/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.swing.SpellCheckedDocument;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

public class SpellEditorKit
extends StyledEditorKit {
    protected static final Cursor linkCursor = Cursor.getPredefinedCursor(12);
    protected Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static SpellDictionary dictionary;

    public SpellEditorKit(File file) {
        SpellDictionaryHashMap spellDictionaryHashMap;
        try {
            spellDictionaryHashMap = new SpellDictionaryHashMap(file);
        }
        catch (Exception exception) {
            spellDictionaryHashMap = null;
        }
        dictionary = spellDictionaryHashMap;
    }

    public void install(JEditorPane jEditorPane) {
        LinkController linkController = new LinkController();
        jEditorPane.addMouseMotionListener(linkController);
        jEditorPane.addMouseListener(linkController);
        super.install(jEditorPane);
        this.defaultCursor = jEditorPane.getCursor();
    }

    public Document createDefaultDocument() {
        return new SpellCheckedDocument(dictionary);
    }

    class ReplaceListener
    implements ActionListener {
        int offset;
        int length;
        Document doc;

        public ReplaceListener(int n, int n2, Document document) {
            this.offset = n;
            this.length = n2;
            this.doc = document;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.doc.remove(this.offset, this.length);
                this.doc.insertString(this.offset, actionEvent.getActionCommand(), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class LinkController
    extends MouseAdapter
    implements MouseMotionListener {
        private Element curElem = null;
        private boolean curElemImage = false;
        private String href = null;
        private Position.Bias[] bias = new Position.Bias[1];
        private int curOffset;
        private int linkoffset = 0;

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (jEditorPane.isEditable() && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0 && this.href != null) {
                SpellCheckedDocument spellCheckedDocument = (SpellCheckedDocument)jEditorPane.getDocument();
                Element element = spellCheckedDocument.getCharacterElement(n);
                try {
                    Object object;
                    String string = spellCheckedDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    List list = dictionary.getSuggestions(string, 5);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ReplaceListener replaceListener = new ReplaceListener(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), spellCheckedDocument);
                    for (int i = 0; i < list.size() && i < 5; ++i) {
                        object = (Word)list.get(i);
                        JMenuItem jMenuItem = new JMenuItem(((Word)object).getWord());
                        jMenuItem.setActionCommand(((Word)object).getWord());
                        jMenuItem.addActionListener(replaceListener);
                        jPopupMenu.add(jMenuItem);
                    }
                    object = new JMenuItem("Add word to wordlist");
                    ((AbstractButton)object).addActionListener(new ActionListener(this, string){
                        private final /* synthetic */ String val$word;
                        private final /* synthetic */ LinkController this$1;
                        {
                            this.this$1 = linkController;
                            this.val$word = string;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            dictionary.addWord(this.val$word);
                        }
                    });
                    jPopupMenu.add((JMenuItem)object);
                    jPopupMenu.show(jEditorPane, mouseEvent.getX(), mouseEvent.getY());
                }
                catch (BadLocationException badLocationException) {
                    System.out.println("" + element.getStartOffset() + " count " + element.getElementCount());
                }
            }
            this.href = null;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = -1;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            boolean bl = true;
            Cursor cursor = SpellEditorKit.this.defaultCursor;
            if (jEditorPane.isEditable()) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                n = jEditorPane.getUI().viewToModel(jEditorPane, point, this.bias);
                if (this.bias[0] == Position.Bias.Backward && n > 0) {
                    --n;
                }
                if (n >= 0 && jEditorPane.getDocument() instanceof SpellCheckedDocument) {
                    SpellCheckedDocument spellCheckedDocument = (SpellCheckedDocument)jEditorPane.getDocument();
                    Element element = spellCheckedDocument.getCharacterElement(n);
                    if (!this.doesElementContainLocation(jEditorPane, element, n, mouseEvent.getX(), mouseEvent.getY())) {
                        element = null;
                    }
                    if (this.curElem != element || this.curElemImage) {
                        this.curElem = element;
                        this.curElemImage = false;
                        if (element != null) {
                            AttributeSet attributeSet = element.getAttributes();
                            if (attributeSet.getAttribute(StyleConstants.NameAttribute) == "errorstyle") {
                                cursor = linkCursor;
                                this.linkoffset = element.getStartOffset();
                                try {
                                    this.href = jEditorPane.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                                }
                                catch (BadLocationException badLocationException) {}
                            } else {
                                this.href = null;
                            }
                        }
                    } else {
                        bl = false;
                    }
                    this.curOffset = n;
                }
            }
            if (bl && jEditorPane.getCursor() != cursor) {
                jEditorPane.setCursor(cursor);
            }
        }

        private boolean doesElementContainLocation(JEditorPane jEditorPane, Element element, int n, int n2, int n3) {
            if (element != null && n > 0 && element.getStartOffset() == n) {
                try {
                    TextUI textUI = jEditorPane.getUI();
                    Rectangle rectangle = textUI.modelToView(jEditorPane, n, Position.Bias.Forward);
                    Rectangle rectangle2 = rectangle instanceof Rectangle ? rectangle : rectangle.getBounds();
                    Rectangle rectangle3 = textUI.modelToView(jEditorPane, element.getEndOffset(), Position.Bias.Backward);
                    Rectangle rectangle4 = rectangle3 instanceof Rectangle ? rectangle3 : rectangle3.getBounds();
                    rectangle2.add(rectangle4);
                    return rectangle2.contains(n2, n3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }
    }
}

