package com.ibm.bsf.engines.javaclass;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;

import com.ibm.bsf.util.MethodUtils;
import com.ibm.bsf.*;
import com.ibm.bsf.util.BSFEngineImpl;

/**
 * This is the interface to scripts consisting of Java objects from the 
 * Bean Scripting Framework. 
 *
 * @author   Sanjiva Weerawarana
 */
public class JavaClassEngine extends BSFEngineImpl {
  /**
   * This is used by an application to evaluate an object containing
   * some expression - clearly not possible for compiled code ..
   */
  public Object eval (String source, int lineNo, int columnNo, 
		      Object oscript) throws BSFException {
    throw new BSFException (BSFException.REASON_UNSUPPORTED_FEATURE,
			    "Java bytecode engine can't evaluate expressions");
  }

  /**
   * call the named method of the given object. If object is an instance
   * of Class, then the call is a static call on that object. If not, its
   * an instance method call or a static call (as per Java) on the given 
   * object.
   */
  public Object call (Object object, String method, Object[] args) 
                                                        throws BSFException {
    // determine arg types
    Class[] argTypes = null;
    if (args != null) {
      argTypes = new Class[args.length];
      for (int i = 0; i < args.length; i++) {
	argTypes[i] = (args[i] != null) ? args[i].getClass () : null;
      }
    }

    // now find method with the right signature, call it and return result
    try {
      Method m = MethodUtils.getMethod (object, method, argTypes);
      return m.invoke (object, args);
    } catch (Exception e) {
      // something went wrong while invoking method
      Throwable t = (e instanceof InvocationTargetException) ?
	            ((InvocationTargetException)e).getTargetException () :
	            null;
      throw new BSFException (BSFException.REASON_OTHER_ERROR,
			      "method invocation failed: " + e +
			      ((t==null)?"":(" target exception: "+t)), t);
    }
  }
}
