/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.DifferenceEnumeration;
import com.icl.saxon.expr.DistinctEnumeration;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterEnumerator;
import com.icl.saxon.expr.IntersectionEnumeration;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.UnionEnumeration;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.exslt.Math;
import com.icl.saxon.functions.Not;
import com.icl.saxon.functions.Round;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.ProcInstParser;
import com.icl.saxon.om.SingletonEnumeration;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.tinytree.TinyBuilder;
import com.icl.saxon.tree.AttributeCollection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class Extensions {
    private static final String[] NODE_TYPE_NAMES = new String[]{"Node", "Element", "Attribute", "Text", "?", "?", "?", "Processing Instruction", "Comment", "Root", "?", "?", "?", "Namespace"};

    public static NodeSetValue nodeSet(Context context, Value value) throws XPathException {
        if (value instanceof NodeSetValue) {
            return (NodeSetValue)value;
        }
        return new TextFragmentValue(value.asString(), "", context.getController());
    }

    public static NodeSetValue nodeset(Context context, Value value) throws XPathException {
        return Extensions.nodeSet(context, value);
    }

    public static String systemId(Context context) throws XPathException {
        return context.getContextNodeInfo().getSystemId();
    }

    public static double lineNumber(Context context) throws XPathException {
        return context.getContextNodeInfo().getLineNumber();
    }

    public static String baseUri(Context context) throws XPathException {
        return context.getContextNodeInfo().getBaseURI();
    }

    public static NodeEnumeration intersection(Context context, NodeEnumeration nodeEnumeration, NodeEnumeration nodeEnumeration2) throws XPathException {
        return new IntersectionEnumeration(nodeEnumeration, nodeEnumeration2, context.getController());
    }

    public static NodeEnumeration difference(Context context, NodeEnumeration nodeEnumeration, NodeEnumeration nodeEnumeration2) throws XPathException {
        return new DifferenceEnumeration(nodeEnumeration, nodeEnumeration2, context.getController());
    }

    public static boolean hasSameNodes(Context context, NodeEnumeration nodeEnumeration, NodeEnumeration nodeEnumeration2) throws XPathException {
        NodeEnumeration nodeEnumeration3 = nodeEnumeration;
        NodeEnumeration nodeEnumeration4 = nodeEnumeration2;
        Controller controller = context.getController();
        if (!nodeEnumeration3.isSorted()) {
            nodeEnumeration3 = new NodeSetExtent(nodeEnumeration3, (NodeOrderComparer)controller).sort().enumerate();
        }
        if (!nodeEnumeration4.isSorted()) {
            nodeEnumeration4 = new NodeSetExtent(nodeEnumeration4, (NodeOrderComparer)controller).sort().enumerate();
        }
        while (nodeEnumeration3.hasMoreElements()) {
            if (!nodeEnumeration4.hasMoreElements()) {
                return false;
            }
            if (nodeEnumeration3.nextElement().isSameNode(nodeEnumeration4.nextElement())) continue;
            return false;
        }
        return !nodeEnumeration4.hasMoreElements();
    }

    public static Value IF(Value value, Value value2, Value value3) throws XPathException {
        return value.asBoolean() ? value2 : value3;
    }

    public static Value evaluate(Context context, String string) throws XPathException {
        StaticContext staticContext = context.getStaticContext().makeRuntimeContext(context.getController().getNamePool());
        Expression expression = Expression.make(string, staticContext);
        return expression.evaluate(context);
    }

    public static Value eval(Context context, Expression expression) throws XPathException {
        return expression.evaluate(context);
    }

    public static Value expression(Context context, String string) throws XPathException {
        StaticContext staticContext = context.getStaticContext().makeRuntimeContext(context.getController().getNamePool());
        Expression expression = Expression.make(string, staticContext);
        Expression expression2 = expression.reduce(1, context).simplify();
        return new ObjectValue(expression2);
    }

    public static double sum(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        double d = 0.0;
        Context context2 = context.newContext();
        NodeEnumeration nodeEnumeration2 = nodeEnumeration instanceof LastPositionFinder ? nodeEnumeration : new LookaheadEnumerator(nodeEnumeration);
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration2));
        int n = 1;
        while (nodeEnumeration2.hasMoreElements()) {
            context2.setContextNode(nodeEnumeration2.nextElement());
            context2.setPosition(n++);
            double d2 = expression.evaluateAsNumber(context2);
            d += d2;
        }
        return d;
    }

    public static double max(NodeEnumeration nodeEnumeration) throws XPathException {
        return Math.max(nodeEnumeration);
    }

    public static double max(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        double d = Double.NEGATIVE_INFINITY;
        Context context2 = context.newContext();
        NodeEnumeration nodeEnumeration2 = nodeEnumeration instanceof LastPositionFinder ? nodeEnumeration : new LookaheadEnumerator(nodeEnumeration);
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration2));
        int n = 1;
        while (nodeEnumeration2.hasMoreElements()) {
            context2.setContextNode(nodeEnumeration2.nextElement());
            context2.setPosition(n++);
            double d2 = expression.evaluateAsNumber(context2);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double min(NodeEnumeration nodeEnumeration) throws XPathException {
        return Math.min(nodeEnumeration);
    }

    public static double min(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        double d = Double.POSITIVE_INFINITY;
        Context context2 = context.newContext();
        NodeEnumeration nodeEnumeration2 = nodeEnumeration instanceof LastPositionFinder ? nodeEnumeration : new LookaheadEnumerator(nodeEnumeration);
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration2));
        int n = 1;
        while (nodeEnumeration2.hasMoreElements()) {
            context2.setContextNode(nodeEnumeration2.nextElement());
            context2.setPosition(n++);
            double d2 = expression.evaluateAsNumber(context2);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static NodeSetValue highest(Context context, NodeEnumeration nodeEnumeration) throws XPathException {
        return Math.highest(context, nodeEnumeration);
    }

    public static NodeEnumeration highest(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        double d = Double.NEGATIVE_INFINITY;
        Context context2 = context.newContext();
        NodeInfo nodeInfo = null;
        NodeEnumeration nodeEnumeration2 = nodeEnumeration instanceof LastPositionFinder ? nodeEnumeration : new LookaheadEnumerator(nodeEnumeration);
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration2));
        int n = 1;
        while (nodeEnumeration2.hasMoreElements()) {
            context2.setContextNode(nodeEnumeration2.nextElement());
            context2.setPosition(n++);
            double d2 = expression.evaluateAsNumber(context2);
            if (!(d2 > d)) continue;
            d = d2;
            nodeInfo = context2.getContextNodeInfo();
        }
        return new SingletonEnumeration(nodeInfo);
    }

    public static NodeSetValue lowest(Context context, NodeEnumeration nodeEnumeration) throws XPathException {
        return Math.lowest(context, nodeEnumeration);
    }

    public static NodeEnumeration lowest(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        double d = Double.POSITIVE_INFINITY;
        Context context2 = context.newContext();
        NodeInfo nodeInfo = null;
        NodeEnumeration nodeEnumeration2 = nodeEnumeration instanceof LastPositionFinder ? nodeEnumeration : new LookaheadEnumerator(nodeEnumeration);
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration2));
        int n = 1;
        while (nodeEnumeration2.hasMoreElements()) {
            context2.setContextNode(nodeEnumeration2.nextElement());
            context2.setPosition(n++);
            double d2 = expression.evaluateAsNumber(context2);
            if (!(d2 < d)) continue;
            d = d2;
            nodeInfo = context2.getContextNodeInfo();
        }
        return new SingletonEnumeration(nodeInfo);
    }

    public static NodeEnumeration distinct(Context context, NodeEnumeration nodeEnumeration) throws XPathException {
        return new DistinctEnumeration(nodeEnumeration, context.getController());
    }

    public static NodeEnumeration distinct(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        return new DistinctEnumeration(context, nodeEnumeration, expression);
    }

    public static NodeEnumeration closure(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        NodeEnumeration nodeEnumeration2 = EmptyEnumeration.getInstance();
        Controller controller = context.getController();
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = nodeEnumeration.nextElement();
            Context context2 = context.newContext();
            context2.setContextNode(nodeInfo);
            context2.setCurrentNode(nodeInfo);
            context2.setPosition(1);
            context2.setLast(1);
            UnionEnumeration unionEnumeration = new UnionEnumeration(new SingletonEnumeration(nodeInfo), Extensions.closure(context2, expression.enumerate(context2, false), expression), controller);
            nodeEnumeration2 = new UnionEnumeration(nodeEnumeration2, unionEnumeration, controller);
        }
        return nodeEnumeration2;
    }

    public static NodeEnumeration leading(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        return new FilterEnumerator(nodeEnumeration, expression, context.newContext(), true);
    }

    public static NodeSetValue before(Context context, NodeSetValue nodeSetValue, NodeSetValue nodeSetValue2) throws XPathException {
        NodeInfo nodeInfo = null;
        NodeEnumeration nodeEnumeration = nodeSetValue2.enumerate();
        while (nodeEnumeration.hasMoreElements()) {
            nodeInfo = nodeEnumeration.nextElement();
        }
        if (nodeInfo == null) {
            return new EmptyNodeSet();
        }
        Controller controller = context.getController();
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        NodeEnumeration nodeEnumeration2 = nodeSetValue.enumerate();
        while (nodeEnumeration2.hasMoreElements()) {
            NodeInfo nodeInfo2 = nodeEnumeration2.nextElement();
            if (controller.compare(nodeInfo2, nodeInfo) >= 0) break;
            vector.addElement(nodeInfo2);
        }
        return new NodeSetExtent(vector, (NodeOrderComparer)controller);
    }

    public static NodeSetValue after(Context context, NodeSetValue nodeSetValue, NodeSetValue nodeSetValue2) throws XPathException {
        NodeInfo nodeInfo = nodeSetValue2.getFirst();
        if (nodeInfo == null) {
            return new EmptyNodeSet();
        }
        Controller controller = context.getController();
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
        boolean bl = false;
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
            if (bl) {
                vector.addElement(nodeInfo2);
                continue;
            }
            if (controller.compare(nodeInfo2, nodeInfo) <= 0) continue;
            bl = true;
            vector.addElement(nodeInfo2);
        }
        return new NodeSetExtent(vector, (NodeOrderComparer)controller);
    }

    public static boolean exists(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        return new FilterEnumerator(nodeEnumeration, expression, context.newContext(), false).hasMoreElements();
    }

    public static boolean forAll(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        Not not = new Not();
        not.addArgument(expression);
        return !new FilterEnumerator(nodeEnumeration, not, context.newContext(), false).hasMoreElements();
    }

    public static NodeEnumeration range(Context context, double d, double d2) throws XPathException {
        int n = (int)Round.round(d);
        int n2 = (int)Round.round(d2);
        try {
            Object object;
            TinyBuilder tinyBuilder = new TinyBuilder();
            NamePool namePool = context.getController().getNamePool();
            int[] nArray = new int[]{namePool.getNamespaceCode("saxon", "http://icl.com/saxon")};
            int n3 = namePool.allocate("saxon", "http://icl.com/saxon", "range");
            tinyBuilder.setNamePool(namePool);
            tinyBuilder.startDocument();
            AttributeCollection attributeCollection = new AttributeCollection(namePool);
            int n4 = n;
            while (n4 <= n2) {
                tinyBuilder.startElement(n3, attributeCollection, nArray, 1);
                object = n4 + "";
                tinyBuilder.characters(((String)object).toCharArray(), 0, ((String)object).length());
                tinyBuilder.endElement(n3);
                ++n4;
            }
            tinyBuilder.endDocument();
            object = tinyBuilder.getCurrentDocument();
            return object.getEnumeration((byte)3, AnyNodeTest.getInstance());
        }
        catch (TransformerException transformerException) {
            throw new XPathException(transformerException);
        }
    }

    public static NodeEnumeration tokenize(Context context, String string) throws XPathException {
        try {
            Object object;
            Builder builder = context.getController().makeBuilder();
            NamePool namePool = context.getController().getNamePool();
            builder.startDocument();
            int[] nArray = new int[]{namePool.getNamespaceCode("saxon", "http://icl.com/saxon")};
            int n = namePool.allocate("saxon", "http://icl.com/saxon", "token");
            AttributeCollection attributeCollection = new AttributeCollection(namePool);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                builder.startElement(n, attributeCollection, nArray, 1);
                object = stringTokenizer.nextToken();
                builder.characters(((String)object).toCharArray(), 0, ((String)object).length());
                builder.endElement(n);
            }
            builder.endDocument();
            object = builder.getCurrentDocument();
            return object.getEnumeration((byte)3, AnyNodeTest.getInstance());
        }
        catch (TransformerException transformerException) {
            throw new XPathException(transformerException);
        }
    }

    public static NodeEnumeration tokenize(Context context, String string, String string2) throws XPathException {
        try {
            Object object;
            Builder builder = context.getController().makeBuilder();
            NamePool namePool = context.getController().getNamePool();
            builder.setNamePool(namePool);
            builder.startDocument();
            int[] nArray = new int[]{namePool.getNamespaceCode("saxon", "http://icl.com/saxon")};
            int n = namePool.allocate("saxon", "http://icl.com/saxon", "token");
            AttributeCollection attributeCollection = new AttributeCollection(namePool);
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                builder.startElement(n, attributeCollection, nArray, 1);
                object = stringTokenizer.nextToken();
                builder.characters(((String)object).toCharArray(), 0, ((String)object).length());
                builder.endElement(n);
            }
            builder.endDocument();
            object = builder.getCurrentDocument();
            return object.getEnumeration((byte)3, AnyNodeTest.getInstance());
        }
        catch (TransformerException transformerException) {
            throw new XPathException(transformerException);
        }
    }

    public static String path(Context context) throws XPathException {
        return Navigator.getPath(context.getContextNodeInfo());
    }

    public static String showNodeset(Context context, NodeSetValue nodeSetValue) throws XPathException {
        System.err.println("Node-set contents at line " + context.getStaticContext().getLineNumber() + " [");
        NodeEnumeration nodeEnumeration = nodeSetValue.enumerate(context, true);
        int n = 0;
        while (nodeEnumeration.hasMoreElements()) {
            ++n;
            NodeInfo nodeInfo = nodeEnumeration.nextElement();
            String string = NODE_TYPE_NAMES[nodeInfo.getNodeType()];
            System.err.println("  " + string + " " + nodeInfo.getDisplayName() + " " + Navigator.getPath(nodeInfo) + " " + nodeInfo.generateId());
        }
        System.err.println("] (Total number of nodes: " + n + ")");
        return "";
    }

    public static boolean isNull(Object object) throws XPathException {
        return object == null;
    }

    public static void setUserData(Context context, String string, Value value) throws XPathException {
        context.getController().setUserData(context.getContextNodeInfo(), string, value);
    }

    public static Value getUserData(Context context, String string) throws XPathException {
        Object object = context.getController().getUserData(context.getContextNodeInfo(), string);
        if (object == null) {
            return new StringValue("");
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        return new ObjectValue(object);
    }

    public static Context getContext(Context context) {
        return context;
    }

    public static String getPseudoAttribute(Context context, String string) {
        NodeInfo nodeInfo = context.getContextNodeInfo();
        if (nodeInfo.getNodeType() != 7) {
            return "";
        }
        String string2 = ProcInstParser.getPseudoAttribute(nodeInfo.getStringValue(), string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }
}

