/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: misc.h,v 1.3 94/05/29 15:27:42 nau Exp $
 */

/* prototypes for misc routines
 */

#ifndef	__MISC_INCLUDED__
#define	__MISC_INCLUDED__

#include <stdlib.h>
#include "global.h"

void		Copyright(void);
void		Usage(void);
void		CatchSignal(int);
Boolean		PointerPosition(Drawable, int *,  int *);
void		SetCursorLine(void);
void		SetStatusLine(void);
void		SetElementnameField(void);
void		SetNameField(void);
void		SetElementInfo(ElementTypePtr, Cardinal);
void		GetMinMaxCoordinates(PCBTypePtr, Position *, Position *, Position *, Position *);
void		CenterDisplay(Position, Position);
void		SetGrid(int);
void		SetZoom(int);
void		SetLineSize(Dimension);
void		SetViaSize(Dimension);
void		SetChangedFlag(Boolean);
char		*StripWhiteSpaceAndDup(char *);
void		SetFontInfo(FontTypePtr);
void		UpdateSettingsOnScreen(void);
void		SetMode(int);
int			ParseGroupString(char *, LayerGroupTypePtr);
void		QuitApplication(void);
void		ContinueBackupAlarm(void);
void		StopBackupAlarm(void);

#endif
