/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: macro.h,v 1.1 94/04/26 20:07:19 nau Exp $
 */

/* some macros
 */

#ifndef	__MACRO_INCLUDED__
#define	__MACRO_INCLUDED__

/* ---------------------------------------------------------------------------
 * rename an object
 */
#define	RENAME(old,new)					\
	{									\
		MyFree(&(old));					\
		if (*(new))						\
			(old) = (new);				\
		else							\
			SaveFree((new));			\
	}

/* ---------------------------------------------------------------------------
 * macros to transform coord systems
 */
#define	TO_SCREEN(x)		((x) >> PCB->Zoom)
#define	TO_PCB(x)			((x) << PCB->Zoom)

/* ---------------------------------------------------------------------------
 * misc macros, some might already be defined by <limits.h>
 */
#ifndef	MIN
#define	MIN(a,b)			((a) < (b) ? (a) : (b))
#define	MAX(a,b)			((a) > (b) ? (a) : (b))
#endif

#define	ENTRIES(x)			(sizeof((x))/sizeof((x)[0]))
#define	UNKNOWN(a)			((a) && *(a) ? (a) : "(unknown)")
#define	EMPTY(a)			((a) ? (a) : "")

/* ---------------------------------------------------------------------------
 * returns pointer to current layer or to n-th element on stack
 */
#define	LAYER_ON_STACK(n)	(&PCB->Layer[LayerStack[(n)]])
#define	CURRENT				(LAYER_ON_STACK(0))

/* ---------------------------------------------------------------------------
 * checks a value for a specified range
 */
#define	OUT_OF_RANGE(val, min, max)	((val) < (min) || (val) > (max))

/* ---------------------------------------------------------------------------
 * some routines for flag setting, clearing, changeing and testing
 */
#define	NOFLAG			0x00
#define	PINFLAG			0x01		/* is a pin */
#define	VIAFLAG			0x02		/* is a via */
#define	FOUNDFLAG		0x04		/* was used by 'FindConnection()' */
#define	MIRRORFLAG		0x08		/* use mirroring for text */
#define	POLYGONFLAG		0x10		/* use polygon lines */
#define	CANONICALFLAG	0x20		/* display canonical element names */

#define	SET_FLAG(f,p)		((p)->Flags |= (f))
#define	CLEAR_FLAG(f,p)		((p)->Flags &= (~(f)))
#define	TEST_FLAG(f,p)		((p)->Flags & (f))
#define	CHANGE_FLAG(f,p)	((p)->Flags = TEST_FLAG((f),(p)) ? (p)->Flags & (~(f)) : (p)->Flags | (f))

#endif

