

/*
 * $Id: ckfa.frag,v 1.6 96/01/09 08:27:22 abe Exp $
 */


/*
 * The caller must define CKFA_EXPDEV and an expdev() macro if stat()
 * buffer device numbers need to be defined.  (This is an EP/IX artifact.)
 *
 * The caller must define CKFA_MPXCHAN to enable the saving of
 * a multiplexed channel number from the path name.  (This is an AIX
 * artifact.)
 *
 * The caller must define the CKFA_XDEVTST macro to implement additional
 * tests that determine which device number, st_dev or st_rdev, to save
 * in the sfile structure.
 */


/*
 * ck_file_arg() - check file arguments
 */

int
ck_file_arg(i, ac, av)
	int i;			/* first file argument index */
	int ac;			/* argument count */
	char *av[];		/* argument vector */
{
	unsigned char ad, an;
	short err = 0;
	char *fnm, *fsnm, *path;
	int ftype, j;
	struct mounts *mp;
	struct stat sb;
	struct sfile *sfp;

#if	defined(CKFA_EXPDEV)
	dev_t dev, rdev;
#endif

#if	defined(HASPROCFS)
	struct procfsid *pfi;
	pid_t pid;
	char *pr;

# if	defined(HASPINFO)
	static int pinfol = -1;
	char *pifo;
	unsigned char type;
# endif
#endif

	for (; i < ac; i++) {
		if ((path = Readlink(av[i])) == NULL) {
			err = 1;
			continue;
		}
	/*
	 * Remove extra terminating `/'.
	 *
	 * Check for file system argument.
	 */
		if ((j = strlen(path)) > 1 && path[j-1] == '/')
			path[j-1] = '\0';
		for (ftype = 1, mp = Mtab; mp; mp = mp->next) {
			if (strcmp(mp->dir, path) == 0) {
				ftype = 0;
				fnm = path;
				fsnm = mp->fsname;
				break;
			}
			if (strcmp(mp->fsname, path) == 0) {
				ftype = 0;
				fnm = mp->dir;
				fsnm = path;
				break;
			}
		}
		if (ftype) {
			fnm = path;
			fsnm = NULL;
		} else {

#if	defined(HASPROCFS)
			if (mp == Mtprocfs) {
				Procsrch = 1;
				continue;
			}
#endif

#if	defined(CKFA_EXPDEV)
			dev = mp->dev;
			rdev = mp->rdev;
#else
			sb.st_dev = mp->dev;
			sb.st_rdev = mp->rdev;
#endif

			sb.st_ino = mp->inode;
			sb.st_mode = mp->mode;

#if	defined(HASFSTYPE)
			(void) strncpy(sb.st_fstype,
				(mp->fstype == NULL) ? "" : mp->fstype,
				sizeof(sb.st_fstype));
			sb.st_fstype[sizeof(sb.st_fstype) - 1] = '\0';
#endif

		}
	/*
	 * Stat the argument to obtain its mode and device.
	 */
		if (ftype && statsafely(fnm, &sb) != 0) {
			(void) fprintf(stderr, "%s: status error on %s: %s\n",
				Pn, fnm, strerror(errno));
			err = 1;
			continue;
		}

#if	defined(CKFA_EXPDEV)
	/*
	 * Expand device numbers before saving, so that they match the
	 * already-expanded Mtab device numbers.  (This is an EP/IX
	 * 2.1.1 and above artifact.)
	 */
		if (ftype) {
			dev = expdev(sb.st_dev);
			rdev = expdev(sb.st_rdev);
		}
#endif

	/*
	 * Allocate an sfile structure and fill in the type, inode,
	 * find-flag and linkages.
	 */
		if ((sfp = (struct sfile *)malloc(sizeof(struct sfile)))
		== NULL) {
			(void) fprintf(stderr, "%s: no space for files\n", Pn);
			exit(1);
		}
		sfp->next = Sfile;
		Sfile = sfp;
		sfp->type = ftype;
		sfp->i = sb.st_ino;
		sfp->f = 0;
	/*
	 * Store the file name and file system name pointers in the sfile
	 * structure, allocating space as necessary.
	 */
		if (fnm == NULL || fnm == path) {
			sfp->name = fnm;
			an = 0;
		} else {
		    if ((sfp->name = (char *)malloc((MALLOC_S)(strlen(fnm)+1)))
		    == NULL) {
			(void) fprintf(stderr,
			    "%s: no space for file name %s\n", Pn, fnm);
			exit(1);
		    }
		    (void) strcpy(sfp->name, fnm);
		    an = 1;
		}
		if (fsnm == NULL || fsnm == path) {
			sfp->devnm = fsnm;
			ad = 0;
		} else {
		    if ((sfp->devnm=(char *)malloc((MALLOC_S)(strlen(fsnm)+1)))
		    == NULL) {
			(void) fprintf(stderr,
			    "%s: no space for file system name %s\n", Pn, fsnm);
			exit(1);
		    }
		    (void) strcpy(sfp->devnm, fsnm);
		    ad = 1;
		}
		if ((sfp->aname = (char *)malloc((MALLOC_S)(strlen(av[i]) + 1)))
		== NULL) {
			(void) fprintf(stderr,
			    "%s: no space for argument file name %s\n",
			    Pn, av[i]);
			exit(1);
		}
		(void) strcpy(sfp->aname, av[i]);
	/*
	 * Save the stat() buffer mode value in the sfile structure.
	 * Use st_rdev if the mode value is S_IFBLK or S_IFCHR; otherwise
	 * use st_dev.
	 */
		sfp->mode = sb.st_mode & S_IFMT;
		if (sfp->mode == S_IFBLK || sfp->mode == S_IFCHR

#if	defined(CKFA_XDEVTST)
		||  CKFA_XDEVTST
#endif
		)

#if	defined(CKFA_EXPDEV)
			sfp->dev = rdev;
		else
			sfp->dev = dev;
#else
			sfp->dev = sb.st_rdev;
		else
			sfp->dev = sb.st_dev;
#endif

#if	defined(CKFA_MPXCHAN)
	/*
	 * Save a (possible) multiplexed channel number.  (This is an AIX
	 * artifact.)
	 */
		sfp->ch = getchan(path);
#endif

#if	defined(HASPROCFS)
	/*
	 * See if this is an individual member of a proc file system.
	 */
		if (Mtprocfs == NULL || Procsrch)
			continue;
		if (strcmp(sb.st_fstype, HASPROCFS) != 0)
			continue;

# if	defined(HASPINFO)
	
	/*
	 * Look for a HASPINFO subdirectory.
	 */
		if (pinfol < 0)
			pinfol = strlen(HASPINFO);
		for (pr = strchr(path + 1, '/'), pifo = NULL, type = 0;
		     pr;
		     pifo = pr, pr = strchr(pr + 1, '/'))
		{
			if (strncmp(pr, HASPINFO, pinfol) == 0) {
				pifo = pr + pinfol;
				if (*pifo && *pifo != '/')
					continue;
				type = 1;
				break;
			}
		}
		if (pifo == NULL)
			continue;
		if (*pifo == '/')
			pifo++;
		if (type == 1 && *pifo == '\0') {
			pid = 0;
			type = 2;
		} else {
			if (strlen(pifo) != PNSIZ)
				continue;
			pid = (pid_t)atoi(pifo);
			if (type == 0 && pid == 0)
				continue;
		}
# else	/* !HASPINFO */
		if ((pr = strrchr(path, '/')) == NULL)
			continue;
		if ((pid = (pid_t)atoi(pr + 1)) == 0)
			continue;
# endif	/* HASPINFO */

		if ((pfi = (struct procfsid *)malloc((MALLOC_S)
			sizeof(struct procfsid)))
		== NULL) {
			(void) fprintf(stderr,
				"%s: no space for %s ID: %s\n", Pn,
					HASPROCFS, path);
			exit(1);
		}
		pfi->pid = pid;
		pfi->next = Procfsid;

# if	defined(HASPINFO)
		pfi->type = type;
# endif

		Procfsid = pfi;
	/*
	 * Abandon the Sfile entry, lest it be used in is_file_named().
	 */
		Sfile = sfp->next;
		(void) free((FREE_P *)sfp->aname);
		if (ad)
			(void) free((FREE_P *)sfp->devnm);
		if (an)
			(void) free((FREE_P *)sfp->name);
		(void) free((FREE_P *)sfp);
#endif	/* HASPROCFS */

	}
	return((int)err);
}
