[
  [
    "https://ephraim.tu-berlin.de/shibboleth", 
    {
      "entity_id": "https://ephraim.tu-berlin.de/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/ephraim.tu-berlin.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.tubit.tu-berlin.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "tu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.tubit.tu-berlin.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "tu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.tubit.tu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.tubit.tu-berlin.de,OU=tubIT,O=Technische Universitaet Berlin,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMzCCBBugAwIBAgIEDied9zANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeVGVjaG5pc2NoZSBVbml2ZXJzaXRhZXQgQmVybGluMQ8wDQYD\nVQQDEwZUVUItQ0ExHjAcBgkqhkiG9w0BCQEWD2NhQFRVLUJlcmxpbi5ERTAeFw0w\nOTA1MTExMjU2MDhaFw0xNDA1MTAxMjU2MDhaMIGQMQswCQYDVQQGEwJERTEPMA0G\nA1UECBMGQmVybGluMQ8wDQYDVQQHEwZCZXJsaW4xJzAlBgNVBAoTHlRlY2huaXNj\naGUgVW5pdmVyc2l0YWV0IEJlcmxpbjEOMAwGA1UECxMFdHViSVQxJjAkBgNVBAMT\nHXNoaWJib2xldGgudHViaXQudHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEA3qUvqkY4p+iLKlQ33hRjbJWVMsJh7Qk7+dbJcbS+X269\nfnOt0pJKGybCHzpGN6bSPixm+pteRQ/ZfdSo7+3Th0YDBstBapNGkw61rnQpOOxm\nds3hH4yooAOYbf3pGaE1Rm8aCwq9cDODLwtujd/qgCChVL1k+pFHtHhov0M98AZ2\nQF1IM9+sYWSttbcTJ8TnE4oQH6MUftHiE6TNtEfKWOkgx8BK1XP3OGEd0qBYAuGl\npwMC6ublvAMSTg46rLxP04x73MbsXY9gGpaszUBRjJKKIC4Cdo+JndIgx+CTN9r5\nVVXnjOV5ryhSTD7rT7koyzaBkgLWtURysx3p/j4xLwIDAQABo4IBuzCCAbcwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBPAwEwYDVR0lBAwwCgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKurFzJOpMsyIAwwO3BAbZxryLf6MB8GA1UdIwQYMBaAFCMyQp7+YkJO+07Q\nF5t45+2KjD54MCEGA1UdEQQaMBiBFmlkbUB0dWJpdC50dS1iZXJsaW4uZGUwgYMG\nA1UdHwR8MHowO6A5oDeGNWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVybGlu\nLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDugOaA3hjVodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL3R1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDCBngYIKwYBBQUHAQEE\ngZEwgY4wRQYIKwYBBQUHMAKGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtYmVy\nbGluLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBFBggrBgEFBQcwAoY5aHR0cDov\nL2NkcDIucGNhLmRmbi5kZS90dS1iZXJsaW4tY2EvcHViL2NhY2VydC9jYWNlcnQu\nY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAwzxECaQ3fX5bZPlaszbbLGAodZW2VkUS8\ncyOASU1zQW0wArj4MolDZ+LZnEBCEVQwTD4bFlcQDIVeqeSbuDNXcnYtC9DKhdjQ\nyor//cu1WZ6zcUa+2NYjNMcCAj0qM1fraYaM3hPTCGREL/BjjKeENgduAmWKQeRM\n3X7Hw1sTK0Y0IfQVNsORi8H7bZDbtTKOR1eYIWRndHbNtKuRgEIG4Ud2FMjl+iX6\ntSNMelecSxtYYjrOFp4SiZDG5LCjEVoRSPwhBAOV+iMOAjqlGA4L+cqDyrWRKYb4\nsXWbU7+qrckzBNerB/L9cym1gAeK1LvL7WG3LhHY9AywW34Ewwe7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Berlin (Technische Universit\u00e4t)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Technische Universit\u00e4t Berlin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.tu-berlin.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Gerd", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "schering@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schering", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Gerd", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "schering@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schering", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Thomas", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gepard@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Gebhardt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Thomas", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gepard@tubit.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Gebhardt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "tubit-", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tubit-shibbolethsupport@lists.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "shibbolethsupport", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "tubit-", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tubit-shibbolethsupport@lists.tu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "shibbolethsupport", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://ticket.iop.org/shibboleth", 
    {
      "entity_id": "https://ticket.iop.org/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/ticket.iop.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "IOP online services", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "IOP online services", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.iop.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Peter", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "peter.haworth@iop.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Haworth", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Matt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "matthew.keen@iop.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Keen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Keith", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "keith.jones@iop.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Jones", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ticket.iop.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rdcdev.ticket.iop.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "11", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "12", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.ticket.iop.org/Shibboleth.sso/SAML2/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ticket.iop.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ticket.iop.org,OU=Member\\, VeriSign Trust Network,OU=Authenticated by VeriSign,OU=Terms of use at www.verisign.co.uk/rpa (c)05,O=IOP Publishing Ltd,L=Bristol,ST=Avon,C=GB", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIQRs9QFKCMIHlnWILL+H/kMjANBgkqhkiG9w0BAQUFADCB\ntTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2Ug\nYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykxMDEvMC0GA1UEAxMm\nVmVyaVNpZ24gQ2xhc3MgMyBTZWN1cmUgU2VydmVyIENBIC0gRzMwHhcNMTEwMzA5\nMDAwMDAwWhcNMTIwNDA2MjM1OTU5WjCB6DELMAkGA1UEBhMCR0IxDTALBgNVBAgT\nBEF2b24xEDAOBgNVBAcUB0JyaXN0b2wxGzAZBgNVBAoUEklPUCBQdWJsaXNoaW5n\nIEx0ZDE1MDMGA1UECxQsVGVybXMgb2YgdXNlIGF0IHd3dy52ZXJpc2lnbi5jby51\nay9ycGEgKGMpMDUxIjAgBgNVBAsTGUF1dGhlbnRpY2F0ZWQgYnkgVmVyaVNpZ24x\nJzAlBgNVBAsTHk1lbWJlciwgVmVyaVNpZ24gVHJ1c3QgTmV0d29yazEXMBUGA1UE\nAxQOdGlja2V0LmlvcC5vcmcwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAK0k\nvYlzSH7vvdi1wquPhBap5XOkZbXSTzxFauceC62qdw2xOwCJW+N8VPliT2bF0+Ic\nuqBRWXRoF7+z5aJWf7Zrq4XjxlJVd0TkiNGSXRY7IA7c2ciNPS8YP+iVrjoHcO0N\n9JFZkfuqnFdajf6exlCe0ZpW9Q/i9QUBglS8oeQhAgMBAAGjggHTMIIBzzAJBgNV\nHRMEAjAAMAsGA1UdDwQEAwIFoDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vU1ZS\nU2VjdXJlLUczLWNybC52ZXJpc2lnbi5jb20vU1ZSU2VjdXJlRzMuY3JsMEYGA1Ud\nIAQ/MD0wOwYLYIZIAYb4RQEHFwMwLDAqBggrBgEFBQcCARYeaHR0cHM6Ly93d3cu\ndmVyaXNpZ24uY28udWsvcnBhMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcD\nAjAfBgNVHSMEGDAWgBQNRFwWU0TBgn4dIKsl9AFj2L55pTB2BggrBgEFBQcBAQRq\nMGgwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTBABggrBgEF\nBQcwAoY0aHR0cDovL1NWUlNlY3VyZS1HMy1haWEudmVyaXNpZ24uY29tL1NWUlNl\nY3VyZUczLmNlcjBuBggrBgEFBQcBDARiMGChXqBcMFowWDBWFglpbWFnZS9naWYw\nITAfMAcGBSsOAwIaBBRLa7kolgYMu9BSOJsprEsHiyEFGDAmFiRodHRwOi8vbG9n\nby52ZXJpc2lnbi5jb20vdnNsb2dvMS5naWYwDQYJKoZIhvcNAQEFBQADggEBABp/\nvWyJLNePxfNv1kLP9w2F5O6vpJr/y4NuH/Wv5LpJinN9KZ6Jht7zC2g7VaGvA75+\nbb95cQ43uJ8KpOMmsaQ4vapwAZLxW/twUMUh2qbUmlmBnkKBPNZxzCRcNmhKOAfe\nngqzUjEo/eZpsFfuvg9d/9L1od5kDfGFr4OFeN+Tin7zHoKbRv129NyIwLhaSixA\nt7LgIqlDQ4PRHCg0YWsE1CBSzSy+nWgDmWjcRIYeFoXve+wpsup3gtoBcxSKp6R5\nZo/W8ldI1Yak/Rkmn/73b1cGG0uqRDWfOHiswnes/xjDIQS9qqJRlNFHd9jkHxwb\nNy/fu2lNRrmtoPmTctI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ticket.iop.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ticket.iop.org,OU=Member\\, VeriSign Trust Network,OU=Authenticated by VeriSign,OU=Terms of use at www.verisign.co.uk/rpa (c)05,O=IOP Publishing Ltd,L=Bristol,ST=Avon,C=GB", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIQRs9QFKCMIHlnWILL+H/kMjANBgkqhkiG9w0BAQUFADCB\ntTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2Ug\nYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykxMDEvMC0GA1UEAxMm\nVmVyaVNpZ24gQ2xhc3MgMyBTZWN1cmUgU2VydmVyIENBIC0gRzMwHhcNMTEwMzA5\nMDAwMDAwWhcNMTIwNDA2MjM1OTU5WjCB6DELMAkGA1UEBhMCR0IxDTALBgNVBAgT\nBEF2b24xEDAOBgNVBAcUB0JyaXN0b2wxGzAZBgNVBAoUEklPUCBQdWJsaXNoaW5n\nIEx0ZDE1MDMGA1UECxQsVGVybXMgb2YgdXNlIGF0IHd3dy52ZXJpc2lnbi5jby51\nay9ycGEgKGMpMDUxIjAgBgNVBAsTGUF1dGhlbnRpY2F0ZWQgYnkgVmVyaVNpZ24x\nJzAlBgNVBAsTHk1lbWJlciwgVmVyaVNpZ24gVHJ1c3QgTmV0d29yazEXMBUGA1UE\nAxQOdGlja2V0LmlvcC5vcmcwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAK0k\nvYlzSH7vvdi1wquPhBap5XOkZbXSTzxFauceC62qdw2xOwCJW+N8VPliT2bF0+Ic\nuqBRWXRoF7+z5aJWf7Zrq4XjxlJVd0TkiNGSXRY7IA7c2ciNPS8YP+iVrjoHcO0N\n9JFZkfuqnFdajf6exlCe0ZpW9Q/i9QUBglS8oeQhAgMBAAGjggHTMIIBzzAJBgNV\nHRMEAjAAMAsGA1UdDwQEAwIFoDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vU1ZS\nU2VjdXJlLUczLWNybC52ZXJpc2lnbi5jb20vU1ZSU2VjdXJlRzMuY3JsMEYGA1Ud\nIAQ/MD0wOwYLYIZIAYb4RQEHFwMwLDAqBggrBgEFBQcCARYeaHR0cHM6Ly93d3cu\ndmVyaXNpZ24uY28udWsvcnBhMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcD\nAjAfBgNVHSMEGDAWgBQNRFwWU0TBgn4dIKsl9AFj2L55pTB2BggrBgEFBQcBAQRq\nMGgwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTBABggrBgEF\nBQcwAoY0aHR0cDovL1NWUlNlY3VyZS1HMy1haWEudmVyaXNpZ24uY29tL1NWUlNl\nY3VyZUczLmNlcjBuBggrBgEFBQcBDARiMGChXqBcMFowWDBWFglpbWFnZS9naWYw\nITAfMAcGBSsOAwIaBBRLa7kolgYMu9BSOJsprEsHiyEFGDAmFiRodHRwOi8vbG9n\nby52ZXJpc2lnbi5jb20vdnNsb2dvMS5naWYwDQYJKoZIhvcNAQEFBQADggEBABp/\nvWyJLNePxfNv1kLP9w2F5O6vpJr/y4NuH/Wv5LpJinN9KZ6Jht7zC2g7VaGvA75+\nbb95cQ43uJ8KpOMmsaQ4vapwAZLxW/twUMUh2qbUmlmBnkKBPNZxzCRcNmhKOAfe\nngqzUjEo/eZpsFfuvg9d/9L1od5kDfGFr4OFeN+Tin7zHoKbRv129NyIwLhaSixA\nt7LgIqlDQ4PRHCg0YWsE1CBSzSy+nWgDmWjcRIYeFoXve+wpsup3gtoBcxSKp6R5\nZo/W8ldI1Yak/Rkmn/73b1cGG0uqRDWfOHiswnes/xjDIQS9qqJRlNFHd9jkHxwb\nNy/fu2lNRrmtoPmTctI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://gidp.geant.net/sp/module.php/saml/sp/metadata.php/default-sp", 
    {
      "entity_id": "https://gidp.geant.net/sp/module.php/saml/sp/metadata.php/default-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/gidp.geant.net-sp.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "GEANT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "GEANT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.geant.net", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "edugain-ot@geant.net", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml2-logout.php/default-sp"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml1-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gidp.geant.net/sp/module.php/saml/sp/saml1-acs.php/default-sp/artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFUzCCBDugAwIBAgIRAOipFX0RJIRenc077AEf/TMwDQYJKoZIhvcNAQEFBQAwNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5BIFNTTCBDQTAeFw0xMDEyMjIwMDAwMDBaFw0xMzEyMjEyMzU5NTlaMIHwMRswGQYDVQQDExJ3d3cuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDIuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDEuZ2lkcC5nZWFudC5uZXQxCzAJBgNVBAYTAkdCMRcwFQYDVQQIEw5DYW1icmlkZ2VzaGlyZTESMBAGA1UEBxMJQ2FtYnJpZGdlMUIwQAYDVQQKEzlEZWxpdmVyeSBvZiBBZHZhbmNlZCBOZXR3b3JrIFRlY2hub2xvZ3kgdG8gRXVyb3BlIExpbWl0ZWQxFzAVBgNVBAMTDmdpZHAuZ2VhbnQubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxshl/HoJhaoNUgaZ8HTIexsHKN2r7Lee0f+k04Jxnmo6o5OauxOpM0991B1xt+5FyXobgNjQSIcKKEvLwaTH7HYYI9bWvfHfVXaYzPOLySPKo+c3Tldbfq0NUXo18ZWuRadEaY+waChcnlkP7yq3ZPxva4aWUvA4iCqpjbZGpMYoJvWhrHua982mBOq29j2+1VwRpBFaverOb2f4jenhlnxstvF6KUSm6B6Y1XUfwJMjAEXxXdai7RodznXV8pCoJMGyn2GN7ClGCq6qHqtSerxdymGHNVpR7pXZ1tF/mI7JIsF+NFErmZJcW79pl7m5ZoZNR+SIDexdg1/IydduGwIDAQABo4IBnzCCAZswHwYDVR0jBBgwFoAUDL2TaAzz3qujSWsrN1dH6pDjue0wHQYDVR0OBBYEFArEHsfdZvlpOxPguP9/En90/NMgMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAYBgNVHSAEETAPMA0GCysGAQQBsjEBAgIdMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMFcGA1UdEQRQME6CDmdpZHAuZ2VhbnQubmV0ghNpZHAxLmdpZHAuZ2VhbnQubmV0ghNpZHAyLmdpZHAuZ2VhbnQubmV0ghJ3d3cuZ2lkcC5nZWFudC5uZXQwDQYJKoZIhvcNAQEFBQADggEBAH56nltzImiMVOv5DJxcTo2cpGBWPO+OI7S1Ns76cS6PzWbkm/zjPPZI871Pfgw6n3Q3V3Kpc48hRyx3WPH/9nk+YnFEUjkjaRCzeWR6A2oYSb83iI2n/33+E2AmyZ1FX5E1nfxRtSBLYyHPdXYQ6A/TN4qtm/9QHrbcISPEQJwvJn4/BOQDrvsjZDJeq7Srrr2An//RpNdC9cA4wU+m0oJPbPHGl32ENO6JVK7gJPYw2WBDER1SMwAEThtUthQyZhp1z6jA/hoeHfM4QR2/mT458LpRXs1c5VGAeC+4pjfJ4skXAU17Nq+ut8+fJMjjQSXOpv10kS2jNq2XfPmN+K4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIFUzCCBDugAwIBAgIRAOipFX0RJIRenc077AEf/TMwDQYJKoZIhvcNAQEFBQAwNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5BIFNTTCBDQTAeFw0xMDEyMjIwMDAwMDBaFw0xMzEyMjEyMzU5NTlaMIHwMRswGQYDVQQDExJ3d3cuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDIuZ2lkcC5nZWFudC5uZXQxHDAaBgNVBAMTE2lkcDEuZ2lkcC5nZWFudC5uZXQxCzAJBgNVBAYTAkdCMRcwFQYDVQQIEw5DYW1icmlkZ2VzaGlyZTESMBAGA1UEBxMJQ2FtYnJpZGdlMUIwQAYDVQQKEzlEZWxpdmVyeSBvZiBBZHZhbmNlZCBOZXR3b3JrIFRlY2hub2xvZ3kgdG8gRXVyb3BlIExpbWl0ZWQxFzAVBgNVBAMTDmdpZHAuZ2VhbnQubmV0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxshl/HoJhaoNUgaZ8HTIexsHKN2r7Lee0f+k04Jxnmo6o5OauxOpM0991B1xt+5FyXobgNjQSIcKKEvLwaTH7HYYI9bWvfHfVXaYzPOLySPKo+c3Tldbfq0NUXo18ZWuRadEaY+waChcnlkP7yq3ZPxva4aWUvA4iCqpjbZGpMYoJvWhrHua982mBOq29j2+1VwRpBFaverOb2f4jenhlnxstvF6KUSm6B6Y1XUfwJMjAEXxXdai7RodznXV8pCoJMGyn2GN7ClGCq6qHqtSerxdymGHNVpR7pXZ1tF/mI7JIsF+NFErmZJcW79pl7m5ZoZNR+SIDexdg1/IydduGwIDAQABo4IBnzCCAZswHwYDVR0jBBgwFoAUDL2TaAzz3qujSWsrN1dH6pDjue0wHQYDVR0OBBYEFArEHsfdZvlpOxPguP9/En90/NMgMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAYBgNVHSAEETAPMA0GCysGAQQBsjEBAgIdMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMFcGA1UdEQRQME6CDmdpZHAuZ2VhbnQubmV0ghNpZHAxLmdpZHAuZ2VhbnQubmV0ghNpZHAyLmdpZHAuZ2VhbnQubmV0ghJ3d3cuZ2lkcC5nZWFudC5uZXQwDQYJKoZIhvcNAQEFBQADggEBAH56nltzImiMVOv5DJxcTo2cpGBWPO+OI7S1Ns76cS6PzWbkm/zjPPZI871Pfgw6n3Q3V3Kpc48hRyx3WPH/9nk+YnFEUjkjaRCzeWR6A2oYSb83iI2n/33+E2AmyZ1FX5E1nfxRtSBLYyHPdXYQ6A/TN4qtm/9QHrbcISPEQJwvJn4/BOQDrvsjZDJeq7Srrr2An//RpNdC9cA4wU+m0oJPbPHGl32ENO6JVK7gJPYw2WBDER1SMwAEThtUthQyZhp1z6jA/hoeHfM4QR2/mT458LpRXs1c5VGAeC+4pjfJ4skXAU17Nq+ut8+fJMjjQSXOpv10kS2jNq2XfPmN+K4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "email", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonScopedAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "commonName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "schacHomeOrganization", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.9"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "schacHomeOrganizationType", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "GEANT SP Proxy", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://www.jwatch.org/shibboleth", 
    {
      "entity_id": "https://www.jwatch.org/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.jwatch.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Journal Watch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Journal Watch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.jwatch.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ryan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibboleth-admin@highwire.stanford.edu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Krebs", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.highwire.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.highwire.org", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDOjCCAiKgAwIBAgIBADANBgkqhkiG9w0BAQQFADAiMSAwHgYDVQQDExdzaGli\nYm9sZXRoLmhpZ2h3aXJlLm9yZzAeFw0xMTA1MjMyMzIwNTVaFw0xNDA1MjIyMzIw\nNTVaMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGlnaHdpcmUub3JnMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwPqatbaGYPuGmKF9zuEEmyun2/v2UMRB\n2zWg0l6T5Evy9vHSwmPqmhZF62oIdm1IWNjZNbl5JhXCLOJPNtVRnnqxbGfdJLWF\nJoAnY6ZuU3jNiO4Ocu+G1K0Dn6AA3nWvgV99wQvWZmrQaMSoQUm3T9avPPr8xgIs\nGLM4DmMtxVbx2q9muUkV8dafX26lIBZuHtlW2cdnEtf/Ezm5+us9xtz0XKzdgaoL\nEV3i4e47w7Mdpms2M6+JGyk0KwcsYmZLf5LFnWgI/5JMAv+mUZEKNoQFHH1qNiLj\n8HO3cl5KFCUbhpdTKq6EU3DBz1shcxQUG7sykXtdhLefP6iVf9kfKQIDAQABo3sw\neTAdBgNVHQ4EFgQU/YLrmdITx8wbuLe37oAx96MP0bwwSgYDVR0jBEMwQYAU/YLr\nmdITx8wbuLe37oAx96MP0byhJqQkMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGln\naHdpcmUub3JnggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQADggEBAGwG\ngkjqlP/+vS8djbKbENIVbKJfqsGM1inuvxERJpwTXoASXTJIpMds1/N16j3s1P1j\n5+UHIdD29vMyukXjLqYY0rd3/xPJ1Sm+w1mnLBgfdE0YMVlQ/zN4ZoyEIzUDA+XS\nf6chvj10tDpE5V3rxLHli6GEo0n848TU2jy5Q0dpmUgtRsn691OviUWNrgGBkaC4\nBbMczrg56rOzqdmn5SIhPt+RzRVn0gnM4eoAThpHg9jLt5SvhNChqOwnY+PByLbB\nY4UozdQzsttgTsqCAAhNXTQQq71Hxvnanm0ak3RKkPQW/tSFsdjiTWDGp2z2djDP\n+d1ZBewNsC/cUy447ok=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.highwire.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.highwire.org", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDOjCCAiKgAwIBAgIBADANBgkqhkiG9w0BAQQFADAiMSAwHgYDVQQDExdzaGli\nYm9sZXRoLmhpZ2h3aXJlLm9yZzAeFw0xMTA1MjMyMzIwNTVaFw0xNDA1MjIyMzIw\nNTVaMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGlnaHdpcmUub3JnMIIBIjANBgkq\nhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwPqatbaGYPuGmKF9zuEEmyun2/v2UMRB\n2zWg0l6T5Evy9vHSwmPqmhZF62oIdm1IWNjZNbl5JhXCLOJPNtVRnnqxbGfdJLWF\nJoAnY6ZuU3jNiO4Ocu+G1K0Dn6AA3nWvgV99wQvWZmrQaMSoQUm3T9avPPr8xgIs\nGLM4DmMtxVbx2q9muUkV8dafX26lIBZuHtlW2cdnEtf/Ezm5+us9xtz0XKzdgaoL\nEV3i4e47w7Mdpms2M6+JGyk0KwcsYmZLf5LFnWgI/5JMAv+mUZEKNoQFHH1qNiLj\n8HO3cl5KFCUbhpdTKq6EU3DBz1shcxQUG7sykXtdhLefP6iVf9kfKQIDAQABo3sw\neTAdBgNVHQ4EFgQU/YLrmdITx8wbuLe37oAx96MP0bwwSgYDVR0jBEMwQYAU/YLr\nmdITx8wbuLe37oAx96MP0byhJqQkMCIxIDAeBgNVBAMTF3NoaWJib2xldGguaGln\naHdpcmUub3JnggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEEBQADggEBAGwG\ngkjqlP/+vS8djbKbENIVbKJfqsGM1inuvxERJpwTXoASXTJIpMds1/N16j3s1P1j\n5+UHIdD29vMyukXjLqYY0rd3/xPJ1Sm+w1mnLBgfdE0YMVlQ/zN4ZoyEIzUDA+XS\nf6chvj10tDpE5V3rxLHli6GEo0n848TU2jy5Q0dpmUgtRsn691OviUWNrgGBkaC4\nBbMczrg56rOzqdmn5SIhPt+RzRVn0gnM4eoAThpHg9jLt5SvhNChqOwnY+PByLbB\nY4UozdQzsttgTsqCAAhNXTQQq71Hxvnanm0ak3RKkPQW/tSFsdjiTWDGp2z2djDP\n+d1ZBewNsC/cUy447ok=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shibboleth.highwire.org/applications/jnlwatch/Shibboleth.sso/SAML2/POST"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://idp.ph-freiburg.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.ph-freiburg.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.ph-freiburg.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ph-freiburg.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ph-freiburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ph-freiburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ph-freiburg.de,O=Paedagogische Hochschule Freiburg,L=Freiburg,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFYDCCBEigAwIBAgIED0XYvTANBgkqhkiG9w0BAQUFADCBrTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIRnJlaWJ1\ncmcxKjAoBgNVBAoTIVBhZWRhZ29naXNjaGUgSG9jaHNjaHVsZSBGcmVpYnVyZzEM\nMAoGA1UECxMDWklLMREwDwYDVQQDEwhQSC1GUiBDQTEhMB8GCSqGSIb3DQEJARYS\ncGtpQHBoLWZyZWlidXJnLmRlMB4XDTA5MTIxNDE1MzUxMFoXDTE0MTIxMzE1MzUx\nMFowgYYxCzAJBgNVBAYTAkRFMRswGQYDVQQIExJCYWRlbi1XdWVydHRlbWJlcmcx\nETAPBgNVBAcTCEZyZWlidXJnMSowKAYDVQQKEyFQYWVkYWdvZ2lzY2hlIEhvY2hz\nY2h1bGUgRnJlaWJ1cmcxGzAZBgNVBAMTEmlkcC5waC1mcmVpYnVyZy5kZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM828KxElHwjl/c6j9CG8AFT+y7J\n4w4yw0qc9Up8zZtzQPuJa+xaG3D3vDcfYB12i2mqdsOrB2ONYUSBgq29myZ6h1kx\nSqQTuOS0Ms+L6xH40XYkApDq76knlDgSzVWy3rnoT539QXLwyo5lMjqqo+/1a5hV\nKP3fygx0BRO45IGgfgvvjSHvEuxWOSTFYSFawj1QhZj1Kdr5LORt1BhG02QADVnA\nj4cTA3gv9O/MN9MnViBM4Vmp4pIUi7SgcwGLxAQcDgoaA4LADU2PF2qsoKCdJOv9\nW4LKtLLqv8rrLajinD/F6rFfbF0Y0MkiE/wQKHY6+DE2LbP5EZwSc8vj5a8CAwEA\nAaOCAaswggGnMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsG\nAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUbBM+NKAEus52mOzdt5CcTaSKs8Qw\nHwYDVR0jBBgwFoAUcc1Tb+nFrN3ri2RPPjhAO2OMRaIwgYgGA1UdHwSBgDB+MD2g\nO6A5hjdodHRwOi8vY2RwMS5wY2EuZGZuLmRlL3BoLWZyZWlidXJnLWNhL3B1Yi9j\ncmwvY2FjcmwuY3JsMD2gO6A5hjdodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3BoLWZy\nZWlidXJnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMIGiBggrBgEFBQcBAQSBlTCBkjBH\nBggrBgEFBQcwAoY7aHR0cDovL2NkcDEucGNhLmRmbi5kZS9waC1mcmVpYnVyZy1j\nYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRwYIKwYBBQUHMAKGO2h0dHA6Ly9jZHAy\nLnBjYS5kZm4uZGUvcGgtZnJlaWJ1cmctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0\nMA0GCSqGSIb3DQEBBQUAA4IBAQB50CER7ZpXfLAHmrAOUCQXWTDAYWmRCx+kuM93\nLmsV51v9wj3ABXW6gTYf5/uBOqepakXVh6F4UDrOMudsyANOGVAyjKKGsf9O80y2\nRcB44enObtzulPJruBlTjuDeJa0JMG2fktq/G24OQ0EbsE/iU7Bjzi/bhBJ8PZ/Q\n+C2L4u2g+MzuP715KXq0TvF1WrqU6E4SlNo57GGwOTEcc236ldrWkA7E2c27x0Gr\nACQ2fRteTKA1w2KTSEDlL+tI4L0fj4Vs/6utxsFGQKsLlZh3XYJV6UN+LWuuV4Ld\nskKvylp9V9RQYU0paW2EUEcSWQ4LqNBNFBfyMYd0FkhipnTt", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ph-freiburg.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ph-freiburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ph-freiburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ph-freiburg.de,O=Paedagogische Hochschule Freiburg,L=Freiburg,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFYDCCBEigAwIBAgIED0XYvTANBgkqhkiG9w0BAQUFADCBrTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIRnJlaWJ1\ncmcxKjAoBgNVBAoTIVBhZWRhZ29naXNjaGUgSG9jaHNjaHVsZSBGcmVpYnVyZzEM\nMAoGA1UECxMDWklLMREwDwYDVQQDEwhQSC1GUiBDQTEhMB8GCSqGSIb3DQEJARYS\ncGtpQHBoLWZyZWlidXJnLmRlMB4XDTA5MTIxNDE1MzUxMFoXDTE0MTIxMzE1MzUx\nMFowgYYxCzAJBgNVBAYTAkRFMRswGQYDVQQIExJCYWRlbi1XdWVydHRlbWJlcmcx\nETAPBgNVBAcTCEZyZWlidXJnMSowKAYDVQQKEyFQYWVkYWdvZ2lzY2hlIEhvY2hz\nY2h1bGUgRnJlaWJ1cmcxGzAZBgNVBAMTEmlkcC5waC1mcmVpYnVyZy5kZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM828KxElHwjl/c6j9CG8AFT+y7J\n4w4yw0qc9Up8zZtzQPuJa+xaG3D3vDcfYB12i2mqdsOrB2ONYUSBgq29myZ6h1kx\nSqQTuOS0Ms+L6xH40XYkApDq76knlDgSzVWy3rnoT539QXLwyo5lMjqqo+/1a5hV\nKP3fygx0BRO45IGgfgvvjSHvEuxWOSTFYSFawj1QhZj1Kdr5LORt1BhG02QADVnA\nj4cTA3gv9O/MN9MnViBM4Vmp4pIUi7SgcwGLxAQcDgoaA4LADU2PF2qsoKCdJOv9\nW4LKtLLqv8rrLajinD/F6rFfbF0Y0MkiE/wQKHY6+DE2LbP5EZwSc8vj5a8CAwEA\nAaOCAaswggGnMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsG\nAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUbBM+NKAEus52mOzdt5CcTaSKs8Qw\nHwYDVR0jBBgwFoAUcc1Tb+nFrN3ri2RPPjhAO2OMRaIwgYgGA1UdHwSBgDB+MD2g\nO6A5hjdodHRwOi8vY2RwMS5wY2EuZGZuLmRlL3BoLWZyZWlidXJnLWNhL3B1Yi9j\ncmwvY2FjcmwuY3JsMD2gO6A5hjdodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3BoLWZy\nZWlidXJnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMIGiBggrBgEFBQcBAQSBlTCBkjBH\nBggrBgEFBQcwAoY7aHR0cDovL2NkcDEucGNhLmRmbi5kZS9waC1mcmVpYnVyZy1j\nYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRwYIKwYBBQUHMAKGO2h0dHA6Ly9jZHAy\nLnBjYS5kZm4uZGUvcGgtZnJlaWJ1cmctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0\nMA0GCSqGSIb3DQEBBQUAA4IBAQB50CER7ZpXfLAHmrAOUCQXWTDAYWmRCx+kuM93\nLmsV51v9wj3ABXW6gTYf5/uBOqepakXVh6F4UDrOMudsyANOGVAyjKKGsf9O80y2\nRcB44enObtzulPJruBlTjuDeJa0JMG2fktq/G24OQ0EbsE/iU7Bjzi/bhBJ8PZ/Q\n+C2L4u2g+MzuP715KXq0TvF1WrqU6E4SlNo57GGwOTEcc236ldrWkA7E2c27x0Gr\nACQ2fRteTKA1w2KTSEDlL+tI4L0fj4Vs/6utxsFGQKsLlZh3XYJV6UN+LWuuV4Ld\nskKvylp9V9RQYU0paW2EUEcSWQ4LqNBNFBfyMYd0FkhipnTt", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "P\u00e4dagogische Hochschule Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "PH-Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.ph-freiburg.de/zik/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Stephan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "lauffer@ph-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Lauffer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Martin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "duffner@ph-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Duffner", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://mds.sunet.se/shibboleth", 
    {
      "id": "_917fd17a90993b5461ed84f107819cfb", 
      "entity_id": "https://mds.sunet.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://mds.sunet.se/Shibboleth.sso/DS/ds.sunet.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.sunet.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.sunet.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC+TCCAeGgAwIBAgIJAOvVefVlKf4tMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDG1kcy5zdW5ldC5zZTAeFw0xMTEwMDMwOTIwMDRaFw0yMTA5MzAwOTIwMDRa\nMBcxFTATBgNVBAMTDG1kcy5zdW5ldC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAMM1mRFzygysIo9Qw7XabyoIe0nbATiS428GJ2oB3PSDLjmnf1CI\nkXwSBogHyAvdmQF04QCxeGki39cib/hTsxEbA14iGc/uyEbs4tFMgPvSPh3t8Uos\n1a8iHngnjpA0VuBH7VP3w0nCvj1eV5EobHKVk0NLgtXDgl87w6COPEre/5QN9IBf\n0/M7uO7zueXhpAzyO2+u+tZN2uacy5L2KTdiFxvFHAjaEjMnlVzbD7wehALIXNBg\nxtHUSITj2nwTjq7X/3sQbrusYL9DrW7RKLzzLSuHxRr4Dz+PESOjZUxBjTcwE4uJ\n2fmPuHfCtsxXHUnm7Ap3Df5I1exmSjc3inkCAwEAAaNIMEYwJQYDVR0RBB4wHIIM\nbWRzLnN1bmV0LnNlhgxtZHMuc3VuZXQuc2UwHQYDVR0OBBYEFB+CPP645D+t0FSk\n/40HaWtGmOP6MA0GCSqGSIb3DQEBBQUAA4IBAQAz/rf6fDHJU8Dp6hahHkVNRWRu\ncdVruda7guUIJ6MQWgl1N9Twfm2OvUSaM5fPtsqfoYTkv4ThVs8vGYyw+Y2oAnBa\nXKvUeP6S6et7cKQZCtpi9UgK8s1dHK7oqJaluW9tGes1Mcer/qKFdYunLlXYi8PA\nPRgEOb2hquFNE5V+0vXeiVqo/fAhlHxZ5jJbSQ2RnnN7ycVCQDZZlaEYPrGpaZVS\n9gYHwnECD5EPl8QsVymK2Co28pXAwpdo4btmWAeDhmy+8yOMjoS+T3k+/wiEmLLp\ndnjCadQzQamnqs4mfuypLT2wWWjkat9QKAM9gHkMwcC1Uv2RM2QeR8FDySJX", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.sunet.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.sunet.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC+TCCAeGgAwIBAgIJAOvVefVlKf4tMA0GCSqGSIb3DQEBBQUAMBcxFTATBgNV\nBAMTDG1kcy5zdW5ldC5zZTAeFw0xMTEwMDMwOTIwMDRaFw0yMTA5MzAwOTIwMDRa\nMBcxFTATBgNVBAMTDG1kcy5zdW5ldC5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAMM1mRFzygysIo9Qw7XabyoIe0nbATiS428GJ2oB3PSDLjmnf1CI\nkXwSBogHyAvdmQF04QCxeGki39cib/hTsxEbA14iGc/uyEbs4tFMgPvSPh3t8Uos\n1a8iHngnjpA0VuBH7VP3w0nCvj1eV5EobHKVk0NLgtXDgl87w6COPEre/5QN9IBf\n0/M7uO7zueXhpAzyO2+u+tZN2uacy5L2KTdiFxvFHAjaEjMnlVzbD7wehALIXNBg\nxtHUSITj2nwTjq7X/3sQbrusYL9DrW7RKLzzLSuHxRr4Dz+PESOjZUxBjTcwE4uJ\n2fmPuHfCtsxXHUnm7Ap3Df5I1exmSjc3inkCAwEAAaNIMEYwJQYDVR0RBB4wHIIM\nbWRzLnN1bmV0LnNlhgxtZHMuc3VuZXQuc2UwHQYDVR0OBBYEFB+CPP645D+t0FSk\n/40HaWtGmOP6MA0GCSqGSIb3DQEBBQUAA4IBAQAz/rf6fDHJU8Dp6hahHkVNRWRu\ncdVruda7guUIJ6MQWgl1N9Twfm2OvUSaM5fPtsqfoYTkv4ThVs8vGYyw+Y2oAnBa\nXKvUeP6S6et7cKQZCtpi9UgK8s1dHK7oqJaluW9tGes1Mcer/qKFdYunLlXYi8PA\nPRgEOb2hquFNE5V+0vXeiVqo/fAhlHxZ5jJbSQ2RnnN7ycVCQDZZlaEYPrGpaZVS\n9gYHwnECD5EPl8QsVymK2Co28pXAwpdo4btmWAeDhmy+8yOMjoS+T3k+/wiEmLLp\ndnjCadQzQamnqs4mfuypLT2wWWjkat9QKAM9gHkMwcC1Uv2RM2QeR8FDySJX", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.sunet.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/mds.sunet.se.xml"
      }
    }
  ], 
  [
    "https://idp.it.gu.se/idp/shibboleth", 
    {
      "entity_id": "https://idp.it.gu.se/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/idp.it.gu.se.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.it.gu.se/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "gu.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "logo": [
                  {
                    "lang": "sv", 
                    "text": "https://www.gu.se/digitalAssets/1374/1374690_lo_gu_left.png", 
                    "width": "344", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "50"
                  }, 
                  {
                    "lang": "en", 
                    "text": "https://www.gu.se/digitalAssets/1374/1374690_lo_gu_left.png", 
                    "width": "376", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "50"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "sv", 
                    "text": "G\u00f6teborgs universitet", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "University of Gothenburg", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "Identity Provider f\u00f6r anst\u00e4llda och studenter vid G\u00f6teborgs universitet.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "The University of Gothenburg Identity Provider is used by employees and students at the university.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints", 
                "geolocation_hint": [
                  {
                    "text": "geo:57.6986,11.9712", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint"
                  }
                ], 
                "domain_hint": [
                  {
                    "text": "gu.se", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIUGLU4YqWFYHboh+F+iLNYkBw8XNAwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMB4XDTA5MDgyNDExMzA1OFoXDTI5\nMDgyNDExMzA1OFowFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEApOVkzaHuTCe+7lf79UnQ5iQ/8OLbJpwOxPTF\nwEPIHbMMU/aCVnxoZnwNApblqvpP2uOsQvh8d0uDv2iVC5BMN0ff9M+9rN7D/gAo\nL+w8CmWiHRudKyZLu8Gu89SGxyQ59AVCbJzGaEE9h/CmMYHCj/ONJ8mtjG9uw6u+\nVj+L8PHXsPHQsLvcl3/D7duIYH/xHRbPzXS0imux+r/OcSCR3aCPCx3uuAfVPxGS\n9Y/ifynV586V3szIM7O15SeXKenFMKjQhzA23ZPcHhDSxWnVGUDWFDRDNAXfD7BF\nKRBCaUlWZvczqsV3eGtW8XgOmuW/7yJT5REfrrSLOKprAK8yoQIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAuaXQuZ3Uuc2WGI2h0dHBzOi8vaWRwLml0Lmd1LnNlL2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBSpKDUl7ZRxhQ1/HRmVbFd+NbwxmzANBgkq\nhkiG9w0BAQUFAAOCAQEAXfaYlHQj4KRaJmMbWFV0XyNUlHNio8010vLv3t6WztlZ\njZFL/hTQIFhmYEA04Davdk+1/1JvcRePSpg2VCxT/QwHyOR3eimmQ6FKXWls/zO/\nV01sJrlLdf/53pzXYsVSOf50UK+GtrSB3hhzrFmeaBALOysGqk2h2/UdYISXxa/e\nMyQ/aOI5u+0Wlq2RdIXF8MrtnwBTRhNXLcXYzz4fPsdjd4TmmJLQLXLmFLE/IA+/\nCP9nuvekzvPla7AXlXPwPvbUunwZIZkN3aHzMY/08FKIYRLb9VmqInKXw8tIBSqG\nMoX9SCDPBh2j39QZupTaPkylXDshurod7B2XtXdHPg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.it.gu.se:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "gu.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIUGLU4YqWFYHboh+F+iLNYkBw8XNAwDQYJKoZIhvcNAQEF\nBQAwFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMB4XDTA5MDgyNDExMzA1OFoXDTI5\nMDgyNDExMzA1OFowFzEVMBMGA1UEAxMMaWRwLml0Lmd1LnNlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEApOVkzaHuTCe+7lf79UnQ5iQ/8OLbJpwOxPTF\nwEPIHbMMU/aCVnxoZnwNApblqvpP2uOsQvh8d0uDv2iVC5BMN0ff9M+9rN7D/gAo\nL+w8CmWiHRudKyZLu8Gu89SGxyQ59AVCbJzGaEE9h/CmMYHCj/ONJ8mtjG9uw6u+\nVj+L8PHXsPHQsLvcl3/D7duIYH/xHRbPzXS0imux+r/OcSCR3aCPCx3uuAfVPxGS\n9Y/ifynV586V3szIM7O15SeXKenFMKjQhzA23ZPcHhDSxWnVGUDWFDRDNAXfD7BF\nKRBCaUlWZvczqsV3eGtW8XgOmuW/7yJT5REfrrSLOKprAK8yoQIDAQABo18wXTA8\nBgNVHREENTAzggxpZHAuaXQuZ3Uuc2WGI2h0dHBzOi8vaWRwLml0Lmd1LnNlL2lk\ncC9zaGliYm9sZXRoMB0GA1UdDgQWBBSpKDUl7ZRxhQ1/HRmVbFd+NbwxmzANBgkq\nhkiG9w0BAQUFAAOCAQEAXfaYlHQj4KRaJmMbWFV0XyNUlHNio8010vLv3t6WztlZ\njZFL/hTQIFhmYEA04Davdk+1/1JvcRePSpg2VCxT/QwHyOR3eimmQ6FKXWls/zO/\nV01sJrlLdf/53pzXYsVSOf50UK+GtrSB3hhzrFmeaBALOysGqk2h2/UdYISXxa/e\nMyQ/aOI5u+0Wlq2RdIXF8MrtnwBTRhNXLcXYzz4fPsdjd4TmmJLQLXLmFLE/IA+/\nCP9nuvekzvPla7AXlXPwPvbUunwZIZkN3aHzMY/08FKIYRLb9VmqInKXw8tIBSqG\nMoX9SCDPBh2j39QZupTaPkylXDshurod7B2XtXdHPg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "GU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "G\u00f6teborgs universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.gu.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "company": {
            "text": "G\u00f6teborgs universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "email_address": [
            {
              "text": "pablo.millet@gu.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://sandbox.aai.niif.hu/shibboleth", 
    {
      "entity_id": "https://sandbox.aai.niif.hu/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/sandbox.aai.niif.hu.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://eduid.hu"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "hu", 
            "text": "NIIF - Nemzeti Inform\u00e1ci\u00f3s Infrastrukt\u00fara Fejleszt\u00e9si Int\u00e9zet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "NIIF Institute - National Information Infrastructure Development", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "hu", 
            "text": "NIIF - Nemzeti Inform\u00e1ci\u00f3s Infrastrukt\u00fara Fejleszt\u00e9si Int\u00e9zet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "NIIF Institute - National Information Infrastructure Development", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "hu", 
            "text": "http://www.niif.hu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.niif.hu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sandbox.aai.niif.hu/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sandbox.aai.niif.hu/Shibboleth.sso/SLO/Redirect"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "is_default": "true", 
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sandbox.aai.niif.hu/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sandbox.aai.niif.hu/Shibboleth.sso/SAML2/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "hu", 
                    "text": "https://sandbox.aai.niif.hu/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "is_default": "true", 
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eppn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "schacHomeOrganizationType", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "affiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "hu", 
                  "text": "sandbox.aai.niif.hu", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "sandbox.aai.niif.hu", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDvjCCAqagAwIBAgIJAKmyDJ5RK7VnMA0GCSqGSIb3DQEBBQUAMEgxCzAJBgNVBAYTAkhVMQ0wCwYDVQQKEwROSUlGMQwwCgYDVQQLEwNBQUkxHDAaBgNVBAMTE3NhbmRib3guYWFpLm5paWYuaHUwHhcNMTAwMTA2MDkzNzM1WhcNMzcwNTI0MDkzNzM1WjBIMQswCQYDVQQGEwJIVTENMAsGA1UEChMETklJRjEMMAoGA1UECxMDQUFJMRwwGgYDVQQDExNzYW5kYm94LmFhaS5uaWlmLmh1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAss8blriJkeVc28dczjS3P7u4Hp+mDYqx9MecEzdGqnRPtE+1yJ3M6LkjmcbMSVvF+9i/qxkZxpn0BpIJhD/6WpC7e4TbAIMls6+eBSd82MJE2siANba+g7KIIc73LhEnnMBv5fmbyaAfCGZ6yG45/hsQ7j5f0ufcJuIINfrSIG+Qo3fMggIbgxZot3kzdJFUkPTNY201yQUhNmb2mNSOX1zOQn7+cRbrQ3ZBUj8E7rasqzZc20VhLF/Jv+yNr5zvkoETucJr4G8OyudKCPQT9xegJ9s5GBQ48DEQot6LFJSZ3zwDVeIoedWju2dLe6YIpC9pamhz9y2IP/9VlUhSTwIDAQABo4GqMIGnMB0GA1UdDgQWBBSmKZt1dBQ80ZzNIcEy0Nihu/nZYzB4BgNVHSMEcTBvgBSmKZt1dBQ80ZzNIcEy0Nihu/nZY6FMpEowSDELMAkGA1UEBhMCSFUxDTALBgNVBAoTBE5JSUYxDDAKBgNVBAsTA0FBSTEcMBoGA1UEAxMTc2FuZGJveC5hYWkubmlpZi5odYIJAKmyDJ5RK7VnMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAH8CkAleuCDK2S3qHSTdveyeXeIMT0JQ1sMwaNUgDpT7dItMc00Xl7kmcHyLq9ERu066ViSQYbJpFncrC+WrNbu5taArSs8I/iYXdBipRo6QRdy3DmjQEp/UgqKBWt+KZXNYm8UbaXJ0M0HNd9OvMznfDgUiBz0Bjy2e0ILhC15Bv33/zXpFJP+jaNv4C6Ql9Y8DbU/PujNBcBMWfN33gLedFHoHNSKJJcDryIxSDnDy7+TOwWcv3daztZEJ6h3rzGqkaN/+NBUynn1LebvvbWTNGarebjqDcT4D2l4d+QIYvXnECWD3ARf/rdP/KbfoNxD2EBrKdxcvDPq0uQii8nE=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "mailto:aai@niif.hu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "NIIF AAI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "email_address": [
            {
              "text": "mailto:aai@niif.hu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "NIIF AAI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "email_address": [
            {
              "text": "mailto:aai@niif.hu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "NIIF AAI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://sp.example.org/shibboleth", 
    {
      "entity_id": "https://sp.example.org/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://dev.teol.uu.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "gravis.its.uu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=gravis.its.uu.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAOCYEsltDIEOMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGdyYXZpcy5pdHMudXUuc2UwHhcNMTEwNTMwMTE0MjQ0WhcNMjEwNTI3MTE0\nMjQ0WjAbMRkwFwYDVQQDExBncmF2aXMuaXRzLnV1LnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAqcyKimtM4p/GlAzooApIxPv+/BHyzyJh8gGcLFnH\nXNq/t1eZz1MAFeSg5nWYwCp2VaVSEGGy/C711qeSgCONkl83E4KFrsfjhT4OAgST\nN0MlNscx1bFy/xhY8auGzCO06vtyjo0KAV3b0dJHLdkVPqnZ2adh5NrBW8W+UjuF\nYlkVloBNbtYFkmDJ9TdDRR0lHn9kc8XBsc+tNWRiY8dnbrqrjEi9dhvu329htBKy\njaXaX7XYO/N3m4bfTv2iLL6LmdIUOldSFg0+hk6haFsexfcpjNXmYW6TOdqEwRKO\nP3WaH3Nw0yfJVWFKiniy6g775F+QXs5PzxlNcLK+jkCOkQIDAQABoz4wPDAbBgNV\nHREEFDASghBncmF2aXMuaXRzLnV1LnNlMB0GA1UdDgQWBBRzUaO3NftSgdTOeqmN\nvB3AFMLi8TANBgkqhkiG9w0BAQUFAAOCAQEAh8KlaKp/LGgJL2w8/ES3nYhEXT6P\nGy6V4RfqYCq0MKrel66XvB/3Q5F9+yoA39DjXFAVaZUB3xI0WeoHorQ7Gx+59gij\nxr6eFVgxL7j7q/dW48sz7tZwZ2znx0ML3LQY4z4Xqq0fGW7o+EsMby27IyM7C3Uk\nch5H5bJ6FWyiKsG1aH9ZHQHGXKbDbCOL7eO3CEZFj10UWeETomBGBsE0YAwMgOKh\n4ZTYqvTaF7H9YYOOET3DeNeyk9LyhwQmHBkj9qfoA076qW58vWT5JxgOowHhf8Q5\ngcZIyBmPJZ77E5v9lXWPYJHop+LYLJppmM00jVz3nrrlX+UraN7koc64xA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.teol.uu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.teol.uu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.teol.uu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.teol.uu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.teol.uu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://dev.teol.uu.se/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/dev.teol.uu.se.xml"
      }
    }
  ], 
  [
    "https://idp.feide.no", 
    {
      "entity_id": "https://idp.feide.no", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.feide.no.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://idp.feide.no/simplesaml/saml2/idp/SingleLogoutService.php"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.feide.no/simplesaml/saml2/idp/SSOService.php"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Feide", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "no", 
                    "text": "Feide", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "nn", 
                    "text": "Feide", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Feide is the login system for norwegian educational and research institusions.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "no", 
                    "text": "Feide er innloggingssiden for norske utdannings- og forskningsinstitusjoner.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "nn", 
                    "text": "Feide er innloggingssida for norske utdannings- og forskningsinstitusjonar.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "text": "aal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "agdenes.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "aho.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "alstahaug.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "aremark.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "arendal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "as-skole.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "askim.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "askoy.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "asnes.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "aure.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "austagderfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "austrheim.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "averoy.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "baerum.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "balestrand.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "bamble.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "bergensskolen.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "bfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "bibsys.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "bokn.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "bomlo.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "bremanger.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "diakonhjemmet.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "dmmh.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "donna.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "drammen.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "eid.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "eideskolen.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "eidfjord.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "eidskog.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "elverum.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "etne.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "etnedal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "fedje.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.afjord.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.ahk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.amot.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.bjugn.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.engerdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.farsund.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.kg.vgs.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.leksvik.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.lorenskog-skole.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.mosseskolen.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.nord-fron.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.oknett.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.orkdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.orlandet.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.osen.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.rade.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.rissa.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.roan.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.roros.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.rygge.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.sarpsborg.com", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.skedsmo.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.stor-elvdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.stord.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.stranda.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "feide.trysil.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ffk.vgs.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "fjell.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "flaa.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "flesberg.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "flora.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "forsand.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "frana.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "frogn.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "froland.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "frosta.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "froya.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "fusa.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "giske.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "gjemnes.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "gloppen.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "gol.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "granvin.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "grimstad.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "grong.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "gs.alesund.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "gs.skodje.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "gs.sula.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ha.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hadsel.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "haldenskole.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "halsa.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "haugesund.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hedmark.org", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hemnegs.fronter.com", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hemnes.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hemsedal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "heroy-no.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hials.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hib.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hibu.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hifm.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hig.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hih.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hihm.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hil.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "himolde.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hin.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hinesna.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hint.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hioa.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hiof.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hisf.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hist.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hit.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hitra.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hive.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hivolda.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hjartdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hjelmeland.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hobol.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hol.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hornindal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "horten.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hoylandet.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "hsh.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "iktsenteret.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "jondal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "karmoyskolen.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "khib.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "khio.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "klabu.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "kongsberg.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "kristiansand.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "kristiansund.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "kvam.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "kvinnherad.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "kvn.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ldh.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "leikanger.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "leirfjord.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "lierne.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "lillesand.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "lindas.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "luster.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "lyngdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "malvik.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "marker.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "masfjorden.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "meland.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "meldal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "melhus.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "meraker.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "mf.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "midtre-gauldal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "modalen.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "mrfylke.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "namsskogan.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nes-bu.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nesset.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nhh.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nih.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nith.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nla.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nmh.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nord-aurdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nore-og-uvdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "notodden.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "notteroy.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ntfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ntnu.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "nvh.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "oddaskolen.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "oksnes.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "oppdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "oppland.org", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "os-ho.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "osteroy.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ovgs.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ovre-eiker.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "oygarden.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "oystre-slidre.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "phs.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "radoy.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rana.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "randaberg.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rauma.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rennebu.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rogfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rollag.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "romskog.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "royken.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "royrvik.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "samfunnsforskning.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "samiskhs.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "samnanger.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sande.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sandefjord.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sauda.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "selbu.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "selje.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sfj.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "skaun.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "skole.fredrikstad.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "skole.svk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "smola.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "snasa.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "snillfjord.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sogndal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sola.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sor-aurdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sorum.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "spusers.feide.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "stavanger.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "steinkjer.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "stfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "stjordal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "stpaul.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "strand.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "stryn.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "suldal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sund.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "sunndal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "surnadal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "svelvik.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "tingvoll.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "tinn.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "tokke.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "troms.vgs.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "tromso.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "trondheim.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "tydal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "tysnes.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "tysver.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "uia.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "uib.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "uin.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "uio.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "uis.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "uit.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ullensvang.herad.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "ulvik.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "umb.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "uninett.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "utsira.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vaalerskolene.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vaf.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vagan.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vagsoy.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vaksdal.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "valer-of.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vang.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vefsn.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vestby.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vestre-slidre.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vfk.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "vgsa.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "voss.kommune.no", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDhjCCAm4CCQCMHNhxUI2H1TANBgkqhkiG9w0BAQUFADCBhDELMAkGA1UEBhMCTk8xEjAQBgNVBAcTCVRyb25kaGVpbTETMBEGA1UEChMKVW5pbmV0dCBBUzEOMAwGA1UECxMFRkVJREUxFTATBgNVBAMTDGlkcC5mZWlkZS5ubzElMCMGCSqGSIb3DQEJARYWbW9yaWEtZHJpZnRAdW5pbmV0dC5ubzAeFw0wODA5MDUxMTU0MzNaFw0xODA3MTUxMTU0MzNaMIGEMQswCQYDVQQGEwJOTzESMBAGA1UEBxMJVHJvbmRoZWltMRMwEQYDVQQKEwpVbmluZXR0IEFTMQ4wDAYDVQQLEwVGRUlERTEVMBMGA1UEAxMMaWRwLmZlaWRlLm5vMSUwIwYJKoZIhvcNAQkBFhZtb3JpYS1kcmlmdEB1bmluZXR0Lm5vMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4fTsmIsKVGtniXddnerSeiLeAZAlAOL8v+ebzVzYcpTJzMHrplD+lF2tXxRgs7IGEw3t2zRCtxnGbiGkXPW+oCs4T989z+Sq8nh7Lff/XlyK+jQ7BtfC8RUYQ+eNEQy0Fif+81JyPbiwZovbiL4WrK1GOG81/2CF7rvwyXJkDD1YXJ5W18/c06YLfYJjuzZgEoCVRq6ecgQyPKg1xwIpW2GpkKOBXA7oKWtev+xcmSiLZwZE96mSHjty0L+wW6NUuf2/8VSCc4IED0EbzqFUoeHuGXqPak+tu9+VpP6vmmyp4gSCxsmWtoKm7UC8P1QeCyZxwQaoGlIp78wsE5ao5wIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQACUWuuirUSwDWksdkwKuqsNttnNmivwUMLtKDjHbMcwVK/b4qWjrAjfmJXxamUSYlnGjeoiqSQQuc3/qHCPAZUnN8VqXcZUCBXWjMO7Y/AnnsFKHpkYm51jWckjudeyfUr4UnH7te0OuUrGRIVrRRg3DqLdgrcbkJ98JyT97hnaDMke4qNVwrQFF+yvxYs1aYkILySBB/KPGSTh5sxJovcyWd7GY4ad5nH5oEjXF1yZzndmUuHGlTTzk6SGzmUJgqKyba+KJ/jauy6qNC1gPqfnbntWKDkE9a9ow8tlsi3jHI9AZu9U6LnOvTJ8MjhyXOEByCaDnTpK8JiZr6JvCaV", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.feide.no/files/feide/metadata-registration-practice-statement.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://feide.no/", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2012-10-09T13:08:24Z"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Feide", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "no", 
            "text": "Feide", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Feide", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "no", 
            "text": "Feide", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.feide.no/introducing-feide", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "no", 
            "text": "http://www.feide.no/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Feide Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "support@feide.no", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://atlases.muni.cz/shibboleth", 
    {
      "entity_id": "https://atlases.muni.cz/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://atlases.muni.cz/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "to provide access to the three atlases: (1) Dermatopathology, (2) Fetal and Neonatal Pathology, (3) Pathology for Pre-graduate Students of Medicine. The atlases may serve as sources of teaching material for pre-graduate as well as postgraduate students of pathology", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "da", 
                  "text": "give adgang til tre atlasser: (1) Dermato-patologi, (2) Foster- og neonatal patologi, (3) Patologi for medicinstuderende. Atlasserne kan bruges som undervisningsmateriale for patologistuderende", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Pathology Images", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "da", 
                  "text": "Patologi-atlasser", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEZzCCA0+gAwIBAgILAQAAAAABID3xVZIwDQYJKoZIhvcNAQEFBQAwajEjMCEGA1UECxMaT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0ExEzARBgNVBAoTCkdsb2JhbFNpZ24xLjAsBgNVBAMTJUdsb2JhbFNpZ24gT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0EwHhcNMDkwMzI1MTMwNTE0WhcNMTIwNTA5MDcwNzU3WjCBgzELMAkGA1UEBhMCREsxETAPBgNVBAgTCE9kZW5zZSBNMREwDwYDVQQHEwhPZGVuc2UgTTEbMBkGA1UECxMSV0FZRiAtIFNlY3JldGFyaWF0MR0wGwYDVQQKExRTeWRkYW5zayBVbml2ZXJzaXRldDESMBAGA1UEAxQJKi53YXlmLmRrMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBsuiyO84OVwkKR0TL6w8viWV4jMg+Jy7LgiEtYfHdnVBCvdM9XJJetS0MiJtulBH4/4ZWrfeGeHgLPvSjp6FiRdI1nDg/33ofc0TdNytxX4tBCzvxM0C4yCCaEXda+tqXJmGua+mVubMhS8kizHjL+s7A8xUqXoEFqOMHtgqoAQIDAQABo4IBdjCCAXIwHwYDVR0jBBgwFoAUfW0q7Garp1E2qwJp8XCPxFkLmh8wSQYIKwYBBQUHAQEEPTA7MDkGCCsGAQUFBzAChi1odHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24ubmV0L2NhY2VydC9vcmd2MS5jcnQwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC5nbG9iYWxzaWduLm5ldC9Pcmdhbml6YXRpb25WYWwxLmNybDAdBgNVHQ4EFgQUvlkjTc0iuzcvi752QgktLT01obgwCQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCBaAwKQYDVR0lBCIwIAYIKwYBBQUHAwEGCCsGAQUFBwMCBgorBgEEAYI3CgMDMEsGA1UdIAREMEIwQAYJKwYBBAGgMgEUMDMwMQYIKwYBBQUHAgEWJWh0dHA6Ly93d3cuZ2xvYmFsc2lnbi5uZXQvcmVwb3NpdG9yeS8wEQYJYIZIAYb4QgEBBAQDAgbAMA0GCSqGSIb3DQEBBQUAA4IBAQCKPVJYHjKOrzWtjPBTEJOwIzE0wSIcA+9+GNR5Pvk+6OTf2QTUDDHpXiiIEcYPL1kN/BEvA+N2y+7qyI5MlL7DNIu9clx1lcqhXiQ0lWcu7Bmb7VNPKq5WS1W81GhbZrO6BJtsQctU6odDXMoORay7FxnaxGHOaJlCSQDgT7QrRhzyd80X8NxrSV25byCTb31du8xoO+WagnqAp6xbKs6IsESDw2r/i3rLOXbL37B7lnbjcLC963xN6j7+kiyqiCjvrP0GLfSV4/FN9i9hWrdMlcbnvr23yz5Jflc1oFPtJx7GZqtV0uTijGxCr+aRaUzBPqc3kyavHJcCsn5TcL1t", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEZzCCA0+gAwIBAgILAQAAAAABID3xVZIwDQYJKoZIhvcNAQEFBQAwajEjMCEGA1UECxMaT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0ExEzARBgNVBAoTCkdsb2JhbFNpZ24xLjAsBgNVBAMTJUdsb2JhbFNpZ24gT3JnYW5pemF0aW9uIFZhbGlkYXRpb24gQ0EwHhcNMDkwMzI1MTMwNTE0WhcNMTIwNTA5MDcwNzU3WjCBgzELMAkGA1UEBhMCREsxETAPBgNVBAgTCE9kZW5zZSBNMREwDwYDVQQHEwhPZGVuc2UgTTEbMBkGA1UECxMSV0FZRiAtIFNlY3JldGFyaWF0MR0wGwYDVQQKExRTeWRkYW5zayBVbml2ZXJzaXRldDESMBAGA1UEAxQJKi53YXlmLmRrMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBsuiyO84OVwkKR0TL6w8viWV4jMg+Jy7LgiEtYfHdnVBCvdM9XJJetS0MiJtulBH4/4ZWrfeGeHgLPvSjp6FiRdI1nDg/33ofc0TdNytxX4tBCzvxM0C4yCCaEXda+tqXJmGua+mVubMhS8kizHjL+s7A8xUqXoEFqOMHtgqoAQIDAQABo4IBdjCCAXIwHwYDVR0jBBgwFoAUfW0q7Garp1E2qwJp8XCPxFkLmh8wSQYIKwYBBQUHAQEEPTA7MDkGCCsGAQUFBzAChi1odHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24ubmV0L2NhY2VydC9vcmd2MS5jcnQwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC5nbG9iYWxzaWduLm5ldC9Pcmdhbml6YXRpb25WYWwxLmNybDAdBgNVHQ4EFgQUvlkjTc0iuzcvi752QgktLT01obgwCQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCBaAwKQYDVR0lBCIwIAYIKwYBBQUHAwEGCCsGAQUFBwMCBgorBgEEAYI3CgMDMEsGA1UdIAREMEIwQAYJKwYBBAGgMgEUMDMwMQYIKwYBBQUHAgEWJWh0dHA6Ly93d3cuZ2xvYmFsc2lnbi5uZXQvcmVwb3NpdG9yeS8wEQYJYIZIAYb4QgEBBAQDAgbAMA0GCSqGSIb3DQEBBQUAA4IBAQCKPVJYHjKOrzWtjPBTEJOwIzE0wSIcA+9+GNR5Pvk+6OTf2QTUDDHpXiiIEcYPL1kN/BEvA+N2y+7qyI5MlL7DNIu9clx1lcqhXiQ0lWcu7Bmb7VNPKq5WS1W81GhbZrO6BJtsQctU6odDXMoORay7FxnaxGHOaJlCSQDgT7QrRhzyd80X8NxrSV25byCTb31du8xoO+WagnqAp6xbKs6IsESDw2r/i3rLOXbL37B7lnbjcLC963xN6j7+kiyqiCjvrP0GLfSV4/FN9i9hWrdMlcbnvr23yz5Jflc1oFPtJx7GZqtV0uTijGxCr+aRaUzBPqc3kyavHJcCsn5TcL1t", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/atlases.muni.cz.xml"
      }
    }
  ], 
  [
    "https://www-s.redi-bw.de", 
    {
      "entity_id": "https://www-s.redi-bw.de", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www-s.redi-bw.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "ReDI Stuttgart", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-freiburg.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Hans-Adolf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ruppert@ub.uni-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Ruppert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "ReDI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "info@redi-bw.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SLO/SOAP"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/SAML/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-s.redi-bw.de/Shibboleth.sso/NIM/SOAP"
            }
          ], 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www-s.redi-bw.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=info@redi-bw.de,CN=www-s.redi-bw.de,OU=Universitaetsbibliothek,O=Universitaet Freiburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFZjCCBE6gAwIBAgIEC0feAzANBgkqhkiG9w0BAQUFADCBhjELMAkGA1UEBhMC\nREUxHjAcBgNVBAoTFVVuaXZlcnNpdGFldCBGcmVpYnVyZzEWMBQGA1UECxMNUmVj\naGVuemVudHJ1bTEYMBYGA1UEAxMPVW5pLUZSIENBIC0gRzAyMSUwIwYJKoZIhvcN\nAQkBFhZwa2lAcnoudW5pLWZyZWlidXJnLmRlMB4XDTA3MTAzMTExMDEwOFoXDTEy\nMTAyOTExMDEwOFowgYoxCzAJBgNVBAYTAkRFMR4wHAYDVQQKExVVbml2ZXJzaXRh\nZXQgRnJlaWJ1cmcxIDAeBgNVBAsTF1VuaXZlcnNpdGFldHNiaWJsaW90aGVrMRkw\nFwYDVQQDExB3d3ctcy5yZWRpLWJ3LmRlMR4wHAYJKoZIhvcNAQkBFg9pbmZvQHJl\nZGktYncuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClimyACau2\n7dtk/2Cd4F7vJfsEiAnyHkXG5LbBNDK286gOIXROgnOwEb6fLc08eR6F/79PlGqA\nNCvzUyMnIDSnNwdiXkofOvNKjYBCpSWzmnZjz4Spn2Fzb9LyDpKe2QAqZ8P8MWYF\nP9Up9C/cRcyprhJHqzL/kMNPQUVPAZWgHhkqjlZifQqElASXJ3u3vNfbWZ6RbuZ1\nPK7Z8l++u1nGkAoBrNr7bpKx4hHbPjQI53XiwpH0VAstYZHnqe7B9z/XCCeYjQMx\nigd03a8+wg0tkDqHDErYyk9ueuHrD72qsi96tdIshudVobdpJVdG2AlBHBl2O3Yj\nQlF0PPqGWAvZAgMBAAGjggHUMIIB0DAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAd\nBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0OBBYEFKEmtco6yR2f\nnO4Yt4UbhdMLOFFwMB8GA1UdIwQYMBaAFDNnqdbxk1U2rKEyvcHkljn/THAxMBoG\nA1UdEQQTMBGBD2luZm9AcmVkaS1idy5kZTCBjwYDVR0fBIGHMIGEMECgPqA8hjpo\ndHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1mcmVpYnVyZy1jYS9wdWIvY3JsL2df\nY2FjcmwuY3JsMECgPqA8hjpodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1mcmVp\nYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGoBggrBgEFBQcBAQSBmzCBmDBK\nBggrBgEFBQcwAoY+aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktZnJlaWJ1cmct\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwSgYIKwYBBQUHMAKGPmh0dHA6Ly9j\nZHAyLnBjYS5kZm4uZGUvdW5pLWZyZWlidXJnLWNhL3B1Yi9jYWNlcnQvZ19jYWNl\ncnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBB6TJb5jerQHmk9LwCvwEQrQGo/C52\n5DOdukZ2zV9SzgRb877XjjwCfNgVRurYyyJnBj95/kX2R7Ry8tDgY3LiDyRRGhXT\nrMdWWZgyEZrn0Aqk28hk2zm+U5f9OFTnwj6wRWfIAglAZxnsTUGFoHw3f2+f7tl1\ndKaPVl2nTMUOq3mJrgkMDwKksVH7miOw2U1dxyXNnPYFJcPKy04wXN4hj5fgJrQk\n7B/eFzIlQAv58jPToJuIf0AQ/tE6s0HbdVQk704V3vJ0shgvYk9XRG79H7xmqKIU\n5+Ku1V1/b70GA9disF4/zyhDZf6InNqnJfDn9nsiBkFInMqCDijq7l12", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www-s.redi-bw.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=info@redi-bw.de,CN=www-s.redi-bw.de,OU=Universitaetsbibliothek,O=Universitaet Freiburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFZjCCBE6gAwIBAgIEC0feAzANBgkqhkiG9w0BAQUFADCBhjELMAkGA1UEBhMC\nREUxHjAcBgNVBAoTFVVuaXZlcnNpdGFldCBGcmVpYnVyZzEWMBQGA1UECxMNUmVj\naGVuemVudHJ1bTEYMBYGA1UEAxMPVW5pLUZSIENBIC0gRzAyMSUwIwYJKoZIhvcN\nAQkBFhZwa2lAcnoudW5pLWZyZWlidXJnLmRlMB4XDTA3MTAzMTExMDEwOFoXDTEy\nMTAyOTExMDEwOFowgYoxCzAJBgNVBAYTAkRFMR4wHAYDVQQKExVVbml2ZXJzaXRh\nZXQgRnJlaWJ1cmcxIDAeBgNVBAsTF1VuaXZlcnNpdGFldHNiaWJsaW90aGVrMRkw\nFwYDVQQDExB3d3ctcy5yZWRpLWJ3LmRlMR4wHAYJKoZIhvcNAQkBFg9pbmZvQHJl\nZGktYncuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQClimyACau2\n7dtk/2Cd4F7vJfsEiAnyHkXG5LbBNDK286gOIXROgnOwEb6fLc08eR6F/79PlGqA\nNCvzUyMnIDSnNwdiXkofOvNKjYBCpSWzmnZjz4Spn2Fzb9LyDpKe2QAqZ8P8MWYF\nP9Up9C/cRcyprhJHqzL/kMNPQUVPAZWgHhkqjlZifQqElASXJ3u3vNfbWZ6RbuZ1\nPK7Z8l++u1nGkAoBrNr7bpKx4hHbPjQI53XiwpH0VAstYZHnqe7B9z/XCCeYjQMx\nigd03a8+wg0tkDqHDErYyk9ueuHrD72qsi96tdIshudVobdpJVdG2AlBHBl2O3Yj\nQlF0PPqGWAvZAgMBAAGjggHUMIIB0DAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAd\nBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0OBBYEFKEmtco6yR2f\nnO4Yt4UbhdMLOFFwMB8GA1UdIwQYMBaAFDNnqdbxk1U2rKEyvcHkljn/THAxMBoG\nA1UdEQQTMBGBD2luZm9AcmVkaS1idy5kZTCBjwYDVR0fBIGHMIGEMECgPqA8hjpo\ndHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1mcmVpYnVyZy1jYS9wdWIvY3JsL2df\nY2FjcmwuY3JsMECgPqA8hjpodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1mcmVp\nYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGoBggrBgEFBQcBAQSBmzCBmDBK\nBggrBgEFBQcwAoY+aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktZnJlaWJ1cmct\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwSgYIKwYBBQUHMAKGPmh0dHA6Ly9j\nZHAyLnBjYS5kZm4uZGUvdW5pLWZyZWlidXJnLWNhL3B1Yi9jYWNlcnQvZ19jYWNl\ncnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBB6TJb5jerQHmk9LwCvwEQrQGo/C52\n5DOdukZ2zV9SzgRb877XjjwCfNgVRurYyyJnBj95/kX2R7Ry8tDgY3LiDyRRGhXT\nrMdWWZgyEZrn0Aqk28hk2zm+U5f9OFTnwj6wRWfIAglAZxnsTUGFoHw3f2+f7tl1\ndKaPVl2nTMUOq3mJrgkMDwKksVH7miOw2U1dxyXNnPYFJcPKy04wXN4hj5fgJrQk\n7B/eFzIlQAv58jPToJuIf0AQ/tE6s0HbdVQk704V3vJ0shgvYk9XRG79H7xmqKIU\n5+Ku1V1/b70GA9disF4/zyhDZf6InNqnJfDn9nsiBkFInMqCDijq7l12", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://www.content-select.com/simplesaml/module.php/saml/sp/metadata.php/preselect.media-sp", 
    {
      "entity_id": "https://www.content-select.com/simplesaml/module.php/saml/sp/metadata.php/preselect.media-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.content-select.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Preselect.media GmbH, Gruenwald", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Preselect.media GmbH, Gruenwald", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.content-select.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Andreas", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "a.fuerlinger@preselect.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Fuerlinger", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml2-logout.php/preselect.media-sp"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.content-select.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.content-select.com,OU=Domain Control Validated - RapidSSL(R),OU=See www.rapidssl.com/resources/cps (c)11,OU=GT34580426,O=www.content-select.com,C=DE,serialNumber=KigR834DJIZuIEHAagJ0xVfd/ETeEvlJ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE9zCCA9+gAwIBAgIDBEopMA0GCSqGSIb3DQEBBQUAMDwxCzAJBgNVBAYTAlVT\nMRcwFQYDVQQKEw5HZW9UcnVzdCwgSW5jLjEUMBIGA1UEAxMLUmFwaWRTU0wgQ0Ew\nHhcNMTExMjA1MTIxNzQ0WhcNMTIxMjA3MTIxMzAwWjCB8zEpMCcGA1UEBRMgS2ln\nUjgzNERKSVp1SUVIQWFnSjB4VmZkL0VUZUV2bEoxCzAJBgNVBAYTAkRFMR8wHQYD\nVQQKExZ3d3cuY29udGVudC1zZWxlY3QuY29tMRMwEQYDVQQLEwpHVDM0NTgwNDI2\nMTEwLwYDVQQLEyhTZWUgd3d3LnJhcGlkc3NsLmNvbS9yZXNvdXJjZXMvY3BzIChj\nKTExMS8wLQYDVQQLEyZEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQgLSBSYXBpZFNT\nTChSKTEfMB0GA1UEAxMWd3d3LmNvbnRlbnQtc2VsZWN0LmNvbTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBANSTVbAyh0XF+bApU51WEeiotNOn7q/HQ7/Z\n0DSSTgsklWbB5kgDBBo4flY5a/PWuO0H5jBWAs2DXALafzelgMYssqA2up9xiK3M\neIVDro2W+2yFv9CfODJyIVCD8vTZFjqSfoehHF2Pjzp1YAQE0MUbgtX+VCE8oUOL\ntpp2iT7XHOr6DPD/6k8dovxuKQyo1xSkiyJ4CW/HrZQ+heauzyTXalZEfJDMlKib\nWnhjdpoXUA6xOSXoh992UjuEQxXoCYkGZHJQCaHBRx9UFuG4TMVRzq6g9h//Xcld\nH+H8xRctL7G2q1ehJm0IDLd9fOkvYyHTJWDy184/92R9BUSAlk0CAwEAAaOCAUgw\nggFEMB8GA1UdIwQYMBaAFGtpPWoYQkrdjwJlOf01JIZ4kRYwMA4GA1UdDwEB/wQE\nAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwNQYDVR0RBC4wLIIW\nd3d3LmNvbnRlbnQtc2VsZWN0LmNvbYISY29udGVudC1zZWxlY3QuY29tMEMGA1Ud\nHwQ8MDowOKA2oDSGMmh0dHA6Ly9yYXBpZHNzbC1jcmwuZ2VvdHJ1c3QuY29tL2Ny\nbHMvcmFwaWRzc2wuY3JsMB0GA1UdDgQWBBRjoYiCPyPt2k/XtEiyOs1ET+ygvjAM\nBgNVHRMBAf8EAjAAMEkGCCsGAQUFBwEBBD0wOzA5BggrBgEFBQcwAoYtaHR0cDov\nL3JhcGlkc3NsLWFpYS5nZW90cnVzdC5jb20vcmFwaWRzc2wuY3J0MA0GCSqGSIb3\nDQEBBQUAA4IBAQAYh5XWr45tlba/mmjOSw2HkGTqRk9rxN6K8VeXwG1+1hr7d2J7\nP34Tt8ln6vBAiSBrNW1j+kHXpxfUS+k/EGTn4m+2NfbKJfKHqEDgUGjYtI5/lu+T\nTrczpZ5qf+a8HSnnnbyH4IL7VKPUneQ22EGppDKLf1FznpJ4pXFmGyM4XU68mlmT\nVqFzNc/40cAysWElKPnDuaEeaNHPj+ygg16o2gELDdZVpcqNPj/u2sGyG8Ve0DoT\n5PFbqWVKT7ei0rDFL5jWiqrmDWQGDJ7afzoPozmz4jaZXVxOkC5bHTL0wtHVFG8Z\nXvtaOslqoxKB8TiLxGjJAXztJJFWwMwF5ebp", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.content-select.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.content-select.com,OU=Domain Control Validated - RapidSSL(R),OU=See www.rapidssl.com/resources/cps (c)11,OU=GT34580426,O=www.content-select.com,C=DE,serialNumber=KigR834DJIZuIEHAagJ0xVfd/ETeEvlJ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE9zCCA9+gAwIBAgIDBEopMA0GCSqGSIb3DQEBBQUAMDwxCzAJBgNVBAYTAlVT\nMRcwFQYDVQQKEw5HZW9UcnVzdCwgSW5jLjEUMBIGA1UEAxMLUmFwaWRTU0wgQ0Ew\nHhcNMTExMjA1MTIxNzQ0WhcNMTIxMjA3MTIxMzAwWjCB8zEpMCcGA1UEBRMgS2ln\nUjgzNERKSVp1SUVIQWFnSjB4VmZkL0VUZUV2bEoxCzAJBgNVBAYTAkRFMR8wHQYD\nVQQKExZ3d3cuY29udGVudC1zZWxlY3QuY29tMRMwEQYDVQQLEwpHVDM0NTgwNDI2\nMTEwLwYDVQQLEyhTZWUgd3d3LnJhcGlkc3NsLmNvbS9yZXNvdXJjZXMvY3BzIChj\nKTExMS8wLQYDVQQLEyZEb21haW4gQ29udHJvbCBWYWxpZGF0ZWQgLSBSYXBpZFNT\nTChSKTEfMB0GA1UEAxMWd3d3LmNvbnRlbnQtc2VsZWN0LmNvbTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBANSTVbAyh0XF+bApU51WEeiotNOn7q/HQ7/Z\n0DSSTgsklWbB5kgDBBo4flY5a/PWuO0H5jBWAs2DXALafzelgMYssqA2up9xiK3M\neIVDro2W+2yFv9CfODJyIVCD8vTZFjqSfoehHF2Pjzp1YAQE0MUbgtX+VCE8oUOL\ntpp2iT7XHOr6DPD/6k8dovxuKQyo1xSkiyJ4CW/HrZQ+heauzyTXalZEfJDMlKib\nWnhjdpoXUA6xOSXoh992UjuEQxXoCYkGZHJQCaHBRx9UFuG4TMVRzq6g9h//Xcld\nH+H8xRctL7G2q1ehJm0IDLd9fOkvYyHTJWDy184/92R9BUSAlk0CAwEAAaOCAUgw\nggFEMB8GA1UdIwQYMBaAFGtpPWoYQkrdjwJlOf01JIZ4kRYwMA4GA1UdDwEB/wQE\nAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwNQYDVR0RBC4wLIIW\nd3d3LmNvbnRlbnQtc2VsZWN0LmNvbYISY29udGVudC1zZWxlY3QuY29tMEMGA1Ud\nHwQ8MDowOKA2oDSGMmh0dHA6Ly9yYXBpZHNzbC1jcmwuZ2VvdHJ1c3QuY29tL2Ny\nbHMvcmFwaWRzc2wuY3JsMB0GA1UdDgQWBBRjoYiCPyPt2k/XtEiyOs1ET+ygvjAM\nBgNVHRMBAf8EAjAAMEkGCCsGAQUFBwEBBD0wOzA5BggrBgEFBQcwAoYtaHR0cDov\nL3JhcGlkc3NsLWFpYS5nZW90cnVzdC5jb20vcmFwaWRzc2wuY3J0MA0GCSqGSIb3\nDQEBBQUAA4IBAQAYh5XWr45tlba/mmjOSw2HkGTqRk9rxN6K8VeXwG1+1hr7d2J7\nP34Tt8ln6vBAiSBrNW1j+kHXpxfUS+k/EGTn4m+2NfbKJfKHqEDgUGjYtI5/lu+T\nTrczpZ5qf+a8HSnnnbyH4IL7VKPUneQ22EGppDKLf1FznpJ4pXFmGyM4XU68mlmT\nVqFzNc/40cAysWElKPnDuaEeaNHPj+ygg16o2gELDdZVpcqNPj/u2sGyG8Ve0DoT\n5PFbqWVKT7ei0rDFL5jWiqrmDWQGDJ7afzoPozmz4jaZXVxOkC5bHTL0wtHVFG8Z\nXvtaOslqoxKB8TiLxGjJAXztJJFWwMwF5ebp", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml2-acs.php/preselect.media-sp"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml1-acs.php/preselect.media-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml2-acs.php/preselect.media-sp"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.content-select.com/simplesaml/module.php/saml/sp/saml1-acs.php/preselect.media-sp/artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://download.portal.chalmers.se/shibboleth", 
    {
      "entity_id": "https://download.portal.chalmers.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGDCCAgCgAwIBAgIJALWMAnfoeEVTMA0GCSqGSIb3DQEBBQUAMCYxJDAiBgNV\nBAMTG2Rvd25sb2FkLnBvcnRhbC5jaGFsbWVycy5zZTAeFw0xMzAyMTMwODUxMjla\nFw0yMzAyMTEwODUxMjlaMCYxJDAiBgNVBAMTG2Rvd25sb2FkLnBvcnRhbC5jaGFs\nbWVycy5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPbG9acyl2gu\nWdBwDx/r2gP4VufkHGiGheTy8jutaG+KjEcw1+0gbXR7j5q0ikaNki1tRaFmSpnZ\nDotWPOF5ZEsp8MI24NoIijkZTPhVVqRrq4FkZT/L2z6MXUpSXcVLgdxoRX9SSVgv\ncs522ZRTQe6WplkNU3oLKP+gkZl9ukdiFgLQNgeyEphRjN2Ec7OWLepizbotZdu8\n69gmzqHLbNZLiugcBpwIbQO5FkDbxSSdmGOyUWRjcHswJRYo2MMFhrbYYVUIiK1u\nY0wcfRdARkfsbbPG5w8hv4DjEJ2JZ+ofBnfnA6ESn/XEOQ9CAsQ2NbJjUj4rfT88\nEuaGtA/9PqkCAwEAAaNJMEcwJgYDVR0RBB8wHYIbZG93bmxvYWQucG9ydGFsLmNo\nYWxtZXJzLnNlMB0GA1UdDgQWBBQba5syq555BkfQhoVoklnnfDhStDANBgkqhkiG\n9w0BAQUFAAOCAQEAO75ObgCaN++7fT0Y1B7XiEQ2p8oNmND5BedRV9TahI8+zykh\n3j8HSTgEXqGK6DFER9SE7tCxtx3sEytVSpE2pEnqWxWKoU491kZGqWGOm6oSDEWT\n8dMpbx9Z/ZBBo5JdvYDI5Q7MvWIf7+aAhTTcFdQAWqLxje21c3Hpl9zWQ0I9H1p3\nmlThPPb5z+XmLaeAQ6Ux+abiWO+DODJZsidLX3/Aaz86RujVnqk95vY9QxUtynIF\nBfKJHhQBqFivpHyPMnT3y6+UtDE4vfTqLWp5UZoXpKsf/Zo/7+5RQhzlPSxQT0+4\n+//vS+QQnFOG6SANEuSxYURni+8Zk25O5yQlDg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://download.portal.chalmers.se/Shibboleth.sso/SAML/POST"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/download.portal.chalmers.se.xml"
      }
    }
  ], 
  [
    "https://mds.lan.kth.se/shibboleth", 
    {
      "id": "_63b44d382bf65bf5608abcce0689be06", 
      "entity_id": "https://mds.lan.kth.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://mds.lan.kth.se/Shibboleth.sso/DS/ds.sunet.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.lan.kth.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.lan.kth.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDATCCAemgAwIBAgIJAKuJLl2VWSDhMA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDm1kcy5sYW4ua3RoLnNlMB4XDTExMTAyNTE0MDMzN1oXDTIxMTAyMjE0MDMz\nN1owGTEXMBUGA1UEAxMObWRzLmxhbi5rdGguc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQD1ZMkEwaMPbixuO7VOmHpZ86vfKMIw5P6AzprpKXLV7m5q\nPFyb3OcK5B8R6iN+uNAE9T4G57G1N0VEQqAdZzOodZRaIypXd8Y6f0PmWPjaptC7\nRCjfyXOEdTeHPBFmJrdkdykF6/jv0zn+BE3wuVCqbULDaHd1l4eBi2Lz7elxVsVX\nrxNDJHG+qRrohbka4tSSCi6yUcSo3Go0Nv7fd5gjidMuqoTK5B0fSfEW5qg8x/Kn\nIrvIFCTlMl81PybL9D/H2uopC8jqWvMkMK8db4P4Ckq96J3KvaIbZyWPmbN0nEgR\n5gwpc7alwRrAOaxit/fB54ps6sR3s7NUwuQcx77zAgMBAAGjTDBKMCkGA1UdEQQi\nMCCCDm1kcy5sYW4ua3RoLnNlhg5tZHMubGFuLmt0aC5zZTAdBgNVHQ4EFgQU0UDQ\niSy3a0gXV/eYtxzIfft90kAwDQYJKoZIhvcNAQEFBQADggEBAHE3lggheqGWhWcS\nO2MECNb8+wKFMS+06ht2j+WJYrqtE73dGdVIwCwkSfT0C0P85NShGCdexaUfzZD6\n4vLqHHfx+zSvJomqkOV0khSte59BsajGET0aa3obgJJaWCjfsgFu840qqKX1sDcD\nmFV1KDcpYhC52EveHBchKQ45ZH/KqKJ4laQy6OkCMQPQolX+KxY8nyJ4J6qACCdY\nA/uj+L0Hs/4CBKkM9kbs0P6oszY0dbWwXLY8+bjZpD0XqZULIkjJixlJ0nQk12uE\nWq6nlMKr18cS90g2FgxclTGMrHuSxPvAdDKGAfO29lzRLGWoCSDLKqIAeajHnRNc\nK4y2OQU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "mds.lan.kth.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=mds.lan.kth.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDATCCAemgAwIBAgIJAKuJLl2VWSDhMA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDm1kcy5sYW4ua3RoLnNlMB4XDTExMTAyNTE0MDMzN1oXDTIxMTAyMjE0MDMz\nN1owGTEXMBUGA1UEAxMObWRzLmxhbi5rdGguc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQD1ZMkEwaMPbixuO7VOmHpZ86vfKMIw5P6AzprpKXLV7m5q\nPFyb3OcK5B8R6iN+uNAE9T4G57G1N0VEQqAdZzOodZRaIypXd8Y6f0PmWPjaptC7\nRCjfyXOEdTeHPBFmJrdkdykF6/jv0zn+BE3wuVCqbULDaHd1l4eBi2Lz7elxVsVX\nrxNDJHG+qRrohbka4tSSCi6yUcSo3Go0Nv7fd5gjidMuqoTK5B0fSfEW5qg8x/Kn\nIrvIFCTlMl81PybL9D/H2uopC8jqWvMkMK8db4P4Ckq96J3KvaIbZyWPmbN0nEgR\n5gwpc7alwRrAOaxit/fB54ps6sR3s7NUwuQcx77zAgMBAAGjTDBKMCkGA1UdEQQi\nMCCCDm1kcy5sYW4ua3RoLnNlhg5tZHMubGFuLmt0aC5zZTAdBgNVHQ4EFgQU0UDQ\niSy3a0gXV/eYtxzIfft90kAwDQYJKoZIhvcNAQEFBQADggEBAHE3lggheqGWhWcS\nO2MECNb8+wKFMS+06ht2j+WJYrqtE73dGdVIwCwkSfT0C0P85NShGCdexaUfzZD6\n4vLqHHfx+zSvJomqkOV0khSte59BsajGET0aa3obgJJaWCjfsgFu840qqKX1sDcD\nmFV1KDcpYhC52EveHBchKQ45ZH/KqKJ4laQy6OkCMQPQolX+KxY8nyJ4J6qACCdY\nA/uj+L0Hs/4CBKkM9kbs0P6oszY0dbWwXLY8+bjZpD0XqZULIkjJixlJ0nQk12uE\nWq6nlMKr18cS90g2FgxclTGMrHuSxPvAdDKGAfO29lzRLGWoCSDLKqIAeajHnRNc\nK4y2OQU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://mds.lan.kth.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/mds.lan.kth.se.xml"
      }
    }
  ], 
  [
    "https://sp.asknet.de/shibboleth-sp", 
    {
      "entity_id": "https://sp.asknet.de/shibboleth-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/sp.asknet.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "asknet AG Karlsruhe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "asknet AG Serviceprovider", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.asknet.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Frank", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "frank.flottemesch@asknet.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Flottemesch", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "J\u00f6rgen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "joergen.dahlke@asknet.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Dahlke", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.asknet.de/Shibboleth.sso/DS"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "sp.asknet.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=sp.asknet.de,OU=DFN-PKI,O=DFN-Verein,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE+jCCA+KgAwIBAgIED9Kx6zANBgkqhkiG9w0BAQUFADBVMQswCQYDVQQGEwJE\nRTETMBEGA1UEChMKREZOLVZlcmVpbjEQMA4GA1UECxMHREZOLVBLSTEfMB0GA1UE\nAxMWREZOLVZlcmVpbiBDQSBTZXJ2aWNlczAeFw0xMDAzMzExMTM5MDhaFw0xNTAz\nMzAxMTM5MDhaMEsxCzAJBgNVBAYTAkRFMRMwEQYDVQQKEwpERk4tVmVyZWluMRAw\nDgYDVQQLEwdERk4tUEtJMRUwEwYDVQQDEwxzcC5hc2tuZXQuZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC+n8aGXU8eGT0HeiRTnXASUoTstkWzkkhL\nLOEGblTGhO7cMFbJM/g/kOdUIIRi0dzhan8UdAKkeqtWnUpf2vgKfu/f97mwfpT7\nqKbN2LvX1VoQXtpmCwkf477fKXsaiHojRxx87/zfURJRUQK9fDeO7k1r3iTzSLJO\n7lEDIQVeezplT1MhzOYPdS8sUaCJogPgvYBZ+mPjpA8SYx6Rq5mtlDZGUII951Uh\nInrCCgmk0WpIxclL1IHdNqy3FOv1XSDS0k+KBQQnu/FpxhInUm1lILXfV2IkTvnn\nHcTJFh6/5Ojk8sOEh0vaBB2Q1ncJsrR0NWCBlgLfSdhX5zXmeFmtAgMBAAGjggHa\nMIIB1jAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcD\nAgYIKwYBBQUHAwEwHQYDVR0OBBYEFNVU8a0BOqrMQNKc91DuHripAe3nMB8GA1Ud\nIwQYMBaAFB2p8YYmdk3PXf1Qo27r8bwidW3rMBwGA1UdEQQVMBOBEWNlcnRhZG1A\nYXNrbmV0LmRlMIGRBgNVHR8EgYkwgYYwQaA/oD2GO2h0dHA6Ly9jZHAxLnBjYS5k\nZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEGgP6A9\nhjtodHRwOi8vY2RwMi5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9wdWIv\nY3JsL2NhY3JsLmNybDCBqgYIKwYBBQUHAQEEgZ0wgZowSwYIKwYBBQUHMAKGP2h0\ndHA6Ly9jZHAxLnBjYS5kZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDBLBggrBgEFBQcwAoY/aHR0cDovL2NkcDIucGNhLmRmbi5k\nZS9nbG9iYWwtc2VydmljZXMtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqG\nSIb3DQEBBQUAA4IBAQAmucftP9132NU6iIByTjBoup1At2Nj0NeA+vE7Tg3iHBZh\nyWGxTsCVCHLSzDi8RpQKnnov1wsJ/Z7JCyd+C292zIFoUamliYVJKcTJtCOLmCkq\nwGLbbYq8CK8Tlv5BaWaleiNVaBxx1At7QT7PnV/YF9dPR3tQKP5vLYtPARAexbcV\nfKsNZP13cjxUMSmHBTgMLgpegD8btC7KcdKbO9xcLPz8A8ge00NElX53dqVGH83z\nRaTY5YqsKUIDh0mx2UxjFV9irG5X/QE6YCt0tBZtjaE7b9cHapIL9BZDRE7aRGDt\nrWoZ1ruqB2jP59EBdg4sTfzhvlLtUdL3H3aUimlg", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "sp.asknet.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=sp.asknet.de,OU=DFN-PKI,O=DFN-Verein,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIE+jCCA+KgAwIBAgIED9Kx6zANBgkqhkiG9w0BAQUFADBVMQswCQYDVQQGEwJE\nRTETMBEGA1UEChMKREZOLVZlcmVpbjEQMA4GA1UECxMHREZOLVBLSTEfMB0GA1UE\nAxMWREZOLVZlcmVpbiBDQSBTZXJ2aWNlczAeFw0xMDAzMzExMTM5MDhaFw0xNTAz\nMzAxMTM5MDhaMEsxCzAJBgNVBAYTAkRFMRMwEQYDVQQKEwpERk4tVmVyZWluMRAw\nDgYDVQQLEwdERk4tUEtJMRUwEwYDVQQDEwxzcC5hc2tuZXQuZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC+n8aGXU8eGT0HeiRTnXASUoTstkWzkkhL\nLOEGblTGhO7cMFbJM/g/kOdUIIRi0dzhan8UdAKkeqtWnUpf2vgKfu/f97mwfpT7\nqKbN2LvX1VoQXtpmCwkf477fKXsaiHojRxx87/zfURJRUQK9fDeO7k1r3iTzSLJO\n7lEDIQVeezplT1MhzOYPdS8sUaCJogPgvYBZ+mPjpA8SYx6Rq5mtlDZGUII951Uh\nInrCCgmk0WpIxclL1IHdNqy3FOv1XSDS0k+KBQQnu/FpxhInUm1lILXfV2IkTvnn\nHcTJFh6/5Ojk8sOEh0vaBB2Q1ncJsrR0NWCBlgLfSdhX5zXmeFmtAgMBAAGjggHa\nMIIB1jAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcD\nAgYIKwYBBQUHAwEwHQYDVR0OBBYEFNVU8a0BOqrMQNKc91DuHripAe3nMB8GA1Ud\nIwQYMBaAFB2p8YYmdk3PXf1Qo27r8bwidW3rMBwGA1UdEQQVMBOBEWNlcnRhZG1A\nYXNrbmV0LmRlMIGRBgNVHR8EgYkwgYYwQaA/oD2GO2h0dHA6Ly9jZHAxLnBjYS5k\nZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEGgP6A9\nhjtodHRwOi8vY2RwMi5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9wdWIv\nY3JsL2NhY3JsLmNybDCBqgYIKwYBBQUHAQEEgZ0wgZowSwYIKwYBBQUHMAKGP2h0\ndHA6Ly9jZHAxLnBjYS5kZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDBLBggrBgEFBQcwAoY/aHR0cDovL2NkcDIucGNhLmRmbi5k\nZS9nbG9iYWwtc2VydmljZXMtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqG\nSIb3DQEBBQUAA4IBAQAmucftP9132NU6iIByTjBoup1At2Nj0NeA+vE7Tg3iHBZh\nyWGxTsCVCHLSzDi8RpQKnnov1wsJ/Z7JCyd+C292zIFoUamliYVJKcTJtCOLmCkq\nwGLbbYq8CK8Tlv5BaWaleiNVaBxx1At7QT7PnV/YF9dPR3tQKP5vLYtPARAexbcV\nfKsNZP13cjxUMSmHBTgMLgpegD8btC7KcdKbO9xcLPz8A8ge00NElX53dqVGH83z\nRaTY5YqsKUIDh0mx2UxjFV9irG5X/QE6YCt0tBZtjaE7b9cHapIL9BZDRE7aRGDt\nrWoZ1ruqB2jP59EBdg4sTfzhvlLtUdL3H3aUimlg", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.asknet.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.asknet.de/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.asknet.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.asknet.de/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.asknet.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.asknet.de/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://unitcf.se/shibboleth", 
    {
      "entity_id": "https://unitcf.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://unitcf.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://unitcf.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://unitcf.se/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "unitcf.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=unitcf.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC7TCCAdWgAwIBAgIJAPLtJRFIh63tMA0GCSqGSIb3DQEBBQUAMBQxEjAQBgNV\nBAMTCXVuaXRjZi5zZTAeFw0xMDA1MjYyMDI1MzZaFw0yMDA1MjMyMDI1MzZaMBQx\nEjAQBgNVBAMTCXVuaXRjZi5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAK4QYuhlDS3lqTEx/GMTYbcXm26G1r8bQJy31fW873gWXsB+WLOv9WPXNjBM\nR/WOli0VgSMesjliHSv9BwBQ8J0rLHD3snvj/yp3aHAvBFdElw1GK3+DrK8JN34X\npgl1KPBzmsS8lwYyyoZYCfmCxrczKs1ZIa3YBuOWLmxFh5P2TS1oaqdwlxQ+N8Xp\nXvv29rMpn5GsSjd8Ue1In2rHO0+4+oewiyQ0SKBpMSiNjxC5c50gT1dpeK2XUZLI\novvTWIPJuUzLX6b7Ft0gEw/kwvcDlVl/C/GNqOtEVPsD/mp03/eVVZVISpj7AUP1\nl7rli6ep61P5ccxH60HjaxzknyECAwEAAaNCMEAwHwYDVR0RBBgwFoIJdW5pdGNm\nLnNlhgl1bml0Y2Yuc2UwHQYDVR0OBBYEFDoYivNyzl6FLDkqruQ/1XAUQBOhMA0G\nCSqGSIb3DQEBBQUAA4IBAQCN10PiM/GBO8l9cArV3pSiuy/T1nTVEHF8cbiwzauM\nZq1dkTh52ccMeeIFItqGZ5c6IxM/KYJhGCrPw8IfICrVe2h+iLdKfu3nI8KgYIc8\nIYvoxNXSPTHiGAA5E1l2MyxAjkP89dUZgnTposoErzmFfsAas+YU28PuIFtB9E4H\nwkGECUu1qorOSdf5XxpxOLootvH6e06In5RLJR5M7Be8uBHDsJPs+w2/TqFmfu8n\nSUnwp5njZX1iqAiERi1qmNuxK4CgeQbaGUqdAngBmO560yd8gaxWcKKSPB1xyZk7\nIGfIdN4NBcMSvwweZYGgdB368AlQ5QP/h0xigpr/VCZG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "unitcf.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=unitcf.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC7TCCAdWgAwIBAgIJAPLtJRFIh63tMA0GCSqGSIb3DQEBBQUAMBQxEjAQBgNV\nBAMTCXVuaXRjZi5zZTAeFw0xMDA1MjYyMDI1MzZaFw0yMDA1MjMyMDI1MzZaMBQx\nEjAQBgNVBAMTCXVuaXRjZi5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAK4QYuhlDS3lqTEx/GMTYbcXm26G1r8bQJy31fW873gWXsB+WLOv9WPXNjBM\nR/WOli0VgSMesjliHSv9BwBQ8J0rLHD3snvj/yp3aHAvBFdElw1GK3+DrK8JN34X\npgl1KPBzmsS8lwYyyoZYCfmCxrczKs1ZIa3YBuOWLmxFh5P2TS1oaqdwlxQ+N8Xp\nXvv29rMpn5GsSjd8Ue1In2rHO0+4+oewiyQ0SKBpMSiNjxC5c50gT1dpeK2XUZLI\novvTWIPJuUzLX6b7Ft0gEw/kwvcDlVl/C/GNqOtEVPsD/mp03/eVVZVISpj7AUP1\nl7rli6ep61P5ccxH60HjaxzknyECAwEAAaNCMEAwHwYDVR0RBBgwFoIJdW5pdGNm\nLnNlhgl1bml0Y2Yuc2UwHQYDVR0OBBYEFDoYivNyzl6FLDkqruQ/1XAUQBOhMA0G\nCSqGSIb3DQEBBQUAA4IBAQCN10PiM/GBO8l9cArV3pSiuy/T1nTVEHF8cbiwzauM\nZq1dkTh52ccMeeIFItqGZ5c6IxM/KYJhGCrPw8IfICrVe2h+iLdKfu3nI8KgYIc8\nIYvoxNXSPTHiGAA5E1l2MyxAjkP89dUZgnTposoErzmFfsAas+YU28PuIFtB9E4H\nwkGECUu1qorOSdf5XxpxOLootvH6e06In5RLJR5M7Be8uBHDsJPs+w2/TqFmfu8n\nSUnwp5njZX1iqAiERi1qmNuxK4CgeQbaGUqdAngBmO560yd8gaxWcKKSPB1xyZk7\nIGfIdN4NBcMSvwweZYGgdB368AlQ5QP/h0xigpr/VCZG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://unitcf.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://unitcf.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/unitcf.se.xml"
      }
    }
  ], 
  [
    "https://terena.org/sp", 
    {
      "entity_id": "https://terena.org/sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-externals-2.0/terena.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "TERENA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "TERENA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.terena.org/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "TERENA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "aai@terena.org", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "AAI team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml2-logout.php/default-sp"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml1-acs.php/default-sp"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml2-acs.php/default-sp"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://login.terena.org/wayf/module.php/saml/sp/saml1-acs.php/default-sp/artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "TERENA Service Provider Proxy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "description": [
                  {
                    "lang": "en", 
                    "text": "A Service Provider Proxy for all TERENA Federated Services", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "https://confluence.terena.org/display/aai/Service+Provider+Proxy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.terena.org/p3p", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "logo": [
                  {
                    "text": "https://www.terena.org/gfx/terena_logo_slogan_rgb-350x97.png", 
                    "width": "350", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "94"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEkjCCA3qgAwIBAgIJAL90CxMEVb/kMA0GCSqGSIb3DQEBBQUAMIGMMQswCQYDVQQGEwJOTDELMAkGA1UECBMCTkgxEjAQBgNVBAcTCUFtc3RlcmRhbTEPMA0GA1UEChMGVEVSRU5BMQwwCgYDVQQLEwNJVFMxHjAcBgNVBAMTFWh0dHBzOi8vdGVyZW5hLm9yZy9zcDEdMBsGCSqGSIb3DQEJARYOYWFpQHRlcmVuYS5vcmcwHhcNMTEwMTEyMTUyNjM4WhcNMjEwMTExMTUyNjM4WjCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwTxx8JBWSpBJiZgdvGOJDXLwaE29Opx1CBbIrYHm47Oy4btsf0BzCmfdSPDlydDm6//355hsQU8BgIh/waEwFZZCg/XyzrJEXCDTZBm1H210aT7FNp356azqKOO1bYWcku0xpFOWWf3jCIkjtOiTkbl12Tw7Y+zJRhV2+jleC5td3JxZ6k1qotgN+1cGwZ2Tv2HhSNeMC4QsGOyBqeP+7B1CLFqFZSiLWGVqcZi0fGkXf+SrTSEH/kLzdciEg2EePyQPcLCKNz9RiIhSmsLE/Rr1ksOvZGmyWFe7YsPyJOLsNyYcZTufDVwpl9fDuJdYy2GdMT1kSNNOpZXZ7QcgYwIDAQABo4H0MIHxMB0GA1UdDgQWBBQ6tVqjpKC8+30XF/qWlaZ3fUKTvDCBwQYDVR0jBIG5MIG2gBQ6tVqjpKC8+30XF/qWlaZ3fUKTvKGBkqSBjzCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnggkAv3QLEwRVv+QwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAn+06i7zZE7MjuB68gCaNvnCkrgfumi4PWiP6kaE6+LU2MTbxdFyoSAoKh6Ft9TDi+8ANAsn5jRQ5xLUE4YoVbub/KufMwdlX0zO9i+Q//npDTFESnWsiMi7DHg/av1LtzrYYZvE2E1e5c/7wo/axx8Bk7qsE9YXFRs372vDkDwOGSkLbRtgwdCUX47CE/fXvccPDHH217XMed2cVOGFjQgidsFZlJbSfSvQjWYw5LIE0wo9RtsEu5I3WAIar8Wr6/nhVOgIBUStpcw94GwlPxLywfij5CJ9HT+sN2SOj4YmKPBtcwHI75uNZp7XRy85jRjrvhahg5baIQ0u3aL8aMA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEkjCCA3qgAwIBAgIJAL90CxMEVb/kMA0GCSqGSIb3DQEBBQUAMIGMMQswCQYDVQQGEwJOTDELMAkGA1UECBMCTkgxEjAQBgNVBAcTCUFtc3RlcmRhbTEPMA0GA1UEChMGVEVSRU5BMQwwCgYDVQQLEwNJVFMxHjAcBgNVBAMTFWh0dHBzOi8vdGVyZW5hLm9yZy9zcDEdMBsGCSqGSIb3DQEJARYOYWFpQHRlcmVuYS5vcmcwHhcNMTEwMTEyMTUyNjM4WhcNMjEwMTExMTUyNjM4WjCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwTxx8JBWSpBJiZgdvGOJDXLwaE29Opx1CBbIrYHm47Oy4btsf0BzCmfdSPDlydDm6//355hsQU8BgIh/waEwFZZCg/XyzrJEXCDTZBm1H210aT7FNp356azqKOO1bYWcku0xpFOWWf3jCIkjtOiTkbl12Tw7Y+zJRhV2+jleC5td3JxZ6k1qotgN+1cGwZ2Tv2HhSNeMC4QsGOyBqeP+7B1CLFqFZSiLWGVqcZi0fGkXf+SrTSEH/kLzdciEg2EePyQPcLCKNz9RiIhSmsLE/Rr1ksOvZGmyWFe7YsPyJOLsNyYcZTufDVwpl9fDuJdYy2GdMT1kSNNOpZXZ7QcgYwIDAQABo4H0MIHxMB0GA1UdDgQWBBQ6tVqjpKC8+30XF/qWlaZ3fUKTvDCBwQYDVR0jBIG5MIG2gBQ6tVqjpKC8+30XF/qWlaZ3fUKTvKGBkqSBjzCBjDELMAkGA1UEBhMCTkwxCzAJBgNVBAgTAk5IMRIwEAYDVQQHEwlBbXN0ZXJkYW0xDzANBgNVBAoTBlRFUkVOQTEMMAoGA1UECxMDSVRTMR4wHAYDVQQDExVodHRwczovL3RlcmVuYS5vcmcvc3AxHTAbBgkqhkiG9w0BCQEWDmFhaUB0ZXJlbmEub3JnggkAv3QLEwRVv+QwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAn+06i7zZE7MjuB68gCaNvnCkrgfumi4PWiP6kaE6+LU2MTbxdFyoSAoKh6Ft9TDi+8ANAsn5jRQ5xLUE4YoVbub/KufMwdlX0zO9i+Q//npDTFESnWsiMi7DHg/av1LtzrYYZvE2E1e5c/7wo/axx8Bk7qsE9YXFRs372vDkDwOGSkLbRtgwdCUX47CE/fXvccPDHH217XMed2cVOGFjQgidsFZlJbSfSvQjWYw5LIE0wo9RtsEu5I3WAIar8Wr6/nhVOgIBUStpcw94GwlPxLywfij5CJ9HT+sN2SOj4YmKPBtcwHI75uNZp7XRy85jRjrvhahg5baIQ0u3aL8aMA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://login2.hs-mittweida.de/idp/shibboleth", 
    {
      "entity_id": "https://login2.hs-mittweida.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/login2.hs-mittweida.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login2.hs-mittweida.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login2.hs-mittweida.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login2.hs-mittweida.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-mittweida.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login2.hs-mittweida.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-mittweida.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login2.hs-mittweida.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login2.hs-mittweida.de,O=Hochschule Mittweida (FH) - University of Applied Sciences,L=Mittweida,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFiTCCBHGgAwIBAgIEDR0M3jANBgkqhkiG9w0BAQUFADCBpjELMAkGA1UEBhMC\nREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlkYTFDMEEGA1UE\nChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNpdHkgb2YgQXBw\nbGllZCBTY2llbmNlczEQMA4GA1UEAxMHSFRXTSBDQTEaMBgGCSqGSIb3DQEJARYL\ncGtpQGh0d20uZGUwHhcNMDgxMDIxMDgxNDA3WhcNMTMxMDIwMDgxNDA3WjCBmTEL\nMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEjAQBgNVBAcTCU1pdHR3ZWlk\nYTFDMEEGA1UEChM6SG9jaHNjaHVsZSBNaXR0d2VpZGEgKEZIKSAtIFVuaXZlcnNp\ndHkgb2YgQXBwbGllZCBTY2llbmNlczEfMB0GA1UEAxMWbG9naW4yLmhzLW1pdHR3\nZWlkYS5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKYgPFWH0AnT\nCh9RD41shYVlrsyiay80CEumGXqLkW+uGlRa5DaxJUmFCrOUoj2ond31l/PLSA3D\n/UuJo1mFGSX8T19xKTUZAaKgLE14dxwukbxjjX27y0nK7VfMxoLmTAgWS0AMdIue\nSl7MRgqSXCg3wwuKQphHhcYPl2uDPQK/Yv8U6d0zlAnr/eiwFk4scz2/PgE8Ts+N\nQ4z6g83VNQKlSqGa+ExZ7Np0VjD51AXrNynVISaBoXtJfjFkwOvV3DaFooV5e4NC\n56Gx3GabqG89s85aDGzkB43WVTzScO5FGBMOQsYfO6kzyUwp1VUCj3DJtueTRWPU\nnlBcDFjN7NsCAwEAAaOCAcgwggHEMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0G\nA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUirW4438b5lTj\nrX6ByfHLGB/jJzQwHwYDVR0jBBgwFoAUthDQcSc/RbN2Lii4Ib5AORnredgwFgYD\nVR0RBA8wDYELcGtpQGh0d20uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2NybC9jYWNybC5j\ncmwwPqA8oDqGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHMtbWl0dHdlaWRhLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcw\nAoY8aHR0cDovL2NkcDEucGNhLmRmbi5kZS9ocy1taXR0d2VpZGEtY2EvcHViL2Nh\nY2VydC9jYWNlcnQuY3J0MEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZu\nLmRlL2hzLW1pdHR3ZWlkYS1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZI\nhvcNAQEFBQADggEBAAGcArobqCHlzG8GO5wWaAS+mLqjWBLbROftIBz2xAj6FcyH\nYDixCT16/Zgt/H6+KUaHxnIQ5vPf9QSJTYMDqtr/WdS8FOPXovFT3mKQunAP+SgG\nqcadVUu9hZ6c9q8BsTIf+jY/G2WQX7LgNQ03JfAomdaQEhmGYqrHoQMCFCN3CLb/\n7t1/xH96cStRITB2nN9liEwTRLrGEc9XMAFM0lgjj+o7M/f9xfzagWw5HfYzjHte\nPAloYirtXrNJfNjAdtSpX6D8uq4TKtLwWVAuu3RsJwqMLjABQsyDJV2xXnYoJoy5\n+NSkVBR/TI4nZCwb990PUBiK5mAszI7kxISvEcg=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Hochschule Mittweida - University of Applied Sciences", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Hochschule Mittweida", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hs-mittweida.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Matthias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "luehr@hs-mittweida.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "L\u00fchr", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Jens", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "rabe@hs-mittweida.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Rabe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://www-fr.redi-bw.de", 
    {
      "entity_id": "https://www-fr.redi-bw.de", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www-fr.redi-bw.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "ReDI Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-freiburg.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Hans-Adolf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ruppert@ub.uni-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Ruppert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "ReDI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "info@redi-bw.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SLO/SOAP"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/SAML/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/NIM/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www-fr.redi-bw.de/Shibboleth.sso/NIM/SOAP"
            }
          ], 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www-fr.redi-bw.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=info@redi-bw.de,CN=www-fr.redi-bw.de,OU=Universitaetsbibliothek,O=Universitaet Freiburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFZzCCBE+gAwIBAgIEC0b00TANBgkqhkiG9w0BAQUFADCBhjELMAkGA1UEBhMC\nREUxHjAcBgNVBAoTFVVuaXZlcnNpdGFldCBGcmVpYnVyZzEWMBQGA1UECxMNUmVj\naGVuemVudHJ1bTEYMBYGA1UEAxMPVW5pLUZSIENBIC0gRzAyMSUwIwYJKoZIhvcN\nAQkBFhZwa2lAcnoudW5pLWZyZWlidXJnLmRlMB4XDTA3MTAzMDE4MjYxMFoXDTEy\nMTAyODE4MjYxMFowgYsxCzAJBgNVBAYTAkRFMR4wHAYDVQQKExVVbml2ZXJzaXRh\nZXQgRnJlaWJ1cmcxIDAeBgNVBAsTF1VuaXZlcnNpdGFldHNiaWJsaW90aGVrMRow\nGAYDVQQDExF3d3ctZnIucmVkaS1idy5kZTEeMBwGCSqGSIb3DQEJARYPaW5mb0By\nZWRpLWJ3LmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6jxBBaez\nyk+N8nQIDnifDR4br5D5zmQD3uF7oos01/lHBEfmNR+fj5qucgfxGAyecy74aFZ7\np82QW6I01IOsqBphcNOsOihS16Bb5F3euq2LCUEmWiLsCYJOYhlZHZZRkSpzf0U1\nwNWjqYAXsT6T5TY+/9NPpAlIcNzxekZN/8VBXIPb2zxn7/KJwEY6Cow053XY0f4z\nBjRWPmnD7LV83MYrR3IOQQtRNQdtHJkMmN5L0IBUqI0cIqBMwNh7rdBXfkPWtWYl\nFb9aCZ6RVdenuH6ek+KKfv6/M67Y+TS31GudIbdddzL+raA9/nwex9Y29hE2sg1+\n8o72bnYyvEuyxwIDAQABo4IB1DCCAdAwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAw\nHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBTNbO30k/O3\nucEvGfqHiWE5jGi8fDAfBgNVHSMEGDAWgBQzZ6nW8ZNVNqyhMr3B5JY5/0xwMTAa\nBgNVHREEEzARgQ9pbmZvQHJlZGktYncuZGUwgY8GA1UdHwSBhzCBhDBAoD6gPIY6\naHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktZnJlaWJ1cmctY2EvcHViL2NybC9n\nX2NhY3JsLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS91bmktZnJl\naWJ1cmctY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZswgZgw\nSgYIKwYBBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdW5pLWZyZWlidXJn\nLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRwOi8v\nY2RwMi5wY2EuZGZuLmRlL3VuaS1mcmVpYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2Fj\nZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAYw9Q8c0vbIGm+B9qKv9zJGaulzsx\nnftJFaYxEpPsiTOBRmaL2Q4dXxgzUEgKyD98DxaZ+Jzz4LHa1ELwa3KS9ZUmOMQ3\nJ52NKhsaqCUU/8NTISXf8ebCAKTkK+IjjrlEd3TIq7OwW60IUz7eSLMr/WdxbUFT\nLq2Ex1DtuGQXMYv/YV3ky4Ci9lnAQkQ4aogfF5CH941sh8Qqd7iA9fAlCbYd2Vmh\nx7P4PILIaPEEHYBxetPmOeOiOEMm3DtsmqXK7XKQeR3opiJxY+xFP7EVid3M0B/+\nyGu46kaBjuW692bV3nPlvetlri3mceGe3/wc5hkfhsSbEsB+JflUsFjVIA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www-fr.redi-bw.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=info@redi-bw.de,CN=www-fr.redi-bw.de,OU=Universitaetsbibliothek,O=Universitaet Freiburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFZzCCBE+gAwIBAgIEC0b00TANBgkqhkiG9w0BAQUFADCBhjELMAkGA1UEBhMC\nREUxHjAcBgNVBAoTFVVuaXZlcnNpdGFldCBGcmVpYnVyZzEWMBQGA1UECxMNUmVj\naGVuemVudHJ1bTEYMBYGA1UEAxMPVW5pLUZSIENBIC0gRzAyMSUwIwYJKoZIhvcN\nAQkBFhZwa2lAcnoudW5pLWZyZWlidXJnLmRlMB4XDTA3MTAzMDE4MjYxMFoXDTEy\nMTAyODE4MjYxMFowgYsxCzAJBgNVBAYTAkRFMR4wHAYDVQQKExVVbml2ZXJzaXRh\nZXQgRnJlaWJ1cmcxIDAeBgNVBAsTF1VuaXZlcnNpdGFldHNiaWJsaW90aGVrMRow\nGAYDVQQDExF3d3ctZnIucmVkaS1idy5kZTEeMBwGCSqGSIb3DQEJARYPaW5mb0By\nZWRpLWJ3LmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6jxBBaez\nyk+N8nQIDnifDR4br5D5zmQD3uF7oos01/lHBEfmNR+fj5qucgfxGAyecy74aFZ7\np82QW6I01IOsqBphcNOsOihS16Bb5F3euq2LCUEmWiLsCYJOYhlZHZZRkSpzf0U1\nwNWjqYAXsT6T5TY+/9NPpAlIcNzxekZN/8VBXIPb2zxn7/KJwEY6Cow053XY0f4z\nBjRWPmnD7LV83MYrR3IOQQtRNQdtHJkMmN5L0IBUqI0cIqBMwNh7rdBXfkPWtWYl\nFb9aCZ6RVdenuH6ek+KKfv6/M67Y+TS31GudIbdddzL+raA9/nwex9Y29hE2sg1+\n8o72bnYyvEuyxwIDAQABo4IB1DCCAdAwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAw\nHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBTNbO30k/O3\nucEvGfqHiWE5jGi8fDAfBgNVHSMEGDAWgBQzZ6nW8ZNVNqyhMr3B5JY5/0xwMTAa\nBgNVHREEEzARgQ9pbmZvQHJlZGktYncuZGUwgY8GA1UdHwSBhzCBhDBAoD6gPIY6\naHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktZnJlaWJ1cmctY2EvcHViL2NybC9n\nX2NhY3JsLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS91bmktZnJl\naWJ1cmctY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZswgZgw\nSgYIKwYBBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdW5pLWZyZWlidXJn\nLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRwOi8v\nY2RwMi5wY2EuZGZuLmRlL3VuaS1mcmVpYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2Fj\nZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAYw9Q8c0vbIGm+B9qKv9zJGaulzsx\nnftJFaYxEpPsiTOBRmaL2Q4dXxgzUEgKyD98DxaZ+Jzz4LHa1ELwa3KS9ZUmOMQ3\nJ52NKhsaqCUU/8NTISXf8ebCAKTkK+IjjrlEd3TIq7OwW60IUz7eSLMr/WdxbUFT\nLq2Ex1DtuGQXMYv/YV3ky4Ci9lnAQkQ4aogfF5CH941sh8Qqd7iA9fAlCbYd2Vmh\nx7P4PILIaPEEHYBxetPmOeOiOEMm3DtsmqXK7XKQeR3opiJxY+xFP7EVid3M0B/+\nyGu46kaBjuW692bV3nPlvetlri3mceGe3/wc5hkfhsSbEsB+JflUsFjVIA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://db.ub.uni-stuttgart.de", 
    {
      "entity_id": "https://db.ub.uni-stuttgart.de", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/db.ub.uni-stuttgart.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Stuttgart", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4tsbibliothek Stuttgart", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-stuttgart.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ralf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ralf.engelmann@ub.uni-stuttgart.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Engelmann", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Ralf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ralf.engelmann@ub.uni-stuttgart.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Engelmann", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://db.ub.uni-stuttgart.de/Shibboleth.shire"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://db.ub.uni-stuttgart.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://db.ub.uni-stuttgart.de/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "db.ub.uni-stuttgart.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=db.ub.uni-stuttgart.de,OU=Universitaetsbibliothek,O=Universitaet Stuttgart,L=Stuttgart,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFbDCCBFSgAwIBAgIEDB2VKDANBgkqhkiG9w0BAQUFADCBlDELMAkGA1UEBhMC\nREUxEjAQBgNVBAcTCVN0dXR0Z2FydDEfMB0GA1UEChMWVW5pdmVyc2l0YWV0IFN0\ndXR0Z2FydDEoMCYGA1UEAxMfVW5pdmVyc2l0YWV0IFN0dXR0Z2FydCBDQSAtIEcw\nMTEmMCQGCSqGSIb3DQEJARYXY2EtZzAxQHVuaS1zdHV0dGdhcnQuZGUwHhcNMDgw\nNDEwMTMzNTIxWhcNMTMwNDA5MTMzNTIxWjCBojELMAkGA1UEBhMCREUxGzAZBgNV\nBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJU3R1dHRnYXJ0MR8wHQYD\nVQQKExZVbml2ZXJzaXRhZXQgU3R1dHRnYXJ0MSAwHgYDVQQLExdVbml2ZXJzaXRh\nZXRzYmlibGlvdGhlazEfMB0GA1UEAxMWZGIudWIudW5pLXN0dXR0Z2FydC5kZTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKwE50dOQQkZznyAAfZEINPH\nhaepUOZgEqAAHDjKEbxVg3WLZKg9CPQ8k1+nWxV8ZomJzXbw+kx1v7NPKdNPXBNw\nqmt6aQAiJHcUtzMGlfGI1YDrC/p0zFmjtno+a++sRSVgfBrSQME7JQ8CPVreSa20\n0MDsWR/OOdzVZo47PhzDYyOiABa/CEiU1k51zciw3XpbEnMqKwZ2tNxX++zgvhyg\nn5MhITT88Lukmz92XF0JyEeNJWE0Q0AKcS6V6A+jKQznEXpQ88c2Zit44z3bJM/9\na9RBlMQ+CuPSuf7aznUY3AOysD5jWlvpJfDC2mMg3KTC1RNTuaoYmtBjJW0Nnj0C\nAwEAAaOCAbQwggGwMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG\nCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUtB7lnAegYLLmVzFpTp8/Lymc\nR0UwHwYDVR0jBBgwFoAUva0nWiw3zw1EH3Iaqrc3mREuAgQwgY0GA1UdHwSBhTCB\ngjA/oD2gO4Y5aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktc3R1dHRnYXJ0LWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMD+gPaA7hjlodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NybC9jYWNybC5jcmwwgaYGCCsGAQUFBwEB\nBIGZMIGWMEkGCCsGAQUFBzAChj1odHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1z\ndHV0dGdhcnQtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MEkGCCsGAQUFBzAChj1o\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCjpYUB2mqfLUpU7uke8uvu\n3b6W/lDX8N54gmmdPfvjYF5ASmXdIdH64P6bspBPfqBajj0RfWflgGO85givR98w\neVT2uqYrXKDIVknHs6/2SqolgcEkSSIUZwiGn4aNuV7BVcTB0bon6O+QJNUz/Ju8\nKG81dktd/OYbDq/yABvrWa2yvbroHwJZj9fydBBFvaT2l1KHv6NVauLXAqYyhDF8\nTkkerRdtxkOOv2vskPFo2HwZ0MZ/S9c5BJwKs0hGklHvT8/cnzAm1tO9TD8jG+9+\nc1GXBwlpyqeX1oyjmAwFsCP0IXVzw11n7BtSjylDJKYARAlw+qtCibuS9S+6oYQ2", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "db.ub.uni-stuttgart.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=db.ub.uni-stuttgart.de,OU=Universitaetsbibliothek,O=Universitaet Stuttgart,L=Stuttgart,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFbDCCBFSgAwIBAgIEDB2VKDANBgkqhkiG9w0BAQUFADCBlDELMAkGA1UEBhMC\nREUxEjAQBgNVBAcTCVN0dXR0Z2FydDEfMB0GA1UEChMWVW5pdmVyc2l0YWV0IFN0\ndXR0Z2FydDEoMCYGA1UEAxMfVW5pdmVyc2l0YWV0IFN0dXR0Z2FydCBDQSAtIEcw\nMTEmMCQGCSqGSIb3DQEJARYXY2EtZzAxQHVuaS1zdHV0dGdhcnQuZGUwHhcNMDgw\nNDEwMTMzNTIxWhcNMTMwNDA5MTMzNTIxWjCBojELMAkGA1UEBhMCREUxGzAZBgNV\nBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJU3R1dHRnYXJ0MR8wHQYD\nVQQKExZVbml2ZXJzaXRhZXQgU3R1dHRnYXJ0MSAwHgYDVQQLExdVbml2ZXJzaXRh\nZXRzYmlibGlvdGhlazEfMB0GA1UEAxMWZGIudWIudW5pLXN0dXR0Z2FydC5kZTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKwE50dOQQkZznyAAfZEINPH\nhaepUOZgEqAAHDjKEbxVg3WLZKg9CPQ8k1+nWxV8ZomJzXbw+kx1v7NPKdNPXBNw\nqmt6aQAiJHcUtzMGlfGI1YDrC/p0zFmjtno+a++sRSVgfBrSQME7JQ8CPVreSa20\n0MDsWR/OOdzVZo47PhzDYyOiABa/CEiU1k51zciw3XpbEnMqKwZ2tNxX++zgvhyg\nn5MhITT88Lukmz92XF0JyEeNJWE0Q0AKcS6V6A+jKQznEXpQ88c2Zit44z3bJM/9\na9RBlMQ+CuPSuf7aznUY3AOysD5jWlvpJfDC2mMg3KTC1RNTuaoYmtBjJW0Nnj0C\nAwEAAaOCAbQwggGwMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG\nCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUtB7lnAegYLLmVzFpTp8/Lymc\nR0UwHwYDVR0jBBgwFoAUva0nWiw3zw1EH3Iaqrc3mREuAgQwgY0GA1UdHwSBhTCB\ngjA/oD2gO4Y5aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktc3R1dHRnYXJ0LWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMD+gPaA7hjlodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NybC9jYWNybC5jcmwwgaYGCCsGAQUFBwEB\nBIGZMIGWMEkGCCsGAQUFBzAChj1odHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1z\ndHV0dGdhcnQtY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MEkGCCsGAQUFBzAChj1o\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1zdHV0dGdhcnQtY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCjpYUB2mqfLUpU7uke8uvu\n3b6W/lDX8N54gmmdPfvjYF5ASmXdIdH64P6bspBPfqBajj0RfWflgGO85givR98w\neVT2uqYrXKDIVknHs6/2SqolgcEkSSIUZwiGn4aNuV7BVcTB0bon6O+QJNUz/Ju8\nKG81dktd/OYbDq/yABvrWa2yvbroHwJZj9fydBBFvaT2l1KHv6NVauLXAqYyhDF8\nTkkerRdtxkOOv2vskPFo2HwZ0MZ/S9c5BJwKs0hGklHvT8/cnzAm1tO9TD8jG+9+\nc1GXBwlpyqeX1oyjmAwFsCP0IXVzw11n7BtSjylDJKYARAlw+qtCibuS9S+6oYQ2", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://filesender.funet.fi", 
    {
      "entity_id": "https://filesender.funet.fi", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/filesender.funet.fi.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.csc.fi/english/institutions/haka/instructions/join/eduGAINRegistrationStatement/", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://www.csc.fi/haka"
          }, 
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.edugain.org/dataprotection/coc-eu-01-draft", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "fi", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "sv", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "is_default": "true", 
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://filesender.funet.fi/simplesaml/module.php/saml/sp/saml2-acs.php/SP"
            }, 
            {
              "is_default": "false", 
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://filesender.funet.fi/simplesaml/module.php/saml/sp/saml2-acs.php/SP"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://filesender.funet.fi/simplesaml/module.php/saml/disco.php"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "fi", 
                    "text": "https://filesender.funet.fi/privacypolicy.html", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }, 
                  {
                    "lang": "en", 
                    "text": "https://filesender.funet.fi/privacypolicy.html", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "fi", 
                    "text": "Funet FileSender", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "sv", 
                    "text": "Funet FileSender", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Funet FileSender", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "sv", 
                    "text": "Funet FileSender erbjuder en l\u00e4tt och s\u00e4ker s\u00e4tt att dela stora datafilar till vem som helst.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "Funet FileSender tarjoaa helpon ja turvallisen tavan jakaa suuria tiedostoja.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "en", 
                    "text": "Funet FileSender offers an easy and a secure way to share large files with anyone.", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_name": [
                {
                  "lang": "fi", 
                  "text": "Funet FileSender", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "en", 
                  "text": "Funet FileSender", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "sv", 
                  "text": "Funet FileSender", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "is_default": "true", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "is_required": "true", 
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_description": [
                {
                  "lang": "fi", 
                  "text": "Funet FileSender tarjoaa helpon ja turvallisen tavan jakaa suuria tiedostoja.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "en", 
                  "text": "Funet FileSender offers an easy and a secure way to share large files with anyone.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "sv", 
                  "text": "Funet FileSender erbjuder en latt och saker satt att dela stora datafilar till vem som helst.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE2TCCA8GgAwIBAgIQX2leAqJlB3Q/3iPF8QljNTANBgkqhkiG9w0BAQUFADA2\nMQswCQYDVQQGEwJOTDEPMA0GA1UEChMGVEVSRU5BMRYwFAYDVQQDEw1URVJFTkEg\nU1NMIENBMB4XDTEyMDYyNjAwMDAwMFoXDTE1MDYyNjIzNTk1OVowgbAxCzAJBgNV\nBAYTAkZJMQ4wDAYDVQQREwUwMjEwMTEQMA4GA1UECBMHdXVzaW1hYTEOMAwGA1UE\nBxMFRXNwb28xFjAUBgNVBAkTDUtlaWxhcmFudGEgMTQxKTAnBgNVBAoTIENTQyAt\nIElUIENlbnRlciBmb3IgU2NpZW5jZSBMdGQuMQ4wDAYDVQQLEwVGVU5FVDEcMBoG\nA1UEAxMTZmlsZXNlbmRlci5mdW5ldC5maTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAMZgasarh1nW+r5+zxxElcXiJm7oQVBGDSVwlkZr+7Op8NvdG+Hg\nqC3r64lrmNUgI6LgQ56BH0lDZCdWmH1r4IWmps+VUHEyRb83uDNis+61wnyPW2+k\n0O7JCygTwvltycl4Iw6eaPxERHhgV27r85jMJQbeLMaN+oNZ2HgLEAK8mnksa+IS\nVYULX9ybvh/0YrqfKvhs3bO0fNP9IvUj3HVGCOu5lxHSrZWG5ppmxrVZcRbTYyfz\nPcU5xp0wpvNKju8NQhPlpOhmtvaC8zEDDiRGGG5BTLBc/dMz7gExcjFRh7uUFImx\nkaQBMgbC4Q1PEAfc1HW4dCXH63rTvx7+yNECAwEAAaOCAWYwggFiMB8GA1UdIwQY\nMBaAFAy9k2gM896ro0lrKzdXR+qQ47ntMB0GA1UdDgQWBBS0whoofsD3sLHsJarO\nfwv9F9uGyzAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/BAIwADAdBgNVHSUEFjAU\nBggrBgEFBQcDAQYIKwYBBQUHAwIwGAYDVR0gBBEwDzANBgsrBgEEAbIxAQICHTA6\nBgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnRjcy50ZXJlbmEub3JnL1RFUkVO\nQVNTTENBLmNybDBtBggrBgEFBQcBAQRhMF8wNQYIKwYBBQUHMAKGKWh0dHA6Ly9j\ncnQudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3J0MCYGCCsGAQUFBzABhhpo\ndHRwOi8vb2NzcC50Y3MudGVyZW5hLm9yZzAeBgNVHREEFzAVghNmaWxlc2VuZGVy\nLmZ1bmV0LmZpMA0GCSqGSIb3DQEBBQUAA4IBAQCo97bKpkoqXDVVfg868CNBrSYi\n1bWlUGH732ijBmo3CIDV08G5Q7/0hejeKKTJfw02XNAxHBjatcB9umyuZUKa2Xf/\nFq9C5c4z3aH1DOpUaVDzRr3gKxEloP0iJfp/jR00cs8hNKw0Lzw/dXVIQ+ObT1B7\n4Qm4RJUOIO/yHNqLvs0QRhYCnonyfUN5Hg5RA0hGwBXJzLZpVYG4yNVYEuSS47BA\nNuSoiRuRqUwvjh1crrpK3aEPzrhwALKEQo0tIKOpSHjVUwvGXWtoljY7JJJt94y1\no9pAScnCYOeqNoQ//wrcSVQcwozZLhGlymlLAyDI0rx/hM9v+8PL1E0iFmf/", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Harri", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "funyht@csc.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Kuusisto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Tomi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "noc@funet.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Salmi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Tomi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "noc@funet.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Salmi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://login.slub-dresden.de/idp/shibboleth", 
    {
      "entity_id": "https://login.slub-dresden.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/login.slub-dresden.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.slub-dresden.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "slub-dresden.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.slub-dresden.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "slub-dresden.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.slub-dresden.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.slub-dresden.de,OU=IT,O=Saechsische Landes-\\, Staats- und Universitaetsbibliothek Dresden,L=Dresden,ST=Sachsen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFejCCBGKgAwIBAgIEER82YjANBgkqhkiG9w0BAQUFADCBhTELMAkGA1UEBhMC\nREUxKDAmBgNVBAoTH1RlY2huaXNjaGUgVW5pdmVyc2l0YWV0IERyZXNkZW4xDDAK\nBgNVBAsTA1pJSDEcMBoGA1UEAxMTVFUgRHJlc2RlbiBDQSAtIEcwMjEgMB4GCSqG\nSIb3DQEJARYRcGtpQHR1LWRyZXNkZW4uZGUwHhcNMTAxMjA4MTY1NjUxWhcNMTUx\nMjA3MTY1NjUxWjCBqTELMAkGA1UEBhMCREUxEDAOBgNVBAgTB1NhY2hzZW4xEDAO\nBgNVBAcTB0RyZXNkZW4xSTBHBgNVBAoTQFNhZWNoc2lzY2hlIExhbmRlcy0sIFN0\nYWF0cy0gdW5kIFVuaXZlcnNpdGFldHNiaWJsaW90aGVrIERyZXNkZW4xCzAJBgNV\nBAsTAklUMR4wHAYDVQQDExVsb2dpbi5zbHViLWRyZXNkZW4uZGUwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDWvW+lzOJGBUl2VquB2WwwWdNabWSjkTcH\nfnSq2NT7V6/hhYIA051JeThS5riLRyPxCk6bpQt7vOl+v7+sh4pQnumaTt3uYibo\n4JHrHUko2zaNJ+62/5hZKtpSbYbSxUjwwTHv9ENbBZOdj7lxjiTf/xv/DQYXfuAn\nfjFnzJ46UfPNRiMXjICFwOX9pBX6Pvi+47JlirhChb8D6D0rX+cu6Yle7sYGDnHR\nRbAAx0atENk+fAYonpetFTF0mjOvvKlb99CMkTMi8h8viE2tLD1z+ds6xyCAk34y\nBzUakng0+ZZ3xuEK5LhkDJ9CRXSiqAmc2PpzqIcj07HgthGaXd7HAgMBAAGjggHK\nMIIBxjAJBgNVHRMEAjAAMAsGA1UdDwQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcD\nATAdBgNVHQ4EFgQUyKpSOjY02z3nvcEr+Pq2R6An10swHwYDVR0jBBgwFoAUxStT\nkxeDyfVGQu1Dat+2gKZH8uAwIgYDVR0RBBswGYEXbmllZGVybEBzbHViLWRyZXNk\nZW4uZGUwgYsGA1UdHwSBgzCBgDA+oDygOoY4aHR0cDovL2NkcDEucGNhLmRmbi5k\nZS90dS1kcmVzZGVuLWNhL3B1Yi9jcmwvZ19jYWNybC5jcmwwPqA8oDqGOGh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdHUtZHJlc2Rlbi1jYS9wdWIvY3JsL2dfY2Fjcmwu\nY3JsMIGkBggrBgEFBQcBAQSBlzCBlDBIBggrBgEFBQcwAoY8aHR0cDovL2NkcDEu\ncGNhLmRmbi5kZS90dS1kcmVzZGVuLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0\nMEgGCCsGAQUFBzAChjxodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWRyZXNkZW4t\nY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAI+A\n/aJshQD10aJl6Zmc7Kdo6DehIu8ev4v3AhTAnTlHdFDaM4Bn38DMzv2lTniRzxs4\ncsaCLtCArLzhDimZ4Co4t8fD7zAvfxMPK9KLdS+oGkD3jSuCNWeGYJlXieOarwI5\n7YnQZj2aJj/q/h67IN9EhO5TmSE8E91BoZDb/D1HFOnDtNmBWRl2YIDRAPbdYILi\ntlvGffPyCHqGDVPGr4/udHHoPLlX5xJOeUPsTqJWvyJH0dZ1QhotnXsZLB+1Zlgi\nRjBDLVfeKIoVbNUYlEvIqADoSO32kE60Ria8L84XZ/PRUIMyV7+0OjgatpQxMxQj\n+IJTcEjcKl3hPdIic+E=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "SLUB Dresden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "SLUB Dresden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.slub-dresden.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Falk", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "niederl@slub-dresden.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Niederlein", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://akino.hh.se/shibboleth", 
    {
      "entity_id": "https://akino.hh.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akino.hh.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "akino.hh.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=akino.hh.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC6DCCAdCgAwIBAgIJANFCVxC7y6BWMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNV\nBAMTC2FraW5vLmhoLnNlMB4XDTA5MTAyNzA4MjU1N1oXDTE5MTAyNTA4MjU1N1ow\nFjEUMBIGA1UEAxMLYWtpbm8uaGguc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQD2Y7TZAeEnPMmlwz3hoXDa/wFIRy6Bodm63LdzbL1cy8PQwgtZM5n7\n8CqSy0tE5dpGeGK3oqEJkalbQa9mY/+HGf4ENC7CzlRnJ/xYpLSBiAHCz0ch9+Tc\nZqbbB7IDEhWEiwj25dZ3OG6wqveHtZGQueju34RwF9slrjAPHkXrHC0zSHLVB+hr\nupH8FHTCEJhTY80mZy1DVBEVU6s0DFDjhTX7zYeytM51tKh5iSqJ/dI4jp7GAWx5\n0pDslYxX29aGUbBaKUL83L4RpLW4hecbPiWYeG4tw5Z3pEhifCo0YEffwFJjTGsh\nTP3XAeiOVEInvmH1jK+LgUpzz7rnyy7pAgMBAAGjOTA3MBYGA1UdEQQPMA2CC2Fr\naW5vLmhoLnNlMB0GA1UdDgQWBBQavhHSFdU5J1TVygW7QNzSuG4QTDANBgkqhkiG\n9w0BAQUFAAOCAQEAlxMSNZxBeI4qFUaUBdH0S8FSheF5ynIutcj5bXfmst4rBxRa\nCZIB+NLzwGIp2rwNM53uB3P1osDr+BilLeFUvgSiGwMYFdAHkr9Bg2WqJj9/phW3\nscmeVlwizwXyQscs8fYr9UQGGjrt+tYIJ8NbZCp7bLyjZdwjC2MGe2bDQzA/S2ye\nJfTpxJCZp5ocIfNyPCGmpf6pLBYjQbVfqO4bNJOvaArHylA8wYb5nYO1HFoqKOB/\n7ayOBgrV5oO97iUTRmBU9Ka8GIqJqdC4LIUwj6HcmCJ94rQbldH5/nbitL9ND2oY\ns2ozMUSsHZxcwpFZ7NQ4lLsgm9VihBDXZ4mTXQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "akino.hh.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=akino.hh.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC6DCCAdCgAwIBAgIJANFCVxC7y6BWMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNV\nBAMTC2FraW5vLmhoLnNlMB4XDTA5MTAyNzA4MjU1N1oXDTE5MTAyNTA4MjU1N1ow\nFjEUMBIGA1UEAxMLYWtpbm8uaGguc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\nggEKAoIBAQD2Y7TZAeEnPMmlwz3hoXDa/wFIRy6Bodm63LdzbL1cy8PQwgtZM5n7\n8CqSy0tE5dpGeGK3oqEJkalbQa9mY/+HGf4ENC7CzlRnJ/xYpLSBiAHCz0ch9+Tc\nZqbbB7IDEhWEiwj25dZ3OG6wqveHtZGQueju34RwF9slrjAPHkXrHC0zSHLVB+hr\nupH8FHTCEJhTY80mZy1DVBEVU6s0DFDjhTX7zYeytM51tKh5iSqJ/dI4jp7GAWx5\n0pDslYxX29aGUbBaKUL83L4RpLW4hecbPiWYeG4tw5Z3pEhifCo0YEffwFJjTGsh\nTP3XAeiOVEInvmH1jK+LgUpzz7rnyy7pAgMBAAGjOTA3MBYGA1UdEQQPMA2CC2Fr\naW5vLmhoLnNlMB0GA1UdDgQWBBQavhHSFdU5J1TVygW7QNzSuG4QTDANBgkqhkiG\n9w0BAQUFAAOCAQEAlxMSNZxBeI4qFUaUBdH0S8FSheF5ynIutcj5bXfmst4rBxRa\nCZIB+NLzwGIp2rwNM53uB3P1osDr+BilLeFUvgSiGwMYFdAHkr9Bg2WqJj9/phW3\nscmeVlwizwXyQscs8fYr9UQGGjrt+tYIJ8NbZCp7bLyjZdwjC2MGe2bDQzA/S2ye\nJfTpxJCZp5ocIfNyPCGmpf6pLBYjQbVfqO4bNJOvaArHylA8wYb5nYO1HFoqKOB/\n7ayOBgrV5oO97iUTRmBU9Ka8GIqJqdC4LIUwj6HcmCJ94rQbldH5/nbitL9ND2oY\ns2ozMUSsHZxcwpFZ7NQ4lLsgm9VihBDXZ4mTXQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://akino.hh.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://akino.hh.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/akino.hh.se.xml"
      }
    }
  ], 
  [
    "https://shibboleth.uni-bonn.de/idp/shibboleth", 
    {
      "entity_id": "https://shibboleth.uni-bonn.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shibboleth.uni-bonn.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.uni-bonn.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni-bonn.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uni-bonn.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uni-bonn.de,OU=Hochschulrechenzentrum,O=Universitaet Bonn,L=Bonn,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGQTCCBSmgAwIBAgIHEunRqyAN0TANBgkqhkiG9w0BAQUFADCBujELMAkGA1UE\nBhMCREUxHDAaBgNVBAgTE05vcmRyaGVpbi1XZXN0ZmFsZW4xDTALBgNVBAcTBEJv\nbm4xGjAYBgNVBAoTEVVuaXZlcnNpdGFldCBCb25uMR8wHQYDVQQLExZIb2Noc2No\ndWxyZWNoZW56ZW50cnVtMR0wGwYDVQQDExRVbml2ZXJzaXRhZXQgQm9ubiBDQTEi\nMCAGCSqGSIb3DQEJARYTY2FhZG1pbkB1bmktYm9ubi5kZTAeFw0xMTExMjExMzM3\nMzJaFw0xNjExMTkxMzM3MzJaMIGYMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjENMAsGA1UEBxMEQm9ubjEaMBgGA1UEChMRVW5pdmVy\nc2l0YWV0IEJvbm4xHzAdBgNVBAsTFkhvY2hzY2h1bHJlY2hlbnplbnRydW0xHzAd\nBgNVBAMTFnNoaWJib2xldGgudW5pLWJvbm4uZGUwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQDhmb095e8n0Ntnl+T69lwmLIJOsoR9K2H+queaqzrEoXWx\nX3EEJSb7nIHQ9RuP4kUo8KRkUtYNoKBV/LZC2XH+NKvgnGyYFIu6GKBZFXeYuQMc\nVRTypqEeTJnQ9Vt7N+7c2KojOQ5lB8qtJk5EuAkofgKBgePgVgob7a3SFx+0HnNX\nR6SDOBQQo695NdgDhuUSiS63WRi0Lafec2xjpb+a9Iq5gjhUsP7lhve3fjm7fnky\nIARB6EE8N37htwEFquG1UWFMvPxa0URymi0GZuTH6Fjok6CnR+NWGrK8QufltW9U\nONE0/KJrNM5f5HxtuBa+n3To/u9VPag4SQirvuQtAgMBAAGjggJqMIICZjAJBgNV\nHRMEAjAAMAsGA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUH\nAwEwHQYDVR0OBBYEFHqcomCwNt7ndEc81rP8KsSSBdtQMB8GA1UdIwQYMBaAFOs3\n0OvXhC5GnhLTsxjbjeWC5GinMIHJBgNVHREEgcEwgb6BD2J2d0B1bmktYm9ubi5k\nZYIWc2hpYmJvbGV0aC51bmktYm9ubi5kZYIbc2hpYmJvbGV0aC5yaHJ6LnVuaS1i\nb25uLmRlghxzaGliYm9sZXRoMS5yaHJ6LnVuaS1ib25uLmRlghxzaGliYm9sZXRo\nMi5yaHJ6LnVuaS1ib25uLmRlghxzaGliYm9sZXRoMy5yaHJ6LnVuaS1ib25uLmRl\nghxzaGliYm9sZXRoNC5yaHJ6LnVuaS1ib25uLmRlMIGBBgNVHR8EejB4MDqgOKA2\nhjRodHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1ib25uLWNhL3B1Yi9jcmwvY2Fj\ncmwuY3JsMDqgOKA2hjRodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1ib25uLWNh\nL3B1Yi9jcmwvY2FjcmwuY3JsMIGcBggrBgEFBQcBAQSBjzCBjDBEBggrBgEFBQcw\nAoY4aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktYm9ubi1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwRAYIKwYBBQUHMAKGOGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUv\ndW5pLWJvbm4tY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUA\nA4IBAQBpSi0VhhudTolynhedRGNbvHi8uK8HD51pG9Xm1BTlqIMa4VwkrBeU07As\nnsSciEBSiALIhrLayokU/z5EpROSE4HBvHMomjSezpkPQ60bwIABSplmiwCpu5zF\nArW5cuNFvSdgVKqkElg4Us2uZYcu9s3HdJWB5giU3GbhyReAviQOHO5Dzo+4twbp\nFqDbI6Tj+m4ZOd1u19hcR4TBIvgn7CEk7tSAZfdEQF+nRlYmFyV0LMGCAqksIYC/\nJJvOc54vwjBXXA+3LU5CSoTt7wjLXC2BjLH4OeJL05owk55toOhNNXg1AxMw1Gew\nNHr2AA4aMaB5TQyo2nz1udsI86g4", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.uni-bonn.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "uni-bonn.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uni-bonn.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uni-bonn.de,OU=Hochschulrechenzentrum,O=Universitaet Bonn,L=Bonn,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGQTCCBSmgAwIBAgIHEunRqyAN0TANBgkqhkiG9w0BAQUFADCBujELMAkGA1UE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\nNHr2AA4aMaB5TQyo2nz1udsI86g4", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "uni-bonn.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Bonn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.uni-bonn.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Irina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "neerfeld@uni-bonn.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Neerfeld", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Annette", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jamitzky@uni-bonn.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Jamitzky", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://connect.funet.fi/shibboleth", 
    {
      "entity_id": "https://connect.funet.fi/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "FUNET E-Meeting Service (Adobe Connect)", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "FUNET E-Meeting Service", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://connect.funet.fi/Shibboleth.sso/DS/ds.swamid.se"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://connect.funet.fi/Shibboleth.sso/DS/haka.funet.fi"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "connect.funet.fi", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=connect.funet.fi", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAKZpZsXKkzHCMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGNvbm5lY3QuZnVuZXQuZmkwHhcNMTIwMjE2MTE0NTMwWhcNMTUwMjE1MTE0\nNTMwWjAbMRkwFwYDVQQDExBjb25uZWN0LmZ1bmV0LmZpMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEA9qHZQfn+2SyyuRhpm+wnEIxXj4eZjNkfQvy/hSih\nfDvnx5QpNerbXt+SIy2YQHmFhn5N5Hdn1onPf91IzshAQVXacIdzqFEXdwl2k4M9\nBw7FiObtFokW4ukEZTEnDPhwTu89oaVuXLLsGt9tCiNBKaSniip4HpMMBEK41jU4\nwzmm+LSQF8xYl+AgagZaydHCVSIQC1PnXqPR1dcnoBzP2t01YqWCfCyxHjHVBYtk\njrXpse9rb0pj1xlurvG1lveqeAStM8AkXiP2gSBQpv88y/YU6UgT1eOLsI65Ox2w\nZWTd36jYbUxHOsRAsZxSy0IokvGIHDK6ykjU9wLthwWXYwIDAQABoz4wPDAbBgNV\nHREEFDASghBjb25uZWN0LmZ1bmV0LmZpMB0GA1UdDgQWBBRxLCa7bCuoP7HKshs5\nFyw8ab6LXzANBgkqhkiG9w0BAQUFAAOCAQEAxw74TU9pNDmMVFq7AXkvHOlnKM9q\nl7c5F7D/KVXOrigwiIn0xwj+kr4ElZp1qrVLgC+fEHk9C2uKR9iJiR1z2SnOEn1U\nTeFtpdM7HaGBivCjsX5d1zMiTILSNkU7u+cJPH9EASOnTjSIbktDfHLApZ+t9yfg\nNPPGeZN6Q8qZuKoJBi7obLAsWbcTSxgIBrYK4G0BS9Hiy3W4gp1gqTflpYx0YBHv\nrNvLo5T1BgsjLc1kQsoAAn8pUP8GHb1KSJ0SY2IKV+k9oWEF3Nd1n/+43bPB666B\nEMBSvHkNXEFDf/FDbw4kjn5ie1pmF4qu+jHVHyB4y4Roz0QFoYIeOWaRMw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "connect.funet.fi", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=connect.funet.fi", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAKZpZsXKkzHCMA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGNvbm5lY3QuZnVuZXQuZmkwHhcNMTIwMjE2MTE0NTMwWhcNMTUwMjE1MTE0\nNTMwWjAbMRkwFwYDVQQDExBjb25uZWN0LmZ1bmV0LmZpMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEA9qHZQfn+2SyyuRhpm+wnEIxXj4eZjNkfQvy/hSih\nfDvnx5QpNerbXt+SIy2YQHmFhn5N5Hdn1onPf91IzshAQVXacIdzqFEXdwl2k4M9\nBw7FiObtFokW4ukEZTEnDPhwTu89oaVuXLLsGt9tCiNBKaSniip4HpMMBEK41jU4\nwzmm+LSQF8xYl+AgagZaydHCVSIQC1PnXqPR1dcnoBzP2t01YqWCfCyxHjHVBYtk\njrXpse9rb0pj1xlurvG1lveqeAStM8AkXiP2gSBQpv88y/YU6UgT1eOLsI65Ox2w\nZWTd36jYbUxHOsRAsZxSy0IokvGIHDK6ykjU9wLthwWXYwIDAQABoz4wPDAbBgNV\nHREEFDASghBjb25uZWN0LmZ1bmV0LmZpMB0GA1UdDgQWBBRxLCa7bCuoP7HKshs5\nFyw8ab6LXzANBgkqhkiG9w0BAQUFAAOCAQEAxw74TU9pNDmMVFq7AXkvHOlnKM9q\nl7c5F7D/KVXOrigwiIn0xwj+kr4ElZp1qrVLgC+fEHk9C2uKR9iJiR1z2SnOEn1U\nTeFtpdM7HaGBivCjsX5d1zMiTILSNkU7u+cJPH9EASOnTjSIbktDfHLApZ+t9yfg\nNPPGeZN6Q8qZuKoJBi7obLAsWbcTSxgIBrYK4G0BS9Hiy3W4gp1gqTflpYx0YBHv\nrNvLo5T1BgsjLc1kQsoAAn8pUP8GHb1KSJ0SY2IKV+k9oWEF3Nd1n/+43bPB666B\nEMBSvHkNXEFDf/FDbw4kjn5ie1pmF4qu+jHVHyB4y4Roz0QFoYIeOWaRMw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://connect.funet.fi/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/connect.funet.fi.xml"
      }
    }
  ], 
  [
    "https://www.vho.de/idpvzg", 
    {
      "entity_id": "https://www.vho.de/idpvzg", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.vho.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://www.vho.de/idpvzg/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "vzg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "www.vho.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.vho.de,OU=Digitale Bibliothek,O=Gemeinsamer Bibliotheksverbund (GBV),L=GOETTINGEN,ST=NIEDERSACHSEN,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGfzCCBWegAwIBAgIED/+i6zANBgkqhkiG9w0BAQUFADCBuzELMAkGA1UEBhMC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\nCFNwbRrYB0gGPASPkZD9WxiosAZp/uqr6QTZIUDSSmWt2B0=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://www.vho.de:8443/idpvzg/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "vzg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "www.vho.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.vho.de,OU=Digitale Bibliothek,O=Gemeinsamer Bibliotheksverbund (GBV),L=GOETTINGEN,ST=NIEDERSACHSEN,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGfzCCBWegAwIBAgIED/+i6zANBgkqhkiG9w0BAQUFADCBuzELMAkGA1UEBhMC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\nCFNwbRrYB0gGPASPkZD9WxiosAZp/uqr6QTZIUDSSmWt2B0=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "IdP der Verbundzentrale", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Verbundzentrale G\u00f6ttingen (VZG)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.vho.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Franck", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "borel@gbv.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Borel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Gerald", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "steilen@gbv.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Steilen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Till", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "kinstler@gbv.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Kinstler", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://www.studera.testb.antagning.se/shibboleth-sp", 
    {
      "entity_id": "https://www.studera.testb.antagning.se/shibboleth-sp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "https://www.studera.testb.antagning.se/shibboleth-sp", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "www.studera.testb.antagning.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.studera.testb.antagning.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDWTCCAkGgAwIBAgIJAIdL6478VUlNMA0GCSqGSIb3DQEBBQUAMCkxJzAlBgNV\nBAMTHnd3dy5zdHVkZXJhLnRlc3RiLmFudGFnbmluZy5zZTAeFw0xMDEwMDQxNjE0\nMTFaFw0xNTEwMDMxNjE0MTFaMCkxJzAlBgNVBAMTHnd3dy5zdHVkZXJhLnRlc3Ri\nLmFudGFnbmluZy5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOHg\naaFU9q3cVQWDQjh2MSvlqGQUorgeeZak3sctZvcyLVuk+2NiBgdhpbeEuGfz7sQU\nYgNdlOjn8ZW405+qxGbkdErfvO1IYXcV1EoPGIlGmOVp0wI2tVTiywuyde9UDkP7\njMyB8NziSa1tep8eabKutChmfTL4thLLXd1kiS1re2cUVwfEQgf6twlmnNDaDgoD\nBC8KXG9pOZEXbLaG6h4IaV4utYJVQy3B+8rGh/xGHQgJjAmVnP39AQ2zPMt1vOXS\nYs4oP0q0i74F3MosS053b+lJljzxBy/zGedLtcsTGKn3fbzG4qlh4UdGT1FYvlbH\nF6kdxwBmXsf4gPKryiMCAwEAAaOBgzCBgDBfBgNVHREEWDBWgh53d3cuc3R1ZGVy\nYS50ZXN0Yi5hbnRhZ25pbmcuc2WGNGh0dHBzOi8vd3d3LnN0dWRlcmEudGVzdGIu\nYW50YWduaW5nLnNlL3NoaWJib2xldGgtc3AwHQYDVR0OBBYEFDZPnNIS+CYoKL5A\nsefcGDrsU89QMA0GCSqGSIb3DQEBBQUAA4IBAQB5w2hhhMDeRJ01OsThQndggTh2\njJ3MTBSNFKotvqvkxvAPRvvQr/yQfNXC/nzhOUOLpp48KKg3z3PEbADC3L20jWkU\ndqtvWBlS4VEcRV/zRWiMqYual1wyEViCP2DDbs3MumPh43jBVau3+68DY1ZagNwS\nQjj9TWKjVQEoYfThufo+WaupwINVPn5bV50FAwTsPma5mD9ntNcpt5IaFFZ4xzdS\nEDBKNuKxJpxjNF8RSIAmzov7a2OkCjCKfn3JWGgRaKL8ZBzxmTXHAAhU9ygEs5UT\nJts+WMokFPGmBI606RWPMu7mpWz7aaT0zh98ifV4tjNWS0GhrtWRAcKj+Kvu", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "https://www.studera.testb.antagning.se/shibboleth-sp", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "www.studera.testb.antagning.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.studera.testb.antagning.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDWTCCAkGgAwIBAgIJAIdL6478VUlNMA0GCSqGSIb3DQEBBQUAMCkxJzAlBgNV\nBAMTHnd3dy5zdHVkZXJhLnRlc3RiLmFudGFnbmluZy5zZTAeFw0xMDEwMDQxNjE0\nMTFaFw0xNTEwMDMxNjE0MTFaMCkxJzAlBgNVBAMTHnd3dy5zdHVkZXJhLnRlc3Ri\nLmFudGFnbmluZy5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOHg\naaFU9q3cVQWDQjh2MSvlqGQUorgeeZak3sctZvcyLVuk+2NiBgdhpbeEuGfz7sQU\nYgNdlOjn8ZW405+qxGbkdErfvO1IYXcV1EoPGIlGmOVp0wI2tVTiywuyde9UDkP7\njMyB8NziSa1tep8eabKutChmfTL4thLLXd1kiS1re2cUVwfEQgf6twlmnNDaDgoD\nBC8KXG9pOZEXbLaG6h4IaV4utYJVQy3B+8rGh/xGHQgJjAmVnP39AQ2zPMt1vOXS\nYs4oP0q0i74F3MosS053b+lJljzxBy/zGedLtcsTGKn3fbzG4qlh4UdGT1FYvlbH\nF6kdxwBmXsf4gPKryiMCAwEAAaOBgzCBgDBfBgNVHREEWDBWgh53d3cuc3R1ZGVy\nYS50ZXN0Yi5hbnRhZ25pbmcuc2WGNGh0dHBzOi8vd3d3LnN0dWRlcmEudGVzdGIu\nYW50YWduaW5nLnNlL3NoaWJib2xldGgtc3AwHQYDVR0OBBYEFDZPnNIS+CYoKL5A\nsefcGDrsU89QMA0GCSqGSIb3DQEBBQUAA4IBAQB5w2hhhMDeRJ01OsThQndggTh2\njJ3MTBSNFKotvqvkxvAPRvvQr/yQfNXC/nzhOUOLpp48KKg3z3PEbADC3L20jWkU\ndqtvWBlS4VEcRV/zRWiMqYual1wyEViCP2DDbs3MumPh43jBVau3+68DY1ZagNwS\nQjj9TWKjVQEoYfThufo+WaupwINVPn5bV50FAwTsPma5mD9ntNcpt5IaFFZ4xzdS\nEDBKNuKxJpxjNF8RSIAmzov7a2OkCjCKfn3JWGgRaKL8ZBzxmTXHAAhU9ygEs5UT\nJts+WMokFPGmBI606RWPMu7mpWz7aaT0zh98ifV4tjNWS0GhrtWRAcKj+Kvu", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.studera.testb.antagning.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/www.studera.testb.antagning.se.xml"
      }
    }
  ], 
  [
    "https://hades.slu.se/shibboleth", 
    {
      "entity_id": "https://hades.slu.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://hades.slu.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://hades.slu.se/Shibboleth.sso/Login"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "fme1-1.ad.slu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=fme1-1.ad.slu.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9zCCAd+gAwIBAgIJAID0pitDTgz2MA0GCSqGSIb3DQEBBQUAMBsxGTAXBgNV\nBAMTEGZtZTEtMS5hZC5zbHUuc2UwHhcNMTIwNjI3MDg0NDEzWhcNMjIwNjI1MDg0\nNDEzWjAbMRkwFwYDVQQDExBmbWUxLTEuYWQuc2x1LnNlMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEAw7oOCbv2+Z2jh0uM6YlV7Q9sF0uH03jBj67JPA4r\nCIXIFdJ/g7gLliZa+DjxaNlPxQAE4xc3vGGO7TUyKCftvRIUI49Phm8WKtapy6XE\nPb52xE0ie+B0RO2boUG9xiM50WlZT0VsmdYjwHey7fT5UZjaGa/PLOAAoKXLvfJG\nVQb1IAO8bQ+k4XWf/2oR2BLEKWmy3xW1T4ew34SmAPcpbwZOxj5t0GRDt6lblHvG\nL4KB5a6hEOuU+0U0KjFYKG2PYLJUB4RM6ctmGOnuwUyoWmFAN1h4OZzXoyckr8u2\ngdaWyFL+k/ojckmw5aaJBpce332Bh9wy53W6J77qa0ANawIDAQABoz4wPDAbBgNV\nHREEFDASghBmbWUxLTEuYWQuc2x1LnNlMB0GA1UdDgQWBBSrX7qpYidl+M3/uMRp\nBZk7JtDvtTANBgkqhkiG9w0BAQUFAAOCAQEAAh37ouHU+pXCxffOUOrDNkBSJSAb\nmmD67HCLmcdLwMxBLji/M/FTK5RYdxlwAwK5F1ntbHovDJKWMva7wuWzmjbcSJ6R\nJVrolJWJDR+Fc84L2Lh1Q3sVOXjDXU5Lw+yYApNcs+f2TdYZEa9HDqTyEjupjecd\na7N6bBlELYgoYFbTpg8AmQOsvVl2yQQiX07lBHHeGOn4i1bbB6ip6exRTxUqf0Ed\nQM0LY0RQjVj4+R+UdaRYQfizHG1rnKcEiRzi/mXYt2YXSjKuyvNUn6uc1GY9/3aJ\n9wX+6Hnwlg8X2wAoLJDLxAoOWSUSyPLCSzqp90tYAn1L6/pX68R46PWq4Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://hades.slu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/hades.slu.se.xml"
      }
    }
  ], 
  [
    "https://services.aai.mpg.de/idp/proxy/idp", 
    {
      "entity_id": "https://services.aai.mpg.de/idp/proxy/idp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/services.aai.mpg.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://services.aai.mpg.de/idp/proxy/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "mpg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://services.aai.mpg.de:8443/idp/proxy/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "mpg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "services.aai.mpg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=services.aai.mpg.de,OU=PKI,O=Max-Planck-Gesellschaft,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFVDCCBDygAwIBAgIEDpZLlDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEgMB4GA1UEChMXTWF4LVBsYW5jay1HZXNlbGxzY2hhZnQxDzANBgNVBAMTBk1Q\nRyBDQTEcMBoGCSqGSIb3DQEJARYNbXBnLWNhQG1wZy5kZTAeFw0wOTA4MDMxMTQ2\nMTNaFw0xNDA4MDIxMTQ2MTNaMFsxCzAJBgNVBAYTAkRFMSAwHgYDVQQKExdNYXgt\nUGxhbmNrLUdlc2VsbHNjaGFmdDEMMAoGA1UECxMDUEtJMRwwGgYDVQQDExNzZXJ2\naWNlcy5hYWkubXBnLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwo/JY5GAYrXqDlrEhVK+3pVjg+fse6ZDZP2pCdmNw0LFnDxNjEXve/5PvMT6PDi9\nlCb2YPLYl8brtICD/rev9O9NyAaReZ/2HApvMNgFBlAsWSlp4NKruwcG4Sz2VG+a\nT3stcy0ud8pdFSlfe9hvRcDm6/F4d/rEoRwuGtxq4y3u1OrcFPLltOaBRQiLEfXP\nkEe4XRndVqDO2Tdv3FVK2kcQsChc3RF53BA+nRrrMzdYFHNSasR2FTAa4sCqGrXW\nfOhBk7YqX8BYyN5WcgHOUYk7o/sjAUzlc7Irk2a4TpUQTeZjxf2I3eJh3A4U/zsm\n5lGTEyoigyt7NgioMz0aaQIDAQABo4ICGzCCAhcwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n2PB1xPMrpSNtJnu/DplMCTithDAfBgNVHSMEGDAWgBQC1h5uCau/WGWnCjxIM2HR\nzn3DWzCBjwYDVR0RBIGHMIGEghNzZXJ2aWNlcy5hYWkubXBnLmRlgg5wdWIuYWFp\nLm1wZy5kZYILYWFpLmd3ZGcuZGWCD3NoaWItaWRwLm1wZy5kZYIQc2hpYi1pZHAu\nZ3dkZy5kZYcEhkwYEIcEhkwYDIcEhkwYCoEbdGhvcnN0ZW4uaGluZGVybWFubkBn\nd2RnLmRlMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUv\nbXBnLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMDWgM6Axhi9odHRwOi8vY2RwMi5wY2Eu\nZGZuLmRlL21wZy1jYS9wdWIvY3JsL2NhY3JsLmNybDCBkgYIKwYBBQUHAQEEgYUw\ngYIwPwYIKwYBBQUHMAKGM2h0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvbXBnLWNhL3B1\nYi9jYWNlcnQvY2FjZXJ0LmNydDA/BggrBgEFBQcwAoYzaHR0cDovL2NkcDIucGNh\nLmRmbi5kZS9tcGctY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEB\nBQUAA4IBAQB3YUqg8sgrAdvD1gRqbo8OPl4M9VBoIBhX3Ex6EUWFYAosQPruOVrz\nom+mXgeN2RdCl2Vq/hua/vYvmNGjnBONfkCHAM7y75r2oo94MC3EhQLVfwUnR5Cq\nHHEJoE5ErvAgPS4w6iWCuZbHVpJEXmaQuu16EX//WWcTmBG9JQ1UeF1XnVRdCzWz\nivgAWoFdxV7rPIXYUrgiLOzdzRyTzsP7odbUcGscrbbHRL44ua06ioo3iggojKRJ\nDktGe+x1VIK6EIzYwwOfhn6xcXAfrAIBj+AnWOGM16KAMb1CqFM81GYAZxUItKdh\nguP31RSo9hKlJTxwkQ7O6HcoNbkOHuH7", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Max-Planck-Gesellschaft", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Max-Planck-Gesellschaft", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.mpg.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Sebastian", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sebastian.rieger@gwdg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Rieger", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Matthias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "matthias.egger@rzg.mpg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Egger", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Thorsten", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "thorsten.hindermann@gwdg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hindermann", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://bibliometrics.ki.se/shibboleth", 
    {
      "entity_id": "https://bibliometrics.ki.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "dakini", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=dakini", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_issuer_serial": {
                      "x509_serial_number": {
                        "text": "13185477282229581982", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SerialNumber"
                      }, 
                      "x509_issuer_name": {
                        "text": "CN=dakini", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerName"
                      }, 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerSerial"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC2TCCAcGgAwIBAgIJALb8ObqBRvieMA0GCSqGSIb3DQEBBQUAMBExDzANBgNV\nBAMTBmRha2luaTAeFw0wOTA4MjAwODQ1MDhaFw0xOTA4MTgwODQ1MDhaMBExDzAN\nBgNVBAMTBmRha2luaTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALWH\nC8Fn5KzWao6uaivX319kdey1mI8ig50awhcF3wkTW+ZZxP4vkbC6YBcrmQOO1iKd\nEVj16GLWaJ8Ut+iVY/rvPgdS2jDbZ2w8BEoa0Vbzn8lcuuBM13oudRiTVVGzLY1V\nPgKzmT3n13VTPEnJeAVgS8SzA15ncMIUQaMLnXxjSzJvzk9f5dWD1Gj0cygpwMT5\nf0oKa0UjYK71kj9we96CVQEi7Rab0sO9jwr+a+nIOUbmND9cLDcsH4p33s/toxJw\nDhNNyk0qn9d31FdEdWxvjKadB3e3XQfidSQcWCi+zj7QSbg4l4JdbCT4dHxnbxhF\nwZ4QYQDb4mAwT6Z4cgMCAwEAAaM0MDIwEQYDVR0RBAowCIIGZGFraW5pMB0GA1Ud\nDgQWBBTxVcu+3um0LDAQLjN13N8+gEAKRjANBgkqhkiG9w0BAQUFAAOCAQEAbSsU\nSIRr47OU0aMebcZdoN/rRlJ0WQoMxb/bK89MiUr9AqWdCJ+DRGuQyXhieMIlOaJu\nWCqlajH795ZfZExSDDH/PG3EhcvC2rOMuBWbAxlpYc0hsXBq8NilZhiSSAqrYurG\nNEKkvNz7AU9EB9u1GMIO3p3UTKiXDVVaGL6fSseSKXsaYH6udoRz++25eDeQPUgp\nHgDpL2zWJcwd1mIaNAxIylz+rR4Rakohiwdl2dkMIT3aimODRAvQVf4wvV08Q11M\nDK12w8bmjGJp07CTu/QuoWW+jyY1S0k6Kv3LN6VtXWckviepGDFNzdGgML9V5fRJ\nfP+xp1jCheyR/F9V3w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "dakini", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=dakini", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_issuer_serial": {
                      "x509_serial_number": {
                        "text": "13185477282229581982", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SerialNumber"
                      }, 
                      "x509_issuer_name": {
                        "text": "CN=dakini", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerName"
                      }, 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerSerial"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC2TCCAcGgAwIBAgIJALb8ObqBRvieMA0GCSqGSIb3DQEBBQUAMBExDzANBgNV\nBAMTBmRha2luaTAeFw0wOTA4MjAwODQ1MDhaFw0xOTA4MTgwODQ1MDhaMBExDzAN\nBgNVBAMTBmRha2luaTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALWH\nC8Fn5KzWao6uaivX319kdey1mI8ig50awhcF3wkTW+ZZxP4vkbC6YBcrmQOO1iKd\nEVj16GLWaJ8Ut+iVY/rvPgdS2jDbZ2w8BEoa0Vbzn8lcuuBM13oudRiTVVGzLY1V\nPgKzmT3n13VTPEnJeAVgS8SzA15ncMIUQaMLnXxjSzJvzk9f5dWD1Gj0cygpwMT5\nf0oKa0UjYK71kj9we96CVQEi7Rab0sO9jwr+a+nIOUbmND9cLDcsH4p33s/toxJw\nDhNNyk0qn9d31FdEdWxvjKadB3e3XQfidSQcWCi+zj7QSbg4l4JdbCT4dHxnbxhF\nwZ4QYQDb4mAwT6Z4cgMCAwEAAaM0MDIwEQYDVR0RBAowCIIGZGFraW5pMB0GA1Ud\nDgQWBBTxVcu+3um0LDAQLjN13N8+gEAKRjANBgkqhkiG9w0BAQUFAAOCAQEAbSsU\nSIRr47OU0aMebcZdoN/rRlJ0WQoMxb/bK89MiUr9AqWdCJ+DRGuQyXhieMIlOaJu\nWCqlajH795ZfZExSDDH/PG3EhcvC2rOMuBWbAxlpYc0hsXBq8NilZhiSSAqrYurG\nNEKkvNz7AU9EB9u1GMIO3p3UTKiXDVVaGL6fSseSKXsaYH6udoRz++25eDeQPUgp\nHgDpL2zWJcwd1mIaNAxIylz+rR4Rakohiwdl2dkMIT3aimODRAvQVf4wvV08Q11M\nDK12w8bmjGJp07CTu/QuoWW+jyY1S0k6Kv3LN6VtXWckviepGDFNzdGgML9V5fRJ\nfP+xp1jCheyR/F9V3w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://bibliometrics.ki.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/bibliometrics.ki.se.xml"
      }
    }
  ], 
  [
    "https://wws.redi-bw.de", 
    {
      "entity_id": "https://wws.redi-bw.de", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/wws.redi-bw.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Universit\u00e4t Freiburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "ReDI Perinorm-Server", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.redi-bw.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Hans-Adolf", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ruppert@ub.uni-freiburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Ruppert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "ReDI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "info@redi-bw.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Team", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://wws-fr.redi-bw.de/Shibboleth.sso/DS"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://wws-s.redi-bw.de/Shibboleth.sso/DS"
              }
            ]
          }, 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "wws.redi-bw.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=info@redi-bw.de,CN=wws.redi-bw.de,OU=Universitaetsbibliothek,O=Universitaet Freiburg,L=Freiburg,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFyTCCBLGgAwIBAgIEENaFljANBgkqhkiG9w0BAQUFADCBhjELMAkGA1UEBhMC\nREUxHjAcBgNVBAoTFVVuaXZlcnNpdGFldCBGcmVpYnVyZzEWMBQGA1UECxMNUmVj\naGVuemVudHJ1bTEYMBYGA1UEAxMPVW5pLUZSIENBIC0gRzAyMSUwIwYJKoZIhvcN\nAQkBFhZwa2lAcnoudW5pLWZyZWlidXJnLmRlMB4XDTEwMTAxNDEzMzkxOVoXDTE1\nMTAxMzEzMzkxOVowgbgxCzAJBgNVBAYTAkRFMRswGQYDVQQIExJCYWRlbi1XdWVy\ndHRlbWJlcmcxETAPBgNVBAcTCEZyZWlidXJnMR4wHAYDVQQKExVVbml2ZXJzaXRh\nZXQgRnJlaWJ1cmcxIDAeBgNVBAsTF1VuaXZlcnNpdGFldHNiaWJsaW90aGVrMRcw\nFQYDVQQDEw53d3MucmVkaS1idy5kZTEeMBwGCSqGSIb3DQEJARYPaW5mb0ByZWRp\nLWJ3LmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0miEzWvjAqrX\noT2H0778Bdd9+TLJD/jxbx7+fy0oN0NJF9nocIxMfMXiYFKWJy5dY0XEx7/33DKY\n5Df66Wk8o1x97xa9LGEaXe0+glZyaDsNKStlY1kW6pM/ohVUIXlHZGnDVLz+4yzh\nXPT/besq9w1YkUDI8R5zXhXgod7WsRXPaGlDj+MYd4+xAX5vPqga0KRtc9gwshKT\nY+xrtD2W3Y4ynzMUT7N5OvPLF/Q807P5bHf3IaZ7PWhm1PF0FN5IOvw9iUci1hqo\ngRhR4q/ImFAOwUu0jkPdrU5RGauTAMI8rPdujB/FirqMdyCQbYZs3MgVRd3kq7nt\nhCcxIaTS8QIDAQABo4ICCTCCAgUwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBSMk/NR+7fUmRRd\nPORgM+0wtrTYSTAfBgNVHSMEGDAWgBQzZ6nW8ZNVNqyhMr3B5JY5/0xwMTBPBgNV\nHREESDBGgQ9pbmZvQHJlZGktYncuZGWCDnd3cy5yZWRpLWJ3LmRlghF3d3MtZnIu\ncmVkaS1idy5kZYIQd3dzLXMucmVkaS1idy5kZTCBjwYDVR0fBIGHMIGEMECgPqA8\nhjpodHRwOi8vY2RwMS5wY2EuZGZuLmRlL3VuaS1mcmVpYnVyZy1jYS9wdWIvY3Js\nL2dfY2FjcmwuY3JsMECgPqA8hjpodHRwOi8vY2RwMi5wY2EuZGZuLmRlL3VuaS1m\ncmVpYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGoBggrBgEFBQcBAQSBmzCB\nmDBKBggrBgEFBQcwAoY+aHR0cDovL2NkcDEucGNhLmRmbi5kZS91bmktZnJlaWJ1\ncmctY2EvcHViL2NhY2VydC9nX2NhY2VydC5jcnQwSgYIKwYBBQUHMAKGPmh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvdW5pLWZyZWlidXJnLWNhL3B1Yi9jYWNlcnQvZ19j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCRsfDQbyon67pB4jiHwtfok+nY\ndYgba+x93m6uO8+RD2MPBBhcVFF4uHfStxhRe8lttNNboTf7g/D4y041ZGSmQH/e\nYqRBVK5WiedYXpyFjB7tzjOmMsFKYEV5MRLpjt7V7y9cKPCFXGXwSvMgAWUHrSs5\nGoWj/xAoOWglllrxwC+gmwaPM8LNSbHDDh8QhA6NJYbYO9fUyLnI2ajgSjar4aTy\n/kygbVgZgqnFGd9prygGXaIc3hLkWcUQGS6t6NP2Ryt4i2w8Ib9ubnjgojS9e+x2\nTL82eFket8If6svRH9dTJHSQS+F2LmjUVQSSPyVt8ZUBFacRauRMyCQ9Ne3h", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-fr.redi-bw.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-s.redi-bw.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-fr.redi-bw.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-s.redi-bw.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-fr.redi-bw.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-s.redi-bw.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-fr.redi-bw.de/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://wws-s.redi-bw.de/Shibboleth.sso/SAML/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://login.rz.rwth-aachen.de/shibboleth", 
    {
      "entity_id": "https://login.rz.rwth-aachen.de/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/login.rz.rwth-aachen.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.rz.rwth-aachen.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.rz.rwth-aachen.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://login.rz.rwth-aachen.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "rwth-aachen.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://login.rz.rwth-aachen.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "rwth-aachen.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "login.rz.rwth-aachen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=login.rz.rwth-aachen.de,OU=Rechen- und Kommunikationszentum,O=RWTH Aachen,L=Aachen,ST=Nordrhein-Westfalen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFCzCCA/OgAwIBAgIEC1FmFjANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJE\nRTEUMBIGA1UEChMLUldUSCBBYWNoZW4xFzAVBgNVBAMTDlJXVEggQWFjaGVuIENB\nMSAwHgYJKoZIhvcNAQkBFhFjYUByd3RoLWFhY2hlbi5kZTAeFw0wNzExMDcxNjMy\nMDhaFw0xMjExMDUxNjMyMDhaMIGfMQswCQYDVQQGEwJERTEcMBoGA1UECBMTTm9y\nZHJoZWluLVdlc3RmYWxlbjEPMA0GA1UEBxMGQWFjaGVuMRQwEgYDVQQKEwtSV1RI\nIEFhY2hlbjEpMCcGA1UECxMgUmVjaGVuLSB1bmQgS29tbXVuaWthdGlvbnN6ZW50\ndW0xIDAeBgNVBAMTF2xvZ2luLnJ6LnJ3dGgtYWFjaGVuLmRlMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs2hVOkyelzF5UQylTADmmcHzrwzRjteUTx6b\nSCnQlTUiCsMGdICcOdP/kzBHDTJsd5AAlb5DMZ5M4O4Vl1NaJPLDT7nQj3oAF9pu\nCNv9XeguWwR1Bsy+KzJ+ixxVP0nt6665zY9FSRPJOVII6ziNUgedmtFV96jWQ49P\nR6duFD9CDyAlLj2DZSANeG50sX1Bcfc5F6UHSgkTzLnJqtl3ufQ/ltZyb3iEmOLS\nmcoOKaS/HUV4vp1y6zVCLbU/i8t82vr6zFB0zJuQiiFQtrp1j/V06XuXxzjpleUz\njySyWf+4W1svGGWkQdZyPdht90i1NFCYQIhSY+U3iNNGl2SnOwIDAQABo4IBjTCC\nAYkwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMB0GA1UdDgQWBBSOzgsiaPAKHD8PTdDijBwTIGvetTAfBgNVHSME\nGDAWgBRu1T7AHC9xyTy/SU7valVI7NHyODB5BgNVHR8EcjBwMDagNKAyhjBodHRw\nOi8vY2RwMS5wY2EuZGZuLmRlL3J3dGgtY2EvcHViL2NybC9jYWNybC5jcmwwNqA0\noDKGMGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY3JsL2NhY3Js\nLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwQAYIKwYBBQUHMAKGNGh0dHA6Ly9jZHAx\nLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwQAYIKwYB\nBQUHMAKGNGh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvcnd0aC1jYS9wdWIvY2FjZXJ0\nL2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAGl5Pq3DyUfhi1G/TEB6/rlf\nfPG85RidFcLXm5BamuZithBT2F/pvFRnlnaogUU6ik9I73qdxFLKAX7c+K/BC89D\njEosFBgD4zCHRTe3gnyBhG4+T40smabgvEBS1LOJPib14nLPOPouFnvdwaD+hCq0\n3XjbCwyEGgGnODTgFAkL+bWx/mgEZpbiCtzYuOVxojm0hQ5i42l9RIKsLrZ3ooT/\nT6qF9criC1jOHj11gJeZ11z/znefgOY+oK9vlc/41+JzhDWiiZ2KB05aiSfq+mTF\nsHc/L7HpK3d6tFerveNpu6HAAyALsqwKOS2CqmANj5EDFnY57yTDWJZcgsMlK+c=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "RWTH Aachen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "RWTH Aachen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.rwth-aachen.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Christian", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "bischof@rz.rwth-aachen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Bischof", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Wilfred", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "sso@rz.rwth-aachen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Gasper", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.hs-esslingen.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.hs-esslingen.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.hs-esslingen.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hs-esslingen.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hs-esslingen.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hs-esslingen.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hs-esslingen.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-esslingen.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hs-esslingen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hs-esslingen.de,OU=Rechenzentrum,O=Hochschule Esslingen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMTCCBBmgAwIBAgIEDmrJ1DANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJE\nRTEdMBsGA1UEChMUSG9jaHNjaHVsZSBFc3NsaW5nZW4xFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xFDASBgNVBAMTC0hFIENBIC0gRzAyMB4XDTA5MDcwMTExNDUwOFoX\nDTEyMDYzMDExNDUwOFowYjELMAkGA1UEBhMCREUxHTAbBgNVBAoTFEhvY2hzY2h1\nbGUgRXNzbGluZ2VuMRYwFAYDVQQLEw1SZWNoZW56ZW50cnVtMRwwGgYDVQQDExNp\nZHAuaHMtZXNzbGluZ2VuLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEAjzTPiYiYIOSVgiDz4a93Y7tHHSRtop49YDlicY5p2hieQfYq+SPMCq++IyIw\nIC1rpUQ1jIicDMv0zD7aWHEdOAmoT7qoZUWhqOMWKgKrXZQUXA1cjaYbmqEGQxar\n37UfTJA+UOVKX+JvMl/7Rp6YmsIiLRIR1wWBkAlcdeTKmU1sAVlmU4nQ/VRITMCp\nIj8/ZQzdoBuhccT92y7Wz8l6GU33UJLwHnzGCgWgyB9D8PwhJj9XEseKBtsmj9x8\nid/S6w7cFDyexuNZd1ceQONUSTlNI2HqV+HRSfaQAUsGC5khG3L2jNwPOvHMFh3a\nLisPMmZncvKPhia9Ch/i4gRr/QIDAQABo4IB9TCCAfEwCQYDVR0TBAIwADALBgNV\nHQ8EBAMCBeAwNAYDVR0lBC0wKwYIKwYBBQUHAwIGCCsGAQUFBwMBBgorBgEEAYI3\nCgMDBglghkgBhvhCBAEwHQYDVR0OBBYEFHDb9XHfqLM+hzTvY2T/5WRCzj0oMB8G\nA1UdIwQYMBaAFONbF7zWLDJlMkDdTRfAN946TV9cMCQGA1UdEQQdMBuBGWFhaS1h\nZG1pbkBocy1lc3NsaW5nZW4uZGUwgY8GA1UdHwSBhzCBhDBAoD6gPIY6aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4tY2EvcHViL2NybC9nX2NhY3Js\nLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4t\nY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZswgZgwSgYIKwYB\nBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaHMtZXNzbGluZ2VuLWNhL3B1\nYi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRwOi8vY2RwMi5w\nY2EuZGZuLmRlL2hzLWVzc2xpbmdlbi1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNy\ndDANBgkqhkiG9w0BAQUFAAOCAQEAUOq3J7g8KIhllj9REZGArIDDEDTKHz4v+nxK\n18HU/a++spk27pnJDZqQFTN59KxpzQaqVgrjoXTxIDib8VJlIKG0ddp2qKFXqKN2\n1mW9A3AYKFASEQB+x7BWsf74g62dn/tIptf190Cb8E8r1kbWTHILw+gGLwd2tOk8\nIQQsBIAbMkd3rtoJ0OqTTwab6qI0SX/BBtRsm9AuSTNohwevDr2ApSbw7Qv+cH2v\n7QI0ZhesW7/xE7O2eaue8Z7rjyHxjNNJOK3Tfj9wZzmjdM+tWl/c6q+DngcClxVw\ntd8exW1+V+2Uh+asbfnUK6XED+qXWm7ze4CmNCE/XOviMn+ylw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hs-esslingen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hs-esslingen.de,OU=Rechenzentrum,O=Hochschule Esslingen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMTCCBBmgAwIBAgIEDmrJ1DANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJE\nRTEdMBsGA1UEChMUSG9jaHNjaHVsZSBFc3NsaW5nZW4xFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xFDASBgNVBAMTC0hFIENBIC0gRzAyMB4XDTA5MDcwMTExNDUwOFoX\nDTEyMDYzMDExNDUwOFowYjELMAkGA1UEBhMCREUxHTAbBgNVBAoTFEhvY2hzY2h1\nbGUgRXNzbGluZ2VuMRYwFAYDVQQLEw1SZWNoZW56ZW50cnVtMRwwGgYDVQQDExNp\nZHAuaHMtZXNzbGluZ2VuLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEAjzTPiYiYIOSVgiDz4a93Y7tHHSRtop49YDlicY5p2hieQfYq+SPMCq++IyIw\nIC1rpUQ1jIicDMv0zD7aWHEdOAmoT7qoZUWhqOMWKgKrXZQUXA1cjaYbmqEGQxar\n37UfTJA+UOVKX+JvMl/7Rp6YmsIiLRIR1wWBkAlcdeTKmU1sAVlmU4nQ/VRITMCp\nIj8/ZQzdoBuhccT92y7Wz8l6GU33UJLwHnzGCgWgyB9D8PwhJj9XEseKBtsmj9x8\nid/S6w7cFDyexuNZd1ceQONUSTlNI2HqV+HRSfaQAUsGC5khG3L2jNwPOvHMFh3a\nLisPMmZncvKPhia9Ch/i4gRr/QIDAQABo4IB9TCCAfEwCQYDVR0TBAIwADALBgNV\nHQ8EBAMCBeAwNAYDVR0lBC0wKwYIKwYBBQUHAwIGCCsGAQUFBwMBBgorBgEEAYI3\nCgMDBglghkgBhvhCBAEwHQYDVR0OBBYEFHDb9XHfqLM+hzTvY2T/5WRCzj0oMB8G\nA1UdIwQYMBaAFONbF7zWLDJlMkDdTRfAN946TV9cMCQGA1UdEQQdMBuBGWFhaS1h\nZG1pbkBocy1lc3NsaW5nZW4uZGUwgY8GA1UdHwSBhzCBhDBAoD6gPIY6aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4tY2EvcHViL2NybC9nX2NhY3Js\nLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4t\nY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZswgZgwSgYIKwYB\nBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaHMtZXNzbGluZ2VuLWNhL3B1\nYi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRwOi8vY2RwMi5w\nY2EuZGZuLmRlL2hzLWVzc2xpbmdlbi1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNy\ndDANBgkqhkiG9w0BAQUFAAOCAQEAUOq3J7g8KIhllj9REZGArIDDEDTKHz4v+nxK\n18HU/a++spk27pnJDZqQFTN59KxpzQaqVgrjoXTxIDib8VJlIKG0ddp2qKFXqKN2\n1mW9A3AYKFASEQB+x7BWsf74g62dn/tIptf190Cb8E8r1kbWTHILw+gGLwd2tOk8\nIQQsBIAbMkd3rtoJ0OqTTwab6qI0SX/BBtRsm9AuSTNohwevDr2ApSbw7Qv+cH2v\n7QI0ZhesW7/xE7O2eaue8Z7rjyHxjNNJOK3Tfj9wZzmjdM+tWl/c6q+DngcClxVw\ntd8exW1+V+2Uh+asbfnUK6XED+qXWm7ze4CmNCE/XOviMn+ylw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hs-esslingen.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hs-esslingen.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hs-esslingen.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hs-esslingen.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-esslingen.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hs-esslingen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hs-esslingen.de,OU=Rechenzentrum,O=Hochschule Esslingen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMTCCBBmgAwIBAgIEDmrJ1DANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJE\nRTEdMBsGA1UEChMUSG9jaHNjaHVsZSBFc3NsaW5nZW4xFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xFDASBgNVBAMTC0hFIENBIC0gRzAyMB4XDTA5MDcwMTExNDUwOFoX\nDTEyMDYzMDExNDUwOFowYjELMAkGA1UEBhMCREUxHTAbBgNVBAoTFEhvY2hzY2h1\nbGUgRXNzbGluZ2VuMRYwFAYDVQQLEw1SZWNoZW56ZW50cnVtMRwwGgYDVQQDExNp\nZHAuaHMtZXNzbGluZ2VuLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEAjzTPiYiYIOSVgiDz4a93Y7tHHSRtop49YDlicY5p2hieQfYq+SPMCq++IyIw\nIC1rpUQ1jIicDMv0zD7aWHEdOAmoT7qoZUWhqOMWKgKrXZQUXA1cjaYbmqEGQxar\n37UfTJA+UOVKX+JvMl/7Rp6YmsIiLRIR1wWBkAlcdeTKmU1sAVlmU4nQ/VRITMCp\nIj8/ZQzdoBuhccT92y7Wz8l6GU33UJLwHnzGCgWgyB9D8PwhJj9XEseKBtsmj9x8\nid/S6w7cFDyexuNZd1ceQONUSTlNI2HqV+HRSfaQAUsGC5khG3L2jNwPOvHMFh3a\nLisPMmZncvKPhia9Ch/i4gRr/QIDAQABo4IB9TCCAfEwCQYDVR0TBAIwADALBgNV\nHQ8EBAMCBeAwNAYDVR0lBC0wKwYIKwYBBQUHAwIGCCsGAQUFBwMBBgorBgEEAYI3\nCgMDBglghkgBhvhCBAEwHQYDVR0OBBYEFHDb9XHfqLM+hzTvY2T/5WRCzj0oMB8G\nA1UdIwQYMBaAFONbF7zWLDJlMkDdTRfAN946TV9cMCQGA1UdEQQdMBuBGWFhaS1h\nZG1pbkBocy1lc3NsaW5nZW4uZGUwgY8GA1UdHwSBhzCBhDBAoD6gPIY6aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4tY2EvcHViL2NybC9nX2NhY3Js\nLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4t\nY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZswgZgwSgYIKwYB\nBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaHMtZXNzbGluZ2VuLWNhL3B1\nYi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRwOi8vY2RwMi5w\nY2EuZGZuLmRlL2hzLWVzc2xpbmdlbi1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNy\ndDANBgkqhkiG9w0BAQUFAAOCAQEAUOq3J7g8KIhllj9REZGArIDDEDTKHz4v+nxK\n18HU/a++spk27pnJDZqQFTN59KxpzQaqVgrjoXTxIDib8VJlIKG0ddp2qKFXqKN2\n1mW9A3AYKFASEQB+x7BWsf74g62dn/tIptf190Cb8E8r1kbWTHILw+gGLwd2tOk8\nIQQsBIAbMkd3rtoJ0OqTTwab6qI0SX/BBtRsm9AuSTNohwevDr2ApSbw7Qv+cH2v\n7QI0ZhesW7/xE7O2eaue8Z7rjyHxjNNJOK3Tfj9wZzmjdM+tWl/c6q+DngcClxVw\ntd8exW1+V+2Uh+asbfnUK6XED+qXWm7ze4CmNCE/XOviMn+ylw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hs-esslingen.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hs-esslingen.de,OU=Rechenzentrum,O=Hochschule Esslingen,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFMTCCBBmgAwIBAgIEDmrJ1DANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJE\nRTEdMBsGA1UEChMUSG9jaHNjaHVsZSBFc3NsaW5nZW4xFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xFDASBgNVBAMTC0hFIENBIC0gRzAyMB4XDTA5MDcwMTExNDUwOFoX\nDTEyMDYzMDExNDUwOFowYjELMAkGA1UEBhMCREUxHTAbBgNVBAoTFEhvY2hzY2h1\nbGUgRXNzbGluZ2VuMRYwFAYDVQQLEw1SZWNoZW56ZW50cnVtMRwwGgYDVQQDExNp\nZHAuaHMtZXNzbGluZ2VuLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEAjzTPiYiYIOSVgiDz4a93Y7tHHSRtop49YDlicY5p2hieQfYq+SPMCq++IyIw\nIC1rpUQ1jIicDMv0zD7aWHEdOAmoT7qoZUWhqOMWKgKrXZQUXA1cjaYbmqEGQxar\n37UfTJA+UOVKX+JvMl/7Rp6YmsIiLRIR1wWBkAlcdeTKmU1sAVlmU4nQ/VRITMCp\nIj8/ZQzdoBuhccT92y7Wz8l6GU33UJLwHnzGCgWgyB9D8PwhJj9XEseKBtsmj9x8\nid/S6w7cFDyexuNZd1ceQONUSTlNI2HqV+HRSfaQAUsGC5khG3L2jNwPOvHMFh3a\nLisPMmZncvKPhia9Ch/i4gRr/QIDAQABo4IB9TCCAfEwCQYDVR0TBAIwADALBgNV\nHQ8EBAMCBeAwNAYDVR0lBC0wKwYIKwYBBQUHAwIGCCsGAQUFBwMBBgorBgEEAYI3\nCgMDBglghkgBhvhCBAEwHQYDVR0OBBYEFHDb9XHfqLM+hzTvY2T/5WRCzj0oMB8G\nA1UdIwQYMBaAFONbF7zWLDJlMkDdTRfAN946TV9cMCQGA1UdEQQdMBuBGWFhaS1h\nZG1pbkBocy1lc3NsaW5nZW4uZGUwgY8GA1UdHwSBhzCBhDBAoD6gPIY6aHR0cDov\nL2NkcDEucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4tY2EvcHViL2NybC9nX2NhY3Js\nLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS9ocy1lc3NsaW5nZW4t\nY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZswgZgwSgYIKwYB\nBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaHMtZXNzbGluZ2VuLWNhL3B1\nYi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRwOi8vY2RwMi5w\nY2EuZGZuLmRlL2hzLWVzc2xpbmdlbi1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNy\ndDANBgkqhkiG9w0BAQUFAAOCAQEAUOq3J7g8KIhllj9REZGArIDDEDTKHz4v+nxK\n18HU/a++spk27pnJDZqQFTN59KxpzQaqVgrjoXTxIDib8VJlIKG0ddp2qKFXqKN2\n1mW9A3AYKFASEQB+x7BWsf74g62dn/tIptf190Cb8E8r1kbWTHILw+gGLwd2tOk8\nIQQsBIAbMkd3rtoJ0OqTTwab6qI0SX/BBtRsm9AuSTNohwevDr2ApSbw7Qv+cH2v\n7QI0ZhesW7/xE7O2eaue8Z7rjyHxjNNJOK3Tfj9wZzmjdM+tWl/c6q+DngcClxVw\ntd8exW1+V+2Uh+asbfnUK6XED+qXWm7ze4CmNCE/XOviMn+ylw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Hochschule Esslingen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Hochschule Esslingen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hs-esslingen.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Herbert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "Herbert.Wiese@hs-esslingen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Wiese", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Martin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "admin@hs-esslingen.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schmid", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://cafe.ifpi.edu.br/idp/shibboleth", 
    {
      "entity_id": "https://cafe.ifpi.edu.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/cafe.ifpi.edu.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe.ifpi.edu.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ifpi.edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ifpi.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ifpi.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "IFPI - Instituto Federal do Piaui", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID0jCCAroCAQAwDQYJKoZIhvcNAQEFBQAwga4xKjAoBgNVBAoTIUlGUEkgLSBJ\nbnN0aXR1dG8gRmVkZXJhbCBkbyBQaWF1aTE1MDMGA1UECxMsRFRJIC0gRGlyZXRv\ncmlhIGRlIFRlY25vbG9naWEgZGEgSW5mb3JtYXRpY2ExETAPBgNVBAcTCFRlcmVz\naW5hMQ4wDAYDVQQIEwVQaWF1aTELMAkGA1UEBhMCQlIxGTAXBgNVBAMTEGNhZmUu\naWZwaS5lZHUuYnIwHhcNMTIwMzA4MTYyNTQyWhcNMTUwMzA4MTYyNTQyWjCBrjEq\nMCgGA1UEChMhSUZQSSAtIEluc3RpdHV0byBGZWRlcmFsIGRvIFBpYXVpMTUwMwYD\nVQQLEyxEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBkYSBJbmZvcm1hdGlj\nYTERMA8GA1UEBxMIVGVyZXNpbmExDjAMBgNVBAgTBVBpYXVpMQswCQYDVQQGEwJC\nUjEZMBcGA1UEAxMQY2FmZS5pZnBpLmVkdS5icjCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBAMQd7Bb3N4li2CCgKYw+KTPSXGW+YPzKJCu3hPc6ObQzb0CN\ntqnNEX3vA/tBZt7hS7XfCdOuwPvHA8ZdVFTlDx2mQu26KHXN20O2WittOtMiD7pe\nlPsa72/HVPLKUVxhkafhVL5MpJhv4oZf5uLPYVRhx4ZpoAjkXvIVu6eKXunJZ/hL\nqUymk3/Srt6kFLnX2UAEQQcxoLlXNKlUVwNPVjZf5UBRKMckpWCdvW3chSnSmUHg\nMI/ASJzp1Ob2Ef+xsAU5bzIFgaVnGUkaOrPzz3INjerXrtee/g0XZ1qSPEpX+31J\nto0UWMBUjTpF5L519WTOrPZB9NgFFrrE5epG/70CAwEAATANBgkqhkiG9w0BAQUF\nAAOCAQEAHCfbOer/V7b9fUJ61tNCSRb/868nudvWDxy66/iBCUwvhXw9bDWszY0K\nOSP/8qI03Lvyt7/JqR2jqV15VBNrSCv5avGNE/sd/4cv3LGeqyoFTNudQPcrHVf+\nxuv71hJ0LHNzh1PDiklIYzcOzi/bJm3dd4DwxRA7uAqVLZzhi3XywQswgvDFZ1G1\nVnM8IFE6OfIb5b5EkQWQKMJ2i75/YL0Qqi7XUlLb8OYfoxi003HyM5QuJqynea8L\nDOPsk2WAnhI0wZtPxcZv6JKawH3m7/41wUm6EdGO0BPjAamRYFOmNyJthdlJxEDm\n2dFaz6UnNXlYSIMJ6HtpNFz/DQw1zA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe.ifpi.edu.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIID0jCCAroCAQAwDQYJKoZIhvcNAQEFBQAwga4xKjAoBgNVBAoTIUlGUEkgLSBJ\nbnN0aXR1dG8gRmVkZXJhbCBkbyBQaWF1aTE1MDMGA1UECxMsRFRJIC0gRGlyZXRv\ncmlhIGRlIFRlY25vbG9naWEgZGEgSW5mb3JtYXRpY2ExETAPBgNVBAcTCFRlcmVz\naW5hMQ4wDAYDVQQIEwVQaWF1aTELMAkGA1UEBhMCQlIxGTAXBgNVBAMTEGNhZmUu\naWZwaS5lZHUuYnIwHhcNMTIwMzA4MTYyNTQyWhcNMTUwMzA4MTYyNTQyWjCBrjEq\nMCgGA1UEChMhSUZQSSAtIEluc3RpdHV0byBGZWRlcmFsIGRvIFBpYXVpMTUwMwYD\nVQQLEyxEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBkYSBJbmZvcm1hdGlj\nYTERMA8GA1UEBxMIVGVyZXNpbmExDjAMBgNVBAgTBVBpYXVpMQswCQYDVQQGEwJC\nUjEZMBcGA1UEAxMQY2FmZS5pZnBpLmVkdS5icjCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBAMQd7Bb3N4li2CCgKYw+KTPSXGW+YPzKJCu3hPc6ObQzb0CN\ntqnNEX3vA/tBZt7hS7XfCdOuwPvHA8ZdVFTlDx2mQu26KHXN20O2WittOtMiD7pe\nlPsa72/HVPLKUVxhkafhVL5MpJhv4oZf5uLPYVRhx4ZpoAjkXvIVu6eKXunJZ/hL\nqUymk3/Srt6kFLnX2UAEQQcxoLlXNKlUVwNPVjZf5UBRKMckpWCdvW3chSnSmUHg\nMI/ASJzp1Ob2Ef+xsAU5bzIFgaVnGUkaOrPzz3INjerXrtee/g0XZ1qSPEpX+31J\nto0UWMBUjTpF5L519WTOrPZB9NgFFrrE5epG/70CAwEAATANBgkqhkiG9w0BAQUF\nAAOCAQEAHCfbOer/V7b9fUJ61tNCSRb/868nudvWDxy66/iBCUwvhXw9bDWszY0K\nOSP/8qI03Lvyt7/JqR2jqV15VBNrSCv5avGNE/sd/4cv3LGeqyoFTNudQPcrHVf+\nxuv71hJ0LHNzh1PDiklIYzcOzi/bJm3dd4DwxRA7uAqVLZzhi3XywQswgvDFZ1G1\nVnM8IFE6OfIb5b5EkQWQKMJ2i75/YL0Qqi7XUlLb8OYfoxi003HyM5QuJqynea8L\nDOPsk2WAnhI0wZtPxcZv6JKawH3m7/41wUm6EdGO0BPjAamRYFOmNyJthdlJxEDm\n2dFaz6UnNXlYSIMJ6HtpNFz/DQw1zA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "IFPI - Instituto Federal do Piaui", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ifpi.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ifpi.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "manuel@ifpi.edu.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Manuel Goncalves da Silva Neto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://gallus.scilifelab.se/shibboleth", 
    {
      "entity_id": "https://gallus.scilifelab.se/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/gallus.scilifelab.se.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://gallus.scilifelab.se/Shibboleth.sso/Login"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://gallus.scilifelab.se/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "encryption_method": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes128-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes192-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#aes256-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2009/xmlenc11#rsa-oaep"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EncryptionMethod", 
                  "algorithm": "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"
                }
              ], 
              "key_info": {
                "key_name": [
                  {
                    "text": "gallus.scilifelab.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "http://gallus.scilifelab.se/", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=gallus.scilifelab.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDITCCAgmgAwIBAgIJAMNm2ATTA3mgMA0GCSqGSIb3DQEBBQUAMB8xHTAbBgNV\nBAMTFGdhbGx1cy5zY2lsaWZlbGFiLnNlMB4XDTEyMDgwNjExNDIwN1oXDTIyMDgw\nNDExNDIwN1owHzEdMBsGA1UEAxMUZ2FsbHVzLnNjaWxpZmVsYWIuc2UwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDJ5UUWP6K/vHk6+uLJPsuNDRxvSi/C\nyjL6e8OevDofr5REK3Ttuhq+qvFwlSUDqHCzeGZxH819Xwok5gJasLf4KKlV6k6H\nuSaRN/njMDwBjloUyja1P/ja5LgFmzly4Pm3VnKIw4MTxeXlLRhEDOSDv303Wp6e\nZpS/vNDkkZbEYpM4iMh6FQM2sIb6EaHYXnicYd4k+1fnWiCiuydG23emvGHmT5Tn\nrOFYI1LSpLGBwkwlM1FDoPCufWYhweHg4LuiUPmbxlQEdJOqy6JrqvFYrYPRV3UR\ntE/OBJ2Ld8L07xlL0o7b8q9+2ccU2ad6XmEs29YsnaMOCvqCBs1GPgH5AgMBAAGj\nYDBeMD0GA1UdEQQ2MDSCFGdhbGx1cy5zY2lsaWZlbGFiLnNlhhxodHRwOi8vZ2Fs\nbHVzLnNjaWxpZmVsYWIuc2UvMB0GA1UdDgQWBBSvHdjNMd+O6sjfHQTrJmhBVxRh\nqzANBgkqhkiG9w0BAQUFAAOCAQEAgzfV6iPbPgfPuWa+/faIYEFV2eKtjzQb74f+\nFe9SYZtBlKtXIPo5oJCx22oh3sDcSJtklRrp+HtVY7Op1sHxaKhEOWjq5hJrrp+9\npRVTnJVCtaIUBcajWMwfG2O1H8Tkpetnj/8qLDaTW0Fd3pF9e4vsIAs66/knJ9bT\nwiCijozckPEz8KVGgW/4TLB8F8ErIHDWVFU4cSezFknpqfe/qPWnCA3E/JVrJhki\nyJdT9GhQ6NTeXbhHS6otn+MTJrWd1kB2hT417PEcHZQO4bbyMWZjsNFgd0haIcOh\nqR3yqb2bdeQUWqkU0/5RA1uDcK8D+f2xAC2npJVHTd1a+1rKgA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://gallus.scilifelab.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "id": "_73535aaf799a6484102c4561ae48c5ce18cfde0c"
    }
  ], 
  [
    "https://www.ifmsa.se/sp", 
    {
      "entity_id": "https://www.ifmsa.se/sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/www.ifmsa.se.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/eu-adequate-protection", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ifmsa.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.ifmsa.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "ifmsa.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ifmsa.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC3zCCAcegAwIBAgIJAJSL4oXsFFGDMA0GCSqGSIb3DQEBBQUAMBMxETAPBgNV\nBAMTCGlmbXNhLnNlMB4XDTEyMDkwNjEyMjYxNloXDTIyMDkwNDEyMjYxNlowEzER\nMA8GA1UEAxMIaWZtc2Euc2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQDBiLhwVpqbr3rI7WcjH4MId7XxuayfJjSCt//kzKVQvMetGh302UQ8YdveRIic\ntIjQ4fjuF2F+GUJyC4nEX3zdsQusCbRA7Dq70K1d5qkT1qvh0leYWBrr2XbXZCIQ\n4/tl4uEHJyXKP5vgWXjqf2mBIYHNsIy068JVfH1dGZ+zBr7H5cebMRG9r/aC90Yl\nWvZ24qFRmCuNGp+pP5/H/jm0ZnQ38QzHF9WCmWfDuL4p+5PBxOab5LCEaT6113MN\n5mOBwbjcFozKzZ2lAX3F0c9K0FqdBxm7hHFm40smzjnnFsgu5TtBIH5Sjgw61QZB\nMzNfuDlKJ6Wt8bjrytYOrNsJAgMBAAGjNjA0MBMGA1UdEQQMMAqCCGlmbXNhLnNl\nMB0GA1UdDgQWBBQSYXjcmZHvwcBTDE45NlQOMwy4UjANBgkqhkiG9w0BAQUFAAOC\nAQEAZRggMXTdRBuNvZFmjYbrDmRgDEdmbaAQ0mfkfD0imSulc39RRq3+9uaRzmTl\n/uThMJwgFtIjrEChsh8Gv0nzk6SuXGwTPybu0wPBBCP1TRZgKl6oGaWUK8kpBy6g\ntkBxI6tIDSkEFpG2CP+Sj6MFYNeI8p2+GuhiAyW1X6bKnIIO7aSgdhU9fV1/mMzt\nMcQYhqSDMw8qGAXKxF3942Ft3gXvnstP3X8l5LM2Ypih/ZDo4PUwUyiEw3RQUXKz\nX40wJ5KGvRmsxTM5VbkQ8wS7EWuIkQG/iXCyD+b1BExCsuXvX3nN24bsBLUtV8wE\n2qw2QAI6MLkoVEpC6c1oX0xn+Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.ifmsa.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "contact_type": "technical", 
          "company": {
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Liu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Mats", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "admin@ifmsa.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }, 
        {
          "contact_type": "administrative", 
          "company": {
            "text": "IFMSA-Sweden", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Liu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Mats", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "admin@ifmsa.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shib.ufg.br/idp/shibboleth", 
    {
      "entity_id": "https://shib.ufg.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shib.ufg.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib.ufg.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufg.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufg.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufg.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFG - Universidade Federal de Goias", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEGDCCAwACAQAwDQYJKoZIhvcNAQEFBQAwgdExLTArBgNVBAoUJFVGRyAtIFVu\naXZlcnNpZGFkZSBGZWRlcmFsIGRlIEdvacOhczE0MDIGA1UECxMrQ0VSQ09NUCAt\nIENlbnRybyBkZSBSZWN1cnNvcyBDb21wdXRhY2lvbmFpczEjMCEGCSqGSIb3DQEJ\nARYUcmVkZXNAY2VyY29tcC51ZmcuYnIxETAPBgNVBAcUCEdvacOibmlhMQ8wDQYD\nVQQIFAZHb2nDoXMxCzAJBgNVBAYTAkJSMRQwEgYDVQQDEwtzaGliLnVmZy5icjAe\nFw0xMTAzMTAxOTQ2MzZaFw0xNDAzMDkxOTQ2MzZaMIHRMS0wKwYDVQQKFCRVRkcg\nLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBHb2nDoXMxNDAyBgNVBAsTK0NFUkNP\nTVAgLSBDZW50cm8gZGUgUmVjdXJzb3MgQ29tcHV0YWNpb25haXMxIzAhBgkqhkiG\n9w0BCQEWFHJlZGVzQGNlcmNvbXAudWZnLmJyMREwDwYDVQQHFAhHb2nDom5pYTEP\nMA0GA1UECBQGR29pw6FzMQswCQYDVQQGEwJCUjEUMBIGA1UEAxMLc2hpYi51Zmcu\nYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDjd7v1zv9XiZujENay\nVRf+lRcFHvUq3KtLFWnys3UhsAlQPiXl3rCdCV3qgC3mLFKoQtCIvxW0ubaX7E+7\nU1FGdLZHZBgkCXdvJ32wMtF/DEhiD/AwT6JMjSWLcE9eGK35NBaB6kC91Pn9oID8\nOjggQmFAot2NQ7KRlSNJg3nY3RQYCFZghgsLec9+0h/YHaRuKgDKcFnreAQ9UQ4M\n4Q1jPKitFkn/IJa2okSwXIu6gwV/2Y2I92ar3LgbNfpXCPW/gGqflkPEA+4AXwRb\n7ZbOdqsDg/PLMzi3jS4VHIOVUHx4fg7PZF+CEJpNG65i5pQB2d9VI2he2e3gUtnY\nxZeBAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAJSsyw+/FRhaSSFPutZN5upO6q/A\nlrui0K4WMGeEh6mJmZu2vX1MB2H7ljxtxZ2I1Gmi4/oNzLzzz4o4lglpN0jnnWx0\nVBZYB+hVNrn03riHaAj9lB4H0IvPGkjsz5j0WM/1To5Mi6iFY+1ac+1p2oFdIWLX\nvoqnzQVYm+5/3zSbVVYFRE5YA655K80+D5F1CxGaaSeEl61lX8G3ncyLJ8GjGQy7\nEuXcPceE+fwojuBV3wZl5Hl6OkeoB9sS+7zuPyc7TWTLxCsrWHRDWlRtargNuxPn\n2KF7d+EaJHILB9sC/ESy/4TMy+XvpU/T1ylvRR2+bW24nPGKHuGuqmETC6I=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib.ufg.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufg.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEGDCCAwACAQAwDQYJKoZIhvcNAQEFBQAwgdExLTArBgNVBAoUJFVGRyAtIFVu\naXZlcnNpZGFkZSBGZWRlcmFsIGRlIEdvacOhczE0MDIGA1UECxMrQ0VSQ09NUCAt\nIENlbnRybyBkZSBSZWN1cnNvcyBDb21wdXRhY2lvbmFpczEjMCEGCSqGSIb3DQEJ\nARYUcmVkZXNAY2VyY29tcC51ZmcuYnIxETAPBgNVBAcUCEdvacOibmlhMQ8wDQYD\nVQQIFAZHb2nDoXMxCzAJBgNVBAYTAkJSMRQwEgYDVQQDEwtzaGliLnVmZy5icjAe\nFw0xMTAzMTAxOTQ2MzZaFw0xNDAzMDkxOTQ2MzZaMIHRMS0wKwYDVQQKFCRVRkcg\nLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBHb2nDoXMxNDAyBgNVBAsTK0NFUkNP\nTVAgLSBDZW50cm8gZGUgUmVjdXJzb3MgQ29tcHV0YWNpb25haXMxIzAhBgkqhkiG\n9w0BCQEWFHJlZGVzQGNlcmNvbXAudWZnLmJyMREwDwYDVQQHFAhHb2nDom5pYTEP\nMA0GA1UECBQGR29pw6FzMQswCQYDVQQGEwJCUjEUMBIGA1UEAxMLc2hpYi51Zmcu\nYnIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDjd7v1zv9XiZujENay\nVRf+lRcFHvUq3KtLFWnys3UhsAlQPiXl3rCdCV3qgC3mLFKoQtCIvxW0ubaX7E+7\nU1FGdLZHZBgkCXdvJ32wMtF/DEhiD/AwT6JMjSWLcE9eGK35NBaB6kC91Pn9oID8\nOjggQmFAot2NQ7KRlSNJg3nY3RQYCFZghgsLec9+0h/YHaRuKgDKcFnreAQ9UQ4M\n4Q1jPKitFkn/IJa2okSwXIu6gwV/2Y2I92ar3LgbNfpXCPW/gGqflkPEA+4AXwRb\n7ZbOdqsDg/PLMzi3jS4VHIOVUHx4fg7PZF+CEJpNG65i5pQB2d9VI2he2e3gUtnY\nxZeBAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAJSsyw+/FRhaSSFPutZN5upO6q/A\nlrui0K4WMGeEh6mJmZu2vX1MB2H7ljxtxZ2I1Gmi4/oNzLzzz4o4lglpN0jnnWx0\nVBZYB+hVNrn03riHaAj9lB4H0IvPGkjsz5j0WM/1To5Mi6iFY+1ac+1p2oFdIWLX\nvoqnzQVYm+5/3zSbVVYFRE5YA655K80+D5F1CxGaaSeEl61lX8G3ncyLJ8GjGQy7\nEuXcPceE+fwojuBV3wZl5Hl6OkeoB9sS+7zuPyc7TWTLxCsrWHRDWlRtargNuxPn\n2KF7d+EaJHILB9sC/ESy/4TMy+XvpU/T1ylvRR2+bW24nPGKHuGuqmETC6I=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFG - Universidade Federal de Goias", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufg.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufg.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "douglasfilho@cercomp.ufg.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Douglas Borges de Oliveira Filho", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp2.civ.cvut.cz/idp/shibboleth", 
    {
      "entity_id": "https://idp2.civ.cvut.cz/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp2.civ.cvut.cz.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.civ.cvut.cz/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.civ.cvut.cz/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.civ.cvut.cz/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.civ.cvut.cz/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "cvut.cz", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "logo": [
                  {
                    "text": "https://idp2.civ.cvut.cz/idp/images/logo_cvut_40pix.png", 
                    "width": "53", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "40"
                  }
                ], 
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.cvut.cz/en", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "http://www.cvut.cz/cs", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "CTU in Prague", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "\u010cVUT v Praze", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Identity Provider for CTU in Prague", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "Identity Provider pro \u010cVUT v Praze", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEfTCCA2WgAwIBAgIRALXH4vfn8/gr0Iw5Iowy/gEwDQYJKoZIhvcNAQEFBQAw\n\t\t\t    NjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\n\t\t\t    IFNTTCBDQTAeFw0xMjExMjEwMDAwMDBaFw0xNTExMjEyMzU5NTlaMFcxCzAJBgNV\n\t\t\t    BAYTAkNaMS0wKwYDVQQKEyRDemVjaCBUZWNobmljYWwgVW5pdmVyc2l0eSBpbiBQ\n\t\t\t    cmFndWUxGTAXBgNVBAMTEGlkcDIuY2l2LmN2dXQuY3owggEiMA0GCSqGSIb3DQEB\n\t\t\t    AQUAA4IBDwAwggEKAoIBAQDIAANNkRJrnWIbXPvPd1g/2Dlj8SObKDs4aLG90fkl\n\t\t\t    7XvId+XJ71GJ8aEjJ9lGAEqs2a9sgm2WpcLQ/B+Y9veRyRtnaK0Ywd8+iSThsA58\n\t\t\t    oTN5H3V3m/M0oMTd9UPkQSHCLUn+Dp1w04DJ6J8ECWoI2rvIblGHGzxfzF4cb2KH\n\t\t\t    aMvWDGSuiQh6GeKkwHDTVTr9pZK8Evcw7RT/4KlChf5hfFD3ZwGsrWCjI25NrR+6\n\t\t\t    753XeaVIOOCKZladSF/93t8kAM4Z+n/ijQDytg3v4poSt0LM5X4+8b7AYTDSjkUq\n\t\t\t    Nh36JZ+OZY4jRrBsrM0S4RXWuPB9DEc8hLe/CIRZWGIzAgMBAAGjggFjMIIBXzAf\n\t\t\t    BgNVHSMEGDAWgBQMvZNoDPPeq6NJays3V0fqkOO57TAdBgNVHQ4EFgQUWkdTT+6T\n\t\t\t    qjlT9i5aI+IBxfKpCm4wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\n\t\t\t    VR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMBgGA1UdIAQRMA8wDQYLKwYBBAGy\n\t\t\t    MQECAh0wOgYDVR0fBDMwMTAvoC2gK4YpaHR0cDovL2NybC50Y3MudGVyZW5hLm9y\n\t\t\t    Zy9URVJFTkFTU0xDQS5jcmwwbQYIKwYBBQUHAQEEYTBfMDUGCCsGAQUFBzAChilo\n\t\t\t    dHRwOi8vY3J0LnRjcy50ZXJlbmEub3JnL1RFUkVOQVNTTENBLmNydDAmBggrBgEF\n\t\t\t    BQcwAYYaaHR0cDovL29jc3AudGNzLnRlcmVuYS5vcmcwGwYDVR0RBBQwEoIQaWRw\n\t\t\t    Mi5jaXYuY3Z1dC5jejANBgkqhkiG9w0BAQUFAAOCAQEAvV4rEv6A07BXcUMTF6+z\n\t\t\t    Da8v2shV1S+f0SGfIdL1DzvaUFf7VAWuKOlwny8OfpzXVCs3yg+KSDWUWi8HWR6y\n\t\t\t    dKWsuHljnD2DxAAPQNZeuESbPSyeZK/EJdSu4Ii+OH0exDRjZjZ3v3VsoueQ41tt\n\t\t\t    1/Fji03+9bZCQi9dOQpQji/q2SrnKRpPsoCemY+bo8E7SanrUd7jwX1ef6HaOnTP\n\t\t\t    l8oHphtTzvbg+i3qaTH9bDQXdXbcFZPklU7+5k80wHe56+1sECQ5g1lB+ZFzx1Oi\n\t\t\t    i5rCf/Zx3bkYkE+xPXAOcCGEWs35at7QpIXuoG9FDU8UKW2cMgEq9GEOddx/wVqB\n\t\t\t    6w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.civ.cvut.cz:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.civ.cvut.cz:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.eduid.cz/wiki/_media/en/eduid/policy/policy_eduid_en-1_1.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }, 
              {
                "lang": "cs", 
                "text": "http://www.eduid.cz/wiki/_media/eduid/policy/policy_eduid_cz-1_1-3.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://www.eduid.cz/"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.civ.cvut.cz:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.civ.cvut.cz:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "cvut.cz", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEfTCCA2WgAwIBAgIRALXH4vfn8/gr0Iw5Iowy/gEwDQYJKoZIhvcNAQEFBQAw\n\t\t\t    NjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\n\t\t\t    IFNTTCBDQTAeFw0xMjExMjEwMDAwMDBaFw0xNTExMjEyMzU5NTlaMFcxCzAJBgNV\n\t\t\t    BAYTAkNaMS0wKwYDVQQKEyRDemVjaCBUZWNobmljYWwgVW5pdmVyc2l0eSBpbiBQ\n\t\t\t    cmFndWUxGTAXBgNVBAMTEGlkcDIuY2l2LmN2dXQuY3owggEiMA0GCSqGSIb3DQEB\n\t\t\t    AQUAA4IBDwAwggEKAoIBAQDIAANNkRJrnWIbXPvPd1g/2Dlj8SObKDs4aLG90fkl\n\t\t\t    7XvId+XJ71GJ8aEjJ9lGAEqs2a9sgm2WpcLQ/B+Y9veRyRtnaK0Ywd8+iSThsA58\n\t\t\t    oTN5H3V3m/M0oMTd9UPkQSHCLUn+Dp1w04DJ6J8ECWoI2rvIblGHGzxfzF4cb2KH\n\t\t\t    aMvWDGSuiQh6GeKkwHDTVTr9pZK8Evcw7RT/4KlChf5hfFD3ZwGsrWCjI25NrR+6\n\t\t\t    753XeaVIOOCKZladSF/93t8kAM4Z+n/ijQDytg3v4poSt0LM5X4+8b7AYTDSjkUq\n\t\t\t    Nh36JZ+OZY4jRrBsrM0S4RXWuPB9DEc8hLe/CIRZWGIzAgMBAAGjggFjMIIBXzAf\n\t\t\t    BgNVHSMEGDAWgBQMvZNoDPPeq6NJays3V0fqkOO57TAdBgNVHQ4EFgQUWkdTT+6T\n\t\t\t    qjlT9i5aI+IBxfKpCm4wDgYDVR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHQYD\n\t\t\t    VR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMBgGA1UdIAQRMA8wDQYLKwYBBAGy\n\t\t\t    MQECAh0wOgYDVR0fBDMwMTAvoC2gK4YpaHR0cDovL2NybC50Y3MudGVyZW5hLm9y\n\t\t\t    Zy9URVJFTkFTU0xDQS5jcmwwbQYIKwYBBQUHAQEEYTBfMDUGCCsGAQUFBzAChilo\n\t\t\t    dHRwOi8vY3J0LnRjcy50ZXJlbmEub3JnL1RFUkVOQVNTTENBLmNydDAmBggrBgEF\n\t\t\t    BQcwAYYaaHR0cDovL29jc3AudGNzLnRlcmVuYS5vcmcwGwYDVR0RBBQwEoIQaWRw\n\t\t\t    Mi5jaXYuY3Z1dC5jejANBgkqhkiG9w0BAQUFAAOCAQEAvV4rEv6A07BXcUMTF6+z\n\t\t\t    Da8v2shV1S+f0SGfIdL1DzvaUFf7VAWuKOlwny8OfpzXVCs3yg+KSDWUWi8HWR6y\n\t\t\t    dKWsuHljnD2DxAAPQNZeuESbPSyeZK/EJdSu4Ii+OH0exDRjZjZ3v3VsoueQ41tt\n\t\t\t    1/Fji03+9bZCQi9dOQpQji/q2SrnKRpPsoCemY+bo8E7SanrUd7jwX1ef6HaOnTP\n\t\t\t    l8oHphtTzvbg+i3qaTH9bDQXdXbcFZPklU7+5k80wHe56+1sECQ5g1lB+ZFzx1Oi\n\t\t\t    i5rCf/Zx3bkYkE+xPXAOcCGEWs35at7QpIXuoG9FDU8UKW2cMgEq9GEOddx/wVqB\n\t\t\t    6w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "cs", 
            "text": "\u010cVUT", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "CTU", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "cs", 
            "text": "\u010cesk\u00e9 vysok\u00e9 u\u010den\u00ed technick\u00e9 v Praze", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "Ceske vysoke uceni technicke v Praze", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "cs", 
            "text": "http://www.cvut.cz/cs", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.cvut.cz/en", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Petr", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "strupl@vc.cvut.cz", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Strupl", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://shib.alexanderstreet.com/shibboleth-sp", 
    {
      "entity_id": "https://shib.alexanderstreet.com/shibboleth-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shib.alexanderstreet.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Alexander Street Press LLC.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Alexander Street Press LLC", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://alexanderstreet.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Nathanel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "nathanels@astreetpress.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Sulimanov", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "John", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jfield@astreetpress.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Field", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SLO/SOAP"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://shib.alexanderstreet.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://shib.alexanderstreet.com/Shibboleth.sso/WAYF"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shib.alexanderstreet.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shib.alexanderstreet.com,O=Alexander Street Press,L=Alexandria,ST=Virginia,C=US", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDbjCCAlYCCQDBNjJ+wWhziDANBgkqhkiG9w0BAQUFADB5MQswCQYDVQQGEwJV\nUzERMA8GA1UECBMIVmlyZ2luaWExEzARBgNVBAcTCkFsZXhhbmRyaWExHzAdBgNV\nBAoTFkFsZXhhbmRlciBTdHJlZXQgUHJlc3MxITAfBgNVBAMTGHNoaWIuYWxleGFu\nZGVyc3RyZWV0LmNvbTAeFw0xMTEwMjcxMzQ5NDNaFw0xNDEwMjExMzQ5NDNaMHkx\nCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhWaXJnaW5pYTETMBEGA1UEBxMKQWxleGFu\nZHJpYTEfMB0GA1UEChMWQWxleGFuZGVyIFN0cmVldCBQcmVzczEhMB8GA1UEAxMY\nc2hpYi5hbGV4YW5kZXJzdHJlZXQuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEAm7HquS72lySd0gXBNERWazSe97ShgPJwSldxjqBuQ1BvBRp9kdlC\noAZcHmlmsleyIFPOvbc+zaZcYprMj8vmwq3aUE8U5bmpo3WFk8DlrFgzPEIFXuHF\n3/On24Id+WSpajoTOMoopw4uDG2FHbpEKnbMB9MAHK0eVVXfnj/PfwjIEZfw5kBg\n3jpJri3fZME7VQFP6pGS1TlEWslw2PcGlhkQjyiHHzZpHMmfwUKm0QzBMY49HecX\nweB8PmIS5Pnrydx3x09/De8GTJn6rGuYhu7aF0GTw9kC0oToJAF8A2xN9vyXcMtx\nbaMAro05qxlTIOWC1yNeGk9dfcdcTsFeBQIDAQABMA0GCSqGSIb3DQEBBQUAA4IB\nAQBziIy25B83PAlHfpZroG4o6kVdyHKtr26IIb7+8l/5xOg+DZZAqP9KMbScBN1T\nXnKZf7nWfg0CPgrkZFx/M4jCrJgY5eQVlKcxhHGA3b7dXT36DK6gpcxWyB0Hkm1c\n9F++liEzSYao5HItr9epelUvzoQjY/aLT+rGzj0TmufvNxIULojZcWP/CZ1VWVVK\nk4/vgLZs88Ow9eY0GVRAO0g47xPsI4Ozu7HFVZeUsrhouwJKUOdBdHx75mxfoQDP\n68FuNHZ4/rGoVHSJlPjW9zgnNHa3yfGfPN4axlzscowZV/7yGJxeoeBLmicXr+mW\nIeRCblzZC+JMvA/j4d6Mi/s8", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "shib.alexanderstreet.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shib.alexanderstreet.com,O=Alexander Street Press,L=Alexandria,ST=Virginia,C=US", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDbjCCAlYCCQDBNjJ+wWhziDANBgkqhkiG9w0BAQUFADB5MQswCQYDVQQGEwJV\nUzERMA8GA1UECBMIVmlyZ2luaWExEzARBgNVBAcTCkFsZXhhbmRyaWExHzAdBgNV\nBAoTFkFsZXhhbmRlciBTdHJlZXQgUHJlc3MxITAfBgNVBAMTGHNoaWIuYWxleGFu\nZGVyc3RyZWV0LmNvbTAeFw0xMTEwMjcxMzQ5NDNaFw0xNDEwMjExMzQ5NDNaMHkx\nCzAJBgNVBAYTAlVTMREwDwYDVQQIEwhWaXJnaW5pYTETMBEGA1UEBxMKQWxleGFu\nZHJpYTEfMB0GA1UEChMWQWxleGFuZGVyIFN0cmVldCBQcmVzczEhMB8GA1UEAxMY\nc2hpYi5hbGV4YW5kZXJzdHJlZXQuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEAm7HquS72lySd0gXBNERWazSe97ShgPJwSldxjqBuQ1BvBRp9kdlC\noAZcHmlmsleyIFPOvbc+zaZcYprMj8vmwq3aUE8U5bmpo3WFk8DlrFgzPEIFXuHF\n3/On24Id+WSpajoTOMoopw4uDG2FHbpEKnbMB9MAHK0eVVXfnj/PfwjIEZfw5kBg\n3jpJri3fZME7VQFP6pGS1TlEWslw2PcGlhkQjyiHHzZpHMmfwUKm0QzBMY49HecX\nweB8PmIS5Pnrydx3x09/De8GTJn6rGuYhu7aF0GTw9kC0oToJAF8A2xN9vyXcMtx\nbaMAro05qxlTIOWC1yNeGk9dfcdcTsFeBQIDAQABMA0GCSqGSIb3DQEBBQUAA4IB\nAQBziIy25B83PAlHfpZroG4o6kVdyHKtr26IIb7+8l/5xOg+DZZAqP9KMbScBN1T\nXnKZf7nWfg0CPgrkZFx/M4jCrJgY5eQVlKcxhHGA3b7dXT36DK6gpcxWyB0Hkm1c\n9F++liEzSYao5HItr9epelUvzoQjY/aLT+rGzj0TmufvNxIULojZcWP/CZ1VWVVK\nk4/vgLZs88Ow9eY0GVRAO0g47xPsI4Ozu7HFVZeUsrhouwJKUOdBdHx75mxfoQDP\n68FuNHZ4/rGoVHSJlPjW9zgnNHa3yfGfPN4axlzscowZV/7yGJxeoeBLmicXr+mW\nIeRCblzZC+JMvA/j4d6Mi/s8", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shib-idp.cms.hu-berlin.de/idp/shibboleth", 
    {
      "entity_id": "https://shib-idp.cms.hu-berlin.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shib-idp.cms.hu-berlin.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "response_location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/Redirect/SLO", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/Redirect/SLO"
            }, 
            {
              "response_location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST/SLO", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST/SLO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML2/SOAP/SLO"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shib-idp.cms.hu-berlin.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uvf.hu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uvf.hu-berlin.de,OU=ZE Computer- und Medienservice,O=Humboldt-Universitaet zu Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFzTCCBLWgAwIBAgIHEqpQbkSDdTANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQG\nEwJERTEoMCYGA1UEChMfSHVtYm9sZHQtVW5pdmVyc2l0YWV0IHp1IEJlcmxpbjEO\nMAwGA1UEAxMFSFUtQ0ExHzAdBgkqhkiG9w0BCQEWEHBraUBodS1iZXJsaW4uZGUw\nHhcNMTExMDA0MDkzMzE5WhcNMTYxMDAyMDkzMzE5WjCBhjELMAkGA1UEBhMCREUx\nKDAmBgNVBAoTH0h1bWJvbGR0LVVuaXZlcnNpdGFldCB6dSBCZXJsaW4xJzAlBgNV\nBAsTHlpFIENvbXB1dGVyLSB1bmQgTWVkaWVuc2VydmljZTEkMCIGA1UEAxMbc2hp\nYmJvbGV0aC51dmYuaHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEA0vBDQzp17iY3EpgON9nw4NprsoHn0GtfkzmL2t1yYRW5U67hdMNg\ntrTQ2OHpD5Yzk2zi88L1y0aRBIsWV/DvvPM+k3NkUKfD5hDrPogHphvUvjIvJG4A\n3oDpb4Tx7TmF1ZBe1M2+xeQ+MhaUrbM8JDcRdgtScgWrEp3qkLY/xMRjVsv6sPbw\n3m3BS2Kayg7Y11d0HCuPYXM8c6dtOSNNKAUYA1IG8FkhtAEVo86goCGETYLQxGLb\nCXfeNg7G8jrKa8NUN0+mOdnpvBX7jSVGSKTYsH3C8QPkMEkYOBCq++WoCDQGIF34\nzAH3QjlIvD6KGKfwFASbV6Q+6jvI1PqG2QIDAQABo4ICWzCCAlcwCQYDVR0TBAIw\nADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0G\nA1UdDgQWBBRgpVpqIZHoHu6A3wNr8YHGwX0chjAfBgNVHSMEGDAWgBQf9Sw+90Cr\nLpCgatPieV7yds2DdDCBtgYDVR0RBIGuMIGrghhzaGliLWRzLmNtcy5odS1iZXJs\naW4uZGWCGXNoaWItaWRwLmNtcy5odS1iZXJsaW4uZGWCHnNoaWJib2xldGgtZHMu\nY21zLmh1LWJlcmxpbi5kZYIfc2hpYmJvbGV0aC1pZHAuY21zLmh1LWJlcmxpbi5k\nZYIbc2hpYmJvbGV0aC51dmYuaHUtYmVybGluLmRlgRZzaGliYWRtaW5AaHUtYmVy\nbGluLmRlMIGDBgNVHR8EfDB6MDugOaA3hjVodHRwOi8vY2RwMS5wY2EuZGZuLmRl\nL2h1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDA7oDmgN4Y1aHR0cDovL2Nk\ncDIucGNhLmRmbi5kZS9odS1iZXJsaW4tY2EvcHViL2NybC9jYWNybC5jcmwwgZ4G\nCCsGAQUFBwEBBIGRMIGOMEUGCCsGAQUFBzAChjlodHRwOi8vY2RwMS5wY2EuZGZu\nLmRlL2h1LWJlcmxpbi1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRQYIKwYBBQUH\nMAKGOWh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHUtYmVybGluLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEABeQzv7HU+e81io7Uh6Ux\n88a61i75dPU+gPsGutyrSj8BGpuYB55gt5Huv95uLXM7XlY4/MzElucvyLdr0nan\n9wO7HpNYVoYfcM2+BT/gD8tQrAPYf49c7vNXN6f4+DAUC66oAMR+6F2tHybAupoE\nqLGnBMAzaKgp9QibCCJb6PnpY6iLNHRMFYFyoYAsST3A8TvEp5o/ga1wziqlWR5U\n63trGi6EXf/TWfqjRVl/vIbqKjJGlXexNaxXUHJmApPMa/J83PE/GZD9nvdYqfli\nXElaOsRM2A6AOAMlKljXc1i3ZeMFMmr5+yOET0AouaSMjgKNn6oBUnf8U34udgZg\nMQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shib-idp.cms.hu-berlin.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hu-berlin.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "shibboleth.uvf.hu-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=shibboleth.uvf.hu-berlin.de,OU=ZE Computer- und Medienservice,O=Humboldt-Universitaet zu Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFzTCCBLWgAwIBAgIHEqpQbkSDdTANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQG\nEwJERTEoMCYGA1UEChMfSHVtYm9sZHQtVW5pdmVyc2l0YWV0IHp1IEJlcmxpbjEO\nMAwGA1UEAxMFSFUtQ0ExHzAdBgkqhkiG9w0BCQEWEHBraUBodS1iZXJsaW4uZGUw\nHhcNMTExMDA0MDkzMzE5WhcNMTYxMDAyMDkzMzE5WjCBhjELMAkGA1UEBhMCREUx\nKDAmBgNVBAoTH0h1bWJvbGR0LVVuaXZlcnNpdGFldCB6dSBCZXJsaW4xJzAlBgNV\nBAsTHlpFIENvbXB1dGVyLSB1bmQgTWVkaWVuc2VydmljZTEkMCIGA1UEAxMbc2hp\nYmJvbGV0aC51dmYuaHUtYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEA0vBDQzp17iY3EpgON9nw4NprsoHn0GtfkzmL2t1yYRW5U67hdMNg\ntrTQ2OHpD5Yzk2zi88L1y0aRBIsWV/DvvPM+k3NkUKfD5hDrPogHphvUvjIvJG4A\n3oDpb4Tx7TmF1ZBe1M2+xeQ+MhaUrbM8JDcRdgtScgWrEp3qkLY/xMRjVsv6sPbw\n3m3BS2Kayg7Y11d0HCuPYXM8c6dtOSNNKAUYA1IG8FkhtAEVo86goCGETYLQxGLb\nCXfeNg7G8jrKa8NUN0+mOdnpvBX7jSVGSKTYsH3C8QPkMEkYOBCq++WoCDQGIF34\nzAH3QjlIvD6KGKfwFASbV6Q+6jvI1PqG2QIDAQABo4ICWzCCAlcwCQYDVR0TBAIw\nADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0G\nA1UdDgQWBBRgpVpqIZHoHu6A3wNr8YHGwX0chjAfBgNVHSMEGDAWgBQf9Sw+90Cr\nLpCgatPieV7yds2DdDCBtgYDVR0RBIGuMIGrghhzaGliLWRzLmNtcy5odS1iZXJs\naW4uZGWCGXNoaWItaWRwLmNtcy5odS1iZXJsaW4uZGWCHnNoaWJib2xldGgtZHMu\nY21zLmh1LWJlcmxpbi5kZYIfc2hpYmJvbGV0aC1pZHAuY21zLmh1LWJlcmxpbi5k\nZYIbc2hpYmJvbGV0aC51dmYuaHUtYmVybGluLmRlgRZzaGliYWRtaW5AaHUtYmVy\nbGluLmRlMIGDBgNVHR8EfDB6MDugOaA3hjVodHRwOi8vY2RwMS5wY2EuZGZuLmRl\nL2h1LWJlcmxpbi1jYS9wdWIvY3JsL2NhY3JsLmNybDA7oDmgN4Y1aHR0cDovL2Nk\ncDIucGNhLmRmbi5kZS9odS1iZXJsaW4tY2EvcHViL2NybC9jYWNybC5jcmwwgZ4G\nCCsGAQUFBwEBBIGRMIGOMEUGCCsGAQUFBzAChjlodHRwOi8vY2RwMS5wY2EuZGZu\nLmRlL2h1LWJlcmxpbi1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRQYIKwYBBQUH\nMAKGOWh0dHA6Ly9jZHAyLnBjYS5kZm4uZGUvaHUtYmVybGluLWNhL3B1Yi9jYWNl\ncnQvY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEABeQzv7HU+e81io7Uh6Ux\n88a61i75dPU+gPsGutyrSj8BGpuYB55gt5Huv95uLXM7XlY4/MzElucvyLdr0nan\n9wO7HpNYVoYfcM2+BT/gD8tQrAPYf49c7vNXN6f4+DAUC66oAMR+6F2tHybAupoE\nqLGnBMAzaKgp9QibCCJb6PnpY6iLNHRMFYFyoYAsST3A8TvEp5o/ga1wziqlWR5U\n63trGi6EXf/TWfqjRVl/vIbqKjJGlXexNaxXUHJmApPMa/J83PE/GZD9nvdYqfli\nXElaOsRM2A6AOAMlKljXc1i3ZeMFMmr5+yOET0AouaSMjgKNn6oBUnf8U34udgZg\nMQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Humboldt-Universit\u00e4t zu Berlin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Humboldt-Universit\u00e4t zu Berlin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hu-berlin.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Petra", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibadmin@hu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Berg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Petra", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "shibadmin@hu-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Berg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://theia.unifei.edu.br/idp/shibboleth", 
    {
      "entity_id": "https://theia.unifei.edu.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/theia.unifei.edu.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://theia.unifei.edu.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "unifei.edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.unifei.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.unifei.edu.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UNIFEI - Universidade Federal de Itajuba", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDqjCCApICAQAwDQYJKoZIhvcNAQEFBQAwgZoxDzANBgNVBAoTBnVuaWZlaTEM\nMAoGA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1\nLmJyMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJ\nBgNVBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMB4XDTExMDIy\nMjE5NDEwNVoXDTE0MDIyMTE5NDEwNVowgZoxDzANBgNVBAoTBnVuaWZlaTEMMAoG\nA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1LmJy\nMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJBgNV\nBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAszS24eQWB14ZsvJbc7/L0OIx91T7/x8eIMAg\niljM/qQb6YscjrpRZF5sMgQExLzvkDWloF10S8tHdAJ85WtLcDHzL6yxv5PlP0dG\n0uA2QL1NqaFYziyasi3MOihRozQ3VyDJLit7nKjb3r9BFlRKxEHH2DzU8ya2q9im\ndlZH9o6jyLk3qYWc88OmshEaqFCzRQre0GPYyLxDgc9mMAtVcG1y5MF2IBxUHG2M\nexL5GNVVRxvH8r+z0ZXssC/35SGmgZXNP83TcAyo7gOcPiLfuNr3E552ffFDjw3i\nGJiR9iyw5sUFMDqMshDUZnaqXpAmHBOGGk/sxa8lcdlJDArBrQIDAQABMA0GCSqG\nSIb3DQEBBQUAA4IBAQBhktjReQRXN2QOley8nhzYJKTThbZdNWg9M7JhClsq43ys\nNMRPWVbGyFPealR7UEAY8NK2i/RBAwAQ1XGvUITAoICuHHzTYBc6EcXp22BEl+gN\nqDLyZOdNaLaWaMpRbd21dBOqe8CTGBxhes5Dwe/L0bBZgV/vHk9Qw6v9I+xaQroW\n3aGrRnyxD8rPbcvLGHUPfoFdskkG2Y7UQUAYy8QlDApcA9hbplhgz5cVmqAR+vli\nFBlXJ1FNxrGhVjRg4ULTHR4H5JA6OXRLjI9gVKPbWk1/SblGi01wStR79SPBXO9c\n2N3Q1WgSwTkR3BxJaxn8/S5iu4mQ+OXuVTxo5R0y", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://theia.unifei.edu.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "unifei.edu.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDqjCCApICAQAwDQYJKoZIhvcNAQEFBQAwgZoxDzANBgNVBAoTBnVuaWZlaTEM\nMAoGA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1\nLmJyMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJ\nBgNVBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMB4XDTExMDIy\nMjE5NDEwNVoXDTE0MDIyMTE5NDEwNVowgZoxDzANBgNVBAoTBnVuaWZlaTEMMAoG\nA1UECxMDZHNpMSUwIwYJKoZIhvcNAQkBFhZldmVyYWxkb0B1bmlmZWkuZWR1LmJy\nMRAwDgYDVQQHEwdpdGFqdWJhMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxCzAJBgNV\nBAYTAkJSMRwwGgYDVQQDExN0aGVpYS51bmlmZWkuZWR1LmJyMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAszS24eQWB14ZsvJbc7/L0OIx91T7/x8eIMAg\niljM/qQb6YscjrpRZF5sMgQExLzvkDWloF10S8tHdAJ85WtLcDHzL6yxv5PlP0dG\n0uA2QL1NqaFYziyasi3MOihRozQ3VyDJLit7nKjb3r9BFlRKxEHH2DzU8ya2q9im\ndlZH9o6jyLk3qYWc88OmshEaqFCzRQre0GPYyLxDgc9mMAtVcG1y5MF2IBxUHG2M\nexL5GNVVRxvH8r+z0ZXssC/35SGmgZXNP83TcAyo7gOcPiLfuNr3E552ffFDjw3i\nGJiR9iyw5sUFMDqMshDUZnaqXpAmHBOGGk/sxa8lcdlJDArBrQIDAQABMA0GCSqG\nSIb3DQEBBQUAA4IBAQBhktjReQRXN2QOley8nhzYJKTThbZdNWg9M7JhClsq43ys\nNMRPWVbGyFPealR7UEAY8NK2i/RBAwAQ1XGvUITAoICuHHzTYBc6EcXp22BEl+gN\nqDLyZOdNaLaWaMpRbd21dBOqe8CTGBxhes5Dwe/L0bBZgV/vHk9Qw6v9I+xaQroW\n3aGrRnyxD8rPbcvLGHUPfoFdskkG2Y7UQUAYy8QlDApcA9hbplhgz5cVmqAR+vli\nFBlXJ1FNxrGhVjRg4ULTHR4H5JA6OXRLjI9gVKPbWk1/SblGi01wStR79SPBXO9c\n2N3Q1WgSwTkR3BxJaxn8/S5iu4mQ+OXuVTxo5R0y", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UNIFEI - Universidade Federal de Itajuba", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.unifei.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.unifei.edu.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "everaldo@unifei.edu.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Everaldo Campos", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://cafe1.ufes.br/idp/shibboleth", 
    {
      "entity_id": "https://cafe1.ufes.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/cafe1.ufes.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cafe1.ufes.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufes.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufes.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufes.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFES - Universidade Federal do Espirito Santo", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEPDCCAyQCARUwDQYJKoZIhvcNAQEFBQAwgeMxNjA0BgNVBAoTLVVuaXZlcnNp\nZGFkZSBGZWRlcmFsIGRvIEVzcGlyaXRvIFNhbnRvIC0gVUZFUzEvMC0GA1UECxMm\nTnVjbGVvIGRlIFByb2Nlc3NhbWVudG8gZGUgRGFkb3MgLSBOUEQxKDAmBgkqhkiG\n9w0BCQEWGWRpcmV0b3IuZ2VyYWxAbnBkLnVmZXMuYnIxEDAOBgNVBAcTB1ZpdG9y\naWExFzAVBgNVBAgTDkVzcGlyaXRvIFNhbnRvMQswCQYDVQQGEwJCUjEWMBQGA1UE\nAxMNY2FmZTEudWZlcy5icjAeFw0xMTA4MDMxMzA4MDVaFw0xNDA4MDIxMzA4MDVa\nMIHjMTYwNAYDVQQKEy1Vbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBFc3Bpcml0byBT\nYW50byAtIFVGRVMxLzAtBgNVBAsTJk51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRl\nIERhZG9zIC0gTlBEMSgwJgYJKoZIhvcNAQkBFhlkaXJldG9yLmdlcmFsQG5wZC51\nZmVzLmJyMRAwDgYDVQQHEwdWaXRvcmlhMRcwFQYDVQQIEw5Fc3Bpcml0byBTYW50\nbzELMAkGA1UEBhMCQlIxFjAUBgNVBAMTDWNhZmUxLnVmZXMuYnIwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDcv1BsThQWzeWTogJgUgbU3tU4UUOuHjXT\nB8AFXxIVARB1RVyksT4wFC5Q2tKXvqin/E4m6LmkdqKwJLj1CRetcEc41Rz0Re5J\n8/EjOE+3BUQXV961qDJIQ86Dpl6jKxjapIWCXd4fLoCF0WLIJG1tf9McAkK39SgH\ny9ImQZTgN8clsY3GOm+FU2HXUcV9W5iDh75b5byN+YCmSxernLHrpyeVIz03ZReJ\nfsNXhASJpoFAzoWNTMoi7WrUwRHrvB6RNjq3dQJrb5XUC88IwfQ512y9W6kUeTm6\nyZVJ0MeiUogHkTgpaaClal9VxPIyvZTV38XafljGrzss2DA2xqUvAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggEBAMVNejcbIY2nJUMXayK7055pjINhCUOH9R1oDIAbL6i3\nKdfahk1XlHN5kM3yOQ3T6hVf2GNy8s9SaAI6VZ5nvzReS0V81tdrzwn8Zrv2BLvc\ncP1WuYtXbOHzFgzornsflt2PKEQpT9mNnUzTagqdqxfW/8Dwp/+ZesFbmDwtN58d\n65/jAMm5oG1zaK/2V2PNELSHmswG0lk8EGaRY3LSKRDIbcMAxkA3gycMP5zEflqF\nB4YZRuxdXGqMUClpbdMxjfKICVL1rOV4wU8r6p40gSyNagGSZW8e78efc5GPL0g4\nbcL1avijCNm7WtrEOBPVFjablxgw0Hrk7CU99BXZwI4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cafe1.ufes.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufes.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEPDCCAyQCARUwDQYJKoZIhvcNAQEFBQAwgeMxNjA0BgNVBAoTLVVuaXZlcnNp\nZGFkZSBGZWRlcmFsIGRvIEVzcGlyaXRvIFNhbnRvIC0gVUZFUzEvMC0GA1UECxMm\nTnVjbGVvIGRlIFByb2Nlc3NhbWVudG8gZGUgRGFkb3MgLSBOUEQxKDAmBgkqhkiG\n9w0BCQEWGWRpcmV0b3IuZ2VyYWxAbnBkLnVmZXMuYnIxEDAOBgNVBAcTB1ZpdG9y\naWExFzAVBgNVBAgTDkVzcGlyaXRvIFNhbnRvMQswCQYDVQQGEwJCUjEWMBQGA1UE\nAxMNY2FmZTEudWZlcy5icjAeFw0xMTA4MDMxMzA4MDVaFw0xNDA4MDIxMzA4MDVa\nMIHjMTYwNAYDVQQKEy1Vbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBFc3Bpcml0byBT\nYW50byAtIFVGRVMxLzAtBgNVBAsTJk51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRl\nIERhZG9zIC0gTlBEMSgwJgYJKoZIhvcNAQkBFhlkaXJldG9yLmdlcmFsQG5wZC51\nZmVzLmJyMRAwDgYDVQQHEwdWaXRvcmlhMRcwFQYDVQQIEw5Fc3Bpcml0byBTYW50\nbzELMAkGA1UEBhMCQlIxFjAUBgNVBAMTDWNhZmUxLnVmZXMuYnIwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDcv1BsThQWzeWTogJgUgbU3tU4UUOuHjXT\nB8AFXxIVARB1RVyksT4wFC5Q2tKXvqin/E4m6LmkdqKwJLj1CRetcEc41Rz0Re5J\n8/EjOE+3BUQXV961qDJIQ86Dpl6jKxjapIWCXd4fLoCF0WLIJG1tf9McAkK39SgH\ny9ImQZTgN8clsY3GOm+FU2HXUcV9W5iDh75b5byN+YCmSxernLHrpyeVIz03ZReJ\nfsNXhASJpoFAzoWNTMoi7WrUwRHrvB6RNjq3dQJrb5XUC88IwfQ512y9W6kUeTm6\nyZVJ0MeiUogHkTgpaaClal9VxPIyvZTV38XafljGrzss2DA2xqUvAgMBAAEwDQYJ\nKoZIhvcNAQEFBQADggEBAMVNejcbIY2nJUMXayK7055pjINhCUOH9R1oDIAbL6i3\nKdfahk1XlHN5kM3yOQ3T6hVf2GNy8s9SaAI6VZ5nvzReS0V81tdrzwn8Zrv2BLvc\ncP1WuYtXbOHzFgzornsflt2PKEQpT9mNnUzTagqdqxfW/8Dwp/+ZesFbmDwtN58d\n65/jAMm5oG1zaK/2V2PNELSHmswG0lk8EGaRY3LSKRDIbcMAxkA3gycMP5zEflqF\nB4YZRuxdXGqMUClpbdMxjfKICVL1rOV4wU8r6p40gSyNagGSZW8e78efc5GPL0g4\nbcL1avijCNm7WtrEOBPVFjablxgw0Hrk7CU99BXZwI4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFES - Universidade Federal do Espirito Santo", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufes.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufes.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "renan.manola@ufes.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Renan Manola", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://shibboleth.slu.se/idp/shibboleth", 
    {
      "entity_id": "https://shibboleth.slu.se/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/shibboleth.slu.se.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.slu.se/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.slu.se/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.slu.se/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.slu.se/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "slu.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDMDCCAhigAwIBAgIVAJgPjWyV8mnw8Zm9lp8a5mHvQve+MA0GCSqGSIb3DQEB\nBQUAMBwxGjAYBgNVBAMTEXNoaWJib2xldGguc2x1LnNlMB4XDTEwMDMxNjExNDAy\nMVoXDTMwMDMxNjExNDAyMVowHDEaMBgGA1UEAxMRc2hpYmJvbGV0aC5zbHUuc2Uw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvQU5k1AvEYedH5FYRuklo\n9wfvfTc5yHnA2NE7mFmnLqYyNhacWsb5kl53TCvHhCUh1RmTwPxDtOgAi1YmyF1X\nOn/U3SPOOm3FVqDbmGOZIiYD2+R2LhvifGXvVXNvE0rJR4aK02C4cmVaxJCSpVfI\n+dGBECEVvzaFy3zQEZmOyeiClFaDKlwLEBj1qWSUWWhMeryYLbNUHiR+5NznHqeB\nRfFPExXbTfjSgUXiq3c7w80AUUC8zAjxo8oQCRoCvmvhT38McCUustziUPzc6/UC\nM2h+eET25OoCCkC5/VPyfTWHfzTOTDasMvny3Jp5fASZ0JxPKAVtU+7arPBf1FmN\nAgMBAAGjaTBnMEYGA1UdEQQ/MD2CEXNoaWJib2xldGguc2x1LnNlhihodHRwczov\nL3NoaWJib2xldGguc2x1LnNlL2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBTDGADa\nHy53hIGPonu2OOONEh54YDANBgkqhkiG9w0BAQUFAAOCAQEAiDlmcUcHOV/GYog4\nUlB4NsZfcfARpmNeR16jmbfXBX5gmwKAlltqUZhhKB89qPCOv/cKjlBXga3Ypdqd\nnZa7NobQlyVsJgBUB82Nh8RRsGB0jaHpAXC48ey5sKqcpVQnCcKG51svYkQHmNRD\n+jza1oyX/wZLjk4whkJm0ef7vToN8xd/cYc0EyfqN7VSDXMdVUtzJDd298CGNx6Q\nXr7EfTMM2MhwKghEOOn25472fguv+kLwaEpOWKKR5vzYPcH5kpYC29CeHCnnHrJv\nsAvj1/KeSjxuQ71kHH8n7cxIqUc+MeHZXAANL9fqDkfeT4L6RStHNUpNCVS9se5b\nxpmbgA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.slu.se:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.slu.se:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.slu.se:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.slu.se:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "slu.se", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDMDCCAhigAwIBAgIVAJgPjWyV8mnw8Zm9lp8a5mHvQve+MA0GCSqGSIb3DQEB\nBQUAMBwxGjAYBgNVBAMTEXNoaWJib2xldGguc2x1LnNlMB4XDTEwMDMxNjExNDAy\nMVoXDTMwMDMxNjExNDAyMVowHDEaMBgGA1UEAxMRc2hpYmJvbGV0aC5zbHUuc2Uw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvQU5k1AvEYedH5FYRuklo\n9wfvfTc5yHnA2NE7mFmnLqYyNhacWsb5kl53TCvHhCUh1RmTwPxDtOgAi1YmyF1X\nOn/U3SPOOm3FVqDbmGOZIiYD2+R2LhvifGXvVXNvE0rJR4aK02C4cmVaxJCSpVfI\n+dGBECEVvzaFy3zQEZmOyeiClFaDKlwLEBj1qWSUWWhMeryYLbNUHiR+5NznHqeB\nRfFPExXbTfjSgUXiq3c7w80AUUC8zAjxo8oQCRoCvmvhT38McCUustziUPzc6/UC\nM2h+eET25OoCCkC5/VPyfTWHfzTOTDasMvny3Jp5fASZ0JxPKAVtU+7arPBf1FmN\nAgMBAAGjaTBnMEYGA1UdEQQ/MD2CEXNoaWJib2xldGguc2x1LnNlhihodHRwczov\nL3NoaWJib2xldGguc2x1LnNlL2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBTDGADa\nHy53hIGPonu2OOONEh54YDANBgkqhkiG9w0BAQUFAAOCAQEAiDlmcUcHOV/GYog4\nUlB4NsZfcfARpmNeR16jmbfXBX5gmwKAlltqUZhhKB89qPCOv/cKjlBXga3Ypdqd\nnZa7NobQlyVsJgBUB82Nh8RRsGB0jaHpAXC48ey5sKqcpVQnCcKG51svYkQHmNRD\n+jza1oyX/wZLjk4whkJm0ef7vToN8xd/cYc0EyfqN7VSDXMdVUtzJDd298CGNx6Q\nXr7EfTMM2MhwKghEOOn25472fguv+kLwaEpOWKKR5vzYPcH5kpYC29CeHCnnHrJv\nsAvj1/KeSjxuQ71kHH8n7cxIqUc+MeHZXAANL9fqDkfeT4L6RStHNUpNCVS9se5b\nxpmbgA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Swedish University of Agricultural Science", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Swedish University of Agricultural Science (OLD)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "sv", 
            "text": "Sveriges Lantbruksuniversitet (OLD)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.slu.se/en/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Martin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "martin.norrsken@slu.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Norrsken", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Stefan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "stefan.edholm@slu.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Edholm", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://rems.csc.fi", 
    {
      "entity_id": "https://rems.csc.fi", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/rems.csc.fi.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/eu-adequate-protection", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - IT-centret f\u00f6r vetenskap", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "fi", 
            "text": "CSC - Tieteen tietotekniikan keskus Oy", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "CSC - IT Center for Science Ltd.", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "sv", 
            "text": "CSC - IT-centret f\u00f6r vetenskap", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "fi", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "sv", 
            "text": "http://www.csc.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "is_default": "true", 
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://rems.csc.fi/Shibboleth.sso/SAML2/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://rems.csc.fi/Shibboleth.sso/Login"
              }, 
              {
                "privacy_statement_url": [
                  {
                    "lang": "en", 
                    "text": "https://rems.csc.fi/web/guest/privacy-policy", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "https://rems.csc.fi/web/guest/tietosuojaseloste", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&PrivacyStatementURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "REMS", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "REMS", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Resource Entitlement Management\n                    System", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "fi", 
                    "text": "REMS-palvelun kautta tutkijat voivat hakea k\u00e4ytt\u00f6oikeuksia tutkimuksen tietoaineistoihin", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_name": [
                {
                  "lang": "fi", 
                  "text": "REMS", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "en", 
                  "text": "REMS", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "is_default": "true", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "schacHomeOrganization", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.9"
                }, 
                {
                  "friendly_name": "schacHomeOrganizationType", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.10"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_description": [
                {
                  "lang": "fi", 
                  "text": "Valtuutuuksien Hallinta\n                Jarjestelma", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "en", 
                  "text": "Resource Entitlement Management\n                System", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC6DCCAdCgAwIBAgIJAJNkHpbnqskZMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNV\n                        BAMTC3JlbXMuY3NjLmZpMB4XDTEyMTAwNDA2NDc1M1oXDTIyMTAwMjA2NDc1M1ow\n                        FjEUMBIGA1UEAxMLcmVtcy5jc2MuZmkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw\n                        ggEKAoIBAQCti37oqpPuAfgsIAc7VwKA+3L99iuTlFG9jlGTJiurXW/ARwl5y8FX\n                        HWDYmdg5GECe7qHsvKAhgGnJ6x0qmhJZacbvBuhofGZBHliG6ykCX377HA09pDr1\n                        db9WRhRMwz/w46mZU/9n/r3BfXXNpmAsdHiC/nD+0lPoOEHfo9wN0JsqO4SQUbya\n                        0cyMle8YVlPeF+8voug2lNvcDRcx9CRvAMTHuJX9HBTYE0XtAgHZOymZ10KvBDnq\n                        Lw7z0bndgUuSAp5puWH1eKGZt1S6rslLeMVw7xlTlds4HmGc5CRkJyZ0WKkU0VI2\n                        THDKIHlWCkJ+X0i04TFYtiJKxwavAjoRAgMBAAGjOTA3MBYGA1UdEQQPMA2CC3Jl\n                        bXMuY3NjLmZpMB0GA1UdDgQWBBSTogtyEd5toTA7qpl65syr7UE9OzANBgkqhkiG\n                        9w0BAQUFAAOCAQEAkHuPNT6e9a3PG8dy/OcUfY+ln2NA1gThNFRc0ZdhsRML1MXk\n                        hTPyv6v04KsyfEH4OjkpyTqcVCvs6jjVZrQmPyzU3nXu1aPyM7lYvGikVM/oFRAV\n                        0H4Cz+Yj8mKCddTdxAAiNyuqjOf+eYlRv3SyNjIYYM6OmqD0mH/mPZ6ado41ALUN\n                        0iqdiwFeKwjOlKALGVW92ihgU8uX3ScC6jCbAdPTu2m+NBO42pKNVYasHI0PBJmB\n                        HCZKDHCPHeGmXn6ab0zU6GbvGrxAKWDwJNw9mgRfxKqvTpVI9hY8QOE4eAjH7UJz\n                        c3E0G+pYuKCVKHVH6HOcuVL23IneYlhKtmz+Kw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Janne", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:janne.lauros@csc.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Lauros", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Janne", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:janne.lauros@csc.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Lauros", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }
      ]
    }
  ], 
  [
    "https://ladok3-06.ladok.umu.se/gui-sp", 
    {
      "entity_id": "https://ladok3-06.ladok.umu.se/gui-sp", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions"
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "https://ladok3-06.ladok.umu.se/gui-sp", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "ladok3-06.ladok.umu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ladok3-06.ladok.umu.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDMDCCAhigAwIBAgIJALk1rPJOG1teMA0GCSqGSIb3DQEBBQUAMCExHzAdBgNV\nBAMTFmxhZG9rMy0wNi5sYWRvay51bXUuc2UwHhcNMTIwNjI5MTIwODEwWhcNMjIw\nNjI3MTIwODEwWjAhMR8wHQYDVQQDExZsYWRvazMtMDYubGFkb2sudW11LnNlMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAy7RjhC7f4/gfQK127LuRggwD\n6VUcajCmZ8HpXZp29b/ghxNhgVlLDiIrLpD+bDaRoyJ20VssaWJ7KdLj2jFAjOmz\nCfPhvAd3kVmLLvVVOG12XlOh81RdQKZBm6qkvC/kTS6fxUHkympbGzFPmhGt6kEs\nz6BbdoOTzXTlXO4/H5N7N9ShspBhbc9NETinrPtIIykgjHSbfWMVdYQqCJbIdbM7\ny61Re55wfl8m6ppNra+oykYly2jhvlN0Vb4QGqpJBB0XzOAVh/DHt9oEDryxxaeG\n6JVhDwD15vx4tdm6ypd7qwNXp0c9nYteYNiSL+qXisKVJZ/JLcllxC7dLZ6GHQID\nAQABo2swaTBIBgNVHREEQTA/ghZsYWRvazMtMDYubGFkb2sudW11LnNlhiVodHRw\nczovL2xhZG9rMy0wNi5sYWRvay51bXUuc2UvZ3VpLXNwMB0GA1UdDgQWBBRK+n8d\nwSrEb8l1peNFBoe/bchVGjANBgkqhkiG9w0BAQUFAAOCAQEAqV8BTMudvEvzIUu1\n7bdjIVNCvNRb914WsPmQR6KhKhRzHVRJFqeSkMtvzCTi4YzaNE59l6iKcFG20ffZ\nO5WwEUhy8TtPgLrdK+Zi1rYfE3pULUs+LQLxz3h0reEW35y084ahB9uhYdkfjqEU\n/8LYg09v4gGOnjCLLj+mOEjpH7oVMWPuLSPbgL8RMfBX1SF51pDs1tp+rjGdbc7c\nPsCzYLHD+n9ygXpZsmmVmYi0YjZbrpYOLJlg/IU+jTfQ8ag4d8QEEz6Zfv+BL8iy\nU5ov36jyE84soQ3NsxFo3cndYZE3Epi7pMNaKAO2OUlS2R2R+l/9pdyzQqcOU6bq\nz181Cw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ladok3-06.ladok.umu.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/swamid-1.0/ladok3-06.ladok.umu.se-gui-sp.xml"
      }
    }
  ], 
  [
    "https://idp.ub.hsu-hh.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.ub.hsu-hh.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.ub.hsu-hh.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ub.hsu-hh.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hsu-hh.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.ub.hsu-hh.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hsu-hh.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ub.hsu-hh.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.ub.hsu-hh.de,O=Helmut-Schmidt-Universitaet Universitaet der Bundeswehr Hamburg,L=Hamburg,ST=Hamburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFmTCCBIGgAwIBAgIEDtrvHzANBgkqhkiG9w0BAQUFADCBizELMAkGA1UEBhMC\nREUxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVuaXZlcnNpdGFldCBVbml2ZXJz\naXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEVMBMGA1UEAxMMSFNVIENBIC0g\nRzAxMRswGQYJKoZIhvcNAQkBFgxjYUBoc3UtaGguZGUwHhcNMDkwOTI0MTMxODA4\nWhcNMTQwOTIzMTMxODA4WjCBljELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0hhbWJ1\ncmcxEDAOBgNVBAcTB0hhbWJ1cmcxSDBGBgNVBAoTP0hlbG11dC1TY2htaWR0LVVu\naXZlcnNpdGFldCBVbml2ZXJzaXRhZXQgZGVyIEJ1bmRlc3dlaHIgSGFtYnVyZzEZ\nMBcGA1UEAxMQaWRwLnViLmhzdS1oaC5kZTCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAJozfQt8GxD1AKQPEqsTcJipCihzU0Gc2gw+qkWWOLEN6K63wICQ\nCjnV2+n4I0uz1cAzzaauAkdFVCjxXrhgq8K/kYGiyLJvl+wHazN6SqSzrEskgCSR\nQrOrn8YzQTtWe7kZR9aVOJFY8p2MqL4UWwUNYqIe4+2InIn3qaimG1mP0CGJT8Ck\nLya8gg7LUWltXvVcWQmsJjBUGPR9TyNxBXTGn/tw0crt18w7TjiwwTacMAsaQEby\no2rHoEFe+c7gQF7ZMYc0yia1+oylmBLHuqy5Pxo3mxyG6fYflVwPMCye3BFEm6fI\nNJQvKZ04sKbk/8+wXsLUWsNhO62zajHYDY0CAwEAAaOCAfYwggHyMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAd\nBgNVHQ4EFgQUzCawY/z2k64WBdr0a5agbjeydZMwHwYDVR0jBBgwFoAU0OF/Hccy\nvOKQu1gUgBTGX53swaowIAYDVR0RBBkwF4EVaWRwQGhzdS1iaWJsaW90aGVrLmRl\nMIGdBgNVHR8EgZUwgZIwR6BFoEOGQWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVs\nbXV0LXNjaG1pZHQtdW5pLWhoLWNhL3B1Yi9jcmwvY2FjcmwuY3JsMEegRaBDhkFo\ndHRwOi8vY2RwMi5wY2EuZGZuLmRlL2hlbG11dC1zY2htaWR0LXVuaS1oaC1jYS9w\ndWIvY3JsL2NhY3JsLmNybDCBtgYIKwYBBQUHAQEEgakwgaYwUQYIKwYBBQUHMAKG\nRWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGVsbXV0LXNjaG1pZHQtdW5pLWhoLWNh\nL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDBRBggrBgEFBQcwAoZFaHR0cDovL2NkcDIu\ncGNhLmRmbi5kZS9oZWxtdXQtc2NobWlkdC11bmktaGgtY2EvcHViL2NhY2VydC9j\nYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQAVuAzmub19Uck2UxkTRAfgQ5Yz\noO3H9crRrXfAfi2EeS/2nd+pn/S9xwaeMcBE02SE6H2ujjWpb4T6zoe8oWeCihHt\nbByDVICPRMvPU0IkLgAlQmUgGTi7SMlFuv/inoEA0Cvjv6EGSC7L8JmzrUzB0Fgi\ns70BXg+QladY3A2Odwt3xgAeCZo8pXrrSqqEjgsToD/dSKi9hAdlah5feBRw8fGw\ng0sqqQB13BJSbmspSm/UTPv1ZQP7VrAIOpP2p9OLGARi9fLxpSfsczPS62BW69Xf\nmd5/h8e4VJDeQ8uU102FbhB7brNCg3SuWZsJivRwy1aaMDvL1zVDP7xULLCG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Helmut-Schmidt-Universit\u00e4t", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "HSU Hamburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://ub.hsu-hh.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ulrich", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "idp@hsu-bibliothek.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hahn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Ulrich", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "uhahn@hsu-bibliothek.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hahn", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://capuccino.info.ufrn.br/idp/shibboleth", 
    {
      "entity_id": "https://capuccino.info.ufrn.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/capuccino.info.ufrn.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://capuccino.info.ufrn.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufrn.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufrn.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufrn.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEUjCCAzoCAQAwDQYJKoZIhvcNAQEFBQAwge4xOzA5BgNVBAoTMlVGUk4gLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYD\nVQQLEydTaW5mbyAtIFN1cGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAf\nBgkqhkiG9w0BCQEWEnJlZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwx\nHDAaBgNVBAgTE1JpbyBHcmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYD\nVQQDExZjYXB1Y2Npbm8uaW5mby51ZnJuLmJyMB4XDTEyMDYxODE3NTA0M1oXDTE1\nMDYxODE3NTA0M1owge4xOzA5BgNVBAoTMlVGUk4gLSBVbml2ZXJzaWRhZGUgRmVk\nZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYDVQQLEydTaW5mbyAtIFN1\ncGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAfBgkqhkiG9w0BCQEWEnJl\nZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwxHDAaBgNVBAgTE1JpbyBH\ncmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYDVQQDExZjYXB1Y2Npbm8u\naW5mby51ZnJuLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1tLx\n+5Q99cvQ6T4dFLqtoXnaeVtePhdogMKFxJsNwxWL901s+NPJT3f4dkEJ9rMry6g2\nWg9U+f96mY5iViRSP09RF6IPyHwU0xUh6gZE2ggvLKKbddkU9I380M3n0SJWRSXe\nrMZwL1qiVEA+Ysgvh1CS+NWKmTzn1GC3MCUjB4mA8fdZ+Xh+SlCbSEtbTo0nQxqt\ng2xx+t+jO2YZIawYp+pYEza5gMWTI58csYXijWzWV/SqaUXDN7nEd08UpLVyzKEf\nrtFsA/U5/v3cqdQ3f9czTABbp6RQuN8sXJ1z/rpID+og2W3o0QmIaJ/GtocyEWtK\nU8KkFewao0aPe2OITQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQBm3htwaGiZLjwh\naJBskxikHeSo95d8uf9Jnh/Ce8KiarRS98hTnn+MBzCcQdQMl6+rVf7Nd9ecRAUC\nUROzPMhbd3+4CF1seVnHbQItxJJdHpvp4KgmkysIqGHXbdy2ah5ajnP+29ow9Uyf\nMUewqb/okcT6h9InBfNzL2bDTOpvy2HsKWcxfX+QArNJnW4mLUqCOa4pfUfv8D5B\no26FhWVhKC93SsUtin1nMtt0/Mw/kRhP30DSsdUzkZBCgL0KnFvdyuy9agT2t0FX\nVoyPFzWCEFj7zzgaFo4Lyc+HeehnKK8p9cZEZu0Jl0r0qFuI65LpMXttzrGxEmlE\nwaiW5wfG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://capuccino.info.ufrn.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufrn.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEUjCCAzoCAQAwDQYJKoZIhvcNAQEFBQAwge4xOzA5BgNVBAoTMlVGUk4gLSBV\nbml2ZXJzaWRhZGUgRmVkZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYD\nVQQLEydTaW5mbyAtIFN1cGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAf\nBgkqhkiG9w0BCQEWEnJlZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwx\nHDAaBgNVBAgTE1JpbyBHcmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYD\nVQQDExZjYXB1Y2Npbm8uaW5mby51ZnJuLmJyMB4XDTEyMDYxODE3NTA0M1oXDTE1\nMDYxODE3NTA0M1owge4xOzA5BgNVBAoTMlVGUk4gLSBVbml2ZXJzaWRhZGUgRmVk\nZXJhbCBkbyBSaW8gZ3JhbmRlIGRvIE5vcnRlMTAwLgYDVQQLEydTaW5mbyAtIFN1\ncGVyaW50ZW5kZW5jaWEgZGUgaW5mb3JtYXRpY2ExITAfBgkqhkiG9w0BCQEWEnJl\nZGVzQGluZm8udWZybi5icjEOMAwGA1UEBxMFTmF0YWwxHDAaBgNVBAgTE1JpbyBH\ncmFuZGUgZG8gTm9ydGUxCzAJBgNVBAYTAkJSMR8wHQYDVQQDExZjYXB1Y2Npbm8u\naW5mby51ZnJuLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1tLx\n+5Q99cvQ6T4dFLqtoXnaeVtePhdogMKFxJsNwxWL901s+NPJT3f4dkEJ9rMry6g2\nWg9U+f96mY5iViRSP09RF6IPyHwU0xUh6gZE2ggvLKKbddkU9I380M3n0SJWRSXe\nrMZwL1qiVEA+Ysgvh1CS+NWKmTzn1GC3MCUjB4mA8fdZ+Xh+SlCbSEtbTo0nQxqt\ng2xx+t+jO2YZIawYp+pYEza5gMWTI58csYXijWzWV/SqaUXDN7nEd08UpLVyzKEf\nrtFsA/U5/v3cqdQ3f9czTABbp6RQuN8sXJ1z/rpID+og2W3o0QmIaJ/GtocyEWtK\nU8KkFewao0aPe2OITQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQBm3htwaGiZLjwh\naJBskxikHeSo95d8uf9Jnh/Ce8KiarRS98hTnn+MBzCcQdQMl6+rVf7Nd9ecRAUC\nUROzPMhbd3+4CF1seVnHbQItxJJdHpvp4KgmkysIqGHXbdy2ah5ajnP+29ow9Uyf\nMUewqb/okcT6h9InBfNzL2bDTOpvy2HsKWcxfX+QArNJnW4mLUqCOa4pfUfv8D5B\no26FhWVhKC93SsUtin1nMtt0/Mw/kRhP30DSsdUzkZBCgL0KnFvdyuy9agT2t0FX\nVoyPFzWCEFj7zzgaFo4Lyc+HeehnKK8p9cZEZu0Jl0r0qFuI65LpMXttzrGxEmlE\nwaiW5wfG", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFRN - Universidade Federal do Rio Grande do Norte", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufrn.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufrn.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "redes@info.ufrn.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "SINFO", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://sgw.africa-grid.org/shibboleth", 
    {
      "entity_id": "https://sgw.africa-grid.org/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/sgw.africa-grid.org.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Consorzio COMETA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "COMETA", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.consorzio-cometa.it/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Marco", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:marco.fargetta@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }, 
            {
              "text": "mailto:credentials-admin@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Fargetta", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Roberto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "mailto:roberto.barbera@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }, 
            {
              "text": "mailto:credentials-admin@ct.infn.it", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Barbera", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "Africa Grid Science Gateway", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "it", 
                    "text": "Africa Grid Science Gateway", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "This service allows to use on a Grid infrastructure the lighthouse applications of the eI4Africa project", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "it", 
                    "text": "Questo servizio permette l'accesso e l'uso delle applicazioni/servizi Grid sviluppati per il progetto eI4Africa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sgw.africa-grid.org/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "www.catania-science-gateways.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "aginfra-sg.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "cogito-med.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "earthserver-sg.consorzio-cometa.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "ecsg.dch-rp.eu", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "garr-sg.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "klios.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "liferay2.ct.infn.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "sgw.africa-grid.org", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "www.progetto-icaro.it", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.catania-science-gateways.it,OU=COMETA,O=Istituto Nazionale di Fisica Nucleare,street=Via S.Sofia n.64,L=Catania,ST=Italy,postalCode=95123,C=IT", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIF0TCCBLmgAwIBAgIRAJjvs9uxU/ydSPVPqQh6szEwDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0xMzAxMDcwMDAwMDBaFw0xNjAxMDcyMzU5NTlaMIHFMQswCQYD\nVQQGEwJJVDEOMAwGA1UEERMFOTUxMjMxDjAMBgNVBAgTBUl0YWx5MRAwDgYDVQQH\nEwdDYXRhbmlhMRkwFwYDVQQJExBWaWEgUy5Tb2ZpYSBuLjY0MS4wLAYDVQQKEyVJ\nc3RpdHV0byBOYXppb25hbGUgZGkgRmlzaWNhIE51Y2xlYXJlMQ8wDQYDVQQLEwZD\nT01FVEExKDAmBgNVBAMTH3d3dy5jYXRhbmlhLXNjaWVuY2UtZ2F0ZXdheXMuaXQw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDMR2RMw4cNImWSKdvZjDhz\n3JuO7/pMOnGw4hF6uu09cqX8qqBpkU/gd33xq7J254ojywwiIlLT7QaTce4YQU2W\nO5mPyqdHjnpA+C0fJWrQgRyJEXsOzwpxyUG42tim/9jgNNDaUuNSGgrMLGlzl0sU\ni3Cq04AY0hukrtFGe6DFvDsm8xoNwfV8jmO3IipWJdJdezRnCGDgTZqgIWj3yrHo\nLjfgLbs85AJ31plMahcEni1jDZYgzu7FurbKpO4FGSLUEI8VUxncdYx3IWidqYBD\nTjxFGIiRIcD59DTIBxZYT4IgGHhG1whnUtE7nZhtuxFvnxfH4gPi7mPcRwidNHg9\nAgMBAAGjggJIMIICRDAfBgNVHSMEGDAWgBQMvZNoDPPeq6NJays3V0fqkOO57TAd\nBgNVHQ4EFgQU+qOkofxo+Ei3aGD2lLEkM4L7LS0wDgYDVR0PAQH/BAQDAgWgMAwG\nA1UdEwEB/wQCMAAwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMCIGA1Ud\nIAQbMBkwDQYLKwYBBAGyMQECAh0wCAYGZ4EMAQICMDoGA1UdHwQzMDEwL6AtoCuG\nKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3JsMG0GCCsG\nAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3MudGVyZW5hLm9y\nZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9vY3NwLnRjcy50\nZXJlbmEub3JnMIH1BgNVHREEge0wgeqCH3d3dy5jYXRhbmlhLXNjaWVuY2UtZ2F0\nZXdheXMuaXSCFWFnaW5mcmEtc2cuY3QuaW5mbi5pdIIVY29naXRvLW1lZC5jdC5p\nbmZuLml0giJlYXJ0aHNlcnZlci1zZy5jb25zb3J6aW8tY29tZXRhLml0gg5lY3Nn\nLmRjaC1ycC5ldYISZ2Fyci1zZy5jdC5pbmZuLml0ghBrbGlvcy5jdC5pbmZuLml0\nghNsaWZlcmF5Mi5jdC5pbmZuLml0ghNzZ3cuYWZyaWNhLWdyaWQub3JnghV3d3cu\ncHJvZ2V0dG8taWNhcm8uaXQwDQYJKoZIhvcNAQEFBQADggEBAIzikPZKDI8rXlUU\niF8KUeEVYZMyBfRtl0sQYBZCprDoVpCr74CPTxQ72Jrh2mD8oAz0ZYVgOA19AbM8\nPskJlhx4bmDJvWU/C2FrOgYDNg9Tl7dqLnr18GDt7DuC0KXCDupgtBmwy7mayNgA\nn2jbIaYsfMI7k1msS1XoaVX7kBMgmeGY3V11Om9Te7iMWKFOhpavI2hbf741ODtV\nzBen58Q2WzjVEKVQYbY7UgtcYzOM44GhMcdS65lLsBviK7HzyB6I5Iu3TR0bcpFE\n2V4bd6L5foq3Qn+WO9wqOwnOk3qfD/TQId7NWv0ZE2vp8fPPaaRF2XcA7Qh5xltt\nj/MCNlE=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sgw.africa-grid.org/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "This service allows to use on a Grid infrastructure the lighthouse applications of the eI4Africa project", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Africa Grid Science Gateway", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://sp.eblib.com/shibboleth", 
    {
      "entity_id": "https://sp.eblib.com/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/sp.eblib.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Ebook Library", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "EBL", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.eblib.com", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Vinay", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "v@ebooks.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Bharadwaj", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.eblib.com/Shibboleth.sso/DS"
              }, 
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.eblib.com/Shibboleth.sso/ACODS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ebooks.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=vinay.bharadwaj@ebooks.com,CN=ebooks.com,OU=Area Servizi ICT,O=Politecnico di Milano,L=Milan,ST=Milan,C=IT", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDNzCCAqCgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBqDELMAkGA1UEBhMCSVQx\nDjAMBgNVBAgTBU1pbGFuMQ4wDAYDVQQHEwVNaWxhbjEeMBwGA1UEChMVUG9saXRl\nY25pY28gZGkgTWlsYW5vMRkwFwYDVQQLExBBcmVhIFNlcnZpemkgSUNUMRMwEQYD\nVQQDEwplYm9va3MuY29tMSkwJwYJKoZIhvcNAQkBFhp2aW5heS5iaGFyYWR3YWpA\nZWJvb2tzLmNvbTAeFw0xMTAyMjMxNTU2NDRaFw0xNjAyMjIxNTU2NDRaMIGoMQsw\nCQYDVQQGEwJJVDEOMAwGA1UECBMFTWlsYW4xDjAMBgNVBAcTBU1pbGFuMR4wHAYD\nVQQKExVQb2xpdGVjbmljbyBkaSBNaWxhbm8xGTAXBgNVBAsTEEFyZWEgU2Vydml6\naSBJQ1QxEzARBgNVBAMTCmVib29rcy5jb20xKTAnBgkqhkiG9w0BCQEWGnZpbmF5\nLmJoYXJhZHdhakBlYm9va3MuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB\ngQD9XQY5ysPYf4+guHJH+o75Ebn+bXE44uogDRo+IMLqCKxvEV5+C9RaDLKmeAs1\nYbYaHRx1Y5bHgHgj4nX44k266qpV78WoUEslkP9ivOKW4+waMzYvRGSC++vMIVtr\nir6jQ94WvCxnS6JPJ5mDX6mEiVPIfuevBqYt+Cgj0Q2bMQIDAQABo28wbTAMBgNV\nHRMBAf8EAjAAMB0GA1UdDgQWBBS99SAMv7ZRQnNJ64Q5iC+xVikSCDALBgNVHQ8E\nBAMCBLAwEQYJYIZIAYb4QgEBBAQDAgWgMB4GCWCGSAGG+EIBDQQRFg94Y2EgY2Vy\ndGlmaWNhdGUwDQYJKoZIhvcNAQEFBQADgYEAG9XLSlU6eORQ1LTL481PFvwsmxUq\nq0Dc6MRsFLwilB3nI1MyA9R6EDh/Tw1Fo7YiZ397OrgYEMvVV5GC+z923Zta9pI+\nh71V8Nt69iFENpx52d3BuYDNkhjSf5oo1KkVHgAmhCPjhFqFa+B6BE79KIz2Bwrx\nYzM6IclOG3yKzoY=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "ebooks.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=vinay.bharadwaj@ebooks.com,CN=ebooks.com,OU=Area Servizi ICT,O=Politecnico di Milano,L=Milan,ST=Milan,C=IT", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDNzCCAqCgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBqDELMAkGA1UEBhMCSVQx\nDjAMBgNVBAgTBU1pbGFuMQ4wDAYDVQQHEwVNaWxhbjEeMBwGA1UEChMVUG9saXRl\nY25pY28gZGkgTWlsYW5vMRkwFwYDVQQLExBBcmVhIFNlcnZpemkgSUNUMRMwEQYD\nVQQDEwplYm9va3MuY29tMSkwJwYJKoZIhvcNAQkBFhp2aW5heS5iaGFyYWR3YWpA\nZWJvb2tzLmNvbTAeFw0xMTAyMjMxNTU2NDRaFw0xNjAyMjIxNTU2NDRaMIGoMQsw\nCQYDVQQGEwJJVDEOMAwGA1UECBMFTWlsYW4xDjAMBgNVBAcTBU1pbGFuMR4wHAYD\nVQQKExVQb2xpdGVjbmljbyBkaSBNaWxhbm8xGTAXBgNVBAsTEEFyZWEgU2Vydml6\naSBJQ1QxEzARBgNVBAMTCmVib29rcy5jb20xKTAnBgkqhkiG9w0BCQEWGnZpbmF5\nLmJoYXJhZHdhakBlYm9va3MuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB\ngQD9XQY5ysPYf4+guHJH+o75Ebn+bXE44uogDRo+IMLqCKxvEV5+C9RaDLKmeAs1\nYbYaHRx1Y5bHgHgj4nX44k266qpV78WoUEslkP9ivOKW4+waMzYvRGSC++vMIVtr\nir6jQ94WvCxnS6JPJ5mDX6mEiVPIfuevBqYt+Cgj0Q2bMQIDAQABo28wbTAMBgNV\nHRMBAf8EAjAAMB0GA1UdDgQWBBS99SAMv7ZRQnNJ64Q5iC+xVikSCDALBgNVHQ8E\nBAMCBLAwEQYJYIZIAYb4QgEBBAQDAgWgMB4GCWCGSAGG+EIBDQQRFg94Y2EgY2Vy\ndGlmaWNhdGUwDQYJKoZIhvcNAQEFBQADgYEAG9XLSlU6eORQ1LTL481PFvwsmxUq\nq0Dc6MRsFLwilB3nI1MyA9R6EDh/Tw1Fo7YiZ397OrgYEMvVV5GC+z923Zta9pI+\nh71V8Nt69iFENpx52d3BuYDNkhjSf5oo1KkVHgAmhCPjhFqFa+B6BE79KIz2Bwrx\nYzM6IclOG3yKzoY=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://sp.eblib.com/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://samadhi.kib.ki.se/shibboleth", 
    {
      "entity_id": "https://samadhi.kib.ki.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "samadhi", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=samadhi", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_issuer_serial": {
                      "x509_serial_number": {
                        "text": "14803890058471736656", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SerialNumber"
                      }, 
                      "x509_issuer_name": {
                        "text": "CN=samadhi", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerName"
                      }, 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerSerial"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC3DCCAcSgAwIBAgIJAM1x+5LlJQVQMA0GCSqGSIb3DQEBBQUAMBIxEDAOBgNV\nBAMTB3NhbWFkaGkwHhcNMDkwODE0MTEzMzM4WhcNMTkwODEyMTEzMzM4WjASMRAw\nDgYDVQQDEwdzYW1hZGhpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwBagrMP26PtYqxBexJdsMdyDYCT74qvR5wLeW1znJTS9I1eK8ghXZ0Wy+uGunUU7\nePkQPDySt3dNOW6hOx9o8Z+/JqwSARj07glBpkN2psiza+7BQP/+l/4iBixGlDea\nwb59dC25cUA5k+YAV1fx6uwufQ/65iRKYilRVxzzSmorrrUuzbKA/Dh6MNCWDkU2\nppxJ/FS0IiR88rj2ZHZbz2wb1ATLnkevD4mUuRY39P9yxb63bTeCG7GboHrVBmNt\nrrlskaeeIYNHIkiWqbPrW/IMCgMFim7r7fiYebTvhw037UtTFDnwI8DDmcfpvbff\n2hztelbzoERAkXardDqx5QIDAQABozUwMzASBgNVHREECzAJggdzYW1hZGhpMB0G\nA1UdDgQWBBTIRU/xxcULxzxNef3jHDp1W2Br7jANBgkqhkiG9w0BAQUFAAOCAQEA\nDsNpDbtB/fhZIlNN11erKFH1VKgZIsLBu86uEYwi3sqK9+DNk40sdG1U0INY21g5\nsTG/vlt6qyuLcB9C5BA+8Ms3T01vcWg+//4KM4OZuLM/0ylSDxhVCHwJU5erI9Bt\nJSqVQ12JHctvIqdIQm0JRR6CCXVdm6Wjy5vVQZEoIanxcyjd0AUF458M7arGk1RB\npvLrKdwx16cOS9mkuq5Jg0Oj2yiUjx1WRzNzqAVQXpBb0ZZz0oKGiOqa0AgyfVKs\naNy8twh152lw5iqjY7qxb9QDhtJpzlPnQk2CmHJbQUXrCK8cLSWSDsiCcaQVicb+\n15HeV+PRFYV9dngg8gm2vg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "samadhi", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=samadhi", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_issuer_serial": {
                      "x509_serial_number": {
                        "text": "14803890058471736656", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SerialNumber"
                      }, 
                      "x509_issuer_name": {
                        "text": "CN=samadhi", 
                        "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerName"
                      }, 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509IssuerSerial"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC3DCCAcSgAwIBAgIJAM1x+5LlJQVQMA0GCSqGSIb3DQEBBQUAMBIxEDAOBgNV\nBAMTB3NhbWFkaGkwHhcNMDkwODE0MTEzMzM4WhcNMTkwODEyMTEzMzM4WjASMRAw\nDgYDVQQDEwdzYW1hZGhpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nwBagrMP26PtYqxBexJdsMdyDYCT74qvR5wLeW1znJTS9I1eK8ghXZ0Wy+uGunUU7\nePkQPDySt3dNOW6hOx9o8Z+/JqwSARj07glBpkN2psiza+7BQP/+l/4iBixGlDea\nwb59dC25cUA5k+YAV1fx6uwufQ/65iRKYilRVxzzSmorrrUuzbKA/Dh6MNCWDkU2\nppxJ/FS0IiR88rj2ZHZbz2wb1ATLnkevD4mUuRY39P9yxb63bTeCG7GboHrVBmNt\nrrlskaeeIYNHIkiWqbPrW/IMCgMFim7r7fiYebTvhw037UtTFDnwI8DDmcfpvbff\n2hztelbzoERAkXardDqx5QIDAQABozUwMzASBgNVHREECzAJggdzYW1hZGhpMB0G\nA1UdDgQWBBTIRU/xxcULxzxNef3jHDp1W2Br7jANBgkqhkiG9w0BAQUFAAOCAQEA\nDsNpDbtB/fhZIlNN11erKFH1VKgZIsLBu86uEYwi3sqK9+DNk40sdG1U0INY21g5\nsTG/vlt6qyuLcB9C5BA+8Ms3T01vcWg+//4KM4OZuLM/0ylSDxhVCHwJU5erI9Bt\nJSqVQ12JHctvIqdIQm0JRR6CCXVdm6Wjy5vVQZEoIanxcyjd0AUF458M7arGk1RB\npvLrKdwx16cOS9mkuq5Jg0Oj2yiUjx1WRzNzqAVQXpBb0ZZz0oKGiOqa0AgyfVKs\naNy8twh152lw5iqjY7qxb9QDhtJpzlPnQk2CmHJbQUXrCK8cLSWSDsiCcaQVicb+\n15HeV+PRFYV9dngg8gm2vg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://samadhi.kib.ki.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/samadhi.kib.ki.se.xml"
      }
    }
  ], 
  [
    "https://betafoo.nordu.net/saml2/metadata/", 
    {
      "contact_person": [
        {
          "contact_type": "technical", 
          "company": {
            "text": "NORDUnet A/S", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Company"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "sur_name": {
            "text": "Lundberg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "given_name": {
            "text": "Johan", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "lundberg@nordu.net", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ]
        }
      ], 
      "entity_id": "https://betafoo.nordu.net/saml2/metadata/", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://betafoo.nordu.net/saml2/ls/"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://betafoo.nordu.net/saml2/acs/"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC3DCCAcSgAwIBAgIJAMvFLpEMEvybMA0GCSqGSIb3DQEBBQUAMBIxEDAOBgNV\nBAMTB2JldGFmb28wHhcNMTIwMTIzMTMwNzAwWhcNMjIwMTIwMTMwNzAwWjASMRAw\nDgYDVQQDEwdiZXRhZm9vMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nn96BBnx0AbGpOlFnSJB2OM5eq/7nzzUx/lwfXIUxolYmz3m7QD16V6+wSRaVvK9R\n+83uUFjiFlKs9OEFRfcDJYgYhlV7r/SXyy41AlPrsqTCuYwEMErtVXePOc88it+V\nnX2wamumJxszGFxon9NXqwnTaza/yM0DFXPi5GJLwI0nhKugiXmlFQHICq2xcNBA\nEGjHQrL2FM//Fg3f8OJsJzqu2GjplWLNrphbdDH3++RJQQ+cNWq4XOzxTnM4BYoj\nn0Avwn35xA7dYdb7cu1qTzss/KCjjDxrJBE7mxJ9b1TK0gxSANfkiKxveJrAJque\nYjLmt2F268BRyMncF91SNwIDAQABozUwMzASBgNVHREECzAJggdiZXRhZm9vMB0G\nA1UdDgQWBBQCWrIP+6UbPqDmZu4046xkI8hUwjANBgkqhkiG9w0BAQUFAAOCAQEA\nEDFP2mVE6wKa2qQdfJUPGLnPp8a5UZKkwrvGpRYcgPp2JRUPRY0sBJlOPM8JeGKi\nrdb+7oWy5pHdpXWEY3gD+Vod7aHJ2g8fQ70l+nqHmh5pFTzqb3dnh8Dbn9M8cG0F\n2bATYYQt7fLEmGIFQ81Ix5Qnm+owPw7QxemE7DaGL4CCyNB5xiX0Kx38eCeEFps8\nFqI3Il3tF2U+FgOT+nizupQelaoagRNerw3p2FHEYeBaTCYiW3IF7lUMIjoX2MYI\n9P5iyOC2nGSq2vAzarevECtjw7KtKuX4K37LIEB5r07NXCPlfgTzHq1KomrY5Lhm\n91krk/l5w5Ayt90FuWQbAA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "want_assertions_signed": "true", 
          "authn_requests_signed": "false", 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "is_required": "true", 
                  "friendly_name": "uid", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "0.9.2342.19200300.100.1.1"
                }, 
                {
                  "is_required": "false", 
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "Federated Django sample SP", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/betafoo.nordu.net-8000-saml2.xml"
      }
    }
  ], 
  [
    "https://idp1.hs-augsburg.de/idp/shibboleth", 
    {
      "entity_id": "https://idp1.hs-augsburg.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp1.hs-augsburg.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp1.hs-augsburg.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp1.hs-augsburg.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-augsburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp1.hs-augsburg.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hs-augsburg.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "idp1.hs-augsburg.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp1.hs-augsburg.de,OU=Rechenzentrum,O=Fachhochschule Augsburg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFQDCCBCigAwIBAgIEDWb0jzANBgkqhkiG9w0BAQUFADCBiDELMAkGA1UEBhMC\nREUxIDAeBgNVBAoTF0ZhY2hob2Noc2NodWxlIEF1Z3NidXJnMRYwFAYDVQQLEw1S\nZWNoZW56ZW50cnVtMR0wGwYDVQQDExRGSCBBdWdzYnVyZyBDQSAtIEcwMjEgMB4G\nCSqGSIb3DQEJARYRY2FAZmgtYXVnc2J1cmcuZGUwHhcNMDgxMjE2MDkzODA3WhcN\nMTMxMjE1MDkzODA3WjBlMQswCQYDVQQGEwJERTEgMB4GA1UEChMXRmFjaGhvY2hz\nY2h1bGUgQXVnc2J1cmcxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHDAaBgNVBAMT\nE2lkcDEuaHMtYXVnc2J1cmcuZGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC8gWpAiIyVdxXsA68rHTJ5LvlxZfhDEjnEFUvayvT/0Y2iXRZSnb+79jzI\nkz+HCgSQwHh9TG9ypJZn8RB9vkxUTMgU5f/pIvOdI4DV6KlAQX7RGdIPRxBaWXjo\nVcqoayxntkfMU61jRA9p2bk0EA3uT/pxnzve0gAn3wF4DH1V+1AO/Rmb/d0m15my\n42JzGOUKcs6RyaF5VqjGVQLLD72n18YD5zbQBylxn0r+WbrJ8ASKvKiRu/T86oF3\nToQmWPjEqMnB2XIyYu7uz8Y5RCHgcM/DMXLjXxOr7pqdU7yQvbpcHhHr4QTTdzGR\naMAj/Oqio6QPuOKy1L61dXSBceytAgMBAAGjggHSMIIBzjAJBgNVHRMEAjAAMAsG\nA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwEwHQYDVR0O\nBBYEFKUAUSuvuh5EWFNPXRYWICHovPa8MB8GA1UdIwQYMBaAFNVwF+PewZf0CD7p\nOhGz6IjxkEfkMBwGA1UdEQQVMBOBEWNhQGZoLWF1Z3NidXJnLmRlMIGNBgNVHR8E\ngYUwgYIwP6A9oDuGOWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvZmgtYXVnc2J1cmct\nY2EvcHViL2NybC9nX2NhY3JsLmNybDA/oD2gO4Y5aHR0cDovL2NkcDIucGNhLmRm\nbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY3JsL2dfY2FjcmwuY3JsMIGmBggrBgEF\nBQcBAQSBmTCBljBJBggrBgEFBQcwAoY9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9m\naC1hdWdzYnVyZy1jYS9wdWIvY2FjZXJ0L2dfY2FjZXJ0LmNydDBJBggrBgEFBQcw\nAoY9aHR0cDovL2NkcDIucGNhLmRmbi5kZS9maC1hdWdzYnVyZy1jYS9wdWIvY2Fj\nZXJ0L2dfY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEAPHeiCv3u24AxLffg\niUTaEQq/+w8f2IgigO26Oq3Z2L5jLH9OeFXjKHOj2L1SzrW5cvuKijmMhSvlcCsI\ndSbt5uzza86ypR9wQARcVBEO1o2HIGEkIcy4IoLF/fQddMs5g5/12YJjtUt5vyJY\nf8IMl0N3Qq5SSIqh0QUfeFxFxArwJjLnMxA9bvg9Vy9jdftZoAJ5F5Ulf3Ofnpqf\nOEKCBtjuDDCfT2ZXClPIavsE8cXoGDo6xgP5zV8o0IvzDTM3DhlD6lMvVj4IFhjj\nAymMd/bc0s9QWtg6cTNyjd4QbIaSAMZXApNYRDkYyB2v5Tmi1YAlDXUS/DmWmb4Z\ncln+zg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Hochschule Augsburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Hochschule Augsburg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hs-augsburg.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Arno", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "arno.schneider@hs-augsburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schneider", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Arno", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "arno.schneider@hs-augsburg.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schneider", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://lingon.ladok.umu.se:8087/sp.xml", 
    {
      "entity_id": "https://lingon.ladok.umu.se:8087/sp.xml", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/lingon.ladok.umu.se.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "se", 
            "text": "Ume Universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "se", 
            "text": "Ume Universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.umu.se", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Roland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "roland.hedberg@umu.se", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hedberg", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://lingon.ladok.umu.se:8087/sls"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/post"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/redirect"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://lingon.ladok.umu.se:8087/ecp"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://lingon.ladok.umu.se:8087/disco"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC8jCCAlugAwIBAgIJAJHg2V5J31I8MA0GCSqGSIb3DQEBBQUAMFoxCzAJBgNV\n                        BAYTAlNFMQ0wCwYDVQQHEwRVbWVhMRgwFgYDVQQKEw9VbWVhIFVuaXZlcnNpdHkx\n                        EDAOBgNVBAsTB0lUIFVuaXQxEDAOBgNVBAMTB1Rlc3QgU1AwHhcNMDkxMDI2MTMz\n                        MTE1WhcNMTAxMDI2MTMzMTE1WjBaMQswCQYDVQQGEwJTRTENMAsGA1UEBxMEVW1l\n                        YTEYMBYGA1UEChMPVW1lYSBVbml2ZXJzaXR5MRAwDgYDVQQLEwdJVCBVbml0MRAw\n                        DgYDVQQDEwdUZXN0IFNQMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDkJWP7\n                        bwOxtH+E15VTaulNzVQ/0cSbM5G7abqeqSNSs0l0veHr6/ROgW96ZeQ57fzVy2MC\n                        FiQRw2fzBs0n7leEmDJyVVtBTavYlhAVXDNa3stgvh43qCfLx+clUlOvtnsoMiiR\n                        mo7qf0BoPKTj7c0uLKpDpEbAHQT4OF1HRYVxMwIDAQABo4G/MIG8MB0GA1UdDgQW\n                        BBQ7RgbMJFDGRBu9o3tDQDuSoBy7JjCBjAYDVR0jBIGEMIGBgBQ7RgbMJFDGRBu9\n                        o3tDQDuSoBy7JqFepFwwWjELMAkGA1UEBhMCU0UxDTALBgNVBAcTBFVtZWExGDAW\n                        BgNVBAoTD1VtZWEgVW5pdmVyc2l0eTEQMA4GA1UECxMHSVQgVW5pdDEQMA4GA1UE\n                        AxMHVGVzdCBTUIIJAJHg2V5J31I8MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\n                        BQADgYEAMuRwwXRnsiyWzmRikpwinnhTmbooKm5TINPE7A7gSQ710RxioQePPhZO\n                        zkM27NnHTrCe2rBVg0EGz7QTd1JIwLPvgoj4VTi/fSha/tXrYUaqc9AqU1kWI4WN\n                        +vffBGQ09mo+6CffuFTZYeOhzP/2stAPwCTU4kxEoiy0KpZMANI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC8jCCAlugAwIBAgIJAJHg2V5J31I8MA0GCSqGSIb3DQEBBQUAMFoxCzAJBgNV\n                        BAYTAlNFMQ0wCwYDVQQHEwRVbWVhMRgwFgYDVQQKEw9VbWVhIFVuaXZlcnNpdHkx\n                        EDAOBgNVBAsTB0lUIFVuaXQxEDAOBgNVBAMTB1Rlc3QgU1AwHhcNMDkxMDI2MTMz\n                        MTE1WhcNMTAxMDI2MTMzMTE1WjBaMQswCQYDVQQGEwJTRTENMAsGA1UEBxMEVW1l\n                        YTEYMBYGA1UEChMPVW1lYSBVbml2ZXJzaXR5MRAwDgYDVQQLEwdJVCBVbml0MRAw\n                        DgYDVQQDEwdUZXN0IFNQMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDkJWP7\n                        bwOxtH+E15VTaulNzVQ/0cSbM5G7abqeqSNSs0l0veHr6/ROgW96ZeQ57fzVy2MC\n                        FiQRw2fzBs0n7leEmDJyVVtBTavYlhAVXDNa3stgvh43qCfLx+clUlOvtnsoMiiR\n                        mo7qf0BoPKTj7c0uLKpDpEbAHQT4OF1HRYVxMwIDAQABo4G/MIG8MB0GA1UdDgQW\n                        BBQ7RgbMJFDGRBu9o3tDQDuSoBy7JjCBjAYDVR0jBIGEMIGBgBQ7RgbMJFDGRBu9\n                        o3tDQDuSoBy7JqFepFwwWjELMAkGA1UEBhMCU0UxDTALBgNVBAcTBFVtZWExGDAW\n                        BgNVBAoTD1VtZWEgVW5pdmVyc2l0eTEQMA4GA1UECxMHSVQgVW5pdDEQMA4GA1UE\n                        AxMHVGVzdCBTUIIJAJHg2V5J31I8MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\n                        BQADgYEAMuRwwXRnsiyWzmRikpwinnhTmbooKm5TINPE7A7gSQ710RxioQePPhZO\n                        zkM27NnHTrCe2rBVg0EGz7QTd1JIwLPvgoj4VTi/fSha/tXrYUaqc9AqU1kWI4WN\n                        +vffBGQ09mo+6CffuFTZYeOhzP/2stAPwCTU4kxEoiy0KpZMANI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "want_assertions_signed": "true", 
          "authn_requests_signed": "false", 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://lingon.ladok.umu.se:8087/ars"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/mni"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/mni"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/mni"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://lingon.ladok.umu.se:8087/acs/artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://idp2.jacobs-university.de/idp/shibboleth", 
    {
      "entity_id": "https://idp2.jacobs-university.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp2.jacobs-university.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp2.jacobs-university.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "jacobs-university.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp2.jacobs-university.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp2.jacobs-university.de,O=Jacobs University Bremen gGmbH,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFKzCCBBOgAwIBAgIEEgMQTjANBgkqhkiG9w0BAQUFADBsMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeSmFjb2JzIFVuaXZlcnNpdHkgQnJlbWVuIGdHbWJIMQ8wDQYD\nVQQLEwZJUkMtSVQxIzAhBgNVBAMTGkphY29icyBVbml2ZXJzaXR5IENBIC0gRzAx\nMB4XDTExMDUzMDEyNTExMFoXDTE2MDUyODEyNTExMFowWjELMAkGA1UEBhMCREUx\nJzAlBgNVBAoTHkphY29icyBVbml2ZXJzaXR5IEJyZW1lbiBnR21iSDEiMCAGA1UE\nAxMZaWRwMi5qYWNvYnMtdW5pdmVyc2l0eS5kZTCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBALBn+nYoa8EkdT59Kn5iyaouvhAZTZsuAB2hqg2Ldo/8J4Pc\nSU6y0ck/a2xgK45CDK+bE12fGM1A828Z+Zkx615PyXRve3Z3uhKLwWh+aVh9Czsn\nO5a4GGPLY/fVeeJyAWk95Vgco2h7hGxOrCGynMCx+wa89SIA1q4DYo4stDPu5zaC\nkZn2+m2eH6Ht6UjIqA4GEhh9/lXNoLJruq/kFgUA0TC5KelRWO2M40zACljgUXjZ\n3ISZXtFqI+1kHTxUd6h/mlsKVk4iFjYLK5HZwl+8/pueO3spiNISLZ8KBewyehVv\ncGsYLGermgavGpNfuHXQn5eZ9nBveWd6zWkGZz0CAwEAAaOCAeUwggHhMAkGA1Ud\nEwQCMAAwCwYDVR0PBAQDAgTwMBMGA1UdJQQMMAoGCCsGAQUFBwMBMB0GA1UdDgQW\nBBTismVGIRouSFz019/hsKvjP4k35TAfBgNVHSMEGDAWgBQcq0Ha1JXUnR6CzU19\nEyU37B+IpzApBgNVHREEIjAggR5pdHN1cHBvcnRAamFjb2JzLXVuaXZlcnNpdHku\nZGUwgZUGA1UdHwSBjTCBijBDoEGgP4Y9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9q\nYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3JsL2NhY3JsLmNybDBDoEGgP4Y9aHR0\ncDovL2NkcDIucGNhLmRmbi5kZS9qYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3Js\nL2NhY3JsLmNybDCBrgYIKwYBBQUHAQEEgaEwgZ4wTQYIKwYBBQUHMAKGQWh0dHA6\nLy9jZHAxLnBjYS5kZm4uZGUvamFjb2JzLXVuaXZlcnNpdHktY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0ME0GCCsGAQUFBzAChkFodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL2phY29icy11bml2ZXJzaXR5LWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDANBgkq\nhkiG9w0BAQUFAAOCAQEAdpCxa/1qVbMWIpJaOkAvhMC6U329LELs5yQLETHvmlPN\nr3t1ULEQnssVDVtD7QfoKpUnRTmcSdOj13e+lTf2KEH46jVowVG9R4xZ4pf9huB6\nIq8CkpOUYTdhzbf3XP/YQRzSWNRe4TJQXqVgvmuG810yKbDRiA2gMnHnE1vbz4u+\n+dL9AEycWmnXgWu5K9QlyAKQxs35VZU1J+2x8PRO8of/csD1C4EcoEwq986tpjRd\nIabwcBEXXxXY0P6/0zC5UrnPCkzyZmL67m/gGNmGhJ3tDnb9mxdrp6t+5JmtG4Qf\nUlOc3b1APPVI3weamhzR+rrUr45b/yLBbFTLwXsTWw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp2.jacobs-university.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "jacobs-university.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp2.jacobs-university.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp2.jacobs-university.de,O=Jacobs University Bremen gGmbH,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFKzCCBBOgAwIBAgIEEgMQTjANBgkqhkiG9w0BAQUFADBsMQswCQYDVQQGEwJE\nRTEnMCUGA1UEChMeSmFjb2JzIFVuaXZlcnNpdHkgQnJlbWVuIGdHbWJIMQ8wDQYD\nVQQLEwZJUkMtSVQxIzAhBgNVBAMTGkphY29icyBVbml2ZXJzaXR5IENBIC0gRzAx\nMB4XDTExMDUzMDEyNTExMFoXDTE2MDUyODEyNTExMFowWjELMAkGA1UEBhMCREUx\nJzAlBgNVBAoTHkphY29icyBVbml2ZXJzaXR5IEJyZW1lbiBnR21iSDEiMCAGA1UE\nAxMZaWRwMi5qYWNvYnMtdW5pdmVyc2l0eS5kZTCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBALBn+nYoa8EkdT59Kn5iyaouvhAZTZsuAB2hqg2Ldo/8J4Pc\nSU6y0ck/a2xgK45CDK+bE12fGM1A828Z+Zkx615PyXRve3Z3uhKLwWh+aVh9Czsn\nO5a4GGPLY/fVeeJyAWk95Vgco2h7hGxOrCGynMCx+wa89SIA1q4DYo4stDPu5zaC\nkZn2+m2eH6Ht6UjIqA4GEhh9/lXNoLJruq/kFgUA0TC5KelRWO2M40zACljgUXjZ\n3ISZXtFqI+1kHTxUd6h/mlsKVk4iFjYLK5HZwl+8/pueO3spiNISLZ8KBewyehVv\ncGsYLGermgavGpNfuHXQn5eZ9nBveWd6zWkGZz0CAwEAAaOCAeUwggHhMAkGA1Ud\nEwQCMAAwCwYDVR0PBAQDAgTwMBMGA1UdJQQMMAoGCCsGAQUFBwMBMB0GA1UdDgQW\nBBTismVGIRouSFz019/hsKvjP4k35TAfBgNVHSMEGDAWgBQcq0Ha1JXUnR6CzU19\nEyU37B+IpzApBgNVHREEIjAggR5pdHN1cHBvcnRAamFjb2JzLXVuaXZlcnNpdHku\nZGUwgZUGA1UdHwSBjTCBijBDoEGgP4Y9aHR0cDovL2NkcDEucGNhLmRmbi5kZS9q\nYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3JsL2NhY3JsLmNybDBDoEGgP4Y9aHR0\ncDovL2NkcDIucGNhLmRmbi5kZS9qYWNvYnMtdW5pdmVyc2l0eS1jYS9wdWIvY3Js\nL2NhY3JsLmNybDCBrgYIKwYBBQUHAQEEgaEwgZ4wTQYIKwYBBQUHMAKGQWh0dHA6\nLy9jZHAxLnBjYS5kZm4uZGUvamFjb2JzLXVuaXZlcnNpdHktY2EvcHViL2NhY2Vy\ndC9jYWNlcnQuY3J0ME0GCCsGAQUFBzAChkFodHRwOi8vY2RwMi5wY2EuZGZuLmRl\nL2phY29icy11bml2ZXJzaXR5LWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNydDANBgkq\nhkiG9w0BAQUFAAOCAQEAdpCxa/1qVbMWIpJaOkAvhMC6U329LELs5yQLETHvmlPN\nr3t1ULEQnssVDVtD7QfoKpUnRTmcSdOj13e+lTf2KEH46jVowVG9R4xZ4pf9huB6\nIq8CkpOUYTdhzbf3XP/YQRzSWNRe4TJQXqVgvmuG810yKbDRiA2gMnHnE1vbz4u+\n+dL9AEycWmnXgWu5K9QlyAKQxs35VZU1J+2x8PRO8of/csD1C4EcoEwq986tpjRd\nIabwcBEXXxXY0P6/0zC5UrnPCkzyZmL67m/gGNmGhJ3tDnb9mxdrp6t+5JmtG4Qf\nUlOc3b1APPVI3weamhzR+rrUr45b/yLBbFTLwXsTWw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Jacobs University Bremen gGmbH", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Jacobs University Bremen gGmbH", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.jacobs-university.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Mario", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "itsupport@jacobs-university.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Kaiser", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Torge", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "t.schmidt@jacobs-university.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Schmidt", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://beta.lobber.se/shibboleth", 
    {
      "entity_id": "https://beta.lobber.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "0", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "SUNET Lobber (BETA) - a BitTorrent data distribution service", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.9"
                }, 
                {
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.7"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "SUNET Lobber (BETA)", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://beta.lobber.se/Shibboleth.sso/DS/ds.swamid.se"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://beta.lobber.se/Shibboleth.sso/DS/kalmar2"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "beta.lobber.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "https://beta.lobber.se/shibboleth-sp", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=beta.lobber.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDFzCCAf+gAwIBAgIJAK3WrSSve3L0MA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDmJldGEubG9iYmVyLnNlMB4XDTEwMDQxNjA4MzUyNVoXDTIwMDQxMzA4MzUy\nNVowGTEXMBUGA1UEAxMOYmV0YS5sb2JiZXIuc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQDUL7NU/brgRsoszEetP0BPY9XcmjSY9BymFpvOn09zLvoY\nJDUgRa5Y54ob3vZZ6dkIBhqZulbTM1/8OMyOFk3zL/SkJJK4Ga7xVelT3JdQGwIU\nTvSuxg2p8CXVijurqVtYp8wWsVyelrpLiQh1X7JSqLlSordJBsFJrKlj7Y8eTqy6\nCuEaWXV4E6pqTmlM2Q+WILSG0G7j8YYw9FVlzTDaF5xM4FhQsYa3DWHNZUZlmB/E\nBBUJmcPpZCDOQP/n5dZnQrDQYSuDudy3UpkuHQHf4B8yiffdOKMFzHcTfQDuMJXw\nh6sA5Xrq1WpsOwn9kgONyDm8ML3IFJC3AYLOLvfdAgMBAAGjYjBgMD8GA1UdEQQ4\nMDaCDmJldGEubG9iYmVyLnNlhiRodHRwczovL2JldGEubG9iYmVyLnNlL3NoaWJi\nb2xldGgtc3AwHQYDVR0OBBYEFEWVLP4kBg/gV79XUV32F6dX7kKBMA0GCSqGSIb3\nDQEBBQUAA4IBAQA666NJBd3xPuNy6PRToyJvGmltOxIsn2HFHANX5xqc7GK9v6vw\nzVhVTpx64sZFC6/B/laF9RNmtr9IxiI2wk43ZkdFtoADGlXMKevQ4+CjdLbqb4VP\nTisAp2vpojnlXtmdj3UCzOmiMjgLlRQY8WN1/vMVBNeYKtJSyXfl4mWVNUTBxnAq\nD46Wa7GYLUVqlWdkWDHBznr4QA4MRxhJDOsm9aVVDq4yAOwCQrHdY+xDokcx4mdN\n5dNwkP7gqpYuryKTfnI32kaRKL+kMXotFg6r+qAaIEo67D3LMnWJE75aZb16HVwz\n/MAyn2Vwd/VAgvtvblNu62vT9+d6mW7zQqTZ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "beta.lobber.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "https://beta.lobber.se/shibboleth-sp", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=beta.lobber.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDFzCCAf+gAwIBAgIJAK3WrSSve3L0MA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDmJldGEubG9iYmVyLnNlMB4XDTEwMDQxNjA4MzUyNVoXDTIwMDQxMzA4MzUy\nNVowGTEXMBUGA1UEAxMOYmV0YS5sb2JiZXIuc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQDUL7NU/brgRsoszEetP0BPY9XcmjSY9BymFpvOn09zLvoY\nJDUgRa5Y54ob3vZZ6dkIBhqZulbTM1/8OMyOFk3zL/SkJJK4Ga7xVelT3JdQGwIU\nTvSuxg2p8CXVijurqVtYp8wWsVyelrpLiQh1X7JSqLlSordJBsFJrKlj7Y8eTqy6\nCuEaWXV4E6pqTmlM2Q+WILSG0G7j8YYw9FVlzTDaF5xM4FhQsYa3DWHNZUZlmB/E\nBBUJmcPpZCDOQP/n5dZnQrDQYSuDudy3UpkuHQHf4B8yiffdOKMFzHcTfQDuMJXw\nh6sA5Xrq1WpsOwn9kgONyDm8ML3IFJC3AYLOLvfdAgMBAAGjYjBgMD8GA1UdEQQ4\nMDaCDmJldGEubG9iYmVyLnNlhiRodHRwczovL2JldGEubG9iYmVyLnNlL3NoaWJi\nb2xldGgtc3AwHQYDVR0OBBYEFEWVLP4kBg/gV79XUV32F6dX7kKBMA0GCSqGSIb3\nDQEBBQUAA4IBAQA666NJBd3xPuNy6PRToyJvGmltOxIsn2HFHANX5xqc7GK9v6vw\nzVhVTpx64sZFC6/B/laF9RNmtr9IxiI2wk43ZkdFtoADGlXMKevQ4+CjdLbqb4VP\nTisAp2vpojnlXtmdj3UCzOmiMjgLlRQY8WN1/vMVBNeYKtJSyXfl4mWVNUTBxnAq\nD46Wa7GYLUVqlWdkWDHBznr4QA4MRxhJDOsm9aVVDq4yAOwCQrHdY+xDokcx4mdN\n5dNwkP7gqpYuryKTfnI32kaRKL+kMXotFg6r+qAaIEo67D3LMnWJE75aZb16HVwz\n/MAyn2Vwd/VAgvtvblNu62vT9+d6mW7zQqTZ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://beta.lobber.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/beta.lobber.se.xml"
      }
    }
  ], 
  [
    "https://calipso.cpd.ufv.br/idp/shibboleth", 
    {
      "entity_id": "https://calipso.cpd.ufv.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/calipso.cpd.ufv.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://calipso.cpd.ufv.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufv.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufv.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufv.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFV - Universidade Federal de Vicosa", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEfTCCA2WgAwIBAgIBADANBgkqhkiG9w0BAQUFADCB3TELMAkGA1UEBhMCQlIx\nFTATBgNVBAgTDE1pbmFzIEdlcmFpczEPMA0GA1UEBxMGVmljb3NhMS0wKwYDVQQK\nEyRVRlYgLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBWaWNvc2ExNDAyBgNVBAsT\nK0RUSSAtIERpcmV0b3JpYSBkZSBUZWNub2xvZ2lhIGRhIEluZm9ybWFjYW8xJDAi\nBgkqhkiG9w0BCQEWFXBvbGx5YW5uYS5tb3RhQHVmdi5icjEbMBkGA1UEAxMSY2Fs\naXBzby5jcGQudWZ2LmJyMB4XDTEwMDQwODEyMjk0MFoXDTEzMDQwNzEyMjk0MFow\ngd0xCzAJBgNVBAYTAkJSMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxDzANBgNVBAcT\nBlZpY29zYTEtMCsGA1UEChMkVUZWIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUg\nVmljb3NhMTQwMgYDVQQLEytEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBk\nYSBJbmZvcm1hY2FvMSQwIgYJKoZIhvcNAQkBFhVwb2xseWFubmEubW90YUB1ZnYu\nYnIxGzAZBgNVBAMTEmNhbGlwc28uY3BkLnVmdi5icjCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMozVW2X3OMKcEQcp4RnGTFR2s6iSFoHvkVPjYkpWszZ\n+QfEV3GroXsLWv/RjJ+QtXhXfttFB0fNdiCWhxh2wbkeF2t1v21B+sCirnf+1qm6\ne0oetbRxK6k5O39pioOdEdUrMoN5s2WLoqMmK8ryqgb25GwLVolne9S4Wwyaocgp\nbDYjG11lZia7bEO03TsKPv7i5s4d2htD/wU+qkDT52H6aGI09L25bpwT+/aeUeIH\nFvy750y5voXDaXx6MH9DrGslG7Dr9S/207uq0AxIrHaIgUbl6307tZhFbN32kBLT\nd/413Qb6H4RKsxwv+DLmy3UEa/c4UGeN7Vn7RDm5+/0CAwEAAaNGMEQwCQYDVR0T\nBAIwADALBgNVHQ8EBAMCBaAwKgYDVR0lBCMwIQYIKwYBBQUHAwEGCWCGSAGG+EIE\nAQYKKwYBBAGCNwoDAzANBgkqhkiG9w0BAQUFAAOCAQEAAzFQSYz2mWPl2z0fhnc8\nKfVtknNUnZFOzozeTD4UrmtTjRZo2O2BY6+9imoLcPtW3GH1fV7maZBk2QdHm1NN\n63yt1rqfMVplsCBbRpgSEBdIEHwUDmT3xGrFphhW84QGIh7dJuhdvaQ522C/YVyK\nzqppjlaUSZgqp4/jL8okZfDRgP+Sw3dBt0zJ+YpR60EQ7niv9mUKsJH4JXGcVtV+\neTUY0S2J5SynJg4s5y9P2tMykzU/tA1pa+B1joFMAe37uKlKTiTWPJgSz/Q0/1bY\nZEvbFOP1xLmtYXK8ipoyp3dauE5ls2QwIhanMz5A6SpPJYWO+9nLq7MQiSwfuvvJ\n1Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://calipso.cpd.ufv.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufv.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEfTCCA2WgAwIBAgIBADANBgkqhkiG9w0BAQUFADCB3TELMAkGA1UEBhMCQlIx\nFTATBgNVBAgTDE1pbmFzIEdlcmFpczEPMA0GA1UEBxMGVmljb3NhMS0wKwYDVQQK\nEyRVRlYgLSBVbml2ZXJzaWRhZGUgRmVkZXJhbCBkZSBWaWNvc2ExNDAyBgNVBAsT\nK0RUSSAtIERpcmV0b3JpYSBkZSBUZWNub2xvZ2lhIGRhIEluZm9ybWFjYW8xJDAi\nBgkqhkiG9w0BCQEWFXBvbGx5YW5uYS5tb3RhQHVmdi5icjEbMBkGA1UEAxMSY2Fs\naXBzby5jcGQudWZ2LmJyMB4XDTEwMDQwODEyMjk0MFoXDTEzMDQwNzEyMjk0MFow\ngd0xCzAJBgNVBAYTAkJSMRUwEwYDVQQIEwxNaW5hcyBHZXJhaXMxDzANBgNVBAcT\nBlZpY29zYTEtMCsGA1UEChMkVUZWIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUg\nVmljb3NhMTQwMgYDVQQLEytEVEkgLSBEaXJldG9yaWEgZGUgVGVjbm9sb2dpYSBk\nYSBJbmZvcm1hY2FvMSQwIgYJKoZIhvcNAQkBFhVwb2xseWFubmEubW90YUB1ZnYu\nYnIxGzAZBgNVBAMTEmNhbGlwc28uY3BkLnVmdi5icjCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMozVW2X3OMKcEQcp4RnGTFR2s6iSFoHvkVPjYkpWszZ\n+QfEV3GroXsLWv/RjJ+QtXhXfttFB0fNdiCWhxh2wbkeF2t1v21B+sCirnf+1qm6\ne0oetbRxK6k5O39pioOdEdUrMoN5s2WLoqMmK8ryqgb25GwLVolne9S4Wwyaocgp\nbDYjG11lZia7bEO03TsKPv7i5s4d2htD/wU+qkDT52H6aGI09L25bpwT+/aeUeIH\nFvy750y5voXDaXx6MH9DrGslG7Dr9S/207uq0AxIrHaIgUbl6307tZhFbN32kBLT\nd/413Qb6H4RKsxwv+DLmy3UEa/c4UGeN7Vn7RDm5+/0CAwEAAaNGMEQwCQYDVR0T\nBAIwADALBgNVHQ8EBAMCBaAwKgYDVR0lBCMwIQYIKwYBBQUHAwEGCWCGSAGG+EIE\nAQYKKwYBBAGCNwoDAzANBgkqhkiG9w0BAQUFAAOCAQEAAzFQSYz2mWPl2z0fhnc8\nKfVtknNUnZFOzozeTD4UrmtTjRZo2O2BY6+9imoLcPtW3GH1fV7maZBk2QdHm1NN\n63yt1rqfMVplsCBbRpgSEBdIEHwUDmT3xGrFphhW84QGIh7dJuhdvaQ522C/YVyK\nzqppjlaUSZgqp4/jL8okZfDRgP+Sw3dBt0zJ+YpR60EQ7niv9mUKsJH4JXGcVtV+\neTUY0S2J5SynJg4s5y9P2tMykzU/tA1pa+B1joFMAe37uKlKTiTWPJgSz/Q0/1bY\nZEvbFOP1xLmtYXK8ipoyp3dauE5ls2QwIhanMz5A6SpPJYWO+9nLq7MQiSwfuvvJ\n1Q==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFV - Universidade Federal de Vicosa", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufv.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufv.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "pollyanna.mota@ufv.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Pollyanna Lopes Mota", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://vfu-gemdev.it.su.se/Shibboleth.sso", 
    {
      "id": "_155af7801eb643ce8235d889a398f816", 
      "entity_id": "https://vfu-gemdev.it.su.se/Shibboleth.sso", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SAML/Artifact"
            }, 
            {
              "index": "7", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "8", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "9", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "10", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/SAML2/ECP"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/WAYF"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/WAYF/wavelan"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "vfu-gemdev-sp01", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=vfu-gemdev-sp01", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9DCCAdygAwIBAgIJAM2DRYvk1gHoMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3ZmdS1nZW1kZXYtc3AwMTAeFw0xMjAzMjMxMTIzNTVaFw0yMjAzMjExMTIz\nNTVaMBoxGDAWBgNVBAMTD3ZmdS1nZW1kZXYtc3AwMTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMNWXQiNwZrd5EpYMZEYbTTQAGLIHPuAgzAf5mrjnyXF\n+811k0uJova1/Jsb1TYyua5Ti5SncDIKsLZFFpxbIHF7Yq22r4bmrYdsQ9bTeifc\nNlMjY/N9we9x/07LmxMopbAZEHbwm7b/xsoSpJ6uGs6wRSxpBejGmB9t5BhQzNN2\nicp/H89hzyOqyzAMl3O6SirdVh/cNqFBAlnVS21Nryy1wWZMr3w0HhkbkEz6Zanz\n6KtWI3IFqeHOhPomiVaWquTp49pGO43cwHb6Tx1h4h+OSqCN9TazA8nOJ0PMAUMp\nNnPgWQW6SO13nVAcHihIDPfoYvD/wW2CYJjUT5OzjqECAwEAAaM9MDswGgYDVR0R\nBBMwEYIPdmZ1LWdlbWRldi1zcDAxMB0GA1UdDgQWBBSEdlf3VKcDHEXFAgPS21B9\nV+cblDANBgkqhkiG9w0BAQUFAAOCAQEAsre/1aUSAAo9bV7rYksGRiCev7VWIxQo\nedcLShMNCBNB9/ozjHtc84J70ONzGPT8oluEBIv5Pl6A0E1RdOjEcnqlvC0Xy0Ad\nu2MmVCM59MNhPMhh8IeBwLcX5jXTOWNvus/Z1rN4NNvYUoPZ9V4+ghAhE09qWSXG\n//NXO1nEPxaPOvs7mwS74gevi6bcbhDULdLWm9Sh6h8La66MHL88QlLHoY9wNCJw\nxAS3RyWn29BJ1tVJtSzAQZLzUtL1XisTFaGHGcCxEgG0+JkqxEl5zi2gGcYxkdpq\nUaFs0ulwkp2uVhPCL1SV0KFnIWeKpY9rkcacQlpaDxwK5TKUnmw3zA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "vfu-gemdev-sp01", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=vfu-gemdev-sp01", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC9DCCAdygAwIBAgIJAM2DRYvk1gHoMA0GCSqGSIb3DQEBBQUAMBoxGDAWBgNV\nBAMTD3ZmdS1nZW1kZXYtc3AwMTAeFw0xMjAzMjMxMTIzNTVaFw0yMjAzMjExMTIz\nNTVaMBoxGDAWBgNVBAMTD3ZmdS1nZW1kZXYtc3AwMTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAMNWXQiNwZrd5EpYMZEYbTTQAGLIHPuAgzAf5mrjnyXF\n+811k0uJova1/Jsb1TYyua5Ti5SncDIKsLZFFpxbIHF7Yq22r4bmrYdsQ9bTeifc\nNlMjY/N9we9x/07LmxMopbAZEHbwm7b/xsoSpJ6uGs6wRSxpBejGmB9t5BhQzNN2\nicp/H89hzyOqyzAMl3O6SirdVh/cNqFBAlnVS21Nryy1wWZMr3w0HhkbkEz6Zanz\n6KtWI3IFqeHOhPomiVaWquTp49pGO43cwHb6Tx1h4h+OSqCN9TazA8nOJ0PMAUMp\nNnPgWQW6SO13nVAcHihIDPfoYvD/wW2CYJjUT5OzjqECAwEAAaM9MDswGgYDVR0R\nBBMwEYIPdmZ1LWdlbWRldi1zcDAxMB0GA1UdDgQWBBSEdlf3VKcDHEXFAgPS21B9\nV+cblDANBgkqhkiG9w0BAQUFAAOCAQEAsre/1aUSAAo9bV7rYksGRiCev7VWIxQo\nedcLShMNCBNB9/ozjHtc84J70ONzGPT8oluEBIv5Pl6A0E1RdOjEcnqlvC0Xy0Ad\nu2MmVCM59MNhPMhh8IeBwLcX5jXTOWNvus/Z1rN4NNvYUoPZ9V4+ghAhE09qWSXG\n//NXO1nEPxaPOvs7mwS74gevi6bcbhDULdLWm9Sh6h8La66MHL88QlLHoY9wNCJw\nxAS3RyWn29BJ1tVJtSzAQZLzUtL1XisTFaGHGcCxEgG0+JkqxEl5zi2gGcYxkdpq\nUaFs0ulwkp2uVhPCL1SV0KFnIWeKpY9rkcacQlpaDxwK5TKUnmw3zA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://vfu-gemdev.it.su.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/vfu-gemdev.it.su.se.xml"
      }
    }
  ], 
  [
    "https://www.degruyter.com/shibboleth", 
    {
      "entity_id": "https://www.degruyter.com/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.degruyter.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "De Gruyter Online", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "De Gruyter Online", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.degruyter.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Scott", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "it@ifactory.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Cipriano", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Ulrike", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "ulrike.engel@degruyter.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Engel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.degruyter.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.degruyter.com", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIEEpCtsTANBgkqhkiG9w0BAQsFADAcMRowGAYDVQQDExF3\nd3cuZGVncnV5dGVyLmNvbTAeFw0xMjAxMjcwMzE2MzBaFw0xNTAxMjYwMzE2MzBa\nMBwxGjAYBgNVBAMTEXd3dy5kZWdydXl0ZXIuY29tMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAtToxdgbSOQHMFtLO+p50jHIis3Cg1n08fU8scnC5mGnm\nQKBb+io0YLFMZ+pGrYWl3nOr3lsVnSj+7FWTJYWlGqkGf4fW0htYxeLUYTmw17pg\n2yzjaKKmefQ5EX03dVnMmFfG6n4ITBms/xm28u3JRWmAZ8i4SUZhsZM1UAKmyddv\nDeF4P/MDOg+HotkEZzv8Ce0Iqf5xS2Gl2NvJuQBVQfROyXvC1UvWFPJry8Sp5izg\nnekjb87CWD/sHj/1/ih+t7KTKhyqPEcdywOYzVAlL28LNJm1Sx2T6b+qmxu0sLe8\ne0A7K8/Klevx0c+L+1apbh1vYVH4e3KN+mhsUbBSyQIDAQABo2UwYzAdBgNVHQ4E\nFgQUX0SLbR2HWLTt/d7PhuyMq4CVAD0wQgYDVR0RBDswOYYkaHR0cHM6Ly93d3cu\nZGVncnV5dGVyLmNvbS9zaGliYm9sZXRoghF3d3cuZGVncnV5dGVyLmNvbTANBgkq\nhkiG9w0BAQsFAAOCAQEAM/uD1qjWNFP9lOUk48zRve2pIZIkq+lOr4JB7ORLUaLn\nUFIC3ay1JwSGEoaic0VA9kNGCfevUluMLZJfAtYYQkTx0hqF264tf8W2MdvaFlJa\nWwqciyEhs/Wg4daMUoSfCrKUwhwb3veY5nToqgJ5zJ/5sZYRdjzDH7PumH3klSG0\ne6FV3DgCekCajSBjOoQLjlcgseHXTX3/JguL9uyJVxMNPArbW6ciE7nCAXwg2neL\nklxijSNZsJQno36M5UueC9aLK4mdoJrS06CRLOeyxBNQachanmq6XBx/yWSeBBq5\nvxnuL36+AybWxM2JdPoPKWxXLxi9KgtY1Fw/Heyaug==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "www.degruyter.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.degruyter.com", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIEEpCtsTANBgkqhkiG9w0BAQsFADAcMRowGAYDVQQDExF3\nd3cuZGVncnV5dGVyLmNvbTAeFw0xMjAxMjcwMzE2MzBaFw0xNTAxMjYwMzE2MzBa\nMBwxGjAYBgNVBAMTEXd3dy5kZWdydXl0ZXIuY29tMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAtToxdgbSOQHMFtLO+p50jHIis3Cg1n08fU8scnC5mGnm\nQKBb+io0YLFMZ+pGrYWl3nOr3lsVnSj+7FWTJYWlGqkGf4fW0htYxeLUYTmw17pg\n2yzjaKKmefQ5EX03dVnMmFfG6n4ITBms/xm28u3JRWmAZ8i4SUZhsZM1UAKmyddv\nDeF4P/MDOg+HotkEZzv8Ce0Iqf5xS2Gl2NvJuQBVQfROyXvC1UvWFPJry8Sp5izg\nnekjb87CWD/sHj/1/ih+t7KTKhyqPEcdywOYzVAlL28LNJm1Sx2T6b+qmxu0sLe8\ne0A7K8/Klevx0c+L+1apbh1vYVH4e3KN+mhsUbBSyQIDAQABo2UwYzAdBgNVHQ4E\nFgQUX0SLbR2HWLTt/d7PhuyMq4CVAD0wQgYDVR0RBDswOYYkaHR0cHM6Ly93d3cu\nZGVncnV5dGVyLmNvbS9zaGliYm9sZXRoghF3d3cuZGVncnV5dGVyLmNvbTANBgkq\nhkiG9w0BAQsFAAOCAQEAM/uD1qjWNFP9lOUk48zRve2pIZIkq+lOr4JB7ORLUaLn\nUFIC3ay1JwSGEoaic0VA9kNGCfevUluMLZJfAtYYQkTx0hqF264tf8W2MdvaFlJa\nWwqciyEhs/Wg4daMUoSfCrKUwhwb3veY5nToqgJ5zJ/5sZYRdjzDH7PumH3klSG0\ne6FV3DgCekCajSBjOoQLjlcgseHXTX3/JguL9uyJVxMNPArbW6ciE7nCAXwg2neL\nklxijSNZsJQno36M5UueC9aLK4mdoJrS06CRLOeyxBNQachanmq6XBx/yWSeBBq5\nvxnuL36+AybWxM2JdPoPKWxXLxi9KgtY1Fw/Heyaug==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/shib/post"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/shib/art"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/saml2/post"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.degruyter.com/oa/auth/rcv/saml2/art"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://shibboleth.ufsc.br/idp/shibboleth", 
    {
      "entity_id": "https://shibboleth.ufsc.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shibboleth.ufsc.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth.ufsc.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufsc.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.ufsc.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.ufsc.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "UFSC - Universidade Federal de Santa Catarina", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIESzCCAzOgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBxDELMAkGA1UEBhMCQlIx\nFzAVBgNVBAgTDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlz\nMTYwNAYDVQQKEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEg\nQ2F0YXJpbmExLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRv\nIGRlIERhZG9zMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwHhcNMTAwNTAy\nMTUyNTQzWhcNMTMwNTAxMTUyNTQzWjCBxDELMAkGA1UEBhMCQlIxFzAVBgNVBAgT\nDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlzMTYwNAYDVQQK\nEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEgQ2F0YXJpbmEx\nLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRlIERhZG9z\nMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQC/oBIF0VeleZ37F3PzefDHAIrgwIaN2aRyLzZ4Uv8/FYsW\nLIXeOxXr49qJ77jFFkv/UzXZJvLvb6yhKC0A18E+ZDcKSQZuYoG8Arx+ohPREI82\n4htm1uAwGAw/SUsDVTgFodHOmIOmal71f6sorCKb1GeBkDkpkSYyYXG3t7fktVY7\n41kqaPcGellMrccwKztjFs31GvNLNZCpLOpF3lLmmpDApOaFO1f9qbSKv0GZPYPm\n/8NxE+4wJMUVHzExCpn/YV0rBd4DfNhU4LJGx6yYQCe+Rj6Uu9vL3AHcBU5kPT/g\ngxte+CDsQADIoYct8oPPDsZa4ezejgh1+XbTcqTzAgMBAAGjRjBEMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgWgMCoGA1UdJQQjMCEGCCsGAQUFBwMBBglghkgBhvhCBAEG\nCisGAQQBgjcKAwMwDQYJKoZIhvcNAQEFBQADggEBABDXKoRWo0mR3SNv98le5NbN\n0QeuL52xlm51qmhWHKCT0ph0AmfDO4LdG/o1oPrtZup34/7BBRKHifuvluknH2DW\ndD9JhriTxsCsw/6Q5UtkQ2ZL40eic2VKk7LKsv8WsVq0Dddfz9aQVAmqnAExKLux\nYY+Hd0263kpDiu/0yEiT4G/3RPhKAmtib08Muc5FPQfIjM/IpF0OydhKYLCPQhtQ\n+0L6xe7VreHsP/n9EoGQ/2hZty+D4k2myZ/ypZH00jSs4+0cVysLZGKbRp481nOn\nutYTuLXJ0VDcCFf3RMwNYDCkW9k160NOZIap3RGIftCo2KR12TlxIE0+McltbGQ=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth.ufsc.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ufsc.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIESzCCAzOgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBxDELMAkGA1UEBhMCQlIx\nFzAVBgNVBAgTDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlz\nMTYwNAYDVQQKEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEg\nQ2F0YXJpbmExLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRv\nIGRlIERhZG9zMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwHhcNMTAwNTAy\nMTUyNTQzWhcNMTMwNTAxMTUyNTQzWjCBxDELMAkGA1UEBhMCQlIxFzAVBgNVBAgT\nDlNhbnRhIENhdGFyaW5hMRYwFAYDVQQHEw1GbG9yaWFub3BvbGlzMTYwNAYDVQQK\nEy1VRlNDIC0gVW5pdmVyc2lkYWRlIEZlZGVyYWwgZGUgU2FudGEgQ2F0YXJpbmEx\nLzAtBgNVBAsTJk5QRCAtIE51Y2xlbyBkZSBQcm9jZXNzYW1lbnRvIGRlIERhZG9z\nMRswGQYDVQQDExJzaGliYm9sZXRoLnVmc2MuYnIwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQC/oBIF0VeleZ37F3PzefDHAIrgwIaN2aRyLzZ4Uv8/FYsW\nLIXeOxXr49qJ77jFFkv/UzXZJvLvb6yhKC0A18E+ZDcKSQZuYoG8Arx+ohPREI82\n4htm1uAwGAw/SUsDVTgFodHOmIOmal71f6sorCKb1GeBkDkpkSYyYXG3t7fktVY7\n41kqaPcGellMrccwKztjFs31GvNLNZCpLOpF3lLmmpDApOaFO1f9qbSKv0GZPYPm\n/8NxE+4wJMUVHzExCpn/YV0rBd4DfNhU4LJGx6yYQCe+Rj6Uu9vL3AHcBU5kPT/g\ngxte+CDsQADIoYct8oPPDsZa4ezejgh1+XbTcqTzAgMBAAGjRjBEMAkGA1UdEwQC\nMAAwCwYDVR0PBAQDAgWgMCoGA1UdJQQjMCEGCCsGAQUFBwMBBglghkgBhvhCBAEG\nCisGAQQBgjcKAwMwDQYJKoZIhvcNAQEFBQADggEBABDXKoRWo0mR3SNv98le5NbN\n0QeuL52xlm51qmhWHKCT0ph0AmfDO4LdG/o1oPrtZup34/7BBRKHifuvluknH2DW\ndD9JhriTxsCsw/6Q5UtkQ2ZL40eic2VKk7LKsv8WsVq0Dddfz9aQVAmqnAExKLux\nYY+Hd0263kpDiu/0yEiT4G/3RPhKAmtib08Muc5FPQfIjM/IpF0OydhKYLCPQhtQ\n+0L6xe7VreHsP/n9EoGQ/2hZty+D4k2myZ/ypZH00jSs4+0cVysLZGKbRp481nOn\nutYTuLXJ0VDcCFf3RMwNYDCkW9k160NOZIap3RGIftCo2KR12TlxIE0+McltbGQ=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "UFSC - Universidade Federal de Santa Catarina", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.ufsc.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.ufsc.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "marcio@npd.ufsc.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Marcio Clemes", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.hochschule-bc.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.hochschule-bc.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.hochschule-bc.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.hochschule-bc.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hochschule-bc.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rz1ads.fh-biberach.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hochschule-bc.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hochschule-bc.de,OU=Rechenzentrum,O=Hochschule Biberach,L=Biberach,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFlTCCBH2gAwIBAgIEEV0vSzANBgkqhkiG9w0BAQUFADCBtTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIQmliZXJh\nY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUgQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xHTAbBgNVBAMTFEhCQy1HbG9iYWwgQ0EgLSBHIDAxMSEwHwYJKoZI\nhvcNAQkBFhJwa2lAZmgtYmliZXJhY2guZGUwHhcNMTEwMTI0MTcwNzA4WhcNMTYw\nMTIzMTcwNzA4WjCBkjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0\ndGVtYmVyZzERMA8GA1UEBxMIQmliZXJhY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUg\nQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHTAbBgNVBAMTFGlkcC5o\nb2Noc2NodWxlLWJjLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nqtj8K4twdlFO6g3v+5yAWFmcQF2w3RB5dt6fUhF79dhb52jSWwqax/zhGjznGHsh\ncGa2ssx0Srbdd0q6B8pE4qj/6aj7Zwex/mUTZpn1ohvAxmtXhu8UorK42klm9NJV\nA/RSs1mNKqG1sMJIVVAxzJrQ0AcIfYVgkh5pY0tuzCWu2badGTdoiY5xzhy1jcGm\nzRZlWFUO/0iUlEPAZbIHbvqjDrEQ5I/O9AGEIoY2bS2ezEqIULPKXILdFLl/W5m6\n15ctpggBz3iIBZXMnmFNhWYsGGMwv+Q2poANbKlZFZBFsjwwa3DJ9YpNzJKyILgm\n16LqgL+fCGMGPOkvmLIgcwIDAQABo4IBzDCCAcgwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n8JgV2opFP3hcLzImHnukv6OGpjAfBgNVHSMEGDAWgBSREBR4GID92wzwllHKuEQz\n3ElITTAkBgNVHREEHTAbgRlzdHVldHpsZUBob2Noc2NodWxlLWJjLmRlMIGFBgNV\nHR8EfjB8MDygOqA4hjZodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2hiYy1nbG9iYWwt\nY2EvcHViL2NybC9jYWNybC5jcmwwPKA6oDiGNmh0dHA6Ly9jZHAyLnBjYS5kZm4u\nZGUvaGJjLWdsb2JhbC1jYS9wdWIvY3JsL2NhY3JsLmNybDCBoAYIKwYBBQUHAQEE\ngZMwgZAwRgYIKwYBBQUHMAKGOmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGJjLWds\nb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRgYIKwYBBQUHMAKGOmh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvaGJjLWdsb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2Vy\ndC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAE5WRkxDRsl5jqKwvJCgE4d223Q0n1Tm\n/6tcHlZRGF9U+xktoJbGW3RWMIEWlhO0fdRpF+5yNoYaCjWRsnb3cHT87RecdMCm\ndr2I3fqtuThgpyU+zfUJKfBBqBsp6bQzxxXqcDvnRuhs6AlFMs4s1TG7NyqAs91u\njqqXuLDDqLvZ/sYxFbSf1CXga/ccJPds6NVnMjQgE4bh3FawgFkOD/YWwXjTKbFC\nT7JWbpKEY0A7BSZxatAiCiRYlZSQdvAed4gcD2u5exbUehy9H53yaNX/3Kq3W5Zs\n+rz+tAL97HDBS6P/Dla1hVADcTSuIrFu7C4rJ92NHkT4Ol5261esM9s=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.hochschule-bc.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "hochschule-bc.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "rz1ads.fh-biberach.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.hochschule-bc.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.hochschule-bc.de,OU=Rechenzentrum,O=Hochschule Biberach,L=Biberach,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFlTCCBH2gAwIBAgIEEV0vSzANBgkqhkiG9w0BAQUFADCBtTELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzERMA8GA1UEBxMIQmliZXJh\nY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUgQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hl\nbnplbnRydW0xHTAbBgNVBAMTFEhCQy1HbG9iYWwgQ0EgLSBHIDAxMSEwHwYJKoZI\nhvcNAQkBFhJwa2lAZmgtYmliZXJhY2guZGUwHhcNMTEwMTI0MTcwNzA4WhcNMTYw\nMTIzMTcwNzA4WjCBkjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0\ndGVtYmVyZzERMA8GA1UEBxMIQmliZXJhY2gxHDAaBgNVBAoTE0hvY2hzY2h1bGUg\nQmliZXJhY2gxFjAUBgNVBAsTDVJlY2hlbnplbnRydW0xHTAbBgNVBAMTFGlkcC5o\nb2Noc2NodWxlLWJjLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\nqtj8K4twdlFO6g3v+5yAWFmcQF2w3RB5dt6fUhF79dhb52jSWwqax/zhGjznGHsh\ncGa2ssx0Srbdd0q6B8pE4qj/6aj7Zwex/mUTZpn1ohvAxmtXhu8UorK42klm9NJV\nA/RSs1mNKqG1sMJIVVAxzJrQ0AcIfYVgkh5pY0tuzCWu2badGTdoiY5xzhy1jcGm\nzRZlWFUO/0iUlEPAZbIHbvqjDrEQ5I/O9AGEIoY2bS2ezEqIULPKXILdFLl/W5m6\n15ctpggBz3iIBZXMnmFNhWYsGGMwv+Q2poANbKlZFZBFsjwwa3DJ9YpNzJKyILgm\n16LqgL+fCGMGPOkvmLIgcwIDAQABo4IBzDCCAcgwCQYDVR0TBAIwADALBgNVHQ8E\nBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBRP\n8JgV2opFP3hcLzImHnukv6OGpjAfBgNVHSMEGDAWgBSREBR4GID92wzwllHKuEQz\n3ElITTAkBgNVHREEHTAbgRlzdHVldHpsZUBob2Noc2NodWxlLWJjLmRlMIGFBgNV\nHR8EfjB8MDygOqA4hjZodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2hiYy1nbG9iYWwt\nY2EvcHViL2NybC9jYWNybC5jcmwwPKA6oDiGNmh0dHA6Ly9jZHAyLnBjYS5kZm4u\nZGUvaGJjLWdsb2JhbC1jYS9wdWIvY3JsL2NhY3JsLmNybDCBoAYIKwYBBQUHAQEE\ngZMwgZAwRgYIKwYBBQUHMAKGOmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvaGJjLWds\nb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwRgYIKwYBBQUHMAKGOmh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvaGJjLWdsb2JhbC1jYS9wdWIvY2FjZXJ0L2NhY2Vy\ndC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAE5WRkxDRsl5jqKwvJCgE4d223Q0n1Tm\n/6tcHlZRGF9U+xktoJbGW3RWMIEWlhO0fdRpF+5yNoYaCjWRsnb3cHT87RecdMCm\ndr2I3fqtuThgpyU+zfUJKfBBqBsp6bQzxxXqcDvnRuhs6AlFMs4s1TG7NyqAs91u\njqqXuLDDqLvZ/sYxFbSf1CXga/ccJPds6NVnMjQgE4bh3FawgFkOD/YWwXjTKbFC\nT7JWbpKEY0A7BSZxatAiCiRYlZSQdvAed4gcD2u5exbUehy9H53yaNX/3Kq3W5Zs\n+rz+tAL97HDBS6P/Dla1hVADcTSuIrFu7C4rJ92NHkT4Ol5261esM9s=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Hochschule Biberach", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Hochschule Biberach", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.hochschule-bc.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Roland", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "forderer@hochschule-bc.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Forderer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "DFN-AAI", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hotline@aai.dfn.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Support", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://registrera.hb.se/shibboleth", 
    {
      "entity_id": "https://registrera.hb.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "registrera.hb.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "vm-registrera.hb.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=registrera.hb.se,OU=GF,O=H\\C3\\B6gskolan i Bor\\C3\\A5s,C=SE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIECjCCAvKgAwIBAgIRAMRSDmNt6njEH0n9VYTNaVgwDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0wOTEyMTQwMDAwMDBaFw0xMjEyMTMyMzU5NTlaMFMxCzAJBgNV\nBAYTAlNFMRwwGgYDVQQKDBNIw7Znc2tvbGFuIGkgQm9yw6VzMQswCQYDVQQLEwJH\nRjEZMBcGA1UEAxMQcmVnaXN0cmVyYS5oYi5zZTCBnzANBgkqhkiG9w0BAQEFAAOB\njQAwgYkCgYEAyN72d/ptyFijjHr3r/6TzZUHYbBAxMBfLCLhBcTYUoSs1NmVfq4v\nj9Gg9o9p4YHNkciQ3IlG/gX6YpbhdVNVAwoer+NAAwv7kyh6pCPYs1/UbT2cNdt4\n+2pmVGYYvephTGdiPD/l6+eJ2MSLIjg1OPyLLIc55/QwckVZ+aNxG5UCAwEAAaOC\nAXgwggF0MB8GA1UdIwQYMBaAFAy9k2gM896ro0lrKzdXR+qQ47ntMB0GA1UdDgQW\nBBThMU05NRahK0xF+83OWb60YYywkDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/\nBAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwGAYDVR0gBBEwDzAN\nBgsrBgEEAbIxAQICHTA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnRjcy50\nZXJlbmEub3JnL1RFUkVOQVNTTENBLmNybDBtBggrBgEFBQcBAQRhMF8wNQYIKwYB\nBQUHMAKGKWh0dHA6Ly9jcnQudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3J0\nMCYGCCsGAQUFBzABhhpodHRwOi8vb2NzcC50Y3MudGVyZW5hLm9yZzAwBgNVHREE\nKTAnghByZWdpc3RyZXJhLmhiLnNlghN2bS1yZWdpc3RyZXJhLmhiLnNlMA0GCSqG\nSIb3DQEBBQUAA4IBAQCb7n3q9y9pWZoFLkQTfjkf+/CmXKP2KqLYRDutieeAN7HG\nm4odw7GslpKCcl7wkrRRGRAMj0SIbKP8sQoBfTebL1tIM6Yj+Tba2Ew+u0aGnXpv\nYuBPTLErr2fkkk/ZcY4JeqB3FTqes195SZF8WVtxJeI88dFMjK9kOLA5CK2EE/bd\ny+LBcpEC8uLx4GF6FJl5eQbnrR25A+VDqkxY+UtAVX/3m+XIeIg6n70LvnFTJmy+\nMbcotK0FqbwSIN7oyLWe5SjUSkrf/LAD/R3CXyGZvcGuUx3cX1ur7exlKMun6/lP\nNi1kp0+3QaewFNePHmM8yl2mPmQulTWmlzOZN9ue", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "registrera.hb.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "vm-registrera.hb.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=registrera.hb.se,OU=GF,O=H\\C3\\B6gskolan i Bor\\C3\\A5s,C=SE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIECjCCAvKgAwIBAgIRAMRSDmNt6njEH0n9VYTNaVgwDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0wOTEyMTQwMDAwMDBaFw0xMjEyMTMyMzU5NTlaMFMxCzAJBgNV\nBAYTAlNFMRwwGgYDVQQKDBNIw7Znc2tvbGFuIGkgQm9yw6VzMQswCQYDVQQLEwJH\nRjEZMBcGA1UEAxMQcmVnaXN0cmVyYS5oYi5zZTCBnzANBgkqhkiG9w0BAQEFAAOB\njQAwgYkCgYEAyN72d/ptyFijjHr3r/6TzZUHYbBAxMBfLCLhBcTYUoSs1NmVfq4v\nj9Gg9o9p4YHNkciQ3IlG/gX6YpbhdVNVAwoer+NAAwv7kyh6pCPYs1/UbT2cNdt4\n+2pmVGYYvephTGdiPD/l6+eJ2MSLIjg1OPyLLIc55/QwckVZ+aNxG5UCAwEAAaOC\nAXgwggF0MB8GA1UdIwQYMBaAFAy9k2gM896ro0lrKzdXR+qQ47ntMB0GA1UdDgQW\nBBThMU05NRahK0xF+83OWb60YYywkDAOBgNVHQ8BAf8EBAMCBaAwDAYDVR0TAQH/\nBAIwADAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwGAYDVR0gBBEwDzAN\nBgsrBgEEAbIxAQICHTA6BgNVHR8EMzAxMC+gLaArhilodHRwOi8vY3JsLnRjcy50\nZXJlbmEub3JnL1RFUkVOQVNTTENBLmNybDBtBggrBgEFBQcBAQRhMF8wNQYIKwYB\nBQUHMAKGKWh0dHA6Ly9jcnQudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3J0\nMCYGCCsGAQUFBzABhhpodHRwOi8vb2NzcC50Y3MudGVyZW5hLm9yZzAwBgNVHREE\nKTAnghByZWdpc3RyZXJhLmhiLnNlghN2bS1yZWdpc3RyZXJhLmhiLnNlMA0GCSqG\nSIb3DQEBBQUAA4IBAQCb7n3q9y9pWZoFLkQTfjkf+/CmXKP2KqLYRDutieeAN7HG\nm4odw7GslpKCcl7wkrRRGRAMj0SIbKP8sQoBfTebL1tIM6Yj+Tba2Ew+u0aGnXpv\nYuBPTLErr2fkkk/ZcY4JeqB3FTqes195SZF8WVtxJeI88dFMjK9kOLA5CK2EE/bd\ny+LBcpEC8uLx4GF6FJl5eQbnrR25A+VDqkxY+UtAVX/3m+XIeIg6n70LvnFTJmy+\nMbcotK0FqbwSIN7oyLWe5SjUSkrf/LAD/R3CXyGZvcGuUx3cX1ur7exlKMun6/lP\nNi1kp0+3QaewFNePHmM8yl2mPmQulTWmlzOZN9ue", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://registrera.hb.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/registrera.hb.se.xml"
      }
    }
  ], 
  [
    "https://akkatest.its.uu.se/Shibboleth", 
    {
      "entity_id": "https://akkatest.its.uu.se/Shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC8TCCAdmgAwIBAgIJAPevEDM/eL6HMA0GCSqGSIb3DQEBBQUAMBkxFzAVBgNV\nBAMTDnJhbWEuaXRzLnV1LnNlMB4XDTEyMDUwNDEzMzkxM1oXDTIyMDUwMjEzMzkx\nM1owGTEXMBUGA1UEAxMOcmFtYS5pdHMudXUuc2UwggEiMA0GCSqGSIb3DQEBAQUA\nA4IBDwAwggEKAoIBAQC/JIPualV+2/W+KqnkNM0zJbiDe/bjGyZqTdpGGNZ+Fdv5\nYWfdMAazx8Q6nebRroCAhzOFD2IiwmPVnhAIGxoT60oSvkLEuROWlpcVGYBWO2ob\nUCJhuf36fNuM+M0cvyfNsszGY/RN+alDkRO4q+qBot0ZCQtxFXEKPc3XU71saW8G\nB5rlQT9bUzaPxnFg/c3I4YsGsrutjFhd346XlWrdY+Yu+kgCroyKuG4fJdEQj+Dc\nzYtnf8bCrmQkymdlVCrqiyscRgy7RTM4o6O86y8K/XKY75LPyO5eW1PwSQmhZ81M\n5GOyiTTvxigchLjs/RjXvO831wOFzHCTQR9s2r3hAgMBAAGjPDA6MBkGA1UdEQQS\nMBCCDnJhbWEuaXRzLnV1LnNlMB0GA1UdDgQWBBRq768tUOrPoWPR73il6QUeu7as\nZDANBgkqhkiG9w0BAQUFAAOCAQEAAi9lQbbCd7UgMc6r1Ds6uBbz2mKwaGUOLE/d\n8ZM3aeE0QLI83yX5pF1cKNar9XNAGklsDtMc64/7+tmuimH7hzh5wbmXtZROlvAq\nA9sCefzcJtjKSXvg1N613W+03ZrUzmL0V9EtKEfEDKnuTqUzLMP112eBwZavOTmR\nqtKsyINwsUmnjBv5DayfcCzfUFmHyBlhe+hAMacex0k2Iy/jozNN5ciwvR4OlHwI\nblxtYGVB1uGczqhd4Vn/jIHHcW5mx6oamuRXMcuRoAIJxw8aL7s+0Gm6vNNbLIpt\n+9Wlbs4JNpKbUADka9XZmieDYfcL+QjBqY7yhrIUnv/1GrLXTA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akkatest.its.uu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akkatest.its.uu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akkatest.its.uu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://akkatest.its.uu.se/Shibboleth.sso/SAML/POST"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/akkatest.its.uu.se.xml"
      }
    }
  ], 
  [
    "https://converis.info/shibboleth", 
    {
      "entity_id": "https://converis.info/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://converis.info/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://converis.info/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://converis.info/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://converis.info/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://converis.info/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://converis.info/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://converis.info/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://converis.info/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://converis.info/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://converis.info/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "converis.info", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=converis@avedas.com,CN=converis.info,O=Avedas AG,L=Kar,ST=Bad,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIICaTCCAdICCQCLAbSDwUzlcTANBgkqhkiG9w0BAQUFADB5MQswCQYDVQQGEwJE\nRTEMMAoGA1UECBMDQmFkMQwwCgYDVQQHEwNLYXIxEjAQBgNVBAoTCUF2ZWRhcyBB\nRzEWMBQGA1UEAxMNY29udmVyaXMuaW5mbzEiMCAGCSqGSIb3DQEJARYTY29udmVy\naXNAYXZlZGFzLmNvbTAeFw0wOTA2MzAxMzI3MzlaFw0xMDA2MzAxMzI3MzlaMHkx\nCzAJBgNVBAYTAkRFMQwwCgYDVQQIEwNCYWQxDDAKBgNVBAcTA0thcjESMBAGA1UE\nChMJQXZlZGFzIEFHMRYwFAYDVQQDEw1jb252ZXJpcy5pbmZvMSIwIAYJKoZIhvcN\nAQkBFhNjb252ZXJpc0BhdmVkYXMuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB\niQKBgQC0AXsGnmd4Ue0YGctAeKBjrRxENIszZj2NjzEZ5hjGXwsvgHExBYejynR4\nx0YRlF7kVg+hkZ5jIK+t3iIDLmUkRBlMZSbkQ0EYUBHvLXECtxggRZFoFEMssB20\nDm4F2I0bK51/ip6KZpltX81Zo44RpRjconBMc0FUZwjNYM2JUwIDAQABMA0GCSqG\nSIb3DQEBBQUAA4GBAIs+aQEHMnmVo8jm8NpzVYpPCN3/27F5IGtS0xgduAttJnYX\nlXi4upRjGaljdEqtTicQzpuZVZTnyik5KscVuSU4rtI5u1b7ybf6oL1xKiqkN7m1\nu7Xr9dYOqLXYBTCx/0NY5C+RF+dq2CYmY8fL/TILzmVGaZhXKzEYKIAPiKv3", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "converis.info", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=converis@avedas.com,CN=converis.info,O=Avedas AG,L=Kar,ST=Bad,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIICaTCCAdICCQCLAbSDwUzlcTANBgkqhkiG9w0BAQUFADB5MQswCQYDVQQGEwJE\nRTEMMAoGA1UECBMDQmFkMQwwCgYDVQQHEwNLYXIxEjAQBgNVBAoTCUF2ZWRhcyBB\nRzEWMBQGA1UEAxMNY29udmVyaXMuaW5mbzEiMCAGCSqGSIb3DQEJARYTY29udmVy\naXNAYXZlZGFzLmNvbTAeFw0wOTA2MzAxMzI3MzlaFw0xMDA2MzAxMzI3MzlaMHkx\nCzAJBgNVBAYTAkRFMQwwCgYDVQQIEwNCYWQxDDAKBgNVBAcTA0thcjESMBAGA1UE\nChMJQXZlZGFzIEFHMRYwFAYDVQQDEw1jb252ZXJpcy5pbmZvMSIwIAYJKoZIhvcN\nAQkBFhNjb252ZXJpc0BhdmVkYXMuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB\niQKBgQC0AXsGnmd4Ue0YGctAeKBjrRxENIszZj2NjzEZ5hjGXwsvgHExBYejynR4\nx0YRlF7kVg+hkZ5jIK+t3iIDLmUkRBlMZSbkQ0EYUBHvLXECtxggRZFoFEMssB20\nDm4F2I0bK51/ip6KZpltX81Zo44RpRjconBMc0FUZwjNYM2JUwIDAQABMA0GCSqG\nSIb3DQEBBQUAA4GBAIs+aQEHMnmVo8jm8NpzVYpPCN3/27F5IGtS0xgduAttJnYX\nlXi4upRjGaljdEqtTicQzpuZVZTnyik5KscVuSU4rtI5u1b7ybf6oL1xKiqkN7m1\nu7Xr9dYOqLXYBTCx/0NY5C+RF+dq2CYmY8fL/TILzmVGaZhXKzEYKIAPiKv3", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://converis.info/Shibboleth.sso/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://converis.info/Shibboleth.sso/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://converis.info/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://converis.info/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/converis.info.xml"
      }
    }
  ], 
  [
    "https://uraccess.se/shibboleth-sp", 
    {
      "entity_id": "https://uraccess.se/shibboleth-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/uraccess.se.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "attribute": [
              {
                "attribute_value": [
                  {
                    "text": "http://www.swamid.se/category/research-and-education", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }, 
                  {
                    "text": "http://www.swamid.se/category/eu-adequate-protection", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                "name": "http://macedir.org/entity-category"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:attribute&EntityAttributes"
          }
        ]
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://uraccess.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://uraccess.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://uraccess.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://uraccess.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uraccess.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uraccess.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uraccess.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uraccess.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uraccess.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://uraccess.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://uraccess.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "vm-uraccess-01.hig.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=vm-uraccess-01.hig.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDBjCCAe6gAwIBAgIJAPUsAkPRkfQcMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFXZtLXVyYWNjZXNzLTAxLmhpZy5zZTAeFw0xMjEyMjgxNDA2NDZaFw0yMjEy\nMjYxNDA2NDZaMCAxHjAcBgNVBAMTFXZtLXVyYWNjZXNzLTAxLmhpZy5zZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALZi4a5TDF3axO1a4SVbIV/yMJuh\nFA5dgRAbepHRugRnkeBrYuJZD5Nw9EDFrZzJBWUTuPwxIngZfsAUtdTKnvzjDtks\n1Zp7ZXl5EqayQ0pM5DMoTf2mJOXaduB1oqR6BJQVK1zgm7/pSeYmp4kwWsChBXKs\nE+qF26/ioxCQZ9lYm0hZB6gaDSIANr9hd3JAwWkDD1iGs3NErfS09TEmzYjxeRlf\nvn36fEm9yO1Kc0ZLfQNOSF240+QN7bxISnPAH+V/Bhxes7vXsMa25LUhkTCxuZte\nuFdeucgrS9B0kdRA1anuWUdfZLA2Zc/RQBsy6A+IHfv9n6z1jkLidJ+M8KkCAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVdm0tdXJhY2Nlc3MtMDEuaGlnLnNlMB0GA1UdDgQW\nBBR4inZYnfGemGRVjiQcUPD0tgLCtTANBgkqhkiG9w0BAQUFAAOCAQEAjd8rcbPm\n1SYlzcKAjyBmxk4rGrw/xC34Q8wPdjSkCWuLSEHnHWZ8zligSG18NYnIAnF2HNcZ\nxDlKdNzUDfTLl6DO5Sj/14cp3KRCEguBBpA5mB1B0V1utNxDSSqmSETMIDfevDG+\nbHjvO72YCMTVdrTETXcEqQief7YOl23gNcA+UFBpJVy32Z1Ys2f/TDUO4zA7EIxO\n5wOyJXko37s+7C2zwiv58MNt4kXp7wfu8yLdwdUx26BSG/r4b6eFl3FOHM/4B/tO\nu+7JsZjXP5N3EUSAg15/2ohUY/eiLIpt2Rwnu4uscUN6P9hW5dL2ma0ooT9rrqxy\nKZxzSTvKUlilgw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "vm-uraccess-01.hig.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=vm-uraccess-01.hig.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDBjCCAe6gAwIBAgIJAPUsAkPRkfQcMA0GCSqGSIb3DQEBBQUAMCAxHjAcBgNV\nBAMTFXZtLXVyYWNjZXNzLTAxLmhpZy5zZTAeFw0xMjEyMjgxNDA2NDZaFw0yMjEy\nMjYxNDA2NDZaMCAxHjAcBgNVBAMTFXZtLXVyYWNjZXNzLTAxLmhpZy5zZTCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALZi4a5TDF3axO1a4SVbIV/yMJuh\nFA5dgRAbepHRugRnkeBrYuJZD5Nw9EDFrZzJBWUTuPwxIngZfsAUtdTKnvzjDtks\n1Zp7ZXl5EqayQ0pM5DMoTf2mJOXaduB1oqR6BJQVK1zgm7/pSeYmp4kwWsChBXKs\nE+qF26/ioxCQZ9lYm0hZB6gaDSIANr9hd3JAwWkDD1iGs3NErfS09TEmzYjxeRlf\nvn36fEm9yO1Kc0ZLfQNOSF240+QN7bxISnPAH+V/Bhxes7vXsMa25LUhkTCxuZte\nuFdeucgrS9B0kdRA1anuWUdfZLA2Zc/RQBsy6A+IHfv9n6z1jkLidJ+M8KkCAwEA\nAaNDMEEwIAYDVR0RBBkwF4IVdm0tdXJhY2Nlc3MtMDEuaGlnLnNlMB0GA1UdDgQW\nBBR4inZYnfGemGRVjiQcUPD0tgLCtTANBgkqhkiG9w0BAQUFAAOCAQEAjd8rcbPm\n1SYlzcKAjyBmxk4rGrw/xC34Q8wPdjSkCWuLSEHnHWZ8zligSG18NYnIAnF2HNcZ\nxDlKdNzUDfTLl6DO5Sj/14cp3KRCEguBBpA5mB1B0V1utNxDSSqmSETMIDfevDG+\nbHjvO72YCMTVdrTETXcEqQief7YOl23gNcA+UFBpJVy32Z1Ys2f/TDUO4zA7EIxO\n5wOyJXko37s+7C2zwiv58MNt4kXp7wfu8yLdwdUx26BSG/r4b6eFl3FOHM/4B/tO\nu+7JsZjXP5N3EUSAg15/2ohUY/eiLIpt2Rwnu4uscUN6P9hW5dL2ma0ooT9rrqxy\nKZxzSTvKUlilgw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://uraccess.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://uraccess.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://uraccess.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://uraccess.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://uraccess.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "id": "_3346fb92a8b1be84015d4cd418443d89"
    }
  ], 
  [
    "https://its-pd0030.ad.umu.se/shibboleth", 
    {
      "entity_id": "https://its-pd0030.ad.umu.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "its-pd0030.ad.umu.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "emailAddress=peter.holm@adm.umu.se,CN=its-pd0030.ad.umu.se,OU=ITS,O=ITS,L=Umea,ST=Vasterbotten,C=SE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIID/TCCAuWgAwIBAgIJANnuq9lnXo3DMA0GCSqGSIb3DQEBBQUAMIGUMQswCQYD\nVQQGEwJTRTEVMBMGA1UECAwMVmFzdGVyYm90dGVuMQ0wCwYDVQQHDARVbWVhMQww\nCgYDVQQKDANJVFMxDDAKBgNVBAsMA0lUUzEdMBsGA1UEAwwUaXRzLXBkMDAzMC5h\nZC51bXUuc2UxJDAiBgkqhkiG9w0BCQEWFXBldGVyLmhvbG1AYWRtLnVtdS5zZTAe\nFw0xMjAzMDUxNTE2MjBaFw0xNTAxMTcxNTE2MjBaMIGUMQswCQYDVQQGEwJTRTEV\nMBMGA1UECAwMVmFzdGVyYm90dGVuMQ0wCwYDVQQHDARVbWVhMQwwCgYDVQQKDANJ\nVFMxDDAKBgNVBAsMA0lUUzEdMBsGA1UEAwwUaXRzLXBkMDAzMC5hZC51bXUuc2Ux\nJDAiBgkqhkiG9w0BCQEWFXBldGVyLmhvbG1AYWRtLnVtdS5zZTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAMQc2UGad/hBaY4f4DpqAqlWEPd4kLXfa5pQ\n8BxNDW7CdHa1PZywE+x3qrEnc7ee5YKi8MljzOU3y5cnmSRuIzuTyjl2tf4/p1Z6\nnE7MvGnuqS69XK8bytAS6J2pNCBmRcKahn53o6pIAgq9BeFKa56ao3KJWyzE6Rxl\nrlgO4KnbBDERb0deGkfRZnVdRTBNNH61L9N1Qt32uKWnW8SnWk7+0jOCZTv+xbn+\nmlP11urE9Pzard/QR+y3VscQTGSjOlcQdf/E/ADcKQKXFia6FVCPXKJi3aMrn8Zz\nUWGI+qbJ6BorsassnZsriv0CurcYIEX/NkfW2FZetgCdX0pzmj8CAwEAAaNQME4w\nHQYDVR0OBBYEFIibejVm82LsZawokaVHs5NcwRlWMB8GA1UdIwQYMBaAFIibejVm\n82LsZawokaVHs5NcwRlWMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEB\nAFkwpLwvpKnotAOWxSx+ilAmv/DHA9SrTAGYQQT1P1qjpmwVAOCUHODx9iN0CBeM\ngVsjTRdImIYlo+LrwauT81kwf80XmLte4JqagelFcPEA5TmbktPKXHv1tCBje/uJ\n8nZ2o8eOZ5wKv5zp8Xxn2Imchg9DAtLzbaTv53JtPtqI+eJik2tBmfklvK55ajLO\n9ubWdsA44GhSnvWyIaTGhXfzoyQ8ZJ6idJDNOwA5u71tAmmUmkOoF5d0+Yj+J43R\n+J9Yt3EiCcvGwQ14r54USZEBGw+rGix8uOMh0fZZzE0yLpMhz7+SJ07lLAFBmG+T\nOIILi2tdLnboWi1QOOeX9+Q=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://its-pd0030.ad.umu.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/its-pd0030.ad.umu.se.xml"
      }
    }
  ], 
  [
    "https://cloudidp1.canarie.ca/idp/shibboleth", 
    {
      "entity_id": "https://cloudidp1.canarie.ca/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/cloudidp1.canarie.ca.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "error_url": "https://cloudidp1.canarie.ca/identity/feedback.htm", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cloudidp1.canarie.ca/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:2.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cloudidp1.canarie.ca/idp/profile/SAML2/Unsolicited/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cloudidp1.canarie.ca/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cloudidp1.canarie.ca/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://cloudidp1.canarie.ca/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "cloudidp1.canarie.ca", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "fr", 
                    "text": "http://www.canarie.ca/fr/a-propos/quinoussommes", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "en", 
                    "text": "http://www.canarie.ca/en/about/aboutus", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "fr", 
                    "text": "CANARIE Fournisseur nuagique d'identit\u00e9", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "en", 
                    "text": "CANARIE Cloud Identity Provider", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "CANARIE - CAF Canada's Advanced Research and Innovation Network", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "fr", 
                    "text": "CANARIE - CAF-FCA Le r\u00e9seau \u00e9volu\u00e9 de recherche et d'innovation du Canada", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints", 
                "domain_hint": [
                  {
                    "text": "canarie.ca", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DomainHint"
                  }
                ]
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cloudidp1.canarie.ca:9443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://cloudidp1.canarie.ca:9443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDSjCCAjICCQCmkqQ0nApLQzANBgkqhkiG9w0BAQUFADBnMR0wGwYDVQQDDBRj\nbG91ZGlkcDEuY2FuYXJpZS5jYTEbMBkGA1UECgwSQ2FuYXJpZSBGZWRlcmF0aW9u\nMQswCQYDVQQGEwJDQTELMAkGA1UECAwCT04xDzANBgNVBAcMBk90dGF3YTAeFw0x\nMzAyMjYxMDM2MTJaFw0xNDAyMjYxMDM2MTJaMGcxHTAbBgNVBAMMFGNsb3VkaWRw\nMS5jYW5hcmllLmNhMRswGQYDVQQKDBJDYW5hcmllIEZlZGVyYXRpb24xCzAJBgNV\nBAYTAkNBMQswCQYDVQQIDAJPTjEPMA0GA1UEBwwGT3R0YXdhMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoQbo4L3ZJ29BmswAzMZNQXzpvsdUR8laZaDn\nq1UjYN0XmUC4zE9QWc7LYxPjubkH9SzRkTVTYMVSCFo0Ja40hXIQBSQ+oE9Em2BN\nHV2qsBHvynbnj3/8bcbG0T9GCdCIobRy2pRcpGaUvkiDrilnwKG7r3alGTeiPRwI\n7zD+Hx32+NaAb4OrdxWwKrRyagWuTdIboR+FkS03St0Pc/Wa5Y5ZsyWVETtVEO0Z\n0MC7bsZWy34Wz0+7TQvJ3YUw3+PVf36AgwcxKkHWIaf1g8NRCJ9Vg3SnGT6Ecbo1\nkV+P/0qjtHonVwp8lQb6nD5OcnWsoxRArsrRwZ/rGGQXXVyYeQIDAQABMA0GCSqG\nSIb3DQEBBQUAA4IBAQA8BuR3/QCpFRsYs6wIWi5N4naU3MXdP7Rbg+GzEnJD9j7d\nltHmQoFIHOpgLmlYpiJjhwJvY4FE++2FCxeYCzGDcoZJnavs5ZiYjjw+AdRlyG7D\nVkkjnmRW7d+iJIMH2olC5O57wwxSQb1FON9KU2c7EjbhrWUJx4RfJy1O8jPMA0XC\nKL4ynk0Gqiuf5X4ll8scRVv2sWP7Zh8a5O09Q6Teghc8VBlitkhVl7Z9Ylle6IHt\n/GajqsEZjDVbsn3fjdIFZJSuUq/q8+TpRzBqOMB4yFAXrGKXcrcQwR721Ol+SDOj\nHOB2BJCb3Ue9NzqIlgXpyc2LpPt2RRlYaJm45zod", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.canarie.ca/templates/services/docs/CAF_join_en.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://www.canarie.ca", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2013-03-25T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cloudidp1.canarie.ca:9443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://cloudidp1.canarie.ca:9443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "cloudidp1.canarie.ca", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDSjCCAjICCQCmkqQ0nApLQzANBgkqhkiG9w0BAQUFADBnMR0wGwYDVQQDDBRj\nbG91ZGlkcDEuY2FuYXJpZS5jYTEbMBkGA1UECgwSQ2FuYXJpZSBGZWRlcmF0aW9u\nMQswCQYDVQQGEwJDQTELMAkGA1UECAwCT04xDzANBgNVBAcMBk90dGF3YTAeFw0x\nMzAyMjYxMDM2MTJaFw0xNDAyMjYxMDM2MTJaMGcxHTAbBgNVBAMMFGNsb3VkaWRw\nMS5jYW5hcmllLmNhMRswGQYDVQQKDBJDYW5hcmllIEZlZGVyYXRpb24xCzAJBgNV\nBAYTAkNBMQswCQYDVQQIDAJPTjEPMA0GA1UEBwwGT3R0YXdhMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoQbo4L3ZJ29BmswAzMZNQXzpvsdUR8laZaDn\nq1UjYN0XmUC4zE9QWc7LYxPjubkH9SzRkTVTYMVSCFo0Ja40hXIQBSQ+oE9Em2BN\nHV2qsBHvynbnj3/8bcbG0T9GCdCIobRy2pRcpGaUvkiDrilnwKG7r3alGTeiPRwI\n7zD+Hx32+NaAb4OrdxWwKrRyagWuTdIboR+FkS03St0Pc/Wa5Y5ZsyWVETtVEO0Z\n0MC7bsZWy34Wz0+7TQvJ3YUw3+PVf36AgwcxKkHWIaf1g8NRCJ9Vg3SnGT6Ecbo1\nkV+P/0qjtHonVwp8lQb6nD5OcnWsoxRArsrRwZ/rGGQXXVyYeQIDAQABMA0GCSqG\nSIb3DQEBBQUAA4IBAQA8BuR3/QCpFRsYs6wIWi5N4naU3MXdP7Rbg+GzEnJD9j7d\nltHmQoFIHOpgLmlYpiJjhwJvY4FE++2FCxeYCzGDcoZJnavs5ZiYjjw+AdRlyG7D\nVkkjnmRW7d+iJIMH2olC5O57wwxSQb1FON9KU2c7EjbhrWUJx4RfJy1O8jPMA0XC\nKL4ynk0Gqiuf5X4ll8scRVv2sWP7Zh8a5O09Q6Teghc8VBlitkhVl7Z9Ylle6IHt\n/GajqsEZjDVbsn3fjdIFZJSuUq/q8+TpRzBqOMB4yFAXrGKXcrcQwR721Ol+SDOj\nHOB2BJCb3Ue9NzqIlgXpyc2LpPt2RRlYaJm45zod", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "CANARIE", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "fr", 
            "text": "CANARIE", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "CANARIE - CAF Cloud IdP", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "fr", 
            "text": "CANARIE - CAF-FCA - Fournisseur nuagique d'identit\u00e9 - Le r\u00e9seau \u00e9volu\u00e9 de recherche et d'innovation du Canada", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.canarie.ca/en/about/aboutus", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "fr", 
            "text": "http://www.canarie.ca/fr/a-propos/quinoussommes", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "noc@canarie.ca", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Network Operations Center", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://sp.kau.se/shibboleth", 
    {
      "id": "_bfc65d391837d34b486a08045cce1cfca197d45e", 
      "entity_id": "https://sp.kau.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.kau.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.kau.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.kau.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.kau.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.kau.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://sp.kau.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.kau.se/Shibboleth.sso/Login"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://sp.kau.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "sp.kau.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=sp.kau.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIC4jCCAcqgAwIBAgIJAK8+Q8SJp9cxMA0GCSqGSIb3DQEBBQUAMBQxEjAQBgNV\nBAMTCXNwLmthdS5zZTAeFw0xMTA1MDYxMzUxMzBaFw0yMTA1MDMxMzUxMzBaMBQx\nEjAQBgNVBAMTCXNwLmthdS5zZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAOOdtYpLS733ksNrv8cVKtY8PCkrL8sa12dMH/Lp2Sm+eqNkJzwbmKPJm6Iu\nrp+Psc/bs767KNqDFRKi+s8iHuKIDCQnkliScR0w0wHzSiHMqEVo3OmU4hYxyYia\n7b3GNY9QYgwbalIuXvIoEVtSP6+19bnreeq0HbR+xCVOnA0EWSJHbIxIcEs1sH3n\nWVtgW5TTJqcasNp9FRtBYgUu5m6tbBZRzEpv2vjgSnhB+D67E6gfUIllWy7EoBFf\nNKtvN6KXr+Md44HanVMg6O+UOLeXY2+niXlP4sVXytCjkXMkZzBnOarPKkEa1yaP\nyyEV1FIoEVJRbQLcYHzhtVX/D+UCAwEAAaM3MDUwFAYDVR0RBA0wC4IJc3Aua2F1\nLnNlMB0GA1UdDgQWBBTDV+sbuDL/6+3K3mKMQvA4B/ctdzANBgkqhkiG9w0BAQUF\nAAOCAQEAKWQPKSkdt82pOnMqFfK07Tyx0tvH04m7TKJKQzL+FcXe4uzv2O1D9Hmg\n9SOoAxvG62KlFlFPkqjEUAuYxEfMWhrftdcWAR3VRu4vBO3QXRxvSuB2lLE487NE\nIWfQbZU6cfz+C8OondMuTtEChkvc5WJAd1HYdUzF0eRSSdKUgJmT4j9fUX0USS3E\noVtdy2lFcEQT6i7/0v8wrxndGmfGHi6vkiVUvLitX1gdUxx/egzZ9vq+uWa/FxU7\nJyw22KeyhvX+Ph1pO0iJh3yjDwSbVRDzMN5GU+aPBpeUVUxhYF3CTP4gh8rUAPJC\nmyMZEHsgIBf3jkmE9uQfRGeQLiSxfg==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://sp.kau.se/Shibboleth.sso/Artifact/SOAP"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/sp.kau.se.xml"
      }
    }
  ], 
  [
    "https://ufal-point.mff.cuni.cz/shibboleth/eduid/sp", 
    {
      "entity_id": "https://ufal-point.mff.cuni.cz/shibboleth/eduid/sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/ufal-point.mff.cuni.cz.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "en", 
                "text": "http://www.eduid.cz/wiki/_media/en/eduid/policy/policy_eduid_en-1_1.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }, 
              {
                "lang": "cs", 
                "text": "http://www.eduid.cz/wiki/_media/eduid/policy/policy_eduid_cz-1_1-3.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://www.eduid.cz/"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "Institute of Formal and Applied Linguistics, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "cs", 
            "text": "\u00dastav form\u00e1ln\u00ed a aplikovan\u00e9 lingvistiky, Matematicko-fyzik\u00e1ln\u00ed fakulta, Univerzita Karlova v Praze", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "Institute of Formal and Applied Linguistics, Faculty of Mathematics and Physics, Charles University in Prague", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "cs", 
            "text": "\u00daFAL MFF UK", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://ufal.mff.cuni.cz/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "cs", 
            "text": "http://ufal.mff.cuni.cz/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_description": [
                {
                  "lang": "en", 
                  "text": "Repository of LINDAT-Clarin project at Institute of Formal and Applied Linguistics, Faculty of Mathematics and Physics, Charles University in Prague", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "requested_attribute": [
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonPrincipalName"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:mail"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:cn"
                }, 
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "eduPersonTargetedID", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.10"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:givenName"
                }, 
                {
                  "friendly_name": "givenName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.42"
                }, 
                {
                  "friendly_name": "surname", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:sn"
                }, 
                {
                  "friendly_name": "surname", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }, 
                {
                  "friendly_name": "eduPersonEntitlement", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:mace:shibboleth:1.0:attributeNamespace:uri", 
                  "name": "urn:mace:dir:attribute-def:eduPersonEntitlement"
                }, 
                {
                  "friendly_name": "eduPersonEntitlement", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.7"
                }
              ], 
              "service_name": [
                {
                  "lang": "en", 
                  "text": "LINDAT-Clarin repository", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ]
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://ufal.mff.cuni.cz/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "http://ufal.mff.cuni.cz/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "LINDAT-Clarin repository", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "Repozit\u00e1\u0159 LINDAT-Clarin", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "Repository of LINDAT-Clarin project at Institute of Formal and Applied Linguistics, Faculty of Mathematics and Physics, Charles University in Prague", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "cs", 
                    "text": "Repozit\u00e1\u0159 projektu LINDAT-Clarin \u00dastavu form\u00e1ln\u00ed a aplikovan\u00e9 lingvistiky Matematicko-fyzik\u00e1ln\u00ed fakulty Univerzity Karlovy v Praze", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }, 
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/DS"
              }, 
              {
                "index": "2", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/Login"
              }
            ]
          }, 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "authn_requests_signed": "1", 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://ufal-point.mff.cuni.cz/Shibboleth.sso/NIM/Artifact"
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "Active", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }, 
                  {
                    "text": "ufal-point.mff.cuni.cz", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=ufal-point.mff.cuni.cz,O=Charles University in Prague,C=CZ", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIEgTCCA2mgAwIBAgIRANAZM0fxIWg+DEEhaZlreVowDQYJKoZIhvcNAQEFBQAw\nNjELMAkGA1UEBhMCTkwxDzANBgNVBAoTBlRFUkVOQTEWMBQGA1UEAxMNVEVSRU5B\nIFNTTCBDQTAeFw0xMjEwMjQwMDAwMDBaFw0xNTEwMjQyMzU5NTlaMFUxCzAJBgNV\nBAYTAkNaMSUwIwYDVQQKExxDaGFybGVzIFVuaXZlcnNpdHkgaW4gUHJhZ3VlMR8w\nHQYDVQQDExZ1ZmFsLXBvaW50Lm1mZi5jdW5pLmN6MIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAz4nCZa/xBh1ebd2+99GEqRMSqSkCEVfFi4Tndz6v87Iv\nZMvLY40OJg3lIEzngOz8tnn/ft6xcLxGwr+IbY6raHT08Xu8lQMd8Rj8Gmdi3Ov3\nXuCgjVpAID+GGfNkahzxebWORNfHyqEGSx2oFgRe8HD9BbT8mqheBPF8FIy6mYvs\n495IEkQVc0BvPvTwqEw+qOHKBX+AWQQIHDJDQQnjoteXplHugOFDJiJYH0T/80u3\nDO7h6oyiLlnyDywOVCQdiJPXNOtPMyM9rMT3Vw9SO4iIaMUkF5EafFFdEPLsi+FO\n2Z3r7pBxv1/LkK9AWuzAYSnjK/szHym25FWroxJZOwIDAQABo4IBaTCCAWUwHwYD\nVR0jBBgwFoAUDL2TaAzz3qujSWsrN1dH6pDjue0wHQYDVR0OBBYEFKKMnXN92GaN\n5uyL8cZdchPl9NpQMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1Ud\nJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAYBgNVHSAEETAPMA0GCysGAQQBsjEB\nAgIdMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcv\nVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0\ncDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUH\nMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMCEGA1UdEQQaMBiCFnVmYWwt\ncG9pbnQubWZmLmN1bmkuY3owDQYJKoZIhvcNAQEFBQADggEBAKWQZsd0zZBi+hz6\n3LBx49MOoCXkpUkIdqecMhz0bpIhC+2Q3Uxp97lpfB/9CIMoI5tq+PRXDXQt2D6A\nfk90Maa8HYp1OQagBlY9jhs4ImbPbsHM5Aa3f4ycxhXs+hecaJBD4WiaxeWpOWes\nk5Q+FdJCZoPqHRD2chNwhBErztJgujEarVtMBCUpCEpy5lwgFFFc2oekH8CkhWLw\nsv6GENdYGamg5HfRAq57+mGW3FUnox3gkqTWDuVzOaMfDlHvfqRVtC7n4mhHVAqz\nadGmTo4VvqYQsi0gVzrts5HDZAQBI13mpxua74rU8XyluKEyjS4gkVXLnlRjwXeF\nIhAZYQU=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ], 
      "contact_person": [
        {
          "given_name": {
            "text": "Pavel", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "stranak@ufal.mff.cuni.cz", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Stra\u0148\u00e1k", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://blblogin.blb-karlsruhe.de/idp/shibboleth", 
    {
      "entity_id": "https://blblogin.blb-karlsruhe.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/blblogin.blb-karlsruhe.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://blblogin.blb-karlsruhe.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://blblogin.blb-karlsruhe.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "blblogin.blb-karlsruhe.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "blblogin.blb-karlsruhe.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=blblogin.blb-karlsruhe.de,O=Badische Landesbibliothek,L=Karlsruhe,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFpDCCBIygAwIBAgIEDaIezzANBgkqhkiG9w0BAQUFADCBuDELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNy\ndWhlMSIwIAYDVQQKExlCYWRpc2NoZSBMYW5kZXNiaWJsaW90aGVrMRUwEwYDVQQL\nEwxJVC1BYnRlaWx1bmcxGTAXBgNVBAMTEEJMQiBLYXJsc3J1aGUgQ0ExIjAgBgkq\nhkiG9w0BCQEWE2NhQGJsYi1rYXJsc3J1aGUuZGUwHhcNMDkwMTMwMDY0MjA4WhcN\nMTQwMTI5MDY0MjA4WjCBhjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1\nZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNydWhlMSIwIAYDVQQKExlCYWRpc2No\nZSBMYW5kZXNiaWJsaW90aGVrMSIwIAYDVQQDExlibGJsb2dpbi5ibGIta2FybHNy\ndWhlLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwK5CwhRlyfdY\nd7yUxHWp7OOLBsbb3iJZgABVoTPwwIxo09s6aoWJEPkcQonDYwruQicUmLNpiUs8\njZcL7D0CRJrVGt1KRnoKQHFVoKlOLE21vxwyFDapQN9BZIOOE9tbE9+zcvkefrRZ\nIWz5Xifz6MRzQWEeXl34c5XPCYA7NQmIwwSDhMRDHY7AU3ODNeBmZQPNhNFQ65v/\nNmuuc5KDpSTVZ60Tw+qsYL2uwvFVltTnTMPxtEaKn6MF7ha3DctAUCD9LS3vcQX9\n1z8RA6Pf7F5mKqfxOxQdyfaTUM8+AC6msg6SleoAH3dv/z1V0WUufOyQxE+KZOkw\nHiq3R/F8bwIDAQABo4IB5DCCAeAwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBS+tVT4orbmPPBd\nBE0bI612jtuvjzAfBgNVHSMEGDAWgBTYEu7/qoIRCVQnKWmkaRu3leqNWjCBpQYD\nVR0fBIGdMIGaMEugSaBHhkVodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2JhZGlzY2hl\nLWxhbmRlc2JpYmxpb3RoZWstY2EvcHViL2NybC9jYWNybC5jcmwwS6BJoEeGRWh0\ndHA6Ly9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1j\nYS9wdWIvY3JsL2NhY3JsLmNybDCBvgYIKwYBBQUHAQEEgbEwga4wVQYIKwYBBQUH\nMAKGSWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlv\ndGhlay1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwVQYIKwYBBQUHMAKGSWh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1jYS9w\ndWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAEtEg8O8PON8\n4oNM1as89QeDwAAsqyH2yfo4GRKLTCmAryPi8QC635YlgG7xvqz+CgS3znz3wAJC\nkNoQhdh3+ARk6oF4wQ/OxPhMq7i/Pmx0uUInPqfPTIz306sEeuksIvsBz2QAZXkS\nfirdXwi9tidcOvxTZYL5J+KscKVDWhS4zEEeF8/oT3bvBFQQv1MdR8Dymn+axGPS\nQm1Z19FEwxKD1Da80qM+vlFKdFm6kf9ANjGEoxU3+nS+SEDolRSvKbD45xtEXDm2\nOecY2Vyft4fthAti2y+7mMkBYZdKXvS8yhL0QJVTYmY/Zh28JInYcQ9dnvrMynTd\nQ1O4HKVwCF4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "blblogin.blb-karlsruhe.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=blblogin.blb-karlsruhe.de,O=Badische Landesbibliothek,L=Karlsruhe,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFpDCCBIygAwIBAgIEDaIezzANBgkqhkiG9w0BAQUFADCBuDELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNy\ndWhlMSIwIAYDVQQKExlCYWRpc2NoZSBMYW5kZXNiaWJsaW90aGVrMRUwEwYDVQQL\nEwxJVC1BYnRlaWx1bmcxGTAXBgNVBAMTEEJMQiBLYXJsc3J1aGUgQ0ExIjAgBgkq\nhkiG9w0BCQEWE2NhQGJsYi1rYXJsc3J1aGUuZGUwHhcNMDkwMTMwMDY0MjA4WhcN\nMTQwMTI5MDY0MjA4WjCBhjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1\nZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNydWhlMSIwIAYDVQQKExlCYWRpc2No\nZSBMYW5kZXNiaWJsaW90aGVrMSIwIAYDVQQDExlibGJsb2dpbi5ibGIta2FybHNy\ndWhlLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwK5CwhRlyfdY\nd7yUxHWp7OOLBsbb3iJZgABVoTPwwIxo09s6aoWJEPkcQonDYwruQicUmLNpiUs8\njZcL7D0CRJrVGt1KRnoKQHFVoKlOLE21vxwyFDapQN9BZIOOE9tbE9+zcvkefrRZ\nIWz5Xifz6MRzQWEeXl34c5XPCYA7NQmIwwSDhMRDHY7AU3ODNeBmZQPNhNFQ65v/\nNmuuc5KDpSTVZ60Tw+qsYL2uwvFVltTnTMPxtEaKn6MF7ha3DctAUCD9LS3vcQX9\n1z8RA6Pf7F5mKqfxOxQdyfaTUM8+AC6msg6SleoAH3dv/z1V0WUufOyQxE+KZOkw\nHiq3R/F8bwIDAQABo4IB5DCCAeAwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBS+tVT4orbmPPBd\nBE0bI612jtuvjzAfBgNVHSMEGDAWgBTYEu7/qoIRCVQnKWmkaRu3leqNWjCBpQYD\nVR0fBIGdMIGaMEugSaBHhkVodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2JhZGlzY2hl\nLWxhbmRlc2JpYmxpb3RoZWstY2EvcHViL2NybC9jYWNybC5jcmwwS6BJoEeGRWh0\ndHA6Ly9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1j\nYS9wdWIvY3JsL2NhY3JsLmNybDCBvgYIKwYBBQUHAQEEgbEwga4wVQYIKwYBBQUH\nMAKGSWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlv\ndGhlay1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwVQYIKwYBBQUHMAKGSWh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1jYS9w\ndWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAEtEg8O8PON8\n4oNM1as89QeDwAAsqyH2yfo4GRKLTCmAryPi8QC635YlgG7xvqz+CgS3znz3wAJC\nkNoQhdh3+ARk6oF4wQ/OxPhMq7i/Pmx0uUInPqfPTIz306sEeuksIvsBz2QAZXkS\nfirdXwi9tidcOvxTZYL5J+KscKVDWhS4zEEeF8/oT3bvBFQQv1MdR8Dymn+axGPS\nQm1Z19FEwxKD1Da80qM+vlFKdFm6kf9ANjGEoxU3+nS+SEDolRSvKbD45xtEXDm2\nOecY2Vyft4fthAti2y+7mMkBYZdKXvS8yhL0QJVTYmY/Zh28JInYcQ9dnvrMynTd\nQ1O4HKVwCF4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://blblogin.blb-karlsruhe.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://blblogin.blb-karlsruhe.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://blblogin.blb-karlsruhe.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://blblogin.blb-karlsruhe.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "blblogin.blb-karlsruhe.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "blblogin.blb-karlsruhe.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=blblogin.blb-karlsruhe.de,O=Badische Landesbibliothek,L=Karlsruhe,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFpDCCBIygAwIBAgIEDaIezzANBgkqhkiG9w0BAQUFADCBuDELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNy\ndWhlMSIwIAYDVQQKExlCYWRpc2NoZSBMYW5kZXNiaWJsaW90aGVrMRUwEwYDVQQL\nEwxJVC1BYnRlaWx1bmcxGTAXBgNVBAMTEEJMQiBLYXJsc3J1aGUgQ0ExIjAgBgkq\nhkiG9w0BCQEWE2NhQGJsYi1rYXJsc3J1aGUuZGUwHhcNMDkwMTMwMDY0MjA4WhcN\nMTQwMTI5MDY0MjA4WjCBhjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1\nZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNydWhlMSIwIAYDVQQKExlCYWRpc2No\nZSBMYW5kZXNiaWJsaW90aGVrMSIwIAYDVQQDExlibGJsb2dpbi5ibGIta2FybHNy\ndWhlLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwK5CwhRlyfdY\nd7yUxHWp7OOLBsbb3iJZgABVoTPwwIxo09s6aoWJEPkcQonDYwruQicUmLNpiUs8\njZcL7D0CRJrVGt1KRnoKQHFVoKlOLE21vxwyFDapQN9BZIOOE9tbE9+zcvkefrRZ\nIWz5Xifz6MRzQWEeXl34c5XPCYA7NQmIwwSDhMRDHY7AU3ODNeBmZQPNhNFQ65v/\nNmuuc5KDpSTVZ60Tw+qsYL2uwvFVltTnTMPxtEaKn6MF7ha3DctAUCD9LS3vcQX9\n1z8RA6Pf7F5mKqfxOxQdyfaTUM8+AC6msg6SleoAH3dv/z1V0WUufOyQxE+KZOkw\nHiq3R/F8bwIDAQABo4IB5DCCAeAwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBS+tVT4orbmPPBd\nBE0bI612jtuvjzAfBgNVHSMEGDAWgBTYEu7/qoIRCVQnKWmkaRu3leqNWjCBpQYD\nVR0fBIGdMIGaMEugSaBHhkVodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2JhZGlzY2hl\nLWxhbmRlc2JpYmxpb3RoZWstY2EvcHViL2NybC9jYWNybC5jcmwwS6BJoEeGRWh0\ndHA6Ly9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1j\nYS9wdWIvY3JsL2NhY3JsLmNybDCBvgYIKwYBBQUHAQEEgbEwga4wVQYIKwYBBQUH\nMAKGSWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlv\ndGhlay1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwVQYIKwYBBQUHMAKGSWh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1jYS9w\ndWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAEtEg8O8PON8\n4oNM1as89QeDwAAsqyH2yfo4GRKLTCmAryPi8QC635YlgG7xvqz+CgS3znz3wAJC\nkNoQhdh3+ARk6oF4wQ/OxPhMq7i/Pmx0uUInPqfPTIz306sEeuksIvsBz2QAZXkS\nfirdXwi9tidcOvxTZYL5J+KscKVDWhS4zEEeF8/oT3bvBFQQv1MdR8Dymn+axGPS\nQm1Z19FEwxKD1Da80qM+vlFKdFm6kf9ANjGEoxU3+nS+SEDolRSvKbD45xtEXDm2\nOecY2Vyft4fthAti2y+7mMkBYZdKXvS8yhL0QJVTYmY/Zh28JInYcQ9dnvrMynTd\nQ1O4HKVwCF4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "blblogin.blb-karlsruhe.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=blblogin.blb-karlsruhe.de,O=Badische Landesbibliothek,L=Karlsruhe,ST=Baden-Wuerttemberg,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFpDCCBIygAwIBAgIEDaIezzANBgkqhkiG9w0BAQUFADCBuDELMAkGA1UEBhMC\nREUxGzAZBgNVBAgTEkJhZGVuLVd1ZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNy\ndWhlMSIwIAYDVQQKExlCYWRpc2NoZSBMYW5kZXNiaWJsaW90aGVrMRUwEwYDVQQL\nEwxJVC1BYnRlaWx1bmcxGTAXBgNVBAMTEEJMQiBLYXJsc3J1aGUgQ0ExIjAgBgkq\nhkiG9w0BCQEWE2NhQGJsYi1rYXJsc3J1aGUuZGUwHhcNMDkwMTMwMDY0MjA4WhcN\nMTQwMTI5MDY0MjA4WjCBhjELMAkGA1UEBhMCREUxGzAZBgNVBAgTEkJhZGVuLVd1\nZXJ0dGVtYmVyZzESMBAGA1UEBxMJS2FybHNydWhlMSIwIAYDVQQKExlCYWRpc2No\nZSBMYW5kZXNiaWJsaW90aGVrMSIwIAYDVQQDExlibGJsb2dpbi5ibGIta2FybHNy\ndWhlLmRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwK5CwhRlyfdY\nd7yUxHWp7OOLBsbb3iJZgABVoTPwwIxo09s6aoWJEPkcQonDYwruQicUmLNpiUs8\njZcL7D0CRJrVGt1KRnoKQHFVoKlOLE21vxwyFDapQN9BZIOOE9tbE9+zcvkefrRZ\nIWz5Xifz6MRzQWEeXl34c5XPCYA7NQmIwwSDhMRDHY7AU3ODNeBmZQPNhNFQ65v/\nNmuuc5KDpSTVZ60Tw+qsYL2uwvFVltTnTMPxtEaKn6MF7ha3DctAUCD9LS3vcQX9\n1z8RA6Pf7F5mKqfxOxQdyfaTUM8+AC6msg6SleoAH3dv/z1V0WUufOyQxE+KZOkw\nHiq3R/F8bwIDAQABo4IB5DCCAeAwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYD\nVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMB0GA1UdDgQWBBS+tVT4orbmPPBd\nBE0bI612jtuvjzAfBgNVHSMEGDAWgBTYEu7/qoIRCVQnKWmkaRu3leqNWjCBpQYD\nVR0fBIGdMIGaMEugSaBHhkVodHRwOi8vY2RwMS5wY2EuZGZuLmRlL2JhZGlzY2hl\nLWxhbmRlc2JpYmxpb3RoZWstY2EvcHViL2NybC9jYWNybC5jcmwwS6BJoEeGRWh0\ndHA6Ly9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1j\nYS9wdWIvY3JsL2NhY3JsLmNybDCBvgYIKwYBBQUHAQEEgbEwga4wVQYIKwYBBQUH\nMAKGSWh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlv\ndGhlay1jYS9wdWIvY2FjZXJ0L2NhY2VydC5jcnQwVQYIKwYBBQUHMAKGSWh0dHA6\nLy9jZHAyLnBjYS5kZm4uZGUvYmFkaXNjaGUtbGFuZGVzYmlibGlvdGhlay1jYS9w\ndWIvY2FjZXJ0L2NhY2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAEtEg8O8PON8\n4oNM1as89QeDwAAsqyH2yfo4GRKLTCmAryPi8QC635YlgG7xvqz+CgS3znz3wAJC\nkNoQhdh3+ARk6oF4wQ/OxPhMq7i/Pmx0uUInPqfPTIz306sEeuksIvsBz2QAZXkS\nfirdXwi9tidcOvxTZYL5J+KscKVDWhS4zEEeF8/oT3bvBFQQv1MdR8Dymn+axGPS\nQm1Z19FEwxKD1Da80qM+vlFKdFm6kf9ANjGEoxU3+nS+SEDolRSvKbD45xtEXDm2\nOecY2Vyft4fthAti2y+7mMkBYZdKXvS8yhL0QJVTYmY/Zh28JInYcQ9dnvrMynTd\nQ1O4HKVwCF4=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Badische Landesbibliothek Karlsruhe", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Badische Landesbibliothek", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.blb-karlsruhe.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Uli", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "fietz@blb-karlsruhe.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Fietz", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Uli", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "fietz@blb-karlsruhe.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Fietz", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://connect.tut.fi/", 
    {
      "entity_id": "https://connect.tut.fi/", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/connect.tut.fi.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "fi", 
            "text": "Tampereen teknillinen yliopisto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "Tampere University of Technology", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "sv", 
            "text": "Tammerfors tekniska universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "fi", 
            "text": "Tampereen teknillinen yliopisto", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "Tampere University of Technology", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "sv", 
            "text": "Tammerfors tekniska universitet", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "fi", 
            "text": "http://www.tut.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "http://www.tut.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "sv", 
            "text": "http://www.tut.fi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Pasi", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "pasi.hakkinen@tut.fi", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hakkinen", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "is_default": "true", 
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ao4.ee.tut.fi/acp/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "is_default": "false", 
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ao4.ee.tut.fi/acp/Shibboleth.sso/SAML/POST"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://ao4.ee.tut.fi/Shibboleth.sso/DS"
              }, 
              {
                "attribute_value": [
                  {
                    "text": "kalmar", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string", 
                      "{http://www.w3.org/2001/XMLSchema-instance}nil": "true"
                    }
                  }, 
                  {
                    "text": "finland", 
                    "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&AttributeValue", 
                    "extension_attributes": {
                      "{http://www.w3.org/2001/XMLSchema-instance}type": "xs:string", 
                      "{http://www.w3.org/2001/XMLSchema-instance}nil": "true"
                    }
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:2.0:assertion&Attribute", 
                "name": "tags"
              }
            ]
          }, 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ], 
          "attribute_consuming_service": [
            {
              "index": "1", 
              "service_name": [
                {
                  "lang": "fi", 
                  "text": "Acrobat Connect Pro -verkkokokouspalvelu", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "en", 
                  "text": "TUT Acrobat Connect Pro", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }, 
                {
                  "lang": "sv", 
                  "text": "TUT Acrobat Connect Pro", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceName"
                }
              ], 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeConsumingService", 
              "is_default": "true", 
              "requested_attribute": [
                {
                  "friendly_name": "cn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.3"
                }, 
                {
                  "friendly_name": "displayName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.16.840.1.113730.3.1.241"
                }, 
                {
                  "friendly_name": "eduPersonAffiliation", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.1"
                }, 
                {
                  "friendly_name": "eduPersonPrincipalName", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.5923.1.1.1.6"
                }, 
                {
                  "friendly_name": "mail", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:0.9.2342.19200300.100.1.3"
                }, 
                {
                  "friendly_name": "schacHomeOrganization", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:1.3.6.1.4.1.25178.1.2.9"
                }, 
                {
                  "friendly_name": "sn", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&RequestedAttribute", 
                  "name_format": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", 
                  "name": "urn:oid:2.5.4.4"
                }
              ], 
              "service_description": [
                {
                  "lang": "fi", 
                  "text": "TTY:n verkkokokouspalvelu.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "en", 
                  "text": "TUT web conference service.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }, 
                {
                  "lang": "sv", 
                  "text": "TUT-tjansten for e-moten.", 
                  "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ServiceDescription"
                }
              ]
            }
          ], 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIE5zCCA8+gAwIBAgIQTC0sMFTDx+8bItkWKEE8EjANBgkqhkiG9w0BAQUFADA2\nMQswCQYDVQQGEwJOTDEPMA0GA1UEChMGVEVSRU5BMRYwFAYDVQQDEw1URVJFTkEg\nU1NMIENBMB4XDTEwMDYwODAwMDAwMFoXDTEzMDYwNzIzNTk1OVowgcQxCzAJBgNV\nBAYTAkZJMQ4wDAYDVQQREwUzMzcyMDESMBAGA1UECBMJUGlya2FubWFhMRAwDgYD\nVQQHEwdUYW1wZXJlMRwwGgYDVQQJExNLb3JrZWFrb3VsdW5rYXR1IDEwMSkwJwYD\nVQQKEyBUYW1wZXJlIFVuaXZlcnNpdHkgb2YgVGVjaG5vbG9neTEeMBwGA1UECxMV\nSHlwZXJtZWRpYSBMYWJvcmF0b3J5MRYwFAYDVQQDEw1hbzQuZWUudHV0LmZpMIIB\nIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw+q6HSeOwJOL+dhw2C6rmt+X\nXOC17rS4cqw/GK/MdcEB6OUGGnP7CVnMTt5i7kYRTE2xZZ4puXgunZc4djROOl5U\n9GpKJr1+PrBJ4bhZvJuuP+NGmk36dhPDelgGrl2g2t5Fdqm5gxLU7JBhDQcttbiQ\nIm4KCUD4RaYkVnt5LRb2XZ5rrfyNjphSr06HopVy77k3H0sd7uPlPg3fj1u6h3GB\nUwd+/Gdle78H5VF75+uhPZvmI9IjRT8i0I0hIDTXrnKKM+hmYg/OZteb/eSxTdfD\ncAsm0hfk4C4+i7FeR2ODlY0kegMZEfFLFAxRH950TP2IfRhl7aFHbggQ9zB6XwID\nAQABo4IBYDCCAVwwHwYDVR0jBBgwFoAUDL2TaAzz3qujSWsrN1dH6pDjue0wHQYD\nVR0OBBYEFD7dPRIPwNod9MvHsOo3Ryx8sENGMA4GA1UdDwEB/wQEAwIFoDAMBgNV\nHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAYBgNVHSAE\nETAPMA0GCysGAQQBsjEBAgIdMDoGA1UdHwQzMDEwL6AtoCuGKWh0dHA6Ly9jcmwu\ndGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0EuY3JsMG0GCCsGAQUFBwEBBGEwXzA1\nBggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3MudGVyZW5hLm9yZy9URVJFTkFTU0xD\nQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9vY3NwLnRjcy50ZXJlbmEub3JnMBgG\nA1UdEQQRMA+CDWFvNC5lZS50dXQuZmkwDQYJKoZIhvcNAQEFBQADggEBAC58dIBC\nvOyd04SLE1l+7yZ3ARTE+enLAEDGJzvvjlKG8MdsC/TfDimtTMOXQnNXbnfEzKwj\nZagmu/FRdhkVTQP48354C/hnAl1/Wyfjab8O9LeC6+pfAyY2mWzrb4kfRBm1KE26\nB2nURaYtDmZ+MJmjCyLQGaNMZz1q+eSyluTMMUven1FPVVPGlOGqUnPwOQUOvuVS\nvUyXrqyYfbSpfBsog9tVyW2KwzKvVCFeQ9pbUaxfsWD8qIeeKI17FzHVJEBtg23r\nz+mEW/8SvYpmYBk5YhfB1rTXQahEGyw8XP+kmmsb5h5d5yHgUXtEpEsBI4ORxMu1\nYUyAsGo8rZZF7VE=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ]
        }
      ]
    }
  ], 
  [
    "http://xenosmilus.umdc.umu.se:8086/sp.xml", 
    {
      "entity_id": "http://xenosmilus.umdc.umu.se:8086/sp.xml", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://xenosmilus.umdc.umu.se:8086/acs/redirect"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "http://xenosmilus.umdc.umu.se:8086/acs/post"
            }
          ], 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC8jCCAlugAwIBAgIJAJHg2V5J31I8MA0GCSqGSIb3DQEBBQUAMFoxCzAJBgNV\n                        BAYTAlNFMQ0wCwYDVQQHEwRVbWVhMRgwFgYDVQQKEw9VbWVhIFVuaXZlcnNpdHkx\n                        EDAOBgNVBAsTB0lUIFVuaXQxEDAOBgNVBAMTB1Rlc3QgU1AwHhcNMDkxMDI2MTMz\n                        MTE1WhcNMTAxMDI2MTMzMTE1WjBaMQswCQYDVQQGEwJTRTENMAsGA1UEBxMEVW1l\n                        YTEYMBYGA1UEChMPVW1lYSBVbml2ZXJzaXR5MRAwDgYDVQQLEwdJVCBVbml0MRAw\n                        DgYDVQQDEwdUZXN0IFNQMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDkJWP7\n                        bwOxtH+E15VTaulNzVQ/0cSbM5G7abqeqSNSs0l0veHr6/ROgW96ZeQ57fzVy2MC\n                        FiQRw2fzBs0n7leEmDJyVVtBTavYlhAVXDNa3stgvh43qCfLx+clUlOvtnsoMiiR\n                        mo7qf0BoPKTj7c0uLKpDpEbAHQT4OF1HRYVxMwIDAQABo4G/MIG8MB0GA1UdDgQW\n                        BBQ7RgbMJFDGRBu9o3tDQDuSoBy7JjCBjAYDVR0jBIGEMIGBgBQ7RgbMJFDGRBu9\n                        o3tDQDuSoBy7JqFepFwwWjELMAkGA1UEBhMCU0UxDTALBgNVBAcTBFVtZWExGDAW\n                        BgNVBAoTD1VtZWEgVW5pdmVyc2l0eTEQMA4GA1UECxMHSVQgVW5pdDEQMA4GA1UE\n                        AxMHVGVzdCBTUIIJAJHg2V5J31I8MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\n                        BQADgYEAMuRwwXRnsiyWzmRikpwinnhTmbooKm5TINPE7A7gSQ710RxioQePPhZO\n                        zkM27NnHTrCe2rBVg0EGz7QTd1JIwLPvgoj4VTi/fSha/tXrYUaqc9AqU1kWI4WN\n                        +vffBGQ09mo+6CffuFTZYeOhzP/2stAPwCTU4kxEoiy0KpZMANI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIC8jCCAlugAwIBAgIJAJHg2V5J31I8MA0GCSqGSIb3DQEBBQUAMFoxCzAJBgNV\n                        BAYTAlNFMQ0wCwYDVQQHEwRVbWVhMRgwFgYDVQQKEw9VbWVhIFVuaXZlcnNpdHkx\n                        EDAOBgNVBAsTB0lUIFVuaXQxEDAOBgNVBAMTB1Rlc3QgU1AwHhcNMDkxMDI2MTMz\n                        MTE1WhcNMTAxMDI2MTMzMTE1WjBaMQswCQYDVQQGEwJTRTENMAsGA1UEBxMEVW1l\n                        YTEYMBYGA1UEChMPVW1lYSBVbml2ZXJzaXR5MRAwDgYDVQQLEwdJVCBVbml0MRAw\n                        DgYDVQQDEwdUZXN0IFNQMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDkJWP7\n                        bwOxtH+E15VTaulNzVQ/0cSbM5G7abqeqSNSs0l0veHr6/ROgW96ZeQ57fzVy2MC\n                        FiQRw2fzBs0n7leEmDJyVVtBTavYlhAVXDNa3stgvh43qCfLx+clUlOvtnsoMiiR\n                        mo7qf0BoPKTj7c0uLKpDpEbAHQT4OF1HRYVxMwIDAQABo4G/MIG8MB0GA1UdDgQW\n                        BBQ7RgbMJFDGRBu9o3tDQDuSoBy7JjCBjAYDVR0jBIGEMIGBgBQ7RgbMJFDGRBu9\n                        o3tDQDuSoBy7JqFepFwwWjELMAkGA1UEBhMCU0UxDTALBgNVBAcTBFVtZWExGDAW\n                        BgNVBAoTD1VtZWEgVW5pdmVyc2l0eTEQMA4GA1UECxMHSVQgVW5pdDEQMA4GA1UE\n                        AxMHVGVzdCBTUIIJAJHg2V5J31I8MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEF\n                        BQADgYEAMuRwwXRnsiyWzmRikpwinnhTmbooKm5TINPE7A7gSQ710RxioQePPhZO\n                        zkM27NnHTrCe2rBVg0EGz7QTd1JIwLPvgoj4VTi/fSha/tXrYUaqc9AqU1kWI4WN\n                        +vffBGQ09mo+6CffuFTZYeOhzP/2stAPwCTU4kxEoiy0KpZMANI=", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "want_assertions_signed": "true", 
          "authn_requests_signed": "false"
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-2.0/xenosmilus.umdc.umu.se-8086-sp.xml"
      }
    }
  ], 
  [
    "https://kurser.math.su.se/shibboleth", 
    {
      "entity_id": "https://kurser.math.su.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "kurser.math.su.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=kurser.math.su.se,O=Stockholms universitet,C=SE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIEcDCCA1igAwIBAgIQE1y2ZmHRWdeouH6Sf5z+WjANBgkqhkiG9w0BAQUFADA2\nMQswCQYDVQQGEwJOTDEPMA0GA1UEChMGVEVSRU5BMRYwFAYDVQQDEw1URVJFTkEg\nU1NMIENBMB4XDTEwMDExOTAwMDAwMFoXDTEzMDExODIzNTk1OVowSjELMAkGA1UE\nBhMCU0UxHzAdBgNVBAoTFlN0b2NraG9sbXMgdW5pdmVyc2l0ZXQxGjAYBgNVBAMT\nEWt1cnNlci5tYXRoLnN1LnNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEA6BmSQGmI4Efp95B1PMcAPi0/KsW6CZHRku76vh8IS+DBD3zV/A5EFWwlGIBt\nTohN+f6dp5ed4/9C6zlfdSyUblqb607LLeCTsmA4YPFWVon63VdE5GQL0x6Ii55I\nmD+z5d9fhNcL/NAffDAVDLB5HH7YEeX1CBa56NWQO6FHb4f2xX1eURt9+TRxCijQ\nLxhUt/RyMSCujqXE8a2j6JO5UksK7549uHd2zFXwpNMmMr8XnsEwcSj7jCT2MXyZ\njQoGXTTCOORX2tBsWdN/q0XunCxWybZntLih2G3Q5WF0+6NVDuJtVPWsooqZlnre\njYsPPvMiryeEVv1l6uGq6G+/FwIDAQABo4IBZDCCAWAwHwYDVR0jBBgwFoAUDL2T\naAzz3qujSWsrN1dH6pDjue0wHQYDVR0OBBYEFAZIY/QOfeb6IU8E3CmoV4n7u57a\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAYBgNVHSAEETAPMA0GCysGAQQBsjEBAgIdMDoGA1UdHwQz\nMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0Eu\nY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3Mu\ndGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9v\nY3NwLnRjcy50ZXJlbmEub3JnMBwGA1UdEQQVMBOCEWt1cnNlci5tYXRoLnN1LnNl\nMA0GCSqGSIb3DQEBBQUAA4IBAQCfqwDPk9vrMyV/Lv9bzX5nCQKWAuAYlo6qX9lI\nW2IM1IES3LYHzBOt1Rbde4r56HYVy/F8z1DiG/SDTT/WZciArryOozZSTmjfkD1J\nBoRtWsNKnGckWCigaxDS/ai1aGl+X8kZTxUAMQtHIJtkeLZaz1aYv5BMCK0aDPCz\n+jK9xMSMbBhWrVhs6HnkFnGhr71s7ZFbMxRv6psLSPl055grTLQK4eLQ63pWNeTM\norcBunWAqfoXXOHt4HTclLpL01R8y9T5LvZBWpEN75u3fkRHWS/kQIXHprWp07xv\n2Zkq+NG9O7ixLXCdQrd/dZlG8/RITegnw2rhMIpEf25eTkvl", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "kurser.math.su.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=kurser.math.su.se,O=Stockholms universitet,C=SE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIEcDCCA1igAwIBAgIQE1y2ZmHRWdeouH6Sf5z+WjANBgkqhkiG9w0BAQUFADA2\nMQswCQYDVQQGEwJOTDEPMA0GA1UEChMGVEVSRU5BMRYwFAYDVQQDEw1URVJFTkEg\nU1NMIENBMB4XDTEwMDExOTAwMDAwMFoXDTEzMDExODIzNTk1OVowSjELMAkGA1UE\nBhMCU0UxHzAdBgNVBAoTFlN0b2NraG9sbXMgdW5pdmVyc2l0ZXQxGjAYBgNVBAMT\nEWt1cnNlci5tYXRoLnN1LnNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEA6BmSQGmI4Efp95B1PMcAPi0/KsW6CZHRku76vh8IS+DBD3zV/A5EFWwlGIBt\nTohN+f6dp5ed4/9C6zlfdSyUblqb607LLeCTsmA4YPFWVon63VdE5GQL0x6Ii55I\nmD+z5d9fhNcL/NAffDAVDLB5HH7YEeX1CBa56NWQO6FHb4f2xX1eURt9+TRxCijQ\nLxhUt/RyMSCujqXE8a2j6JO5UksK7549uHd2zFXwpNMmMr8XnsEwcSj7jCT2MXyZ\njQoGXTTCOORX2tBsWdN/q0XunCxWybZntLih2G3Q5WF0+6NVDuJtVPWsooqZlnre\njYsPPvMiryeEVv1l6uGq6G+/FwIDAQABo4IBZDCCAWAwHwYDVR0jBBgwFoAUDL2T\naAzz3qujSWsrN1dH6pDjue0wHQYDVR0OBBYEFAZIY/QOfeb6IU8E3CmoV4n7u57a\nMA4GA1UdDwEB/wQEAwIFoDAMBgNVHRMBAf8EAjAAMB0GA1UdJQQWMBQGCCsGAQUF\nBwMBBggrBgEFBQcDAjAYBgNVHSAEETAPMA0GCysGAQQBsjEBAgIdMDoGA1UdHwQz\nMDEwL6AtoCuGKWh0dHA6Ly9jcmwudGNzLnRlcmVuYS5vcmcvVEVSRU5BU1NMQ0Eu\nY3JsMG0GCCsGAQUFBwEBBGEwXzA1BggrBgEFBQcwAoYpaHR0cDovL2NydC50Y3Mu\ndGVyZW5hLm9yZy9URVJFTkFTU0xDQS5jcnQwJgYIKwYBBQUHMAGGGmh0dHA6Ly9v\nY3NwLnRjcy50ZXJlbmEub3JnMBwGA1UdEQQVMBOCEWt1cnNlci5tYXRoLnN1LnNl\nMA0GCSqGSIb3DQEBBQUAA4IBAQCfqwDPk9vrMyV/Lv9bzX5nCQKWAuAYlo6qX9lI\nW2IM1IES3LYHzBOt1Rbde4r56HYVy/F8z1DiG/SDTT/WZciArryOozZSTmjfkD1J\nBoRtWsNKnGckWCigaxDS/ai1aGl+X8kZTxUAMQtHIJtkeLZaz1aYv5BMCK0aDPCz\n+jK9xMSMbBhWrVhs6HnkFnGhr71s7ZFbMxRv6psLSPl055grTLQK4eLQ63pWNeTM\norcBunWAqfoXXOHt4HTclLpL01R8y9T5LvZBWpEN75u3fkRHWS/kQIXHprWp07xv\n2Zkq+NG9O7ixLXCdQrd/dZlG8/RITegnw2rhMIpEf25eTkvl", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://kurser.math.su.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/kurser.math.su.se.xml"
      }
    }
  ], 
  [
    "https://idp.tu-clausthal.de/idp/shibboleth", 
    {
      "entity_id": "https://idp.tu-clausthal.de/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.tu-clausthal.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.tu-clausthal.de/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.tu-clausthal.de/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.tu-clausthal.de/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.tu-clausthal.de/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "tu-clausthal.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.tu-clausthal.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.tu-clausthal.de,OU=Rechenzentrum,O=Technische Universitaet Clausthal,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFajCCBFKgAwIBAgIHEzeWYlp+0DANBgkqhkiG9w0BAQUFADCBmDELMAkGA1UE\nBhMCREUxKjAoBgNVBAoTIVRlY2huaXNjaGUgVW5pdmVyc2l0YWV0IENsYXVzdGhh\nbDEWMBQGA1UECxMNUmVjaGVuemVudHJ1bTEeMBwGA1UEAxMVVFUgQ2xhdXN0aGFs\nIENBIC0gRzAyMSUwIwYJKoZIhvcNAQkBFhZwa2lAcnoudHUtY2xhdXN0aGFsLmRl\nMB4XDTEyMDExOTEzMjEyMloXDTE3MDExNzEzMjEyMlowbzELMAkGA1UEBhMCREUx\nKjAoBgNVBAoTIVRlY2huaXNjaGUgVW5pdmVyc2l0YWV0IENsYXVzdGhhbDEWMBQG\nA1UECxMNUmVjaGVuemVudHJ1bTEcMBoGA1UEAxMTaWRwLnR1LWNsYXVzdGhhbC5k\nZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOTXMm5lk1dD5aFAodbn\n3Hb1BO6e91Z4lMKSnYeWErJhs91SvbeKPRIF9Hsp6jJJWcxhN7yX8LsQlFyxf6Y6\nT9RGtJYdaalamdVc+E9hfojRC3ZMcmiR9Mw29JZuHOQenRRzOqkKWBwtphZqdwMw\niFQ1dI/c4ZvIs0a2iTfXOENY+b3R/MLX3TEKvGL0dDiLqfP086Brp2D3ZYT64/yn\nQFvRHQOJ92HVZUJ+rzTtFcwycU3ylFzLnxMml/6gRYzO1Q10EtGB7TnNo0sNXY9d\nNk/ypCNfxP9nYVpFjTQzhUx9hPJUL9ONjbRqPuDN6wmZZORwMfNppa0nqIIZ+a79\nmicCAwEAAaOCAd8wggHbMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQW\nMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUMzoVo6zpqDLp6HBsV7Kv\nrcDrXMswHwYDVR0jBBgwFoAUYvySt+ft8x81VVvJQ99Qs170ECUwJQYDVR0RBB4w\nHIEac3VwcG9ydEByei50dS1jbGF1c3RoYWwuZGUwgY8GA1UdHwSBhzCBhDBAoD6g\nPIY6aHR0cDovL2NkcDEucGNhLmRmbi5kZS90dS1jbGF1c3RoYWwtY2EvcHViL2Ny\nbC9nX2NhY3JsLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS90dS1j\nbGF1c3RoYWwtY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZsw\ngZgwSgYIKwYBBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtY2xhdXN0\naGFsLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRw\nOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWNsYXVzdGhhbC1jYS9wdWIvY2FjZXJ0L2df\nY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEARsQhmJny/CMVM0+iHo/bchZa\n6crTTbKyEcBexnQlTcKxid6DK+gquIM4U9eCE+1cxgY0kZ9Q/aph1kV0OwGMFGQM\nk5NSRVBlI9Ih/5pWm1lLXEs7tQLF4+L63Z/N15mjzVrnxXZDuQI9YV4V8MnWyRb9\nhEw2ifP/jHV+6yqCe6Nl09DZK4miW5KGEQxVpM975zfCRIOf2INo1//b7wFD7aMR\nmOApGzt7PRZFHR0in3DGFTN5ILSyavrNvHbBXGtaEV2NAtTCqmFBOnlDpGrVz8L8\nyozMpjXfBly8IwiZNQ8GiI4m4oGiv4973ZOwk1njfaI8s82Uq45yjKxs/xhK8g==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.tu-clausthal.de:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.tu-clausthal.de:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.tu-clausthal.de:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://idp.tu-clausthal.de:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "tu-clausthal.de", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.tu-clausthal.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=idp.tu-clausthal.de,OU=Rechenzentrum,O=Technische Universitaet Clausthal,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFajCCBFKgAwIBAgIHEzeWYlp+0DANBgkqhkiG9w0BAQUFADCBmDELMAkGA1UE\nBhMCREUxKjAoBgNVBAoTIVRlY2huaXNjaGUgVW5pdmVyc2l0YWV0IENsYXVzdGhh\nbDEWMBQGA1UECxMNUmVjaGVuemVudHJ1bTEeMBwGA1UEAxMVVFUgQ2xhdXN0aGFs\nIENBIC0gRzAyMSUwIwYJKoZIhvcNAQkBFhZwa2lAcnoudHUtY2xhdXN0aGFsLmRl\nMB4XDTEyMDExOTEzMjEyMloXDTE3MDExNzEzMjEyMlowbzELMAkGA1UEBhMCREUx\nKjAoBgNVBAoTIVRlY2huaXNjaGUgVW5pdmVyc2l0YWV0IENsYXVzdGhhbDEWMBQG\nA1UECxMNUmVjaGVuemVudHJ1bTEcMBoGA1UEAxMTaWRwLnR1LWNsYXVzdGhhbC5k\nZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOTXMm5lk1dD5aFAodbn\n3Hb1BO6e91Z4lMKSnYeWErJhs91SvbeKPRIF9Hsp6jJJWcxhN7yX8LsQlFyxf6Y6\nT9RGtJYdaalamdVc+E9hfojRC3ZMcmiR9Mw29JZuHOQenRRzOqkKWBwtphZqdwMw\niFQ1dI/c4ZvIs0a2iTfXOENY+b3R/MLX3TEKvGL0dDiLqfP086Brp2D3ZYT64/yn\nQFvRHQOJ92HVZUJ+rzTtFcwycU3ylFzLnxMml/6gRYzO1Q10EtGB7TnNo0sNXY9d\nNk/ypCNfxP9nYVpFjTQzhUx9hPJUL9ONjbRqPuDN6wmZZORwMfNppa0nqIIZ+a79\nmicCAwEAAaOCAd8wggHbMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQW\nMBQGCCsGAQUFBwMCBggrBgEFBQcDATAdBgNVHQ4EFgQUMzoVo6zpqDLp6HBsV7Kv\nrcDrXMswHwYDVR0jBBgwFoAUYvySt+ft8x81VVvJQ99Qs170ECUwJQYDVR0RBB4w\nHIEac3VwcG9ydEByei50dS1jbGF1c3RoYWwuZGUwgY8GA1UdHwSBhzCBhDBAoD6g\nPIY6aHR0cDovL2NkcDEucGNhLmRmbi5kZS90dS1jbGF1c3RoYWwtY2EvcHViL2Ny\nbC9nX2NhY3JsLmNybDBAoD6gPIY6aHR0cDovL2NkcDIucGNhLmRmbi5kZS90dS1j\nbGF1c3RoYWwtY2EvcHViL2NybC9nX2NhY3JsLmNybDCBqAYIKwYBBQUHAQEEgZsw\ngZgwSgYIKwYBBQUHMAKGPmh0dHA6Ly9jZHAxLnBjYS5kZm4uZGUvdHUtY2xhdXN0\naGFsLWNhL3B1Yi9jYWNlcnQvZ19jYWNlcnQuY3J0MEoGCCsGAQUFBzAChj5odHRw\nOi8vY2RwMi5wY2EuZGZuLmRlL3R1LWNsYXVzdGhhbC1jYS9wdWIvY2FjZXJ0L2df\nY2FjZXJ0LmNydDANBgkqhkiG9w0BAQUFAAOCAQEARsQhmJny/CMVM0+iHo/bchZa\n6crTTbKyEcBexnQlTcKxid6DK+gquIM4U9eCE+1cxgY0kZ9Q/aph1kV0OwGMFGQM\nk5NSRVBlI9Ih/5pWm1lLXEs7tQLF4+L63Z/N15mjzVrnxXZDuQI9YV4V8MnWyRb9\nhEw2ifP/jHV+6yqCe6Nl09DZK4miW5KGEQxVpM975zfCRIOf2INo1//b7wFD7aMR\nmOApGzt7PRZFHR0in3DGFTN5ILSyavrNvHbBXGtaEV2NAtTCqmFBOnlDpGrVz8L8\nyozMpjXfBly8IwiZNQ8GiI4m4oGiv4973ZOwk1njfaI8s82Uq45yjKxs/xhK8g==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Technische Universitaet Claustha", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Technische Universit\u00e4t Clausthal", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.tu-clausthal.de/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Alexander", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "hasenfuss@rz.tu-clausthal.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hasenfu\u00df", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://idp.ppke.hu/idp/shibboleth", 
    {
      "entity_id": "https://idp.ppke.hu/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/idp.ppke.hu.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://idp.ppke.hu/idp/profile/SAML2/Redirect/SLO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://idp.ppke.hu/idp/profile/SAML2/POST/SLO"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ppke.hu/idp/profile/SAML2/Redirect/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ppke.hu/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://idp.ppke.hu/idp/profile/SAML2/POST-SimpleSign/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "ppke.hu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "text": "login.ppke.hu", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "ip_hint": [
                  {
                    "text": "193.225.109.0/24", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&IPHint"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DiscoHints", 
                "geolocation_hint": [
                  {
                    "text": "geo:47.48841,19.0784", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&GeolocationHint"
                  }
                ]
              }, 
              {
                "logo": [
                  {
                    "text": "https://idp.ppke.hu/logo.png", 
                    "width": "86", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Logo", 
                    "height": "86"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "idp.ppke.hu", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIDGDCCAgCgAwIBAgIVALqsFrR4I9Bs0KO2BfLx5BkiO3BEMA0GCSqGSIb3DQEBBQUAMBYxFDASBgNVBAMTC2lkcC5wcGtlLmh1MB4XDTA5MDkyNDA4NTEyMloXDTI5MDkyNDA4NTEyMlowFjEUMBIGA1UEAxMLaWRwLnBwa2UuaHUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC2OUIJ85ChB9LqQ+KHBXLtCODAr4phVIYGiTp3qDMHOOtGBNUKoyq9AMyVb8nk+coIA0+v5yHOdWHB2ZLz7T7BE2XqWYP/LjW4o6ImBcPnZO3CMYH+EWaxgqvpoS12DlEd9dCJqGqNmL7NYFM/+gX4FeHOCIIKN86ol8Kqup/OVvF9KpzNVaPiVB5UitWO7FG3ZStIGa7kXM3VZW6DpN1Hfs4eQxNPzl0L9em1SMh1KybUde8w0eDaTJHWDvC8W+jwz+3Qc0HHX2BO0SX7LjrJ0/sjU6fEWEP/Q6tApcb4pKxtcWPBC5cdRawyXx5eixirnHafNmWXZf3vqCbd4u67AgMBAAGjXTBbMDoGA1UdEQQzMDGCC2lkcC5wcGtlLmh1hiJodHRwczovL2lkcC5wcGtlLmh1L2lkcC9zaGliYm9sZXRoMB0GA1UdDgQWBBQVA2Fh1jDMY7aRgf+BHStRAVdNkjANBgkqhkiG9w0BAQUFAAOCAQEAQkTajo9mUk/O/yyDv19cb3e9du0FH8TSY5YYYUEsW8xQf5tj7JKavI82FK0ixQnBW9E9I2GEtefMzk11g7DGHujhEyPR8OYoCpCH5UpsxHR06+ZH5kf7bVRxj3FahhgFYCjKQJ8gkmuem8wVd8BkEvnFjt4aP61+Afe+mcNjTm3IYN5iBZPMn/4xpHqDvH7tong+nXD58mMBtDv+JlwVfn7uq9C+OoPMaHWKgt+Y3Rp15/pdTmVzZFjzHxc2OKGM6TRP1woQ6CEx3M3qiCXtP57nApLg0XNLtrMM3jUpEECXyrM4vr6mdBVJqDJAHkr0Ej85ZP84waSs/Ojj5U5etQ==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://idp.ppke.hu:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_authority": "http://eduid.hu"
          }
        ]
      }, 
      "organization": {
        "organization_name": [
          {
            "lang": "hu", 
            "text": "P\u00e1zm\u00e1ny P\u00e9ter Katolikus Egyetem", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "en", 
            "text": "Pazmany Peter Catholic University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "hu", 
            "text": "PPKE - P\u00e1zm\u00e1ny P\u00e9ter Katolikus Egyetem", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "en", 
            "text": "PPKE - P\u00e1zm\u00e1ny P\u00e9ter Catholic University", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "hu", 
            "text": "https://info.ppke.hu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "en", 
            "text": "https://info.ppke.hu", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "mailto:cstamas@digitus.itk.ppke.hu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Csillag Tam\u00e1s", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "email_address": [
            {
              "text": "mailto:cstamas@digitus.itk.ppke.hu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Csillag Tam\u00e1s", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "support"
        }, 
        {
          "email_address": [
            {
              "text": "mailto:cstamas@digitus.itk.ppke.hu", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Csillag Tam\u00e1s", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ]
    }
  ], 
  [
    "https://www.video2brain.com/shibboleth", 
    {
      "entity_id": "https://www.video2brain.com/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/www.video2brain.com.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "video2brain", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "video2brain", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "https://www.video2brain.com/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Ammar", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "aganovic@parkside.at", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Aganovic", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }, 
        {
          "given_name": {
            "text": "Thomas", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "tlauter@video2brain.com", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Lauter", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://www.video2brain.com/Shibboleth.sso/Login"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "key_name": [
                  {
                    "text": "www.video2brain.com", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=www.video2brain.com,OU=Terms of use at www.verisign.com/rpa (c)05,O=video2brain GmbH,L=Graz,ST=Steiermark,C=AT,serialNumber=310510h,businessCategory=Private Organization,1.3.6.1.4.1.311.60.2.1.1=#140120,1.3.6.1.4.1.311.60.2.1.2=#140120,1.3.6.1.4.1.311.60.2.1.3=#13024154", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGITCCBQmgAwIBAgIQNS1m8T236j2soVAkQJv7jzANBgkqhkiG9w0BAQUFADCB\nujELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2Ug\nYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwNjE0MDIGA1UEAxMr\nVmVyaVNpZ24gQ2xhc3MgMyBFeHRlbmRlZCBWYWxpZGF0aW9uIFNTTCBDQTAeFw0x\nMjAxMDMwMDAwMDBaFw0xNDAxMDIyMzU5NTlaMIIBDTETMBEGCysGAQQBgjc8AgED\nEwJBVDESMBAGCysGAQQBgjc8AgECFAEgMRIwEAYLKwYBBAGCNzwCAQEUASAxHTAb\nBgNVBA8TFFByaXZhdGUgT3JnYW5pemF0aW9uMRAwDgYDVQQFEwczMTA1MTBoMQsw\nCQYDVQQGEwJBVDETMBEGA1UECBQKU3RlaWVybWFyazENMAsGA1UEBxQER3JhejEZ\nMBcGA1UEChQQdmlkZW8yYnJhaW4gR21iSDEzMDEGA1UECxQqVGVybXMgb2YgdXNl\nIGF0IHd3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA1MRwwGgYDVQQDFBN3d3cudmlk\nZW8yYnJhaW4uY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo1oh\nXDUGMkwc2fgsmGnYwPOwCAEeYtZI5du0E40rE+h9f1Ruaq+niJUOI4Rz0bVTP/o9\n1Ae2+PyNbV+tlhcUT60OsSVVEkl6oya6o4mTO/bvXM2O+/EUnG/l3a8jNFddL9Zr\ny162ybEnwjxMo37EWtLE3/8yr3Hrz151BXRWAGfu3eXSAGzgJkNjDv78e2gm7MCL\nFMjEl9j3j2Oivzvn4OLTm0Nt+amNh9BEXPcWu2bnID4gddiFF3aGeb8lfJix1HVV\ncM6GEgxmBvoypNUj7Fu/nvO1K2UERhGiHvZfLjjndRoNheYulPtNsHXH1esrGlp8\nGRC5VHe3isUsAZsq2QIDAQABo4IByzCCAccwCQYDVR0TBAIwADALBgNVHQ8EBAMC\nBaAwQgYDVR0fBDswOTA3oDWgM4YxaHR0cDovL0VWU2VjdXJlLWNybC52ZXJpc2ln\nbi5jb20vRVZTZWN1cmUyMDA2LmNybDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcG\nMCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9jcHMwHQYD\nVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMB8GA1UdIwQYMBaAFPyKULqeuSVa\ne1WFT5UAY4/pWGtDMHMGCCsGAQUFBwEBBGcwZTAkBggrBgEFBQcwAYYYaHR0cDov\nL29jc3AudmVyaXNpZ24uY29tMD0GCCsGAQUFBzAChjFodHRwOi8vRVZTZWN1cmUt\nYWlhLnZlcmlzaWduLmNvbS9FVlNlY3VyZTIwMDYuY2VyMG4GCCsGAQUFBwEMBGIw\nYKFeoFwwWjBYMFYWCWltYWdlL2dpZjAhMB8wBwYFKw4DAhoEFEtruSiWBgy70FI4\nmymsSweLIQUYMCYWJGh0dHA6Ly9sb2dvLnZlcmlzaWduLmNvbS92c2xvZ28xLmdp\nZjANBgkqhkiG9w0BAQUFAAOCAQEAhEs/7E2y3/HBHrqo/K7HP4Tdh3R2wlYqgBcW\nbMryxFyEAeL3DRwyx5YP8ZvVGdDoYeR0nMiZOK/mM5Z6HrI5SctILAvzRCvA5vd4\nBDwQn6ywEFaCcbjKLn+qWp9+Edb4eKlfX+iy6biEyhU4xxM7l/oTi60XqUwjMhrB\nvYhJG7vUAHPzBorZdAVFX0mDKyQk6biUYK/FYdQ80FeZMgDUf3snKZfmh8ZCQTRp\nRMwhC+WtUjgR8YGq8g9Cr7IwKbigkuL52fruRz2uK/wJr4e4A2/UdkMsAwBAWr+5\nEHbDtbx/A7fv7IBuW8MyR8JQuf5kfqS8ca8cH47paHLRK9BzNA==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://www.video2brain.com/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://slcs.pca.dfn.de/shibboleth", 
    {
      "entity_id": "https://slcs.pca.dfn.de/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/slcs.pca.dfn.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "DFN-CERT Services GmbH", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "DFN Short-Lived Credential Service (DFN-SLCS)", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://www.dfn-cert.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Reimer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "dfnpca@dfn-cert.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Karlsen-Masur", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Reimer", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "dfnpca@dfn-cert.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Karlsen-Masur", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SLO/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SLO/SOAP"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://slcs.pca.dfn.de/Shibboleth.sso/DS"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "slcs.pca.dfn.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=slcs.pca.dfn.de,OU=DFN-PKI,O=DFN-Verein,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFATCCA+mgAwIBAgIEDbn3WDANBgkqhkiG9w0BAQUFADBVMQswCQYDVQQGEwJE\nRTETMBEGA1UEChMKREZOLVZlcmVpbjEQMA4GA1UECxMHREZOLVBLSTEfMB0GA1UE\nAxMWREZOLVZlcmVpbiBDQSBTZXJ2aWNlczAeFw0wOTAyMTcwODQ4MDhaFw0xNDAy\nMTYwODQ4MDhaME4xCzAJBgNVBAYTAkRFMRMwEQYDVQQKEwpERk4tVmVyZWluMRAw\nDgYDVQQLEwdERk4tUEtJMRgwFgYDVQQDEw9zbGNzLnBjYS5kZm4uZGUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCw3Jc6eE6FdEoDHX4bGRTQ8tt2f65t\nhR76ZN4o4WIMXlnKuUiPcj84bSnsToXi8CTZy0Y3IS/iqiG+VIhlwombfqgEJb1/\nYXxW9hL3s38qobUNsSlv1cam6MjJVRRbvmnulqA2UkcXh0j8oXjMgMrvRscvc5Vr\nR+qrLotFyEp3weKYTS03k6f2QN63pFCtwu+4db5g7DLAgf4T8LkCwPR1yrAjfIyQ\nKZlilI1I+LIEepIbZ5Yi/HWxGJ4rE0QQzf595yiygtXL+lwgOjexnKOEoVNdRa3k\ngDUoh5xyTkdnLDjV2J/fsHkzjy8mODDl9POPm+5xsLXLwGMn+ChU6CSrAgMBAAGj\nggHeMIIB2jAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEF\nBQcDAgYIKwYBBQUHAwEwHQYDVR0OBBYEFJweQjSs1QUY3yB1FTgAhsULqiHTMB8G\nA1UdIwQYMBaAFB2p8YYmdk3PXf1Qo27r8bwidW3rMCAGA1UdEQQZMBeBFXdlYm1h\nc3RlckBkZm4tY2VydC5kZTCBkQYDVR0fBIGJMIGGMEGgP6A9hjtodHRwOi8vY2Rw\nMS5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9wdWIvY3JsL2NhY3JsLmNy\nbDBBoD+gPYY7aHR0cDovL2NkcDIucGNhLmRmbi5kZS9nbG9iYWwtc2VydmljZXMt\nY2EvcHViL2NybC9jYWNybC5jcmwwgaoGCCsGAQUFBwEBBIGdMIGaMEsGCCsGAQUF\nBzAChj9odHRwOi8vY2RwMS5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9w\ndWIvY2FjZXJ0L2NhY2VydC5jcnQwSwYIKwYBBQUHMAKGP2h0dHA6Ly9jZHAyLnBj\nYS5kZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNy\ndDANBgkqhkiG9w0BAQUFAAOCAQEAilQf5k73NxqSFP81D51u6cnwE+ZW1WCPcUhd\nIkQ+K85pP57nd4ClbL+mond011qRiyzA9txYuoxw6+J6mXU9MlKDgWh7ACVIjEZB\nVeS/ROi0GvRKQBlUp4OgwFFMhoHp5wZbpL7cCp5NE7ZOMNZfGk095tEFEDZX7Csg\nGlcR2n3wMi66UIFjaMKTdmh5kPFVtQNw8FltrO+qRJeTljDTB4Ct9SOCV7F2VnNo\n/bBzPejsxto0mF0W/gqyfZqcQSnSGEFVDQsAEv2aLMHoFvuOIr4nHWTsimbKuidM\n73o/AK2KZu86hs7mFt0tLOrUUlJJOtekqrPLWHFfLLBT8f9L+w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "slcs.pca.dfn.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=slcs.pca.dfn.de,OU=DFN-PKI,O=DFN-Verein,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIFATCCA+mgAwIBAgIEDbn3WDANBgkqhkiG9w0BAQUFADBVMQswCQYDVQQGEwJE\nRTETMBEGA1UEChMKREZOLVZlcmVpbjEQMA4GA1UECxMHREZOLVBLSTEfMB0GA1UE\nAxMWREZOLVZlcmVpbiBDQSBTZXJ2aWNlczAeFw0wOTAyMTcwODQ4MDhaFw0xNDAy\nMTYwODQ4MDhaME4xCzAJBgNVBAYTAkRFMRMwEQYDVQQKEwpERk4tVmVyZWluMRAw\nDgYDVQQLEwdERk4tUEtJMRgwFgYDVQQDEw9zbGNzLnBjYS5kZm4uZGUwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCw3Jc6eE6FdEoDHX4bGRTQ8tt2f65t\nhR76ZN4o4WIMXlnKuUiPcj84bSnsToXi8CTZy0Y3IS/iqiG+VIhlwombfqgEJb1/\nYXxW9hL3s38qobUNsSlv1cam6MjJVRRbvmnulqA2UkcXh0j8oXjMgMrvRscvc5Vr\nR+qrLotFyEp3weKYTS03k6f2QN63pFCtwu+4db5g7DLAgf4T8LkCwPR1yrAjfIyQ\nKZlilI1I+LIEepIbZ5Yi/HWxGJ4rE0QQzf595yiygtXL+lwgOjexnKOEoVNdRa3k\ngDUoh5xyTkdnLDjV2J/fsHkzjy8mODDl9POPm+5xsLXLwGMn+ChU6CSrAgMBAAGj\nggHeMIIB2jAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEF\nBQcDAgYIKwYBBQUHAwEwHQYDVR0OBBYEFJweQjSs1QUY3yB1FTgAhsULqiHTMB8G\nA1UdIwQYMBaAFB2p8YYmdk3PXf1Qo27r8bwidW3rMCAGA1UdEQQZMBeBFXdlYm1h\nc3RlckBkZm4tY2VydC5kZTCBkQYDVR0fBIGJMIGGMEGgP6A9hjtodHRwOi8vY2Rw\nMS5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9wdWIvY3JsL2NhY3JsLmNy\nbDBBoD+gPYY7aHR0cDovL2NkcDIucGNhLmRmbi5kZS9nbG9iYWwtc2VydmljZXMt\nY2EvcHViL2NybC9jYWNybC5jcmwwgaoGCCsGAQUFBwEBBIGdMIGaMEsGCCsGAQUF\nBzAChj9odHRwOi8vY2RwMS5wY2EuZGZuLmRlL2dsb2JhbC1zZXJ2aWNlcy1jYS9w\ndWIvY2FjZXJ0L2NhY2VydC5jcnQwSwYIKwYBBQUHMAKGP2h0dHA6Ly9jZHAyLnBj\nYS5kZm4uZGUvZ2xvYmFsLXNlcnZpY2VzLWNhL3B1Yi9jYWNlcnQvY2FjZXJ0LmNy\ndDANBgkqhkiG9w0BAQUFAAOCAQEAilQf5k73NxqSFP81D51u6cnwE+ZW1WCPcUhd\nIkQ+K85pP57nd4ClbL+mond011qRiyzA9txYuoxw6+J6mXU9MlKDgWh7ACVIjEZB\nVeS/ROi0GvRKQBlUp4OgwFFMhoHp5wZbpL7cCp5NE7ZOMNZfGk095tEFEDZX7Csg\nGlcR2n3wMi66UIFjaMKTdmh5kPFVtQNw8FltrO+qRJeTljDTB4Ct9SOCV7F2VnNo\n/bBzPejsxto0mF0W/gqyfZqcQSnSGEFVDQsAEv2aLMHoFvuOIr4nHWTsimbKuidM\n73o/AK2KZu86hs7mFt0tLOrUUlJJOtekqrPLWHFfLLBT8f9L+w==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/NIM/Artifact"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://slcs.pca.dfn.de/Shibboleth.sso/NIM/SOAP"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://portalservicesutv.miun.se/shibboleth", 
    {
      "entity_id": "https://portalservicesutv.miun.se/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "4", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SAML2/ECP"
            }, 
            {
              "index": "5", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SAML/POST"
            }, 
            {
              "index": "6", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/SAML/Artifact"
            }
          ], 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "index": "1", 
                "binding": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol", 
                "__class__": "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol&DiscoveryResponse", 
                "location": "https://portalservicesutv.miun.se/Shibboleth.sso/DS/ds.swamid.se"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "rosalindutv.personal.miun.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=rosalindutv.personal.miun.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIJAKCTfNMVxYcfMA0GCSqGSIb3DQEBBQUAMCcxJTAjBgNV\nBAMTHHJvc2FsaW5kdXR2LnBlcnNvbmFsLm1pdW4uc2UwHhcNMTIxMTE1MjIyMTM5\nWhcNMjIxMTEzMjIyMTM5WjAnMSUwIwYDVQQDExxyb3NhbGluZHV0di5wZXJzb25h\nbC5taXVuLnNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqKPvBXqy\nnRvi3sDksMSy9G5VZ9JhXA4/Kz3xY00PiE0Qg6FonPD01VqAJe8uh/yZc4Ckb9on\n6eWHX9wRiE+bdk0HsqaqXvXjmbQdQs2w3VQqNVDIAWoIljdVFf80G5KzJYLf8IRd\n5HI/hQ72rctAQCo5XWB8VfU18QDcPVMdiJJ4mVjOEuj5nWBqOi5xX94SHJZzlsA3\nUamgvzbO4hypXeoXxz2t8rAsMSSajlvURBN7/7yKp0Phwp5UqGXQz/O+FrjNxVxa\nT5ARsjgi3h1L1izfkHlOnCB6CL4Hgs4azOfAlokchmV4I92Wz4zyQq9HwCylJDOv\nckP3oS/ZKIe2DwIDAQABo0owSDAnBgNVHREEIDAeghxyb3NhbGluZHV0di5wZXJz\nb25hbC5taXVuLnNlMB0GA1UdDgQWBBQKoz3fn0XgpuozE4czYMpBM19mZjANBgkq\nhkiG9w0BAQUFAAOCAQEAU6lmNUTJOleVGd5RjCnHBx5qBHU158VVUfrKEWbCohPi\nE0gUTOT7wf7FEK7A7XEdV1oC530cIUsRiEAi/hZMQxhkHwjcxRTEtqbIsknDcP6P\nYCROa5TjdPIF/ABsFXlVG5ypmezx/6i+iT+9INr6ipvnQP0bNnfnZGejI9OUrAw4\n42gbDmSviYSYdHr6VDi2V3+JdIQ7AEgw5VRdPsBwAg1b8jyrvTywbYooSHvh/9sp\nOdn0f+Ng1oWBX+8fMDWfhppFm2bDrgM3xCF9GA15oA24yzp4n1VZN5K4mr1+79Tj\nvWPiY7ukG3rEmXz1vlicbY542ygl7W7mMwL6JqPEXw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "rosalindutv.personal.miun.se", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=rosalindutv.personal.miun.se", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIDGzCCAgOgAwIBAgIJAKCTfNMVxYcfMA0GCSqGSIb3DQEBBQUAMCcxJTAjBgNV\nBAMTHHJvc2FsaW5kdXR2LnBlcnNvbmFsLm1pdW4uc2UwHhcNMTIxMTE1MjIyMTM5\nWhcNMjIxMTEzMjIyMTM5WjAnMSUwIwYDVQQDExxyb3NhbGluZHV0di5wZXJzb25h\nbC5taXVuLnNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqKPvBXqy\nnRvi3sDksMSy9G5VZ9JhXA4/Kz3xY00PiE0Qg6FonPD01VqAJe8uh/yZc4Ckb9on\n6eWHX9wRiE+bdk0HsqaqXvXjmbQdQs2w3VQqNVDIAWoIljdVFf80G5KzJYLf8IRd\n5HI/hQ72rctAQCo5XWB8VfU18QDcPVMdiJJ4mVjOEuj5nWBqOi5xX94SHJZzlsA3\nUamgvzbO4hypXeoXxz2t8rAsMSSajlvURBN7/7yKp0Phwp5UqGXQz/O+FrjNxVxa\nT5ARsjgi3h1L1izfkHlOnCB6CL4Hgs4azOfAlokchmV4I92Wz4zyQq9HwCylJDOv\nckP3oS/ZKIe2DwIDAQABo0owSDAnBgNVHREEIDAeghxyb3NhbGluZHV0di5wZXJz\nb25hbC5taXVuLnNlMB0GA1UdDgQWBBQKoz3fn0XgpuozE4czYMpBM19mZjANBgkq\nhkiG9w0BAQUFAAOCAQEAU6lmNUTJOleVGd5RjCnHBx5qBHU158VVUfrKEWbCohPi\nE0gUTOT7wf7FEK7A7XEdV1oC530cIUsRiEAi/hZMQxhkHwjcxRTEtqbIsknDcP6P\nYCROa5TjdPIF/ABsFXlVG5ypmezx/6i+iT+9INr6ipvnQP0bNnfnZGejI9OUrAw4\n42gbDmSviYSYdHr6VDi2V3+JdIQ7AEgw5VRdPsBwAg1b8jyrvTywbYooSHvh/9sp\nOdn0f+Ng1oWBX+8fMDWfhppFm2bDrgM3xCF9GA15oA24yzp4n1VZN5K4mr1+79Tj\nvWPiY7ukG3rEmXz1vlicbY542ygl7W7mMwL6JqPEXw==", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/Artifact/SOAP"
            }
          ], 
          "manage_name_id_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/NIM/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/NIM/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/NIM/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ManageNameIDService", 
              "location": "https://portalservicesutv.miun.se/Shibboleth.sso/NIM/Artifact"
            }
          ]
        }
      ], 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-1.0/portalservicesutv.miun.se.xml"
      }
    }
  ], 
  [
    "https://shibboleth-idp.pucrs.br/idp/shibboleth", 
    {
      "entity_id": "https://shibboleth-idp.pucrs.br/idp/shibboleth", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/shibboleth-idp.pucrs.br.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "idpsso_descriptor": [
        {
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&IDPSSODescriptor", 
          "single_sign_on_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth-idp.pucrs.br/idp/profile/SAML2/POST-SimpleSign/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth-idp.pucrs.br/idp/profile/SAML2/POST/SSO"
            }, 
            {
              "binding": "urn:mace:shibboleth:1.0:profiles:AuthnRequest", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth-idp.pucrs.br/idp/profile/Shibboleth/SSO"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleSignOnService", 
              "location": "https://shibboleth-idp.pucrs.br/idp/profile/SAML2/Redirect/SSO"
            }
          ], 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "pucrs.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }, 
              {
                "information_url": [
                  {
                    "lang": "en", 
                    "text": "http://www.pucrs.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "http://www.pucrs.br/", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&InformationURL"
                  }
                ], 
                "display_name": [
                  {
                    "lang": "en", 
                    "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&DisplayName"
                  }
                ], 
                "__class__": "urn:oasis:names:tc:SAML:metadata:ui&UIInfo", 
                "description": [
                  {
                    "lang": "en", 
                    "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }, 
                  {
                    "lang": "pt-br", 
                    "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
                    "__class__": "urn:oasis:names:tc:SAML:metadata:ui&Description"
                  }
                ]
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEATCCAumgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBnzELMAkGA1UEBhMCQlIx\nGjAYBgNVBAgTEVJpbyBHcmFuZGUgZG8gU3VsMRUwEwYDVQQHEwxQb3J0byBBbGVn\ncmUxDjAMBgNVBAoTBVBVQ1JTMQ0wCwYDVQQLEwRHVElUMSAwHgYJKoZIhvcNAQkB\nFhFzZWN1cml0eUBwdWNycy5icjEcMBoGA1UEAxMTc2hpYmJvbGV0aC5wdWNycy5i\ncjAeFw0xMDExMTAxMDExMDdaFw0xMzExMDkxMDExMDdaMIGfMQswCQYDVQQGEwJC\nUjEaMBgGA1UECBMRUmlvIEdyYW5kZSBkbyBTdWwxFTATBgNVBAcTDFBvcnRvIEFs\nZWdyZTEOMAwGA1UEChMFUFVDUlMxDTALBgNVBAsTBEdUSVQxIDAeBgkqhkiG9w0B\nCQEWEXNlY3VyaXR5QHB1Y3JzLmJyMRwwGgYDVQQDExNzaGliYm9sZXRoLnB1Y3Jz\nLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1iilPh8rOxBD8ceq\nrAb8KcN3WRX6V8CtSEs8GBAKjDt9nRYpFavkJcW6w6+w6ZJz1KlJndy6sgleGjsX\nR1za5nK3gKe3nvWJwkImqNX/nAjBegCnvxq8VSJ4VspLYZQYoTIbAiGvSs7pP++/\n7OBimb424JHU+16+ceqGF75C9tXeA3vOJzHS/bLgxhRwyhhug25DHkTl8wVDuCU0\nq/P8Y0D6sLEXaYFb2jl0piXWK7dz/5LhX2AyyKtrYlQEzgndR/SkANY5iIFiXqJ7\n/q5tQTOQQN4aeb9YEQJaNWJfoa4co8LTmHki6KQvPCmtaBBAjSU7kk9s3+mXJL8l\ngtRI6QIDAQABo0YwRDAJBgNVHRMEAjAAMAsGA1UdDwQEAwIFoDAqBgNVHSUEIzAh\nBggrBgEFBQcDAQYJYIZIAYb4QgQBBgorBgEEAYI3CgMDMA0GCSqGSIb3DQEBBQUA\nA4IBAQC3sT5o3/9sxv2dsti0UVf1aH4f5mYR9ke9mtlEG3GBSepPSsIWSc3AG2ax\nxQ7YCwso+qDo+Yd0v1nQBotFO+KZLN1ruUZv7kjZe0KlRtqrEorpwzkhFfeYQLTZ\n8IvYpV51ZF86yiC+ILZCJCyfr/0SUKkq7d9dXwo0aMMceatSGcVQBtAtmSUKDrCH\nczMiE68nK6Kdez4a/lmP2Y/0fxM2t9S/yos9E5DR94L1Vi3i4lES/0o2QKERXJRg\nYGMwj3C7CmRqC78PfQXLjQdSlJdl17FE6iYyTpssZlhyfFPmbuA+jB7wXKPpeaAf\nE74OQ01EvgXvltt/+5/txq+akm84", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "artifact_resolution_service": [
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth-idp.pucrs.br:8443/idp/profile/SAML2/SOAP/ArtifactResolution"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ArtifactResolutionService", 
              "location": "https://shibboleth-idp.pucrs.br:8443/idp/profile/SAML1/SOAP/ArtifactResolution"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "extensions": {
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
        "extension_elements": [
          {
            "registration_policy": [
              {
                "lang": "pt-br", 
                "text": "http://www.rnp.br/_arquivo/servicos/Politica_CAFe_IDP_final.pdf", 
                "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationPolicy"
              }
            ], 
            "registration_authority": "http://cafe.rnp.br", 
            "__class__": "urn:oasis:names:tc:SAML:metadata:rpi&RegistrationInfo", 
            "registration_instant": "2010-01-01T00:00:00Z"
          }
        ]
      }, 
      "attribute_authority_descriptor": [
        {
          "attribute_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth-idp.pucrs.br:8443/idp/profile/SAML2/SOAP/AttributeQuery"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeService", 
              "location": "https://shibboleth-idp.pucrs.br:8443/idp/profile/SAML1/SOAP/AttributeQuery"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AttributeAuthorityDescriptor", 
          "extensions": {
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Extensions", 
            "extension_elements": [
              {
                "text": "pucrs.br", 
                "__class__": "urn:mace:shibboleth:metadata:1.0&Scope", 
                "regexp": "false"
              }
            ]
          }, 
          "key_descriptor": [
            {
              "key_info": {
                "x509_data": [
                  {
                    "x509_certificate": {
                      "text": "MIIEATCCAumgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBnzELMAkGA1UEBhMCQlIx\nGjAYBgNVBAgTEVJpbyBHcmFuZGUgZG8gU3VsMRUwEwYDVQQHEwxQb3J0byBBbGVn\ncmUxDjAMBgNVBAoTBVBVQ1JTMQ0wCwYDVQQLEwRHVElUMSAwHgYJKoZIhvcNAQkB\nFhFzZWN1cml0eUBwdWNycy5icjEcMBoGA1UEAxMTc2hpYmJvbGV0aC5wdWNycy5i\ncjAeFw0xMDExMTAxMDExMDdaFw0xMzExMDkxMDExMDdaMIGfMQswCQYDVQQGEwJC\nUjEaMBgGA1UECBMRUmlvIEdyYW5kZSBkbyBTdWwxFTATBgNVBAcTDFBvcnRvIEFs\nZWdyZTEOMAwGA1UEChMFUFVDUlMxDTALBgNVBAsTBEdUSVQxIDAeBgkqhkiG9w0B\nCQEWEXNlY3VyaXR5QHB1Y3JzLmJyMRwwGgYDVQQDExNzaGliYm9sZXRoLnB1Y3Jz\nLmJyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1iilPh8rOxBD8ceq\nrAb8KcN3WRX6V8CtSEs8GBAKjDt9nRYpFavkJcW6w6+w6ZJz1KlJndy6sgleGjsX\nR1za5nK3gKe3nvWJwkImqNX/nAjBegCnvxq8VSJ4VspLYZQYoTIbAiGvSs7pP++/\n7OBimb424JHU+16+ceqGF75C9tXeA3vOJzHS/bLgxhRwyhhug25DHkTl8wVDuCU0\nq/P8Y0D6sLEXaYFb2jl0piXWK7dz/5LhX2AyyKtrYlQEzgndR/SkANY5iIFiXqJ7\n/q5tQTOQQN4aeb9YEQJaNWJfoa4co8LTmHki6KQvPCmtaBBAjSU7kk9s3+mXJL8l\ngtRI6QIDAQABo0YwRDAJBgNVHRMEAjAAMAsGA1UdDwQEAwIFoDAqBgNVHSUEIzAh\nBggrBgEFBQcDAQYJYIZIAYb4QgQBBgorBgEEAYI3CgMDMA0GCSqGSIb3DQEBBQUA\nA4IBAQC3sT5o3/9sxv2dsti0UVf1aH4f5mYR9ke9mtlEG3GBSepPSsIWSc3AG2ax\nxQ7YCwso+qDo+Yd0v1nQBotFO+KZLN1ruUZv7kjZe0KlRtqrEorpwzkhFfeYQLTZ\n8IvYpV51ZF86yiC+ILZCJCyfr/0SUKkq7d9dXwo0aMMceatSGcVQBtAtmSUKDrCH\nczMiE68nK6Kdez4a/lmP2Y/0fxM2t9S/yos9E5DR94L1Vi3i4lES/0o2QKERXJRg\nYGMwj3C7CmRqC78PfQXLjQdSlJdl17FE6iYyTpssZlhyfFPmbuA+jB7wXKPpeaAf\nE74OQ01EvgXvltt/+5/txq+akm84", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }, 
            {
              "text": "urn:oasis:names:tc:SAML:2.0:nameid-format:transient", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ], 
      "organization": {
        "organization_name": [
          {
            "lang": "en", 
            "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }, 
          {
            "lang": "pt-br", 
            "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "en", 
            "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }, 
          {
            "lang": "pt-br", 
            "text": "PUCRS - Pontificia Universidade Catolica do Rio Grande do Sul", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "en", 
            "text": "http://www.pucrs.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }, 
          {
            "lang": "pt-br", 
            "text": "http://www.pucrs.br/", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "email_address": [
            {
              "text": "dbueno@pucrs.br", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Dilermando Bueno", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ]
    }
  ], 
  [
    "https://erf.sbb.spk-berlin.de/shibboleth-sp", 
    {
      "entity_id": "https://erf.sbb.spk-berlin.de/shibboleth-sp", 
      "extension_attributes": {
        "{http://www.w3.org/XML/1998/namespace}base": "swamid-interfederations-2.0/erf.sbb.spk-berlin.de.xml"
      }, 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "organization": {
        "organization_name": [
          {
            "lang": "de", 
            "text": "Staatsbibliothek zu Berlin", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationName"
          }
        ], 
        "organization_display_name": [
          {
            "lang": "de", 
            "text": "Staatsbibliothek zu Berlin Service Provider", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationDisplayName"
          }
        ], 
        "organization_url": [
          {
            "lang": "de", 
            "text": "http://staatsbibliothek-berlin.de", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&OrganizationURL"
          }
        ], 
        "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&Organization"
      }, 
      "contact_person": [
        {
          "given_name": {
            "text": "Jann-Gerd", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "jgh@sbb.spk-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Hans", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "administrative"
        }, 
        {
          "given_name": {
            "text": "Gerrit", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&GivenName"
          }, 
          "email_address": [
            {
              "text": "gerrit.gragert@sbb.spk-berlin.de", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EmailAddress"
            }
          ], 
          "sur_name": {
            "text": "Gragert", 
            "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SurName"
          }, 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&ContactPerson", 
          "contact_type": "technical"
        }
      ], 
      "spsso_descriptor": [
        {
          "assertion_consumer_service": [
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://erf.sbb.spk-berlin.de/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:1.0:profiles:browser-post", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://erf.sbb.spk-berlin.de/Shibboleth.sso/SAML/POST"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "key_descriptor": [
            {
              "use": "encryption", 
              "key_info": {
                "key_name": [
                  {
                    "text": "erf.sbb.spk-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=erf.sbb.spk-berlin.de,OU=Staatsbibliothek zu Berlin PK,O=STIFTUNG PREUSSISCHER KULTURBESITZ,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGCDCCBPCgAwIBAgIEDQQY/DANBgkqhkiG9w0BAQUFADCBsjELMAkGA1UEBhMC\nREUxDzANBgNVBAgTBkJlcmxpbjEPMA0GA1UEBxMGQmVybGluMSswKQYDVQQKEyJT\nVElGVFVORyBQUkVVU1NJU0NIRVIgS1VMVFVSQkVTSVRaMTAwLgYDVQQDEydTVElG\nVFVORyBQUkVVU1NJU0NIRVIgS1VMVFVSQkVTSVRaIC0gQ0ExIjAgBgkqhkiG9w0B\nCQEWE2NhQGh2LnNway1iZXJsaW4uZGUwHhcNMDgxMDAyMDk1OTA5WhcNMTMxMDAx\nMDk1OTA5WjCBpDELMAkGA1UEBhMCREUxDzANBgNVBAgTBkJlcmxpbjEPMA0GA1UE\nBxMGQmVybGluMSswKQYDVQQKEyJTVElGVFVORyBQUkVVU1NJU0NIRVIgS1VMVFVS\nQkVTSVRaMSYwJAYDVQQLEx1TdGFhdHNiaWJsaW90aGVrIHp1IEJlcmxpbiBQSzEe\nMBwGA1UEAxMVZXJmLnNiYi5zcGstYmVybGluLmRlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAsIo/QRLwUvAHXZ9FkD80W+O3HY9peAQExGGc2Ojzq7h8\n6Clq0sKVAFkXV4jJArtC8O4V+LVfL+/EHGLawi9Nps7UflkSjSNlK3Bu33I8ZZVJ\nwBxZG4/YrtuzZpz5KZ0sY3x4/HQCYxehVPdsdlgDx82O4yy3A2NSEryLZk0syX3m\nORB9V3soO/4QVs/avsc/N+pvcbmXCf8MT/XG5j0qdMYYqYenT8aG3YCmGF7d0e04\nME1kQ4QN+2tprrJuDslnIV6X/tMJGvRmayKyDCe+ORdWqFnZE9MxPhDj2gkR+Uf8\nRO5Ip552z/ZqbrAFHBwqokOLolu5MZ0fGbu/KeE1QwIDAQABo4ICMDCCAiwwCQYD\nVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUF\nBwMBMB0GA1UdDgQWBBT3xLOhGMK2vHK2JywZAkPJ2nJruTAfBgNVHSMEGDAWgBTn\np8hlJwW/CmNIRBlH2cq44OVQKTAmBgNVHREEHzAdgRtlcmYtYWRtaW5Ac2JiLnNw\nay1iZXJsaW4uZGUwgbcGA1UdHwSBrzCBrDBUoFKgUIZOaHR0cDovL2NkcDEucGNh\nLmRmbi5kZS9zdGlmdHVuZy1wcmV1c3Npc2NoZXIta3VsdHVyYmVzaXR6LWNhL3B1\nYi9jcmwvY2FjcmwuY3JsMFSgUqBQhk5odHRwOi8vY2RwMi5wY2EuZGZuLmRlL3N0\naWZ0dW5nLXByZXVzc2lzY2hlci1rdWx0dXJiZXNpdHotY2EvcHViL2NybC9jYWNy\nbC5jcmwwgdAGCCsGAQUFBwEBBIHDMIHAMF4GCCsGAQUFBzAChlJodHRwOi8vY2Rw\nMS5wY2EuZGZuLmRlL3N0aWZ0dW5nLXByZXVzc2lzY2hlci1rdWx0dXJiZXNpdHot\nY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MF4GCCsGAQUFBzAChlJodHRwOi8vY2Rw\nMi5wY2EuZGZuLmRlL3N0aWZ0dW5nLXByZXVzc2lzY2hlci1rdWx0dXJiZXNpdHot\nY2EvcHViL2NhY2VydC9jYWNlcnQuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQBDr6KA\n0mxhN6uvQwoQPTJxvSCzibyOIj2LpChEtewwWZxmrG6jmddag1iUPG8VsdB+Ocrn\nAuKmrZJhAJtmkH5YcdTA9l4kbNNgBBx4fkOsxsXgo5yMeX2V8OCCjdL+ZvMiv1ih\nf+PsEmREhK3MhoLa0R2jK69AYOM80uhc4Tw+T4tICXNLojudpnK4fiRnnaJ0JV2W\nvAuQQAnkXf7C5K9cPxzPE8zfL4OGMk1HkFRdZ6Cdw/NT2nquE9uoe6IiJbyHqVye\n7TQp8bbt4gXHGiMg4iKniIYBGa1hpT36g6UudpvjoKEmDWiy59bIYHSuH6E0O24L\ni+qpO2NCiiTGlah8", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }, 
            {
              "use": "signing", 
              "key_info": {
                "key_name": [
                  {
                    "text": "erf.sbb.spk-berlin.de", 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyName"
                  }
                ], 
                "x509_data": [
                  {
                    "x509_subject_name": {
                      "text": "CN=erf.sbb.spk-berlin.de,OU=Staatsbibliothek zu Berlin PK,O=STIFTUNG PREUSSISCHER KULTURBESITZ,L=Berlin,ST=Berlin,C=DE", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509SubjectName"
                    }, 
                    "x509_certificate": {
                      "text": "MIIGCDCCBPCgAwIBAgIEDQQY/DANBgkqhkiG9w0BAQUFADCBsjELMAkGA1UEBhMC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\ni+qpO2NCiiTGlah8", 
                      "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Certificate"
                    }, 
                    "__class__": "http://www.w3.org/2000/09/xmldsig#&X509Data"
                  }
                ], 
                "__class__": "http://www.w3.org/2000/09/xmldsig#&KeyInfo"
              }, 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&KeyDescriptor"
            }
          ], 
          "name_id_format": [
            {
              "text": "urn:mace:shibboleth:1.0:nameIdentifier", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&NameIDFormat"
            }
          ]
        }
      ]
    }
  ], 
  [
    "https://ci.nordu.net/shibboleth", 
    {
      "entity_id": "https://ci.nordu.net/shibboleth", 
      "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&EntityDescriptor", 
      "spsso_descriptor": [
        {
          "single_logout_service": [
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ci.nordu.net/Shibboleth.sso/SLO/SOAP"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ci.nordu.net/Shibboleth.sso/SLO/Redirect"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ci.nordu.net/Shibboleth.sso/SLO/POST"
            }, 
            {
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SingleLogoutService", 
              "location": "https://ci.nordu.net/Shibboleth.sso/SLO/Artifact"
            }
          ], 
          "protocol_support_enumeration": "urn:oasis:names:tc:SAML:2.0:protocol", 
          "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&SPSSODescriptor", 
          "assertion_consumer_service": [
            {
              "index": "0", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ci.nordu.net/Shibboleth.sso/SAML2/POST"
            }, 
            {
              "index": "1", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ci.nordu.net/Shibboleth.sso/SAML2/POST-SimpleSign"
            }, 
            {
              "index": "2", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 
              "__class__": "urn:oasis:names:tc:SAML:2.0:metadata&AssertionConsumerService", 
              "location": "https://ci.nordu.net/Shibboleth.sso/SAML2/Artifact"
            }, 
            {
              "index": "3", 
              "binding": "urn:oasis:names:tc:SAML:2.0:bindings:P