<?php
/**
 * German Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Norgaz Kurt, and Peter Pluntke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Norgaz Kurt
 * @author Peter Pluntke
 * @version $Id: help_text.de.php,v 1.65.2.7 2005/12/24 17:30:35 canajun2eh Exp $
 */

if (preg_match("/help_text\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
print "You cannot access a language file directly.";
exit;
}

// Arrow symbol or icon for up-page links on Help pages
$ImgSrc = $THEME_DIR."images/uarrow3.gif";
$UpArrow = "<b>^&nbsp;&nbsp;</b>";
if (file_exists($ImgSrc)) $UpArrow = "<img src=\"$ImgSrc\" class=\"icon\" border=0 alt=\"\">";

//-- GENERAL
$pgv_lang["help_header"]                        = "Informationen über:";
$pgv_lang["privacy_error_help"]			= "<b>PRIVATE DETAILS</b><br /><br />Es gibt verschiedene Gründe, warum Sie diese Nachricht angezeigt bekommen können:<br /><br /><b>1. Alle Daten von lebenden Personen sind als \"Privat\" eingestellt.<br />Unregistrierte oder nicht eingeloggte Besucher, können vollständige Informationen nur von verstorbenen Personen sehen. Sofern vom Administrator zugelassen, können Sie sich registrieren, indem Sie auf den Login Button klicken und anschließend den Link #pgv_lang[requestpassword]#.<br /><br /><b>2. Sie sind ein Benutzer mit Benutzername und Passwort...</b><br />aber Sie haben sich nicht erfolgreich angemeldet oder Sie haben zu lange keine Eingabe gemacht und wurden automatisch abgemeldet.<br /><br /><b>3. Aus Datenschutzgründen</b><br /> Manche Personen haben den Administrator eventuell gebeten, bestimmte Daten auf \"Privat\" zu setzen oder möchten überhaupt nicht in der Datenbank erscheinen.<br />Der Datenschutz kann folgende Werte annehmen:<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4. Außerhalb des \"Verwandschafts-Pfades\"</b><br />Auch wenn Sie ein regulär <b>angemeldeter</b> Benutzer sind, kann es vorkommen, dass Sie diese Nachricht erhalten, wenn Sie Daten einer Person ansehen möchten, die mit Ihnen in einer größeren Anzahl von Verwandtschafts-Schritten verwand ist als der Administrator zugelassen hat (Verwandschafts-Pfad-Länge).<br />Beispiele<br />Wenn die Länge des Verwandtschafts-Pfades auf <b>1</b> gesetzt ist, können Sie nur Daten Ihrer eigenen Familie, Vater, Mutter, Geschwister (aber nicht die Ehepartner oder Kinder Ihrer Geschwister) sehen.<br /><br />Wenn die Länge auf <b>2</b> eingestellt ist, können Sie auch die Daten der Ehepartner Ihrer Geschwister und deren Kindern sehen (aber nicht die Ehepartner deren Kinder).<br />Je länger der Verwandtschaftspfad eingestellt ist, umso weiter entferntere Verwandte können Sie im Detail sehen.<br /><br />Wenn Sie glaube, Sie sollten das Recht haben, bestimmte Daten zu sehen, kontaktieren Sie den Administrator über den \"Kontakt\"-Link auf der Seite.";
$pgv_lang["more_help"]				= "<br />Wenn Sie auf allen Seiten die Kontexthilfe aktivieren möchten, stellen Sie bitte sicher, dass die <b>#pgv_lang[show_context_help]#</b> (im Hilfe Menü) aktiviert wurde und klicken Sie auf das <b>?</b> neben dem gewünschten Objekt.<br />";
$pgv_lang["more_config_help"]			= "<br /><b>Weitere Hilfe</b><br />Weitere Hilfe finden Sie im Formular. Bitte klicken Sie auf das <b>?</b> hinter der Beschriftung.<br />";
$pgv_lang["start_admin_help"]			= "+++ Beginn zusätzliche Informationen für Administratoren +++";
$pgv_lang["end_admin_help"]			= "--- Ende zusätzliche Informationen für Administratoren ---";
$pgv_lang["multiple_help"]			= "<center>--- Dies ist ein allgemeiner Hilfetext, der mehrere Seiten betrifft ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>ALLGEMEINE INFORMATIONEN</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~Ihr Bildschirm~<br />PhpGedView wurde entickelt für eine Bildschirmauflösung von 1024x768 Pixeln.<br />Die ist die minimale Auflösung, in der alles optimal dargestellt wird.<br />Wenn Sie eine niedrigere Auflösung verwenden (z.B. 800x600 Pixel.), werden Sie horzontal scrollen müssen, um alles zu sehen.<br />";
$pgv_lang["preview_help"]			= "~Drucken~<br />Wenn Sie auf den \"Druck-optimierte Version\"-Link klicken, wird alles, was für einen Audruck irrelevant bzw. unschön ist (Menüs, Eingabefelder, zusätzliche Links, die Fragezeichen der Kontexthilfe etc.), ausgelassen.<br />In der \"Druck-optimierten Version\" erscheint der Link <b>Drucken</b> am unteren Seitenrand. Klicken Sie einfach darauf und das Druck-Dialogfenster öffnet sich.<br />Nach dem Drucken klicken Sie einfach auf den <b>zurück</b> Link und der Bildschirm wird wieder in der normalen Ansicht neu aufgebaut.<br /><br />Anmerkung: Die \"Druck-optimierte Version\" entfernt einige Links vom Bildschirm, die vebleibenden Links sind aber noch funktionsfähig.<br />";
$pgv_lang["readme_help"]			= "<center>In der Datei <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> finden Sie weitere Informationen.</center>";
$pgv_lang["is_user_help"]			= "--- Dieser Hilfe Text ist identisch mit dem Hilfetext für Besucher. --- <br />--- Um Platz zu sparen, gibt es zu diesem Thema keine spezielle Hilfe für Administratoren. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~GEDCOM ROHDATEN EDITIEREN~<br /><br />Wenn Sie auf diesen Link klicken, öffnet sich ein weiteres Fenster, das die GEDCOM-Rohdaten zu den Informationen dieser Seite anzeigt.<br />Dort können Sie die GEDCOM-Rohdaten direkt editieren. Achten Sie darauf, dass Ihre Eingaben dem GEDCOM 5.5 Standard entsprechen; es finden nämlich keine Gültigkeitsprüfungen für Ihre Eingaben statt.<br />Die veränderten bzw. hinzugefügten Daten werden in PhpGedView als Änderungen angezeigt und müssen anschließend von einem Benutzer akzeptiert werden, der die dafür notwendigen Rechte besitzt.";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~DIE BEGRÜSSUNGS SEITE~<br /><br />Dies ist die Begrüßungs-Seite. Sie heißt Sie auf der ausgewählten  <a href=\"#def_gedcom\">GEDCOM</a-Datei-Seite willkomen. Sie gelangen zurück auf diese Seite über den Begrüßungs-Seite-Link in der oberen Menüleiste. Wenn mehrere GEDCOM-Dateien auf dieser Seite hinterlegt sind, können Sie eine davon über das Drop-Down-Menü auswählen.<br /><b>Diese Seite enthält Informationen über:</b> (da dies die Haupt-Seite von PhpGedView ist)<ul><li><a href=\"#index_portal\">Begrüßungs-Seite</a><li><a href=\"#header\">Kopfbereich</a><li><a href=\"#menu\">Menüs</a><li><a href=\"#header_general\">Allgemeine Informationen</a><li><a href=\"#def\">Definitionen</a></ul><br />Version #VERSION# enthält einen neuen Look für <a href=\"#def_pgv\">PhpGedView</a>. Die Menüs, die Startseite und viele andere Leistungsmerkmale wurden verbessert oder erneuert.<br /><br />";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>KOPFBEREICH</b></center></div><br />Der Kopfbereicht wird im oberen Teil jeder Seite angezeigt.<br />Der Kopfbereich enthält einige hilfreiche Links, die die gesamte Seite beeinflussen können.<br />Da die Seite durch die Auwahl verschiedener <a href=\"#def_theme\">Themes</a> variieren kann, enthält der Kopfbereich je nach gewähltem Theme eventuell unterschiedliche Links.<br /><br /><b>Links, die vorkommen können, sind:</b><ul><li><a href=\"#header_search\">Suche-Feld</a><li><a href=\"#header_lang_select\">Sprachauswahl</a><li><a href=\"#header_user_links\">Benutzer-Links</a><li><a href=\"#header_favorites\">Lesezeichen</a><li><a href=\"#header_theme\">Theme wechseln</a></ul>";
$pgv_lang["header_search_help"]			= "~Kopfbereich: Suche~<br />Diese Such-Box ist klein aber leistungsstark.<br />Sie können fast alles eingeben und das Programm danach suchen lassen. Wenn Sie den Button \"<b>></b>\" oder <b>Suchen</b>-Button anklicken, gelangen Sie auf die Such-Hauptseite, wo Sie die Ergebnisse Ihrer Suche sehen können.<br />Sie finden weitere Hilfe auf der Such-Hauptseite.<br />";
$pgv_lang["header_lang_select_help"]		= "~Kopfbereich: Sprachauswahl~<br />Eines der wichtigsten Leistungsmerkmale dieses Programmes ist der automatische Wechsel der Sprache, passend zur Browser-Spracheinstellung des jeweiligen Besuchers.<br />Manchmal kann diese automatische Einstellung aber zu einer unerwünschten Spracheinstellung führen.<br />Der Besucher kann dann manuell mittels der <b>Sprachauswahl</b><br /> die Sprache umschalten. Die Sprachauswahl kann in 2 Arten angezeigt werden:<br />1. \"Drop down\"-Liste.<br />2. Eine Leiste von bunten Nationalflaggen.<br /> ";
$pgv_lang["header_user_links_help"]		= "~Kopfbereich: Benutzerlinks~<br />Die Benutzerlinks sind eine kleine Gruppe von hilfreichen Links, die auf jeder Seite an der gleichen Stelle erscheinen (sofern das Theme nicht gewechselt wird).<br />Wenn Sie noch nicht angemeldet sind, dann sehen Sie nur den <b>Login</b> Link.<br />Wenn Sie eingeloggt sind, erscheint: <b>Angemeldet als (Ihr Benutzername)</b>. Klicken Sie auf diesen Link, um zu Ihren Benutzereinstellungen zu gelangen.<br />Klicken Sie <b>Logout</b>, um sich abzumelden.<br />Wenn Sie Administrator sind, sehen Sie außerdem den <b>Verwalten</b>-Link. Klicken Sie darauf, um direkt auf die Konfigurations-Seite zu gelangen.<br />";
$pgv_lang["header_favorites_help"]		= "~Kopfbereich: Meine Lesezeichen~<br />Diese drop down Liste zeigt Ihnen Ihre Lesezeichen, sofern Sie welche erstellt haben. Sie zeigt auch die Lesezeichen, die der Administrator für die GEDCOM-Datei erstellt hat.<br />Wenn Sie auf eines Ihrer Lesezeichen klicken, so gelangen Sie auf die Seite mit persönlichen Informationen zur jeweiligen Person.<br />Weitere Hilfe zum Erstellen von Lesezeichen finden Sie unter Ihrem persönlichen Portal.<br />";
$pgv_lang["header_theme_help"]		= "~Kopfbereich: Theme wechseln~<br />Sofern vom Administrator aktiviert, zeigt die \"Theme wechseln\" Dropdown-Liste alle vorhandenen Themes, von denen Sie eines auswählen können. Das Theme bestimmt das Aussehen der Seite. Wenn Sie angemeldet sind, so ändern Sie mit Ihrer Auswahl im Kopfbereich auch das Theme, das üblicherweise nach Ihrer Anmeldung erscheint.<br />";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class=\"name_head\"><center><b>MENÜS</b></center></div><br />Oben auf der Seite gibt es nun verschiedene (Dropdown) Menüpunkte.<br />Wenn Sie mit dem Mauszeiger über die Menüpunkte fahren, öffnet sich ein Untermenü, sofern der Menüpunkt Unterpunkte enthält.<br />Klicken Sie auf einen Hauptmenüpunkt, so entspricht das einem Klick auf den obersten Untermenüpunkt.<br /><br /><b>Sie können aus den folgenden Haupt-Menüpunkten auswählen:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">Mein GedView Portal</a><br /><li><a href=\"#menu_charts\">Diagramme</a><br /><li><a href=\"#menu_lists\">Listen</a><br /><li><a href=\"#menu_annical\">Jahrestag Kalendar</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">Suche</a><br /><li><a href=\"#menu_help\">Hilfe</a></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Begrüßungs-Seite~<br />Alle verfügbaren GEDCOM-Dateien, werden in diesem Menü aufgeführt.<br />Jede GEDCOM-Datai hat Ihre eigene Startseite, so wie diese hier.<br />Wenn nur eine GEDCOM-Datei auf dieser Seite vorhanden ist, gibt es kein Untermenü für den Menüpunkt \"Begrüßungs-Seite\".<br />";
$pgv_lang["menu_myged_help"]			= "~Mein GedView Portal~<br />Wenn Sie sich angemeldet haben, kann das Menü folgende Unterpunkte beinhalten:<dl><dt>Mein GedView Portal</dt><dd>Führt Sie zu Ihrer eigenen konfigurierbaren \"Startseite\".</dd><dt>Eigene Benutzerdaten bearbeiten</dt><dd>Hier können Sie Ihre persönlichen Daten einstellen.</dd><dt>Mein Stammbaum</dt><dd>Wenn Sie eine Startperson für diese GEDCOM-Datei gewählt haben, führt Sie dieser Link zum Stammbaum-Diagramm dieser Person.</dd><dt>Mein Datenblatt</dt><dd>Dieser Link führt Sie zu der Seite mit persönlichen Informationen über Sie selbst, auf der die genealogischen Daten zu Ihrer Person und Ihrer Familie dargestellt wird.</dd></dl>";
$pgv_lang["menu_charts_help"]			= "~Diagramme~<br />Alle verfügbaren Diagramme sind in diesem Menü zu finden:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Führt Sie zum Stammbaum-Diagramm dieser GEDCOM-Datei. Der Stammbaum geht von der Startperson der GEDCOM-Datei aus. Wenn Sie eingeloggt sind, können Sie die Starperson für diesen Menüpunkt selbst auswählen.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Der Nachfahrenbaum ist vergleichbar mit einem umgekehrten <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.<br />Dieser Vergleich hinkt zwar, aber während der Stammbaum alle Vorfahren einer Person zeigt, zeigt der Nachfahrenbaum alle Nachfahren dieser Person.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Die Erlebnisse einer Person werden entlang einer Zeitleiste dargestellt.<br />Es kann sehr interessant sein, die Ereignisse im Leben von 2 oder mehr Personen innerhalb einer Zeitleiste zu vergleichen.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Hier können Sie die Verwandtschaft einer Person zu Ihnen selbst oder zu einer anderen Person bestimmen.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Ähnelt sehr dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, zeigt aber mehr Detailinformationen und verschiedene <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#en</a>.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Ähnelt sehr dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, aber ist eine eher graphische Darstellung.</dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Listen~<br />Dieses Menü führt Sie zu den vefügbaren Listen:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>In diesen beiden Listen können Sie alphabetisch nach Personen suchen.<br />Die erste zeigt eine Liste von Personen, die zweite von Familien an.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Dieser Menüpunkt erstellt eine Liste aller Quellen, die in dieser GEDCOM-Datei vorkommen.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Hier können Sie über Orte nach Personen suchen. Eine 2-spaltige Liste wird dabei erstellt: Die Personen werden links aufgezählt, die Familien rechts.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Dieser Menüpunkt erscheint nur, wenn der Administrator ihn aktiviert hat.<br />Er führt zu einer Liste mit allen Multimedia-Dateien, die in dieser GEDCOM-Datei vorkommen.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~Jahrestag Kalender~<br />Der Jahrestag-Kalender zeigt alle Ereignisse einer GEDCOM-Datei für ein bestimmtes Datum, einen Monat oder ein Jahr an.<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Klicken Sie hierauf, so erhalten Sie einen Jahrestagkalender, der die Ereignisse des heutigen Tages anzeigt.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Führt Sie zu einem Monats-Kalender, der die Ereignisse des aktuellen Monats anzeigt.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Führt Sie zu einem Jahrestagkalender, der die Ereignisse des ausgewählten Jahres anzeigt.</dd></dl>";
$pgv_lang["menu_clip_help"]			= "~Ausschnittssammelbehälter~<br />Sofern durch den Administrator aktiviert, erscheint dieser Menüpunkt in der Menüleiste.<br />Der Ausschnittssammelbehälter ermöglicht das Zusammenstellen von Daten über Personen, Familien und Quellen zum anschließenden Download im GEDCOM 5.5 Format.<br /><br />";
$pgv_lang["menu_search_help"]			= "~Suche~<br />Die Such-Seite, auf die Sie gelangen, wenn Sie diesen Link anklicken, ist der leistungsfähigere Bruder des Suchfeldes im Kopfbereich.<br /><br />";
$pgv_lang["menu_help_help"]			= "~Hilfe~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>DIE BEGRÜSSUNGS-SEITE</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "Die Begrüßungs-Seite besteht aus mehreren einzelnen Blöcken, die vom Administrator zusammengestellt werden. Für jede GEDCOM-Datei auf dieser Seite (sofern hier mehrere GEDCOM-Dateien vorhanden sind), kann eine eigene Begrüßungs-Seite erstellt werden.<br /><br /><b>Je nach Einstellung durch den Administrator, kann die Begrüßungs-Seite eine Auswahl der folgenden Blöcke enthalten:</b><ul><li><a href=\"#index_welcome\">Willkommen</a><li><a href=\"#index_login\">Login</a><li><a href=\"#index_events\">Bevorstehende Ereignisse</a><li><a href=\"#index_onthisday\">An diesem Tag in Ihrer Chronik</a><li><a href=\"#index_favorites\">GEDCOM Lesezeichen</a><li><a href=\"#index_stats\">GEDCOM Statistik</a><li><a href=\"#index_common_surnames\">Häufigste Nachnamen</a><li><a href=\"#index_media\">Zufällig ausgewähltes Bild</a><li><a href=\"#index_loggedin\">Angemeldete Benutzer</a><li><a href=\"#gedcom_news\">GEDCOM Neuigkeiten</a><li><a href=\"#recent_changes\">Aktuelle Änderungen</a></ul>";
$pgv_lang["index_welcome_help"]			= "~WILKOMMEN~<br />Der Willkommen Block zeigt Ihnen:<br />Die aktive GEDCOM-Datei, das Datum und die Uhrzeit (sofern vom Administrator aktiviert), den <b>Besucher Zähler</b>.<br />Dieser Besucher Zähler wird nur im Willkommen-Block und auf der persönlichen Seite angezeigt.<br />Der Zähler zählt die Zugriffe auf diese Seiten. Das heißt, er zeigt an, wie oft diese Seiten besucht wurden.<br />Der Zähler überprüft nicht die Rechneradresse des Besuchers, d.h. wenn dieser Besucher nach einer Weile die Seite erneut aufruft, so wird das als neuer Zugriff gezählt.<br />";
$pgv_lang["index_login_help"]			= "~LOGIN~<br />Obwohl Sie sich auf fast jeder Seite anmelden können, werden Sie das üblicherweise auf der ersten Seite tun, weil Sie eventuell verborgene private Informationen nur nach der Anmeldung sehen können.<br />Tragen Sie hierzu Ihren <b>Benutzernamen</b> und Ihr <b>Passwort </b> ein und klicken Sie auf den Login Button.<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]			= "~BEVORSTEHENDE EREIGNISSE~<br />Dieser Block zeigt Ereignisse vom heutigen Tag bis einen Monat im voraus.<br />";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Diese Option erlaubt es Ihnen zu bestimmen, welche Medientypen gezeigt werden können.<br /><br />Wenn Sie <b>#pgv_lang[random_media_persons]#</b> wählen, werden nur Medien, die mit Personen assoziiert sind, gezeigt. Normalerweise sind das Fotos. Wenn Sie  <b>#pgv_lang[random_media_events]#</b> wählen, werden nur Medien, die mit Fakten oder Ereignissen assoziiert sind, gezeigt. Das könnten Abbilder von Urkunden sein. Wenn Sie <b>#pgv_lang[all]#</b> wählen, zeigt dieser Block alle Medientypen.";
$pgv_lang["index_onthisday_help"]		= "~AN DIESEM TAG IN IHRER CHRONIK~<br />Dieser Block arbeitet ähnlich wie der Block \"Bevorstehende Ereignisse\", nur dass Ereignisse angezeigt werden, die sich am heutigen Tage jähren.<br />";
$pgv_lang["index_favorites_help"]		= "~STAMMBAUM-LESEZEICHEN~<br />Der Stammbaum-Lesezeichen Block entspricht weitestgehend dem \"Meine Lesezeichen\"-Bereich auf dem MeinGedView Portal. In diesem Fall aber kann nur der Administrator die Lesezeichen für die GEDCOM-Datei verwalten.<br />So kann er auf besondere Persönlichkeiten in der GEDCOM-Datei aufmerksam machen.<br />Auf jeder Seite erreichen Sie die \"Stammbaum-Lesezeichen\" über eine Drop-Down-Liste im Kopfbereich.<br />Über diese Links gelangen Sie jeweils auf die Seite mit persönlichen Informationen der angeklickten Person.<br /><br />Um Platz zu sparen, werden in den Boxen nicht alle Informationen angezeigt. Rechts in der Box sehen Sie ein Lupen-Symbol, mit dem Sie weitere Informationen anzeigen lassen können.<br />Wenn Sie auf den Namen klicken gelangen Sie auf die Seite mit persönlichen Informationen.<br />Weiterhin befindet sich rechts in der Box ein Menü mit Links zu weiteren Informationen und Diagrammen.<br />";
$pgv_lang["index_stats_help"]			= "~GEDCOM STATISTIK~<br />Dieser Block zeigt einige statistische Daten über die aktuelle GEDCOM-Datei an.<br />Falls Sie weitere Informationen benötigen, senden Sie eine Nachricht an die Kontaktadresse am unteren Rand der Seite.<br /><br />";
$pgv_lang["index_common_names_help"]		= "~HÄUFIGSTE NACHNAMEN~<br />Hier werden Nachnamen, die in der GEDCOM-Datei vorkommen, angezeigt. Die Anzahl der dargestellten Namen kann vom Administrator festgelegt werden.<br />(Derzeit werden alle Namen angezeigt, die mindestens #COMMON_NAMES_THRESHOLD# Mal in der Datei vorkommen.)<br /><br />Die Namen kann man anklicken. Wenn Sie auf einen Namen klicken, gelangen Sie zur #pgv_lang[individual_list]#, wo Sie genauere Informationen zu diesem Namen erhalten.";
$pgv_lang["index_media_help"]			= "~ZUFÄLLIGES BILD~<br />Bei jedem Besuch der Seite, zeigt dieser Block ein anderes Bild oder eine andere Multimedia-Datei an.<br />Wenn Sie auf das Bild oder seinen Namen klicken, sehen Sie eine Darstellung in Originalgröße.<br /> Unterhalb vom Bild gibt es einen Link zur Person, mit der das Bild verbunden ist.<br />Klicken Sie auf den Namen dieser Person, um zur persönlichen Seite der Person zu gelangen.<br />";
$pgv_lang["index_loggedin_help"]		= "~ANGEMELDETE BENUTZER~<br />Dieser Block zeigt wie viele Benutzer zur Zeit angemeldet sind.<br />";
$pgv_lang["index_gedcom_news_help"]		= "~GEDCOM NEUIGKEITEN~<br />Der \"Neuigkeiten\"-Block ist so etwas wie ein \"schwarzes Brett\" für diese GEDCOM-Datei.<br />Der administrator kann wichtige Ankündigungen oder interessante Neuigkeiten hier bekanntgeben.<br /><br />Wenn Sie etwas Interessantes veröffentlichen möchten, kontaktieren Sie bitte den Administrator, der Ihre Meldung dann platzieren kann.";
$pgv_lang["index_gedcom_news_adm_help"]		= "In diesem Block können Sie <b>HTML tags</b> einfügen.<br />Bitte achten Sie darauf, die Start- und End-Tags korrekt einzutragen.<br /><br />Dieses Programm verwendet <b>Style Sheets (CSS)</b>. Jedes Theme hat seine eigene style sheet-Datei.<br />Sie können auch \"Klassen\" aus diesen Style-Sheets verwenden.<br /><br />Wenn Sie weitere Hilfe benötigen: Auf der PhpGedvView Webseite werden Sie einige Beispiele finden, wie Sie solche Tags in Ihren eigenen Blöcken verwenden.<br />";
$pgv_lang["recent_changes_help"]			= "~AKTUELLE ÄNDERUNGEN~<br />Dieser Block zeigt Ihnen die jüngsten Änderungen in der GEDCOM-Datei, die anhand des CHAN-tags erkannt werden.<br />";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Natürlich wäre der Idealfall ein Programm, das so einfach zu benutzen ist, dass man keine Erklärungen benötigt.<br />Es sollte so einfach sein, wie ein Buch zu lesen.<br />Aber obwohl dieses Programm recht kompliziert und leistungsstark ist, sollte man das am Benutzerinterface kaum bemerken. Fast alles kann ohne Erklärungen benutzt werden.<br />Aber weil es sicherlich auch viele Ahnenforscher gibt, die noch wenig Erfahrungen mit Computern oder dem Internet haben, steht dieses Hilfesystem bereit.<br />Im Hilfe-Menü stehen folgende Punkte zur Verfügung:<br />";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Hilfe zu dieser Seite</b></dt><dd>Für alle Seiten gibt es eine allgemeine \"Hilfe für diese Seite\".<br />Wenn Sie auf einer beliebigen Seite sind, klicken Sie auf diesen Menüpunkt, um die \"Seitenhilfe\" zu erhalten, die Sie über die Objekte informiert, die Sie auf dieser Seite finden.<br />Die Seitenhilfe ist in den meisten Fällen kurz gehalten.<br />Wenn Sie mehr Hilfe benötigen, oder Informationen über ein bestimmtes Objekt auf der Seite, dann sollten Sie die 3. Option des Hilfemenüs beachten: Die \"Kontext-bezogene Hilfe\".</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>Hilfe Inhalt</b></dt><dd>Wenn Sie auf diesen Menüpunkt klicken, öffnet sich ein Popup-Fenster, das einen Index der Haupt-Hilfethemen enthält.<br />Dieser Index wird in naher Zukunft noch um die Hilfe-Unterthemen erweitert werden.</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Kontext-bezogene Hilfe anzeigen/verbergen</b></dt><dd>Dieser letzte Menüpunkt kann sehr hilfreich sein. Wenn Sie diesen Link anklicken, wird die \"Kontext-Hilfe\" ein- bzw. ausgeschaltet.<br /> Was ist \"Kontext-Hilfe\" ?<br />Wenn sie aktiviert ist, sehen Sie ein Fragezeichen rechts neben einigen Links, drop-down Boxen oder Buttons. Wenn Sie auf dieses <b>?</b> klicken, erscheint ein kleines Popup-Fenster mit weiteren Informationen zu diesem Objekt.<br />Wenn Sie auf \"Kontext-bezogene Hilfe verbergen\" klicken, werden alle diese Fragezeichen verborgen, bis Sie auf \"Kontext-bezogene Hilfe anzeigen\" klicken.</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>DEFINITIONEN</b></center></div><br />Einige Erklärungen zu Begriffen in diesem Hilfetext:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Daten</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Portal</a><li><a href=\"#def_theme\">Theme</a></ul>";
$pgv_lang["def_portal_help"]			= "~Portal~<br />Auf dieser Webseite ist das Portal so etwas wie ein Empfang im Hotel. Es ist der Ausgangspunkt für Ihren Besuch auf dieser Seite, der auch wichtige Informationen, Erklärungen und Menüs etc. enthält.<br />";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM Datei~<br />Eine GEDCOM-Datei ist eine Datei, die alle Informationen über einen Stammbaum enthält.<br />Alle Ereignisse, Daten, Namen usw. werden in einer GEDCOM-Datei gespeichert.<br />Eine GEDCOM-Datei enthält diese Daten nach einer strengen Syntax, damit Sie austauschbar bleibt, unabhängig von dem verwendeten Programm, dem Betriebssystem oder benutzten Rechner.<br />";
$pgv_lang["def_gedcom_date_help"]		= "~Datumsangaben in einer GEDCOM-Datei~<br />Da die Datumsangaben innderhalb einer GEDCOM-Datei internationalen Regeln folgen müssen, gibt es eine einheitliche Schreibweise dafür.<br /><br />Obwohl das Datums-Feld freie Texteingabe erlaubt, sollten Sie folgende Beschreibungen beachten:<br />Ein vollständiges Datum wird (immer in Englisch!) angegeben als \"DD MMM YYYY\" also:<br />01 Mar 1801 oder 14 Dec 1950<br />Wenn Ihnen eine Information teilweise fehlt, so können Sie sie einfach auslassen:<br />Mar 1801 oder 14 Dec<br />Wenn Sie nicht ganz sicher sind, oder das Datum nur ungefähr bekannt ist, können Sie es wie folgt angeben:<br />abt Mar 1801 (abt = about, d.h. ungefähr)<br />bef 20 Dec 1950 (bef = before, d.h. vor)<br />aft 1949 (aft = after, d.h. nach)<br />Achten Sie darauf, die Daten und die Abkürzungen in Englisch einzutragen, damit die GEDCOM-Datei austauschbar bleibt und alle Programme Ihre Angaben korrekt interpretieren können.<br />Das Programm stellt mit Ihren Datumsangaben auch Berechnungen an. Wenn Daten also fehlerhaft eingegeben wurden, wird das Programm falsche Rechenergebnisse liefern.<br />";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (oder PGV) ist ein Program, entwickelt von John Finlay, um GEDCOM Dateien im Internet zu betrachten.<br />Wie Sie sehen stellt dieses Programm nicht nur statische Seiten ins Internet, sondern arbeitet dynamisch und kann in vielen Bereichen angepasst werden.<br />John begann die Entwicklung alleine aber inzwischen arbeitet ein internationales Team von Entwicklern und Übersetzern zusammen, um dieses Programm zu verbessern.<br />Außer dem bloßen Betrachten von GEDCOM-Dateien, kann der Benutzer nun auch Ereignisse online hinzufügen oder editieren.<br />";
$pgv_lang["def_theme_help"]			= "~Theme~<br />Diese Seite kann unterscheidlich aussehen (in Bezug auf Farben, Anordnung der Elemente etc.), was durch sogenannte Themes erreicht wird.<br />Der Administrator wählt zunächst ein Standard-Theme aus.<br />So sieht die Seite zunächst einmal für jeden Besucher gleich aus. Sofern vom Administrator so eingestellt, können Besucher aber auch ihr Lieblings-Theme aus einer Liste vorhandener Themes auswählen.<br />Wenn ein Benutzer sein bevorzugtes Theme ausgewählt hat, so erscheint die Seite für ihn in diesem Aussehen, sobald er sich angemeldet hat.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[upper_mygedview]#~<br />Dies ist Ihre persönliche #pgv_lang[mgv]#-Seite.<br />Sie finden hier Links zu Ihren persönlichen Daten wie <b>Meine Benutzerdaten, Mein Datenblatt</b> (das ist die Seite mit Informationen zu Ihrer Person), <b>Mein Stammbaum</b>.<br />Außerdem können hier die Blöcke <b>Nachrichten</b>, <b>Journal</b> (wie ein Notizbuch) und weitere enthalten sein.<br /><br />Das Layout dieser Seite entspricht dem der Begrüßungs-Seite.<br />Während die Begrüßungs-Seite vom Adminstrator zusammengestellt wird, können Sie diese Seite selbst zusammenstellen.<br /><br />Im Willkommens-Block auf dieser Seite finden Sie den Link zum Konfigurieren dieser Seite.<br /><br /><b>Sie können folgende Blöcke auswählen:</b><ul><li><a href=\"#mygedview_welcome\">Willkommen</a><li><a href=\"#mygedview_customize\">Mein GedView Portal anpassen</a><li><a href=\"#mygedview_message\">Nachrichten</a><li><a href=\"#mygedview_events\">Bevorstehende Ereignisse</a><li><a href=\"#mygedview_onthisday\">An diesem Tag in Ihrer Chronik</a><li><a href=\"#mygedview_favorites\">Meine Lesezeichen</a><li><a href=\"#mygedview_stats\">GEDCOM Statistik</a><li><a href=\"#mygedview_myjournal\">Mein Journal</a><li><a href=\"#mygedview_media\">Zufällig ausgewähltes Bild</a><li><a href=\"#mygedview_loggedin\">Angemeldete Benutzer</a><li><a href=\"#mygedview_recent_changes\">Aktuelle Änderungen</a></ul>";
$pgv_lang["mygedview_customize_help"]		= "~Mein GedView-PORTAL ANPASSEN~<br />Wenn Sie das erste Mal auf die Mein GedView-Seite kommen, sind schon einige Blöcke vorhanden.<br />Wenn Sie möchten, können Sie das Portal anpassen.<br />Klicken Sie auf diesen Link und Sie gelangen zu einem Formular in einem Popup-Fenster, in dem Sie Blöcke hinzufügen, löschen oder verschieben können.<br />Weitere Hilfe finden Sie in diesem Formular.<br />";
$pgv_lang["mygedview_message_help"]		= "~NACHRICHTEN~<br />In diesem Block finden Sie die Nachrichten, die Ihnen von anderen Benutzern oder dem Administrator zugesandt wurden.<br />Natürlich können Sie auch selbst Nachrichten an andere Benutzer schicken.<br />Dieses Mail-System unterstützt den Schutz Ihrer persönlichen Daten. Da Sie Ihre E-Mail-Adresse nicht angeben müssen können andere sie auch nicht sehen.<br /><br />Um eine Nachricht anzuzeigen, klicken Sie auf die Betreffzeile oder das \"+\" Zeichen neben der Nachricht. Sie können mehrere Dateien auf einmal löschen, indem Sie die Kästchen neben den Nachrichten markieren und auf \"Ausgewählte Nachrichten löschen\" klicken.<br />";
$pgv_lang["mygedview_favorites_help"]		= "~MEINE LESEZEICHEN~<br />Meine Lesezeichen arbeitet genauso wie gewöhnliche Lesezeichen.<br />Angenommen Sie haben jemanden in Ihrem Stammbaum, dessen Eintrag Sie regelmäßig überprüfen möchten.<br />Gehen Sie einfach auf die Seite mit den persönlichen Informationen dieser Person und wählen Sie \"Lesezeichen hinzufügen\" aus dem drop-down Menü \"Meine Lesezeichen\". Auf diese Person haben Sie nun ein Lesezeichen gesetzt, das in der Liste Ihrer Lesezeichen auftaucht.<br />Gleich auf welcher Seite in PhpGedView Sie sich befinden, Sie können immer auf einen Namen aus der Dropdown-Liste \"Meine Lesezeichen\" klicken.<br />Dann gelangen Sie auf die Seite mit persönlichen Informationen zu dieser Person.<br /><br />Um Platz zu sparen, werden die Boxen mit eingeschränkten Informationen angezeigt. An der rechten Seite der Namens-Box sehen Sie ein Lupen-Symbol, mit dem Sie weitere Informationen einblenden können.<br />Wenn Sie auf den Namen klicken, gelangen Sie auf die Seite mit den persönlichen Informationen dieser Person.<br />Auf der rechten Seite befindet sich außerdem ein Menü, das Sie zu Seiten mit weiteren Informationen oder Diagrammen führt.<br />";
$pgv_lang["mygedview_myjournal_help"]		= "~MEIN JOURNAL~<br />Sie können dieses Portal benutzen, um Notizen (oder Erinnerungen) für Ihren eigenen Gebrauch aufzuschreiben.<br />Diese Notizen stehen Ihnen natürlich auch noch zur Verfügung, wenn Sie die Seite das nächste Mal besuchen.<br /><br />Diese Notizen sind für andere nicht einsehbar.<br />";
$pgv_lang["mygedview_welcome_help"]		= "~WILKOMMEN~<dt>Dieser Wilkommen-Block zeigt Ihnen:</dt><dd>- Die aktuelle GEDCOM-Datei</dd><dd>- Das Datum und die Uhrzeit</dd><dd>- Links zu:</dd><dd>- - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (siehe Anmerkung)</dd><dd>- - #pgv_lang[my_indi]# (siehe Anmerkung)</dd><dd>- - #pgv_lang[customize_page]#</dd><br /><b>Anmerkung</b><br />Sie sehen die Links zu \"Mein Datenblatt\" und \"Mein Stammbaum\" nur, wenn Sie selbst als Person in der GEDCOM-Datei vorkommen.<br />Daher kann es je nach gewählter GEDCOM-Datei vorkommen, dass diese Links vorhanden sind oder fehlen.<br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~DIE STAMMBAUM SEITE~<br /><br />Die meisten Besucher wissen was ein Stammbaum ist, aber dennoch gibt es wichtige Zusatzinformationen zu diesem Stammbaum:<br />Dieser Stammbaum ist im wesentlichen eine Aufzählung aller Vorfahren der Ausgangsperson.<br />Wenn Sie diese Seite aus dem Hauptmenü aufrufen, sehen Sie die Startperson in der Box ganz links (wenn Sie angemeldeter Benutzer sind, können Sie diese Startperson auch verändern).<br /><br />\"Alle Vorfahren\" bedeutet also Vater und Mutter, deren Eltern usw.<br />Auf dieser Seite sehen Sie den Stammbaum als graphische Darstellung.<br />Sie müssen nicht durch Seiten voller Text blättern, um Ihre Vorfahren zu finden.<br />Jede Person wird in einer Namens-Box dargestellt.<br /><br />* DIE PERSONEN BOXEN DES STAMMBAUMS<br />Wenn Sie \"Details zeigen\" gewählt haben, so werden einige Grundinformationen (sofern bekannt, z.B. Geburtsdatum) über jede Person in ihrer Box angezeigt.<br />Sie können auf den Namen einer Person klicken, um zur Seite mit den persönlichen Details dieser Person zu gelangen.<br />Wenn Sie \"Details zeigen\" gewählt haben, erscheinen 2 Symbole in der Namens-Box.<br /><br />* STAMMBAUM SYMBOL IN DER NAMENS-BOX<br />Wenn Sie \"Details zeigen\" gewählt haben, sehen Sie ein Stammbaum-Symbol in der Namens-Box. Je nach Einstellung müssen Sie mit der Maus darüberfahren oder darauf klicken, um ein Menü zu öffnen.<br />Der \"Stammbaum\" und der \"Nachfahren-Baum\" entsprechen denen im Hauptmenü, wobei die Start-Person dann diejenige ist, in deren Box Sie auf das Symbol geklickt haben.<br />Außerdem sehen Sie den Link \"Familie mit Ehepartner\". Sie sehen den Namen des Ehepartners gefolgt von den Namen der Kinder.<br />Alle Namen können angeklickt werden.<br /><br />* LUPEN-SYMBOL IN DEN BOXEN<br />Je nach Einstellung müssen Sie mit der Maus darüberfahren oder darauf klicken.<br />Die gewählte Box wird dann vergrößert und es werden (sofern vorhanden) zusätzliche Informationen über die Person eingeblendet.<br /><br />* DIE PFEILE<br />Auf der linken bzw. rechten Seite der äußersten Boxen werden evtl. Pfeile angezeigt.<br />Klicken Sie auf diese Pfeile, um die Ansicht in die entsprechende Richtung zu \"verschieben\"<br /><br />Weitere Hilfe erhalten Sie, wenn Sie auf das <b>?</b> neben Boxen oder Links klicken.";
$pgv_lang["show_full_help"]			= "~DETAILS ANZEIGEN ODER VERBERGEN~<br /><br />Mit dieser Option können Sie alle Details in den Namen-Boxen ein- oder ausblenden.<br />Wenn die Details ausgeblendet sind, passen mehr Boxen auf den Bildschirm.<br /><br />Wenn Sie die Details verbergen, können Sie die Details immer noch kurzfristig anzeigen, indem Sie auf das Lupen-Symbol klicken (sofern die Lupen-Funktion generell aktiviert ist).<br />Das hängt davon ab, wie der Administrator das Programm eingerichtet hat.<br />Wenn Sie in der normalen Ansicht (mit Details) auf die Lupe klicken müssen, dann erhalten Sie in der verkürzten Ansicht alle Details, indem Sie auf die Personen-Box klicken.<br />Wenn Sie normalerweise den Zoom auslösen, indem Sie mit der Maus nur über die Lupe fahren, dann funktioniert das in der verkürzten Ansicht ebenso, wenn Sie über die Box fahren.";
$pgv_lang["talloffset_help"]			= "~SEITEN LAYOUT~<br /><br />Mit dieser Option, können Sie die Seitenausrichtung anpassen.<br />Verändern Sie diese Einstellung z.B. für einen Ausdruck oder falls Sie einen Hochformat-Bildschirm haben. Im Hochformat wird der Baum etwas schmaler, so dass ein Diagramm über 4 Generationen noch auf eine Seite passen sollte. Im Querformat sollte ein Diagramm mit 4 Generationen quergedruckt auf eine einzelne Seite passen.";
$pgv_lang["rootid_help"]                        = "~NEUE START-PERSON~<br /><br />Wenn Sie einen Stammbaum ausgehend von einer anderen Person anzeigen möchten, dann können Sie in dieses Feld die ID der gewünschten Person eintragen.<br /> Wenn Sie die ID nicht kennen, benutzen Sie einfach den <b>>ID suchen<</b> Link.<br /><br /><b>ID NUMMER (=Identifikationsnummer)</b><br />Die ID-Nummern, die in PhpGedView benutzt werden haben nichts zu tun mit z.B. der \"ID-Card number\" (Personalausweisnummer in USA)!<br />Die ID-Nummer ist nur eine Nummer, die in der GEDCOM-Datei benutzt wird und von der Genealogie-Software vergeben wird, um die GEDCOM-Datei zu erstellen!";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~ANZAHL DER GENERATIONEN~<br /><br />Hier können Sie einstellen, wie viele Generationen auf dieser Seite angezeigt werden.<br />Welche Einstellung für Sie optimal ist, hängt auch von der Größe/Auflösung Ihres Bildschirmes ab und ob z.B. die Details ein- oder ausgeblendet sind.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~DIE LOGIN SEITE~<br /><br />Auf dieser Seite können Sie sich Anmelden, ein neus Passwort beantragen oder einen Benutzer-Zugang beantragen.<br /><br />Weitere Informationen bekommen Sie, wenn Sie auf die \"?\" hinter den Feldern und Links klicken.";
$pgv_lang["username_help"]			= "~BENUTZERNAME~<br /><br />Geben Sie in dieses Feld Ihren Benutzernamen ein.<br />Groß-/Kleinschreibung beachten";
$pgv_lang["password_help"]			= "~PASSWORT~<br /><br />Tragen Sie hier Ihr Passwort ein.<br />Groß-/Kleinschreibung beachten";
$pgv_lang["login_buttons_help"]			= "~LOGIN BUTTONS~<br /><br />Es gibt hier 2 Buttons, um sich anzumelden.<br />Die Buttons führen Sie nach der Anmeldung zu unterschiedlichen Seiten.<br /><br />* Der<b> #pgv_lang[login]# </b> Button<br />Klicken Sie diesen Knopf, um zu der Seite zu gelangen, von der aus Sie die Login-Seite aufgerufen haben, allerdings nun mit den Ihnen zugewiesenen Zugriffs-Rechten.<br />Wenn Sie also den \" #pgv_lang[login]# \" Button auf der Stammbaum-Seite angeklickt haben, so gelangen Sie wieder zur Stammbaum-Seite.<br /><br />* Der <b> #pgv_lang[admin]# </b> Button<br />Falls Sie Administrator dieser Seite sind, gelangen Sie so direkt zur Administrations-Seite.";
$pgv_lang["login_buttons_aut_help"]		= "~AUTHENTICATION MODUS~<br /><br />LOGIN BUTTONS<br /><br />Es gibt hier 2 Buttons, um sich anzumelden.<br />Die Buttons führen Sie nach der Anmeldung zu unterschiedlichen Seiten.<br /><br />* Der<b> #pgv_lang[login]# </b> Button<br />Klicken Sie diesen Knopf, um zu der Seite zu gelangen, von der aus Sie die Login-Seite aufgerufen haben, allerdings nun mit den Ihnen zugewiesenen Zugriffs-Rechten.<br />Wenn Sie also den \" #pgv_lang[login]# \" Button auf der Stammbaum-Seite angeklickt haben, so gelangen Sie wieder zur Stammbaum-Seite.<br /><br />* Der <b> #pgv_lang[admin]# </b> Button<br />Falls Sie Administrator dieser Seite sind, gelangen Sie so direkt zur Administrations-Seite.";
$pgv_lang["new_password_help"]			= "~NEUES PASSWORT BEANTRAGEN~<br /><br />Wenn Sie Ihre Passwort vergessen haben, klicken Sie auf diesen Link, um ein neues anzufordern.<br />Sie werden weitergeleitet auf die Seite \"Verlorenes Passwort Beantragen\".";
$pgv_lang["new_user_help"]			= "~ALS NEUER BENUTZER ANMELDEN~<br /><br />Wenn Sie als Besucher dieser Seite einen Benutzer-Zugang beantragen möchten, klicken Sie auf diesen Link.<br />Sie werden weitergeleitet auf die Seite \"Registrierung\".|";
$pgv_lang["mygedview_login_help"]		= "Um das \"Mein GedView Portal\" anzuzeigen, müssen Sie als Benutzer registriert sein.<br /><br />Mit dem \"Mein GedView Portal\" können Sie Lesezeichen auf Personen setzen, die Ihnen wichtig sind, ein Journal führen, Nachrichten verwalten, andere angemeldete Benutzer sehen und PhpGedView an Ihre Bedürfnisse anpassen.<br /><br />Geben Sie Ihren Benutzernamen und Ihr Passwort in die jeweiligen Felder ein, um sich bei Mein GedView anzumelden.";
$pgv_lang["new_user_fullname_help"]		= "~#pgv_lang[fullname]#~<br /><br />In dieses Feld müssen Sie Ihren vollständigen Namen eingeben.<br /><br />Dies ist auch der Name, der für andere angemeldete Benutzer sichtbar wird.<br /><br />Der Name wird auch benötigt, um zu überprüfen, ob Sie berechtigt sind, Zugang zu den Daten zu erhalten.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~DER NACHFAHREN-BAUM~<br /><br />Diese Seite zeigt die Nachfahren einer Person.<br />Sie können eine Start-Person für diesen Nachfahren-Baum auf dieser Seite auswählen, oder Sie können auf einer anderen Seite einen Link \"Nachfahrenbaum\" anklicken, um auf diese Seite zu gelangen.<br />Klicken Sie auf den \"nach-oben\"-Pfeil, um im Baum nach oben zu navigieren. Klicken Sie auf das Diagramme-Icon in einer Personen-Box, um diese Person als Ausgangsperson für ein Diagramm auszuwählen.";
$pgv_lang["desc_rootid_help"]			= "~NEUE START-PERSON~<br /><br />Wenn Sie einen Nachfahrenbaum ausgehend von einer anderen Person anzeigen möchten, dann können Sie in dieses Feld die ID der gewünschten Person eintragen.<br /> Wenn Sie die ID nicht kennen, benutzen Sie einfach den \"ID suchen\" Link.";
$pgv_lang["desc_generations_help"]		= "~ANZAHL DER GENERATIONEN~<br /><br />Hier können Sie einstellen, wie viele Generationen auf dieser Seite angezeigt werden.<br />Eine höhere Anzahl von Generationen erhöht auch die Rechenzeit.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~LEBENSSPANNENANZEIGE~<br /><br />Auf dieser Seite können Sie eine odere mehrere Personen auf einer Zeitleiste darstellen.<br />So können Sie zum Beispiel veranschaulichen wie alt Personen oder deren Verwandte an bestimmten Stationen ihres Lebens waren.";
$pgv_lang["add_person_help"]			= "~PERSON HINZUFÜGEN~<br /><br />Sie können mehrere Personen auf der Zeitleiste darstellen.<br />Geben Sie in dieses Feld die ID einer weiteren Person ein.<br />Wenn Sie die ID der Person nicht kennen, benutzen Sie den Link \"ID suchen\" hinter dem Eingabefeld.";
$pgv_lang["remove_person_help"]			= "~PERSON ENTFERNEN~<br /><br />Klicken Sie auf diesen Link, um die Person, von der Zeitleiste zu entfernen.";
$pgv_lang["show_age_marker_help"]		= "~ALTERSANKER ANZEIGEN~<br /><br />Wenn Sie dieses Feld aktivieren, wird ein Alters-Feld eingeblendet, das man auf der Zeitleiste verschieben kann.<br /> Dieser Altersanker ist nützlich, um das Alter einer Person bei einem bestimmten Ereignis zu prüfen.<br />Für jede Person im Diagramm kann man den Altersanker ein- oder ausschalten.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~VERWANDTSCHAFTSBERECHNUNGS-SEITE~<br /><br />Auf dieser Seite kann der Verwandtschafts-Grad zwischen 2 Personen dargestellt werden.<br />Dies bedeutet nicht, dass die Personen direkte Blutsverwandtschaft haben müssen.<br />Jegliche Verwandtschaft wird gefunden.";
$pgv_lang["relationship_id_help"]		= "~ID von PERSON 1 und PERSON 2~<br /><br />Wenn Sie von einer anderen Seite auf diese weitergeleitet wurden, indem Sie z.B. den \"Verwandtschaft zu mir\"-Link benutzt haben, werden Sie hier den Verwandtschaftsgrad zwischen diesen Personen sehen.<br /><br />Andernfalls müssen Sie die IDs von 2 Personen eingeben, deren Verwandtschafts-Grad zueinander Sie erfahren möchten.<br />Wenn Sie die IDs nicht kennen, klicken Sie auf den Link \"ID suchen\".";
$pgv_lang["next_path_help"]			= "~NÄCHSTEN PFAD SUCHEN~<br /><br />Klicken Sie auf diesen Button, um zu prüfen, ob es einen weiteren Verwandtschafts-Pfad gibt, der diese beiden Personen verbindet.<br />Zuvor gefundene Pfade können wieder angezeigt werden, indem man auf den Klick mit der entsprechenden Pfad-Nummer klickt.";
$pgv_lang["follow_spouse_help"]			= "~ÜBERPRÜFE VERWANDTSCHAFT ANHAND DER EHEN -CHECKBOX~<br /><br />Wenn dieses Feld <b>nicht</b>aktiviert ist, werden nur Blutsverwandschaften überprüft.<br />Wird dieses Feld aktiviert, werden auch Verwandtschaften durch Eheschließungen berücksichtigt. Es ist wahrscheinlich, dass mehr Zusammenhänge gefunden werden, wenn Sie diese Box aktivieren.";
$pgv_lang["line_up_generations_help"]	= "~GENERATIONEN AUF GLEICHER HÖHE DARSTELLEN - CHECK BOX~<br /><br />Wenn Sie diese check box markieren, werden im Diagramm alle Personen, die der gleichen Genearation angehören, nebeneinander (auf einer Höhe) dargestellt. Ist die check box aus, so werden die Personen in einer Linie untereinander dargestellt, ganz gleich ob das Verhältnis zur vorigen Person Eltern oder Kind ist.";
$pgv_lang["oldest_top_help"]          = "~ÄLTESTE ZUOBERST - CHECKBOX~<br /><br />Wenn diese checkbox markiert ist, werden im Diagramm die ältesten Personen zuoberst angezeigt.<br />Andernfalls stehen die jüngsten Personen oben.<br /><br />Anmerkung: Diese Option funktioniert nur, wenn das Feld <i>#pgv_lang[line_up_generations]#</i> aktiviert ist.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]# Seite~<br /><br />Die #pgv_lang[ancestry_chart]#-Seite ist der <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#-Seite</a> sehr ähnlich, zeigt aber mehr Details und bietet mehrere <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#en</a>.<br /><br />Jeder Vorfahre wird mit einer Nummer nach dem <i>Sosa-Stradonitz</i> System gekennzeichnet:<br /> - gerade Zahlen für Männer (Nummer des Kindes*2)<br /> - ungerade Zahlen für Frauen (Nummer des Ehemannes + 1) außer bei Nummer <big>1</big><br /><br />Beispiel: <big>7</big> ist die Frau von <big>6</big>, die Mutter von <big>3</big>, und die Tochter von <big>14</big> und <big>15</big>.";
$pgv_lang["box_width_help"]		= "~#pgv_lang[ancestry_chart]# box width~</b><br /><br />Hier können Sie die Box-Breite zwischen 50% und 300% verändern.<br />Standard-Wert ist 100%: die Box-Breite beträgt dann ca. 270 Pixel.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[ancestry_chart]# Diagramm Typ~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd>Vertikaler Baum mit ein-/ausblendbaren Familien</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Eine Familie pro Seite mit Eltern, Großeltern und allen erfassten Kindern.<br />Gut zum Ausdruck und zur Weitergabe an Verwandte geeignet.</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]#~<br /><br />Das #pgv_lang[fan_chart]# ist dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> sehr ähnlich, bietet aber eine graphik-orientierte Darstellung.<br /><br />Die Ausgangsperson steht in der Mitte, deren Eltern auf dem ersten Ring, Großeltern im zweiten Ring usw.<br /><br />Geburts- und Todesdaten erscheinen unter den Namen wenn bekannt.<br /><br />Wenn Sie auf einen Namen im Diagramm klicken, so wird diese Person als neue Ausgangsperson festgelegt (und erscheint dann in der Mitte). Bei der Person in der Mitte ist ein Pfeil zu sehen, der beim Anklicken ein Menü öffnet, mit dem Sie eines der Kinder oder Geschwister der Person als neue Starperson auswählen können (gleiche Arbeitsweise wie beim <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>).";
$pgv_lang["fan_width_help"]		= "~#pgv_lang[fan_chart]#-Breite~</b><br /><br />Hier können Sie die Breite des Kreisdiagramms zwischen 50% und 300% verändern.<br />Standard-Wert ist 100%: die Diagramm-Breite beträgt dann ca. 640 Pixel.";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# Typ~<br /><br /><dl><dt>1/2</dt><dd>Halbkreis (180°) Kreis-Diagramm</dd><dt>3/4</dt><dd>Drei-Viertel (270°) Kreis-Diagramm oder 'Engels-Flügel'</dd><dt>4/4</dt><dd>Vollkreis (360°) Kreis-Diagramm</dd></dl>";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PERSONEN SEITE~<br /><br />Auf dieser Seite wird eine Liste von Personen angezeigt.<br /><br />Die Namen werden mit vorne stehendem Nachnamen, alphabetisch sortiert angezeigt.<br />Die ausgegebene Liste basiert auf folgenden Kriterien:<br /><b>1.</b> Der Buchstabe, den Sie im Alphabet-Index angeklickt haben.<br /><b>2.</b> Sie können am unteren Ende der Liste die \"Nachnamen-Sprungliste\" oder \"Nachnamen anzeigen\" wählen.<br /><br />Wenn Sie weitere Hilfe benötigen, klicken Sie auf die \"?\" neben den Symbolen.";
$pgv_lang["alpha_help"]				= "~ALPHABET-INDEX~<br /><br />Klicken Sie auf einen Buchstaben des Alphabets und Sie erhalten eine neue Liste mit den Nachnamen des von Ihnen gewählten Buchstabens.<br />An vorletzter Stelle sehen Sie eventuell <b>#pgv_lang[NN]#</b><br />#pgv_lang[NN]# steht für Personen in der GEDCOM-Datei, deren Nachnamen nicht angegeben wurde, oder deren Nachnamen keinen einzigen Buchstaben des unterstützten Alphabets enthält.<br />#pgv_lang[NN]# kann auch für unbekannte Personen stehen.<br /><br /><b>Achtung</b><br />Wenn im GEDCOM-Datensatz einer Person der Nachname z.B. mit Nn, NN, Unbekannt oder auch N.N. eingetragen ist, dann erscheint diese Person <b>nicht</b> in der Rubrik <b>#pgv_lang[NN]#</b>. Solche Personen finden Sie unter \"<b>N</b>\" oder \"<b>U</b>\".<br />Dies liegt daran, dass das Programm nur prüft, ob ein Name eingetragen ist.<br /><br />Am Ende des Alphabetes sehen Sie \"<b>ALLE</b>\". Klicken Sie hierauf, um eine Liste mir allen Nachnamen der GEDCOM-Datei anzeigen zu lassen.<br /><br />FEHLENDE BUCHSTABEN?<br />Es kann sein, dass im Alphabet-Index einige Buchstaben fehlen.<br />Das bedeutet, dass es in der Liste keine Nachnamen gibt, die mit diesen Buchstaben beginnen.";
$pgv_lang["name_list_help"]			= "~NAMENS LISTE~<br /><br />In dieser Box erscheint entweder eine Liste von Nachnamen oder von einzelnen Personen.<br />In beiden Fällen beginnen die Nachnamen mit dem Buchstaben, den Sie im Alphabet-Index angeklickt haben, es sei denn, Sie haben auf \"ALLE\" geklickt.<br /><br />Ob Sie die Nachnamensliste oder die Liste einzelner Personen angezeigt bekommen, können Sie mit dem Link unter dieser Box auswählen.";
$pgv_lang["skip_sublist_help"]			= "~NACHNAMEN ANZEIGEN~<br /><br />Normalerweise wird eine Unterliste gruppiert nach Nachnamen angezeigt, wenn Sie einen Buchstaben des Alphabets ausgewählt haben.<br />Wenn Sie auf diesen Link klicken, werden die Nachnamen nicht gruppiert, sondern jede einzelne Person, deren Nachname mit diesem Buchstaben beginnt, wird angezeigt.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~FAMILIEN SEITE~<br /><br />Auf dieser Seite wird eine Liste der Familien angezeigt.<br /><br />Die Namen werden mit vorne stehendem Nachnamen, alphabetisch sortiert angezeigt.<br />Die ausgegebene Liste basiert auf folgenden Kriterien:<br /><b>1.</b> Der Buchstabe, den Sie im Alphabet-Index angeklickt haben.<br /><b>2.</b> Wahl der \"Nachnamen-Sprungliste\" oder \"Nachnamen anzeigen\".<br /><br />Sie können sowohl nach dem Nachnamen des Ehemannes als auch nach dem der Ehefrau suchen. Beide sind in der Liste enthalten.<br /><br />Wenn Sie weitere Hilfe benötigen, klicken Sie auf die \"?\" neben den Symbolen.";
$pgv_lang["help_family.php"]			= "~FAMILIEN DETAIL SEITE~<br /><br />Diese Seite zeigt Ihnen eine Übersicht der Familie, die Sie auf der vorigen Seite ausgewählt habe.<br />Von oben nach unten sehen Sie die Detailinfo-Boxen von:<br />Der Ehemann und seine Eltern, die Ehefrau und ihre Elternm, und die Kinder.<br /><br />Das Layout und der Inhalt der Personen-Boxen entspricht dem der Boxen, die Sie von der Stammbaum-Seite oder Nachfahren-Baum-Seite kennen.<br />Rechts von den Namens-Boxen der Eltern sehen Sie einen Pfeil (wenn weitere Vorfahren eingetragen sind). Wenn Sie auf diesen Pfeil klicken, gelangen Sie eine Geneartion höher und Sie sehen eine neue Familien-Seite in der die Eltern der vorigen Seite nun als Ehemann und Ehefrau auftauchen.<br />Auf der rechten Seite <i>in</i> der Namens-Box, sehen Sie eventuell ein Lupen-Symbol, das zu weiteren Detail-Information einer Person führt. Wenn Sie auf den Namen klicken, gelangen Sie auf die Seite mit persönlichen Informationen zur Person.<br />Außerdem ist am rechten Rand ein kleines Menü vorhanden, das Sie zu anderen Seiten mir mehr Informationen oder zu anderen Diagrammen führt.<br /><br />Die Familiengruppen-Information zeigt alle Fakten und Daten über diese Familie, wie Hochzeit, Multimedia-Objekte und Notizen. Wenn Sie innerhalb der Informationen auf einen Ort klicken, gelangen Sie zur Ortsliste, in der alle anderen Familien und Personen aufgelistet sind, die zu diesem Ort ebenfalls einen Bezug haben. Wenn Sie auf ein Datum klicken, gelangen Sie zum Tages-Kalender, der alle Ereignisse zeigt, die an diesem Datum in der Vergangenheit stattfanden. Multimedia-Objekte können auch angeklickt werden, dann öffnet sich ein görßeres Bild-Betrachtungsfenster. Wenn Sie auf eine Quelle klicken, erscheinen die Detailinformationen zu dieser Quelle.<br /><br />Unter den Namens-Boxen der Kinder sehen Sie eventuell einen Link \"Kind zu dieser Familie hinzufügen\".<br />Neben den Namens-Boxen der Kinder sehen Sie \"Informationen zur Familiengruppe\".<br />Wenn Sie die nötigen Rechte haben, können Sie Ereignisse und Daten verändern, löschen oder hinzufügen.<br /><br />Am rechten Bildschirmrand sehen Sie (wenn aktiviert) Symbole und Links für: <br /><b>GEDCOM Daten anzeigen</b>, dadurch werden die Daten im GEDCOM-Format dargestellt.<br /><b>Datensatz dem Sammelbehälter hinzufügen</b>, dadurch speichern Sie die Daten in Ihrem Ausschnitts-Sammelbehälter. Die Daten in diesem \"Behälter\" können Sie später herunterladen und in Ihre eigene GEDCOM-Datei importieren.<br /><b>Ehepaar in Lebensspannen-Ansicht zeigen</b>, hiermit gelangen Sie zur Lebensspannenanzeige und die Daten des Ehepaares werden in der Zeitleiste angezeigt.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~EIN KIND ZU DIESER FAMILIE HINZUFÜGEN~<br /><br />Wenn Sie diesen Link klicken, können Sie ein Kind zur Familie hinzufügen.<br />Ein Kind hinzuzufügen funktioniert einfach: Klicken Sie auf diesen Link und füllen Sie die Felder im Popup-Fenster aus, das ist alles.<br />";
$pgv_lang["show_fam_gedcom_help"]	= "~GEDCOM DATENSATZ ANZEIGEN~<br /><br />Wenn Sie auf diesen Link klicken, wird in einem Popup-Fenster die Information über diese Familie so angezeigt, wie Sie im GEDCOM-Datensatz gespeichert ist.";
$pgv_lang["add_fam_clip_help"]		= "~FAMILIE ZUM AUSSCHNITTSAMMELBEHÄLTER HINZUFÜGEN~<br /><br />Klicken Sie auf diesen Link, um die Daten der Familie aus der GEDCOM-Datei zum Ausschnittsammelbehälter hinzuzufügen. Auf der nächsten Seite, können Sie dann im Detail auswählen, welche Informationen Sie hinzufügen möchten: nur die Eltern oder auch deren Eltern und/oder deren Kinder und/oder alle Nachfahren.";
$pgv_lang["show_fam_timeline_help"]	= "~PAAR IN DER LEBENSSPANNENANZEIGE ANZEIGEN~<br /><br />Wenn Sie auf diesen Link klicken, gelangen Sie auf die Lebensspannenanzeigen-Seite, wobei die Daten des Personenpaares direkt in der Zeitleiste angezeigt werden.";
//-- same variables as individuals page

//-- Sourcelist-page
$pgv_lang["help_sourcelist.php"]		= "~QUELLEN SEITE~<br /><br />Auf dieser Seite wird eine Liste aller Quellen angezeigt.<br />Anders als bei der Personen- und Familien-Seite gibt es keinen Alphabet-Index auf dieser Seite. Da die Quellen sowohl Personen mit unterschiedlichen Namen als auch öffentliche Datenbanken oder Institute sein können, würde eine alphabetische Unter-Gruppierung nicht viel Sinn machen.<br />Die Namen erscheinen in der gleichen alphabetischen Reihenfolge wie sie in der GEDCOM-Datei gespeichert sind.<br /><br /><b>QUELLEN</b><br />Ohne Quellen könnte man keine Genealogie betreiben. Für jede Information in der Datenbank gibt es eine Quelle. Dies kann eine Person, ein Amt oder z.B. eine öffentliche Datenbank sein.<br />Eine Quelle kann mit vielen Personen verknüpft sein. Andererseits kann eine Person auch mit mehreren Quellen verknüpft sein. Sie können mehrere Quellen für ein Ereignis haben, gleich ob es ein Geburtstag, ein Beruf, eine Hochzeit etc. ist.";
$pgv_lang["sourcelist_listbox_help"]		= "~QUELLEN LISTE~<br /><br />In dieser Box erscheinen die Namen der Quellen, so wie sie in der GEDCOM-Datei gespeichert sind.<br />Die Namen erscheinen alphabetisch sortiert.<br /><br />Wenn Sie auf eine Quelle in der Liste klicken, gelangen Sie auf die Seite dieser Quelle, wo eine Liste der mit dieser Quelle verknüpften Personen und Familien angezeigt wird.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~QUELLEN DETAIL SEITE~<br /><br />Auf dieser Seite werden die Details einer Quelle angezeigt. Quellenangaben sind für Genealogen sehr wichtig und helfen die Ergebnisse von anderen Forschern nachzuvollziehen.<br />Auf dieser Seite finden Sie Informationen über den Namen der Quelle(n), deren Autor, Veröffentlichung und dem Archiv/Ort, wo diese Quelle gefunden wurde. Da es sehr viele verschiedener Arten von Quellen gibt, finden Sie eventuell unterschiedliche Mengen von Angaben vor.<br /><br />Wenn zu einem Multimedia-Objekt eine Quelle angegeben ist (z.B. Scan eines Dokuments), gelangen Sie zu einer größeren Ansicht, indem Sie auf das Objekt oder den Dateinamen daneben klicken.<br /><br />Im Anschluss an die Quellen-Details wird eine Liste angezeigt, die Personen und Familien enthält, die mit dieser Quelle verknüpft sind. So finden Sie alle Informationen, die dieser einen Quelle entnommen sind.<br /><br />Eventuell werden ein oder zwei zusätzliche Symbole angezeigt, je nach Konfiguration durch den Administrator:<br /><b>GEDCOM-Datensatz anzeigen</b> - was die Daten im GEDCOM-Format anzeigt.<br /><b>Datensatz dem Sammelbehälter hinzufügen</b> - was ihnen erlaubt die Dateien in Ihrem Sammelbehälter zu speichern. Diesen \"Behälter\" können Sie später herunterladen und die Daten in ihre eigene GEDCOM-Datei einfügen.<br /><br />Weitere Hilfe erhalten Sie, wenn Sie auf die \"<b>?</b>\" klicken.";
$pgv_lang["sources_listbox_help"]		= "~MIT DIESER QUELLE VERBUNDENE EINTRÄGE~<br /><br />In dieser Box erscheint eine Liste der Personen und Familien, die mit dieser Quelle verknüpft sind.<br />Die Namen erscheinen in alphabetischer Reihenfolge.<br /><br />Wenn Sie auf einen Namen in der Liste klicken, gelangen Sie zur Detail-Seite der betreffenden Person oder Familie.";
$pgv_lang["show_source_gedcom_help"]		= "~GEDCOM-DATENSATZ ANZEIGEN~<br /><br />Wenn Sie auf diesen Link klicken, werden die Informationen über diese Quelle in einem Extra-Fenster genau so angezeigt, wie sie in der GEDCOM-Datei gespeichert sind (GEDCOM-Roh-Daten).";
$pgv_lang["add_source_clip_help"]		= "~DATENSATZ DEM SAMMELBEHÄLTER HINZUFÜGEN~<br /><br />Wenn Sie auf diesen Link klicken, werden die Daten, so wie in der GEDCOM-Datei enthalten, in Ihren Ausschnitssammelbehälter hinzugefügt.";
$pgv_lang["delete_source_help"]			= "~DIESE QUELLE LÖSCHEN~<br /><br />Wenn Sie diesen Link klicken, wird die Quelle zum Löschen markiert.<br />Was bedeutet das?<br />Angenommen Sie möchten aus irgendeinem Grund eine Quelle löschen. Klicken Sie auf den Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen.<br /><br />Wenn Sie mit dem Löschen fortfahren, kann es einige Zeit dauern, bis ein Popup-Fenster erscheint, das über das erfolgreiche Löschen informiert.<br /><br />Bei näherem Betrachten werden Sie aber feststellen, dass die Quelle weiterhin sichtbar ist und wie zuvor ausgewählt werden kann.<br /><br />Dies ist <b>kein</b> Fehler.<br />Der Administrator wird eine Nachricht bekommen, dass Änderungen an der Datenbank erwünscht sind, und dass Sie die Quelle gelöscht haben.<br />Der Administrator kann Ihre Änderung akzeptieren oder ablehnen. Erst danach ist die Quelle unwiderruflich gelöscht.<br />Im Zweifelsfalle wird der Administrator Sie zuvor kontaktieren.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~LISTE DER ORTE~<br />(oder Personen je Ort)<br /><br />Auf dieser Seite sehen Sie hierarchisch, welche Personen oder Familien mit einem Ort verknüpft sind.<br /><br />Wenn eine Verbindung zwischen einer Person oder Familie und einem Ereignis an einem bestimmten Ort besteht, bekommen Sie es angezeigt.<br /><br />Die Ergebnisse werden in einer 2-spaltigen Liste angezeigt:<br />Eine für Personen und eine für Familien.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~ORDNUNGS-FORMAT FÜR ORTE~<br /><br /><b>STANDARDEINSTELLUNG</b><br />Das bedeutet, dass keine vorgegebene Anordnung in der GEDCOM-Datei gefunden wurde.<br />In diesem Fall wird die Standard-Anordnung angenommen.<br /><br />Wenn ein anderes Ordnungs-Format in der GEDCOM-Datei gefunden wurde, würde das zwischen den (...) am Ende der Zeile angezeigt werden.";
$pgv_lang["ppp_match_one_help"]			= "~ORDNUNGS-FORMAT FÜR ORTE~<br /><br />GEDCOM-REIHENFOLGE<br />Es wird angenommen, die Orte seien in der Ordnung -wie in der der GEDCOM-Datei vorgefunden- codiert.<br />Diese Einstellung überschreibt die Standard-Anordnung, die benutzt würde, wenn die GEDCOM-Datei keine Ordnungs-Angabe enthält.";
$pgv_lang["ppp_numfound_help"]			= "~ORTS-VERBINDUNGEN GEFUNDEN~<br /><br />Hier wird die Anzahl der Verbindungen angezeigt.<br />Wenn Sie noch eine Liste mit Orten sehen, bedeutet das, dass Sie noch nicht die unterste Ebene erreicht haben. Sie können entweder alle Datensätze, die zu diesem Ort gefunden wurden, anzeigen oder die Suchangaben präzisieren, indem Sie auf einen Ort klicken.";
$pgv_lang["ppp_levels_help"]			= "~ORTS-EBENE~<br /><br />Hier werden die bisher ausgewählten Ortsangaben angezeigt.<br />Die Liste in der Box stellt eine Unterliste der zuletzt gewählten Ebene.<br /><br />BEISPIEL:<br />Die Reihenfolge ist: #pgv_lang[default_form]#<br />Wenn die aktuelle Ebene die oberste ist, zeigt die Box alle Länder in der GEDCOM-Datei an.<br />Wenn als Ebene angezeigt wird: \"Deutschland, zurück\", dann werden in der Box alle Regionen innerhalb Deutschlands angezeigt.<br />etc.<br /><br />Sie können in der Zeile auf jede beliebige Ebene klicken, um wieder eine oder mehrere Ebenen nach oben zu springen.";
$pgv_lang["ppp_placelist_help"]			= "~ORTS-HIERARCHIE~<br /><br />In dieser Liste sehen Sie die Orte unter der angebenenen Ortsauswahl. Wenn Sie noch keinen Ort angegeben haben, sehen Sie eine Liste der obersten Ebene (z.B. Länder oder Staaten).<br />Sie können die Namen der Ortsangaben in der Liste anklicken.<br />Dadurch wird der ausgewählte Ort als Filter aktiviert und sie gelangen eine Ebene tiefer.";
$pgv_lang["ppp_placelist_help2"]		= "~ORTS-LISTE~<br /><br />In dieser Liste sehen Sie die bisher gefunden Orte.<br />Sie können die Namen der Ortsangaben in der Liste anklicken.<br />Dadurch wird der ausgewÃ¤hlte Ort als Filter aktiviert und sie gelangen eine Ebene tiefer.<br />Nur solange Sie in der obersten Ebene arbeiten, wird keine Namensliste angezeigt. In allen tiefer gelegenen Ebenen, erhalten Sie eine Liste von Personen oder Familien, die mit diesem Ort verknüpft sind.";
$pgv_lang["ppp_view_records_help"]		= "~ALLE DATENSÄTZE ANZEIGEN~<br /><br />Wenn SIe auf diesen Link klicken, erhalten Sie eine Liste mit allen Personen und Familien, bei denen Ereignisse am zuvor ausgewählten Ort stattgefunden haben. Wenn Sie in der untersten Hierarchieebene der Ortsangabe angelangt sind (z.B. ein Dorf oder eine Stadt), dann wird diese Namensliste automatisch angezeigt.";
$pgv_lang["ppp_name_list_help"]			= "~NAMEN-LISTE~<br /><br />Diese Box zeigt eine Liste aller Personen und Familien, die in irgendeiner Weise mit dem gewählten Ort verbunden sind.<br /><br />Sie können auf die Namen in der Liste klicken.<br />Dadurch gelangen Sie auf die Detail-Seite der Person oder Familie.<br /><br />Sie können Ihre Orts-Wahl auch abändern, indem Sie auf einen Ort oberhalb der Liste klicken.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~MULTI MEDIA LISTE~<br /><br />Die Multi Media Seite listet alle Multi Media Objekte (MMO), die in der GEDCOM-Datei vorkommen.<br /><br />Zu jedem Multimedia-Objekt finden Sie den Titel oder Dateinamen des Objekts sowie die Namen der Personen oder Familien, die mit dem MMO verbunden sind, sowie Notizen zum Objekt.<br /><br />Auf den Titel oder Dateinamen des MMO zu klicken bewirkt das gleiche wie ein Klick auf sein Thumbnail.<br />Abhängig vom Dateiformat (*.gif, *.jpg), wird das MMO mit dem PGV-internen Viewer geöffnet oder in einem Viewer-plugin Ihres Browsers.<br /><br />Wenn Sie auf den \"Zeige\" Link einer Person oder Familie klicken, gelangen Sie zur Seite der jeweiligen Familie oder Person.<br /><br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~MULTIMEDIA-DATEIEN HOCHLADEN~<br /><br />Das Hochladen der Dateien ist einfach, hier aber ein paar Zusatzinformationen.<br /><br /><b>Thumbnails</b><br />Thumbnails sollten ungefährt 100 Pixel breit sein.<br />Der Dateiname muss der selbe sein, wie der des Original-Bildes.<br /><br /><b>Hochladen</b><br />Die Dateien werden automatisch in das Verzeichnis ../media hochgeladen, wenn es sich um Originale handelt und in das Verzeichnis ../media/thumbs/ bei thumbnails.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~JAHRESTAG KALENDER~<br /><br /><ul><li><a href=\"#calendar_general\">Allgemeine Informationen</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Ereignis</a><li><a href=\"#calendar_button\">Vorauswahl (Buttons)</a><li><a href=\"#calendar_tip\">Tipp</a></ul><br /><a name=\"calendar_general\"></a>Der Jahrestag-Kalender zeigt Personen und Familien an, die mit einem Ereignis in Verbindung stehen, das sich an einem bestimmten Tag und/oder Monat oder einem bestimmten Zeitraum ereignet hat. Er besitzt ein mehrstufiges Filtersystem, um das gewünschte Datum/den gewünschten Zeitraum und die Art der Ereignisse auszuwählen.<br /><br /><dl><dt><b><a href=\"#calendar_day\">Tag anzeigen</b></dt><dd>Dies zeigt die Ereignisse eines bestimmten Tages an (unabhängig vom gewählten Jahr). Es wird entweder eine einzelne Liste ausgegeben, die die Namen von Personen oder aber Familien enthält, oder eine 2-spaltige Liste mit Personen in der einen Spalte und Familien in der anderen  Spalte.</dd><dt><b><a href=\"#calendar_month\">Monat anzeigen</a></b></dt><dd>Dies zeigt wird einen <b>Kalender</b> an, wobei die Namen von Personen und Familien jeweils in den Tages-Kästchen erscheinen. Der Kalender erscheint wie in dem Jahr, das Sie im Jahres-Feld eingegeben haben. Alle Ereignisse, die sich in der Vergangenheit bis zu diesem Jahr ereignet haben, werden angezeigt.<br />In Kombination mit der Option \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" ergibt sich eine realistische Ansicht, wie sich die Ereignisse für die Vorfahren dargestellt haben.</dd><dt><b><a href=\"#calendar_year\">Jahr anzeigen</a></b></dt><dd>Dies zeigt die Ereignisse eines oder mehrerer Jahre. Es wird entweder eine einzelne Liste ausgegeben, die die Namen von Personen oder aber Familien enthält, oder eine 2-spaltige Liste mit Personen in der einen Spalte und Familien in der anderen  Spalte.</dd></dl><br />Die aktuell eingestellten Datums-Werte sind im Kalender-Menü farblich hervorgehoben dargestellt.<br /><br />Die Namen und Daten, die in der Liste oder im Kalender erscheinen, können Sie anklicken.<br />Wenn Sie auf einen Namen klicken, gelangen Sie Detail-Seite der betreffenden Person oder Familie, wenn Sie auf ein Datum klicken, gelangen Sie in die \"Heute\"-Ansicht (oder das Jahr) für das angeklickte Datum.<br /><br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">\$UpArrow</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~DATUMS AUSWAHL~<br /><br />Die obere Zeile der Auswahl-Tabelle ist die <b>Tagesauswahl</b>.<br />Hier wählen Sie den Tag aus.<br />Das Ergebnis hängt davon ab, ob Sie sich im \"Tages Modus\" oder im \"Monats Modus\" befinden.<br /><br />Der <b>Tages Modus</b>:<br />Wenn Sie in diesem Modus einen Tag anklicken, wird der Bildschirm aktualisiert und die Liste des angeklickten Tages wird angezeigt.<br /><br />Der <b>Monats Modus</b>:<br />Wenn Sie im Monatsmodus auf einen Tag klicken, wird der Bildschirm zwar aktualisiert, aber Sie sehen immer noch den Kalender des gleichen Monats wie zuvor.<br />Um den Modus zu wechseln klicken Sie einfach auf den <b>#pgv_lang[viewday]#</b> oder <b>#pgv_lang[viewmonth]# Button</b>.<br /><br />Am Ende der Tages-Reihe finden Sie den <b>\"Direkt-Link\"</b> mit dem heutigen Datum.<br />Wenn Sie diesen \"Direkt-Link\" anklicken, sehen Sie die Liste für den heutigen Tag im \"Tages-Modus\", gleich in welchem Modus Sie zuvor waren.<br />";
$pgv_lang["annivers_month_select_help"]		= "~MONATS AUSWAHL~<br /><br />Die mittlere Zeile der Auswahl-Tabelle ist die <b>Monatsauswahl</b>.<br />Hier wählen Sie den Monat aus.<br />Das Ergebnis hängt davon ab, ob Sie sich im \"Tages Modus\" oder im \"Monats Modus\" befinden.<br /><br />Der <b>Tages Modus</b>:<br />Wenn Sie in diesem Modus einen Monat anklicken, wird der Bildschirm aktualisiert und die Liste des angeklickten Datums mit dem neu gewählten Monat wird angezeigt.<br /><br />Der <b>Monats Modus</b>:<br />Wenn Sie im Monatsmodus auf einen Monat klicken, wird der Kalender des neuen Monats angezeigt.<br /><br />Am Ende der Monats-Reihe finden Sie den <b>\"Direkt-Link\"</b> mit dem aktuellen Monat.<br />Wenn Sie diesen \"Direkt-Link\" anklicken, sehen Sie den Kalender des aktuellen Monats, gleich in welchem Modus Sie zuvor waren.<br />";
$pgv_lang["annivers_year_select_help"]		= "~JAHRES EINGABEFELD~<br /><br />In diesem Feld können Sie das Jahr angeben für die Ausgabe der Liste im \"Jahres Modus\" bzw. für den Kalender im \"Monats Modus\".<br />Im \"Tages-Modus\" ändert die Jahreszahl nichts, da die Ereignisse aller Jahre angezeigt werden.<dl><dt><b>Tipps für Fortgeschrittene</b> bei <b>#pgv_lang[viewyear]#:<br />Mehrere Jahre</b></dt><dd>Sie können über mehrere Jahre suchen, indem Sie im Jahresfeld folgende Eingabe machen:<br />- Beisp. 1: <b>1992-5</b> für alle Ereigniss von 1992 bis 1995.<br />- Beisp. 2: <b>1972-89</b> für alle Ereignisse von 1972 bis 1989.<br />- Beisp. 3: <b>1610-759</b> für alle Ereignisse von 1610 bis 1759.<br />- Beisp. 4: <b>1880-1905</b> für alle Ereignisse von 1880 bis 1905.<br />- Beisp. 5: <b>880-1105</b> für alle Ereignisse von 880 bis 1105.<br /><br />Sie können auch die letzte Ziffer eines Jahres weglassen, um alle Ereignise eines Jahrzehnts zu erhalten.<br />- Beisp.: <b>197</b> für alle Ereignisse von 1970 bis 1979.</dd><dt><b>Abkürzungen</b></dt><dd>Manchmal is das genaue Datum eines Ereignisse nicht bekannt. In diesem Fall können Begriffe wie \"nach\", \"vor\" und \"um\" in Verbindung mit einem Datum verwendet werden. Die Daten werden zusammen mit einer englischen Abkürzung dieser Begriffe in der GEDCOM-Datei gespeichert. Im Jahres-Modus können Sie auch nach diesen Begriffen (mit oder ohne Datumsangabe) suchen. Hier einige Beispiele:<br /><b>abt</b> 1800 (abt = about, d.h. um)<br /><b>bet</b> 1950-1959 (bet = between, d.h. zwischen) Eingabe: bet 1950-59<br /><b>bef</b> 1950 (bef = before, d.h. vor)<br /><b>aft</b> 1900 (aft = after, d.h. nach)<br />PS: <i>Diese Abkürzungen müssen in Englisch eingegeben werden, da der GEDCOM-Standard die englischen Kürzel beinhaltet !<br />PhpGedView sucht nach exakt der Zeichenfolge, die Sie eingeen. Wenn Sie also nach \"abt 1850\" suchen, wird ein Datum wie \"abt oct 1850\" <b>nicht</b> unter den Suchergebnissen erscheinen.</i></dd></dl>Wenn Sie eine neue Jahreszahl eingeben, wird der Bildschirm nicht sofort aktualisiert.<br />Sie müsen auf den Button <b>#pgv_lang[viewmonth]#</b> oder <b>#pgv_lang[viewyear]# </b> klicken, um die Anzeige zu aktualisieren.<br />";
$pgv_lang["annivers_show_help"]			= "~EREIGNISAUSWAHL~<br />Wenn Sie nicht angemeldeter Benutzer sind, haben Sie 2 Wahlmöglichkeiten::<br /><br /><b>1. Alle Personen</b><br />Mit dieser Option werden alle Personen und Familien angezeigt.<br /><br /><b>2. Jüngere Ereignisse (<100 Jahre)</b><br />Mit dieser Option sehen Sie alle Ereignisse des gewählten Datums/Monats, die maximal 100 Jahre zurück liegen.<br /><br />Es gibt eine dritte Option. Hierfür müssen Sie entweder angemeldet sein, oder der Administrator muss auch die Daten von lebenden Personen für alle freigeschaltet haben.<br /><br /><b>3. Lebende Personen</b><br />Mit dieser Option sehen Sie nur Ereignisse noch lebender Personen.<br /><br />Wenn Sie eine Option auswählen, wird die Anzeige aktualisiert und die Ereignisse Ihrer Wahl werden aufgelistet.<br />Die Einstellungen von Tag, Monat, Jahr und Tag-Modus oder Monats-Modus bleiben unverändert.<br />";
$pgv_lang["annivers_sex_help"]			= "~GESCHLECHT-FILTER~<br />Wenn Sie angemeldet sind (oder wenn der Administrator die Datenschutzoptionen deaktiviert hat), können Sie zwischen 3 Optionen wählen:<dl><dt><b>1. Symbol \"beide\"</b></dt><dd>Mit dieser Option (voreingestellt) werden alle Ereignisse von Personen und Familien angezeigt.</dd><dt><b>2. Symbol \"männlich\"</b></dt><dd>Hier werden nur Ereignisse von männlichen Personen angezeigt. Außerdem werden männliche Familienmitglieder bei Familien-Ereignissen angezeigt.</dd><dt><b>3. Symbol \"weiblich\"</b></dt><dd>Hier werden nur Ereignisse von weiblichen Personen angezeigt. Außerdem werden weibliche Familienmitglieder bei Familien-Ereignissen angezeigt.</dd></dl>Wenn Sie auf ein Symbol klicken, wird die Bildschirmanzeige aktualisiert und die von Ihnen ausgewählten Ereignisse werden angezeigt.<br />Die übrigen Einstellungen von Tag, Monat, Jahr, Ereignis-Filter und Anzeige-Modus bleiben unverändert.<br />";
$pgv_lang["annivers_event_help"]		= "~EREIGNIS AUSWAHL~<br />Hier können Sie wählen, ob Sie <b>alle</b> Ereignisse für Personen und Familien anzeigen möchten, oder nur ein bestimmtes Ereignis.<br /><br />Wenn Sie eine Option auswählen, wird der Bildschirm aktualisiert und die Ereignisse Ihrer Wahl werden angezeigt.<br />Die übrigen Einstellungen von Tag, Monat, Jahr, Ereignis-Filter und Anzeige-Modus bleiben unverändert.<br />";
$pgv_lang["annivers_tip_help"]			= "~TIPP~<br />Angenommen Sie hätten einen Verwandten, der am am 25. Januar 1875 geboren wurde.<br />Stellen Sie die Datumsangabe auf dieses Datum ein.<br />So können Sie sich eine Liste oder einen Kalender anzeigen lassen, für genau diesen Tag.<br />Alle Altersangaben, Jahrestage etc. werden neuberechnet auf den Tag, den Sie eingegeben haben.<br />So sehen Sie die Angaben genau so, wie Sie sich für Ihren Verwandten vor langer Zeit dargestellt haben.<br />";
$pgv_lang["day_month_help"]			= "~TAG / MONAT / JAHR ANZEIGEN~<br />Wenn Sie auf <b>Tag anzeigen</b> klicken, werden nur die Ereignisse genau dieses Datums in einer Liste angezeigt. Alle Jahre werden durchsucht, deshalb können hier auch nur Tag und Monat angegeben werden. Eine Änderung der Jahreszahl bewirkt nichts.<br />Sie können die Liste einschränken, in dem Sie die Option \"Jüngere Ereignisse\" auswählen, oder (falls möglich) \"Lebende Personen\" auswählen.<br />Die Altersangaben in der Liste beziehen sich auf die angegebene Jahreszahl.<br /><br />Klicken Sie auf <b>Monat anzeigen</b> wird ein Kalender des ausgewählten Monats und Jahres dargestellt. Auch hier können Sie die Liste einschränken durch die Wahl von \"Jüngere Ereignisse\" oder \"Lebende Personen\".<br />Wenn Sie ein Jahr in der Vergangenheit wählen und \"Jüngere Ereignisse\" wählen, erhalten Sie einee realistischen Eindruck, wie sich der Kalender Ihrer Vorfahren darbot. Alle Altersangaben beziehen sich auf die angegebene Jahreszahl.<br /><br />Der Button <b>Jahr anzeigen</b> zeigt eine Liste der Ereignisse des gewählten Jahres.<br />Auch hier können Sie die Liste einschränken durch die Wahl von \"Jüngere Ereignisse\" oder \"Lebende Personen\".<br />Eine weitere Möglichkeit ist die Anzeige der Ereignisse aus mehreren Jahren: Geben Sie einfach die Endziffern der zweiten Jahreszahl hinter der ersten Jahreszahl ein, als Trennzeichen verwenden Sie ein \"-\" (z.B. \"1992-4\" für alle Ereignisse von 1992 bis 1994), oder 1976-1984 für alle Ereignisse von 1976 bis 1984).<br />- Sie können auch einfach die nur die ersten Ziffern einer Jahreszahl angeben, um Ereignisse zu suchen, deren Jahreszahl mit diesen Ziffern beginnt. (z.B.: 197 für alle Ereignisse von 1970 bis 1979)<br /><br />Wenn Sie das <b>Jahr wechseln</b> möchten <b>müssen</b> Sie einen der drei Buttons benutzen.<br /><br />Alle anderen Einstellungen bleiben unverändert, wenn Sie einen dieser Buttons anklicken.<br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]			= "~AUSSCHNITTSAMMELBEHÄLTER~<br />Der Ausschnittssammelbehälter erlaubt \"Ausschnitte\" aus diesem Stammbaum zu sammeln und in eine separate GEDCOM-Datei zu speichern, die man anschließend herunterladen kann.<br /><br />* Wie wählt man Abschnitte aus ?<br />Jeder anklickbare Name führt auf die Detail-Seite der betreffenden Person (Familie, Quelle). Dort gibt es die Option \"Zum Ausschnittsammelbehälter hinzufügen\".<br />Klicken Sie auf diesen Link und Sie gelangen zu einer Liste von Optionen.<br /><br />* Wie herunterladen ?<br />Sobald Sie Elemente in Ihrem Sammelbehälter haben, können Sie diese durch Klick auf \"Jetzt herunterladen\" herunterladen.<br />Folgen Sie den weiteren Anweisungen.";
$pgv_lang["clip_download_help"]			= "~AUSSCHNITTE HERUNTERLADEN~<br /><br />Wenn Sie diesen Link anklicken, gelangen Sie auf eine andere Seite.<br />Falls in den von Ihnen gesammelten Ausschnitten auch Multimedia-Objekte referenziert sind, werden auch diese auf der Seite angezeigt.<br />Folgen Sie den Anweisungen.";
$pgv_lang["empty_cart_help"]			= "~AUSSCHNITTSAMMELBEHÄLTER LEEREN~<br /><br />Klicken Sie auf diesen Link, um den Ausschnittsammelbehälter zu leeren.<br /><br />Falls Sie nicht ALLE Personen, Familien etc. aus dem Sammelbehälter entfernen möchten, können Sie auch einzelne Elemente entfernenen, indem Sie auf den jeweiligen \"Entfernen\"-Link in der Namensbox klicken.";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~ÄNDERUNGEN AN DER GEDCOM-DATEI ANZEIGEN~<br /><br />Wenn Sie diese Meldung sehen, bedeutet das 2 Dinge:<br /><br />1. Jemand hat Änderungen an der GEDCOM-Datei vorgenommen.<br />Einer oder mehrere Datensätze wurden hinzugefügt, verändert oder gelöscht.<br /><br />2. Die Änderungen wurden bisher noch nicht vom Administrator akzeptiert.<br />Sobald die Änderungen akzeptiert oder abgelehnt wurden, wird diese Meldung nicht mehr angezeigt.<br /><br /><br />Indem Sie auf den Link klicken, sehen Sie, welche Änderungen beantragt wurden.<br />Wenn Sie bemerken, dass eine Änderung nicht korrekt ist, informieren Sie bitte den Administrator.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~Die SUCH-SEITE~<br /><br />Obwohl diese Seite sehr einfach aussieht, arbeitet Sie mit einem vielseitigen Such-Algorithmus.<br /><br />Die meisten Genealogie-Webseiten ermöglichen nur eine einfache (Nach-)Namen-Suche.<br />Auf dieser Seite können Sie praktisch nach allem suchen.<br /><br />Das Such-Feld auf der linken Seite ist das gleiche wie im Seitenkopf.<br /><br />Wenn Sie nach Personen in Verbindung mit einer bestimmten Jahreszahl suchen, geben Sie nur das Jahr ein. Das Programm wird alle Verbindungen finden.<br /><br />Suchen Sie einen Namen oder einen Ort ?<br />Geben Sie den Namen oder den Ort -vollständing oder teilweise- ein, und das Programm erledigt den Rest.<br /><br />SOUNDEX (Phonetische) Suche<br />Mit diesen Such-Feldern auf der rechten Seite, können Sie nach Namen von Personen oder Orten suchen, auch wenn Sie die genaue Schreibweise nicht kennen.<br /><br />Sie finden weitere Hilfe, wenn Sie auf die Fragezeichen an den Feldern klicken.<br /><br />";
$pgv_lang["search_enter_terms_help"]		= "~SUCH-BEGRIFFE EINGEBEN~<br /><br />In dieses Feld können Sie Suchkriterien wie Daten, Geburtsnamen, Nachnamen, Orte usw. eingeben<br /><br /><b>Wildcarts (Joker)</b><br />Wildcarts, die Sie sicherliche kennen (wie * oder ?), sind nicht erlaubt, aber das Programm \"vermutet\" wildcarts.<br />Was bedeutet das ?<br />Angenommen Sie geben in in das Such-Feld folgendes ein: \"<b>Pete</b>\"<br />Als Ergebnis erhalten Sie (vorausgesetzt diese Namen sind in der Datenbank enthalten):<br /><b>Pete</b> Schmitd<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />irgendjemand --Geburt 01 january 1901 <b>Pete</b>rsburg<br />etc., etc.<br /><br /><b>Daten</b><br />Geben Sie ein Datum in das Such-Feld ein und Sie erhalten eine Liste aller Personen, die mit dieser Jahreszahl in Verbindung stehen.<br />Wenn Sie 1950 eingeben, erhalten Sie alle Personen, die in diesem Jahr geboren wurden, geheiratet haben, gestorben sind usw.<br /><br />Wenn Sie eingeben \"4 Dec\", werden alle Personen, die Verbindung zu einem Ereignis an einem 4. Dezember haben, aufgelistet.<br />Es werden aber auch Personen mit Ereignissen am 14. oder 24. Dezember aufgelistet.<br />Wie Sie sehen, werden auch hier Wildcarts angenommen, so dass man Sie nicht eingeben muss (darf!).<br /><br /><b>Richtige Datumsangabe</b><br />Das Programm sucht nach den Daten, so wie Sie in der GEDCOM-Datei eingetragen sind.<br />D. h., wenn Sie nach einem Ereignis an einem 14. Dezember suchen, sollten Sie <br /><b>14 dec</b><br /> eingeben, weil diese (englische) schreibweise in GEDCOM-Dateien verwendet wird.<br />Wenn Sie z.B. eingeben \"<b>dec 14</b>\", würde das Ergebnis eine Person sein, die z.B. mit dem Datum 08 <b>dec</b>ember 18<b>14</b> verbunden ist.Sie können auch reguläre Ausdrücke in der Sucher verwenden. Um z.B. alle Personen zu finden, die Daten im 20. Jahrhunder haben, geben Sie im Suchfeld ein 19[0-9][0-9], dann erhalten Sie Personen mit Daten von 1900 bis 1999.<br /><br />Wenn Sie weitere Hilfe zu diesem Such-System benötigen, teilen Sie uns dies mit, damit wir die Hilfe-Datei erweitern können.";
$pgv_lang["soundex_search_help"]		= "~NAMEN NACH AUSSPRACHE SUCHEN - SOUNDEX (PHONETISCHE) NAMENS SUCHE~<br /><br />Die SOUNDEX Namens-Suche ist ausgesprochen leistungstark.<br />Zunächst eine kurze Erläuterung zu Soundex:<br /><br />Soundex sortiert Namen, die gleich klingen aber verschieden geschrieben werden, zusammen. Der Soundex-Code eines Namens beginnt mit dem ersten Buchstaben des Nachnamens, gefolgt von einem 3-ziffrigen Code, der die ersten drei folgenden Konsonanten repräsentiert. Nullen werden angefügt, falls der Name zu kurz ist.<br /><br />Für einen englischen Namen bedeutet das:<br />Wenn Sie nach \"Smith\" suchen, können Sie als Ergebnis folgende erhalten:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote etc.<br /><br />Über die eigentliche Codierung brauchen Sie sich keine Gedanken zu machen.<br />Geben Sie einfach einen Namen ein, nachdem Sie suchen, und das Programm erledigt die Aufgabe.<br /><br />Die Soundex-Suche ist sehr nützlich, wenn man die genaue Schreibweise eines Namens nicht kennt.<br />Es kann auch vorkommen, dass beim Eingeben einer Person in die Datenbank ein (Tipp-)Fehler passiert ist.<br />Mit dem Soundex-System finden Sie auch solche Namen.<br /><br />Um damit vertraut zu werden, versuchen Sie nach einem Namen zu suchen, aber geben Sie ihn in veränderter Schreibweise in das Feld ein.<br /><br />Bei der Soundex-Suche genügt schon ein Name als Ausgangspunkt.<br />Sie können nach einem Vor-, Nachnamen oder einer Ortsangabe suchen.<br />Wenn Sie mehrere Angaben machen, werden diese \"UND\"-verknüpft.<br />Sie können die ANzahl der Suchergebnisse auch verringern, wenn Sie zusätzliche eine Jahreszahl oder einen Zeitraum eingeben. Z.B.: 1950 oder 19[5-7][0-9], letzteres bedeutet 1950 bis 1979.<br />Das Suchergebnis enthält alle Personen bei denen ein Ereignis am betreffenden Ort in der angegebenen Zeitspanne eingetragen ist.";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~PERSÖNLICHE INFORMATIONEN SEITE~<br /><br />Auf dieser Seite werden alle Details zu einer Person aufgelistet.<br /><br />Falls ein Bild vorhanden ist, wird es links oben angezeigt.<br />Direkt neben dem Bild (sofern vorhanden) sehen Sie alle Namen der Person.<br />Zu den Namen können Notizen oder Quellen angegeben sein. Wenn zu einem Namen diese Angaben vorhanden sind, werden Sie jeweils unter dem Namen angezeigt.<br />Wenn die Person auch unter anderem Namen bekannt ist (AKA = Also Known As), erscheint dies hier ebenfalls.<br /><br />Wenn Sie Rechte zum Editieren der Daten haben, sehen Sie bei einigen Angaben auch Links zum Editieren oder Löschen.<br /><br />Auf dieser Seite gibt es außerdem die Registerkarten \"Persönliche Fakten und Details\", \"Notizen\", \"Quellen\", \"Multimedia\" und \"Direkte Verwandtschaft\".<br /><br />Auf diesen Registerkarten finden Sie alle Informationen die in der GEDCOM-Datei zu dieser Person gespeichert sind.<br /><br />Die Registerkarte \"Perönliche Fakten und Details\" zeigt die Daten der Person und zu Hochzeiten. Wenn Sie auf ein Datum auf dieser Registerkarte klicken, gelangen Sie zum Jahrestagkalender für dieses Datum, der Ihnen andere Ereignisse dieses Datums aus der GEDCOM-Datei zeigt. Wenn Sie auf einen Ort klicken, gelangen Sie in die Liste der Orte und finden so andere Personen, in deren Leben dieser Ort irgendeine Rolle spielte. Bei Hochzeiten und anderen Familienereignissen, wird der Name des Ehepartners angezeigt, so dass Sie direkt zum Partner gelangen können; außerdem ist ein Link zur Familien-Seite vorhanden.<br /><br />Die \"Notizen\"-Registerkarte zeigt alle  allgemeinen Notizen, die zu dieser Person vorhanden sind.<br /><br />Die Registerkarte \"Quellen\" zeigt alle Quellen, in denen diese Person genannt wird. Klicken Sie auf den Titel einer Quelle, erhalten Sie weitere Informationen zu dieser Quelle, sowie eine Liste von weiteren Personen, die in dieser Quelle genannt werden.<br /><br />Die Registerkarte \"Multimedia\" zeigt alle Bilder oder andere Media-Dateien, die zu dieser Person vorhanden sind. Wenn Sie auf ein Thumbnail eines Bildes klicken, öffnet sich ein größeres Bild-Betrachtungsfenster.<br /><br />Die Registerkarte \"Direkte Verwandschaft\" listet die Eltern und Geschwistern, sowie die Ehepartner und Kinder dieser Person auf. Alle Personen sind in Boxen dargestellt, die den Boxen in den Diagrammen ähneln.<br /><br />Am rechten Rand des Bildschirmes sehen Sie eine Box mit Links.<br />Die meisten Links in dieser Box entsprechen denen im Menü der Kopfzeile. Wenn Sie z.B. auf den \"Stammbaum\"-Link an der rechten Seite klicken, gelangen Sie zum Stammbaum DIESER PERSON. Das ist der Unterschied zu den Links im Menü, denn dort führt der \"Stammbaum\"-Link zum Grund-Stammbaum dieser GEDCOM-Datei.<br /><br />Wenn der Administrator diese Funktion aktiviert hat, erscheint bei diesen Links rechts auch \"GEDCOM-Datensatz anzeigen\". Dieser Link zeigt Ihnen die GEDCOM Rohdaten dieser Person.<br /><br />Wenn der Ausschnittssammelbehälter aktiviert wurde, erscheint auch ein Link, der diese Person in den Ausschnittssammelbehälter hinzufügt.<br /><br />Der Link \"Verwandschaft mit mir\" erscheint nur, wenn Sie angemeldet sind und ihnen eine ID in der GEDCOM-Datei zugewiesen wurde. Sie bekommen mit diesem Link angezeigt, wie Sie mit dieser Person verwandt sind.<br /><br />Weitere Hilfe zu dieser Seite erhalten Sie, wenn Sie auf die <b>?</b> neben den Links oder Elementen klicken.";
$pgv_lang["delete_person_help"]			= "~DIESE PERSON LÖSCHEN~<br /><br />Wenn Sie diesen Link klicken, wird die Person zum Löschen markiert.<br />Was bedeutet das?<br />Angenommen Sie möchten aus irgendeinem Grund eine Person löschen. Klicken Sie auf den Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen.<br /><br />Wenn Sie mit dem Löschen fortfahren, kann es einige Zeit dauern, bis ein Popup-Fenster erscheint, das über das erfolgreiche Löschen informiert.<br /><br />Bei näherem Betrachten werden Sie aber feststellen, dass die Person weiterhin sichtbar ist und wie zuvor ausgewählt werden kann.<br /><br />Dies ist <b>kein</b> Fehler.<br />Der Administrator wird eine Nachricht bekommen, dass Änderungen an der Datenbank erwünscht sind, und dass Sie die Person gelöscht haben.<br />Der Administrator kann Ihre Änderung akzeptieren oder ablehnen. Erst danach ist die Person unwiderruflich gelöscht.<br />Im Zweifelsfalle wird der Administrator Sie zuvor kontaktieren.";
$pgv_lang["delete_name_help"]			= "~NAMEN EDITIEREN ODER LÖSCHEN~<br /><br /><b>NAMEN EDITIEREN</b><br />Wenn Sie auf diesen Link klicken, öffnet sich ein Fenster, in dem Sie den Namen der Person verändern können.<br />Das funktioniert einfach, indem Sie die Änderungen in die Felder schreiben und auf Speichern klicken. Dann können Sie das Fenster einfach schließen.<br /><br /><b>NAMEN LÖSCHEN</b><br />Wenn Sie auf diesen Link klicken, wird der Name zum Löschen markiert.<br />Beachten Sie bitte, dass das Löschen eines Namens etwas anderes ist als das Löschen einer Person.<br />Wenn Sie den Namen löschen, so wird nur der Name von der Person entfernt. Die Person selbst wird nicht gelöscht.<br />Wenn Sie den Namen unter \"auch bekannt als\" löschen, dann trägt die Person immer noch ihre(n) anderen Namen.<br />Wenn Sie den Namen löschen, wird die Person anschließens unter \"Unbekannt\" aufgelistet werden.<br />Die Person wird aber nicht von den übrigen Verwandten getrennt, ebensowenig von den Links zu Quellen, Notizen etc.<br /><br />Wie funktioniert das ?<br />Angenommen Sie möchten aus irgendeinem Grund den Namen einer Person löschen. Klicken Sie auf den Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen.<br /><br />Wenn Sie mit dem Löschen fortfahren, kann es einige Zeit dauern, bis ein Popup-Fenster erscheint, das über das erfolgreiche Löschen informiert.<br /><br />Bei näherem Betrachten werden Sie aber feststellen, dass der Name weiterhin sichtbar ist und wie zuvor ausgewählt werden kann.<br /><br />Dies ist <b>kein</b> Fehler.<br />Der Administrator wird eine Nachricht bekommen, dass Änderungen an der Datenbank erwünscht sind, und dass Sie den Namen gelöscht haben.<br />Der Administrator kann Ihre Änderung akzeptieren oder ablehnen. Erst danach ist der Name unwiderruflich gelöscht.<br />Im Zweifelsfalle wird der Administrator Sie zuvor kontaktieren.";
$pgv_lang["add_name_help"]				= "~NEUEN NAMEN HINZUFÜGEN~<br /><br />Mit diesem Link können Sie einen weiteren Namen zu einer Person hinzufügen. Eventuell sind Personen unter anderen Namen oder Schreibweisen bekannt. Mit diesem Link können Sie einen neuen Namen zu einer Person hinzufügen, ohne die alten Namen zu verändern.";
$pgv_lang["add_sibling_help"]			= "~EINEN BRUDER ODER EINE SCHWESTER HINZUFÜGEN~<br /><br />Wenn Sie auf diesen Link klicken, können Sie ein Kind zu dieser Familie hinzufügen.<br />\"Diese Familie\" ist in diesem Fall der Vater und die Mutter, der Person, deren Seite Sie gerade betrachten.<br />Das heißt, Sie fügen einen Bruder oder eine Schwester dieser Person hinzu.<br />Das Verfahren ist einfach: Klicken Sie auf den Link, füllen Sie die Felder im Popup-Fenster aus, das wars.<br /><br />Wenn Sie einen Sohn oder eine Tochter der Hauptperson dieser Seite hinzufügen möchten, scrollen Sie ein bisschen nach unten und klicken Sie auf den Link unter \"Familie mit Ehefrau\".";
$pgv_lang["add_son_daughter_help"]		= "~EINEN SOHN ODER EINE TOCHTER HINZUFÜGEN~<br /><br />Wenn Sie auf diesen Link klicken, können Sie ein Kind zu dieser Familie hinzufügen.<br />\"Diese Familie\" ist in diesem Fall die Person, deren Seite Sie gerade betrachten und sein/ihr Ehepartner.<br />Das heißt Sie fügen einen Sohn oder eine Tochter dieser Person hinzu.<br />Das Verfahren ist einfach: Klicken Sie auf den Link, füllen Sie die Felder im Popup-Fenster aus, das wars.<br /><br />Wenn Sie einen Bruder oder eine Schwester der Hauptperson dieser Seite hinzufügen möchten, scrollen Sie ein bisschen nach obenund klicken Sie auf den Link unter \"Familiendaten als Kind\".";
$pgv_lang["link_child_help"]			= "~DIESE PERSON ALS KIND MIT EINER BESTEHENDEN FAMILIE VERBINDEN~<br /><br />Wenn Sie auf diesen Link klicken, können Sie die Person als Kind zu einer bestehenden Familie hinzufügen.<br /><br />Wenn z.B. die Eltern einer Person unbekannt sind, Sie aber feststellen, dass die Eltern auch in der GEDCOM-Datei eingetragen sind, klicken Sie auf diesen Link.<br /><br />Geben Sie die ID der Familie an (wenn Sie die ID nicht kennen, können Sie danach suchen) und die Verbindung ist schon eingetragen.";
$pgv_lang["link_husband_help"]			= "~DIESE PERSON ALS EHEMANN MIT EINER BESTEHENDEN FAMILIE VERBINDEN~<br /><br />Wenn Sie auf diesen Link klicken, fügen Sie die aktuelle Person als Ehemann zu einer bereits in der GEDCOM-Datei bestehenden Familie hinzu. Wenn Sie diesen Link klicken, wird die Person zu einer bestehenden Familie hinzugefügt, in der der Ehemann bisher unbekannt war. Die Person wird den Platz dieses unbekannten Ehemannes einnehmen. Alle Ereignisse, Hochzeitsdaten, Informationen und Kinder werden Ihre bestehenden Verbindungen zu dieser Familie beibehalten.<br /><br />Klicken Sie nur auf diesen Link und geben Sie die ID der Familie ein (wenn Sie die ID nicht kennen, können Sie danach suchen). Diese fortgeschrittene Option darf nur verwendet werden, wenn die Familie wirklich schon in der Datei existiert. Wenn Sie eine neue Familie hinzufügen möchten, verwenden Sie bitte den Link \"Ehefrau hinzufügen\".";
$pgv_lang["add_husband_help"]			= "~EINEN WEITEREN EHEMANN HINZUFÜGEN~<br /><br />Wenn Sie auf diesen Link klicken, können Sie eine neue männliche Person eintragen und mit der Hauptperson dieser Seite als Ehemann verknüpfen.<br /><br />Klicken Sie einfach auf diesen Link und es öffnet sich ein Popup-Fenster zum Eingeben der neuen Person.<br />Füllen Sie so viele Felder wie möglich aus und klicken Sie den \"Speichern\" button.<br /><br />Das ist alles.";
$pgv_lang["link_wife_help"]			= "~DIESE PERSON ALS EHEFRAU MIT EINER BESTEHENDEN FAMILIE VERBINDEN~<br /><br />Wenn Sie auf diesen Link klicken, fügen Sie die aktuelle Person als Ehefrau zu einer bereits in der GEDCOM-Datei bestehenden Familie hinzu. Diese fortgeschritten Option darf nur verwendet werden, wenn die Familie wirklich schon in der Datei existiert. Wenn Sie eine neue Familie hinzufügen möchten, verwenden Sie bitte den Link \"Ehemann hinzufügen\".";
$pgv_lang["add_wife_help"]			= "~EINE WEITERE EHEFRAU HINZUFÜGEN~<br /><br />Wenn Sie auf diesen Link klicken, können Sie eine neue weibliche Person eintragen und mit der Hauptperson dieser Seite als Ehefrau verknüpfen.<br /><br />Klicken Sie einfach auf diesen Link und es öffnet sich ein Popup-Fenster zum Eingeben der neuen Person.<br />Füllen Sie so viele Felder wie möglich aus und klicken Sie den \"Speichern\" button.<br /><br />Das ist alles.";
$pgv_lang["add_new_parent_help"]		= "|#pgv_lang[multiple_help]#<br />~EINEN VATER oder EINE MUTTER HINZUFÜGEN~<br /><br />Bei vielen Personen in der GEDCOM-Datei sind Vater bzw. Mutter noch nicht eingetragen.<br /><br />In diesem Fall sehen Sie auf der Seite <b>Persönliche Informationen</b>, Registerkarte <b>Direkte Verwandschaft</b> in der Tabelle <b>Familiendaten als Kind</b> die Links zum hinzufügen von Vater oder Mutter.<br /><br /><b>ANMERKUNG:</b><br />Bitte beachten Sie, dass diese Link dazu da sind, Eltern einzutragen, wenn keine Eltern vorhanden sind.<br />Wenn Vater oder Mutter bereits in die GEDCOM-Datei eingetragen sind, benutzen Sie bitte den folgenden Link: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, den Sie ebenfalls auf der Seite der persönlichen Informationen unterhalb der letzten Tabelle finden.";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~NEUE EREIGNISSE HINZUFÜGEN~<br /><br />Hier können Sie ein Ereignis zu einer (oder mehreren) Person(en) hinzufügen.<br /><br />Wählten Sie zunächst das Ereignis aus der dropdown-Liste, klicken Sie dann auf den \"Hinzufügen\" Button.<br />In der dropdown-Liste befinden sich schon alle möglichen Ereignisse, die zum Hinzufügen in Frage kommen.<br />";
$pgv_lang["add_custom_facts_help"]		= "~Ein benutzerdefiniertes Ereignis hinzufügen~<br />Wenn Sie das Ereignis, das Sie hinzufügen möchten, in der Liste der vordefinierten Ereignisse nicht finden können, so benutzen Sie ein <b>Benutzerdefiniertes Ereignis</b>.<br />Es gibt bei der Eingabe keinen wesentlichen Unterschied zu einem vordefinierten Ereignis.<br />Sie müssen nur für das Ereignis zusätzlich eine Bezeichnung eingeben. Nutzen Sie hierfür das oberste Feld: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~EINE NEUE NOTIZ HINZUFÜGEN~<br />Wenn Sie eine Notiz zu einer (oder mehreren) Person(en) hinzufügen möchten, können Sie das hier tun.<br />Klicken Sie einfach auf den Link, dann öffnet sich ein Popup-Fenster und Sie können die Notiz dort eingeben.<br /><br />Wenn Sie fertig sind, klicken Sie auf den Button unter der Box und schließen Sie das Popup-Fenster - fertig.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~EINE NEUE QUELLE HINZUFÜGEN~<br /><br />Hilfe noch nicht fertiggestellt";
$pgv_lang["add_media_help"]			= "~EINE NEUE MULTIMEDIA-DATEI HINZUFÜGEN~<br /><br />Dies ist eine sehr nützliche Funktion.<br />Obwohl das Programm die Daten auch ohne Bilder schon sehr hübsch darstellt, wird die Optik durch hinzugefügte Bilder oder andere Multimedia-Dateien doch deutlich aufgewertet.<br /><br /><b>Hierbei sollten Sie allerdings ein paar Dinge beachten.</b><br />Wie Sie sicher wissen, gibt es unzählige Formate für Multimedia-Dateien. Auch wenn PhpGedView die meisten davon verarbeiten kann, sollte man bestimmte Hinweise berücksichtigen.<br /><br /><b>Dateityp</b><br />Bilder können in verschiedenen Dateitypen gespeichert werden.<br />z.B. picture.jpg / picture.png / picture.bmp / picture.gif / etc.<br />Alle Bilder dieses Beispieles können die selben Größe (Pixelzahl) haben, aber die Dateien werden sich in ihrer Größe stark unterscheiden.<br /><br /><b>Auflösung</b><br />Die Auflösung eines Bildes wird in \"dpi\" (dots per inch = Punkte pro Inch, ein Inch=Zoll sind 2,54 mm) angegeben (manchmal Angabe auch in dots pro cm). Sie können diese Angabe im Grunde vergleichen mit den Unterschieden zwischen 25 ASA - 200 ASA - 800 ASA in der herkömmlichen Fotografie.<br />Je höher die Auflösung, umso besser die Qualität, aber um so größer wird auch die Datei.<br />Für ein Bild im Internet sind 75 dpi normalerweise gut genug.<br /><br /><b>Farbtiefe</b><br />Die dritte Möglichkeit, eine Datei kleiner zu bekommen, ist die Anzahl der Farben zu vermindern.<br />Die Anzahl der Farben kann variieren zwischen 2 (Schwarz-Weiß) und \"True-Colour\" also einer wirklichkeitsgetreuen Farbdarstellung.<br />Natürlich ist die Datei umso größer, je mehr Farben benutzt werden.<br /><br /><b>Warum ist es wichtig kleine Dateien zu verwenden ?</b><br /><br />Zuallererst weil der Web-Speicherplatz begrenzt ist.<br />Je größer die einzelnen Dateien sind, umso mehr Platz belegen wir auf dem Server. Je mehr Platz man belegt, umso mehr muss man in der Regel dafür bezahlen.<br /><br />Übertragungsdauer. Wenn Sie große Dateien verwenden, muss der Besucher sehr lange warten, bis die Datei vom Server auf seinen Rechner übertragen wurde.<br />Nicht jeder verfügt über einen Breitband-Anschluss oder DSL.<br /><br /><b>Wie laden Sie Ihre Multimedia-Datei hoch ?</b><br />Kurz gesagt: Es geht nicht.<br />Auch aus den eben genannten Gründen können Sie Ihre Datei nicht direkt in die Datenbank hochladen.<br /><br /><b>Was nun?</b><br />Kontaktieren Sie den Administrator und teilen Sie ihm mit, dass Sie eine Datei beisteuern möchten. Er kann Ihnen auch mitteilen, was das optimale Format ist.<br />Wenn Sie Bilder im richtigen Format haben, können Sie diese per E-Mail an den Administrator schicken. Er wird die Bilder prüfen und auf die Webseite hochladen.<br />Anschließend können Sie diese Multimedia-Dateien mit Personen verknüpfen, indem Sie diesen Link verwenden.";
$pgv_lang["add_facts_general_help"]		= "~Allgemeine Informationen über das Hinzufügen~<br />Wenn Sie ein Ereignis, eine Notiz, Quelle oder eine Multi-Media-Datei zu einer oder mehreren Person(en) hinzugefügt haben, so muss dieser Vorgang erst von einem Benutzer mit \"Akzeptieren\"-Rechten überprüft werden.<br />Inzwischen sind die Änderungen auf der Seite nur für Benutzer mit Editier-Rechten sichtbar und mit einem andersfarbigen Rahmen gekennzeichnet. Wenn die Angaben überprüft sind, verschwinden die andersfarbigen Rahmen und die Daten werden wie üblich dargestellt.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Auf dieser Seite können Sie Ihre persönlichen Einstellungen verändern.<br /><br />Sie können Ihren Benutzernamen, den richtigen Namen, Ihr Passwort, die Sprachanzeige, E-Mail-Adresse, verwendetes Theme und die bevorzugte Kontakt-Methode anpassen.<br /><br />Was Sie nicht selbst verändern können, ist die ID Ihrer Person in der GEDCOM-Datei.<br /><br />";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />In diesem Feld können Sie Ihren Benutzernamen ändern.<br />Wenn Sie einen neuen Benutzernamen haben möchten, so können Sie ihn hier eintragen.<br /><br />Beim Benutzernamen müssen Sie auf <b>Groß-/Kleinschreibung</b> achten. Das bedeutet, das \"John\" nicht das gleiche ist wie \"john\" oder \"JOHN\".<br /><br />Sie sollten <b>ausschließlich</b> Buchstaben des vom Programm unterstützten Alphabets (große oder kleine Buchstaben), Ziffern, Bindestriche (-) und Unterstriche (_) verwenden.<br /><br />Verwenden Sie <b>keine</b> Interpunktionszeichen, Leerzeichen oder andere Sonderzeichen wie Umlaute etc.";
$pgv_lang["edituser_fullname_help"]		= "~#pgv_lang[fullname]#~<br /><br />In diesem Feld können Sie Ihren richtigen (vollständigen) Namen ändern.<br />Auch wenn Sie diese Änderung selbst vornehmen können, sollten Sie hierüber wenigstens den Administrator informieren.<br />So wie Sie andere zur Zeit angemeldete Benutzer sehen können, so können diese Sie auch sehen. Wenn also plötzlich ein unbekannter Name auftaucht, so könnte das leicht Verwirrung stiften.<br />";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Diese interne ID-Nummer (GEDCOM-ID), die auf Ihre Daten in der GEDCOM-Datei verweist.<br /><br />Diese ID können Sie nicht selbst ändern.<br />Der Verweis wird vom Administrator eingetragen.<br />Wenn Sie glauben, dass Ihre ID nicht korrekt ist, kontaktieren Sie bitte den Administrator, damit er sie ändern kann.<br />";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Dies ist die Ausgangsperson aller Ihrer Diagramme.<br />Bei der Ausgangsperson beginnen die Diagramme.<br />Wenn Sie z.B. einen Stammbaum anzeigen lassen, dann ist diese Person die äußerste Person am linken Rand.<br />Natürlich muss diese Person nicht Sie selbst sein. Sie können jede Person auswählen, solange Sie berechtigt sind die Person überhaupt zu sehen.<br />In einigen Diagrammen können Sie die Ausgangsperson auch speziell nur für diese Seite ändern.<br />";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />Es ist sinnvoll Ihr Passwort regelmäßig zu verändern.<br />Sie müssen bedenken, dass jeder, der Ihren Benutzernamen und Ihr Passwort kennt, auch Ihre persönlichen Daten einsehen kann.<br />Ein Passwort sollte aus wenigstens 6 Zeichen bestehen. Je länger, umso sicherer. Sie können alle Buchstaben des Alphabets und Ziffern verwenden, sowie alle Zeichen auf der Tastatur.<br /><b>Anmerkung:</b> Sicherheitshalber sollten Sie <b>nicht</b> Anführungszeichen (\") oder Hochkommata (') verwenden! Das könnte zwar funktionieren, die Funktion ist aber nicht sichergestellt.<br /><br /><b>Ideal ist eine Kombination aus Großbuchstaben, Kleinbuchstaben, Ziffern und anderen Zeichen</b>. Beispiel: 5Z_q\$P4=r9.<br /><br />Wie beim Benutzernamen, so müssen Sie auch beim Passwort auf <b>Groß-/Kleinschreibung</b> achten. Das bedeutet, das \"Jo5hn\" nicht das gleiche ist wie \"jo5hn\" oder \"JO5HN\".";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Wenn Sie Ihr Passwort verändert haben, muss es ein zweites Mal eingegeben werden.<br />Dies soll sicherstellen, dass Sie sich nicht bei der Eingabe vertippt haben.<br />Wenn erkannt wird, dass die beiden Eingaben nicht übereinstimmen, erhalten Sie eine Fehlermeldung: <b>#pgv_lang[password_mismatch]#</b>.<br />Beide Felder (Passwort- und Bestätigungsfeld) werden geleert und Sie müssen Ihr neues Passwort nochmals 2-mal eingeben.<br />";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Hier stellen Sie eine Ausgabesprache ein, in der Sie diese Seite normalerweise betrachten möchten.<br />Das Programm erkennt normalerweise die <b>Bevorzugte Sprache </b>-Einstellung Ihres Browsers, so dass Sie in den meisten Fällen hier gar keine Eingabe machen müssen.<br />Trotzdem können Sie, wenn Ihr Browser z.B. auf Englisch eingestellt ist, diese Seite unabhängig davon auch standardmäßig auf Deutsch oder Holländisch ausgeben lassen.<br />";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Ihre korrekte E-Mail Adresse ist wichtig, damit der Administrator mit Ihnen in Kontakt bleiben kann.<br />Wenn Sie eine neue E-Mail Adresse erhalten (z.B. bei Providerwechsel), vergessen Sie bitte nicht, dies auch hier einzutragen.<br />Falls Sie mehrere E-Mail-Adressen haben und für genealogische Fragen eine bestimmte Adresse bevorzugen, so geben Sie sie bitte hier an.<br />";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Diese Seite können Sie sich in verschiedenen Themes anzeigen lassen.<br />Man könnte es auch als \"Seiten-Layout\" bezeichnen. In jedem Theme sehen Sie die selben Daten aber in einer anderen Darstellung.<br />Es ist vergleichbar mit dem Wechsel eines Bilderrahmens oder dem Aufhängen eines Bildes in einem anderen Raum. Das Bild verändert sich dabei nicht, aber die Ansicht ist doch eine andere.<br />Probieren Sie es einfach aus. Stellen Sie ein anderes Theme ein. Geben Sie hier Ihr bevorzugtes Theme an.<br />Immer wenn Sie sich bei dieser Seite anmelden, wird das Programm dann \"ihr\" bevorzugtes Theme verwenden.<br />";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br />Das Nachrichten-System dieser Seite bietet verschiedene Methoden an.<br />Die Sende-Methode wird vom Administrator ausgewählt.<br />Die Methode zum <b>Nachrichten-Empfang</b> können Sie hier einstellen.<br />Derzeit stehen 4 verschiedene Methoden zur Verfügung.";
$pgv_lang["mail_option1_help"]			= "Wenn Sie diese Option nutzen, wird das interne PhpGedView Nachrichtesystem benutzt und es werden keine E-Mails versand.<br />So werden Sie nur <b>interne Nachrichten</b> von den anderen Nutzern erhalten.<br />Wenn ein anderer Nutzer Ihnen eine Nachricht von dieser Seite aus schickt, wird diese im Nachrichten-Block auf Ihrer MeinGedView Seite erscheinen (sofern Sie den Block nicht deaktiviert haben).<br />";
$pgv_lang["mail_option2_help"]			= "Diese Option entspricht der Einstellung #pgv_lang[messaging]# mit einer Ergänzung.<br />Zusätzlich wird eine Kopie der Nachricht an die E-Mail-Adresse geschickt, die Sie angegeben haben.<br />Dies ist die standardmäßig eingestellte Option.<br />";
$pgv_lang["mail_option3_help"]			= "Mit dieser Option, werden Sie die Nachrichten nur per E-Mail erhalten.<br />Die anderen Benutzer können Sie nicht über das interne Mail System erreichen.<br />";
$pgv_lang["mail_option4_help"]			= "Mit dieser Option werden Sie überhaupt keine Nachrichten erhalten.<br />";

//-- Add user


//-- Admin
$pgv_lang["admin_help"]				= "Auf dieser Seite finden Sie alle Links zur Konfigurationes-Seiten, Dokumentation und Logfiles.<br /><br />Die <b>System-Zeit</b>, direkt unter der Seiten-Überschrift zeigt die Uhrzeit des Servers, auf dem Ihre Seite gehostet ist. Die angezeigte Zeit ist die, bei der Sie die Seite geöffnet (oder neu geladen) haben.<br /><br /><b>ACHTUNG</b><br />Wenn unterhalb der System-Zeit eine Warnung erscheint, bedeutet das, dass die Datei <b>config.php</b> noch schreibrechte besitzt!<br />Nachdem Sie Ihre Seite konfiguriert haben, sollten Sie zur <b>Sicherheit</b> die Rechte für diese Datei wieder auf read-only (nur lesen) setzen.<br />Dies müssen Sie <b>manuell</b> tun, da PhpGedView diesen Schritt (derzeit) nicht durchführen kann.#pgv_lang[readme_help]#<br /><br />Außer den Möglichkeiten: Readme-Datei, Benutzerhandbuch und Log File, werden Sie weitere Hilfe auf den Seiten finden, die Sie aufrufen.";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~DIE BENUTZER VERWALTUNG~<br /><br />Auf dieser Seite können Sie die vorhandenen Benutzer verwalten und neue anlegen.<br /><br /><b>Liste vorhandener Benutzer</b><br />In dieser Tabelle werden die vorhandenen Benutzer, deren Status und Rechte angezeigt.<br />Sie können Benutzer <b>löschen</b> oder <b>bearbeiten</b>.<br /><br /><b>Neuen Benutzer hinzufügen</b><br />Dieses Formular ist ähnlich wie das Formular \"Meine Benutzerdaten\".<br />Für viele Punkte gibt es keine speziellen Hilfe-Texte für Administratoren. Dort lesen Sie den Text:";
$pgv_lang["useradmin_gedcomid_help"]		= "~Nummer des GEDCOM-Datensatzfeldes INDI dieser Person~<br /><br />Diese ID muss der Administrator für den Benutzer setzen.<br />Sie identifiziert den Benutzer in der GEDCOM-Datei.<br />Sie legt auch den Zugriff des Benutzers fest für die Seiten \"Mein Datenblatt\" und \"Mein Stammbaum\".<br /><br />Für jede GEDCOM-Datei, die Sie in diesem Programm verwenden, können Sie die ID-Nummer für den Benutzer festlegen.<br />Wenn ein Benutzer in einer Datei nicht genannt wird und daher auch keine ID hat, lassen Sie dieses Feld leer.";
$pgv_lang["useradmin_rootid_help"]		= "~START PERSON FÜR DIE STAMMBAUMDARSTELLUNG~<br /><br />Für jede GEDCOM-Datei im Program können Sie eine <b>Start-Person</b> je Benutzer festlegen.<br />Wahrscheinlich möchte der Benutzer das Programm mit seinem eigenen Stammbaum beginnen, aber das ist nicht zwingend.<br /><br />Der Benutzer kann diese Einstellung selbst nach Belieben verändern.|";
$pgv_lang["useradmin_can_admin_help"]		= "~BENUTZER HAT ADMINISTRATIONSRECHTE CHECKBOX~<br /><br />Wenn diese Checkbox markiert ist, hat der Benutzer die gleichen Rechte für das Programm, wie Sie als Administrator.<dl><dt>D.h. er kann nicht nur:</dt><dd>Benutzer hinzufügen / löschen / bearbeiten</dd><dd>Eine Nachricht an alle Nutzer gleichzeitig senden</dd><dd>Die Begrüßungs-Nachrichten bearbeiten</dd><dd>Sprachdateien bearbeiten und konfigurieren</dd><dt>Sondern auch:</dt><dd>Einen Upgrade des Programmes durchführen</dd><dd>Die Konfiguration verändern</dd><dd>Die GEDCOM-Dateien verwalten</dd><dd>Die Datenschutzeinstellungen ändern</dd><dt>Und vieles andere, was hier nicht genannt ist</dt><dd>Aber außerhalb dieses Programmes hat er dadurch noch keine weiteren Rechte.</dd></dl>";
$pgv_lang["useradmin_can_edit_help"]		= "~BENUTZER ZUGRIFFSRECHTE~<br /><br />Für jede GEDCOM-Datei werden jedem Benutzer bestimmte Zugriffs- und Editier-Rechte zugewiesen.<br /><br />Bei <b>Keine</b> hat der Benutzer keinen Zugriff auf private Daten in der GEDCOM-Datei. Bei <b>Zugreifen</b> kann der Benutzer zwar keine Daten ändern und keine Änderungen akzeptieren, aber er kann private Daten einsehen.<br /><br />Bei <b>Editieren</b> kann der Benutzer Daten verändern, aber ein anderer Benutzer mit dem Recht <b>Akzeptieren</b> muss die Änderungen erst bestätigen, bevor sie in die Datenbank eingetragen werden und veröffentlicht werden.<br /><br />Bei <b>Akzeptieren</b> kann der Benutzer sowohl Daten ändern, als auch Änderungen anderer freigeben.<br /><br />Bei <b>GEDCOM verwalten</b> darf der Benutzer die Konfiguration und die Datenschutzeinstellungen dieser GEDCOM-Datei verändern.<br /><br />Administratoren haben automatisch das Recht <b>verwalten</b>.";
$pgv_lang["useradmin_verified_help"]		= "~BENUTZER HAT SICH SELBER VERIFIZIERT~<br /><br /><b>Selbst-Registrierung</b><br />Ein Benutzer kann einen neuen Benutzerzugang mit Hilfe des <b>Selbst Registratierungs</b> Moduls anlegen.<br />Wenn er dies tut, erhält er eine Mail mit einem Link zur Bestätigung seiner Angaben.<br />Wenn er diesen schon durchgeführt hat, sehen Sie diese Box aktiviert und Sie können mit dem nächsten Schritt fortfahren: <b>Benutzer-Überprüfung durch den Administrator</b>.<br />Wenn der Benutzer sich noch nicht selbst verifiziert hat, sollten Sie mit Ihrer Überprüfung warten.<br /><br /><b>Benutzer manuell erstellen</b><br />Wenn Sie dieses Formular benutzen, um einen Benutzer manuell hinzuzufügen, dann ist diese Checkbox bereits gesetzt.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~BENUTZER WURDE DURCH DEN ADMINISTRATOR FREIGEGEBEN~<br /><br />Wenn ein Benutzer sich mit Hilfe des Selbst Registratrierungs Moduls angemeldet und bereits selbst verifiziert hat, dann ist der letzte Schritt Ihre Zustimmung, bevor der Benutzerzugang freigeschaltet ist.<br /><br />Nachdem Sie Ihre Zustimmung erteilt haben, erhält der Benutzer eine E-Mail-Nachricht, dass sein Zugang nun aktiv ist und dass er sich mit seinem Benutzernamen und Passwort anmelden kann.";
$pgv_lang["useradmin_edit_user_help"]		= "~BENUTZERDATEN AKTUALISIEREN~<br /><br />Dieses Formular dient dem Administrator für Veränderungen am Benutzeraccount.<br /><br />Das Formular ist recht ähnlich wie das Formular \"Benutzer erstellen\" oder \"Meine Benutzerdaten\".";
$pgv_lang["useradmin_visibleonline_help"]		= "~ONLINE SICHTABR~<br /><br />Wenn aktiviert, können andere angemeldete Benutzer sehen, wenn diese Person ebenfalls online ist und umgekehrt. Wenn Sie nicht möchten, dass andere Personen sehen wenn Sie online sind, deaktivieren Sie die Box, dann sehen Sie aber auch nicht mehr, welche anderen Benutzer online sind.";
$pgv_lang["useradmin_editaccount_help"]			= "~BENUTZERDATEN ÄNDERN~<br /><br />Wenn aktiviert, kann dieser Benutzer seine Benutzerdaten verändern. So können Sie einen einzelnen Benutzer erstellen, der von mehreren Personen verwendet wird, ohne dass diese Personen die Benutzerdaten ändern können.";

//-- Upgrade utility
$pgv_lang["how_upgrade_help"]			= "~Das Upgrade-Tool~<br />Das Upgrade-Tool überwacht die Aktualisierung Ihres bestehenden PhpGedView auf eine neuere Version, die Sie aus dem Internet heruntergeladen haben.<br /><br />Eine neue Version herunterladen ?<br />Eine neue Version können Sie entweder direkt von http://sourceforge.net/projects/phpGedView/ herunterladen oder das Upgrade-Tool kann selbst nach einer neuen Version suchen. Falls eine neue Version exisitert, werden die verfügbaren Downloads angezeigt (zip-Dateien oder gz-Dateien oder beides).<br /><br />Was wird aktualisiert ?<br />* PhpGedView<br />Dies wird alle Kern-Dateien von PhpGedView außer config.php, privacy.php und authenticate.php aktualisieren. Auch die images-Verzeichnisse werden aktualisiert.<br />* Index Dateien<br />Dies aktualisiert das Verzeichnis /index. Benutzen Sie diese Option mit Vorsicht, da alle existierenden Dateien überschrieben werden.<br />* Sprachen<br />Aktualisiert das Verzeichnis /languages.<br />* Themes<br />Aktualisiert das Verzeichnis /themes. Ebenfalls mit Vorsicht zu benutzen, da eventuelle Anpassungen überschrieben werden.<br />* Konfigurations-Datei<br />Dies überprüft Ihre aktuelle Konfigurations-Datei und aktualisiert nur die Änderungen aus der neuen Datei in Ihre Datei hinein. So wird sichergestellt, dass Sie die neueste Konfigurations-Datei mit Ihren eigenen Einstellungen haben.<br />* Privacy Datei(en)<br />Überprüft Ihre aktuelle(n) Privacy-Datei(en) und aktualisiert nur die Änderungen aus der neuen Datei in Ihre Datei hinein. So wird sichergestellt, dass Sie die neueste Privacy-Datei mit Ihren eigenen Einstellungen haben.<br />* Handbücher<br />Aktualisiert das Verzeichnis /doc.<br />* Sicherung erstellen<br />Diese Option erstellt eine Kopie der alten Dateien im Verzeichnis /backup.<br /><br />Wie kann ich aktualisieren ?<br />1. Wählen Sie die Programm-Teile, die Sie aktualisieren möchten ?<br />2. Klicken Sie auf Speichern<br /><br />Der Fortschritt der Aktualisierung wird am unteren Seitenrand angezeigt.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~HINZUFÜGEN oder UPLOAD EINER GEDCOM-DATEI~<dl><dt>Upload einer GEDCOM-Datei</dt><dd>Ein Upload wird online durchgeführt.<br />Sie können von jedem Ort aus Daten hochladen, ohne Hilfe eines FTP-Programmes.</dd><dt>Hinzufügen von GEDCOM-Dateien</dt><dd>Wenn eine Datei in Ihrem GEDCOM-Verzeichnis noch existiert, können Sie sie benutzen, ohne sie erneut hochzuladen.<br />Manchmal wählt man Hinzufügen anstelle von Upload, z.B. wegen der Dateigröße oder Upload-Einschränkungen.</dd></dl>Beide Vorgänge können in 4 einfachen Schritten durchgeführt werden.<br />Nur Schritt 1 der Prozedur ist jeweils ein anderer.<br />";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM KONFIGURATIONS DATEI~<br /><br />Dies ist die Datei in der alle Grundeinstellungen zur GEDCOM-Datei gespeichert werden.<br /><br />In der Spalte \"Konfigurations-Datei\" auf der GEDCOM-Administrations-Seite wird der Pfad und der Dateiname dieser Datei angezeigt.";
$pgv_lang["default_gedcom_help"]		= "~STANDARD GEDCOM~<br /><br />Wenn Sie mehr als 1 GEDCOM-Datei eintragen, können Sie hier angeben, welche davon die <b>Standard</b> GEDCOM-Datei für dieses Programm sein soll.<br /><br />Das heißt, dass diese Datei den Besuchern und unangemeldeten Benutzern gezeigt wird.<br /><br />Benutzer können diese Auwahl überschreiben, indem Sie in Ihrem Benutzerprofil eine andere Standard-Datei auswählen.<br />";
$pgv_lang["delete_gedcom_help"]			= "~GEDCOM LÖSCHEN~<br /><br />PhpGedView importiert Datensätze aus der GEDCOM-Datei. Wenn Sie auf <b>Löschen</b> klicken, entfernt das Programm diese Datensätze, die aus der GEDCOM-Datei importiert wurden.<br />Die eigentliche GEDCOM-Datei bleibt in dem Verzeichnis, in das Sie hochgeladen wurden, unverändert bestehen.<br /><br />Wenn Sie später wieder mit dieser GEDCOM-Datei arbeiten möchten, müssen Sie sie nicht erneut hochladen. Stattdessen können Sie die Option <b>GEDCOM-Datei hinzufügen</b> verwenden.<br /><br />Nachdem Sie \"Löschen\" geklickt haben, müssen Sie dies in einer Sicherheitsabfrage bestätigen.";

$pgv_lang["add_gedcom_help"]			= "~GEDCOM-DATEI HINZUFÜGEN~<br />Wenn Sie diese Option nutzen, müssen Sie die GEDCOM-Datei bereits <i>mit Hilfe eines externen Programmes</i>, z.B. <b>ftp</b> nauf Ihren Server hochgeladen haben.<br />Wenn die GEDCOM-Datei noch nicht auf Ihrem Server ist, dann <b>müssen</b> Sie dies erst erledigen, bevor sie mit dem \"Hinzufügen\" beginnen.<br /><br />Sie werden Schritt für Schritt durch die Prozedur geführt.<br />";
$pgv_lang["add_new_gedcom_help"]		= "~EINE NEUE GEDCOM-DATEI ERSTELLEN~<br /><br />Sie können eine komplett neue GEDCOM-Datei erstellen.<br /><br />Dazu sind nur wenige Schritte erforderlich. Schritt 1 unterscheidet sich von den bekannten Vorgängen zu upload und hinzufügen. Die übrigen Schritte sind bekannt.<dl><dt>Schritt 1: Benennen Sie die neue GEDCOM-Datei</dt><dd>Geben Sie einen Namen für die neue Datei ohne die Endung '.ged' an. Die Datei wird in dem Verzeichnis angelegt, das oberhalb des Eingabefeld zu lesen ist.<br />Klicken Sie <b>Hinzufügen</b>.</dd><dt>Schritt 2: Konfigurations Seite.</dt><dd>Die ist die Seite zur Konfiguration einer GEDCOM-Datei, die Sie schon kennen.</dd><dt>Schritt 3: Überprüfen</dt><dd>Auch dieser Schritt ist schon bekannt. Die neue GEDCOM-Datei wird überprüft und ist höchstwahrscheinlich in Ordnung.</dd><dt>Schritt 4: Datensätze importieren</dt><dd>Da es nur einen einzigen Datensatz zu importieren gibt, wird das sehr schnelle gehen.</dd><dt>Erstellung fertig</dt><dd>Sie können nun z.B. das Stammbaum-Diagramm öffnen, um die erste Person Ihrer neuen Datei zu sehen. Klicken Sie auf den Namen der Person und beginnen Sie mit der Eingabe weiterer Daten. Nun können Sie auch weitere Personen zur ersten Person hinzufügen.</dd></dl>";
$pgv_lang["download_gedcom_help"]		= "~GEDCOM-DATEI HERUNTERLADEN~<br /><br />Sie haben die Möglichkeit eine GEDCOM-Datei von Ihrem Server herunterzuladen.<br /><br />Auf der Seite \"Download GEDCOM\" haben Sie die Wahl, ob Sie die Datei vom <b>UTF-8</b>-Format in das <b>ANSI (ISO-8859-1)</b>-Format umwandeln möchten.<br />Welches Format Sie benötigen, hängt von dem Programm ab, mit dem Sie die heruntergeladene GEDCOM-Datei bearbeiten möchten.<br />Sehen Sie dazu in der Dokumentation Ihrer Software nach.";
$pgv_lang["edit_gedcoms_help"]			= "~GEDCOM-ADMINISTRATION~<br /><br />Die GEDCOM-Administrations-Seite ist die wichtigste Seite für Einstellungen an <b>vorhandenen</b> und and <b>neuen</b> GEDCOM-Dateien.<br /><dl><b>VORHANDENE GEDCOM-DATEIEN</b><br /><dt>In der <b>Vorhandene GEDCOMs</b> Tabelle haben Sie folgende Optionen:</dt><dd>Löschen</dd><dd>Bearbeiten</dd><dl><dt>Konfiguration der Datenschutzdatei</dt><dd>Die Konfiguration der Datenschutzdatei ist in jede Zeile der Tabelle integriert, weil jede GEDCOM-Datei ihre eigene zugehörige Datenschutzdatei hat.</dd></dl><dd>Standard GEDCOM</dd><dd>GEDCOM-Import</dd><dd>Download</dd><dt>Folgende 3 Spalten enthalten Informationen:</dt><dd>GEDCOM-Datei</dd><dd>GEDCOM-Bezeichnung</dd><dd>Konfigurations-Datei</dd></dl><dl><b>NEUE GEDCOM-DATEIEN</b><dt>Auf dieser Seite haben Sie die folgenden Möglichkeiten, <b>neue</b> oder <b>existierende</b> GEDCOM-Dateien zum System hinzuzufügen.</dt><dd>GEDCOM-Datei hinzufügen</dd><dd>GEDCOM-Upload </dd><dd>Eine neue GEDCOM-Datei erstellen</dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]		= "~GEDCOM-KONFIGURATION BEARBEITEN~<br /><br />Jede GEDCOM-Datei in diesem Programm hat ihre eigene <b>Konfigurations-Datei</b>.<br /><br />In diesem Formular können Sie die Grundeinstellungen vornehmen, wie z.B. Sprache, Kalenderformat, E-Mail-Optionen etc.<br />";
$pgv_lang["import_gedcom_help"]			= "~GEDCOM-DATEI IMPORTIEREN~<br /><br />In den meisten Fällen ist das Importieren einer GEDCOM-Datei ein einzelner Schritt in einer Prozedur ebenso wie das Hinzufügen oder Hochladen einer GEDCOM-Datei.<br /><br />Diese Schritte bauen aufeinander auf und müssen beendet werden, damit man mit der GEDCOM-Datei arbeiten kann.<br />Wenn Sie diese Prozedur nicht vollständig beenden, sehen Sie eine <b>Warnungs</b>-Meldung, dass die GEDCOM-Datei noch nicht importiert wurde. In diesem Fall, klicken Sie auf den Link zum (wieder)importieren der GEDCOM-Datei.<br /><br /><b>Importieren</b><br /><br />Die Konfiguration der GEDCOM-Datei werden beim Importieren nicht verändert.<br />Die alte Datenbank wird aber überschrieben.";
$pgv_lang["upload_gedcom_help"]			= "~GEDCOM-DATEI HOCHLADEN (Upload)~<br /><br />Ander als die Funktion \"GEDCOM hinzufügen\", muss noch keine GEDCOM-Datei auf Ihrem Server bereitliegen.<br /><br />In Schritt 1 wählen Sie eine GEDCOM-Datei auf Ihrem lokalen Computer aus. Geben Sie den kompletten Pfad und Dateinamen in das Textfeld ein oder nutzen Sie den Button <b>Browse</b> auf dieser Seite.<br /><br />Während des Installationsprozesses finden Sie weitere Hilfe auf der jeweiligen Seite .<br />";
$pgv_lang["validate_gedcom_help"]		= "~GEDCOM-DATEI PRÜFEN~<br /><br />Die Überprüfung der GEDCOM-Datei, die Sie hochladen oder hinzufügen findet im 3. Schritt der Prozedur statt.<br /><br />Das Programm prüft das korrekte Format von: Datumsangaben, Ortsangaben, Zeichensatz etc.<br />Einige Abweichungen kann das Programm selbst korrigieren, z.B. die Zeilenumbrüche von MacIntosh oder falsche Verwendung von Ortsangaben.<br />In diesen Fällen, sehen Sie eine Meldung, dass das Programm die Daten geändert hat.<br />Bei anderen Abweichungen erhalten Sie eine Warn-Meldung mit einem Lösungsvorschlag.<br /><br /><b>Optionale Tools</b><br />Zur Zeit gibt es 2 zusätzliche Tools:<br /><b>Personen ID ändern zu...</b> und <b>Media Hinzufügen Tool</b>.<br />Letzeres ist nur im <b>MySQL</b>-Modus verfügbar. Wenn Sie im <b>Index</b>-Modus arbeiten, wird diese Option nicht angezeigt.<br /><br /><b>Weitere Hilfe</b> finden Sie im Formular.#pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		= "~ANSI NACH UTF-8 KONVERTIEREN~<br /><br />Um sicherzustellen, dass das Programm Ihre GEDCOM-Dateien korrekt behandeln kann, sollten die Dateien im UTF-8-Format gespeichert sein.<br /><br />Viele Genealogie-Programme besitzen eine Option, um Daten im UTF-8-Format zu exportieren.<br />Falls das Programm, welches Sie benutzen, diese Option nicht anbieten sollte, kann PhpGedView die Konvertierung für Sie übernehmen.<br /><br />Beim Überprüfen der hochgeladenen oder hinzugefügten Dateien, wird PhpGedView feststelllen, ob die Datei im ANSI-Format kodiert ist.";
$pgv_lang["detected_ansi2utf_help"]		="~ANSI-CODIERUNG ERKANNT~<br /><br />Die überprüfte GEDCOM-Datei hat ANSI-Codierung.<br />Es wird dringend empfohlen, die Codierung auf UTF-8 zu ändern.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			="~FALSCHES DATUMS-FORMAT ERKANNT:~<br />DATUMS-FORMATIERUNG WIRD GEÄNDERT</b><br /><br />Das Standard-Datums-Format in PhpGedView ist (entsprechend des <b>GEDCOM 5.5 Standard</b>): DD MMM YYYY (d.h. 01 JAN 2004)<br /><br />Wenn Sie nach der Überprüfung der GEDCOM-Datei eine Meldung erhalten, dass ein falsches Datums-Format erkannt wurde, wird das Programm diese Datumsangaben in diesen Standard konvertieren.<br /><br />Sie können aber wählen zwischen: \"<b>Tag</b> vor Monat\" (DD MMM YYYY), oder \"<b>Monat</b> vor Tag\" (MMM DD YYYY).<br />Empfohlen ist die erstere Einstellung.";
$pgv_lang["addmedia_tool_help"]			= "~EINE NEUE MULTIMEDIA-DATEI HINZUFÜGEN~<br />nur im MySQL Modus</b><br /><br />Dieses Tool wurde für Benutzer entwickelt, deren Genealogie Software die Links für Multimedia-Dateien nicht exportiert (z.B. Family Tree Maker).<br /><br />Das Tool ermöglicht eine Liste von Media-Links außerhalb der GEDCOM-Datei zu verwalten. Weil diese Daten in einer separaten Tabelle gespeichert werden, müssen Sie die Daten nur einmal eingeben. So können Administratoren einfach die genealogischen Daten wie gewohnt in ihrer Software bearbeiten, die GEDCOM-Datei exportieren und anschließend mit dem Multimedia-Tool beim Importieren die Links für die Multimedia-Dateien ergänzen.<br /><br />Um das Tool zu nutzen, erstellen Sie zuerst eine Liste von Multimedia-Dateien, indem Sie die Felder ausfüllen und auf den 'hinzufügen'-Button klicken. Das Feld \"#pgv_lang[gedcomid]#\" enthält die ID des GEDCOM-Eintrages, dem das Bild zugeordnet werden soll. Im Feld \"Exerne Datei\" tragen Sie bitte den Dateinamen des zu nutzenden Bildes ein. Geben Sie die Extension der Datei im Feld \"#pgv_lang[extension]#\" an. Im Feld \"#pgv_lang[highlighted]#\" geben Sie an, ob dieses Bild hervorgehoben bzw. das erste Bild für diese Person sein soll. Das hervorgehobene oder erste Bild wird in Diagrammen benutzt und wird auf der Seite der persönlichen Informationen hervorgehoben neben dem Namen der Person dargestellt. In das Feld \"#pgv_lang[title]#\" können Sie eine Bildbeschreibung oder einen Titel für das Bild eintragen. Mit dem Feld \"#pgv_lang[order]#\" legen Sie die Reihenfolge fest, in der die Bilder auf der Registerkarte Multimedia erscheinen. Im Feld \"#pgv_lang[gedcom_file]#\" legen Sie fest, zu welchee GEDCOM-Datei das Multimedia-Objekt gehört. So können Sie das Tool für mehrere GEDCOM-Dateien einsetzen.<br /><br />Wenn die Liste komplett ausgefüllt ist, klicken Sie auf den Button \"#pgv_lang[click_to_add_media]#\", um die Änderungen in der GEDCOM-Datei zu speichern. Wenn Sie das nächste mal Ihre GEDCOM-Datei aktualisieren, müssen Sie nur das Tool starten und auf diesen Button klicken.<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~PERSÖNLICHE ID ÄNDERN IN ...~<br /><br />Dieses Tool wurde erstellt für Benutzer, deren Genealogie Software bei jedem Export andere ID-Nummern für die Personen generiert. D.h. beim ersten Export ist die ID für eine Person I100 aber beim erneuten Export ist die ID der selben Person z.B. I234. Dieses Wechseln der IDs erschwert die Verwaltung in PhpGedView, denn die ID ist die Referenz auf die sich viele Personenangaben beziegen.<br /><br />Die meisten Genealogie-Programme nutzen aber zusätzlich einen RIN oder REFN Bezeichner, um jeder Person eine eindeutige Nummer zuzuordnen, die auch als Referenz verwendet werden kann. Dieses Tool ersetzt alle IDs in der GEDCOM-Datei mit dem Wert aus dem von Ihnen gewünschten Feld (RIN oder REFN).<br /><br />";
$pgv_lang["edit_privacy_help"]			= "Auf dieser Seite können Sie alle Datenschutzeinstellungen für die ausgewählte(n) GEDCOM-Datei(en) vornehmen.<br />Unterhalb der Überschrift können Sie erkennen, ob Sie die richtige Datei bearbeiten.<br />Der Dateiname wird wie folgt dargestellt: (Pfad/NameIhrerGedcomDatei_priv.php)<br /><br />Wenn Sie weitergehende Einstellungen vornehmen möchten, können Sie auch Änderungen direkt in der Datenschutzdatei (manuell) vornehmen. Dazu finden Sie weitere Informationen auf der PhpGedView Web Seite.<br />";
$pgv_lang["invalid_header_help"]		= "~UNGÜLTIGER GEDCOM HEADER~<br />Eine GEDCOM-Datei muss in der ersten Zeile folgendermaßen beginnen: 0 HEAD. PhpGedView hat erkannt, dass Ihre GEDCOM -Datei in der ersten Zeile anders beginnt. Wenn Sie den Korrigieren-Button klicken, werden alle Zeile vor der ersten \"0 HEAD-Zeile entfernt.<br /><br />Dieser Fehler bedeutet meistens, dass das von Ihnen verwendete Programm die Datei nicht ordnungsgemäß erstellt hat oder dass es sich nicht um eine GEDCOM-Datei handelt. Sie sollten überprüfen, ob Sie die richtige Datei hochgeladen haben und ob sie mit der Zeile \"0 HEAD\" beginnt und mit der Zeile \"0 TRLR\" endet.";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSH DATEI ERKANNT~<br />PhpGedView hat erkannt, dass Ihre GEDCOM-Datei auf einem Macintosh Computer erstellt wurde. Macintosh-Dateien enthalten andere Zeilenumbrüche (r) als in Unix (n) oder Windows (rn). Die PHP-Funktionen, die PhpGedView benutzt, verlangen das Unix- oder DOS-Format. Wenn Sie auf \"Korrigieren\" klicken, wird Ihre Datei in eine DOS-Datei umgewandelt.<br />";
$pgv_lang["cleanup_places_help"]		= "~ORTE KORRIGIEREN~<br />PhpGedView hat erkannt, dass Ihre GEDCOM-Datei Ortsangaben zu GEDCOM-Daten macht, die keine Ortsangaben zulassen. Viele Genealogie-Programm, z.B. Family Tree Maker, erstellen solche GEDCOM-Dateien. PhpGedView funktioniert zwar mit diesen Dateien, aber es tauchen einige ungültige Orte in der Ortsliste auf. <br /><br />Beipiel: Ihre GEDCOM-Datei enthält folgende Zeilen<br />1 SSN<br />2 PLAC 123-45-6789<br />Nach den geltenden GEDCOM Specifikationen sollte dies eigentlich wie folgt notiert sein<br />1 SSN 123-45-6789<br />Wenn Sie diese Option auf \"Yes\" setzen, wird PhpGedView automatisch solche Fehler erkennen und korrigieren.<br />";
$pgv_lang["empty_lines_detected_help"]	= "~LEERE ZEILEN ERKANNT~<br />PhpGedView hat erkannt, dass in Ihrer GEDCOM-Datei Leerzeilen enthalten sind. Diese Zeilen können zu Fehlern führen und werden vor dem Import aus der Datei entfernt.<br />|";
$pgv_lang["skip_cleanup_help"]			= "~KORRIGIEREN ÜBERSPRINGEN~<br />Sie sollten unbedingt die von PGV vorgeschlagene Korrektur durchführen, bevor Sie die Daten importieren, andernfalls könnten einige Funktionen nicht ordnungsgemäß arbeiten.<br /><br />Sie haben aber die Möglichkeit, die vorgeschlagenen Korrekturen zu überspringen, indem Sie diesen Button anklicken, und mit dem Import der unveränderten Datei fortzufahren.<br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		="~PhpGedView KONFIGURIEREN~<br /><br />Auf dieser Seite werden die Grundeinstellungen des Programmes vorgenommen, nachdem PhpGedView neu auf Ihrem Server installiert wurde und zum ersten Mal gestartet wird..<br />#pgv_lang[review_readme]#<br /><br />Da dies <b>Grund</b>einstellungen sind, gelten Sie für das gesamte Programm und für alle GEDCOM-Dateien, die Sie darin benutzen.<br />Für jede GEDCOM-Datei können Sie zusätlich noch jeweils eigene Einstellungen festlegen.<br />Hier auf der Konfigurations-Seite können Sie auch auf den Link zur GEDCOM-Verwaltung direkt über der Tabelle klicken.<br />Normalerweise erreichen Sie disen Link im Menü \"Mein GedView Portal\".";

//-- GDBI Changes
$pgv_lang["help_gdbi_changes.php"]		= "~#pgv_lang[review_changes]#~<br /><br />Diese Liste ist einfach und verständlich.<br /><br />Der <b>Rückgängig</b> Link wird sofort ausgeführt. Es findet keine Sicherheitsabfrage statt!<br /><br />Wenn ein Benutzer etwas verändert hat und dabei auch ein <b>Datum</b> eingegeben hat, prüfen Sie bitte, ob das Datum im richtigen Format eingegeben wurde.<br />Das Datumsfeld ist ein Textfeld, so dass alle Eingaben zulässig sind.<br />Falsche Datumsformatierung kann später zu Problemen oder Fehlermeldungen führen.<br />Für weitere Hilfe über Datumsangaben in der GEDCOM-Datei, sehen Sie bitte unter <b>GEDCOM-Informationen</b> im Hilfe Menü nach.<br />";

//-- merge records
$pgv_lang["help_gdbi_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Auf dieser Seite können Sie 2 GEDCOM-Datensätze innerhalb einer GEDCOM-Datei miteinander verschmelzen. Dies ist hilfreich, wenn nach dem Verbinden von 2 GEDCOM-Dateien anschließend mehrere Personen, Familien oder Quellen doppelt vorhanden sind.<br /><br />Das Verschmelzen geschieht in 3 Schritten.<br /><ul><li><b>Schritt 1</b> erfordert die Eingabe von 2 Datensatz ID-Nummern. Diese Datensätze müssen vom gleichen Typ sein (z.B. können Sie nicht eine Person mit einer Familie verschmelzen oder eine Familie mit einer Quelle). Geben Sie im Feld \"Verschmelzen zu\" die ID des Datensatzes ein, in dem Sie die Daten nach dem Verschmelzen vorfinden möchten. Geben Sie in das Feld \"Verschmelzen von\" die ID des Datensatzes ein, aus dem Daten zum Verschmelzen entnommen werden, und der anschließend gelöscht werden kann.</li><li><b>Schritt 2</b> fragt, welche Fakten Sie jeweils aus den beiden Datensätzen behalten möchten. Klicken Sie hierzu auf die Checkboxen neben den Fakten, die Sie übernehmen möchten.</li><li><b>Schritt 3</b> zeigt Ihnen das Ergebnis des Verschmelzen an. Wie bei allen online-Änderungen, müssen auch diese Änderungen erst akzeptiert werden, bevor Sie öffentlich sichtbar werden.</li></ul><br />";

//-- Language Editor
$pgv_lang["lang_edit_help"]			= "Auf dieser Seite können Sie Ihre Sprachdateien verwalten.<br />Sie können Sprachdateien übersetzen, vergleichen und exportieren.<br />Außerdem können auswählen, welche Sprachen vom Programm unterstützt werden.<br /><br />Sie können die folgenden Optionen und Tools nutzen:";
$pgv_lang["language_to_edit_help"]		= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[language_to_edit]#</b><br /><br />Hier können Sie die Sprache auswählen, deren Texte Sie <b>bearbeiten</b> möchten.";
$pgv_lang["file_to_edit_help"]			= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[file_to_edit]#</b><br /><br /><br />Hier können Sie den Typ der Sprachdatei auswählen, die Sie verändern möchten. <br /><br />Folgende Typen sind vorhanden:<br />lang.xx.php<br />facts.xx.php<br />configure_help.xx.php<br />help_text.xx.php<br /><br />Hierbei steht xx für den Sprachcode der von Ihnen gewählten Sprache und wird automatisch eingefügt.<br />";
$pgv_lang["hide_translated_help"]		= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[hide_translated]#</b><br /><br />Wenn auf 'Ja' eingestellt, sehen Sie nur die Meldungen der gewählten Sprach, die noch nicht übersetzt wurden, d.h. die Meldungen, die in der Sprachdatei noch fehlen.<br />Nachdem Sie die Übersetzung eines Textes eingegeben haben, wird diese folglich dann auch sofort ausgeblendet.";
$pgv_lang["language_to_export_help"]		= "#pgv_lang[export_lang_utility]# >> <b>#pgv_lang[language_to_export]#</b><br /><br />Hier können Sie die Sprache wählen, aus der Sie Texte <b>exportieren</b> möchten.";
$pgv_lang["new_language_help"]			= "#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[new_language]#</b><br /><br />Hier können Sie die Sprache einstellen, die Sie als Referenz für den Vergleich mit einer anderen Datei verwenden möchten.<br /><br />Alle Veränderungen und Ergänzungen werden vom Programmiererteam zuerst in den <b>englischen</b> Dateien vorgenommen.";
$pgv_lang["old_language_help"]			= "#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[old_language]#</b><br /><br />Hier können Sie die Sprache einstellen, deren Texte Sie mit der zuvor ausgewählten Sprache vergleichen möchten.<br /><br />Nachdem Sie die Auswahl getroffen haben, klicken Sie auf den Button <b>Vergleichen</b> und Sie erhalten eine Liste der Unterschiede.<br /><br />Zum Verständnis:<br /><b>Ergänzungen</b> bedeutet: Dieser Text <b>besteht</b> in der Referenz-Datei aber <b>nicht</b> in der zweiten Datei.<br /><br /><b>Entfernte Teile</b> bedeutet: Der Text besteht <b>nicht</b> (mehr) in der Referenzdatei aber <b>ist</b> (noch) in der zweiten Datei vorhanden.";
$pgv_lang["add_new_lang_help"]			= "<b>#pgv_lang[add_new_language]#</b><br /><br />Mit dieser Auswahlliste können Sie eine neue Sprache zu PhpGedView hinzufügen und die Grundeinstellungen vornehmen, wie Sprach-Erkennungs-Code, Schriftrichtung, erster Tag der Woche in dieser Sprache, Zeitformat, Alphabet etc.<br /><br />Für weitere Hilfe zu diesen Einstellungen fügen Sie einfach eine Sprache hinzu und bearbeiten Sie die Sprache.<br />In dem neuen Fenster für die Einstellungen dieser Sprache sehen Sie einige Fragezeichen, die Ihnen weitere Hilfe bieten.";

//-- report engine
$pgv_lang["help_reportengine.php"]	= "~BERICHTE~<br />Die PGV Bericht-Routine nutzt Vorlage-Dateien im XML-Format, um automatisch PDF-Berichte zu erstellen. Zunächst müssen Sie den gewünschten Bericht auswählen. Die Liste der verfügbaren Berichte wird aus den vorhandenen Berichtsvorlagen im \"reports\"-Verzeichnis generiert. Sobald Sie einen Bericht ausgewählt haben, werden noch berichtspezifische Parameter abgefragt, z.B. welche Person oder Familie die Basis für den Bericht bilden soll oder ob Fotos angezeigt werden sollen oder nicht. Anschließend klicken Sie auf den Button \"#pgv_lang[download_report]#\", um den Bericht auf Ihren Rechner herunterzuladen.<br /><br />Sie können eigene Berichte erstellen, indem Sie eine bestehende Vorlage kopieren und den XML-Code anpassen. Um die so erstellte Vorlage zur Auswahl hinzuzufügen, speichern Sie die Datei im \"reports\"-Verzeichnis, dann wird PGV die Datei finden und automatisch zur Berichts-Auswahlliste hinzufügen.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>INHALT HILFE</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-Informationen";
$pgv_lang["help_contents_gedcom_places"]	= "Orte in der GEDCOM-Datei";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>HILFE INHALT<br /><br />ADMINISTRATOREN HILFE</b> wurde der Liste vorangestellt.<br /><br />";
$pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]				= "_PhpGedView konfigurieren";
$pgv_lang["ah3_help"]				= "_GEDCOM: Hinzufügen oder Upload";
$pgv_lang["ah4_help"]				= "_GEDCOM: Konfigurations-Datei";
$pgv_lang["ah5_help"]				= "_GEDCOM: Standard";
$pgv_lang["ah6_help"]				= "_GEDCOM: Löschen";
$pgv_lang["ah7_help"]				= "_GEDCOM: Hinzufügen";
$pgv_lang["ah8_help"]				= "_GEDCOM: neue GEDCOM-Datei erstellen";
$pgv_lang["ah9_help"]				= "_GEDCOM: Herunterladen";
$pgv_lang["ah10_help"]				= "_GEDCOM: Administration";
$pgv_lang["ah11_help"]				= "_GEDCOM: Konfiguration bearbeiten";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importieren";
$pgv_lang["ah13_help"]				= "_GEDCOM: Hochladen (Upload)";
$pgv_lang["ah14_help"]				= "_GEDCOM: Prüfen";
$pgv_lang["ah15_help"]				= "_GEDCOM: ANSI nach UTF-8 konvertieren";
$pgv_lang["ah16_help"]				= "_GEDCOM: Datenschutz-Datei konfigurieren";
$pgv_lang["ah17_help"]				= "_Benutzer-Verwaltung";
$pgv_lang["ah18_help"]				= "_Administration";
$pgv_lang["ah19_help"]				= "_GEDCOM: Multimedia-Tool";
$pgv_lang["ah20_help"]				= "_GEDCOM: Persönliche ID ändern in ...";
$pgv_lang["ah21_help"]				= "_Sprach-Dateien";
//           22 is in the help_text_vars.php




?>