<?php
/**
 * English Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @version $Id: configure_help.en.php,v 1.168.2.175 2006/09/23 23:22:47 canajun2eh Exp $
 */
if (preg_match("/configure_help\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
	print "You cannot access a language file directly.";
	exit;
}

$pgv_lang["COMMIT_COMMAND_help"] 			= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />If you wish to use a version control system such as CVS to archive changes to your GEDCOM file and your configuration or privacy settings, enter the command here.  Leave the box blank if you do not wish to use a version control system.  Valid options are <b>cvs</b> and <b>svn</b>.<br />";
$pgv_lang["COMMIT_COMMAND"] 			= "Version Control Commit Command";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multi-site search allows users to search across multiple PhpGedView websites which you have setup in the Manage Sites administration area or remotely linked to.  This option controls whether the Multi-site Search feature is available to everyone or only to authenticated users.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Show Multi-Site Search";
$pgv_lang["DBPERSIST"]					= "Use persistent database connections";
$pgv_lang["DBPERSIST_help"]				= "Controls whether PhpGedView should use persistent database connections when dealing with the database.<br /><br />When set to <b>Yes</b>, PhpGedView can re-use database connections thereby speeding up the establishing of database accesses.  However, this could cause errors if your host configuration has the maximum connections value set too low.  If you are unsure of your host's support of persistent connections, you should set this value to <b>No</b>.<br />";
$pgv_lang["INDI_FACTS_ADD"] 			= "Individual Add Facts";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to individuals.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unique Individual Facts";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to individuals.  For example, if BIRT is in this list, users will not be able to add more than one BIRT record to an individual.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[INDI_FACTS_ADD]#</i> list.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "Family Add Facts";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to families.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unique Family Facts";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to families.  For example, if MARR is in this list, users will not be able to add more than one MARR record to a family.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[FAM_FACTS_ADD]#</i> list.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Source Add Facts";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to sources.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unique Source Facts";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to sources.  For example, if TITL is in this list, users will not be able to add more than one TITL record to a source.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[SOUR_FACTS_ADD]#</i> list.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "Repository Add Facts";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to repositories.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unique Repository Facts";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to repositories.  For example, if NAME is in this list, users will not be able to add more than one NAME record to a repository.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[REPO_FACTS_ADD]#</i> list.<br />";
$pgv_lang["LANG_SELECTION"] 			= "Supported languages";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />You can change the list of languages supported by your PhpGedView site by adding or removing checkmarks as appropriate.  This changes the language choices available to your users.<br /><br />You can achieve the same thing through the <b>#pgv_lang[enable_disable_lang]#</b> link on the #pgv_lang[admin]# menu, where you can also change things such as the language's flag icon, the date format, or whether the surname should always be printed first.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Media ID prefix";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />When a new media record is added online in PhpGedView, a new ID for that media will be generated automatically. The media ID will have this prefix.<br />";
$pgv_lang["FAM_ID_PREFIX"]		= "Family ID prefix";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />When a new family record is added online in PhpGedView, a new ID for that family will be generated automatically. The family ID will have this prefix.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Facts for families to always show on Quick Update";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will always be shown on the Family tabs of the Quick Update form whether or not they already exist in the individual's record.  For example, if MARR is in the list, then fields for marriage date and marriage place will always be shown on the form.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Facts for families to show on Quick Update";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown on the Family tabs of the Quick Update form.  Only the facts in this list will be shown on the form or made available for selection in the area where you add new facts on the form.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Facts to always show on Quick Update";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will always be shown on the Quick Update form whether or not they already exist in the individual's record.  For example, if BIRT is in the list, fields for birth date and birth place will always be shown on the form.<br />";
$pgv_lang["QUICK_ADD_FACTS"]			= "Facts to show on Quick Update";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown on the Quick Update form.  Only the facts in this list will be shown on the form or made available for selection in the area where you add new facts on the form.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatically generated thumbnails";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Should the system automatically generate thumbnails for images that do not have them.  Your PHP installation might not support this functionality.<br />";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />This page provides extensive information about the server on which PhpGedView is being hosted.  Many configuration details about the server's software, as it relates to PHP and PhpGedView, can be viewed.<br />";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />This page collects all of the major topics of Configuration Help into one place.  You can view the information on your screen, or you can print it for later use.<br />";
$pgv_lang["more_config_hjaelp"]			= "<br /><b>More help</b><br />More help is available by clicking the <b>?</b> next to items on the page.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Width of generated thumbnails";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />This is the width (in pixels) that the program will use when automatically generating thumbnails.  The default setting is 100.<br />";
$pgv_lang["SHOW_SOURCES"]			= "Show sources";
$pgv_lang["SHOW_SOURCES_help"]		= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Set the privacy access level for all Sources.  If the user does not have access to Sources, the Source list will be removed from the Lists menu and the Sources tab will not be shown on the Individual Details page.<br />";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]		= "Require an administrator to approve new user registrations";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />If the option <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> is enabled this setting controls whether the admin must approve the registration.<br /><br />Setting this to <b>Yes</b> will require that all new users first verify themselves and then be approved by an admin before they can login.  With this setting on <b>No</b>, the <b>#pgv_lang[verified_by_admin]#</b> checkbox will be checked automatically when users verify their account, thus allowing an immediate login afterwards without admin intervention.<br /><br />This sets \$REQUIRE_ADMIN_AUTH_REGISTRATION in <i>config.php</i>.<br />";
$pgv_lang["SPLIT_PLACES"]		= "Split places in Edit mode";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Set this to <b>Yes</b> to split each place name by commas into subfields for easier editing.  Example :<br /><ol><li>Default mode<br /><u>Place</u>: Half Moon Bay, San Mateo, California, USA<br /><br /></li><li>Split mode<br /><u>Country</u>: USA<br /><u>State</u>: California<br/><u>County</u>: San Mateo<br/><u>City</u>: Half Moon Bay</li></ol>";
$pgv_lang["ALLOW_REMEMBER_ME"]		= "Show <b>Remember Me</b> option on Login page";
$pgv_lang["ALLOW_REMEMBER_ME_help"]	= "~#pgv_lang[ALLOW_REMEMBER_ME]#~<br /><br />Many sites allow users to choose whether they want to be remembered from the same computer the next time they visit the site.  Enabling this option will put a <b>Remember Me</b> checkbox on the Login page.  When this checkbox is checked, PhpGedView has permission to store a cookie in the user's computer.  This cookie will allow PhpGedView to remember the user between visits from the same remote computer.<br /><br />This sets \$ALLOW_REMEMBER_ME in <i>config.php</i>.<br />";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Underline names in quotes";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Many programs will place the preferred given name in \"quotes\" in the GEDCOM.  The usual convention for this is to underline the preferred given name.  Enabling this option will convert any names surrounded by quotes to &lt;span&gt; with a CSS class of \"starredname\".<br /><br />For example, if the name in the GEDCOM were 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ enabling this option would change the part of the name enclosed in quotes to &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; for printing purposes.  Depending on other settings, the browser would then display that name as <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> or <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b><br /><br />This sets \$UNDERLINE_NAME_QUOTES in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["PRIVACY_BY_RESN"]		= "Use GEDCOM (RESN) Privacy restriction";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />The GEDCOM 5.5.1 specification includes the option of using RESN tags to set Privacy options for people and facts in the GEDCOM file.  Enabling this option will tell the program to look for level 1 RESN tags in GEDCOM records.  Level 2+ RESN tags are automatically applied and will not be affected by this setting.  Note that this might slow down some of the functions of PhpGedView such as the Individual list.<br /><br />This sets \$PRIVACY_BY_RESN in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Show LDS ordinance codes in chart boxes";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Setting this option to <b>Yes</b> will show status codes for LDS ordinances in chart boxes.<ul><li><b>B</b> - Baptism</li><li><b>E</b> - Endowed</li><li><b>S</b> - Sealed to spouse</li><li><b>P</b> - Sealed to parents</li></ul>A person who has all of the ordinances done will have <b>BESP</b> printed after their name.  Missing ordinances are indicated by <b>_</b> in place of the corresponding letter code.  For example, <b>BE__</b> indicates missing <b>S</b> and <b>P</b> ordinances.<br /><br />This sets \$SHOW_LDS_AT_GLANCE in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Default tab to show on Individual page";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />This option allows you to choose which tab opens automatically on the Individual page when that page is accessed.<br /><br />This sets \$GEDCOM_DEFAULT_TAB in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Show married names on Individual list";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />This option will show the married names of females on the Individual list.  This option requires that you calculate the married names when you import the GEDCOM file.<br /><br />This sets \$SHOW_MARRIED_NAMES in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_QUICK_RESN"]		= "Show privacy fields on #pgv_lang[quick_update_title]# form";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />This option allows you to turn on or off the privacy fields on the #pgv_lang[quick_update_title]# form.  Privacy fields allow a user who is adding information through the form to override the default privacy for the fact they are entering.<br /><br />This sets \$SHOW_QUICK_RESN in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_QUICK_UPDATE"]		= "Use #pgv_lang[quick_update_title]# form";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />This option allows logged in users to submit changes through the #pgv_lang[quick_update_title]# form.<br /><br />This sets \$USE_QUICK_UPDATE in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archive SearchLog files";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />How often should the program archive Searchlog files.<br /><br />This sets \$SEARCHLOG_CREATE in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHANGELOG_CREATE"]		= "Archive ChangeLog files";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />How often should the program archive Changelog files.<br /><br />This sets \$CHANGELOG_CREATE in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHART_BOX_TAGS"]		= "Other facts to show in charts";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />This should be a comma or space separated list of facts, in addition to Birth and Death, that you want to appear in chart boxes such as the Pedigree chart.  This list requires you to use fact tags as defined in the GEDCOM 5.5.1 Standard.  For example, if you wanted the occupation to show up in the box, you would add \"OCCU\" to this field.<br /><br />This sets \$CHART_BOX_TAGS in <i><u>xxx</u>.GED_conf.php</i>.<br />";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "Configure PhpGedView";
$pgv_lang["standard_conf"]		= "Standard Configuration Options";
$pgv_lang["advanced_conf"]		= "Advanced Configuration Options";
$pgv_lang["gedcom_conf"]		= "GEDCOM Basics";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["accpriv_conf"]		= "Access and Privacy";
$pgv_lang["displ_conf"]			= "Display and Layout";
$pgv_lang["displ_names_conf"]	= "Names";
$pgv_lang["displ_comsurn_conf"] = "Common Surnames";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]	= "Hide and Show";
$pgv_lang["editopt_conf"]		= "Edit Options";
$pgv_lang["useropt_conf"]		= "User Options";
$pgv_lang["contact_conf"]		= "Contact Information";
$pgv_lang["meta_conf"]			= "Web Site and META Tag Settings";
$pgv_lang["configure_head"]		= "PhpGedView Configuration";
$pgv_lang["gedconf_head"]		= "GEDCOM Configuration";
$pgv_lang["default_user"]		= "Create the default administrative user.";
$pgv_lang["about_user"]			= "You must first create your main administrative user.  This user will have privileges to update the configuration files, view private data, and create other users.";
$pgv_lang["can_admin"]			= "User can administer";
$pgv_lang["can_edit"]			= "Access level";
$pgv_lang["access"]				= "Access";
$pgv_lang["sync_gedcom"]		= "Synchronize User Settings with GEDCOM Data";
$pgv_lang["user_relationship_priv"]	= "Limit access to related people";
$pgv_lang["user_path_length"]	= "Max relationship privacy path length";
$pgv_lang["add_user"]			= "Add a new user";
$pgv_lang["current_users"]		= "User List";
$pgv_lang["leave_blank"]		= "Leave password blank if you want to keep the current password.";
$pgv_lang["other_theme"]		= "Other, please type in";
$pgv_lang["performing_update"]		= "Performing update.";
$pgv_lang["config_file_read"]		= "Config file read.";
$pgv_lang["does_not_exist"]		= "does not exist";
$pgv_lang["media_drive_letter"]		= "Media path should not contain a drive letter; media may not be displayed.";
$pgv_lang["pgv_config_write_error"] 		= "Error!!! Cannot write to the PhpGedView configuration file.  Please check file and directory permissions and try again.";
$pgv_lang["db_setup_bad"]		= "Your current database configuration is bad.  Please check your database connection parameters and configure again.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView was unable to make a connection to your database host.  Check the host, username, and password to make sure they are correct.";
$pgv_lang["bad_database_name"]		= "PhpGedView made a connection to your database host, but was unable to use the database with the name you entered.  Check that the database exists and that the username you entered has the appropriate permissions on that database.";
$pgv_lang["click_here_to_continue"]	= "Click here to continue.";
$pgv_lang["config_help"]		= "Configuration help";
$pgv_lang["mysql"]			= "MySQL";
$pgv_lang["db"]				= "Database";
$pgv_lang["dbase"]			= "dBase";
$pgv_lang["fbsql"]			= "FrontBase";
$pgv_lang["ibase"]			= "InterBase";
$pgv_lang["ifx"]			= "Informix";
$pgv_lang["msql"]			= "Mini SQL";
$pgv_lang["mssql"]			= "Microsoft SQL server";
$pgv_lang["mysqli"]			= "MySQL 4.1+ and PHP 5";
$pgv_lang["oci8"]			= "Oracle 7+";
$pgv_lang["pgsql"]			= "PostgreSQL";
$pgv_lang["sqlite"]			= "SQLite";
$pgv_lang["sybase"]			= "Sybase";
$pgv_lang["admin_gedcoms"]		= "Click here to administer GEDCOMS";
$pgv_lang["current_gedcoms"]		= "Current GEDCOMs";
$pgv_lang["gedcom_adm_head"]	= "GEDCOM Administration";
$pgv_lang["ged_download"]		= "Download";
$pgv_lang["ged_gedcom"]			= "GEDCOM file";
$pgv_lang["ged_title"]			= "GEDCOM title";
$pgv_lang["ged_config"]			= "Configuration file";
$pgv_lang["ged_search"]			= "SearchLog files";
$pgv_lang["ged_change"]			= "ChangeLog files";
$pgv_lang["ged_privacy"]		= "Privacy file";
$pgv_lang["show_phpinfo"]		= "Show PHP information page";
$pgv_lang["confirm_gedcom_delete"]	= "Are you sure you want to delete this GEDCOM";
$pgv_lang["gregorian"]			= "Gregorian";
$pgv_lang["julian"]			= "Julian";
$pgv_lang["config_french"]		= "French";
$pgv_lang["jewish"]			= "Jewish";
$pgv_lang["config_hebrew"]		= "Hebrew";
$pgv_lang["jewish_and_gregorian"]	= "Jewish and Gregorian";
$pgv_lang["hebrew_and_gregorian"]	= "Hebrew and Gregorian";
$pgv_lang["hijri"]				= "Hijri";
$pgv_lang["arabic_cal"]				= "Arabic";
$pgv_lang["disabled"]			= "Disabled";
$pgv_lang["mouseover"]			= "On Mouse Over";
$pgv_lang["mousedown"]			= "On Mouse Down";
$pgv_lang["click"]			= "On Mouse Click";
$pgv_lang["mailto"]			= "Mailto link";
$pgv_lang["messaging"]			= "PhpGedView internal messaging";
$pgv_lang["messaging2"]			= "Internal messaging with emails";
$pgv_lang["messaging3"]			= "PhpGedView sends emails with no storage";
$pgv_lang["no_messaging"]		= "No contact method";
$pgv_lang["no_logs"]			= "Disable logging";
$pgv_lang["daily"]			= "Daily";
$pgv_lang["weekly"]			= "Weekly";
$pgv_lang["monthly"]			= "Monthly";
$pgv_lang["yearly"]			= "Yearly";
$pgv_lang["enter_db_pass"]		= "For security, you must enter the #pgv_lang[DBUSER]# and #pgv_lang[DBPASS]# before changing configuration values.";
$pgv_lang["config_still_writable"]	= "Your <i>config.php</i> file is still writable.  For security, you should set the permissions of this file back to read-only when you have finished configuring your site.";
$pgv_lang["admin_verification_waiting"] = "User accounts awaiting verification by admin";
$pgv_lang["admin_user_warnings"]		= "One or more user accounts have warnings";
$pgv_lang["DEFAULT_GEDCOM"]		= "Default GEDCOM";
$pgv_lang["privileges"]			= "Privileges";
$pgv_lang["date_registered"]	= "Date registered";
$pgv_lang["last_login"]			= "Last logged in";
$pgv_lang["server_url_note"]	= "This should be the URL to your PhpGedView folder.  You should only change this setting if you are sure you know what you are doing.  PhpGedView has determined this value to be <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Database Type";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />The type of PEAR supported database to connect to.<br /><br />PhpGedView supports MySQL, PostgreSQL, and SQLite databases.  MySQL and PostgreSQL both require libraries to be installed in PHP.  SQLite comes installed by default in PHP 5.<br /><br />With SQLite you don't need to configure #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, or #pgv_lang[DBPASS]#, but you will need to set a file path for your database in the #pgv_lang[DBNAME]# field.<br /><br />This sets \$DBTYPE in <i>config.php</i>.<br />";
$pgv_lang["DBHOST"]			= "Database Host";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />The DNS or IP address of the computer hosting your database server.  This setting is ignored if you are using an SQLite database.<br /><br />This sets \$DBHOST in <i>config.php</i>.<br />";
$pgv_lang["DBUSER"]			= "Database Username";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />The database username required to login to your database.  This setting is ignored if you are using an SQLite database.<br /><br />This sets \$DBUSER in <i>config.php</i>.<br />";
$pgv_lang["DBPASS"]			= "Database Password";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />The database password for the user you entered in the #pgv_lang[DBUSER]# field.  This setting is ignored if you are using an SQLite database.<br /><br />This sets \$DBPASS in <i>config.php</i>.<br />";
$pgv_lang["DBNAME"]			= "Database Name";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />The database in the server you want PhpGedView to use.<br /><br />The username you enter in the #pgv_lang[DBUSER]# field must have Create, Insert, Update, Delete, and Select privileges on this database.  In SQLite you need to set this to a file name in a directory that is writable by PHP such as your index directory (index/phpgedview.db).<br /><br />This sets \$DBNAME in <i>config.php</i>.<br />";
$pgv_lang["TBLPREFIX"]			= "Database Table Prefix";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />A prefix to prepend to the tables created by PhpGedView.  By changing this value you can set up multiple PhpGedView sites to use the same physical database but different tables.  For example, the same site could host a \"test\" as well as a \"production\" installation of PhpGedView with completely independent data tables.<br /><br />This sets \$TBLPREFIX in <i>config.php</i>.<br />";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]	= "Allow GEDCOM switching";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />If you have an environment with multiple GEDCOMs, setting this value to <b>Yes</b> allows your site visitors <u>and</u> users to have the option of changing GEDCOMs.  Setting it to <b>No</b> disables GEDCOM switching for both visitors <u>and</u> logged in users.<br /><br />This sets \$ALLOW_CHANGE_GEDCOM in <i>config.php</i>.<br />";
$pgv_lang["upload_path"]			= "Upload path";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />This is the path where the GEDCOM file you wish to upload can be found. To select the path, click on <b>Browse</b> and navigate to your GEDCOM file and then click <b>Open</b>.";
$pgv_lang["gedcom_path"]			= "Path and name of GEDCOM on server";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />There are two ways of importing your GEDCOM file into PhpGedView. They are:<ol><li>FTP the file to the server</li><li>Upload within PhpGedView</li></ol>When your file already exists on the server, you engage the <i>#pgv_lang[add_gedcom]#</i> procedure and fill in the path and name of your GEDCOM file as they exist on the server. The name can be with or without extension. If no extension is given, .ged will be assumed. The path is optional. If no path is given, the value of the <i>#pgv_lang[INDEX_DIRECTORY]#</i> option, as set in your PhpGedView site configuration, will be used.  Please note that on most servers, file and path names are case sensitive.<br /><br />When you engage the <i>#pgv_lang[upload_gedcom]#</i> procedure built into PhpGedView, you can use the <b>Browse</b> button to locate the desired file on your local computer. This can be a regular GEDCOM file or a ZIP file containing the GEDCOM file. PhpGedView will automatically extract and then use the GEDCOM file contained in that ZIP file.<br /><br />When uploading a file it is possible to specify an alternative path and/or filename to save it under on the server.<br /><br />See the <a href=\"readme.txt\">Readme.txt</a> file for more information.<br />";
$pgv_lang["CHARACTER_SET"]		= "Character Set encoding";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />This is the character set of your GEDCOM file.  UTF-8 is the default and should work for almost all sites.  If you export your GEDCOM using IBM Windows encoding, you should put WINDOWS here.<br /><br />NOTE: PhpGedView can't support UNICODE (UTF-16) because the support is missing in PHP.<br />";
$pgv_lang["LANGUAGE"]			= "Language";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Assign the default language for the site.<br /><br />When the <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> option is set, users can override this setting through their browser's preferred language configuration, configuration options on their Account page, or through links or buttons on most PhpGedView pages.<br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Allow user to change language";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Set to <b>Yes</b> to allow users to override the site's default language.  They can do this through their browser's preferred language configuration, configuration options on their Account page, or through links or buttons on most PhpGedView pages.<br />";
$pgv_lang["LANGUAGE_DEFAULT"]		= "You have not configured the languages your site will support.<br />PhpGedView will use its default actions.";
$pgv_lang["CALENDAR_FORMAT"]		= "Calendar format";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />This option allows you to specify the type of calendar you would like to use with this GEDCOM file.<br /><br />Hebrew is the same as the Jewish calendar but using Hebrew characters.<br /><br />Note: The values used for Jewish and Hebrew dates are calculated from the Gregorian or Julian dates.  Since the Jewish calendar day starts at dusk, any event taking place from dusk till midnight will display as one day prior to the correct Jewish date.  The display of Hebrew can be problematic in old browsers, which may display Hebrew backwards (left to right) or not at all.<br />";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Display Hebrew Thousands";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Show Alafim in Hebrew calendars.<br /><br />Setting this to <b>Yes</b> will display the year 1969 as <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; while setting it to <b>No</b> will display the year as <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  This has no impact on the Jewish year setting.  The year will display as 5729 regardless of this setting.<br /><br />This sets \$DISPLAY_JEWISH_THOUSANDS in <i><u>xxx</u>.GED_conf.php</i>.<br /><br />Note: This setting is similar to the PHP 5.0 Calendar constant CAL_JEWISH_ADD_ALAFIM.<br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Display Hebrew Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Show single and double quotes when displaying Hebrew dates.<br /><br />Setting this to <b>Yes</b> will display February 8 1969 as <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; while setting it to <b>No</b> will display it as <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  This has no impact on the Jewish year setting since quotes are not used in Jewish dates displayed with Latin characters.<br /><br />This sets \$DISPLAY_JEWISH_GERESHAYIM in <i><u>xxx</u>.GED_conf.php</i>.<br /><br />Note: This setting is similar to the PHP 5.0 Calendar constants CAL_JEWISH_ADD_ALAFIM_GERESH and CAL_JEWISH_ADD_GERESHAYIM.  This single setting affects both.<br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jewish Ashkenaz pronunciation";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Use Jewish Ashkenazi pronunciations.<br /><br />When set to <b>Yes</b> the months Cheshvan and Teves will be spelled with Ashkenazi pronunciation.  Setting it to <b>No</b> will change the months to Hesvan and Tevet.  This only affects the Jewish setting.  The Hebrew setting will always use the Hebrew alphabet.<br /><br />This sets \$JEWISH_ASHKENAZ_PRONUNCIATION in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_RTL_FUNCTIONS"]	= "Use RTL processing";
$pgv_lang["USE_RTL_FUNCTIONS_help"]	= "~#pgv_lang[USE_RTL_FUNCTIONS]#~<br /><br />Use processing to properly display GEDCOM data in RTL languages.  If set to <b>Yes</b> the database will be processed at runtime to ensure proper display of RTL data; this setting can slow down performance.<br /><br />This sets \$USE_RTL_FUNCTIONS in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Pedigree generations";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Set the default number of generations to display on Pedigree charts.<br />";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximum Pedigree generations";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Set the maximum number of generations to display on Pedigree charts.<br />";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximum Descendancy generations";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Set the maximum number of generations to display on Descendancy charts.<br />";
$pgv_lang["USE_RIN"]			= "Use RIN number instead of GEDCOM ID";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Set to <b>Yes</b> to use the RIN number instead of the GEDCOM ID when asked for Individual IDs in configuration files, user settings, and charts.  This is useful for genealogy programs that do not consistently export GEDCOMs with the same ID assigned to each individual but always use the same RIN.<br />";
$pgv_lang["GENERATE_GUID"]		= "Automatically create globally unique IDs";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> in this context is an acronym for «Globally Unique ID».<br /><br />GUIDs are intended to help identify each individual in a manner that is repeatable, so that central organizations such as the Family History Center of the LDS Church in Salt Lake City, or even compatible programs running on your own server, can determine whether they are dealing with the same person no matter where the GEDCOM originates.  The goal of the Family History Center is to have a central repository of genealogical data and expose it through web services. This will enable any program to access the data and update their data within it.<br /><br />If you do not intend to share this GEDCOM with anyone else, you do not need to let PhpGedView create these GUIDs; however, doing so will do no harm other than increasing the size of your GEDCOM.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Default person for Pedigree and Descendancy charts";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Set the ID of the default person to display on Pedigree and Descendancy charts.<br />";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Individual ID prefix";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />When a new individual record is added online in PhpGedView, a new ID for that individual will be generated automatically. The individual ID will have this prefix.<br />";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Source ID prefix";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />When a new source record is added online in PhpGedView, a new ID for that source will be generated automatically.  The source ID will have this prefix.<br />";
$pgv_lang["REPO_ID_PREFIX"]		= "Repository ID prefix";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />When a new repository record is added online in PhpGedView, a new ID for that repository will be generated automatically. The repository ID will have this prefix.<br />";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Show Birth and Death details on Pedigree and Descendancy charts";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />This option controls whether or not to show the Birth and Death details of an individual by default.<br />";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Default Pedigree chart layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />This option indicates whether the Pedigree chart should be generated in landscape or portrait mode.<br />";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Show empty boxes on Pedigree charts";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />This option controls whether or not to show empty boxes on Pedigree charts.<br />";
$pgv_lang["ZOOM_BOXES"]			= "Zoom boxes on charts";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Allows a user to zoom boxes on charts to get more information.<br /><br />Set to <b>#pgv_lang[disabled]#</b> to disable this feature.  Set to <b>#pgv_lang[mouseover]#</b> to zoom boxes when the user mouses over the icon in the box.  Set to <b>#pgv_lang[click]#</b> to zoom boxes when the user clicks on the icon in the box.<br />";
$pgv_lang["LINK_ICONS"]			= "PopUp links on charts";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Allows the user to select links to other charts and close relatives of the person.<br /><br />Set to <b>#pgv_lang[disabled]#</b> to disable this feature.  Set to <b>#pgv_lang[mouseover]#</b> to popup the links when the user mouses over the icon in the box.  Set to <b>#pgv_lang[click]#</b> to popup the links when the user clicks on the icon in the box.<br />";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Abbreviate chart labels";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />This option controls whether or not to abbreviate labels like \"Birth\" on charts with just the first letter like \"B\".<br />";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Show age of parents next to child's birthdate";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />This option controls whether or not to show age of father and mother next to child's birthdate on charts.<br />";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Show events of close relatives on Individual page";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Births, marriages, and deaths of relatives are important events in one's life. This option controls whether or not to show these events on the <i>Personal facts and details</i> tab on the Individual page.<br /><br />The events affected by this option are:<ul><li>Death of spouse</li><li>Birth and death of children</li><li>Death of parents</li><li>Birth and death of siblings</li><li>Death of grand-parents</li><li>Birth and death of parents' siblings</li></ul><br />";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Automatically expand list of events";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />This option controls whether or not to automatically expand the <i>Events of close relatives</i> list.<br />";
$pgv_lang["EXPAND_SOURCES"]      = "Automatically expand sources";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />This option controls whether or not to automatically display content of a <i>Source</i> record on the Individual page.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Enable Privacy";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />This option will enable all privacy settings and hide the details of living people.<br /><br />Living people are defined to be those who do not have an event more recent than the number of years specified in variable \$MAX_ALIVE_AGE.  For this purpose, births of children are considered to be such events as well.<br />";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Require visitor authentication";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Enabling this option will force all visitors to login before they can view any data on the site.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Welcome text on Login page in Authentication mode";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Here you can choose text to appear on the login screen when authentication mode is set to <b>Yes</b>. You must determine which predefined text is most appropriate.  You can also choose to enter your own custom Welcome text, but the text you enter will not be translated when your users change language.<br /><br />The predefined texts are:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Predefined text that states all users can request a user account";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Predefined text that states admin will decide on each request for a user account";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Predefined text that states only family members can request a user account";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Choose user defined welcome text typed below";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Custom Welcome text for Authentication mode";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />If you have opted for custom Welcome text, you can type that text here.  The text will NOT be translated into the language of the visitor, but will be shown exactly as you typed it.<br /><br />If you wish, you can use HTML tags in the text.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standard header for custom Welcome text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Choose to display a standard header for your custom Welcome text.  When your users change language, this header will appear in the new language.<br /><br />If set to <b>Yes</b>, the header will look look this:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Check child dates";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Check children's dates when determining whether a person is dead.  On older systems and large GEDCOMs this can slow down the response time of your site.<br />";
$pgv_lang["MAX_ALIVE_AGE"]		= "Age at which to assume a person is dead";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />If this person has any events other than Death, Burial, or Cremation more recent than this number of years, he is considered to be \"alive\".  Children's birth dates are considered to be such events for this purpose.<br />";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Allow users to see raw GEDCOM records";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Setting this to <b>Yes</b> will place links on individuals, sources, and families to let users bring up another window containing the raw data taken right out of the GEDCOM file.<br />";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Enable online editing";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />This option enables online editing features for this database so that users with Edit privileges may update data online.<br />";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Autoclose edit window";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />This option controls wether or not to automatically close the Edit window after a successful update.<br />";
$pgv_lang["INDEX_DIRECTORY"]		= "Index file directory";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />The path to a readable and writable directory where PhpGedView should store index files (include the trailing \"/\").  PhpGedView does not require this directory's name to be \"index\".  You can choose any name you like.<br /><br />For security, this directory should be placed somewhere in the server's file space that is not accessible from the Internet. An example of such a structure follows:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />For the example shown, you would enter <b>../../dir4/dir5/dir6/index/</b> in this field.<br /><br />This sets \$INDEX_DIRECTORY in <i>config.php</i>.<br />";
$pgv_lang["POSTAL_CODE"]  = "Postal Code position";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Different countries use different ways to write the address. This option will enable you to place the postal code either before or after the city name.<br />";
$pgv_lang["ALPHA_INDEX_LISTS"]		= "Break up long lists by the first letter";
$pgv_lang["ALPHA_INDEX_LISTS_help"]	= "~#pgv_lang[ALPHA_INDEX_LISTS]#~<br /><br />For very long Individual and Family lists, set this to <b>Yes</b> to split the list into pages by the first letter of their last name.<br />";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Get display name from GEDCOM";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "~#pgv_lang[NAME_FROM_GEDCOM]#~<br /><br />By default PhpGedView uses the name stored in the indexes to get a person's name.  With some GEDCOM formats and languages, the sortable name stored in the indexes does not get displayed properly and the best way to get the correct display name is from the GEDCOM.<br /><br />Spanish names are a good example of this.  A Spanish name can take the form (Given Names) (Father's Surname) (Mother's Surname).  Using the Indexes for sorting and display, the name would display like this: (Given Names) (Mother's Surname) (Father's Surname), which is incorrect.  Going back to the GEDCOM for the name will return the correct name.  However, retrieving the name from the GEDCOM will slow the program down.<br />";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Show ID numbers next to names";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />This option controls whether or not to show ID numbers in parentheses after person names on charts.<br />";
$pgv_lang["SHOW_FAM_ID_NUMBERS"]		= "Show ID numbers next to families";
$pgv_lang["SHOW_FAM_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_FAM_ID_NUMBERS]#~<br /><br />This option controls whether or not to show family ID numbers in parentheses after family names on charts and on the Individual page.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Place levels to show in person boxes";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />This sets how much of the place information is shown in the person boxes on charts.<br /><br />Setting the value to 9 will guarantee to show all place levels.  Setting the value to 0 will hide places completely.  Setting the value to 1 will show the first level, setting it to 2 will show the first two levels, etc.<br />";
$pgv_lang["MULTI_MEDIA"]		= "Enable multimedia features";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 allows you to link pictures, videos, and other multimedia objects into your GEDCOM.  If you do not include multimedia objects in your GEDCOM, you can disable the multimedia features by setting this value to <b>No</b>.<br /><br />See the Multimedia section in the <a href=\"readme.txt\">readme.txt</a> file for more information about including media in your site.<br />";
$pgv_lang["MEDIA_EXTERNAL"]			= "Keep links";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />When a multimedia link is found starting with for example http://, ftp://, mms:// it will not be altered when set to <b>Yes</b>. For example, http://www.myfamily.com/photo/dad.jpg will stay http://www.myfamily.com/photo/dad.jpg.  When set to <b>No</b>, the link will be handled as a standard reference and the media depth will be used.  For example: http://www.myfamily.com/photo/dad.jpg will be changed to ./media/dad.jpg<br />";
$pgv_lang["MEDIA_DIRECTORY"]		= "MultiMedia directory";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />The path to a readable and writable directory where PhpGedView should store media files (include the trailing \"/\").  PhpGedView does not require this directory's name to be \"media\".  You can choose any name you like.<br /><br />Unfortunately, this directory must be accessible to your Browser.  For that reason, it is best to use the default name \"media/\" in the default location, within the PhpGedView install directory.<br />";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Multi-Media directory levels to keep";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />A value of 0 will ignore all directories in the file path for the media object.  A value of 1 will retain the first directory containing this image.  Increasing the numbers increases number of parent directories to retain in the path.<br /><br />For example, if you link an image in your GEDCOM with a path like <b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, a value of 0 will translate this path to <b>./media/grandpa.jpg</b>.  A value of 1 will translate this to <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, etc.  Most people will only need to use a 0.  However, it is possible that some media objects kept in different directories have identical names and would overwrite each other when this option is set to 0.  Non-zero settings allow you to keep some organization in your media thereby preventing name collisions.<br />";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Show highlight images in people boxes";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />If you have enabled multimedia in your site, you can have PhpGedView display a thumbnail image next to the person's name in charts and boxes.<br /><br />Currently, PhpGedView uses the first multimedia object listed in the GEDCOM record as the highlight image.  For people with multiple images, you should arrange the multimedia objects such that the one you wish to be highlighted appears first, before any others.<br /><br />See the Multimedia section in the <a href=\"readme.txt\">readme.txt</a> file for more information about including media in your site.<br />";
$pgv_lang["USE_THUMBS_MAIN"]	= "Use thumbnail for main picture on Individual page";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Depending on how you want to store your images, it may be better for you to use thumbnails for the picture next to the name on the Individual page.<br /><br />If your main images are very large, they can take a long time to download and if your thumbnails are high enough quality they could be used in place of the full resolution image.  Set this item to <b>Yes</b> to use thumbnails or leave it as <b>No</b> to use the full resolution image.<br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Enable Clippings Cart";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />The clippings cart allows users to add people to a temporary file that they can download in GEDCOM format for subsequent import into their genealogy software.<br />";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Hide GEDCOM errors";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Setting this to <b>Yes</b> will hide error messages produced by PhpGedView when it doesn't understand a tag in your GEDCOM file.  PhpGedView makes every effort to conform to the GEDCOM 5.5.1 standard, but many genealogy software programs include their own custom tags.  See the <a href=\"readme.txt\">readme.txt</a> file for more information.<br />";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Add spaces where notes were wrapped";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Some genealogy programs wrap notes at word boundaries while others wrap notes anywhere.  This can cause PhpGedView to run words together.  Setting this to <b>Yes</b> will add a space between words where they are wrapped in the original GEDCOM.<br />";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Show contextual <b>?</b> Help links";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />This option will enable links, identified by question marks, next to items on many pages.  These links allow users to get information or help about those items.<br />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Upcoming Events block day limit";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Enter the maximum number of days to show in Upcoming Events blocks.  This number cannot be greater than 30. If you enter a larger value, 30 will be used.<br /><br />The value you enter here determines how far ahead PhpGedView looks when searching for upcoming events.  The results of this search, done once daily, are copied into a temporary file.<br /><br />No Upcoming Events blocks on Index or Portal pages can request more days than this value.  The larger you make this, the longer it will take to build the daily database extract, and the longer it will take to display the block, even when you request to display a number of days less than this setting.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Min. no. of occurrences to be a \"Common Surname\"";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />This is the number of times that a surname must occur before it shows up in the Common Surname list on the Welcome page.<br />";
$pgv_lang["COMMON_NAMES_ADD"]	= "Names to add to Common Surnames (comma separated)";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />If the number of times that a certain surname occurs is lower than the threshold, it will not appear in the list.  It can be added here manually.  If more than one surname is entered, they must be separated by a comma.  <b>Surnames are case-sensitive.</b><br />";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Names to remove from Common Surnames (comma separated)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />If you want to remove a surname from the Common Surname list without increasing the threshold value, you can do that by entering the surname here.  If more than one surname is entered, they must be separated by a comma. <b>Surnames are case-sensitive.</b>  Surnames entered here will also be removed from the Top-10 list on the Welcome page.<br />";
$pgv_lang["HOME_SITE_URL"]		= "Main WebSite URL";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Each PhpGedView page includes a link to your main Home page.  The appearance of this link is controlled by the theme being used.  You enter the actual URL to your Home site here.<br />";
$pgv_lang["HOME_SITE_TEXT"]		= "Main WebSite text";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />The legend used to identify the link to your main Home page.<br />";
$pgv_lang["CONTACT_EMAIL"]		= "Genealogy contact";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />The person to contact about the genealogical data on this site.<br />";
$pgv_lang["CONTACT_METHOD"]		= "Contact method";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />The method to be used to contact the #pgv_lang[CONTACT_EMAIL]# about genealogy questions.<ul><li>The <b>#pgv_lang[mailto]#</b> option will create a \"mailto\" link that can be clicked to send an email using the mail client on the user's PC.</li><li>The <b>#pgv_lang[messaging]#</b> option will use a messaging system internal to PhpGedView, and no emails will be sent.</li><li>The <b>#pgv_lang[messaging2]#</b> option is the default.  It will use the PhpGedView messaging system and will also send copies of the messages via email.</li><li>The <b>#pgv_lang[messaging3]#</b> option allows PhpGedView to handle the messaging and will send the messages as emails, but will not store the messages internally.  This option is similar to the <b>#pgv_lang[mailto]#</b> option, except that the message will be sent by PhpGedView instead of the user's workstation.</li><li>The <b>#pgv_lang[no_messaging]#</b> option results in your users having no way of contacting you.</li></ul>";
$pgv_lang["WEBMASTER_EMAIL"]		= "Support contact";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />The person to be contacted about technical questions or errors encountered on your site.<br />";
$pgv_lang["SUPPORT_METHOD"]		= "Support method";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />The method to be used to contact the #pgv_lang[WEBMASTER_EMAIL]# about technical questions.<ul><li>The <b>#pgv_lang[mailto]#</b> option will create a \"mailto\" link that can be clicked to send an email using the mail client on the user's PC.</li><li>The <b>#pgv_lang[messaging]#</b> option will use a messaging system internal to PhpGedView, and no emails will be sent.</li><li>The <b>#pgv_lang[messaging2]#</b> option is the default.  It will use the PhpGedView messaging system and will also send copies of the messages via email.</li><li>The <b>#pgv_lang[messaging3]#</b> option allows PhpGedView to handle the messaging and will send the messages as emails, but will not store the messages internally.  This option is similar to the <b>#pgv_lang[mailto]#</b> option, except that the message will be sent by PhpGedView instead of the user's workstation.</li><li>The <b>#pgv_lang[no_messaging]#</b> option results in your users having no way of contacting you.</li></ul>";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Show Fact icons";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Set this to <b>#pgv_lang[yes]#</b> to display icons near Fact names on the #pgv_lang[personal_facts]# page.  Fact icons will be displayed only if they exist in the <i>images/facts</i> directory of the current theme.<br />";
$pgv_lang["FAVICON"]			= "Favorites icon";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Change this to point to the icon you want to display in peoples' favorites menu when they bookmark your site.<br />";
$pgv_lang["THEME_DIR"]			= "Theme directory";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />The directory where your PhpGedView theme files are kept.<br /><br />You may customize any of the standard themes that come with PhpGedView to give your site a unique look and feel.  See the Theme Customization section of the <a href=\"readme.txt\">readme.txt</a> file for more information.<br />";
$pgv_lang["TIME_LIMIT"]			= "PHP time limit";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />The maximum time in seconds that PhpGedView should be allowed to run.<br /><br />The default is 1 minute.  Depending on the size of your GEDCOM file, you may need to increase this time limit when you need to build the indexes.  Set this value to 0 to allow PHP to run forever.<br /><br />CAUTION: Setting this to 0 or setting it too high could cause your site to hang on certain operating systems until the script finishes.  Setting it to 0 means it may never finish until a server administrator kills the process or restarts the server.  A large Pedigree chart can take a very long time to run; leaving this value as low as possible ensures that someone cannot crash your server by requesting an excessively large chart.<br />";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Session save path";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />The path to store PhpGedView session files.<br /><br />Some hosts do not have PHP configured properly and sessions are not maintained between page requests.  This option lets site administrators overcome that problem by saving files in one of their local directories.  The ./index/ directory is a good choice if you need to change this.  The default is to leave the field empty, which will use the Save path as configured in <i>php.ini</i>.<br /><br />This sets \$PGV_SESSION_SAVE_PATH in <i>config.php</i>.<br />";
$pgv_lang["SERVER_URL"]			= "PhpGedView URL";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />If you use https or a port other than the default, you will need to enter the URL to access your server here.<br /><br />This sets \$SERVER_URL in <i>config.php</i>.<br />";
$pgv_lang["LOGIN_URL"]			= "Login URL";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />You only need to enter a Login URL if you want to redirect to a different site or location when your users login.  This is very useful if you need to switch from http to https when your users login.  Include the full URL to <i>login.php</i>.  For example, https://www.yourserver.com/phpgedview/login.php<br /><br />This sets \$LOGIN_URL in <i>config.php</i>.<br />";
$pgv_lang["PGV_SESSION_TIME"]		= "Session timeout";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />The time in seconds that a PhpGedView session remains active before requiring a login.  The default is 7200, which is 2 hours.<br /><br />This sets \$PGV_SESSION_TIME in <i>config.php</i>.<br />";
$pgv_lang["SHOW_STATS"]			= "Show execution statistics";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Show runtime statistics and database queries at the bottom of every page.<br />";
$pgv_lang["SHOW_COUNTER"]		= "Show hit counters";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Show hit counters on Portal and Individual pages.<br />";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Allow visitors to request account registration";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Gives visitors the option of registering themselves for an account on the site.<br /><br />The visitor will receive an email message with a code to verify his application for an account.  After verification, the Administrator will have to approve the registration before it becomes active.<br /><br />This sets \$USE_REGISTRATION_MODULE in <i>config.php</i>.<br />";
$pgv_lang["ALLOW_USER_THEMES"]		= "Allow users to select their own theme";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Gives users the option of selecting their own theme.<br /><br />This sets \$ALLOW_USER_THEMES in <i>config.php</i>.<br />";
$pgv_lang["PGV_SIMPLE_MAIL"] = "Use simple mail headers in external mails";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />In normal mail headers for external mails, the email address as well as the name are used. Some mail systems will not accept this. When set to <b>Yes</b>, only the email address will be used.<br /><br />This sets \$PGV_SIMPLE_MAIL in <i>config.php</i>.<br />";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Enter a descriptive title to be displayed when users are choosing among GEDCOM datasets at your site.<br />";
$pgv_lang["LOGFILE_CREATE"]		= "Archive log files";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />How often should the program archive log files.<br /><br />This sets \$LOGFILE_CREATE in <i>config.php</i>.<br />";
$pgv_lang["PGV_MEMORY_LIMIT"]		= "Memory limit";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />The maximum amount of memory that can be consumed by PhpGedView scripts.  The default is 32 Mb.  Many hosts disable this option in their PHP configuration; changing this value may not actually affect the current maximum memory setting. <br /><br />This sets \$PGV_MEMORY_LIMIT in <i>config.php</i>.<br />";
$pgv_lang["PGV_STORE_MESSAGES"]		= "Allow messages to be stored online";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Specifies whether messages sent through PhpGedView can be stored in the database.  If set to <b>Yes</b> users will be able to retrieve their messages when they login to PhpGedView.  If set to <b>No</b> messages will only be emailed.<br /><br />This sets \$PGV_STORE_MESSAGES in <i>config.php</i>.<br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Display theme dropdown selector for theme changes";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Gives users the option of selecting their own theme from a menu.<br /><br />Even with this option set, the theme currently in effect may not provide for such a menu.  To be effective, this option requires the <b>#pgv_lang[ALLOW_USER_THEMES]#</b> option to be set as well.<br /><br />This sets \$ALLOW_THEME_DROPDOWN in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["MAX_VIEW_RATE"]		= "Maximum page view rate";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />This option limits the rate at which a user can view pages.<br /><br />If that rate is exceeded, PhpGedView treats the session as a hacking attempt;  the session will be terminated with a suitable message.  These two values should place a reasonable limit on the amount of bandwith and downloaded bytes from the server.  This feature can be switched off by setting the time interval to 0.<br /><br />This sets \$MAX_VIEWS and \$MAX_VIEW_TIME in <i>config.php</i>.<br />";
$pgv_lang["page_views"]			= "&nbsp;&nbsp;page views in&nbsp;&nbsp;";
$pgv_lang["seconds"]			= "&nbsp;&nbsp;seconds";
$pgv_lang["META_AUTHOR"]		= "Author META tag";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />The value to place in the Author meta tag in the HTML page header.  Leave this field empty to use the full name of the #pgv_lang[CONTACT_EMAIL]#.<br /><br />This sets \$META_AUTHOR in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_AUTHOR_descr"]	= "Leave this field empty to use the full name of the #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "Publisher META tag";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />The value to place in the Publisher meta tag in the HTML page header.  Leave this field empty to use the full name of the #pgv_lang[CONTACT_EMAIL]#.<br /><br />This sets \$META_PUBLISHER in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PUBLISHER_descr"]	= "Leave this field empty to use the full name of the  #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "Copyright META tag";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />The value to place in the Copyright meta tag in the HTML page header.  Leave this field empty to use the full name of the #pgv_lang[CONTACT_EMAIL]#.<br /><br />This sets \$META_COPYRIGHT in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_COPYRIGHT_descr"]	= "Leave this field empty to use the full name of the  #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "Description META tag";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />The value to place in the Description meta tag in the HTML page header.  Leave this field empty to use the title of the currently active database.<br /><br />This sets \$META_DESCRIPTION in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_DESCRIPTION_descr"]	= "Leave this field empty to use the title of the currently active database.";
$pgv_lang["META_PAGE_TOPIC"]		= "Page-topic META tag";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />The value to place in the Page-topic meta tag in the HTML page header.  Leave this field empty to use the title of the currently active database.<br /><br />This sets \$META_PAGE_TOPIC in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Leave this field empty to use the title of the currently active database.";
$pgv_lang["META_AUDIENCE"]		= "Audience META tag";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />The value to place in the Audience meta tag in the HTML page header.<br /><br />This sets \$META_AUDIENCE in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TYPE"]		= "Page-type META tag";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />The value to place in the Page-type meta tag in the HTML page header.<br /><br />This sets \$META_PAGE_TYPE in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_ROBOTS"]		= "Robots META tag";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />The value to place in the Robots meta tag in the HTML page header.  Some robots or web crawlers ignore this value.<br /><br />This sets \$META_ROBOTS in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_REVISIT"]		= "How often should crawlers revisit META tag";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />The value to place in the Revisit meta tag in the HTML page header.  Some web crawlers ignore this value.<br /><br />This sets \$META_REVISIT in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_KEYWORDS"]		= "Keywords META tag";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />The value to place in the Keywords meta tag in the HTML page header.  Some search engines will use the Keywords meta tag to help index your page.<br /><br />The #pgv_lang[common_surnames]# list that appears in the #pgv_lang[gedcom_stats]# block on your Welcome page can also be added to anything you enter here.<br /><br />This sets \$META_KEYWORDS in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Add Most Common Surnames to Keywords META field";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "~#pgv_lang[META_SURNAME_KEYWORDS]#~<br /><br />With this option set to <b>Yes</b> the surnames from the #pgv_lang[common_surnames]# list will be added to the Keywords meta field.  This can help search engines better find your site.<br /><br />This sets \$META_SURNAME_KEYWORDS in <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_TITLE"]		= "Add to TITLE header tag";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Anything on this line will be added to the TITLE tag in the HTML page header after the regular page title and before the PhpGedView credit.<br /><br />This sets \$META_TITLE in <i><u>xxx</u>.GED_conf.php</i>.<br />";

$pgv_lang["ENABLE_RSS"]				= "Enable RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />This option lets you disable the RSS feature.<br /><br />RSS lets users monitor your site for changes to the Index page without actually visiting your site periodically.  If too many users make use of this feature or if the refresh frequency set by these users is too high, RSS can use up too much bandwidth or server capacity.<br />";
$pgv_lang["RSS_FORMAT"]				= "RSS Format";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />The format of RSS to be used as the default RSS feed format for the site. The numeric suffixes <u>do not</u> indicate version, they identify formats.  For example, RSS 2.0 is not newer than RSS 1.0, but a different format. Feed readers should be able to read any format. There is currently no difference between ATOM and ATOM 0.3. Both use the ATOM 0.3 draft specification.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Check for downloadable GEDCOM file";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />For security reasons, the GEDCOM file should not be in a location where it can be directly downloaded, thus bypassing privacy checks. This check can cause performance problems on some servers.<br /><br />If you know that the GEDCOM file is in a server directory that is not directly accessible from the Internet, you can safely disable this check.<br />";

$pgv_lang["welcome_new"]			= "Welcome to your new PhpGedView website.";
$pgv_lang["welcome_new2"]			= "<br /><br />Since you are seeing this page, you have successfully installed PhpGedView on your server and are ready to begin configuring it to your requirements.<br /><br />";
$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#This Help page will guide you through the configuration process.  As you enter different fields, this window will provide you with help information about the field you are in.  You may close this window; to open it again click on one of the \"?\" question marks next to the field label.<br />";
$pgv_lang["review_readme"]		= "You should review the <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> file before continuing to configure PhpGedView.<br /><br />";
$pgv_lang["return_editconfig"]		= "You may return to this configuration at any time by pointing your browser to <i>editconfig.php</i> or by clicking the link for <b>Configuration</b> on the <b>PhpGedView Administration</b> page.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "You may return to this configuration at any time by clicking the link <b>Edit</b> in the <b>#pgv_lang[current_gedcoms]#</b> table on the <b>#pgv_lang[gedcom_adm_head]#</b> page or by pointing your browser to <i>editconfig_gedcom.php</i>.<br />";
$pgv_lang["save_config"] 		= "Save configuration";
$pgv_lang["download_here"]		= "Click here to download file.";
$pgv_lang["download_gedconf"]		= "Download GEDCOM configuration.";
$pgv_lang["not_writable"]		= "We have detected that your configuration file is not writable by PHP.  You can use the <b>#pgv_lang[download_file]#</b> button to save your settings to a file that you can upload manually.";
$pgv_lang["download_file"]		= "Download File";
$pgv_lang["upload_to_index"]		= "Upload the file to your index directory: ";
$pgv_lang["import_sql"]			= "SQL files have been found in your index directory. Since they may have originated from the User Migration tool, you have the option to import the information into your database. Do you wish to attempt importing these files into your database now? All existing user-related information (users, news, favorites, block layouts, and messages) in your database will be lost.<br /><br />If you choose to proceed, PhpGedView will attempt to import the data. If this is not successful, you will be asked to make the first administrator account anyway.<br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Edit Privacy";
$pgv_lang["edit_privacy_title"]			= "Edit GEDCOM privacy settings";
$pgv_lang["PRIV_PUBLIC"]			= "Show to public";
$pgv_lang["PRIV_USER"]				= "Show only to authenticated users";
$pgv_lang["PRIV_NONE"]				= "Show only to admin users";
$pgv_lang["PRIV_HIDE"]				= "Hide even from admin users";
$pgv_lang["save_changed_settings"]		= "Save changes";
$pgv_lang["add_new_pp_setting"]			= "Add new setting for Privacy by ID";
$pgv_lang["add_new_up_setting"]			= "Add new setting for User Privacy";
$pgv_lang["add_new_gf_setting"]			= "Add new setting for Global Fact Privacy";
$pgv_lang["add_new_pf_setting"]			= "Add new setting for Facts Privacy by ID";
$pgv_lang["file_read_error"]			= "E R R O R !!! Could not read privacy file!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Edit existing settings for Privacy by ID";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Edit existing settings for User Privacy";
$pgv_lang["edit_exist_global_facts_settings"]	= "Edit existing settings for Global Fact Privacy";
$pgv_lang["edit_exist_person_facts_settings"]	= "Edit existing settings for Facts Privacy by ID";
$pgv_lang["general_privacy"]			= "General Privacy settings";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />You can have different Privacy settings for each GEDCOM on your PhpGedView web site.  Check under the page title whether you are editing the correct GEDCOM.<br /><br />You can override these general settings by using the other Privacy forms on the #pgv_lang[edit_privacy_title]# page.<br />#pgv_lang[more_config_hjaelp]#";
$pgv_lang["person_privacy"]				= "Privacy settings by ID";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />These settings allow administrators to override default privacy settings for a particular person, family, source, or media object.<br /><br />Suppose for example you have a child who died in infancy. Normally because the child is dead, its details would be shown to public users. However, you and everyone else in your family are still private. You don't want to remove the death record for the child but you want to hide the details and make them private. If this child had the ID of I100 you should enter the following privacy settings:<br />ID: I100<br />Show to: Show only to authenticated users<br /><br />This works the other way as well. If you wanted to make public the details of someone (ID 101) who you know to be dead but don't have a death date for, you could add the following:<br />ID: I101<br />Show to: Show to public<br /><br />This sets \$person_privacy in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["user_privacy"]				= "User Privacy settings";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />These settings give administrators the ability to override default privacy settings for individuals in the GEDCOM based on Username.  Suppose you don't want the Username <b>John</b> to be able to see any details of ID 100 in the GEDCOM, you could configure it like this:<br />Username: John<br />ID: I100<br />Show?: \"Hide\"<br /><br />and details for the specified individual would be hidden for the Username \"John\" only.<br /><br />To show the details of I101 (which usually would be hidden because I101 is still alive) to Username \"John\" set:<br /><br />Username: John<br />ID: I101<br />Show?: \"Show\"<br /><br />This sets \$user_privacy in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["global_facts"]				= "Global Fact Privacy settings";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />These settings define facts on a global level that should be hidden for all individuals in the GEDCOM.  This only applies to level 1 fact records such as BIRT or DEAT that will appear with their own headings on the personal facts and details tab of the individual page.<br /><ul><li>The <b>#pgv_lang[name_of_fact]#</b> element determines which fact should be hidden.</li><li>The <b>#pgv_lang[choice]#</b> element specifies the fact itself or related details.</li><li>The <b>#pgv_lang[accessible_by]#</b> element determines at what access level the fact is shown.</li></ul><br />This feature is meant to hide certain facts, identified by GEDCOM tags, for all individuals alive or dead. By default the SSN tag is hidden to public users. This is to prevent people from stealing social security numbers and committing identity theft of dead persons.  This is probably mostly relevant for the USA.<br /><br />If you wanted to hide all marriages from public users in your GEDCOM you could set:<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Marriage<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_show]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Marriage<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_details]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br />These settings would hide marriages and related details to everyone who wasn't an admin.<br /><br />Unlike all other settings, in <b>#pgv_lang[edit_exist_global_facts_settings]#</b> you can hide facts even from admin users. Unwanted facts are completely suppressed.<br /><br />This sets \$global_facts in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["person_facts"]				= "Facts Privacy settings by ID";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />These settings define facts that are hidden for a specific person, family, or source and the level at which they are hidden.  This only applies to level 1 fact records such as BIRT or DEAT that will appear with their own headings on the relevant details page  of the person, family, or source.<br /><br />The first element is the ID of the person, family, or source. The second element is the fact.  The <b>#pgv_lang[choice]#</b> element specifies the fact itself or related details.  The <b>#pgv_lang[accessible_by]#</b> element determines at what access level the fact is shown.  Not all facts shown in the list are applicable to all types of IDs.  For example, Birth and Death facts are not relevant to Source records.<br /><br />The \$person_facts array works the same as the \$global_facts array except that you also specify the GEDCOM ID of the person you want to hide facts for. You could, for example, hide the marriage record for a specific person.<br /><br />This sets \$person_facts in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["accessible_by"]			= "Show to?";
$pgv_lang["hide"]				= "Hide";
$pgv_lang["show_question"]			= "Show?";
$pgv_lang["user_name"]				= "Username";
$pgv_lang["name_of_fact"]			= "Name of fact";
$pgv_lang["choice"]				= "Choice";
$pgv_lang["fact_show"]				= "Show fact";
$pgv_lang["fact_details"]			= "Show fact details";
$pgv_lang["privacy_header"]			= "Edit privacy settings";
$pgv_lang["unable_to_find_privacy_indi"]	= "Unable to find individual with id";
$pgv_lang["save_and_import"]			= "After you save this GEDCOM configuration you will need to import the GEDCOM by clicking the <b>Import GEDCOM</b> button or by going to <b>Admin->Manage GEDCOMs->Import</b>";
$pgv_lang["help_info"]				= "You can get help for each item by clicking on the red &quot;?&quot; beside the label for each cell.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Show living names";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Should the names of living people be shown to the public?<br /><br />This sets \$SHOW_LIVING_NAMES in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Show research assistant";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />What type of user can view the research assistant module if it is installed?<br /><br />This sets \$SHOW_RESEARCH_ASSISTANT in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Use relationship privacy";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>No</b> means that authenticated users can see the details of all living people.  <b>Yes</b> means that users can only see the private information of living people they are related to.<br /><br />This sets \$USE_RELATIONSHIP_PRIVACY in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. relation path length";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />If #pgv_lang[USE_RELATIONSHIP_PRIVACY]# is enabled, logged in users will only be able to see or edit individuals within this number of relationship steps.<br /><br />This sets \$MAX_RELATION_PATH_LENGTH in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Check marriage relations";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Check relationships that are related by marriage.<br /><br />This sets \$CHECK_MARRIAGE_RELATIONS in <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Show dead people";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Set the privacy access level for all dead people.<br />";
$pgv_lang["select_privacyfile_button"]		= "Select privacy file";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Limit Privacy by age of event";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />The <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> setting will hide the details of people based on how old they were at specific events regardless of whether they are dead or alive.<br /><br />Use this setting along with the <b>#pgv_lang[MAX_ALIVE_AGE]#</b> setting.  For example, if you made the Age setting 100 and set this option to <b>Yes</b>, all persons, alive or dead, born less than 100 years ago would be set to private.  People who were married less than 85 years ago and people who died less than 75 years ago would also be marked as private.  Please note that using this option will slow down your performance somewhat.<br /><br />This sets \$PRIVACY_BY_YEAR in <i><u>xxx</u>.GED_priv.php</i>.<br />";

//-- language edit utility
$pgv_lang["enable_disable_lang"]	= "Configure supported languages";
$pgv_lang["translator_tools"]	= "Translator tools";
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />This page is intended to be used by translators.  You can translate, compare, and export language files.  There is also an option to help translators determine the origin of text that is output by PhpGedView.<br /><br />You can use the following options and utilities:<br />";
$pgv_lang["edit_langdiff"]		= "Edit and configure language files";
$pgv_lang["bom_check"]		= "Byte Order Mark (BOM) check";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br />";
$pgv_lang["bom_check_desc"]		= "This check will analyze all the language files for the BOM (Byte Order Mark). If found, it will remove the BOM from the affected file. These special codes can cause malfunctions in some parts of PhpGedView.";
$pgv_lang["lang_debug"]			= "Help Text Debug Option";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["lang_debug_desc"]	= "When you enable this option, the names of the language variables used in help text will print in the help text popup window.  This will help translators determine the variable name when text needs to be adjusted.<br /><br />This setting will only be valid during your current PhpGedView session.";
$pgv_lang["lang_debug_use"]		= "Use Help Text Debug Option";
$pgv_lang["bom_not_found"]		= "No BOM has been found.";
$pgv_lang["bom_found"]			= "BOM has been found in ";
$pgv_lang["edit_lang_utility"]		= "Language File Edit Utility";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#<br />";
$pgv_lang["edit_lang_utility_desc"]	= "You can use this utility to edit the contents of a language file by using the contents of the English one.<br /><br />You will see the contents of the original English language file and the contents of the same file type (there are four of these) in your chosen language.  You click on the message text shown below the English version.  This opens a new window where you can modify the text.  You can save the changes or abandon them.";
$pgv_lang["edit_lang_utility_warning"]	= "CAUTION!<br /><br />If you use the <b>#pgv_lang[close_window_without_refresh]#</b> button, you might not see your changes on the screen until you do a manual page reload.  It's possible that your language file may be destroyed if you add a message which has not yet appeared inside the language file or if you just edit a message you have edited directly before.<br /><br />If you don't really know what you're doing, please do not use the <b>#pgv_lang[close_window_without_refresh]#</b> button.";
$pgv_lang["language_to_edit"]		= "Language to edit";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />In this list box you select the language whose messages you want to edit.<br />";
$pgv_lang["file_to_edit"]		= "Language file type to edit";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />PhpGedView has implemented support for many different languages.  This has been achieved by keeping all text that is visible to users in files completely separate from the main program.  There is a set of five files for each supported language, and the various texts have been separated into one of these files according to function.  When a given text is not yet available in translated form, PhpGedView will use the English version.<br /><br />The files in each language set are:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;This file contains terms, common expressions, and Help text for use during configuration of PhpGedView.  The Help text is not intended to be viewed by ordinary users.</li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;This is a list of country names, taken from the Web site of the Statistics Division, United Nations Department of Economic and Social Affairs.  This is the relevant <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> to the English list.  The list is available in either English or French.</li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;This file contains the textual equivalents of the GEDCOM Fact codes found in the GEDCOM 5.5.1 Standard.  It also contains additional Fact codes not found in the Standard but used by various genealogy programs.<br /><br />An English copy of the <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> can be downloaded in PDF (Portable Document Format).</li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;This file contains Help text for ordinary users.  Some Help topics in this file address the needs of administrators, and are hidden from users who do not have Admin rights.</li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Many terms and common expressions are found in this file.</li></ul>";
$pgv_lang["check"]			= "Check";
$pgv_lang["lang_save"]			= "Save";
$pgv_lang["contents"]			= "Contents";
$pgv_lang["listing"]			= "Listing";
$pgv_lang["no_content"]			= "No Content";
$pgv_lang["editlang"]			= "Edit";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Edit message from language file.<br />";
$pgv_lang["cancel"]			= "Cancel";
$pgv_lang["savelang"]			= "Save";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Save edited message to language file.<br />";
$pgv_lang["original_message"]		= "Original message";
$pgv_lang["message_to_edit"]		= "Message to edit";
$pgv_lang["changed_message"]		= "Changed content";
$pgv_lang["message_empty_warning"]	= "-> Warning!!! This message is empty in #LANGUAGE_FILE# &lt;-";
$pgv_lang["language_to_export"]		= "Language to export";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />From this list box you can select the language whose messages you want to export.<br /><br />The routine currently only exports the contents of the <i>configure_help_text.php</i> file.  The output is an HTML file that you can print from your browser.<br />";
$pgv_lang["export_lang_utility"]	= "Language File Export Utility";
$pgv_lang["export"]			= "Export";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#<br />";
$pgv_lang["export_lang_utility_desc"]	= "You can create documentation for administrators.<br /><br />This utility will produce an HTML version of the Configuration Help file in the selected language.  You can use your browser to look at this file, which is formatted for printing.";
$pgv_lang["export_ok"]			= "Help messages were exported";
$pgv_lang["compare_lang_utility"]	= "Language File Comparison Utility";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["compare_lang_utility_desc"]	= "This utility will compare two sets of language files to produce a list of the additions and subtractions between them.<br /><br />Read also the file <a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a> for changes to the English version.  The English files should be used as the reference from which all others are produced.";
$pgv_lang["new_language"]		= "Source language";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />From this list box you can select the language whose messages you want to compare with those of another language.<br /><br />All changes and additions to language files are first made to the <b>English</b> language files, so you would normally select English as one of the languages to compare.<br />";
$pgv_lang["old_language"]		= "Secondary language";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />From this list box you can select the language which you want to compare with the language selected in the <b>Source</b> list box.<br /><br />After you have made your choice, click the <b>Compare</b> button to get a list of all additions and subtractions in all four files of both languages.<br /><br />To refresh your memory:<br /><b>Addition</b> means: It is <u>in</u> the Source file, but <u>not</u> in the Secondary file.<br /><br /><b>Subtraction</b> means: It is <u>not</u> in the Source file, but it <u>is</u> in the Secondary file.  This might happen when a given message is no longer used and therefore was removed from the English files.  You can safely remove the corresponding message from the secondary language files.<br />";
$pgv_lang["compare"]			= "Compare";
$pgv_lang["comparing"]			= "Language files that are compared";
$pgv_lang["additions"]			= "Additions";
$pgv_lang["no_additions"]		= "No Additions";
$pgv_lang["subtractions"]		= "Subtractions";
$pgv_lang["no_subtractions"]		= "No subtractions";
$pgv_lang["config_lang_utility"]	= "Configuration of supported languages";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />This page is used to control what language choices are available to your users.  For example, you can set things up so that only German and French are available.  This might be useful if, for example, you are not able to communicate with your users in Hungarian.<br /><br />You also use this page to alter certain aspects of PhpGedView that depend on the selected language.  For example, here is where you tell PhpGedView how to format date and time fields.<br /><br />The languages that are active and greyed out cannot be disabled because they are in use. Look at the bottom table to see where the language is used. When a language is no longer used by the GEDCOM or user you will be able to disable it.<br /><br />All of your changes will be recorded in a new file called <b>lang_settings.php</b> created in the <b>#INDEX_DIRECTORY#</b> directory.  All of your further changes will be made to this new file and PhpGedView will use only <u>this</u> file.  You can revert to the original default language settings by deleting this file.<br /><br />If you must report problems with your language settings, please tell the PhpGedView support team whether this new file is present or not.<br />";
$pgv_lang["active"]			= "Active";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Allow users to select this language if the option <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> is enabled.<br />";
$pgv_lang["edit_settings"]		= "Edit settings";
$pgv_lang["lang_edit"]			= "Edit";
$pgv_lang["lang_language"]		= "Language";
$pgv_lang["export_filename"]		= "Output file name:";
$pgv_lang["lang_back"]			= "Return to the main menu to edit and configure language files";
$pgv_lang["lang_back_admin"]		= "Return to the Admin menu";
$pgv_lang["lang_back_manage_gedcoms"]	= "Return to the GEDCOM management menu";
$pgv_lang["lang_name_czech"]		= "Czech";
$pgv_lang["lang_name_chinese"]		= "Chinese";
$pgv_lang["lang_name_danish"]		= "Danish";
$pgv_lang["lang_name_dutch"]		= "Dutch";
$pgv_lang["lang_name_english"]		= "English";
$pgv_lang["lang_name_finnish"]		= "Finnish";
$pgv_lang["lang_name_french"]		= "French";
$pgv_lang["lang_name_german"]		= "German";
$pgv_lang["lang_name_hebrew"]		= "Hebrew";
$pgv_lang["lang_name_hungarian"]	= "Hungarian";
$pgv_lang["lang_name_italian"]		= "Italian";
$pgv_lang["lang_name_norwegian"]	= "Norwegian";
$pgv_lang["lang_name_polish"]		= "Polish";
$pgv_lang["lang_name_portuguese"]	= "Portuguese";
$pgv_lang["lang_name_portuguese-br"]	= "Portuguese (Brazil)";
$pgv_lang["lang_name_russian"]		= "Russian";
$pgv_lang["lang_name_spanish"]		= "Spanish";
$pgv_lang["lang_name_spanish-ar"]	= "Spanish (Latin America)";
$pgv_lang["lang_name_swedish"]		= "Swedish";
$pgv_lang["lang_name_turkish"]		= "Turkish";
$pgv_lang["lang_name_greek"]		= "Greek";
$pgv_lang["lang_name_arabic"]		= "Arabic";
$pgv_lang["lang_name_lithuanian"]	= "Lithuanian";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamese";
$pgv_lang["lang_name_slovak"]		= "Slovak";
$pgv_lang["lang_name_estonian"]		= "Estonian";
$pgv_lang["lang_new_language"]		= "New Language";
$pgv_lang["original_lang_name"]		= "Original name of language in #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Original name of language~<br /><br />How is this language named in this language?<br /><br />English calls itself <b>English</b>;  German calls itself <b>Deutsch</b>;  Dutch calls itself <b>Nederlands</b>;  Czech calls itself <b>Ceština</b>, etc.<br />";
$pgv_lang["lang_shortcut"]		= "Abbreviation for language files";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />This code defines an abbreviation for the language name.  This abbreviation forms part of the name of each of the language files used by PhpGedView.  For example, the abbreviation used for French is <b>fr</b>, and consequently the file names for French are <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, and <i>lang.<b>fr</b>.php</i><br />";
$pgv_lang["lang_langcode"]		= "Language detection codes";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />These codes allow PhpGedView to detect the Preferred Language setting of the browser being used. PhpGedView determines the language actually being requested by the browser by matching the browser's language code against this list.  Individual list entries must be separated by a semicolon.<br />";
$pgv_lang["lang_filenames"]		= "Language files";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />PhpGedView has implemented support for many different languages.  This has been achieved by keeping all text that is visible to users in files completely separate from the main program.  There is a set of five files for each supported language, and the various texts have been separated into one of these files according to function.  When a given text is not yet available in translated form, PhpGedView will use the English version.<br /><br />The files in each language set are:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;This file contains terms, common expressions, and Help text for use during configuration of PhpGedView.  The Help text is not intended to be viewed by ordinary users.</li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;This is a list of country names, taken from the Web site of the Statistics Division, United Nations Department of Economic and Social Affairs.  This is the relevant <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> to the English list.  The list is available in either English or French.</li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;This file contains the textual equivalents of the GEDCOM Fact codes found in the GEDCOM 5.5.1 Standard.  It also contains additional Fact codes not found in the Standard but used by various genealogy programs.<br /><br />An English copy of the <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> can be downloaded in PDF (Portable Document Format).</li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;This file contains Help text for ordinary users.  Some Help topics in this file address the needs of Administrators, and are hidden from users who do not have Admin rights.</li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Many terms and common expressions are found in this file.</li></ul>";
$pgv_lang["flagsfile"]			= "Flag file";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Name of the national flag image file for the selected language.<br /><br />Images for many countries are available from <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a> site.<br /><br />When you find a flag image you like, right-click on it and save the image in a temporary folder. Next, open the saved image with a suitable image editor (IrfanView is recommended for Windows systems), reduce its size 50x32 pixels, which is the normal size used in PhpGedView, and then save it as a GIF file to the <i><b>images/flags</b></i> folder.<br /><br />Although you can use any name you wish, you should select a name consistent with the two-letter language shortcut.  For example, Croatian is represented by the two-letter code <i><b>hr</b></i>, so the Croatian flag would normally be named <i><b>hr.gif</b></i>.<br />";
$pgv_lang["text_direction"]		= "Text direction";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Identifies which direction is used to write text in the chosen language.  Most languages are written from left to right.  Arabic and Hebrew are examples of languages that are written in the opposite direction (right to left).<br />";
$pgv_lang["date_format"]			= "Date format";
$pgv_lang["date_format_help"]		= "~#pgv_lang[date_format]#~<br /><br />This field defines the date format to be used by PhpGedView when displaying dates from the database.<ul><li><b>Standard format</b><br />Symbols you can use are:<br /><b>D</b> for day<br /><b>M</b> for month<br /><b>Y</b> for year.<br /><br />You can change the order of these symbols, and you can add delimiters to the format.<br /><br />For the examples below, assume that the date in the database is 1965.08.20, which is actually recorded as <b>DATE&nbsp;20&nbsp;Aug&nbsp;1965</b>.<br /><br />The standard setting for the English date display format is <b>D&nbsp;M&nbsp;Y</b>, which produces <b>20&nbsp;August&nbsp;1965</b>.<br /><br />The German date format is usually <b>D.&nbsp;M&nbsp;Y</b>, resulting in <b>20.&nbsp;August&nbsp;1965</b> when displayed by PhpGedView.  The eighth month is called \"August\" in German.<br /><br />In Hungarian, the format normally is <b>Y.&nbsp;M&nbsp;D.</b> producing <b>1965.&nbsp;augusztus&nbsp;20.</b> when displayed by PhpGedView.  In Hungarian, month names do not have an initial capital letter, and the eighth month is called \"augusztus\".</li><li><b>Alternative format</b><br />To show dates in special ways not handled by the <b>Standard format</b>, use these codes:<br /><b>d</b> - day of the month, 2 digits, leading zero; i.e. <b>01</b> to <b>31</b><br /><b>D</b> - day of the week, textual, 3 letters; e.g. <b>Fri</b><br /><b>F</b> - month, textual, long; e.g. <b>January</b><br /><b>j</b> - day of the month, no leading zeros; i.e. <b>1</b> to <b>31</b><br /><b>l</b> (lowercase \"L\") - day of the week, textual, long; e.g. <b>Friday</b><br /><b>M</b> - month, textual, 3 letters; e.g. <b>Jan</b><br /><b>Y</b> - year, 4 digits; e.g. <b>1999</b><br /><b>R</b> - French Revolutionary format (see note)<br /><b>y</b> - year, 2 digits; e.g. <b>99</b><br /><br />For example, the date format <b>D&nbsp;j&nbsp;F&nbsp;Y</b> could result in <b>Thu&nbsp;9&nbsp;January&nbsp;1806</b> while the same date displayed according to the formula <b>l&nbsp;d&nbsp;M&nbsp;Y</b> would result in <b>Thursday&nbsp;09&nbsp;Jan&nbsp;1806</b></li><li><b>French Revolutionary format</b><br />The format code <b>R</b> works in all languages, but produces output when the date is in the range 1792.09.22 to 1805.12.31.  The <b>R</b> code produces only French text, and the order of Day, Month, and Year cannot be changed. The output of the <b>R</b> formatting code is underlined to distinguish it from the regular date.  <br /><br />The <b>R</b> formatting code is considered to be normal text when the date format contains only <b>D</b>, <b>M</b>, and <b>Y</b> codes as described in the topic <b>Standard format</b> above.  In other words, for the <b>R</b> code to be recognized, the date format needs to contain a code from the <b>Alternative format</b> list that doesn't appear in the <b>Standard format</b> list.<br /><br />For example, the date format <b>D&nbsp;M&nbsp;Y&nbsp;R</b> will produce <b>13&nbsp;October&nbsp;1797&nbsp;R</b> in English for the date 1797.10.13. If, on the other hand, the date format were <b>j&nbsp;F&nbsp;Y&nbsp;R</b>, the same date would result in <b>13&nbsp;October&nbsp;1797&nbsp;<u>22&nbsp;Vendemiaire&nbsp;An&nbsp;6</u></b> in English.</li></ul>";
$pgv_lang["time_format"]		= "Time format";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />This field defines the time format to be used by PhpGedView.<br /><br />Symbols you can use are:<br /><b>a</b> - lowercase Ante meridiem and Post meridiem; i.e. <b>am</b> or <b>pm</b><br /><b>A</b> - uppercase Ante meridiem and Post meridiem; i.e. <b>AM</b> or <b>PM</b><br /><b>B</b> - Swatch Internet time; i.e. <b>000</b> through <b>999</b><br /><b>c</b> - ISO 8601 date (added in PHP 5); e.g. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - day of the month, 2 digits, leading zero; i.e. <b>01</b> to <b>31</b><br /><b>D</b> - day, textual, three letters; e.g. <b>Mon</b><br /><b>F</b> - month, textual, long; e.g. <b>January</b><br /><b>g</b> - hour, 12-hour format, no leading zero; i.e. <b>1</b> through <b>12</b><br /><b>G</b> - hour, 24-hour format, no leading zero; i.e. <b>0</b> through <b>23</b><br /><b>h</b> - hour, 12-hour format, leading zero; i.e. <b>01</b> through <b>12</b><br /><b>H</b> - hour, 24-hour format, leading zero; i.e. <b>00</b> through <b>23</b><br /><b>i</b> - minutes, leading zero; i.e. <b>00</b> to <b>59</b><br /><b>I</b> (capital \"i\") - daylight saving time indicator; <b>1</b> if Daylight Saving Time, <b>0</b> otherwise.<br /><b>j</b> - day of the month, no leading zero; i.e. <b>1</b> to <b>31</b><br /><b>l</b> (lowercase \"L\") - day of the week, textual, long; e.g. <b>Friday</b><br /><b>L</b> - leap year indicator; <b>1</b> if it is a leap year, <b>0</b> otherwise.<br /><b>m</b> - month, numeric, leading zero; i.e. <b>01</b> through <b>12</b><br /><b>M</b> - month, textual, 3 letters; e.g. <b>Jan</b><br /><b>n</b> - month, numeric, no leading zero; i.e. <b>1</b> through <b>12</b><br /><b>O</b> (capital \"o\") - difference between local and Greenwich time (GMT) in hours; e.g. <b>+0200</b><br /><b>r</b> - RFC 2822 formatted date; e.g. <b>Thu,&nbsp;21&nbsp;Dec&nbsp;2000nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - seconds, leading zero; i.e. <b>00</b> through <b>59</b><br /><b>S</b> - day of the month suffix, English only, 2 characters; i.e. <b>st</b>, <b>nd</b>, <b>rd</b> or <b>th</b>. Works well with <b>j</b><br /><b>t</b> - number of days in the given month; i.e. <b>28</b> through <b>31</b><br /><b>T</b> - time zone setting of this machine; e.g. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - seconds since the start of the Unix Epoch (January&nbsp;1&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - day of the week, numeric; i.e. <b>0</b> (for Sunday) through <b>6</b> (for Saturday)<br /><b>W</b> - ISO-8601 week number of year, weeks starting on Monday; e.g. <b>42</b> (the 42nd week in the year)<br /><b>Y</b> - year, 4 digits; e.g. <b>1999</b><br /><b>y</b> - year, 2 digits; e.g. <b>99</b><br /><b>z</b> - day of year, numeric, no leading zeros; i.e. <b>0</b> (1 Jan) through <b>364</b> (31 Dec when not a leap year) or <b>365</b> (31 Dec in leap years)<br /><b>Z</b> - time zone offset in seconds.  The offset for time zones west of Greenwich is always negative, and for those east of Greenwich the offset is always positive. i.e. <b>-43200</b> through <b>43200</b><br /><br />You can change the order of these symbols, and you can add delimiters to the format.<br /><br />For example, in German this field normally contains <b>H:i:s</b> to produce a display like <b>09:01:25</b>. English usually defines the time format as <b>g:i:sa</b> to produce a display like <b>9:01:25am</b>.<br /><br />In the 24-hour system, midnight is 00:00.  In the 12-hour system, midnight is 12:00am and noon is 12:00pm.<br />";
$pgv_lang["week_start"]			= "Week starting day";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />The day of the week that starts a new week in this language.  Most languages start the week on Sunday, but some start on Monday or other days.<br />";
$pgv_lang["name_reverse"]		= "Surname first";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />In some languages the surname should be displayed first instead of the default to display it last.  Enabling this option will display the surname first.  Hungarian, Chinese, and Japanese are examples where the surname (the family name) is usually given first.<br />";
$pgv_lang["ltr"]			= "Left to right";
$pgv_lang["rtl"]			= "Right to left";
$pgv_lang["file_does_not_exist"]	= "ERROR! The file does not exist...";
$pgv_lang["alphabet_upper"]		= "Alphabet upper case";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Upper case alphabet letters in this language.  This alphabet is used while sorting lists of names.<br />";
$pgv_lang["alphabet_lower"]		= "Alphabet lower case";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Lower case alphabet letters in this language.  This alphabet is used while sorting lists of names.<br />";
$pgv_lang["multi_letter_alphabet"]		= "Multi-letter alphabet";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Multi-letter combinations that are to be treated as a single distinct letter when sorting lists of names and titles in this language.<br /><br />Some languages, Hungarian and Slovak for example, consider certain combinations of letters to be distinct letters in their own right.  The order in which you specify these letter combinations determines the order in which they are inserted into the normal alphabet during sorting.  This is important when several multi-letter combinations have the same first letter.  Except for <b>ch</b>, these letter combinations are inserted into the normal alphabet according to their first letter.  <b>ch</b> is always inserted after <b>h</b>.<br />";
$pgv_lang["dictionary_sort"]		= "Use dictionary rules while sorting";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />This option controls how characters with diacritic marks are handled when sorting lists of names and titles.<br /><br />When set to <b>#pgv_lang[yes]#</b>, all characters with diacritic marks are treated as if they did not have any marks.  Diacritic marks are considered only when the two words being considered are otherwise identical.  When set to <b>#pgv_lang[no]#</b>, all letters are distinct, regardless of the presence or absence of diacritic marks.<br />";
$pgv_lang["lang_config_write_error"]	= "Error writing language settings into the file <b>lang_settings.php</b>.  Please check permissions and try again.";
$pgv_lang["translation_forum"]		= "PhpGedView Translations forum on SourceForge";
$pgv_lang["translation_forum_help"]	= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["translation_forum_desc"]	= "This <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"_blank\"><b>link</b></a> opens a new browser window.  You will be redirected to the Translations forum of PhpGedView, where you can discuss translation topics.";
$pgv_lang["system_time"]		= "Current System Time:";
$pgv_lang["gedcom_not_imported"]	= "This GEDCOM has not yet been imported.";
$pgv_lang["lang_set_file_read_error"]	= "E R R O R !!! Could not read <b>lang_settings.php</b>!";
$pgv_lang["add_new_language"]		= "Add files and settings for a new language";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "This routine lets you add a new, previously unavailable and completely unsupported language to PhpGedView.<br /><br />You can set up the standard settings of the new language.  These include language detection code, language direction, start of the week for this language, time settings, alphabet, etc.<br /><br />You will get more help on the settings of languages supported by PhpGedView after selecting the language and clicking the <b>#pgv_lang[add_new_lang_button]#</b> button.<br /><br />More help is available on the Configuration page for the language.<br />";
$pgv_lang["add_new_lang_button"]	= "Add new language";
$pgv_lang["hide_translated"]		= "Hide translated";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />If set to <b>Yes</b> you will only see those messages of your selected language file which have not been translated.  This means the new message does <u>not</u> appear in the target language file.<br /><br />Some language files contain English text for various untranslated messages.  This routine cannot identify these untranslated items, since they already are present in the target file.  The assumption is, \"If the message is present in the target file, it must have been translated.\"<br />";
$pgv_lang["lang_file_write_error"]	= "E R R O R !!!<br /><br />Could not write changes into the selected language file.  Please check Write permissions on <b>#lang_filename#</b>";
$pgv_lang["no_open"]	= "E R R O R !!!<br /><br />Cannot open file <b>#lang_filename#</b>";
$pgv_lang["never"]					= "Never";
$pgv_lang["users_total"]			= "Total number of users";
$pgv_lang["users_admin"]			= "Site Administrators";
$pgv_lang["users_unver"]			= "Unverified by User";
$pgv_lang["users_unver_admin"]		= "Unverified by Administrator";
$pgv_lang["users_langs"]			= "Users' languages";
$pgv_lang["warn_users"]				= "Users with warnings";
$pgv_lang["users_gedadmin"]			= "GEDCOM Administrators";
$pgv_lang["cleanup_users"]			= "Cleanup users";
$pgv_lang["usr_no_cleanup"]			= "Nothing found to cleanup";
$pgv_lang["back_useradmin"]			= "Back to User Administration";
$pgv_lang["del_proceed"]			= "Continue";
$pgv_lang["del_unveru"]				= "User didn't verify within 7 days.";
$pgv_lang["del_unvera"]				= "User not verified by administrator.";
$pgv_lang["del_gedrights"]			= "GEDCOM no longer active, remove user references.";
$pgv_lang["usr_idle"]				= "Number of months since the last login for a user's account to be considered inactive: ";
$pgv_lang["usr_idle_toolong"]		= "User's account has been inactive too long: ";
$pgv_lang["usr_unset_rights"]		= "Unset GEDCOM rights for ";
$pgv_lang["usr_unset_rootid"]		= "Unset root ID for ";
$pgv_lang["usr_unset_gedcomid"]		= "Unset GEDCOM ID for ";
$pgv_lang["usr_deleted"]			= "Deleted user: ";
$pgv_lang["configured_languages"]	= "Languages used";
$pgv_lang["message_to_all"]			= "Send message to all users";
$pgv_lang["ip_address"]				= "IP address";
$pgv_lang["date_time"]				= "Date and time";
$pgv_lang["message"]				= "Message";
$pgv_lang["searchtype"]				= "Search type";
$pgv_lang["type"]					= "Type";
$pgv_lang["query"]					= "Query";


//-- User Migration Tool messages
$pgv_lang["um_header"] = "User Information Migration tool";
$pgv_lang["um_proceed"] = "Choose an option or click the link below to return to the Administration menu<br />";
$pgv_lang["um_creating"] = "Creating";
$pgv_lang["um_sql_index"] = "This tool will create <i>authenticate.php</i> and several <i>.dat</i> files in your index directory.<br /><br />After successful creation, you can switch to Index mode with all current users and their messages, favorites, news, and MyGedview layout available.<br /><br />Note: After switching to Index mode, you will need to import your GEDCOM files again.<br />";
$pgv_lang["um_file_create_fail1"] = "Creation of new file failed, a file with that name already exists:";
$pgv_lang["um_file_create_fail2"] = "Cannot create";
$pgv_lang["um_file_create_fail3"] = "Check access rights on this directory.";
$pgv_lang["um_file_create_succ1"] = "Creation of new file successful:";
$pgv_lang["um_file_not_created"] = "File is not created.";
$pgv_lang["um_nomsg"] = "No Messages seem to be present in the system.";
$pgv_lang["um_nofav"] = "No Favorites seem to be present in the system.";
$pgv_lang["um_nonews"] = "No News seems to be present in the system.";
$pgv_lang["um_noblocks"] = "No Blocks seems to be present in the system.";
$pgv_lang["um_index_sql"] = "This tool will import <i>authenticate.php</i> and other <i>.dat</i> files from your index directory into your database.<br />";
$pgv_lang["um_noaction"] = "No action is required to migrate user information to SQL mode.<br /><br />Once switched to SQL mode, you need to restart the User Migration tool to import all data into the SQL database.  PhpGedView will use existing files from Index mode.<br /><br /><b>Do <u>not</u> remove <i>authenticate.php</i> and <i>.dat</i> files from your index directory while switching.</b><br />";
$pgv_lang["um_import"] = "Import";
$pgv_lang["um_export"] = "Export";
$pgv_lang["um_explain"] = "This tool will either export user data from SQL to Index mode, or import user data from Index files into SQL tables.<br /><br />User data, favorites, block definitions, messages, and news will be available again after migration.<br /><br /><b>CAUTION</b><br />You cannot use this tool to migrate user data between different versions of PhpGedView. Be sure that the data originates from, or is imported into the same PhpGedView version.<br /><br /><b>IMPORT</b><br />If you choose to import the user data files from Index mode, all user data present in the database tables will be <u>overwritten</u>. This tool does <u>not</u> merge the information. Once you have run the Import, there is no way to retrieve the old information using PhpGedView.<br /><br /><b>EXPORT</b><br />If you export the user information from your SQL database to Index Mode files, this tool will create <i>authenticate.php</i> and several <i>.dat</i> files in your index directory. If identically named files are already present, you will be prompted if they must be overwritten. After switching to Index mode, all information will be available directly.<br /><br /><b>Note:</b> After switching to Index mode, you will need to import your GEDCOM files again.<br />";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migrate users from SQL to Index mode~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migrate users from Index to SQL mode~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importing users";
$pgv_lang["um_imp_blocks"] = "Importing blocks";
$pgv_lang["um_imp_favorites"] = "Importing favorites";
$pgv_lang["um_imp_messages"] = "Importing messages";
$pgv_lang["um_imp_news"] = "Importing news";
$pgv_lang["um_nousers"] = "File <i>authenticate.php</i> not found in your index directory. Migration is cancelled.";
$pgv_lang["um_imp_succ"] = "Import successful";
$pgv_lang["um_imp_fail"] = "Import failed";
$pgv_lang["um_backup"] = "Backup";
$pgv_lang["um_zip_succ"] = "ZIP file successfully created.";
$pgv_lang["um_zip_dl"] = "Download ZIPped backup file ";
$pgv_lang["um_bu_explain"] = "This tool can make a backup of several kinds of data in PhpGedView.<br /><br />The data you choose to back up will be gathered into a ZIP file, which you can download by clicking the link at the bottom of the page, after the backup has been successfully made.<br /><br />The ZIP file will remain in your Index directory until you remove it manually.<br />";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "PhpGedView Configuration File";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM Files";
$pgv_lang["um_bu_gedsets"] = "GEDCOM Settings, Configuration and Privacy files";
$pgv_lang["um_bu_logs"] = "GEDCOM Counters, SearchLogs and PhpGedView Logfiles";
$pgv_lang["um_bu_usinfo"] = "User definitions, Block settings, Favorites, Messages, News";
$pgv_lang["um_mk_bu"] = "Make Backup";
$pgv_lang["um_nofiles"] = "No files found for backup.";
$pgv_lang["um_files_exist"] = "One or more files already exist. Do you want to overwrite them?";
$pgv_lang["um_results"]		= "Results";
$pgv_lang["preview_faq_item"] = "Preview all FAQ items";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />This option lets an admin user view the FAQ page without all the editing options and links.<br /><br /> Except for a single <b>Edit</b> link above the first FAQ item, the appearance of the FAQ page will be identical to what an ordinary user would see. This special <b>Edit</b> link will restore full Edit functionality to the FAQ page.<br />";
$pgv_lang["restore_faq_edits"] = "Restore FAQ edit functionality";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />This option restores the FAQ page to what an admin user normally sees, so that individual FAQ items may be edited.<br />";
$pgv_lang["add_faq_item"] = "Add FAQ item";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />This option will let you add an item to the FAQ page.<br />";
$pgv_lang["edit_faq_item"] = "Edit FAQ item";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />This option will let you edit an item on the FAQ page.<br />";
$pgv_lang["delete_faq_item"] = "Delete FAQ item";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />This option will let you delete an item from the FAQ page<br />";
$pgv_lang["moveup_faq_item"] = "Move FAQ item up";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />This option will let you move an item upwards on the FAQ page.<br /><br />Each time you use this option, the FAQ Position number of this item is reduced by one.  You can achieve the same effect by editing the item in question and changing the FAQ Position field.  When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["movedown_faq_item"] = "Move FAQ item down";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />This option will let you move an item downwards on the FAQ page.<br /><br />Each time you use this option, the FAQ Position number of this item is increased by one.  You can achieve the same effect by editing the item in question and changing the FAQ Position field.  When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["add_faq_header_help"] = "~FAQ Header~<br />This is the title or subject of the FAQ item.<br /><br />What you enter here can be formatted; HTML tags such as &lt;b&gt; and &lt;br&gt; are allowed, as are HTML entities such as &amp;amp; and &amp;nbsp;.  There is no way to enter HTML tags so that they will be interpreted as text.<br />";
$pgv_lang["add_faq_body_help"] = "~FAQ Body~<br />The text of the FAQ item is entered here.<br /><br />The text can be formatted; HTML tags such as &lt;b&gt; and &lt;br&gt; are allowed, as are HTML entities such as &amp;amp; and &amp;nbsp;.  There is no way to enter HTML tags so that they will be interpreted as text.<br />";
$pgv_lang["add_faq_order_help"] = "~FAQ Position~<br />This field controls the order in which the FAQ items are displayed.<br /><br />You do not have to enter the numbers sequentially.  If you leave holes in the numbering scheme, you can insert other items later.  For example, if you use the numbers 1, 6, 11, 16, you can later insert items with the missing sequence numbers.  Negative numbers and zero are allowed, and can be used to insert items in front of the first one.<br /><br />When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />The maximum time the import is allowed to run for processing the GEDCOM file.";

// Media items
$pgv_lang["media_import_help"] = "~#pgv_lang[media_import]#~<br />This import will convert the multimedia links in your GEDCOM file to multimedia records. For example, the following media entry will be changed from:<blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Picture of grandma</code></blockquote>to:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/grandma.jpg<br />1 TITL Picture of grandma</code></blockquote>The new multimedia record will be stored separately in the database. Links to external multimedia files will be changed to references to the new multimedia record, which will in turn contain a reference to the external file. For example, the following GEDCOM record will be changed from:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Picture of grandma</code></blockquote>to:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE @M1@<br /></code></blockquote>The advantage of using multimedia records is that you can easily administer your media. When you change the title of a multimedia record, it is changed for all GEDCOM records that link to this multimedia record. Several people,families, or sources can be linked to the same multimedia record.";

?>
