#!/bin/sh
# CVE-2010-4567
# CVE-2011-0048
set -e

echo "> $0 $*"

cd "$1" && patch -p1 < "$0"

exit 0

Description: tighten URL-checking
 CVE-2010-4567 Safety checks that disallow clicking for javascript: or data: URLs in the
 URL field can be evaded with prefixed whitespace
 CVE-2011-0048 For not-logged-in users, the URL field doesn't safeguard against
 javascript: or data: URLs
Origin: http://bzr.mozilla.org/bugzilla/3.6/revision/7224
Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=619588
Bug-Debian: http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=611176

--- a/Bugzilla/Template.pm	2010-11-04 16:48:50 +0000
+++ b/Bugzilla/Template.pm	2011-01-24 18:36:51 +0000
@@ -736,6 +736,19 @@
                 return $docs_urlbase;
             },
 
+            # Check whether the URL is safe.
+            'is_safe_url' => sub {
+                my $url = shift;
+                return 0 unless $url;
+
+                my $safe_protocols = join('|', SAFE_PROTOCOLS);
+                return 1 if $url =~ /^($safe_protocols):[^\s<>\"]+[\w\/]$/i;
+                # Pointing to a local file with no colon in its name is fine.
+                return 1 if $url =~ /^[^\s<>\":]+[\w\/]$/i;
+                # If we come here, then we cannot guarantee it's safe.
+                return 0;
+            },
+
             # Allow templates to generate a token themselves.
             'issue_hash_token' => \&Bugzilla::Token::issue_hash_token,
 
--- a/template/en/default/bug/edit.html.tmpl	2010-02-18 19:02:58 +0000
+++ b/template/en/default/bug/edit.html.tmpl	2011-01-24 18:36:51 +0000
@@ -553,8 +553,7 @@
   <tr>
     <td class="field_label">
       <label for="bug_file_loc" accesskey="u"><b>
-        [% IF bug.bug_file_loc 
-           AND NOT bug.bug_file_loc.match("^(javascript|data)") %]
+        [% IF is_safe_url(bug.bug_file_loc) %]
           <a href="[% bug.bug_file_loc FILTER html %]"><u>U</u>RL</a>
         [% ELSE %]
           <u>U</u>RL
@@ -564,8 +563,7 @@
     <td>
       [% IF bug.check_can_change_field("bug_file_loc", 0, 1) %]
         <span id="bz_url_edit_container" class="bz_default_hidden"> 
-        [% IF bug.bug_file_loc 
-           AND NOT bug.bug_file_loc.match("^(javascript|data)") %]
+        [% IF is_safe_url(bug.bug_file_loc) %]
            <a href="[% bug.bug_file_loc FILTER html %]" target="_blank"
               title="[% bug.bug_file_loc FILTER html %]">
              [% bug.bug_file_loc FILTER truncate(40) FILTER html %]</a>
@@ -576,7 +574,8 @@
       [% END %]
       <span id="bz_url_input_area">
         [% url_output =  PROCESS input no_td=1 inputname => "bug_file_loc" size => "40" colspan => 2 %]
-        [% IF NOT bug.check_can_change_field("bug_file_loc", 0, 1)  %]
+        [% IF NOT bug.check_can_change_field("bug_file_loc", 0, 1)
+              AND is_safe_url(bug.bug_file_loc)  %]
           <a href="[% bug.bug_file_loc FILTER html %]">[% url_output FILTER none %]</a>
         [% ELSE %]
           [% url_output FILTER none %]

--- a/template/en/default/bug/show-multiple.html.tmpl	2009-11-18 07:04:57 +0000
+++ b/template/en/default/bug/show-multiple.html.tmpl	2011-01-24 18:36:51 +0000
@@ -163,11 +163,11 @@
       <tr>
         <th>[% field_descs.bug_file_loc FILTER html %]:</th>
         <td colspan="3">
-          [% IF bug.bug_file_loc.match("^(javascript|data)") %]
-            [% bug.bug_file_loc FILTER html %]
-          [% ELSE %]
+          [% IF is_safe_url(bug.bug_file_loc) %]
             <a href="[% bug.bug_file_loc FILTER html %]">
                      [% bug.bug_file_loc FILTER html %]</a>
+          [% ELSE %]
+            [% bug.bug_file_loc FILTER html %]
           [% END %]
         </td>
       </tr>

