// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   ./tools/json_schema_compiler/compiler.py.

/** @fileoverview Interface for networkingPrivate that can be overriden. */

assertNotReached('Interface file for Closure Compiler should not be executed.');

/** @interface */
function NetworkingPrivate() {}

NetworkingPrivate.prototype = {
  /**
   * Gets all the properties of the network with id networkGuid. Includes all
   * properties of the network (read-only and read/write values).
   * @param {string} networkGuid The GUID of the network to get properties for.
   * @param {function(!chrome.networkingPrivate.NetworkProperties):void}
   *     callback Called with the network properties when received.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-getProperties
   */
  getProperties: assertNotReached,

  /**
   * Gets the merged properties of the network with id networkGuid from the
   * sources: User settings, shared settings, user policy, device policy and the
   * currently active settings.
   * @param {string} networkGuid The GUID of the network to get properties for.
   * @param {function(!chrome.networkingPrivate.ManagedProperties):void}
   *     callback Called with the managed network properties when received.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-getManagedProperties
   */
  getManagedProperties: assertNotReached,

  /**
   * Gets the cached read-only properties of the network with id networkGuid.
   * This is meant to be a higher performance function than
   * $(ref:getProperties), which requires a round trip to query the networking
   * subsystem. The following properties are returned for all networks: GUID,
   * Type, Name, WiFi.Security. Additional properties are provided for visible
   * networks: ConnectionState, ErrorState, WiFi.SignalStrength,
   * Cellular.NetworkTechnology, Cellular.ActivationState,
   * Cellular.RoamingState.
   * @param {string} networkGuid The GUID of the network to get properties for.
   * @param {function(!chrome.networkingPrivate.NetworkStateProperties):void}
   *     callback Called immediately with the network state properties.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-getState
   */
  getState: assertNotReached,

  /**
   * Sets the properties of the network with id networkGuid.
   * @param {string} networkGuid The GUID of the network to set properties for.
   * @param {!chrome.networkingPrivate.NetworkConfigProperties} properties The
   *     properties to set.
   * @param {function():void=} callback Called when the operation has completed.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-setProperties
   */
  setProperties: assertNotReached,

  /**
   * Creates a new network configuration from properties. If a matching
   * configured network already exists, this will fail. Otherwise returns the
   * guid of the new network.
   * @param {boolean} shared If true, share this network configuration with
   *     other users.
   * @param {!chrome.networkingPrivate.NetworkConfigProperties} properties The
   *     properties to configure the new network with.
   * @param {function(string):void=} callback Called with the GUID for the new
   *     network configuration once     the network has been created.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-createNetwork
   */
  createNetwork: assertNotReached,

  /**
   * Forgets a network configuration by clearing any configured properties for
   * the network with GUID 'networkGuid'. This may also include any other
   * networks with matching identifiers (e.g. WiFi SSID and Security). If no
   * such configuration exists, an error will be set and the operation will
   * fail.
   * @param {string} networkGuid The GUID of the network to forget.
   * @param {function():void=} callback Called when the operation has completed.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-forgetNetwork
   */
  forgetNetwork: assertNotReached,

  /**
   * Returns a list of network objects with the same properties provided by
   * $(ref:networkingPrivate.getState). A filter is provided to specify the type
   * of networks returned and to limit the number of networks. Networks are
   * ordered by the system based on their priority, with connected or connecting
   * networks listed first.
   * @param {!chrome.networkingPrivate.NetworkFilter} filter Describes which
   *     networks to return.
   * @param {function(!Array<!chrome.networkingPrivate.NetworkStateProperties>):void}
   *     callback Called with a dictionary of networks and their state
   *     properties when received.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-getNetworks
   */
  getNetworks: assertNotReached,

  /**
   * Returns a list of $(ref:networkingPrivate.DeviceStateProperties) objects.
   * @param {function(!Array<!chrome.networkingPrivate.DeviceStateProperties>):void}
   *     callback Called with a list of devices and their state.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-getDeviceStates
   */
  getDeviceStates: assertNotReached,

  /**
   * Enables any devices matching the specified network type. Note, the type
   * might represent multiple network types (e.g. 'Wireless').
   * @param {!chrome.networkingPrivate.NetworkType} networkType The type of
   *     network to enable.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-enableNetworkType
   */
  enableNetworkType: assertNotReached,

  /**
   * Disables any devices matching the specified network type. See note for
   * $(ref:networkingPrivate.enableNetworkType).
   * @param {!chrome.networkingPrivate.NetworkType} networkType The type of
   *     network to disable.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-disableNetworkType
   */
  disableNetworkType: assertNotReached,

  /**
   * Requests that the networking subsystem scan for new networks and update the
   * list returned by $(ref:getVisibleNetworks). This is only a request: the
   * network subsystem can choose to ignore it.  If the list is updated, then
   * the $(ref:onNetworkListChanged) event will be fired.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-requestNetworkScan
   */
  requestNetworkScan: assertNotReached,

  /**
   * Starts a connection to the network with networkGuid.
   * @param {string} networkGuid The GUID of the network to connect to.
   * @param {function():void=} callback Called when the connect request has been
   *     sent. Note: the     connection may not have completed. Observe
   *     $(ref:onNetworksChanged)     to be notified when a network state
   *     changes.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-startConnect
   */
  startConnect: assertNotReached,

  /**
   * Starts a disconnect from the network with networkGuid.
   * @param {string} networkGuid The GUID of the network to disconnect from.
   * @param {function():void=} callback Called when the disconnect request has
   *     been sent. See note     for $(ref:startConnect).
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-startDisconnect
   */
  startDisconnect: assertNotReached,

  /**
   * Starts activation of the Cellular network with networkGuid. If called for a
   * network that is already activated, or for a network with a carrier that can
   * not be directly activated, this will show the account details page for the
   * carrier if possible.
   * @param {string} networkGuid The GUID of the Cellular network to activate.
   * @param {string=} carrier Optional name of carrier to activate.
   * @param {function():void=} callback Called when the activation request has
   *     been sent. See note     for $(ref:startConnect).
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-startActivate
   */
  startActivate: assertNotReached,

  /**
   * Verifies that the device is a trusted device.
   * @param {!chrome.networkingPrivate.VerificationProperties} properties
   *     Properties of the destination to use in verifying that it     is a
   *     trusted device.
   * @param {function(boolean):void} callback A callback function that indicates
   *     whether or not the device     is a trusted device.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-verifyDestination
   */
  verifyDestination: assertNotReached,

  /**
   * Verifies that the device is a trusted device and retrieves encrypted
   * network credentials.
   * @param {!chrome.networkingPrivate.VerificationProperties} properties
   *     Properties of the destination to use in verifying that it     is a
   *     trusted device.
   * @param {string} networkGuid The GUID of the Cellular network to activate.
   * @param {function(string):void} callback A callback function that receives
   *     base64-encoded encrypted     credential data to send to a trusted
   *     device.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-verifyAndEncryptCredentials
   */
  verifyAndEncryptCredentials: assertNotReached,

  /**
   * Verifies that the device is a trusted device and encrypts supplied data
   * with device public key.
   * @param {!chrome.networkingPrivate.VerificationProperties} properties
   *     Properties of the destination to use in verifying that it     is a
   *     trusted device.
   * @param {string} data A string containing the base64-encoded data to
   *     encrypt.
   * @param {function(string):void} callback A callback function that receives
   *     base64-encoded encrypted     data to send to a trusted device.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-verifyAndEncryptData
   */
  verifyAndEncryptData: assertNotReached,

  /**
   * Enables TDLS for WiFi traffic with a specified peer if available.
   * @param {string} ip_or_mac_address The IP or MAC address of the peer with
   *     which to     enable a TDLS connection. |enabled| If true, enable TDLS,
   *     otherwise disable TDLS.
   * @param {boolean} enabled
   * @param {function(string):void=} callback A callback function that receives
   *     a string with an error or     the current TDLS status. 'Failed'
   *     indicates that the request failed     (e.g. MAC address lookup failed).
   *     'Timeout' indicates that the lookup     timed out. Otherwise a valid
   *     status is returned (see     $(ref:getWifiTDLSStatus)).
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-setWifiTDLSEnabledState
   */
  setWifiTDLSEnabledState: assertNotReached,

  /**
   * Returns the current TDLS status for the specified peer.
   * @param {string} ip_or_mac_address The IP or MAC address of the peer.
   * @param {function(string):void} callback A callback function that receives a
   *     string with the current     TDLS status which can be 'Connected',
   *     'Disabled', 'Disconnected',     'Nonexistent', or 'Unknown'.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-getWifiTDLSStatus
   */
  getWifiTDLSStatus: assertNotReached,

  /**
   * Returns captive portal status for the network matching 'networkGuid'.
   * @param {string} networkGuid The GUID of the network to get captive portal
   *     status for.
   * @param {function(!chrome.networkingPrivate.CaptivePortalStatus):void}
   *     callback A callback function that returns the results of the query for
   *     network captive portal status.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-getCaptivePortalStatus
   */
  getCaptivePortalStatus: assertNotReached,

  /**
   * Unlocks a Cellular SIM card. * If the SIM is PIN locked, |pin| will be used
   * to unlock the SIM and   the |puk| argument will be ignored if provided. *
   * If the SIM is PUK locked, |puk| and |pin| must be provided. If the
   * operation succeeds (|puk| is valid), the PIN will be set to |pin|.   (If
   * |pin| is empty or invalid the operation will fail).
   * @param {string} networkGuid The GUID of the cellular network to unlock.
   * @param {string} pin The current SIM PIN, or the new PIN if PUK is provided.
   * @param {string=} puk The operator provided PUK for unblocking a blocked
   *     SIM.
   * @param {function():void=} callback Called when the operation has completed.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-unlockCellularSim
   */
  unlockCellularSim: assertNotReached,

  /**
   * Sets whether or not SIM locking is enabled (i.e a PIN will be required when
   * the device is powered) and changes the PIN if a new PIN is specified. If
   * the new PIN is provided but not valid (e.g. too short) the operation will
   * fail. This will not lock the SIM; that is handled automatically by the
   * device. NOTE: If the SIM is locked, it must first be unlocked with
   * unlockCellularSim() before this can be called (otherwise it will fail and
   * chrome.runtime.lastError will be set to Error.SimLocked).
   * @param {string} networkGuid The GUID of the cellular network to set the SIM
   *     state of.
   * @param {!chrome.networkingPrivate.CellularSimState} simState The SIM state
   *     to set.
   * @param {function():void=} callback Called when the operation has completed.
   * @see https://developer.chrome.com/extensions/networkingPrivate#method-setCellularSimState
   */
  setCellularSimState: assertNotReached,

  /**
   * Fired when the properties change on any of the networks.  Sends a list of
   * GUIDs for networks whose properties have changed.
   * @type {!ChromeEvent}
   * @see https://developer.chrome.com/extensions/networkingPrivate#event-onNetworksChanged
   */
  onNetworksChanged: new ChromeEvent(),

  /**
   * Fired when the list of networks has changed.  Sends a complete list of
   * GUIDs for all the current networks.
   * @type {!ChromeEvent}
   * @see https://developer.chrome.com/extensions/networkingPrivate#event-onNetworkListChanged
   */
  onNetworkListChanged: new ChromeEvent(),

  /**
   * Fired when the list of devices has changed or any device state properties
   * have changed.
   * @type {!ChromeEvent}
   * @see https://developer.chrome.com/extensions/networkingPrivate#event-onDeviceStateListChanged
   */
  onDeviceStateListChanged: new ChromeEvent(),

  /**
   * Fired when a portal detection for a network completes. Sends the guid of
   * the network and the corresponding captive portal status.
   * @type {!ChromeEvent}
   * @see https://developer.chrome.com/extensions/networkingPrivate#event-onPortalDetectionCompleted
   */
  onPortalDetectionCompleted: new ChromeEvent(),
};
