/* Generated by wayland-scanner 1.13.0 */

#ifndef STYLUS_TOOLS_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define STYLUS_TOOLS_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_stylus_tools_unstable_v1 The stylus_tools_unstable_v1 protocol
 * Protocol for the stylus tools
 *
 * @section page_desc_stylus_tools_unstable_v1 Description
 *
 * This protocol specifies a set of interfaces used to control the behavior
 * of stylus tools.
 *
 * Warning! The protocol described in this file is experimental and backward
 * incompatible changes may be made. Backward compatible changes may be added
 * together with the corresponding interface version bump. Backward
 * incompatible changes are done by bumping the version number in the protocol
 * and interface names and resetting the interface version. Once the protocol
 * is to be declared stable, the 'z' prefix and the version number in the
 * protocol and interface names are removed and the interface version number is
 * reset.
 *
 * @section page_ifaces_stylus_tools_unstable_v1 Interfaces
 * - @subpage page_iface_zcr_stylus_tools_v1 - stylus_tools
 * - @subpage page_iface_zcr_stylus_tool_v1 - stylus_tool interface to a wl_surface
 * @section page_copyright_stylus_tools_unstable_v1 Copyright
 * <pre>
 *
 * Copyright 2017 The Chromium Authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct zcr_stylus_tool_v1;
struct zcr_stylus_tools_v1;

/**
 * @page page_iface_zcr_stylus_tools_v1 zcr_stylus_tools_v1
 * @section page_iface_zcr_stylus_tools_v1_desc Description
 *
 * The global interface is used to instantiate an interface extension for a
 * wl_surface object. This extended interface will then allow the client to
 * control the stylus-related behavior for input device event processing
 * related to wl_surface.
 * @section page_iface_zcr_stylus_tools_v1_api API
 * See @ref iface_zcr_stylus_tools_v1.
 */
/**
 * @defgroup iface_zcr_stylus_tools_v1 The zcr_stylus_tools_v1 interface
 *
 * The global interface is used to instantiate an interface extension for a
 * wl_surface object. This extended interface will then allow the client to
 * control the stylus-related behavior for input device event processing
 * related to wl_surface.
 */
extern const struct wl_interface zcr_stylus_tools_v1_interface;
/**
 * @page page_iface_zcr_stylus_tool_v1 zcr_stylus_tool_v1
 * @section page_iface_zcr_stylus_tool_v1_desc Description
 *
 * An additional interface to a wl_surface object, which allows the
 * client to control the behavior of stylus tools.
 *
 * If the wl_surface associated with the stylus_tool object is destroyed,
 * the stylus_tool object becomes inert.
 *
 * If the stylus_tool object is destroyed, the stylus_tool state is removed
 * from the wl_surface. The change will be applied on the next
 * wl_surface.commit.
 * @section page_iface_zcr_stylus_tool_v1_api API
 * See @ref iface_zcr_stylus_tool_v1.
 */
/**
 * @defgroup iface_zcr_stylus_tool_v1 The zcr_stylus_tool_v1 interface
 *
 * An additional interface to a wl_surface object, which allows the
 * client to control the behavior of stylus tools.
 *
 * If the wl_surface associated with the stylus_tool object is destroyed,
 * the stylus_tool object becomes inert.
 *
 * If the stylus_tool object is destroyed, the stylus_tool state is removed
 * from the wl_surface. The change will be applied on the next
 * wl_surface.commit.
 */
extern const struct wl_interface zcr_stylus_tool_v1_interface;

#ifndef ZCR_STYLUS_TOOLS_V1_ERROR_ENUM
#define ZCR_STYLUS_TOOLS_V1_ERROR_ENUM
enum zcr_stylus_tools_v1_error {
	/**
	 * the surface already has a stylus_tool object associated
	 */
	ZCR_STYLUS_TOOLS_V1_ERROR_STYLUS_TOOL_EXISTS = 0,
};
#endif /* ZCR_STYLUS_TOOLS_V1_ERROR_ENUM */

#define ZCR_STYLUS_TOOLS_V1_DESTROY 0
#define ZCR_STYLUS_TOOLS_V1_GET_STYLUS_TOOL 1


/**
 * @ingroup iface_zcr_stylus_tools_v1
 */
#define ZCR_STYLUS_TOOLS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_stylus_tools_v1
 */
#define ZCR_STYLUS_TOOLS_V1_GET_STYLUS_TOOL_SINCE_VERSION 1

/** @ingroup iface_zcr_stylus_tools_v1 */
static inline void
zcr_stylus_tools_v1_set_user_data(struct zcr_stylus_tools_v1 *zcr_stylus_tools_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcr_stylus_tools_v1, user_data);
}

/** @ingroup iface_zcr_stylus_tools_v1 */
static inline void *
zcr_stylus_tools_v1_get_user_data(struct zcr_stylus_tools_v1 *zcr_stylus_tools_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcr_stylus_tools_v1);
}

static inline uint32_t
zcr_stylus_tools_v1_get_version(struct zcr_stylus_tools_v1 *zcr_stylus_tools_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zcr_stylus_tools_v1);
}

/**
 * @ingroup iface_zcr_stylus_tools_v1
 *
 * Informs the server that the client will not be using this
 * protocol object anymore. This does not affect any other objects,
 * stylus_tool objects included.
 */
static inline void
zcr_stylus_tools_v1_destroy(struct zcr_stylus_tools_v1 *zcr_stylus_tools_v1)
{
	wl_proxy_marshal((struct wl_proxy *) zcr_stylus_tools_v1,
			 ZCR_STYLUS_TOOLS_V1_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) zcr_stylus_tools_v1);
}

/**
 * @ingroup iface_zcr_stylus_tools_v1
 *
 * Instantiate an interface extension for the given wl_surface to
 * provide access to the stylus tools features. If the given
 * wl_surface already has an stylus_tool object associated,
 * the stylus_tool_exists protocol protocol error is raised.
 */
static inline struct zcr_stylus_tool_v1 *
zcr_stylus_tools_v1_get_stylus_tool(struct zcr_stylus_tools_v1 *zcr_stylus_tools_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_constructor((struct wl_proxy *) zcr_stylus_tools_v1,
			 ZCR_STYLUS_TOOLS_V1_GET_STYLUS_TOOL, &zcr_stylus_tool_v1_interface, NULL, surface);

	return (struct zcr_stylus_tool_v1 *) id;
}

#define ZCR_STYLUS_TOOL_V1_DESTROY 0
#define ZCR_STYLUS_TOOL_V1_SET_STYLUS_ONLY 1


/**
 * @ingroup iface_zcr_stylus_tool_v1
 */
#define ZCR_STYLUS_TOOL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_stylus_tool_v1
 */
#define ZCR_STYLUS_TOOL_V1_SET_STYLUS_ONLY_SINCE_VERSION 1

/** @ingroup iface_zcr_stylus_tool_v1 */
static inline void
zcr_stylus_tool_v1_set_user_data(struct zcr_stylus_tool_v1 *zcr_stylus_tool_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcr_stylus_tool_v1, user_data);
}

/** @ingroup iface_zcr_stylus_tool_v1 */
static inline void *
zcr_stylus_tool_v1_get_user_data(struct zcr_stylus_tool_v1 *zcr_stylus_tool_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcr_stylus_tool_v1);
}

static inline uint32_t
zcr_stylus_tool_v1_get_version(struct zcr_stylus_tool_v1 *zcr_stylus_tool_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zcr_stylus_tool_v1);
}

/**
 * @ingroup iface_zcr_stylus_tool_v1
 *
 * The associated wl_surface's stylus_tool state is removed.
 * The change is applied on the next wl_surface.commit.
 */
static inline void
zcr_stylus_tool_v1_destroy(struct zcr_stylus_tool_v1 *zcr_stylus_tool_v1)
{
	wl_proxy_marshal((struct wl_proxy *) zcr_stylus_tool_v1,
			 ZCR_STYLUS_TOOL_V1_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) zcr_stylus_tool_v1);
}

/**
 * @ingroup iface_zcr_stylus_tool_v1
 *
 * Enables the "stylus-only" mode for input device event processing
 * related to wl_surface.
 */
static inline void
zcr_stylus_tool_v1_set_stylus_only(struct zcr_stylus_tool_v1 *zcr_stylus_tool_v1)
{
	wl_proxy_marshal((struct wl_proxy *) zcr_stylus_tool_v1,
			 ZCR_STYLUS_TOOL_V1_SET_STYLUS_ONLY);
}

#ifdef  __cplusplus
}
#endif

#endif
