/*
 * Copyright (C) 2014-2016 Stichting Mapcode Foundation (http://www.mapcode.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __MAPCODE_TERRITORIES_H__
#define __MAPCODE_TERRITORIES_H__

#ifdef __cplusplus
extern "C" {
#endif

// *** GENERATED FILE (coords.cpp data2.3.0), DO NOT CHANGE OR PRETTIFY ***

enum Territory {
    TERRITORY_NONE = -1,
    TERRITORY_UNKNOWN = 0,
    _TERRITORY_MIN = 1000, // Valid territories are from _TERRITORY_MIN + 1 to _TERRITORY_MAX - 1.
    TERRITORY_VAT,
    TERRITORY_MCO,
    TERRITORY_GIB,
    TERRITORY_TKL,
    TERRITORY_CCK,
    TERRITORY_BLM,
    TERRITORY_NRU,
    TERRITORY_TUV,
    TERRITORY_MAC,
    TERRITORY_SXM,
    TERRITORY_MAF,
    TERRITORY_NFK,
    TERRITORY_PCN,
    TERRITORY_BVT,
    TERRITORY_BMU,
    TERRITORY_IOT,
    TERRITORY_SMR,
    TERRITORY_GGY,
    TERRITORY_AIA,
    TERRITORY_MSR,
    TERRITORY_JEY,
    TERRITORY_CXR,
    TERRITORY_WLF,
    TERRITORY_VGB,
    TERRITORY_LIE,
    TERRITORY_ABW,
    TERRITORY_MHL,
    TERRITORY_ASM,
    TERRITORY_COK,
    TERRITORY_SPM,
    TERRITORY_NIU,
    TERRITORY_KNA,
    TERRITORY_CYM,
    TERRITORY_BES,
    TERRITORY_MDV,
    TERRITORY_SHN,
    TERRITORY_MLT,
    TERRITORY_GRD,
    TERRITORY_VIR,
    TERRITORY_MYT,
    TERRITORY_SJM,
    TERRITORY_VCT,
    TERRITORY_HMD,
    TERRITORY_BRB,
    TERRITORY_ATG,
    TERRITORY_CUW,
    TERRITORY_SYC,
    TERRITORY_PLW,
    TERRITORY_MNP,
    TERRITORY_AND,
    TERRITORY_GUM,
    TERRITORY_IMN,
    TERRITORY_LCA,
    TERRITORY_FSM,
    TERRITORY_SGP,
    TERRITORY_TON,
    TERRITORY_DMA,
    TERRITORY_BHR,
    TERRITORY_KIR,
    TERRITORY_TCA,
    TERRITORY_STP,
    TERRITORY_HKG,
    TERRITORY_MTQ,
    TERRITORY_FRO,
    TERRITORY_GLP,
    TERRITORY_COM,
    TERRITORY_MUS,
    TERRITORY_REU,
    TERRITORY_LUX,
    TERRITORY_WSM,
    TERRITORY_SGS,
    TERRITORY_PYF,
    TERRITORY_CPV,
    TERRITORY_TTO,
    TERRITORY_BRN,
    TERRITORY_ATF,
    TERRITORY_PRI,
    TERRITORY_CYP,
    TERRITORY_LBN,
    TERRITORY_JAM,
    TERRITORY_GMB,
    TERRITORY_QAT,
    TERRITORY_FLK,
    TERRITORY_VUT,
    TERRITORY_MNE,
    TERRITORY_BHS,
    TERRITORY_TLS,
    TERRITORY_SWZ,
    TERRITORY_KWT,
    TERRITORY_FJI,
    TERRITORY_NCL,
    TERRITORY_SVN,
    TERRITORY_ISR,
    TERRITORY_PSE,
    TERRITORY_SLV,
    TERRITORY_BLZ,
    TERRITORY_DJI,
    TERRITORY_MKD,
    TERRITORY_RWA,
    TERRITORY_HTI,
    TERRITORY_BDI,
    TERRITORY_GNQ,
    TERRITORY_ALB,
    TERRITORY_SLB,
    TERRITORY_ARM,
    TERRITORY_LSO,
    TERRITORY_BEL,
    TERRITORY_MDA,
    TERRITORY_GNB,
    TERRITORY_TWN,
    TERRITORY_BTN,
    TERRITORY_CHE,
    TERRITORY_NLD,
    TERRITORY_DNK,
    TERRITORY_EST,
    TERRITORY_DOM,
    TERRITORY_SVK,
    TERRITORY_CRI,
    TERRITORY_BIH,
    TERRITORY_HRV,
    TERRITORY_TGO,
    TERRITORY_LVA,
    TERRITORY_LTU,
    TERRITORY_LKA,
    TERRITORY_GEO,
    TERRITORY_IRL,
    TERRITORY_SLE,
    TERRITORY_PAN,
    TERRITORY_CZE,
    TERRITORY_GUF,
    TERRITORY_ARE,
    TERRITORY_AUT,
    TERRITORY_AZE,
    TERRITORY_SRB,
    TERRITORY_JOR,
    TERRITORY_PRT,
    TERRITORY_HUN,
    TERRITORY_KOR,
    TERRITORY_ISL,
    TERRITORY_GTM,
    TERRITORY_CUB,
    TERRITORY_BGR,
    TERRITORY_LBR,
    TERRITORY_HND,
    TERRITORY_BEN,
    TERRITORY_ERI,
    TERRITORY_MWI,
    TERRITORY_PRK,
    TERRITORY_NIC,
    TERRITORY_GRC,
    TERRITORY_TJK,
    TERRITORY_BGD,
    TERRITORY_NPL,
    TERRITORY_TUN,
    TERRITORY_SUR,
    TERRITORY_URY,
    TERRITORY_KHM,
    TERRITORY_SYR,
    TERRITORY_SEN,
    TERRITORY_KGZ,
    TERRITORY_BLR,
    TERRITORY_GUY,
    TERRITORY_LAO,
    TERRITORY_ROU,
    TERRITORY_GHA,
    TERRITORY_UGA,
    TERRITORY_GBR,
    TERRITORY_GIN,
    TERRITORY_ECU,
    TERRITORY_ESH,
    TERRITORY_GAB,
    TERRITORY_NZL,
    TERRITORY_BFA,
    TERRITORY_PHL,
    TERRITORY_ITA,
    TERRITORY_OMN,
    TERRITORY_POL,
    TERRITORY_CIV,
    TERRITORY_NOR,
    TERRITORY_MYS,
    TERRITORY_VNM,
    TERRITORY_FIN,
    TERRITORY_COG,
    TERRITORY_DEU,
    TERRITORY_JPN,
    TERRITORY_ZWE,
    TERRITORY_PRY,
    TERRITORY_IRQ,
    TERRITORY_MAR,
    TERRITORY_UZB,
    TERRITORY_SWE,
    TERRITORY_PNG,
    TERRITORY_CMR,
    TERRITORY_TKM,
    TERRITORY_ESP,
    TERRITORY_THA,
    TERRITORY_YEM,
    TERRITORY_FRA,
    TERRITORY_ALA,
    TERRITORY_KEN,
    TERRITORY_BWA,
    TERRITORY_MDG,
    TERRITORY_UKR,
    TERRITORY_SSD,
    TERRITORY_CAF,
    TERRITORY_SOM,
    TERRITORY_AFG,
    TERRITORY_MMR,
    TERRITORY_ZMB,
    TERRITORY_CHL,
    TERRITORY_TUR,
    TERRITORY_PAK,
    TERRITORY_MOZ,
    TERRITORY_NAM,
    TERRITORY_VEN,
    TERRITORY_NGA,
    TERRITORY_TZA,
    TERRITORY_EGY,
    TERRITORY_MRT,
    TERRITORY_BOL,
    TERRITORY_ETH,
    TERRITORY_COL,
    TERRITORY_ZAF,
    TERRITORY_MLI,
    TERRITORY_AGO,
    TERRITORY_NER,
    TERRITORY_TCD,
    TERRITORY_PER,
    TERRITORY_MNG,
    TERRITORY_IRN,
    TERRITORY_LBY,
    TERRITORY_SDN,
    TERRITORY_IDN,
    TERRITORY_MX_DIF,
    TERRITORY_MX_TLA,
    TERRITORY_MX_MOR,
    TERRITORY_MX_AGU,
    TERRITORY_MX_CL,
    TERRITORY_MX_QUE,
    TERRITORY_MX_HID,
    TERRITORY_MX_MX,
    TERRITORY_MX_TAB,
    TERRITORY_MX_NAY,
    TERRITORY_MX_GUA,
    TERRITORY_MX_PUE,
    TERRITORY_MX_YUC,
    TERRITORY_MX_ROO,
    TERRITORY_MX_SIN,
    TERRITORY_MX_CAM,
    TERRITORY_MX_MIC,
    TERRITORY_MX_SLP,
    TERRITORY_MX_GRO,
    TERRITORY_MX_NLE,
    TERRITORY_MX_BCN,
    TERRITORY_MX_VER,
    TERRITORY_MX_CHP,
    TERRITORY_MX_BCS,
    TERRITORY_MX_ZAC,
    TERRITORY_MX_JAL,
    TERRITORY_MX_TAM,
    TERRITORY_MX_OAX,
    TERRITORY_MX_DUR,
    TERRITORY_MX_COA,
    TERRITORY_MX_SON,
    TERRITORY_MX_CHH,
    TERRITORY_GRL,
    TERRITORY_SAU,
    TERRITORY_COD,
    TERRITORY_DZA,
    TERRITORY_KAZ,
    TERRITORY_ARG,
    TERRITORY_IN_DD,
    TERRITORY_IN_DN,
    TERRITORY_IN_CH,
    TERRITORY_IN_AN,
    TERRITORY_IN_LD,
    TERRITORY_IN_DL,
    TERRITORY_IN_ML,
    TERRITORY_IN_NL,
    TERRITORY_IN_MN,
    TERRITORY_IN_TR,
    TERRITORY_IN_MZ,
    TERRITORY_IN_SK,
    TERRITORY_IN_PB,
    TERRITORY_IN_HR,
    TERRITORY_IN_AR,
    TERRITORY_IN_AS,
    TERRITORY_IN_BR,
    TERRITORY_IN_UT,
    TERRITORY_IN_GA,
    TERRITORY_IN_KL,
    TERRITORY_IN_TN,
    TERRITORY_IN_HP,
    TERRITORY_IN_JK,
    TERRITORY_IN_CT,
    TERRITORY_IN_JH,
    TERRITORY_IN_KA,
    TERRITORY_IN_RJ,
    TERRITORY_IN_OR,
    TERRITORY_IN_GJ,
    TERRITORY_IN_WB,
    TERRITORY_IN_MP,
    TERRITORY_IN_TG,
    TERRITORY_IN_AP,
    TERRITORY_IN_MH,
    TERRITORY_IN_UP,
    TERRITORY_IN_PY,
    TERRITORY_AU_NSW,
    TERRITORY_AU_ACT,
    TERRITORY_AU_JBT,
    TERRITORY_AU_NT,
    TERRITORY_AU_SA,
    TERRITORY_AU_TAS,
    TERRITORY_AU_VIC,
    TERRITORY_AU_WA,
    TERRITORY_AU_QLD,
    TERRITORY_BR_DF,
    TERRITORY_BR_SE,
    TERRITORY_BR_AL,
    TERRITORY_BR_RJ,
    TERRITORY_BR_ES,
    TERRITORY_BR_RN,
    TERRITORY_BR_PB,
    TERRITORY_BR_SC,
    TERRITORY_BR_PE,
    TERRITORY_BR_AP,
    TERRITORY_BR_CE,
    TERRITORY_BR_AC,
    TERRITORY_BR_PR,
    TERRITORY_BR_RR,
    TERRITORY_BR_RO,
    TERRITORY_BR_SP,
    TERRITORY_BR_PI,
    TERRITORY_BR_TO,
    TERRITORY_BR_RS,
    TERRITORY_BR_MA,
    TERRITORY_BR_GO,
    TERRITORY_BR_MS,
    TERRITORY_BR_BA,
    TERRITORY_BR_MG,
    TERRITORY_BR_MT,
    TERRITORY_BR_PA,
    TERRITORY_BR_AM,
    TERRITORY_US_DC,
    TERRITORY_US_RI,
    TERRITORY_US_DE,
    TERRITORY_US_CT,
    TERRITORY_US_NJ,
    TERRITORY_US_NH,
    TERRITORY_US_VT,
    TERRITORY_US_MA,
    TERRITORY_US_HI,
    TERRITORY_US_MD,
    TERRITORY_US_WV,
    TERRITORY_US_SC,
    TERRITORY_US_ME,
    TERRITORY_US_IN,
    TERRITORY_US_KY,
    TERRITORY_US_TN,
    TERRITORY_US_VA,
    TERRITORY_US_OH,
    TERRITORY_US_PA,
    TERRITORY_US_MS,
    TERRITORY_US_LA,
    TERRITORY_US_AL,
    TERRITORY_US_AR,
    TERRITORY_US_NC,
    TERRITORY_US_NY,
    TERRITORY_US_IA,
    TERRITORY_US_IL,
    TERRITORY_US_GA,
    TERRITORY_US_WI,
    TERRITORY_US_FL,
    TERRITORY_US_MO,
    TERRITORY_US_OK,
    TERRITORY_US_ND,
    TERRITORY_US_WA,
    TERRITORY_US_SD,
    TERRITORY_US_NE,
    TERRITORY_US_KS,
    TERRITORY_US_ID,
    TERRITORY_US_UT,
    TERRITORY_US_MN,
    TERRITORY_US_MI,
    TERRITORY_US_WY,
    TERRITORY_US_OR,
    TERRITORY_US_CO,
    TERRITORY_US_NV,
    TERRITORY_US_AZ,
    TERRITORY_US_NM,
    TERRITORY_US_MT,
    TERRITORY_US_CA,
    TERRITORY_US_TX,
    TERRITORY_US_AK,
    TERRITORY_CA_BC,
    TERRITORY_CA_AB,
    TERRITORY_CA_ON,
    TERRITORY_CA_QC,
    TERRITORY_CA_SK,
    TERRITORY_CA_MB,
    TERRITORY_CA_NL,
    TERRITORY_CA_NB,
    TERRITORY_CA_NS,
    TERRITORY_CA_PE,
    TERRITORY_CA_YT,
    TERRITORY_CA_NT,
    TERRITORY_CA_NU,
    TERRITORY_IND,
    TERRITORY_AUS,
    TERRITORY_BRA,
    TERRITORY_USA,
    TERRITORY_MEX,
    TERRITORY_RU_MOW,
    TERRITORY_RU_SPE,
    TERRITORY_RU_KGD,
    TERRITORY_RU_IN,
    TERRITORY_RU_AD,
    TERRITORY_RU_SE,
    TERRITORY_RU_KB,
    TERRITORY_RU_KC,
    TERRITORY_RU_CE,
    TERRITORY_RU_CU,
    TERRITORY_RU_IVA,
    TERRITORY_RU_LIP,
    TERRITORY_RU_ORL,
    TERRITORY_RU_TUL,
    TERRITORY_RU_BE,
    TERRITORY_RU_VLA,
    TERRITORY_RU_KRS,
    TERRITORY_RU_KLU,
    TERRITORY_RU_TT,
    TERRITORY_RU_BRY,
    TERRITORY_RU_YAR,
    TERRITORY_RU_RYA,
    TERRITORY_RU_AST,
    TERRITORY_RU_MOS,
    TERRITORY_RU_SMO,
    TERRITORY_RU_DA,
    TERRITORY_RU_VOR,
    TERRITORY_RU_NGR,
    TERRITORY_RU_PSK,
    TERRITORY_RU_KOS,
    TERRITORY_RU_STA,
    TERRITORY_RU_KDA,
    TERRITORY_RU_KL,
    TERRITORY_RU_TVE,
    TERRITORY_RU_LEN,
    TERRITORY_RU_ROS,
    TERRITORY_RU_VGG,
    TERRITORY_RU_VLG,
    TERRITORY_RU_MUR,
    TERRITORY_RU_KR,
    TERRITORY_RU_NEN,
    TERRITORY_RU_KO,
    TERRITORY_RU_ARK,
    TERRITORY_RU_MO,
    TERRITORY_RU_NIZ,
    TERRITORY_RU_PNZ,
    TERRITORY_RU_KI,
    TERRITORY_RU_ME,
    TERRITORY_RU_ORE,
    TERRITORY_RU_ULY,
    TERRITORY_RU_PM,
    TERRITORY_RU_BA,
    TERRITORY_RU_UD,
    TERRITORY_RU_TA,
    TERRITORY_RU_SAM,
    TERRITORY_RU_SAR,
    TERRITORY_RU_YAN,
    TERRITORY_RU_KM,
    TERRITORY_RU_SVE,
    TERRITORY_RU_TYU,
    TERRITORY_RU_KGN,
    TERRITORY_RU_CH,
    TERRITORY_RU_BU,
    TERRITORY_RU_ZAB,
    TERRITORY_RU_IRK,
    TERRITORY_RU_NVS,
    TERRITORY_RU_TOM,
    TERRITORY_RU_OMS,
    TERRITORY_RU_KK,
    TERRITORY_RU_KEM,
    TERRITORY_RU_AL,
    TERRITORY_RU_ALT,
    TERRITORY_RU_TY,
    TERRITORY_RU_KYA,
    TERRITORY_RU_MAG,
    TERRITORY_RU_CHU,
    TERRITORY_RU_KAM,
    TERRITORY_RU_SAK,
    TERRITORY_RU_PO,
    TERRITORY_RU_YEV,
    TERRITORY_RU_KHA,
    TERRITORY_RU_AMU,
    TERRITORY_RU_SA,
    TERRITORY_CAN,
    TERRITORY_RUS,
    TERRITORY_CN_SH,
    TERRITORY_CN_TJ,
    TERRITORY_CN_BJ,
    TERRITORY_CN_HI,
    TERRITORY_CN_NX,
    TERRITORY_CN_CQ,
    TERRITORY_CN_ZJ,
    TERRITORY_CN_JS,
    TERRITORY_CN_FJ,
    TERRITORY_CN_AH,
    TERRITORY_CN_LN,
    TERRITORY_CN_SD,
    TERRITORY_CN_SX,
    TERRITORY_CN_JX,
    TERRITORY_CN_HA,
    TERRITORY_CN_GZ,
    TERRITORY_CN_GD,
    TERRITORY_CN_HB,
    TERRITORY_CN_JL,
    TERRITORY_CN_HE,
    TERRITORY_CN_SN,
    TERRITORY_CN_NM,
    TERRITORY_CN_HL,
    TERRITORY_CN_HN,
    TERRITORY_CN_GX,
    TERRITORY_CN_SC,
    TERRITORY_CN_YN,
    TERRITORY_CN_XZ,
    TERRITORY_CN_GS,
    TERRITORY_CN_QH,
    TERRITORY_CN_XJ,
    TERRITORY_CHN,
    TERRITORY_UMI,
    TERRITORY_CPT,
    TERRITORY_ATA,
    TERRITORY_AAA,
    _TERRITORY_MAX
};

#define INDEX_OF_TERRITORY(c) (((int) c) - _TERRITORY_MIN - 1)
#define TERRITORY_OF_INDEX(x) ((x < 0) ? TERRITORY_NONE : (enum Territory) (_TERRITORY_MIN + x + 1))

#ifdef __cplusplus
}
#endif

#endif // __MAPCODE_TERRITORIES_H__

