# Compiler configuration
IF(WIN32)
    IF(MSVC)
        SET(HTTRAQT_COMPILER_MSVC TRUE)
    ELSE(MSVC)
        SET(HTTRAQT_COMPILER_GCC TRUE)
    ENDIF(MSVC)
ELSE(WIN32)
    SET(HTTRAQT_COMPILER_GCC TRUE)
ENDIF(WIN32)

# Win32 API configuration
IF(WIN32)
    SET(HTTRAQT_API_WIN32 TRUE)
ENDIF(WIN32)

# Darwin API configuration
IF(APPLE)
    SET(HTTRAQT_API_DARWIN TRUE)

  EXECUTE_PROCESS(
    COMMAND sw_vers -productVersion
    OUTPUT_VARIABLE HTTRAQT_OSX_VERSION
    )
  STRING(REGEX REPLACE "([0-9]*)[.]([0-9]*)[.]([0-9]*).*" "\\1" HTTRAQT_OSX_MAJOR_VERSION "${HTTRAQT_OSX_VERSION}")
  STRING(REGEX REPLACE "([0-9]*)[.]([0-9]*)[.]([0-9]*).*" "\\2" HTTRAQT_OSX_MINOR_VERSION "${HTTRAQT_OSX_VERSION}")

ENDIF(APPLE)

