#!/bin/bash

usage(){
echo "
Written by Brian Bushnell
Last modified June 12, 2019

Description:  Counts the rate of triangle reads in a file
generated by IceCreamMaker with custom headers.

Usage:  icecreamgrader.sh in=<input file>

Standard parameters:
in=<file>       Reads to grade.

Please contact Brian Bushnell at bbushnell@lbl.gov if you encounter any problems.
"
}

#This block allows symlinked shellscripts to correctly set classpath.
pushd . > /dev/null
DIR="${BASH_SOURCE[0]}"
while [ -h "$DIR" ]; do
  cd "$(dirname "$DIR")"
  DIR="$(readlink "$(basename "$DIR")")"
done
cd "$(dirname "$DIR")"
DIR="$(pwd)/"
popd > /dev/null

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )/"
CP="$DIR""current/"

z="-Xmx200m"
z2="-Xms200m"
set=0

if [ -z "$1" ] || [[ $1 == -h ]] || [[ $1 == --help ]]; then
	usage
	exit
fi

calcXmx () {
	source "$DIR""/calcmem.sh"
	setEnvironment
	parseXmx "$@"
}
calcXmx "$@"

icecreamgrader() {
	local CMD="java $EA $EOOM $z -cp $CP pacbio.IceCreamGrader $@"
	echo $CMD >&2
	eval $CMD
}

icecreamgrader "$@"
