# $Id: tc_schema.rb,v 1.1 2005/03/02 04:40:10 ianmacd Exp $
#
# A suite of unit tests for testing Ruby/LDAP schema functionality.

require 'ldap'
require 'ldap/schema'
require 'test/unit'

class TC_SchemaTest < Test::Unit::TestCase

  def setup
    unless @host
      File.open( '/etc/ldap.conf' ) do |f|
        while line = f.gets
          if line =~ /^host\s+(.+)$/
            @host = $1
            break
	  elsif line =~ /^base\s+(.+)$/
	    @base = $1
	    break
          end
        end
      end

      @conn = LDAP::Conn.new( @host ).bind
    end
  end

  def test_schema
    schema = @conn.schema
    assert_instance_of( LDAP::Schema, schema )
    assert( schema.key?( 'attributetypes' ) )
    assert( schema.key?( 'ldapsyntaxes' ) )
    assert( schema.key?( 'matchingrules' ) )
    assert( schema.key?( 'matchingruleuse' ) )
    assert( schema.key?( 'objectclasses' ) )
  end

  def test_root_dse
    root_dse = @conn.root_dse[0]
    assert( root_dse.key?( 'subschemaSubentry' ) )
    assert( root_dse.key?( 'namingContexts' ) )
    assert( root_dse.key?( 'supportedSASLMechanisms' ) )
    assert( root_dse.key?( 'supportedControl' ) )
    assert( root_dse.key?( 'supportedExtension' ) )
    assert( root_dse.key?( 'supportedLDAPVersion' ) )
  end
    
end
