/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/src/ypost/ypost.h,v 1.2 2002/03/21 04:58:31 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#ifndef _YPOST_H
#define _YPOST_H

#include "y.h"

#if HAVE_PWD_H
#	include <pwd.h>
#endif
#if HAVE_SIGNAL_H
#	include <signal.h>
#endif
#if HAVE_SYS_SOCKET_H
#	include <sys/socket.h>
#endif
#if HAVE_NETINET_IN_H
#	include <netinet/in.h>
#endif
#if HAVE_ARPA_INET_H
#	include <arpa/inet.h>
#endif
#if HAVE_NETDB_H
#	include <netdb.h>
#endif
#if HAVE_SYS_UTSNAME_H
#	include <sys/utsname.h>
#endif

#include "meter.h"
#include "nntp.h"
#include "prompt.h"
#include "sock.h"
#include "usenet.h"

#define	DEFAULT_MULTIPART_LINES	5000
#define	DEFAULT_RETRY_LIMIT		3

/* Evaluate string for boolean options:  "[Yy](es)", "[Tt](rue)", "1", and "(o)[Nn]" evaluate to 1 */
#define  getbool(s)   \
	(s && (s[0] == 'Y' || s[0] == 'y' || s[0] == 'T' || s[0] == 't' || \
	s[0] == '1' || s[1] == 'n' || s[1] == 'N'))

extern int		opt_verbose;					/* Should the program be verbose in its operation? */
extern int		opt_debug;						/* Debug output? */

extern char		*opt_author;					/* Author name for posting */
extern int		opt_prompt_author;			/* Prompt for author? */
extern char		*opt_auth_user;				/* Username for authentication */
extern char		*opt_auth_pass;				/* Password for authentication */
extern int		opt_prompt_pass;				/* Prompt for password? */
extern char		*opt_nntp_server;				/* nntp server to use */
extern char		*opt_subject;					/* Subject prefix */
extern int		opt_prompt_subject;			/* Prompt for subject? */
extern char		*opt_comment;					/* Subject suffix */
extern int		opt_prompt_comment;			/* Prompt for comment? */
extern int		opt_timeout;					/* Timeout for socket ops */
extern char		*opt_newsgroup;				/* Newsgroup to post to */
extern int		opt_force;						/* Post messages without confirming? */
extern int		opt_nosort;						/* Do not sort input files */
extern int		opt_multipart_lines;			/* Lines per multipart message */

extern char		*opt_sender;					/* For header generation, not set directly */

extern int		opt_line_length;				/* Line length for posting */
extern int		opt_keep_paths;				/* Keep relative path names? */
extern int		opt_overwrite;					/* (not actually used by this program..) */
extern int		opt_message_id;				/* Generate Message-ID: header when posting? */
extern int		opt_stdout;						/* Send output to stdout instead of posting? */

extern YENCFILE	**input_files;				/* List of files to process */
extern int			num_input_files;			/* Number of items in files */

extern int		opt_sfv;							/* Create .SFV file? */
extern char		*opt_sfv_filename;			/* SFV filename */
extern int		opt_crc;							/* Create .CRC file? */
extern char		*opt_crc_filename;			/* CRC filename */

extern char		*opt_sort_first;				/* Sort these extensions first, comma separated list */

extern int		opt_resume_msg;				/* Message number at which to restart */
extern crc32_t	opt_resume_crc;				/* CRC value for posts, to ensure they are the same */

extern size_t	total_input_bytes;			/* Total number of input bytes overall */

extern int		part_current,					/* Current part number of this part */
					part_total;						/* Total number of parts for this part */
extern int		file_current,					/* Current file number overall */
					file_total;						/* Total number of files being posted */
extern int		total_messages,				/* Total number of messages to post */
					total_posted;					/* Total number of messages posted so far */

#endif /* !_YPOST_H */

/* vi:set ts=3: */
