datatype expression =
	  Function of function
	| Apply of (expression*expression)

and function =
	  I
	| Dot of char
	| K1 of function
	| K
	| S2 of (function*function)
	| S1 of function
	| S
	| V
	| D1 of expression
	| D
	| Cont of (function SMLofNJ.Cont.cont)
	| C
	| E
	| At
	| Ques of char
	| Pipe
;;

val current_ch = ref (NONE : char option);;

val rec apply = fn
	  I => (fn t => t)
	| Dot ch => (fn t => (TextIO.output1 (TextIO.stdOut, ch); t))
	| K1 v => (fn t => v)
	| K => (fn t => (K1 t))
	| S2 (x,y) => (fn z => eval (Apply (Apply (Function x,Function z),
					    Apply (Function y,Function z))))
	| S1 x => (fn y => (S2 (x,y)))
	| S => (fn x => (S1 x))
	| V => (fn t => V)
	| D1 e => (fn t => eval (Apply (e, Function t)))
(*	| D => raise your_expectations *)
	| Cont cnt => (fn t => SMLofNJ.Cont.throw cnt t)
	| C => (fn t => SMLofNJ.Cont.callcc (fn cnt =>
			 eval (Apply (Function t, Function (Cont cnt)))))
	| E => (fn t => OS.Process.exit OS.Process.success)
	| At => (fn t => (current_ch := TextIO.input1 TextIO.stdIn;
				eval (Apply (Function t, Function ((fn
			    NONE => V
			  | SOME _ => I) (!current_ch))))))
	| Ques ch => (fn t => (eval (Apply (Function t, Function ((fn
			    NONE => V
			  | SOME ch2 => if ch=ch2 then I else V) (!current_ch))))))
	| Pipe => (fn t => (eval (Apply (Function t, Function ((fn
			    NONE => V
			  | SOME ch => Dot ch) (!current_ch))))))
and eval = fn
	  Function f => f
	| Apply (rator, rand) => (fn D =>
		  D1 rand
		| erator => apply erator (eval rand))
	    (eval rator)
;;

exception ParseError
;;

val rec parse = fn input =>
	( fn NONE => raise ParseError
	   | SOME #"#" => let fun gobble () = ((fn
		  NONE => parse input
		| SOME #"\n" => parse input
		| SOME _ => gobble ())
			(TextIO.input1 input))
		in gobble () end
	   | SOME #" " => parse input
	   | SOME #"\n" => parse input
	   | SOME #"\t" => parse input
	   | SOME #"\r" => parse input
	   | SOME #"`" => Apply ((parse input),(parse input))
	   | SOME #"i" => Function I
	   | SOME #"I" => Function I
	   | SOME #"k" => Function K
	   | SOME #"K" => Function K
	   | SOME #"s" => Function S
	   | SOME #"S" => Function S
	   | SOME #"v" => Function V
	   | SOME #"V" => Function V
	   | SOME #"d" => Function D
	   | SOME #"D" => Function D
	   | SOME #"c" => Function C
	   | SOME #"C" => Function C
	   | SOME #"e" => Function E
	   | SOME #"E" => Function E
	   | SOME #"." => Function (Dot
		(( fn NONE => raise ParseError | SOME ch => ch )
		 (TextIO.input1 input)))
	   | SOME #"r" => Function (Dot #"\n")
	   | SOME #"@" => Function At
	   | SOME #"?" => Function (Ques
		(( fn NONE => raise ParseError | SOME ch => ch )
		 (TextIO.input1 input)))
	   | SOME #"|" => Function Pipe
	   | _ => raise ParseError
	) (TextIO.input1 input)
;;

exception UsageError
;;

(fn [] => eval (parse (TextIO.stdIn))
  | [filename] => eval (parse (TextIO.openIn filename))
  | _ => raise UsageError)
(CommandLine.arguments ());
OS.Process.exit OS.Process.success
;;
