//exprlp.cpp, Copyright (c) 2002, 2003, 2004, 2005 R.Lackner
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <locale.h>
#include <unistd.h>			//required for unlink()
#include "Version.h"
#include "rlplot.h"

int file_fmt = FF_UNKNOWN;
bool bQuiet = false, bSVGtype = false, bDelete = false;
char *szFile1 = 0L, *szFile2 = 0L;
int dlgtxtheight = 12;				//stub: not used

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// direct messages to console
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void InfoBox(char *Msg)
{
	if(!bQuiet) fprintf(stderr, "exprlp INFO: %s\n", Msg);
}

void ErrorBox(char *Msg)
{
	if(!bQuiet) fprintf(stderr, "exprlp ERROR: %s\n", Msg);
}

bool YesNoBox(char *Msg)
{
return false;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// STUBS: we do not need dialogs
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bool ShowLayers(GraphObj *root)
{
	return false;
}

bool GetBitmapRes(double *res, double *width, double *height, char *header)
{
	return false;
}

bool GetPaper(double *w, double *h)
{
	*w = *h = 1.0;
	return true;
}
 
bool Symbol::PropertyDlg()
{
	return false;
}

bool Bubble::PropertyDlg()
{
	return false;
}

bool Bar::PropertyDlg()
{
	return false;
}

bool DataLine::PropertyDlg()
{
	return false;
}

bool DataPolygon::PropertyDlg()
{
	return false;
}

bool RegLine::PropertyDlg()
{
	return false;
}

bool SDellipse::PropertyDlg()
{
	return false;
}

bool ErrorBar::PropertyDlg()
{
	return false;
}

bool Arrow::PropertyDlg()
{
	return false;
}

bool Box::PropertyDlg()
{
	return false;
}

bool Whisker::PropertyDlg()
{
	return false;
}

bool DropLine::PropertyDlg()
{
	return false;
}

bool Sphere::PropertyDlg()
{
	return false;
}

bool Plane3D::PropertyDlg()
{
	return false;
}

bool Brick::PropertyDlg()
{
	return false;
}

bool DropLine3D::PropertyDlg()
{
	return false;
}

bool Arrow3D::PropertyDlg()
{
	return false;
}

bool Line3D::PropertyDlg()
{
	return false;
}

bool Label::PropertyDlg()
{
	return false;
}

bool segment::PropertyDlg()
{
	return false;
}

bool polyline::PropertyDlg()
{
	return false;
}

bool polygon::PropertyDlg()
{
	return false;
}

bool rectangle::PropertyDlg()
{
	return false;
}

bool PlotScatt::PropertyDlg()
{
	return false;
}

bool Regression::PropertyDlg()
{
	return false;
}

bool FreqDist::PropertyDlg()
{
	return false;
}

bool BubblePlot::PropertyDlg()
{
	return false;
}

bool PolarPlot::PropertyDlg()
{
	return false;
}

bool PolarPlot::Config()
{
	return false;
}

bool BoxPlot::PropertyDlg()
{
	return false;
}

bool DensDisp::PropertyDlg()
{
	return false;
}

bool StackBar::PropertyDlg()
{
	return false;
}

bool Waterfall::PropertyDlg()
{
	return false;
}

bool MultiLines::PropertyDlg()
{
	return false;
}

bool PieChart::PropertyDlg()
{
	return false;
}

bool StarChart::PropertyDlg()
{
	return false;
}

bool Function::PropertyDlg()
{
	return false;
}

bool Scatt3D::PropertyDlg()
{
	return false;
}

bool FitFunc::PropertyDlg()
{
	return false;
}

bool Plot3D::PropertyDlg()
{
	return false;
}

bool Plot3D::AddPlot(int)
{
	return false;
}

bool Chart25D::PropertyDlg()
{
	return false;
}

bool Ribbon25D::PropertyDlg()
{
	return false;
}

bool BubblePlot3D::PropertyDlg()
{
	return false;
}

bool GridLine::PropertyDlg()
{
	return false;
}

bool Tick::PropertyDlg()
{
	return false;
}

bool Axis::PropertyDlg()
{
	return false;
}

bool Graph::AddPlot(int family)
{
	return false;
}

bool Graph::PropertyDlg()
{
	return false;
}

bool Graph::Configure()
{
	return false;
}

bool Graph::AddAxis()
{
	return false;
}

bool Page::Configure()
{
	return false;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// some more STUBS .....
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
char *SaveGraphAsName(char *oldname)
{
	return 0L;
}

char *OpenGraphName(char *oldname)
{
	return 0L;
}

void HideTextCursor()
{
	return;
}

void HideTextCursorObj(anyOutput *out)
{
	return;
}

void ShowTextCursor(anyOutput *out, RECT *disp, DWORD color)
{
	return;
}

anyOutput *NewDispClass(GraphObj *g)
{
	return 0L;
}

bool DelDispClass(anyOutput *w)
{
	return false;
}

anyOutput *NewBitmapClass(int w, int h, double hr, double vr)
{
	return 0L;
}

bool DelBitmapClass(anyOutput *w)
{
	return false;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// create a root object to handle I/O
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class ExpRoot:public GraphObj{
public:
	ExpRoot(char *file1, char *file2);
	~ExpRoot();
	bool Command(int cmd, void *tmpl, anyOutput *o);

private:
	char *name1, *name2;
	GraphObj *go;
};

ExpRoot::ExpRoot(char *file1, char *file2):GraphObj(0L, 0L)
{
	if(file1 && strcmp("-", file1)) name1 = file1;
	else name1 = 0L;
	if(file2 && strcmp("-", file2)) name2 = file2;
	else name2 = 0L;
	go = 0L;
	OpenGraph(this, name1, 0L);
	if(bDelete && name1 && name1[0]) unlink(name1);
}

ExpRoot::~ExpRoot()
{
	if(go) {
		DeleteGO(go);
		if(!bQuiet)fprintf(stderr, "Object deleted after read\n");
		}
}

bool
ExpRoot::Command(int cmd, void *tmpl, anyOutput *o)
{
	int i;

	switch(cmd) {
	case CMD_DROP_GRAPH:
		go = (GraphObj*)tmpl;
		if(go) {
			go->Command(CMD_SET_DATAOBJ, 0L, 0L);
			switch(file_fmt){
			case FF_SVG:
				DoExportSvg(go, name2, bSVGtype ? 1L : 0L);
				break;
			case FF_WMF:
				DoExportWmf(go, name2, 600.0f, 0L);
				break;
			case FF_EPS:
				DoExportEps(go, name2, 0L);
				break;
			default:
				ErrorBox("Unknown file extension or format of destination");
				}
			DeleteGO(go);
			go = 0L;
			}
		break;
		}
	return true;
}


int Usage()
{
	printf("______________________________________________________________\n");
	printf("\nexprlp: RLPlot export utility, version %s.\n", SZ_VERSION);
	printf("Copyright (C) 2002-2004 R. Lackner\n");
	printf("This is free software published under the GNU\n");
	printf("general public licence (GPL).\n");
	printf("\nUsage: exprlp [options] <input> [options] [<output>]\n");
	printf("\nOptions:\n");
	printf("   -      use stdin/stdout as input or output file; requires\n");
	printf("             that file format is set by -e | -s | -w option\n");
	printf("             not an option in the strict sense\n");
	printf("   -h     print this information\n");
	printf("   -d     delete input file after read\n");
	printf("   -e     output Encapsulated PostScript, *.eps\n");
	printf("   -s     output Scalable Vector Graphics, *.svg\n");
	printf("   -S     like -s, start output with \"Content-Type: image/svg+xml\"\n");
	printf("   -v     print RLPlot version\n");
	printf("   -w     output Windows Meta File, *.wmf\n");
	printf("   -q     quiet mode: suppress output to the console\n");
	printf("\nExamples:\n");
	printf("   exprlp foo.rlp foo.svg      ;exports Scalable Vector Graphics\n");
	printf("   exprlp -q foo.rlp foo.eps   ;exports Encapsulated PostScript, no messages\n");
	printf("   exprlp foo.rlp foo.wmf      ;exports Windows Meta File\n");
	printf("   exprlp -sq foo.rlp -        ;exports SVG to the console, no messages\n");
	printf("   exprlp -eq - -              ;converts inputfile from stdin to EPS\n");
	printf("                                   on stdout: useful for pipes\n");
	printf("\n switch character is either \'-\' or \'/\'\n");
	printf("______________________________________________________________\n\n");
	if(szFile1) free(szFile1);	if(szFile2) free(szFile2);
	szFile1 = szFile2 = 0L;
	return 1;
}

int main (int argc, char **argv)
{
	ExpRoot *base = 0L;
	int i, j, k;

	for (i = 1, j = 0; i < argc; i++) {
		if(argv[i][0] == '-' || (argv[i][0] == '/' && strlen(argv[i]) < 5)) {
			//check for switch
			for(k = 1; argv[i][k-1]; k++) {
				switch(argv[i][k]){
				case 'h':	case 'H':	case '?':
					return Usage();
				case 'd':
					bDelete = true;
					break;
				case 'S':
					bSVGtype = true;
				case 's':
					file_fmt = FF_SVG;
					break;
				case 'e':	case 'E':
					file_fmt = FF_EPS;
					break;
				case 'w':	case 'W':
					file_fmt = FF_WMF;
					break;
				case 'q':	case 'Q':
					bQuiet = true;
					break;
				case 'v':	case 'V':
					printf("RLPlot version %s\n", SZ_VERSION);
					return 0;
				case '\0':
					if(k == 1) {
						if(j == 0) szFile1 = strdup("-");
						else if(j == 1) szFile2 = strdup("-");
						j++;
						}
					break;
					}
				}
			}
		else switch(j) {
		case 0:
			szFile1 = strdup(argv[i]);
			j++;
			break;
		case 1:
			szFile2 = strdup(argv[i]);
			j++;
			}
		}
	if(file_fmt == FF_UNKNOWN && szFile2 && (i = strlen(szFile2)) > 4) {
		if(0==strcmp(".svg", szFile2+i-4)) file_fmt = FF_SVG;
		else if(0==strcmp(".wmf", szFile2+i-4)) file_fmt = FF_WMF;
		else if(0==strcmp(".eps", szFile2+i-4)) file_fmt = FF_EPS;
		}
	if(file_fmt == FF_UNKNOWN) {
		if(szFile1)printf("\n**** Unknown file extension or format ****\n\n");
		return Usage();
		}
	if(!bQuiet) {
		fprintf(stderr,"Input file \"%s\"\n", szFile1);
		fprintf(stderr,"Output file \"%s\"\n", szFile2);
		}
	setlocale(LC_ALL, "");
	if(!szFile1) return Usage();
	base = new ExpRoot(szFile1, szFile2);
	if(base) {
		delete base;
		}
	if(szFile1) free(szFile1);	if(szFile2) free(szFile2);
	return 0;
}
