from Ft.Server.Common import Schema, ResourceTypes, CreationParams, ValidationInfo, DocumentReference
import sha

def GetAnonRepo(tester):
    from Ft.Server.Client import Core
    return Core.GetRepository(None, None,
                              tester.test_data['ftrpc-host'],
                              tester.test_data['ftrpc-port'])

##def RetrieveSession(tester,sid,key):
##    from Ft.Server.Server import SCore
##    return SCore.RetrieveSession(sid,
##                                 key,
##                                 NullLogger.NullLogger(),
##                                 tester.test_data['properties'])

def GetRepo(tester,userName = None, passwd = None):
    if userName is None:
        userName = tester.test_data['userName']
    if passwd is None:
        passwd = tester.test_data['password']
    from Ft.Server.Client import Core
    return Core.GetRepository(userName,
                              sha.new(passwd).hexdigest(),
                              tester.test_data['ftrpc-host'],
                              tester.test_data['ftrpc-port'])

def CompareValidationInfo(tester,original,actual):
    tester.compare(original.validationType,actual.validationType)
    if original.validationType == ValidationInfo.ValidationType.NONE:
        return
    elif original.validationType == ValidationInfo.ValidationType.SCHEMATRON:
        CompareDocumentReference(tester,original.documentReference,actual.documentReference)
    elif original.validationType == ValidationInfo.ValidationType.DTD:
        CompareDocumentReference(tester,original.documentReference,actual.documentReference)
    else:
        raise "Finish"

def CompareNsMap(tester,original,actual):

    #Compare the dictionarys.
    #Cause there may be a few extra, we need to
    #Just make sure actual has everything that orginal has
    #tester.compare(len(original.keys()),len(actual.keys()))

    for k,v in original.items():
        tester.compare(1,actual.has_key(k))
        tester.compare(v,actual[k])
        
    
def CompareRdfMaps(tester,original,actual):
    #Compare a list of lists

    tester.compare(len(original),len(actual))
    for s,p,o,t in original:
        found = 0
        for ts,tp,to,tt in actual:
            if ts == s and tp == p and to == o and tt == t:
                found = 1
                break
        if not found:
            print 'expected',original
            print 'compared',actual
            tester.error("Mapping %s not found" % str((s,p,o,t)))

            
def CompareCreationParams(tester,original,actual):
    
    tester.compare(original.fullTextIndex,actual.fullTextIndex)
    tester.compare(original.enforceSchema,actual.enforceSchema)
    CompareValidationInfo(tester,original.validationInfo,actual.validationInfo)

    tester.compare(len(original.extModules),len(actual.extModules))
    for m in original.extModules:
        tester.compareIn(actual.extModules,m)

def CompareDocumentReference(tester,original,actual):

    tester.compare(original.referenceType,actual.referenceType)
    if original.referenceType == DocumentReference.DocumentReferenceType.INTERNAL:
        tester.compare(original.uri,actual.uri)
    elif original.referenceType == DocumentReference.DocumentReferenceType.EXTERNAL:
        tester.compare(original.uri,actual.uri)
    elif original.referenceType == DocumentReference.DocumentReferenceType.STRING:
        tester.compare(original.baseUri,actual.baseUri)
        tester.compare(original.data,actual.data)
    else:
        raise "Unknown"



