
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Union
from Ft.Ods.MetaData import UnionCase
from Ft.Ods.MetaData import Interface
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_scopedtype
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    
    try:
        test_scopedtype.Test(tester,db,Union.Union,UnionCase.UnionCase)


        tester.startGroup("Union Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_form_drop(tester,db,Union.Union,'switch_type',Interface.Interface)
        test_metadata_util.test_form_drop(tester,db,Union.Union,'cases',UnionCase.UnionCase,nSided=1)
        tester.groupDone()

    finally:
        db.close()



