<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Draw (a card) processing

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='draw-screen.xsl'/>

  <xsl:template match="/cribbage">
    <xsl:call-template name='draw-screen'>
      <xsl:with-param name='form-action' select='"../discard.xslt"'/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name='playing-area'>
    <!-- Play info -->
    <H2>The Cut: <xsl:value-of select='key("players",$initial-dealer)/name'/><xsl:text>'s crib</xsl:text></H2>
    <TABLE>
      <TR>
        <TD><IMG src='{draw-info/player-one/Card/@img}'/></TD>
      </TR>
      <TR>
        <TD><IMG src='{draw-info/player-two/Card/@img}'/></TD>
      </TR>
    </TABLE>
  </xsl:template>

  <xsl:template match='Card' mode='player-hand'>
    <TD>
      <IMG src='{@img}'/><BR class='HACK'/>
      <INPUT TYPE='CHECKBOX' NAME='DISCARD{position()}' VALUE='{@short-name}'/>Discard
    </TD>
  </xsl:template>

  <xsl:template name='cur-count'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        Current Count: <xsl:value-of select='/cribbage/game-info/cur-count'/>
      </TD>
    </TR>
  </xsl:template>

  <xsl:template match='Card' mode='cut-card'>
    <TR>
      <TD ALIGN='CENTER' COLSPAN='2'>
        <IMG src='/images/cards/4SS-Back.png'/>
      </TD>
    </TR>
  </xsl:template>


  <xsl:template name='player-hand-other'>
    <INPUT TYPE='SUBMIT' VALUE='Submit Discards'/>
  </xsl:template>

</xsl:stylesheet>
