<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Screen draw processing

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:param name='top-show-puter' select='0'/>
  <xsl:param name='fres:uri-path'/>

  <xsl:include href='globals.xsl'/>

  <xsl:template name='draw-screen'>
    <xsl:param name='form-action'/>
    <xsl:param name='show-all' select='0'/>
    <xsl:param name='show-puter' select='$top-show-puter'/>

    <html>
    <head>
      <title><xsl:value-of select="key('players',1)/name"/><xsl:text> vs </xsl:text><xsl:value-of select='key("players",2)/name'/><xsl:text> in </xsl:text><xsl:value-of select='/cribbage/game-info/@type'/><xsl:text> Cribbage</xsl:text></title>
    </head>
    <body bgcolor='green'>


      <TABLE BORDER='1'>
       <!--Display other player's hand-->
        <TR>
          <TD rowspan="3">
            <TABLE CELLSPACING='0' CELLPADDING='0' BORDER='0'>
              <cext:draw-cribbage-board p1-scores='key("players",1)/scores/score' p2-scores='key("players",2)/scores/score'/>

            </TABLE>
          </TD>
          <TD colspan="3" ALIGN='CENTER'>
            <TABLE>
              <TR>
                <xsl:variable name='cards'>
                  <xsl:choose>
                    <xsl:when test='$show-all="1"'>
                      <xsl:copy-of select='key("players",1)/cards/Card'/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:copy-of select='key("players",1)/playing-cards/Card'/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <xsl:for-each select='exslt:node-set($cards)/Card'>
                  <xsl:choose>
                    <xsl:when test='$show-puter="1"'>
                      <TD><IMG src='{@img}'/></TD>
                    </xsl:when>
                    <xsl:otherwise>
                      <TD><IMG src='/images/cards/4SS-Back.png'/></TD>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
                <xsl:choose>
                  <xsl:when test='count(exslt:node-set($cards)/Card) &lt; 1'>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                  </xsl:when>
                  <xsl:when test='count(exslt:node-set($cards)/Card) &lt; 2'>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                  </xsl:when>
                  <xsl:when test='count(exslt:node-set($cards)/Card) &lt; 3'>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                  </xsl:when>
                  <xsl:when test='count(exslt:node-set($cards)/Card) &lt; 4'>
                    <TD><IMG src='/images/cards/O.png'/></TD>
                  </xsl:when>
                </xsl:choose>
              </TR>
            </TABLE>
          </TD>
    <TD rowspan="3">
            <H2>Log of last Action</H2>
            <xsl:for-each select='cur-log/log-entry[last() - position() &lt; 20]'>
              <xsl:text>* </xsl:text><xsl:value-of select='.'/><BR/>
            </xsl:for-each>
            <BR/>
            <a href='{$fres:uri-path}?xslt=../decorated-xml.xslt' TARGET='_blank'>View the XML behind the scenes</a>
          </TD>
        </TR>
        <TR>
          <!--Display board-->
          <TD colspan="2" VALIGN='TOP'>
            <TABLE BORDER='1'>
              <TR>
                <TH><FONT COLOR='red'><xsl:value-of select='key("players",1)/name'/></FONT></TH>
                <TH><FONT COLOR='blue'><xsl:value-of select='key("players",2)/name'/></FONT></TH>
              </TR>
              <TR>
                <TH><xsl:value-of select='sum(key("players",1)/scores/score)'/></TH>
                <TH><xsl:value-of select='sum(key("players",2)/scores/score)'/></TH>
              </TR>

            <xsl:apply-templates select='game-info/cut-card/Card' mode='cut-card'/>
            <xsl:call-template name='cur-count'/>
            </TABLE>
          </TD>
          <!-- Play info -->
          <TD ALIGN='CENTER'>
            <xsl:call-template name='playing-area'/>
          </TD>
        </TR>
        <!-- Player's Hand -->
        <TR>
          <TD colspan="3" ALIGN='CENTER'>
            <FORM name='discard' action='{$fres:uri-path}?xslt={$form-action}' METHOD='POST'>
              <TABLE>
                <TR>
                  <xsl:choose>
                    <xsl:when test='$show-all="1"'>
                      <xsl:apply-templates select='key("players",2)/cards/Card' mode='player-hand'>
                        <xsl:sort select='@value-int' data-type='number'/>
                      </xsl:apply-templates>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:variable name='cards' select='exslt:node-set(key("players",2)/playing-cards/Card)'/>
                      <xsl:apply-templates select='$cards' mode='player-hand'>
                        <xsl:sort select='@value-int' data-type='number'/>
                      </xsl:apply-templates>
                      <xsl:choose>
                        <xsl:when test='count($cards) &lt; 1'>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                        </xsl:when>
                        <xsl:when test='count($cards) &lt; 2'>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                        </xsl:when>
                        <xsl:when test='count($cards) &lt; 3'>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                        </xsl:when>
                        <xsl:when test='count($cards) &lt; 4'>
                          <TD><IMG src='/images/cards/O.png'/></TD>
                        </xsl:when>
                      </xsl:choose>
                    </xsl:otherwise>
                  </xsl:choose>
                </TR>
                <TR>
                  <TD colspan='4'> <!-- it will always be at least this -->
                    <xsl:call-template name='player-hand-other'/>
                    <INPUT TYPE='CHECKBOX' NAME='debug' VALUE='debug'>Debug (just show me the changes)</INPUT>
                  </TD>
                </TR>
              </TABLE>
            </FORM>
          </TD>
        </TR>
      </TABLE>
    </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
