########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/FtRpc/Responses.py,v 1.7 2005/03/22 09:58:58 mbrown Exp $
"""
RPC server protocol responses

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import Marshal

from Ft.Server.FtRpc import ResponseCodes


class FtRpcResponse:
    def __init__(self):
        pass

    def send(self, connection):
        Marshal.Send(connection, self.response, self.data)
        return


class GeneralErrorResponse(FtRpcResponse):
    """
    This response class represents an unknown error condition.
    It is returned when ever a unknown exception occurs on the server
    """
    response = ResponseCodes.GENERAL_ERROR
    def __init__(self, error, traceback):
        self.msg = str(error)
        self.traceback = traceback
        self.data = {'msg': self.msg,
                     'traceback': traceback,
                     'params': error.args,
                     }
        return


class FtServerErrorResponse(FtRpcResponse):
    """
    A specific Ft Server exception occurred
    """
    response = ResponseCodes.FTSERVER_ERROR

    def __init__(self, error):
        self.error = str(error)
        self.data = {'error': str(error),
                     'params': error.params, # computed
                    }
        # Add code, params, message from FtServerServerException instance to
        # the returned data. We really only need the code.
        self.data.update(vars(error))
        return


class OkResponse(FtRpcResponse):
    """
    Simple Acknowledge
    """
    response = ResponseCodes.OK
    data={}
    pass


class ResourceTypeResponse(FtRpcResponse):
    """
    Return the Resource type of an object
    """
    response = ResponseCodes.RESOURCE_TYPE
    def __init__(self, path, resourceType):
        self.path = path
        self.resourceType = resourceType
        self.data={'path': path,
                   'resourceType': resourceType}


class MethodResultsResponse(FtRpcResponse):
    """
    The results of invoking a method
    """
    response = ResponseCodes.METHOD_RESULTS
    def __init__(self, path, results):
        self.path = path
        self.results = results
        self.data={'path': path,
                   'results': results}


class RdfResultsResponse(FtRpcResponse):
    """
    The results of invoking a method on the model
    """
    response = ResponseCodes.RDF_RESULTS
    def __init__(self, path, results):
        self.path = path
        self.results = results
        self.data={'path': path,
                   'results': results}


g_responseMapping = {ResponseCodes.OK: OkResponse,
                     ResponseCodes.GENERAL_ERROR: GeneralErrorResponse,
                     ResponseCodes.RESOURCE_TYPE: ResourceTypeResponse,
                     ResponseCodes.METHOD_RESULTS: MethodResultsResponse,
                     ResponseCodes.RDF_RESULTS: RdfResultsResponse,
                     ResponseCodes.FTSERVER_ERROR: FtServerErrorResponse,
                     }

