/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.soap.axis.ser;

import javax.management.ObjectName;
import javax.management.MBeanServerNotification;

import org.xml.sax.SAXException;

/**
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class MBeanServerNotificationDeser extends NotificationDeser
{
   private ObjectName mbeanName;

   public void onSetChildValue(Object value, Object hint) throws SAXException
   {
      super.onSetChildValue(value, hint);
      if (MBeanServerNotificationSer.MBEAN_NAME.equals(hint)) mbeanName = (ObjectName)value;
   }

   protected Object createObject() throws SAXException
   {
      MBeanServerNotification notification = new MBeanServerNotification(getType(), getSource(), getSequenceNumber(), mbeanName);
      notification.setTimeStamp(getTimeStamp());
      notification.setUserData(getUserData());
      return notification;
   }
}
