/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.local;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;

import javax.management.remote.JMXServerErrorException;
import javax.security.auth.Subject;

import mx4j.remote.MX4JRemoteUtils;

/**
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.2 $
 */
class ServerSubjectInvoker implements InvocationHandler
{
   static LocalConnection newInstance(LocalConnection target, Subject subject, AccessControlContext context)
   {
      ServerSubjectInvoker handler = new ServerSubjectInvoker(target, subject, context);
      return (LocalConnection)Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{LocalConnection.class}, handler);
   }

   private final LocalConnection target;
   private final Subject subject;
   private final AccessControlContext context;

   private ServerSubjectInvoker(LocalConnection target, Subject subject, AccessControlContext context)
   {
      this.target = target;
      this.subject = subject;
      this.context = context;
   }

   public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable
   {
      String name = method.getName();
      if ("close".equals(name)) return chain(method, args);

      Subject delegate = (Subject)args[args.length - 1];
      return MX4JRemoteUtils.subjectInvoke(subject, delegate, context, new PrivilegedExceptionAction()
      {
         public Object run() throws Exception
         {
            return chain(method, args);
         }
      });
   }

   private Object chain(Method method, Object[] args) throws Exception
   {
      try
      {
         return method.invoke(target, args);
      }
      catch (InvocationTargetException x)
      {
         Throwable xx =  x.getTargetException();
         if (xx instanceof Exception) throw (Exception)xx;
         throw new JMXServerErrorException("Error thrown during invocation", (Error)xx);
      }
   }
}
