/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.log;


import org.apache.log4j.Category;
import org.apache.log4j.Priority;

/**
 * Log that redirects log calls to a Log4J Category. <p>
 *
 * @see org.apache.log4j.Category at <a href="http://jakarta.apache.org/log4j">Apache's Log4J</a>
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.4 $
 */
public class Log4JLogger extends Logger
{
	private Category m_category;

	/**
	 * This constructor is called to create instances of this Logger, following the prototype pattern.
	 */
	public Log4JLogger() {}

	protected void setCategory(String category)
	{
		super.setCategory(category);
		m_category = Category.getInstance(getCategory());
	}

	protected void log(int priority, Object message, Throwable t)
	{
		// Convert MX4J priority to log4j priority
		Priority p = convertPriority(priority);
		m_category.log(p, message, t);
	}

	/**
	 * Converts MX4J priority to Log4J priority
	 */
	protected Priority convertPriority(int mx4jPriority)
	{
		Priority log4jPriority = Priority.DEBUG;
		switch (mx4jPriority)
		{
			case Logger.FATAL: log4jPriority = Priority.FATAL; break;
			case Logger.ERROR: log4jPriority = Priority.ERROR; break;
			case Logger.WARN: log4jPriority = Priority.WARN; break;
			case Logger.INFO: log4jPriority = Priority.INFO; break;
			case Logger.DEBUG: log4jPriority = Priority.DEBUG; break;
			case Logger.TRACE: log4jPriority = Priority.DEBUG; break;
			default: log4jPriority = Priority.INFO; break;
		}
		return log4jPriority;
	}
}
