/* $Id: postgres.c,v 1.3 2002/01/05 11:50:50 tellini Exp $ */

/*
	Copyright (c) 2001-2002 Simone Tellini

	Permission is hereby granted, free of charge, to any person obtaining 
	a copy of this software and associated documentation files (the "Software"), 
	to deal in the Software without restriction, including without limitation 
	the rights to use, copy, modify, merge, publish, distribute, sublicense, 
	and/or sell copies of the Software, and to permit persons to whom the 
	Software is furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included 
	in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
	OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
	THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
	FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
	DEALINGS IN THE SOFTWARE.
*/

#ifdef NEED_POSTGRES

#include <libpq-fe.h>

#include "mod_accounting.h"

#define PG_ERROR( handle ) (( handle ) ? ( PQerrorMessage(( PGconn * )handle )) : "PostgreSQL server has gone away" )

int PgSetup( accounting_state *cfg )
{
	if( !cfg->DBHandle && cfg->DBName ) {

		cfg->DBHandle = (void *) PQsetdbLogin( cfg->DBHost, cfg->DBPort, NULL, NULL, cfg->DBName, cfg->DBUser, cfg->DBPwd );

		if( PQstatus(( PGconn * )cfg->DBHandle ) == CONNECTION_BAD )
			PgClose( cfg );
	}

	return( cfg->DBHandle != NULL );
}

int PgQuery( accounting_state *cfg, server_rec *server, pool *p, char *query )
{
	int	retval = 0;

	if( !cfg->DBHandle || ( PQstatus(( PGconn * )cfg->DBHandle ) == CONNECTION_BAD )) {
		
	    PgClose( cfg );

	    ap_log_error( APLOG_MARK,ERRLEVEL, server, "PostgresSQL: connection lost, attempting reconnect" );

   		if( !PgSetup( cfg ))
   			ap_log_error( APLOG_MARK,ERRLEVEL, server, "PostgresSQL: reconnect failed" );
		else
	   		ap_log_error( APLOG_MARK,ERRLEVEL, server, "PostgresSQL: reconnect successful" );
	}

	if( cfg->DBHandle ) {
		PGresult	*res;

		res = PQexec(( PGconn * )cfg->DBHandle, query );

		retval = PQresultStatus( res ) == PGRES_COMMAND_OK;

		if( !retval ) {

			ap_log_error( APLOG_MARK,ERRLEVEL, server, 
						  ap_pstrcat( p, "PostgresSQL query failed:  ", query, NULL ));

			ap_log_error( APLOG_MARK, ERRLEVEL, server, 
						  ap_pstrcat( p, "PostgresSQL failure reason:  ", PG_ERROR( cfg->DBHandle ), NULL ));
		}

		PQclear( res );
	}

	return( retval );
}

void PgClose( accounting_state *cfg )
{
	if( cfg->DBHandle ) {

		PQfinish(( PGconn * )cfg->DBHandle );

		cfg->DBHandle = NULL;
	}
}

#endif /* NEED_POSTGRES */
