/*
 *  
 *  Java-Gnome Bindings Library
 *
 *  Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *  
 *  This is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *  
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <jni.h>
#include <vte/vte.h>
#include <unistd.h>

extern char **environ;

#ifndef _Included_org_gnu_gnomevte_Terminal
#define _Included_org_gnu_gnomevte_Terminal
#ifdef __cplusplus
extern "C" {
#endif

gchar** getStringArray(JNIEnv *env, jobjectArray anArray);
void freeStringArray(JNIEnv *env, jobjectArray anArray, gchar** str);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1new
  (JNIEnv *env, jclass klass){

	  return (jint) vte_terminal_new ();
  }


/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_fork_command
 * Signature: (I[B[[B[[B[BZZZ)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1fork_1command
  (JNIEnv *env, jclass klass, jint handle, jbyteArray command, jobjectArray argv, 
   jbyteArray directory, jboolean lastlog, jboolean utmp, jboolean wtmp){

	gchar **args_g = getStringArray(env, argv);

	jbyte *command_g_byte = command ? (*env)->GetByteArrayElements(env, command, 0) : NULL;
	gchar *command_g = (gchar*)command_g_byte;
	
	
	jbyte *directory_g_byte = directory ? (*env)->GetByteArrayElements(env, directory, 0) : NULL;
	gchar *directory_g = (gchar*)directory_g_byte;

	int retval = vte_terminal_fork_command ((VteTerminal*)handle, command_g, args_g, environ, directory_g, 
			(gboolean)lastlog, (gboolean)utmp, (gboolean)wtmp);
	

	freeStringArray(env, argv, args_g);
	return retval;
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_feed
 * Signature: (I[BI)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1feed
  (JNIEnv *env, jclass klass, jint handle, jbyteArray data, jint length){

	  VteTerminal *terminal = (VteTerminal*)handle;
	  jbyte *data_g_byte = data ? (*env)->GetByteArrayElements(env, data, 0) : NULL;
	  gchar* data_g = (gchar*)data_g_byte;

	  vte_terminal_feed (terminal, data_g, (gint)length);

  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_feed_child
 * Signature: (I[BJ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1feed_1child
  (JNIEnv *env, jclass klass, jint handle, jbyteArray data, jlong length){

	  VteTerminal *terminal = (VteTerminal*)handle;
	  jbyte *data_g_byte = data ? (*env)->GetByteArrayElements(env, data, 0) : NULL;
	  gchar* data_g = (gchar*)data_g_byte;

	  vte_terminal_feed_child (terminal, data_g, (gint)length);
	  
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_copy_clipboard
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1copy_1clipboard
  (JNIEnv *env, jclass klass, jint handle){
	  
	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_copy_clipboard (term);
  }
	  

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_paste_clipboard
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1paste_1clipboard
  (JNIEnv *env, jclass klass, jint handle){

	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_paste_clipboard (term);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_copy_primary
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1copy_1primary
  (JNIEnv *env, jclass klass, jint handle) {
		VteTerminal *term = (VteTerminal*)handle;
		vte_terminal_copy_primary(term);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_paste_primary
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1paste_1primary
  (JNIEnv *env, jclass klass, jint handle) {
		VteTerminal *term = (VteTerminal*)handle;
		vte_terminal_paste_primary(term);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_size
 * Signature: (III)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1size
  (JNIEnv *env, jclass klass, jint handle, jint columns, jint rows){

	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_set_size (term, (gint)columns, (gint)rows);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_audible_bell
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1audible_1bell
  (JNIEnv *env, jclass klass, jint handle, jboolean audible){

	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_set_audible_bell (term, (gboolean)audible);
  }
	  
  

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_audible_bell
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1audible_1bell
  (JNIEnv *env, jclass klass, jint handle){
	  
	  VteTerminal *term = (VteTerminal*)handle;
	  return (gboolean)vte_terminal_get_audible_bell (term);
  }
	  

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_visible_bell
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1visible_1bell
  (JNIEnv *env, jclass klass, jint handle, jboolean visible){
	  
	VteTerminal *term = (VteTerminal*)handle;
	vte_terminal_set_visible_bell (term, (gboolean)visible);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_visible_bell
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1visible_1bell
  (JNIEnv *env, jclass klass, jint handle){
	  
	  VteTerminal *term = (VteTerminal*)handle;
	  return vte_terminal_get_visible_bell (term);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_scroll_on_output
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1scroll_1on_1output
  (JNIEnv *env, jclass klass, jint handle, jboolean scroll){

	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_set_scroll_on_output (term, (gboolean)scroll);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_scroll_on_keystroke
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1scroll_1on_1keystroke
  (JNIEnv *env, jclass klass, jint handle, jboolean scroll){

	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_set_scroll_on_keystroke (term, (gboolean)scroll);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_color_dim
 * Signature: (II)V
 */
//TODO: TEST IT!!!
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1color_1dim
	(JNIEnv *env, jclass klass, jint handle, jint dim) {
		VteTerminal *term = (VteTerminal*)handle;
		GdkColor *g_dim = (GdkColor*)dim;
		vte_terminal_set_color_dim(term, g_dim);
  	}
	
/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_color_bold
 * Signature: (II)V
 */
//TODO: Test It
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1color_1bold
  (JNIEnv *env, jclass klass, jint handle, jint color) {
	VteTerminal *term = (VteTerminal*)handle;
	GdkColor *g_color = (GdkColor*)color;
	vte_terminal_set_color_bold(term, g_color);
}  

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_color_foreground
 * Signature: (II)V
 */
//TODO: Test It!!!
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1color_1foreground
  (JNIEnv *env, jclass klass, jint handle, jint fgcolor) {
	VteTerminal *term = (VteTerminal*)handle;
	GdkColor *g_fgcolor = (GdkColor*)fgcolor;
	
	//printf("[JNI] set_color_foreground ...");
	
	vte_terminal_set_color_foreground(term, g_fgcolor);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_color_background
 * Signature: (II)V
 */
//TODO: TEST IT!!!
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1color_1background
  (JNIEnv *env, jclass klass, jint handle, jint bgcolor) {
  	
	//printf("[JNI]: set_color_background ...\n");
	
	VteTerminal *term = (VteTerminal*)handle;
	GdkColor *g_bgcolor = (GdkColor*)bgcolor;
	vte_terminal_set_color_background(term, g_bgcolor);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_colors
 * Signature: (IIIII)V
 */
//TODO: Test it
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1colors
  (JNIEnv *env, jclass klass, jint handle, jint foreground, jint background, 
  		jint palett, jint palett_size) {
	
	VteTerminal *term = (VteTerminal*)handle;
	GdkColor *g_fgcolor = (GdkColor*)foreground;
	GdkColor *g_bgcolor = (GdkColor*)background;
	GdkColor *g_palett = (GdkColor*)palett;

	vte_terminal_set_colors(term, g_fgcolor, g_bgcolor, g_palett, (glong)palett_size);
}		

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_default_colors
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1default_1colors
  (JNIEnv *env, jclass klass, jint handle){
	  
	VteTerminal *term = (VteTerminal*)handle;
	vte_terminal_set_default_colors (term);
  }
/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_background_image
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1background_1image
  (JNIEnv *env, jclass klass, jint handle, jint pixbuf){

	  GdkPixbuf *pix = (GdkPixbuf*)pixbuf;
	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_set_background_image (term, pix);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_background_image_file
 * Signature: (I[B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1background_1image_1file
  (JNIEnv *env, jclass klass, jint handle, jbyteArray file){

	jbyte *file_g_byte = file ? (*env)->GetByteArrayElements(env, file, 0) : NULL;
	gchar *file_g = (gchar*)file_g_byte;
	VteTerminal *term = (VteTerminal*)handle;
	vte_terminal_set_background_image_file(term, file_g);

  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_background_saturation
 * Signature: (ID)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1background_1saturation
  (JNIEnv *env, jclass klass, jint handle, jdouble saturation){
	  
	VteTerminal *term = (VteTerminal*)handle;
	vte_terminal_set_background_saturation (term, (double)saturation);
  }


/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_background_transparent
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1background_1transparent
  (JNIEnv *env, jclass klass, jint handle, jboolean transparent){
	  
	VteTerminal *term = (VteTerminal*)handle;
	vte_terminal_set_background_transparent (term, (gboolean)transparent);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_cursor_blinks
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1cursor_1blinks
  (JNIEnv *env, jclass klass, jint handle, jboolean blinking){
	  
	VteTerminal *term = (VteTerminal*)handle;
	vte_terminal_set_cursor_blinks (term, (gboolean)blinking);
  }


/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_scrollback_lines
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1scrollback_1lines
  (JNIEnv *env, jclass klass, jint handle, jint lines){
	  
	VteTerminal *term = (VteTerminal*)handle;
	vte_terminal_set_scrollback_lines (term, lines);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_im_append_menuitems
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1im_1append_1menuitems
  (JNIEnv *env, jclass klass, jint handle, jint menuShell){

	  VteTerminal *term = (VteTerminal*)handle;
	  GtkMenuShell *menu = (GtkMenuShell*)menuShell;

	  vte_terminal_im_append_menuitems(term, menu);
  }
	  

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_font
 * Signature: (II)V
 */
//TODO:
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1font
  (JNIEnv *env, jclass klass, jint handle, jint font) {
	
	VteTerminal *term = (VteTerminal*)handle;
	PangoFontDescription *p_font = (PangoFontDescription*)font;
	vte_terminal_set_font(term, p_font);
}  

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_font_from_string
 * Signature: (I[B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1font_1from_1string
  (JNIEnv *env, jclass klass, jint handle, jbyteArray font){
	
	VteTerminal *term = (VteTerminal*)handle;
	jbyte *font_g_byte = font ? (*env)->GetByteArrayElements(env, font, 0) : NULL;
	gchar *font_g = (gchar*)font_g_byte;

	vte_terminal_set_font_from_string(term, font_g);
  }
	  

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_font
 * Signature: (I)I
 */
//TODO:
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1font
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_using_xft
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1using_1xft
  (JNIEnv *env, jclass klass, jint handle){
	  return (jboolean) vte_terminal_get_using_xft((VteTerminal*)handle);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_allow_bold
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1allow_1bold
  (JNIEnv *env, jclass klass, jint handle, jboolean allow){

	  gboolean _allow = (gboolean)allow;
	  VteTerminal *term = (VteTerminal*)handle;
	  vte_terminal_set_allow_bold(term, _allow);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_allow_bold
 * Signature: (I)Z
 */
//TODO: From here.
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1allow_1bold
  (JNIEnv *env, jclass klass, jint handle){
	  return (jboolean) vte_terminal_get_allow_bold((VteTerminal*)handle);
  }

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_has_selection
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1has_1selection
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_word_chars
 * Signature: (I[B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1word_1chars
  (JNIEnv *env, jclass klass, jint, jbyteArray);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_is_word_char
 * Signature: (IC)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1is_1word_1char
  (JNIEnv *env, jclass klass, jint, jchar);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_backspace_binding
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1backspace_1binding
  (JNIEnv *env, jclass klass, jint, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_delete_binding
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1delete_1binding
  (JNIEnv *env, jclass klass, jint, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_mouse_autohide
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1mouse_1autohide
  (JNIEnv *env, jclass klass, jint, jboolean);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_mouse_autohide
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1mouse_1autohide
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_reset
 * Signature: (IZZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1reset
  (JNIEnv *env, jclass klass, jint, jboolean, jboolean);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_cursor_position
 * Signature: (I[I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1cursor_1position
  (JNIEnv *env, jclass klass, jint, jintArray, jintArray);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_match_clear_all
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1match_1clear_1all
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_match_add
 * Signature: (I[B)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1match_1add
  (JNIEnv *env, jclass klass, jint, jbyteArray);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_match_remove
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1match_1remove
  (JNIEnv *env, jclass klass, jint, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_match_check
 * Signature: (III[I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1match_1check
  (JNIEnv *env, jclass klass, jint, jint, jint, jintArray);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_emulation
 * Signature: (I[B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1emulation
  (JNIEnv *env, jclass klass, jint, jbyteArray);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_emulation
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1emulation
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_set_encoding
 * Signature: (I[B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1set_1encoding
  (JNIEnv *env, jclass klass, jint, jbyteArray);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_encoding
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1encoding
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_status_line
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1status_1line
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_padding
 * Signature: (I[I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1padding
  (JNIEnv *env, jclass klass, jint, jintArray, jintArray);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_adjustment
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1adjustment
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_char_width
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1char_1width
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_char_height
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1char_1height
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_char_descent
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1char_1descent
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_char_ascent
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1char_1ascent
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_row_count
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1row_1count
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_column_count
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1column_1count
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_window_title
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1window_1title
  (JNIEnv *env, jclass klass, jint);

/*
 * Class:     org_gnu_gnomevte_Terminal
 * Method:    vte_terminal_get_icon_title
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_org_gnu_gnomevte_Terminal_vte_1terminal_1get_1icon_1title
  (JNIEnv *env, jclass klass, jint);

#ifdef __cplusplus
}
#endif
#endif
