// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright (C) 2000 Stefanus Du Toit

#include <Atlas/Message/Encoder.h>
#include <Atlas/Message/Element.h>

namespace Atlas { namespace Message {

Encoder::Encoder(Atlas::Bridge* b)
    : EncoderBase(b)
{
}

void Encoder::listItem(const Element& obj)
{
    switch (obj.getType()) {
        case Element::TYPE_INT: b->listItem(obj.asInt()); break;
        case Element::TYPE_FLOAT: b->listItem(obj.asFloat()); break;
        case Element::TYPE_STRING: b->listItem(obj.asString()); break;
        case Element::TYPE_MAP: {
            b->listItem(Bridge::MapBegin);
            Element::MapType::const_iterator I;
            for (I = obj.asMap().begin(); I != obj.asMap().end();
                    I++)
                mapItem((*I).first, (*I).second);
            b->mapEnd();
            }
            break;
        case Element::TYPE_LIST: {
            b->listItem(Bridge::ListBegin);
            Element::ListType::const_iterator I;
            for (I = obj.asList().begin(); I != obj.asList().end();
                    I++)
                listItem(*I);
            b->listEnd();
            }
            break;
        default: break;
    }
}

void Encoder::mapItem(const std::string& name, const Element& obj)
{
    switch (obj.getType()) {
        case Element::TYPE_INT: b->mapItem(name, obj.asInt()); break;
        case Element::TYPE_FLOAT: b->mapItem(name, obj.asFloat()); break;
        case Element::TYPE_STRING: b->mapItem(name, obj.asString()); break;
        case Element::TYPE_MAP: {
            b->mapItem(name, Bridge::MapBegin);
            Element::MapType::const_iterator I;
            for (I = obj.asMap().begin(); I != obj.asMap().end();
                    I++)
                mapItem((*I).first, (*I).second);
            b->mapEnd();
            }
            break;
        case Element::TYPE_LIST: {
            b->mapItem(name, Bridge::ListBegin);
            Element::ListType::const_iterator I;
            for (I = obj.asList().begin(); I != obj.asList().end();
                    I++)
                listItem(*I);
            b->listEnd();
            }
            break;
        default:
            break;
    }                          
}

void Encoder::streamMessage(const Element& obj)
{
    if (obj.isMap()) {
        b->streamMessage(Bridge::MapBegin);
        Element::MapType::const_iterator I;
        for (I = obj.asMap().begin();
             I != obj.asMap().end(); I++)
            mapItem((*I).first, (*I).second);
        b->mapEnd();
    }
}



} } // namespace Atlas::Message
