/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc;

import java.sql.*;
import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.jdbc.translators.*;
/**
 *
 */
public class ResultSetMetaDataSapDB implements java.sql.ResultSetMetaData {
    private DBTechTranslator [] colInfo;
    /**
     *
     * @param infos com.sap.dbtech.jdbc.translators.DBTechTranslator[]
     */
    ResultSetMetaDataSapDB(DBTechTranslator [] infos) {
        this.colInfo = infos;
    }
    /**
     *
     * @return com.sap.dbtech.jdbc.translators.DBTechTranslator
     * @param columnIndex int
     * @exception java.sql.SQLException The exception description.
     */
    public DBTechTranslator findColInfo (int columnIndex) throws SQLException {
        DBTechTranslator info;

        try {
            info = this.colInfo [columnIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new InvalidColumnException (columnIndex, this);
        }
        return info;
    }
    /**
     * getCatalogName method comment.
     */
    public String getCatalogName(int column) throws SQLException {
        return com.sap.dbtech.jdbc.DatabaseMetaDataSapDB.defaultCatalogName;
    }
    /**
     *
     * @return java.lang.String
     * @param column int
     * @exception java.sql.SQLException The exception description.
     */
    public String getColumnClassName(int column) throws SQLException {
        return this.findColInfo (column).getColumnClassName ();
    }
    /**
     * getColumnCount method comment.
     */
    public int getColumnCount() throws SQLException {
        return this.colInfo.length;
    }
    /**
     * getColumnDisplaySize method comment.
     */
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.findColInfo (column).getColumnDisplaySize ();
    }
    /**
     * getColumnLabel method comment.
     */
    public String getColumnLabel(int column) throws SQLException {
        return this.findColInfo (column).getColumnLabel ();
    }
    /**
     * getColumnName method comment.
     */
    public String getColumnName(int column) throws SQLException {
        return this.findColInfo (column).getColumnName ();
    }
    /**
     * getColumnType method comment.
     */
    public int getColumnType(int column) throws SQLException {
        return this.findColInfo (column).getColumnType ();
    }
    /**
     * getColumnTypeName method comment.
     */
    public String getColumnTypeName(int column) throws SQLException {
        return this.findColInfo (column).getColumnTypeName ();
    }
    /**
     * getPrecision method comment.
     */
    public int getPrecision(int column) throws SQLException {
        return this.findColInfo (column).getPrecision ();
    }
    /**
     * getScale method comment.
     */
    public int getScale(int column) throws SQLException {
        return this.findColInfo (column).getScale ();
    }
    /**
     * getSchemaName method comment.
     */
    public String getSchemaName(int column) throws SQLException {
        return this.findColInfo (column).getSchemaName ();
    }
    /**
     * getTableName method comment.
     */
    public String getTableName(int column) throws SQLException {
        return this.findColInfo (column).getTableName ();
    }
    /**
     * isAutoIncrement method comment.
     */
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }
    /**
     * isCaseSensitive method comment.
     */
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.findColInfo (column).isCaseSensitive ();
    }
    /**
     * isCurrency method comment.
     */
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }
    /**
     * isDefinitelyWritable method comment.
     */
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }
    /**
     * isNullable method comment.
     */
    public int isNullable(int column) throws SQLException {
        return this.findColInfo (column).isNullable ();
    }
    /**
     * isReadOnly method comment.
     */
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }
    /**
     * isSearchable method comment.
     */
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }
    /**
     * isSigned method comment.
     */
    public boolean isSigned(int column) throws SQLException {
        return true;
    }
    /**
     * isWritable method comment.
     */
    public boolean isWritable(int column) throws SQLException {
        return this.findColInfo (column).isWritable ();
    }
}
