/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.procserver;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.ProcReplyPacket;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.procserver.Callable;
import com.sap.dbtech.procserver.CallableFactory;
import com.sap.dbtech.procserver.Log;
import com.sap.dbtech.procserver.ProcParameterList;
import com.sap.dbtech.procserver.ProcServerConnection;
import com.sap.dbtech.procserver.SQLJCallable;
import com.sap.dbtech.procserver.Stop;
import com.sap.dbtech.rte.comm.NativeComm;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.sql.SQLException;

public class ProcServerSession
extends Thread {
    private NativeComm comm;
    private ProcServerConnection conn;
    private CallableFactory callFactory;

    public ProcServerSession(String string) throws Exception {
        ParsedSessionId parsedSessionId = new ParsedSessionId(string);
        try {
            this.comm = new NativeComm("", string);
        }
        catch (RTEException rTEException) {
            throw new Exception(rTEException.getMessage());
        }
        try {
            this.conn = new ProcServerConnection(this.comm);
        }
        catch (SQLException sQLException) {
            throw new Exception(sQLException.getMessage());
        }
        this.callFactory = new SQLJCallable.SQLJCallableFactory();
    }

    public void run() {
        try {
            StructuredMem structuredMem = this.comm.getRequestPacket();
            structuredMem.putString("", 0);
            this.comm.request(structuredMem, 0);
            while (true) {
                ProcReplyPacket procReplyPacket;
                StructuredMem structuredMem2;
                StructuredBytes[] structuredBytesArray = new StructuredBytes[1];
                StructuredMem structuredMem3 = this.comm.receive();
                if (structuredMem3.size() == 0) break;
                boolean bl = false;
                if (structuredMem3.getInt1(1) == 2) {
                    structuredMem2 = (StructuredBytes)structuredMem3;
                    structuredMem3 = new FullswapMem(structuredMem2.bytes());
                    bl = true;
                }
                try {
                    structuredMem2 = new ReplyPacket(structuredMem3);
                    String[] stringArray = this.parseProcidPart((ReplyPacket)structuredMem2);
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    Callable callable = this.callFactory.create(string, string2);
                    ProcParameterList procParameterList = new ProcParameterList((ReplyPacket)structuredMem2);
                    callable.call(procParameterList);
                    procReplyPacket = this.initReply(bl, structuredBytesArray);
                    if (procParameterList.hasOutputParameter()) {
                        DataPart dataPart = procReplyPacket.newDataPart(5);
                        procParameterList.copyToOutputPacket(dataPart);
                        dataPart.close();
                    }
                }
                catch (Stop stop) {
                    Log.log("STOP: [" + stop.getErrorCode() + "] " + stop.getMessage());
                    procReplyPacket = this.initReply(bl, structuredBytesArray);
                    procReplyPacket.setStopInfo(stop.getErrorCode(), stop.getMessage());
                }
                catch (Throwable throwable) {
                    Log.traceException(throwable);
                    procReplyPacket = this.initReply(bl, structuredBytesArray);
                    procReplyPacket.setExceptionInfo(throwable);
                }
                procReplyPacket.closePacket();
                procReplyPacket.traceOn(System.out);
                this.comm.request(procReplyPacket, procReplyPacket.length());
            }
        }
        catch (Throwable throwable) {
            Log.traceException(throwable);
        }
    }

    protected String[] parseProcidPart(ReplyPacket replyPacket) throws PartNotFound {
        String[] stringArray = new String[2];
        replyPacket.findPart(29);
        int n = replyPacket.getPartDataPos();
        int n2 = 0;
        while (n2 < 2) {
            String string;
            int n3 = replyPacket.getUInt1(n) * 256 + replyPacket.getUInt1(n + 1);
            stringArray[n2] = string = replyPacket.getString(n + 2, n3);
            n += 2 + n3;
            ++n2;
        }
        return stringArray;
    }

    protected ProcReplyPacket initReply(boolean bl, StructuredBytes[] structuredBytesArray) {
        StructuredMem structuredMem;
        StructuredMem structuredMem2 = this.comm.getRequestPacket();
        structuredBytesArray[0] = (StructuredBytes)structuredMem2;
        if (bl) {
            structuredMem = (StructuredBytes)structuredMem2;
            structuredMem2 = new FullswapMem(((StructuredBytes)structuredMem).bytes());
        }
        structuredMem = new ProcReplyPacket(structuredMem2);
        return structuredMem;
    }

    private static class ParsedSessionId {
        public int port;
        public int packetSize;

        public ParsedSessionId(String string) {
            int n = string.indexOf(58, 2);
            this.port = Integer.parseInt(string.substring(2, n));
            this.packetSize = Integer.parseInt(string.substring(n + 1));
        }
    }

    public class Exception
    extends Throwable {
        public Exception(String string) {
            super(string);
        }
    }
}

