/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import java.io.IOException;
import java.io.InputStream;

public class InputStreamFilter
extends InputStream {
    private int maxlength;
    private InputStream ips;
    private int readlength = 0;

    public InputStreamFilter(InputStream inputStream, int n) {
        this.maxlength = n;
        this.ips = inputStream;
    }

    public int read() throws IOException {
        if (this.maxlength <= this.readlength++) {
            return -1;
        }
        return this.ips.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readlength >= this.maxlength) {
            return -1;
        }
        if (this.readlength + n2 > this.maxlength) {
            n2 = this.maxlength - this.readlength;
        }
        if (n2 <= 0) {
            return 0;
        }
        n2 = this.ips.read(byArray, n, n2);
        this.readlength += n2;
        return n2;
    }
}

