/**
 * =============================================================
 * JFreeReport : an open source reporting class library for Java
 * =============================================================
 *
 * Project Info:  http://www.object-refinery.com/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ---------------------
 * DemoResources_hu.java
 * ---------------------
 * (C)opyright 2003, by Demeter F. Tams
 *
 * Original Author:  Demeter F. Tams;
 * Contributor(s):   -;
 *
 * $Id: DemoResources_hu.java,v 1.2 2003/06/16 16:06:56 taqua Exp $
 *
 *
 */
package com.jrefinery.report.demo.resources;

import java.awt.event.KeyEvent;

import com.jrefinery.report.resources.JFreeReportResources;

/**
 * User interface items for the JFreeReport demonstration application.  These have been put into
 * a ResourceBundle to ease localisation of the application.
 *
 * @author Demeter F. Tams
 */
public class DemoResources_hu extends JFreeReportResources
{
  /**
   * Returns the contents of the resource bundle.
   *
   * @return an array of localised resources.
   */
  public Object[][] getContents ()
  {
    return CONTENTS;
  }

  /** The resources to be localised. */
  private static final Object[][] CONTENTS = {
    // in the title pattern, leave in the '{0}' as it gets replaced with the version number
    {"main-frame.title.pattern", "JFreeReport {0} Dem"},

    {"action.close.name", "Kilps"},
    {"action.close.description", "kilps a JFreeReportDemo-bl"},
    {"action.close.mnemonic", new Integer (KeyEvent.VK_K)},

    {"action.print-preview.name", "Nyomtatsi elnzet..."},
    {"action.print-preview.description", "Lista megtekintse"},
    {"action.print-preview.mnemonic", new Integer (KeyEvent.VK_N)},

    {"action.about.name", "Nvjegy..."},
    {"action.about.description", "Informcik az alkalmazsrl"},
    {"action.about.mnemonic", new Integer (KeyEvent.VK_N)},

    {"menu.file.name", "Fjl"},
    {"menu.file.mnemonic", new Character ('F')},
    {"menu.help.name", "Sg"},
    {"menu.help.mnemonic", new Character ('S')},
    {"exitdialog.title", "Jvhagys .."},
    {"exitdialog.message", "Biztos, hogy kilpsz a programbl?"},


    {"report.definitionnotfound", "ReportDefinition {0} nem tallhat classpath elrsi ton"},
    {"report.definitionfailure.message", "Reportdefinition {0} nem tudom betlteni."},
    {"report.definitionfailure.title", "Betlt hiba"},
    {"report.definitionnull", "A listadefinci nem lett ltrehoozva"},
    {"error", "Hiba"},
    {"example", "Plda {0}"}

  };
}
