/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.ImageDecorator;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class FileSystemStatus
implements StatusDecorator,
ImageDecorator {
    private static final Logger LOG = Logger.getLogger(FileSystemStatus.class.getName());

    public String annotateName(String string, Set<? extends FileObject> set) {
        for (FileObject fileObject : set) {
            String string2 = this.annotateName(fileObject);
            if (string2 == null) continue;
            return string2;
        }
        return string;
    }

    private final String annotateName(FileObject fileObject) {
        String string = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
        if (string != null) {
            try {
                string = BaseUtilities.translate((String)string);
                ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
                try {
                    return resourceBundle.getString(fileObject.getPath());
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            catch (MissingResourceException missingResourceException) {
                Exceptions.attachMessage((Throwable)missingResourceException, (String)this.warningMessage(string, fileObject));
                LOG.log(Level.INFO, null, missingResourceException);
            }
        }
        return (String)fileObject.getAttribute("displayName");
    }

    private String warningMessage(String string, FileObject fileObject) {
        Object object = fileObject.getAttribute("layers");
        if (object instanceof Object[]) {
            object = Arrays.toString((Object[])object);
        }
        return "Cannot load " + string + " for " + fileObject + " defined by " + object;
    }

    @Override
    public Image annotateIcon(Image image, int n, Set<? extends FileObject> set) {
        for (FileObject fileObject : set) {
            Image image2 = this.annotateIcon(fileObject, n);
            if (image2 == null) continue;
            return image2;
        }
        return image;
    }

    public String annotateNameHtml(String string, Set<? extends FileObject> set) {
        return null;
    }

    private Image annotateIcon(FileObject fileObject, int n) {
        Object object;
        String string = null;
        if (n == 1) {
            string = "SystemFileSystem.icon";
        } else if (n == 2) {
            string = "SystemFileSystem.icon32";
        }
        if (string != null && (object = fileObject.getAttribute(string)) != null) {
            if (object instanceof URL) {
                return Toolkit.getDefaultToolkit().getImage((URL)object);
            }
            if (object instanceof Image) {
                return (Image)object;
            }
            LOG.warning("Attribute " + string + " on " + fileObject + " expected to be a URL or Image; was: " + object);
        }
        if ((object = (String)fileObject.getAttribute("iconBase")) != null) {
            if (n == 1) {
                return ImageUtilities.loadImage((String)object, (boolean)true);
            }
            if (n == 2) {
                return ImageUtilities.loadImage((String)this.insertBeforeSuffix((String)object, "_32"), (boolean)true);
            }
        }
        return null;
    }

    private String insertBeforeSuffix(String string, String string2) {
        String string3 = string;
        String string4 = "";
        if (string.lastIndexOf(46) >= 0) {
            string3 = string.substring(0, string.lastIndexOf(46));
            string4 = string.substring(string.lastIndexOf(46), string.length());
        }
        return string3 + string2 + string4;
    }
}

