/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.rules;

import java.util.HashMap;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.FieldAccess;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Histogram;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.IteratingRule;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.MemoryLint;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.StringHelper;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class DuplicatedString
extends IteratingRule {
    private FieldAccess fldValue;
    private HashMap<String, Integer> map = new HashMap();
    private Histogram<Histogram.Entry> dupSources = new Histogram();
    private StringHelper helper;
    private int total;

    public DuplicatedString() {
        super(NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_Name"), NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_Desc"), "java.lang.String");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(DuplicatedString.class, (String)"LBL_DupStr_LongDesc");
    }

    @Override
    protected void perform(Instance in) {
        String str = this.helper.decodeString(in);
        Integer val = this.map.get(str);
        if (val != null) {
            long strSize = in.getSize();
            Instance arr = this.fldValue.getRefValue(in);
            if (arr != null) {
                strSize += (long)(str.length() * 2 + 14);
            }
            String incomming = this.getContext().getRootIncommingString(in);
            incomming = Utils.printClass(this.getContext(), incomming);
            this.dupSources.add(incomming, new Histogram.Entry(strSize));
            this.total = (int)((long)this.total + strSize);
        }
        val = val == null ? 1 : val + 1;
        this.map.put(str, val);
    }

    @Override
    protected void prepareRule(MemoryLint context) {
        Heap heap = context.getHeap();
        this.helper = context.getStringHelper();
        JavaClass clsString = heap.getJavaClassByName("java.lang.String");
        this.fldValue = new FieldAccess(clsString, "value");
    }

    @Override
    protected void summary() {
        this.getContext().appendResults(NbBundle.getMessage(DuplicatedString.class, (String)"FMT_DupStr_Result", (Object)this.total));
        this.getContext().appendResults(this.dupSources.toString(50000));
    }
}

