/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.freehep.graphicsio.ps.AbstractPSGraphics2D;

public class EPSGraphics2D
extends AbstractPSGraphics2D {
    public EPSGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public EPSGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public EPSGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(os);
    }

    public EPSGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
    }

    protected EPSGraphics2D(EPSGraphics2D graphics, boolean doRestoreOnDispose) {
        super(graphics, doRestoreOnDispose);
    }

    private Rectangle getBoundingBox() {
        Dimension pageSize = this.getPageSize();
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        boolean isPortrait = this.getProperty(ORIENTATION).equals("Portrait");
        double awidth = pageSize.width - margins.left - margins.right;
        double aheight = pageSize.height - margins.top - margins.bottom;
        Dimension size = this.getSize();
        double iwidth = isPortrait ? size.width : size.height;
        double iheight = isPortrait ? size.height : size.width;
        double sf = Math.min(awidth / iwidth, aheight / iheight);
        if (!this.isProperty(FIT_TO_PAGE)) {
            sf = Math.min(sf, 1.0);
        }
        double x0 = awidth / 2.0 + (double)margins.left - sf * iwidth / 2.0;
        double y0 = aheight / 2.0 + (double)margins.bottom - sf * iheight / 2.0;
        double x1 = x0 + sf * iwidth;
        double y1 = y0 + sf * iheight;
        int llx = (int)x0;
        int lly = (int)y0;
        int urx = (int)Math.ceil(x1);
        int ury = (int)Math.ceil(y1);
        return new Rectangle(llx, lly, urx - llx, ury - lly);
    }

    @Override
    public void writeHeader() throws IOException {
        Dimension size = this.getSize();
        this.resetClip(new Rectangle(0, 0, size.width, size.height));
        this.os = new PrintStream(this.ros, true);
        this.os.println("%!PS-Adobe-3.0 EPSF-3.0");
        Rectangle bbox = this.getBoundingBox();
        this.os.println("%%BoundingBox: " + bbox.x + " " + bbox.y + " " + (bbox.x + bbox.width) + " " + (bbox.y + bbox.height));
        super.writeHeader();
        this.os.println("%%BeginSetup");
        super.openPage(this.getSize(), null, this.getComponent());
        this.os.println("%%EndSetup");
        this.os.println();
        try {
            this.writeGraphicsState();
            this.writeBackground();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void writeTrailer() throws IOException {
        super.writeTrailer();
        this.os.println("%%EOF");
    }

    @Override
    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new EPSGraphics2D(this, true);
    }

    @Override
    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        EPSGraphics2D graphics = new EPSGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }
}

