/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.desktop.search.SearchUIModel;
import org.gephi.desktop.search.api.SearchCategory;
import org.gephi.desktop.search.api.SearchController;
import org.gephi.desktop.search.api.SearchListener;
import org.gephi.desktop.search.api.SearchRequest;
import org.gephi.desktop.search.api.SearchResult;
import org.gephi.desktop.search.filter.SearchFilterBuilder;
import org.gephi.desktop.search.impl.SearchCategoryImpl;
import org.gephi.desktop.search.popup.ActionPopup;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.visualization.api.VisualizationController;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SearchDialog
extends JPanel
implements SearchListener {
    private final SearchUIModel uiModel;
    private final ButtonGroup categoryGroup;
    private JToggleButton allCategoriesButton;
    private JToolBar categoryToolbar;
    private JButton filterButton;
    private JToolBar optionToolbar;
    private JList<SearchResult> resultsList;
    private JTextField searchField;
    private JPanel topPanel;

    public SearchDialog(SearchUIModel uiModel) {
        this.uiModel = uiModel;
        this.categoryGroup = new ButtonGroup();
        this.initComponents();
        this.setup();
    }

    protected void setup() {
        this.allCategoriesButton.addActionListener(e -> {
            this.uiModel.setCategory(null);
            this.search();
        });
        this.allCategoriesButton.putClientProperty("JButton.buttonType", "square");
        this.allCategoriesButton.setSelected(true);
        this.categoryGroup.add(this.allCategoriesButton);
        this.uiModel.getCategories().forEach(category -> {
            JToggleButton toggleButton = new JToggleButton();
            toggleButton.setText(category.getDisplayName());
            toggleButton.setFocusable(false);
            toggleButton.setHorizontalTextPosition(0);
            toggleButton.setVerticalTextPosition(3);
            toggleButton.putClientProperty("JButton.buttonType", "square");
            this.categoryToolbar.add(toggleButton);
            this.categoryGroup.add(toggleButton);
            toggleButton.addActionListener(e -> {
                this.uiModel.setCategory((SearchCategory)category);
                this.search();
            });
            if (this.uiModel.category == category) {
                toggleButton.setSelected(true);
            }
        });
        this.resultsList.setFocusable(false);
        this.resultsList.setCellRenderer(new ResultRenderer());
        this.resultsList.addMouseListener(new ActionPopup(this.resultsList));
        this.resultsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchDialog.this.click();
                }
            }
        });
        this.resultsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SearchDialog.this.select();
                }
            }
        });
        this.searchField.setText(this.uiModel.query);
        this.searchField.getDocument().addDocumentListener(e -> this.search());
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "none");
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "none");
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 38) {
                    SearchDialog.this.resultsList.setSelectedIndex(Math.max(0, SearchDialog.this.resultsList.getSelectedIndex() - 1));
                } else if (evt.getKeyCode() == 40) {
                    SearchDialog.this.resultsList.setSelectedIndex(SearchDialog.this.resultsList.getSelectedIndex() + 1);
                } else if (evt.getKeyCode() == 10) {
                    SearchDialog.this.click();
                }
            }
        });
        this.filterButton.setEnabled(false);
        if (!this.uiModel.query.isEmpty()) {
            this.search();
        }
        this.searchField.requestFocusInWindow();
    }

    protected void unsetup() {
        this.resetSelection();
    }

    protected void search() {
        String query;
        this.uiModel.query = query = this.searchField.getText();
        if (query != null && !query.trim().isEmpty()) {
            SearchRequest request = SearchRequest.builder().query(query.trim()).category(this.uiModel.category).build();
            SearchController searchController = (SearchController)Lookup.getDefault().lookup(SearchController.class);
            searchController.search(request, this);
        } else {
            this.resultsList.setModel(new ResultsListModel(Collections.emptyList()));
            this.filterButton.setEnabled(false);
        }
    }

    protected void click() {
        SearchResult result = this.resultsList.getSelectedValue();
        if (result != null) {
            DataTablesController dataTablesController;
            VisualizationController visualizationController;
            Object val = result.getResult();
            if (SearchDialog.isGraphOpened() && (visualizationController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class)) != null) {
                if (val instanceof Node) {
                    visualizationController.centerOnNode((Node)val);
                } else if (val instanceof Edge) {
                    visualizationController.centerOnEdge((Edge)val);
                }
            }
            if (SearchDialog.isDataLabOpened() && (dataTablesController = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)) != null) {
                if (val instanceof Node) {
                    dataTablesController.selectNodesTable();
                    dataTablesController.setNodeTableSelection(new Node[]{(Node)val});
                } else if (val instanceof Edge) {
                    dataTablesController.selectEdgesTable();
                    dataTablesController.setEdgeTableSelection(new Edge[]{(Edge)val});
                }
            }
        }
    }

    protected void select() {
        SearchResult result = this.resultsList.getSelectedValue();
        if (result != null) {
            DataTablesController dataTablesController;
            VisualizationController visualizationController;
            Object val = result.getResult();
            if (SearchDialog.isGraphOpened() && (visualizationController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class)) != null) {
                if (val instanceof Node) {
                    visualizationController.resetSelection();
                    visualizationController.selectNodes(new Node[]{(Node)val});
                } else if (val instanceof Edge) {
                    visualizationController.resetSelection();
                    visualizationController.selectEdges(new Edge[]{(Edge)val});
                }
            }
            if (SearchDialog.isDataLabOpened() && (dataTablesController = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)) != null) {
                if (val instanceof Node && dataTablesController.isNodeTableMode()) {
                    dataTablesController.setNodeTableSelection(new Node[]{(Node)val});
                } else if (val instanceof Edge && dataTablesController.isEdgeTableMode()) {
                    dataTablesController.setEdgeTableSelection(new Edge[]{(Edge)val});
                }
            }
        } else {
            this.resetSelection();
        }
    }

    protected void filter(String type) {
        FilterController filterController;
        String query = this.searchField.getText();
        if (query != null && !query.trim().isEmpty() && (filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class)) != null) {
            FilterBuilder filterBuilder = (FilterBuilder)Lookup.getDefault().lookup(SearchFilterBuilder.class);
            Query filterQuery = filterController.createQuery(filterBuilder);
            ((SearchFilterBuilder.SearchFilter)filterQuery.getFilter()).setQuery(query);
            ((SearchFilterBuilder.SearchFilter)filterQuery.getFilter()).setType(type);
            filterController.add(filterQuery);
        }
    }

    private void resetSelection() {
        DataTablesController dataTablesController;
        VisualizationController visualizationController;
        if (SearchDialog.isGraphOpened() && (visualizationController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class)) != null) {
            visualizationController.resetSelection();
        }
        if (SearchDialog.isDataLabOpened() && (dataTablesController = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)) != null) {
            dataTablesController.clearSelection();
        }
    }

    protected void instrumentDragListener(JDialog dialog) {
        DragListener dragListener = new DragListener(dialog);
        this.categoryToolbar.addMouseListener(dragListener);
        this.categoryToolbar.addMouseMotionListener(dragListener);
    }

    @Override
    public void started(SearchRequest request) {
    }

    @Override
    public void cancelled() {
    }

    @Override
    public void finished(SearchRequest request, List<SearchResult> results) {
        SwingUtilities.invokeLater(() -> {
            this.resultsList.setModel(new ResultsListModel(results));
            this.resultsList.setSelectedIndex(0);
            this.enableFilterButton(results);
        });
    }

    private synchronized void enableFilterButton(List<SearchResult> results) {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this.filterButton.getActionListeners()) {
            this.filterButton.removeActionListener(listener);
        }
        List types = results.stream().map(r -> r.getResult().getClass()).distinct().collect(Collectors.toUnmodifiableList());
        boolean enabled = types.size() == 1 && (Node.class.isAssignableFrom((Class)types.get(0)) || Edge.class.isAssignableFrom((Class)types.get(0)));
        this.filterButton.setEnabled(enabled);
        if (enabled) {
            if (Node.class.isAssignableFrom((Class)types.get(0))) {
                this.filterButton.addActionListener(e -> this.filter(SearchCategoryImpl.NODES().getId()));
            } else if (Edge.class.isAssignableFrom((Class)types.get(0))) {
                this.filterButton.addActionListener(e -> this.filter(SearchCategoryImpl.EDGES().getId()));
            }
        }
    }

    public static boolean isGraphOpened() {
        return TopComponent.getRegistry().getOpened().stream().map(tc -> WindowManager.getDefault().findTopComponentID(tc)).anyMatch(id -> id.equals("GraphTopComponent"));
    }

    public static boolean isDataLabOpened() {
        return TopComponent.getRegistry().getOpened().stream().map(tc -> WindowManager.getDefault().findTopComponentID(tc)).anyMatch(id -> id.equals("DataTableTopComponent"));
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.optionToolbar = new JToolBar();
        this.filterButton = new JButton();
        this.searchField = new JTextField();
        this.categoryToolbar = new JToolBar();
        this.allCategoriesButton = new JToggleButton();
        this.resultsList = new JList();
        this.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.borderColor")));
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.optionToolbar.setRollover(true);
        this.filterButton.setIcon(ImageUtilities.loadImageIcon((String)"DesktopSearch/filter.png", (boolean)false));
        this.filterButton.setToolTipText(NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.filterButton.toolTipText"));
        this.filterButton.setFocusable(false);
        this.filterButton.setHorizontalTextPosition(0);
        this.filterButton.setVerticalTextPosition(3);
        this.optionToolbar.add(this.filterButton);
        this.topPanel.add((Component)this.optionToolbar, "East");
        this.topPanel.add((Component)this.searchField, "South");
        this.categoryToolbar.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.allCategoriesButton, (String)NbBundle.getMessage(SearchDialog.class, (String)"SearchDialog.allCategoriesButton.text"));
        this.allCategoriesButton.setFocusable(false);
        this.allCategoriesButton.setHorizontalTextPosition(0);
        this.allCategoriesButton.setVerticalTextPosition(3);
        this.categoryToolbar.add(this.allCategoriesButton);
        this.topPanel.add((Component)this.categoryToolbar, "Center");
        this.add((Component)this.topPanel, "North");
        this.resultsList.setSelectionMode(0);
        this.add(this.resultsList, "Center");
    }

    private class DragListener
    extends MouseInputAdapter {
        Point location;
        MouseEvent pressed;
        Component componentToMove;

        public DragListener(JDialog dialog) {
            this.componentToMove = dialog;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.pressed = me;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.location = this.componentToMove.getLocation(this.location);
            int x = this.location.x - this.pressed.getX() + me.getX();
            int y = this.location.y - this.pressed.getY() + me.getY();
            this.componentToMove.setLocation(x, y);
        }
    }

    @FunctionalInterface
    public static interface SimpleDocumentListener
    extends DocumentListener {
        public void update(DocumentEvent var1);

        @Override
        default public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }
    }

    private static class ResultsListModel
    extends AbstractListModel<SearchResult> {
        private final List<SearchResult> results;

        public ResultsListModel(List<SearchResult> results) {
            this.results = results;
        }

        @Override
        public int getSize() {
            return this.results.size();
        }

        @Override
        public SearchResult getElementAt(int index) {
            return this.results.get(index);
        }
    }

    private static class ResultRenderer
    implements ListCellRenderer<SearchResult> {
        protected final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private final ImageIcon nodeIcon = ImageUtilities.loadImageIcon((String)"DesktopSearch/node.svg", (boolean)false);
        private final ImageIcon edgeIcon = ImageUtilities.loadImageIcon((String)"DesktopSearch/edge.svg", (boolean)false);
        private final Color selectionBackground = UIManager.getColor("List.selectionBackground");
        private final Color selectionForeground = UIManager.getColor("List.selectionForeground");

        private ResultRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SearchResult> list, SearchResult value, int index, boolean isSelected, boolean cellHasFocus) {
            Object val;
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, isSelected);
            if (isSelected) {
                renderer.setBackground(this.selectionBackground);
                renderer.setForeground(this.selectionForeground);
            }
            if ((val = value.getResult()) instanceof Node) {
                renderer.setIcon(this.nodeIcon);
            } else if (val instanceof Edge) {
                renderer.setIcon(this.edgeIcon);
            }
            return renderer;
        }
    }
}

