/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdesktop.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager
extends CookieHandler {
    private static Map<String, Set<Wrapper>> cache = new HashMap<String, Set<Wrapper>>();

    private CookieManager() {
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
        if (uri == null) {
            return cookieHeaders;
        }
        Set<Wrapper> cookies = cache.get(uri.getHost());
        if (cookies != null) {
            for (Wrapper w : cookies) {
                if (!CookieManager.pathsMatch(uri.getPath(), w.cookie.getPath())) continue;
                ArrayList<String> pairs = (ArrayList<String>)cookieHeaders.get("Cookie");
                if (pairs == null) {
                    pairs = new ArrayList<String>();
                    cookieHeaders.put("Cookie", pairs);
                }
                Cookie c = w.cookie;
                StringBuffer buffer = new StringBuffer();
                buffer.append(c.getName()).append("=").append(c.getValue());
                pairs.add(buffer.toString());
            }
        }
        return cookieHeaders;
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            if (!"Set-Cookie".equalsIgnoreCase(entry.getKey())) continue;
            Set<Wrapper> cookies = cache.get(uri.getHost());
            if (cookies == null) {
                cookies = new HashSet<Wrapper>();
                cache.put(uri.getHost(), cookies);
            }
            for (String v : entry.getValue()) {
                Cookie c = Cookie.parseCookie(v);
                Wrapper w = new Wrapper(c);
                if (c.getMaxAge() == 0) {
                    cookies.remove(w);
                    continue;
                }
                cookies.add(w);
            }
        }
    }

    public static Cookie[] getCookies(URI uri) {
        return CookieManager.getCookies(uri.getHost());
    }

    public static Cookie[] getCookies(String host) {
        Set<Wrapper> cookies = cache.get(host);
        if (cookies == null) {
            return new Cookie[0];
        }
        Cookie[] c = new Cookie[cookies.size()];
        int index = 0;
        for (Wrapper w : cookies) {
            c[index++] = w.cookie;
        }
        return c;
    }

    public static Cookie[] getCookies() {
        HashSet<Cookie> cookies = new HashSet<Cookie>();
        for (Map.Entry<String, Set<Wrapper>> entry : cache.entrySet()) {
            if (entry.getValue() == null) continue;
            for (Wrapper w : entry.getValue()) {
                cookies.add(w.cookie);
            }
        }
        return cookies.toArray(new Cookie[0]);
    }

    private static boolean pathsMatch(String p1, String p2) {
        if (p1 == null && p2 != null || p2 == null && p1 != null) {
            return false;
        }
        if (p1 == null && p2 == null) {
            return true;
        }
        return p1.equals(p2) || p1.startsWith(p2);
    }

    public static void install() {
        CookieHandler.setDefault(new CookieManager());
    }

    private static final class Wrapper {
        private Cookie cookie;

        private Wrapper(Cookie c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.cookie = c;
        }

        public boolean equals(Object o) {
            if (o instanceof Wrapper) {
                return this.cookie.getName().equalsIgnoreCase(((Wrapper)o).cookie.getName());
            }
            return false;
        }

        public Cookie unwrap() {
            return this.cookie;
        }

        public void eat() {
        }

        public boolean wasTasty() {
            return true;
        }
    }
}

