/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public class IBiblioResolver
extends URLResolver {
    private String root = null;
    private String pattern = null;
    private boolean usepoms = true;
    private boolean useMavenMetadata = true;

    public IBiblioResolver() {
        this.setChangingMatcher("regexp");
        this.setChangingPattern(".*-SNAPSHOT");
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        if (this.isM2compatible() && this.isUsepoms()) {
            ResolvedResource resolvedResource;
            ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
            moduleRevisionId = this.convertM2IdForResourceSearch(moduleRevisionId);
            if (dependencyDescriptor.getDependencyRevisionId().getRevision().endsWith("SNAPSHOT") && (resolvedResource = this.findSnapshotDescriptor(dependencyDescriptor, resolveData, moduleRevisionId)) != null) {
                return resolvedResource;
            }
            resolvedResource = this.findResourceUsingPatterns(moduleRevisionId, this.getIvyPatterns(), DefaultArtifact.newPomArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
            return resolvedResource;
        }
        return null;
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ResolvedResource resolvedResource;
        IBiblioResolver iBiblioResolver = this;
        iBiblioResolver.ensureConfigured(iBiblioResolver.getSettings());
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            moduleRevisionId = this.convertM2IdForResourceSearch(moduleRevisionId);
        }
        if (artifact.getId().getRevision().endsWith("SNAPSHOT") && this.isM2compatible() && (resolvedResource = this.findSnapshotArtifact(artifact, date, moduleRevisionId)) != null) {
            return resolvedResource;
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.getArtifactPatterns(), artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    private ResolvedResource findSnapshotArtifact(Artifact artifact, Date date, ModuleRevisionId moduleRevisionId) {
        String string = this.findSnapshotVersion(moduleRevisionId);
        if (string != null) {
            string = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + string);
            return this.findResourceUsingPattern(moduleRevisionId, string, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
        }
        return null;
    }

    private ResolvedResource findSnapshotDescriptor(DependencyDescriptor dependencyDescriptor, ResolveData resolveData, ModuleRevisionId moduleRevisionId) {
        String string = this.findSnapshotVersion(moduleRevisionId);
        if (string != null) {
            Message.verbose("[" + string + "] " + moduleRevisionId);
            string = this.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + string);
            return this.findResourceUsingPattern(moduleRevisionId, string, DefaultArtifact.newPomArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String findSnapshotVersion(ModuleRevisionId var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setM2compatible(boolean bl) {
        super.setM2compatible(bl);
        if (bl) {
            if (this.root == null) {
                this.root = "https://repo1.maven.org/maven2/";
            }
            if (this.pattern == null) {
                this.pattern = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
            }
            this.updateWholePattern();
        }
    }

    public void ensureConfigured(ResolverSettings resolverSettings) {
        if (resolverSettings != null && (this.root == null || this.pattern == null)) {
            String string;
            if (this.root == null) {
                string = resolverSettings.getVariable("ivy.ibiblio.default.artifact.root");
                if (string != null) {
                    this.root = string;
                } else {
                    resolverSettings.configureRepositories(true);
                    this.root = resolverSettings.getVariable("ivy.ibiblio.default.artifact.root");
                }
            }
            if (this.pattern == null) {
                string = resolverSettings.getVariable("ivy.ibiblio.default.artifact.pattern");
                if (string != null) {
                    this.pattern = string;
                } else {
                    resolverSettings.configureRepositories(false);
                    this.pattern = resolverSettings.getVariable("ivy.ibiblio.default.artifact.pattern");
                }
            }
            this.updateWholePattern();
        }
    }

    private String getWholePattern() {
        return this.root + this.pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String string) {
        if (string == null) {
            throw new NullPointerException("root must not be null");
        }
        this.root = !string.endsWith("/") ? string + "/" : string;
        IBiblioResolver iBiblioResolver = this;
        iBiblioResolver.ensureConfigured(iBiblioResolver.getSettings());
        this.updateWholePattern();
    }

    private void updateWholePattern() {
        if (this.isM2compatible() && this.isUsepoms()) {
            IBiblioResolver iBiblioResolver = this;
            iBiblioResolver.setIvyPatterns(Collections.singletonList(iBiblioResolver.getWholePattern()));
        } else {
            this.setIvyPatterns(Collections.EMPTY_LIST);
        }
        IBiblioResolver iBiblioResolver = this;
        iBiblioResolver.setArtifactPatterns(Collections.singletonList(iBiblioResolver.getWholePattern()));
    }

    @Override
    protected ResolvedResource[] listResources(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        if (this.shouldUseMavenMetadata(string)) {
            Object object = this.listRevisionsWithMavenMetadata(repository, moduleRevisionId.getModuleId().getAttributes());
            if (object != null) {
                Message.debug("\tfound revs: " + object);
                ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>();
                object = object.iterator();
                while (object.hasNext()) {
                    String string2;
                    String string3 = (String)object.next();
                    Object object2 = ModuleRevisionId.newInstance(moduleRevisionId, string3);
                    String string4 = string;
                    if (string3.endsWith("SNAPSHOT") && (string2 = this.findSnapshotVersion((ModuleRevisionId)object2)) != null) {
                        string4 = string.replaceFirst("\\-\\[revision\\]", "-" + string2);
                    }
                    string2 = IvyPatternHelper.substitute(string4, (ModuleRevisionId)object2, artifact);
                    try {
                        object2 = repository.getResource(string2);
                        if (object2 == null || !object2.exists()) continue;
                        arrayList.add(new ResolvedResource((Resource)object2, string3));
                    }
                    catch (IOException iOException) {
                        Message.warn("impossible to get resource from name listed by maven-metadata.xml:" + arrayList + ": " + iOException.getMessage());
                    }
                }
                ArrayList<ResolvedResource> arrayList2 = arrayList;
                return arrayList2.toArray(new ResolvedResource[arrayList2.size()]);
            }
            return super.listResources(repository, moduleRevisionId, string, artifact);
        }
        return super.listResources(repository, moduleRevisionId, string, artifact);
    }

    private List listRevisionsWithMavenMetadata(Repository repository, Map object) {
        object = IvyPatternHelper.substituteTokens(this.root + "[organisation]/[module]/maven-metadata.xml", (Map)object);
        return this.listRevisionsWithMavenMetadata(repository, (String)object);
    }

    /*
     * Exception decompiling
     */
    private List listRevisionsWithMavenMetadata(Repository var1_1, String var2_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean shouldUseMavenMetadata(String string) {
        return this.isUseMavenMetadata() && this.isM2compatible();
    }

    @Override
    public String getTypeName() {
        return "ibiblio";
    }

    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) throws ParseException {
        this.ensureConfigured(resolveData.getSettings());
        return super.getDependency(dependencyDescriptor, resolveData);
    }

    @Override
    public DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        IBiblioResolver iBiblioResolver = this;
        iBiblioResolver.ensureConfigured(iBiblioResolver.getSettings());
        return super.download(artifactArray, downloadOptions);
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        IBiblioResolver iBiblioResolver = this;
        iBiblioResolver.ensureConfigured(iBiblioResolver.getSettings());
        return super.locate(artifact);
    }

    @Override
    public List getArtifactPatterns() {
        IBiblioResolver iBiblioResolver = this;
        iBiblioResolver.ensureConfigured(iBiblioResolver.getSettings());
        return super.getArtifactPatterns();
    }

    public boolean isUsepoms() {
        return this.usepoms;
    }

    public boolean isUseMavenMetadata() {
        return this.useMavenMetadata;
    }

    @Override
    public void dumpSettings() {
        IBiblioResolver iBiblioResolver = this;
        iBiblioResolver.ensureConfigured(iBiblioResolver.getSettings());
        super.dumpSettings();
        Message.debug("\t\troot: " + this.getRoot());
        Message.debug("\t\tpattern: " + this.getPattern());
        Message.debug("\t\tusepoms: " + this.usepoms);
        Message.debug("\t\tuseMavenMetadata: " + this.useMavenMetadata);
    }
}

