/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.sort.CollectionOfModulesToSort;
import org.apache.ivy.core.sort.ModuleInSort;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.plugins.circular.CircularDependencyException;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class ModuleDescriptorSorter {
    private final CollectionOfModulesToSort moduleDescriptors;
    private final List sorted = new LinkedList();
    private final CircularDependencyStrategy circularDepStrategy;

    public ModuleDescriptorSorter(Collection collection, VersionMatcher versionMatcher, NonMatchingVersionReporter nonMatchingVersionReporter, CircularDependencyStrategy circularDependencyStrategy) {
        this.circularDepStrategy = circularDependencyStrategy;
        this.moduleDescriptors = new CollectionOfModulesToSort(collection, versionMatcher, nonMatchingVersionReporter);
    }

    public List sortModuleDescriptors() throws CircularDependencyException {
        Message.debug("Nbr of module to sort : " + this.moduleDescriptors.size());
        Iterator iterator = this.moduleDescriptors.iterator();
        while (iterator.hasNext()) {
            ModuleInSort moduleInSort;
            ModuleInSort moduleInSort2 = moduleInSort = (ModuleInSort)iterator.next();
            this.sortModuleDescriptorsHelp(moduleInSort2, moduleInSort2);
        }
        return this.sorted;
    }

    private void sortModuleDescriptorsHelp(ModuleInSort moduleInSort, ModuleInSort moduleInSort2) throws CircularDependencyException {
        if (moduleInSort.isProcessed()) {
            return;
        }
        if (moduleInSort.checkLoop(moduleInSort2, this.circularDepStrategy)) {
            return;
        }
        DependencyDescriptor[] dependencyDescriptorArray = moduleInSort.getDependencies();
        Message.debug("Sort dependencies of : " + moduleInSort.toString() + " / Number of dependencies = " + dependencyDescriptorArray.length);
        moduleInSort.setCaller(moduleInSort2);
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            ModuleInSort moduleInSort3 = this.moduleDescriptors.getModuleDescriptorDependency(dependencyDescriptorArray[i]);
            if (moduleInSort3 == null) continue;
            this.sortModuleDescriptorsHelp(moduleInSort3, moduleInSort);
        }
        moduleInSort.endOfCall();
        Message.debug("Sort done for : " + moduleInSort.toString());
        moduleInSort.addToSortedListIfRequired(this.sorted);
    }
}

