/* $NetBSD: $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_MESON_REG_H
#define _ARM_MESON_REG_H

#define CONSADDR_VA	(CONSADDR - MESON_CORE_BASE + MESON_CORE_VBASE)

#define MESON_CORE_BASE	0xc0000000
#define MESON_CORE_SIZE	0x1b000000
#define MESON_CORE_VBASE	0xe0000000

#define MESON_REF_FREQ	24000000

#define MESON_CBUS_OFFSET	0x01100000

#define MESON_PL310_OFFSET	0x04200000

#define MESON_DMC_OFFSET	0x08006000
#define MESON_DMC_SIZE	0x400

#define MESON_AOBUS_OFFSET	0x08100000

#define MESON_AO_RTI_PIN_MUX_OFFSET 0x08100014
#define MESON_GPIOAO_OFFSET	0x08100024

#define MESON_GPIOAO_EN_N_REG		0x00	/* [15:0] */
#define MESON_GPIOAO_OUT_REG		0x00	/* [31:16] */
#define MESON_GPIOAO_IN_REG		0x04
#define MESON_GPIOAO_PUPD_EN_REG	0x08	/* [15:0] */
#define MESON_GPIOAO_PUPD_REG		0x08	/* [31:16] */

#define MESON_UART_FREQ	MESON_REF_FREQ

#define MESON_CBUS_CPU_CLK_CNTL_REG	0x419c

#define MESON_AOBUS_PWR_CTRL0_REG	0xe0
#define MESON_AOBUS_PWR_CTRL1_REG	0xe4
#define MESON_AOBUS_PWR_MEM_PD0_REG	0xf4

#define MESON_CPUCONF_CTRL_REG	0x00
#define MESON_CPUCONF_CPU_ADDR_REG(n)	(0x04 * (n))

#endif /* _ARM_MESON_REG_H */
