/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.views.ConfigurationView;

public class ConfigurationManagerWindow
extends ApplicationWindow {
    private ConfigurationView view;
    private GlobalAction propertiesAction;
    private IAction propertiesActionHandler;

    public ConfigurationManagerWindow(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.addMenuBar();
        this.addActions();
        this.addToolBar(0x800000);
    }

    private void addActions() {
        MenuManager menuBar = this.getMenuBarManager();
        MenuManager fileMenu = new MenuManager(UpdateUI.getString("ConfigurationManagerWindow.fileMenu"));
        menuBar.add((IContributionItem)fileMenu);
        this.propertiesAction = new GlobalAction();
        this.propertiesAction.setText(UpdateUI.getString("ConfigurationManagerWindow.properties"));
        this.propertiesAction.setEnabled(false);
        fileMenu.add((IAction)this.propertiesAction);
        fileMenu.add((IContributionItem)new Separator());
        Action closeAction = new Action(){

            public void run() {
                ConfigurationManagerWindow.this.close();
            }
        };
        closeAction.setText(UpdateUI.getString("ConfigurationManagerWindow.close"));
        fileMenu.add((IAction)closeAction);
    }

    private void hookGlobalActions() {
        if (this.propertiesActionHandler != null) {
            this.propertiesAction.setActionHandler(this.propertiesActionHandler);
        }
    }

    protected Control createContents(Composite parent) {
        this.view = new ConfigurationView(this);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        Label separator = new Label(container, 258);
        GridData gd = new GridData(256);
        gd.heightHint = 1;
        separator.setLayoutData((Object)gd);
        this.view.createPartControl(container);
        Control viewControl = this.view.getControl();
        gd = new GridData(1808);
        viewControl.setLayoutData((Object)gd);
        this.hookGlobalActions();
        this.updateActionBars();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            this.view.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)localSite));
        }
        catch (CoreException e) {
            // empty catch block
        }
        UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
        this.getShell().setImage(provider.get(UpdateUIImages.DESC_CONFIGS_VIEW, 0));
        return container;
    }

    private void updateActionBars() {
        this.getMenuBarManager().updateAll(false);
        this.getToolBarManager().update(false);
    }

    public boolean close() {
        if (this.view != null) {
            this.view.dispose();
        }
        return super.close();
    }

    public void create() {
        super.create();
        this.getShell().setText(UpdateUI.getString("ConfigurationManagerAction.title"));
        this.getShell().setSize(800, 600);
    }

    public int open() {
        this.updateActionBars();
        return super.open();
    }

    public void setPropertiesActionHandler(IAction handler) {
        this.propertiesActionHandler = handler;
    }

    class GlobalAction
    extends Action
    implements IPropertyChangeListener {
        private IAction handler;

        public void setActionHandler(IAction action) {
            if (this.handler != null) {
                this.handler.removePropertyChangeListener((IPropertyChangeListener)this);
                this.handler = null;
            }
            if (action != null) {
                this.handler = action;
                action.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            if (this.handler != null) {
                this.setEnabled(this.handler.isEnabled());
                this.setChecked(this.handler.isChecked());
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setEnabled(bool);
            } else if (event.getProperty().equals("checked")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setChecked(bool);
            }
        }

        public void run() {
            if (this.handler != null) {
                this.handler.run();
            }
        }
    }
}

