/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class NewTypeWizardPage
extends NewContainerWizardPage {
    public int F_PUBLIC = 1;
    public int F_PRIVATE = 2;
    public int F_PROTECTED = 4;
    public int F_STATIC = 8;
    public int F_FINAL = 16;
    public int F_ABSTRACT = 1024;
    private static final String PAGE_NAME = "NewTypeWizardPage";
    protected static final String PACKAGE = "NewTypeWizardPage.package";
    protected static final String ENCLOSING = "NewTypeWizardPage.enclosing";
    protected static final String ENCLOSINGSELECTION = "NewTypeWizardPage.enclosing.selection";
    protected static final String TYPENAME = "NewTypeWizardPage.typename";
    protected static final String SUPER = "NewTypeWizardPage.superclass";
    protected static final String INTERFACES = "NewTypeWizardPage.interfaces";
    protected static final String MODIFIERS = "NewTypeWizardPage.modifiers";
    protected static final String METHODS = "NewTypeWizardPage.methods";
    private StringButtonStatusDialogField fPackageDialogField;
    private SelectionButtonDialogField fEnclosingTypeSelection;
    private StringButtonDialogField fEnclosingTypeDialogField;
    private boolean fCanModifyPackage;
    private boolean fCanModifyEnclosingType;
    private IPackageFragment fCurrPackage;
    private IType fCurrEnclosingType;
    private StringDialogField fTypeNameDialogField;
    private StringButtonDialogField fSuperClassDialogField;
    private ListDialogField fSuperInterfacesDialogField;
    private IType fSuperClass;
    private SelectionButtonDialogFieldGroup fAccMdfButtons;
    private SelectionButtonDialogFieldGroup fOtherMdfButtons;
    private IType fCreatedType = null;
    private JavaPackageCompletionProcessor fCurrPackageCompletionProcessor;
    private JavaTypeCompletionProcessor fEnclosingTypeCompletionProcessor;
    private JavaTypeCompletionProcessor fSuperClassCompletionProcessor;
    protected IStatus fEnclosingTypeStatus;
    protected IStatus fPackageStatus;
    protected IStatus fTypeNameStatus;
    protected IStatus fSuperClassStatus;
    protected IStatus fModifierStatus;
    protected IStatus fSuperInterfacesStatus;
    private boolean fIsClass;
    private final int PUBLIC_INDEX = 0;
    private final int DEFAULT_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int PROTECTED_INDEX = 3;
    private final int ABSTRACT_INDEX = 0;
    private final int FINAL_INDEX = 1;
    private final int STATIC_INDEX = 2;

    public NewTypeWizardPage(boolean isClass, String pageName) {
        super(pageName);
        this.fIsClass = isClass;
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fPackageDialogField = new StringButtonStatusDialogField(adapter);
        this.fPackageDialogField.setDialogFieldListener(adapter);
        this.fPackageDialogField.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.package.label"));
        this.fPackageDialogField.setButtonLabel(NewWizardMessages.getString("NewTypeWizardPage.package.button"));
        this.fPackageDialogField.setStatusWidthHint(NewWizardMessages.getString("NewTypeWizardPage.default"));
        this.fEnclosingTypeSelection = new SelectionButtonDialogField(32);
        this.fEnclosingTypeSelection.setDialogFieldListener(adapter);
        this.fEnclosingTypeSelection.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.enclosing.selection.label"));
        this.fEnclosingTypeDialogField = new StringButtonDialogField(adapter);
        this.fEnclosingTypeDialogField.setDialogFieldListener(adapter);
        this.fEnclosingTypeDialogField.setButtonLabel(NewWizardMessages.getString("NewTypeWizardPage.enclosing.button"));
        this.fTypeNameDialogField = new StringDialogField();
        this.fTypeNameDialogField.setDialogFieldListener(adapter);
        this.fTypeNameDialogField.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.typename.label"));
        this.fSuperClassDialogField = new StringButtonDialogField(adapter);
        this.fSuperClassDialogField.setDialogFieldListener(adapter);
        this.fSuperClassDialogField.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.superclass.label"));
        this.fSuperClassDialogField.setButtonLabel(NewWizardMessages.getString("NewTypeWizardPage.superclass.button"));
        String[] addButtons = new String[]{NewWizardMessages.getString("NewTypeWizardPage.interfaces.add"), null, NewWizardMessages.getString("NewTypeWizardPage.interfaces.remove")};
        this.fSuperInterfacesDialogField = new ListDialogField(adapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setDialogFieldListener(adapter);
        String interfaceLabel = this.fIsClass ? NewWizardMessages.getString("NewTypeWizardPage.interfaces.class.label") : NewWizardMessages.getString("NewTypeWizardPage.interfaces.ifc.label");
        this.fSuperInterfacesDialogField.setLabelText(interfaceLabel);
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
        String[] buttonNames1 = new String[]{NewWizardMessages.getString("NewTypeWizardPage.modifiers.public"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.default"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.private"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.protected")};
        this.fAccMdfButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.setLabelText(NewWizardMessages.getString("NewTypeWizardPage.modifiers.acc.label"));
        this.fAccMdfButtons.setSelection(0, true);
        String[] buttonNames2 = this.fIsClass ? new String[]{NewWizardMessages.getString("NewTypeWizardPage.modifiers.abstract"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.final"), NewWizardMessages.getString("NewTypeWizardPage.modifiers.static")} : new String[]{};
        this.fOtherMdfButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 4);
        this.fOtherMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.enableSelectionButton(2, false);
        this.fAccMdfButtons.enableSelectionButton(3, false);
        this.fOtherMdfButtons.enableSelectionButton(2, false);
        this.fCurrPackageCompletionProcessor = new JavaPackageCompletionProcessor();
        this.fEnclosingTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this.fSuperClassCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this.fPackageStatus = new StatusInfo();
        this.fEnclosingTypeStatus = new StatusInfo();
        this.fCanModifyPackage = true;
        this.fCanModifyEnclosingType = true;
        this.updateEnableState();
        this.fTypeNameStatus = new StatusInfo();
        this.fSuperClassStatus = new StatusInfo();
        this.fSuperInterfacesStatus = new StatusInfo();
        this.fModifierStatus = new StatusInfo();
    }

    protected void initTypePage(IJavaElement elem) {
        String text;
        String initSuperclass = "java.lang.Object";
        ArrayList<String> initSuperinterfaces = new ArrayList<String>(5);
        IPackageFragment pack = null;
        IType enclosingType = null;
        if (elem != null) {
            pack = (IPackageFragment)elem.getAncestor(4);
            IType typeInCU = (IType)elem.getAncestor(7);
            if (typeInCU != null) {
                if (typeInCU.getCompilationUnit() != null) {
                    enclosingType = typeInCU;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
                if (cu != null) {
                    enclosingType = cu.findPrimaryType();
                }
            }
            try {
                IType type = null;
                if (elem.getElementType() == 7 && (type = (IType)elem).exists()) {
                    String superName = JavaModelUtil.getFullyQualifiedName(type);
                    if (type.isInterface()) {
                        initSuperinterfaces.add(superName);
                    } else {
                        initSuperclass = superName;
                    }
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        String typeName = "";
        ITextSelection selection = this.getCurrentTextSelection();
        if (selection != null && JavaConventions.validateJavaTypeName((String)(text = selection.getText())).isOK()) {
            typeName = text;
        }
        this.setPackageFragment(pack, true);
        this.setEnclosingType(enclosingType, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName(typeName, true);
        this.setSuperClass(initSuperclass, true);
        this.setSuperInterfaces(initSuperinterfaces, true);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fCurrPackageCompletionProcessor);
    }

    protected void createEnclosingTypeControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fEnclosingTypeSelection.doFillIntoGrid(tabGroup, 1);
        Text text = this.fEnclosingTypeDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        Button button = this.fEnclosingTypeDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeightHint(button);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fEnclosingTypeCompletionProcessor);
    }

    protected void createTypeNameControls(Composite composite, int nColumns) {
        this.fTypeNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fTypeNameDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccMdfButtons.getLabelControl(composite), 1);
        Composite control = this.fAccMdfButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
        if (this.fIsClass) {
            DialogField.createEmptySpace(composite);
            control = this.fOtherMdfButtons.getSelectionButtonsGroup(composite);
            gd = new GridData(256);
            gd.horizontalSpan = nColumns - 2;
            control.setLayoutData((Object)gd);
            DialogField.createEmptySpace(composite);
        }
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.fSuperClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fSuperClassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        ControlContentAssistHelper.createTextContentAssistant(text, this.fSuperClassCompletionProcessor);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.fIsClass ? this.convertHeightInCharsToPixels(3) : this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    protected void setFocus() {
        this.fTypeNameDialogField.setFocus();
    }

    private void typePageChangeControlPressed(DialogField field) {
        IType type;
        if (field == this.fPackageDialogField) {
            IPackageFragment pack = this.choosePackage();
            if (pack != null) {
                this.fPackageDialogField.setText(pack.getElementName());
            }
        } else if (field == this.fEnclosingTypeDialogField) {
            IType type2 = this.chooseEnclosingType();
            if (type2 != null) {
                this.fEnclosingTypeDialogField.setText(JavaModelUtil.getFullyQualifiedName(type2));
            }
        } else if (field == this.fSuperClassDialogField && (type = this.chooseSuperType()) != null) {
            this.fSuperClassDialogField.setText(JavaModelUtil.getFullyQualifiedName(type));
        }
    }

    private void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSuperInterfacesDialogField) {
            this.chooseSuperInterfaces();
        }
    }

    private void typePageDialogFieldChanged(DialogField field) {
        String fieldName = null;
        if (field == this.fPackageDialogField) {
            this.fPackageStatus = this.packageChanged();
            this.updatePackageStatusLabel();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = PACKAGE;
        } else if (field == this.fEnclosingTypeDialogField) {
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSING;
        } else if (field == this.fEnclosingTypeSelection) {
            this.updateEnableState();
            boolean isEnclosedType = this.isEnclosingTypeSelected();
            if (!isEnclosedType) {
                if (this.fAccMdfButtons.isSelected(2) || this.fAccMdfButtons.isSelected(3)) {
                    this.fAccMdfButtons.setSelection(2, false);
                    this.fAccMdfButtons.setSelection(3, false);
                    this.fAccMdfButtons.setSelection(0, true);
                }
                if (this.fOtherMdfButtons.isSelected(2)) {
                    this.fOtherMdfButtons.setSelection(2, false);
                }
            }
            this.fAccMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fAccMdfButtons.enableSelectionButton(3, isEnclosedType);
            this.fOtherMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSINGSELECTION;
        } else if (field == this.fTypeNameDialogField) {
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = TYPENAME;
        } else if (field == this.fSuperClassDialogField) {
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = SUPER;
        } else if (field == this.fSuperInterfacesDialogField) {
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
            fieldName = INTERFACES;
        } else if (field == this.fOtherMdfButtons || field == this.fAccMdfButtons) {
            this.fModifierStatus = this.modifiersChanged();
            fieldName = MODIFIERS;
        } else {
            fieldName = METHODS;
        }
        this.handleFieldChanged(fieldName);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
        }
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public String getEnclosingTypeText() {
        return this.fEnclosingTypeDialogField.getText();
    }

    public IPackageFragment getPackageFragment() {
        if (!this.isEnclosingTypeSelected()) {
            return this.fCurrPackage;
        }
        if (this.fCurrEnclosingType != null) {
            return this.fCurrEnclosingType.getPackageFragment();
        }
        return null;
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        this.fCurrPackage = pack;
        this.fCanModifyPackage = canBeModified;
        String str = pack == null ? "" : pack.getElementName();
        this.fPackageDialogField.setText(str);
        this.updateEnableState();
    }

    public IType getEnclosingType() {
        if (this.isEnclosingTypeSelected()) {
            return this.fCurrEnclosingType;
        }
        return null;
    }

    public void setEnclosingType(IType type, boolean canBeModified) {
        this.fCurrEnclosingType = type;
        this.fCanModifyEnclosingType = canBeModified;
        String str = type == null ? "" : JavaModelUtil.getFullyQualifiedName(type);
        this.fEnclosingTypeDialogField.setText(str);
        this.updateEnableState();
    }

    public boolean isEnclosingTypeSelected() {
        return this.fEnclosingTypeSelection.isSelected();
    }

    public void setEnclosingTypeSelection(boolean isSelected, boolean canBeModified) {
        this.fEnclosingTypeSelection.setSelection(isSelected);
        this.fEnclosingTypeSelection.setEnabled(canBeModified);
        this.updateEnableState();
    }

    public String getTypeName() {
        return this.fTypeNameDialogField.getText();
    }

    public void setTypeName(String name, boolean canBeModified) {
        this.fTypeNameDialogField.setText(name);
        this.fTypeNameDialogField.setEnabled(canBeModified);
    }

    public int getModifiers() {
        int mdf = 0;
        if (this.fAccMdfButtons.isSelected(0)) {
            mdf += this.F_PUBLIC;
        } else if (this.fAccMdfButtons.isSelected(2)) {
            mdf += this.F_PRIVATE;
        } else if (this.fAccMdfButtons.isSelected(3)) {
            mdf += this.F_PROTECTED;
        }
        if (this.fOtherMdfButtons.isSelected(0)) {
            mdf += this.F_ABSTRACT;
        }
        if (this.fOtherMdfButtons.isSelected(1)) {
            mdf += this.F_FINAL;
        }
        if (this.fOtherMdfButtons.isSelected(2)) {
            mdf += this.F_STATIC;
        }
        return mdf;
    }

    public void setModifiers(int modifiers, boolean canBeModified) {
        if (Flags.isPublic((int)modifiers)) {
            this.fAccMdfButtons.setSelection(0, true);
        } else if (Flags.isPrivate((int)modifiers)) {
            this.fAccMdfButtons.setSelection(2, true);
        } else if (Flags.isProtected((int)modifiers)) {
            this.fAccMdfButtons.setSelection(3, true);
        } else {
            this.fAccMdfButtons.setSelection(1, true);
        }
        if (Flags.isAbstract((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(0, true);
        }
        if (Flags.isFinal((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(1, true);
        }
        if (Flags.isStatic((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(2, true);
        }
        this.fAccMdfButtons.setEnabled(canBeModified);
        this.fOtherMdfButtons.setEnabled(canBeModified);
    }

    public String getSuperClass() {
        return this.fSuperClassDialogField.getText();
    }

    public void setSuperClass(String name, boolean canBeModified) {
        this.fSuperClassDialogField.setText(name);
        this.fSuperClassDialogField.setEnabled(canBeModified);
    }

    public List getSuperInterfaces() {
        return this.fSuperInterfacesDialogField.getElements();
    }

    public void setSuperInterfaces(List interfacesNames, boolean canBeModified) {
        this.fSuperInterfacesDialogField.setElements(interfacesNames);
        this.fSuperInterfacesDialogField.setEnabled(canBeModified);
    }

    public IResource getModifiedResource() {
        IType enclosing = this.getEnclosingType();
        if (enclosing != null) {
            return enclosing.getResource();
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            return pack.getCompilationUnit(this.getTypeName() + ".java").getResource();
        }
        return null;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        this.fCurrPackageCompletionProcessor.setPackageFragmentRoot(this.getPackageFragmentRoot());
        if (this.getPackageFragmentRoot() != null) {
            this.fEnclosingTypeCompletionProcessor.setPackageFragment(this.getPackageFragmentRoot().getPackageFragment(""));
        }
        return status;
    }

    protected IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        this.fPackageDialogField.enableButton(this.getPackageFragmentRoot() != null);
        String packName = this.getPackageText();
        if (packName.length() > 0) {
            IStatus val = JavaConventions.validatePackageName((String)packName);
            if (val.getSeverity() == 4) {
                status.setError(NewWizardMessages.getFormattedString("NewTypeWizardPage.error.InvalidPackageName", val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.DiscouragedPackageName", val.getMessage()));
            }
        } else {
            status.setWarning(NewWizardMessages.getString("NewTypeWizardPage.warning.DefaultPackageDiscouraged"));
        }
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            if (root.getJavaProject().exists() && packName.length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = root.getJavaProject().getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals(outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                        status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.ClashOutputLocation"));
                        return status;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            this.fCurrPackage = root.getPackageFragment(packName);
            this.fSuperClassCompletionProcessor.setExtendsCompletionContext(this.fCurrPackage);
        } else {
            status.setError("");
        }
        return status;
    }

    private void updatePackageStatusLabel() {
        String packName = this.getPackageText();
        if (packName.length() == 0) {
            this.fPackageDialogField.setStatus(NewWizardMessages.getString("NewTypeWizardPage.default"));
        } else {
            this.fPackageDialogField.setStatus("");
        }
    }

    private void updateEnableState() {
        boolean enclosing = this.isEnclosingTypeSelected();
        this.fPackageDialogField.setEnabled(this.fCanModifyPackage && !enclosing);
        this.fEnclosingTypeDialogField.setEnabled(this.fCanModifyEnclosingType && enclosing);
    }

    protected IStatus enclosingTypeChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrEnclosingType = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fEnclosingTypeDialogField.enableButton(root != null);
        if (root == null) {
            status.setError("");
            return status;
        }
        String enclName = this.getEnclosingTypeText();
        if (enclName.length() == 0) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.EnclosingTypeEnterName"));
            return status;
        }
        try {
            IType type = this.findType(root.getJavaProject(), enclName);
            if (type == null) {
                status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.EnclosingTypeNotExists"));
                return status;
            }
            if (type.getCompilationUnit() == null) {
                status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.EnclosingNotInCU"));
                return status;
            }
            if (!JavaModelUtil.isEditable(type.getCompilationUnit())) {
                status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.EnclosingNotEditable"));
                return status;
            }
            this.fCurrEnclosingType = type;
            IPackageFragmentRoot enclosingRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)type);
            if (!enclosingRoot.equals(root)) {
                status.setWarning(NewWizardMessages.getString("NewTypeWizardPage.warning.EnclosingNotInSourceFolder"));
            }
            return status;
        }
        catch (JavaModelException e) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.EnclosingTypeNotExists"));
            JavaPlugin.log(e);
            return status;
        }
    }

    protected IStatus typeNameChanged() {
        StatusInfo status = new StatusInfo();
        String typeName = this.getTypeName();
        if (typeName.length() == 0) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.EnterTypeName"));
            return status;
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.QualifiedName"));
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)typeName);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getFormattedString("NewTypeWizardPage.error.InvalidTypeName", val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.TypeNameDiscouraged", val.getMessage()));
        }
        if (!this.isEnclosingTypeSelected()) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack != null) {
                ICompilationUnit cu = pack.getCompilationUnit(typeName + ".java");
                IResource resource = cu.getResource();
                if (resource.exists()) {
                    status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.TypeNameExists"));
                    return status;
                }
                IPath location = resource.getLocation();
                if (location != null && location.toFile().exists()) {
                    status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.TypeNameExistsDifferentCase"));
                    return status;
                }
            }
        } else {
            IType member;
            IType type = this.getEnclosingType();
            if (type != null && (member = type.getType(typeName)).exists()) {
                status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.TypeNameExists"));
                return status;
            }
        }
        return status;
    }

    protected IStatus superClassChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperClassDialogField.enableButton(root != null);
        this.fSuperClass = null;
        String sclassName = this.getSuperClass();
        if (sclassName.length() == 0) {
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)sclassName);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.InvalidSuperClassName"));
            return status;
        }
        if (root != null) {
            try {
                IType type = this.resolveSuperTypeName(root.getJavaProject(), sclassName);
                if (type == null) {
                    status.setWarning(NewWizardMessages.getString("NewTypeWizardPage.warning.SuperClassNotExists"));
                    return status;
                }
                if (type.isInterface()) {
                    status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.SuperClassIsNotClass", sclassName));
                    return status;
                }
                int flags = type.getFlags();
                if (Flags.isFinal((int)flags)) {
                    status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.SuperClassIsFinal", sclassName));
                    return status;
                }
                if (!JavaModelUtil.isVisible((IMember)type, this.getPackageFragment())) {
                    status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.SuperClassIsNotVisible", sclassName));
                    return status;
                }
                this.fSuperClass = type;
            }
            catch (JavaModelException e) {
                status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.InvalidSuperClassName"));
                JavaPlugin.log(e);
            }
        } else {
            status.setError("");
        }
        return status;
    }

    private IType resolveSuperTypeName(IJavaProject jproject, String sclassName) throws JavaModelException {
        if (!jproject.exists()) {
            return null;
        }
        IType type = null;
        if (this.isEnclosingTypeSelected()) {
            String[][] res;
            IType enclosingType = this.getEnclosingType();
            if (enclosingType != null && (res = enclosingType.resolveType(sclassName)) != null && res.length > 0) {
                type = jproject.findType(res[0][0], res[0][1]);
            }
        } else {
            IPackageFragment currPack = this.getPackageFragment();
            if (type == null && currPack != null) {
                String packName = currPack.getElementName();
                if (!currPack.isDefaultPackage()) {
                    type = jproject.findType(packName, sclassName);
                }
                if (type == null && !"java.lang".equals(packName)) {
                    type = jproject.findType("java.lang", sclassName);
                }
            }
            if (type == null) {
                type = jproject.findType(sclassName);
            }
        }
        return type;
    }

    private IType findType(IJavaProject project, String typeName) throws JavaModelException {
        if (project.exists()) {
            return project.findType(typeName);
        }
        return null;
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperInterfacesDialogField.enableButton(0, root != null);
        if (root != null) {
            List elements = this.fSuperInterfacesDialogField.getElements();
            int nElements = elements.size();
            for (int i = 0; i < nElements; ++i) {
                String intfname = (String)elements.get(i);
                try {
                    IType type = this.findType(root.getJavaProject(), intfname);
                    if (type == null) {
                        status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.InterfaceNotExists", intfname));
                        return status;
                    }
                    if (type.isClass()) {
                        status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.InterfaceIsNotInterface", intfname));
                        return status;
                    }
                    if (!JavaModelUtil.isVisible((IMember)type, this.getPackageFragment())) {
                        status.setWarning(NewWizardMessages.getFormattedString("NewTypeWizardPage.warning.InterfaceIsNotVisible", intfname));
                        return status;
                    }
                    continue;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        return status;
    }

    protected IStatus modifiersChanged() {
        StatusInfo status = new StatusInfo();
        int modifiers = this.getModifiers();
        if (Flags.isFinal((int)modifiers) && Flags.isAbstract((int)modifiers)) {
            status.setError(NewWizardMessages.getString("NewTypeWizardPage.error.ModifiersFinalAndAbstract"));
        }
        return status;
    }

    private IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.getString("NewTypeWizardPage.ChoosePackageDialog.title"));
        dialog.setMessage(NewWizardMessages.getString("NewTypeWizardPage.ChoosePackageDialog.description"));
        dialog.setEmptyListMessage(NewWizardMessages.getString("NewTypeWizardPage.ChoosePackageDialog.empty"));
        dialog.setElements(packages);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    private IType chooseEnclosingType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root});
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 0, scope);
        dialog.setTitle(NewWizardMessages.getString("NewTypeWizardPage.ChooseEnclosingTypeDialog.title"));
        dialog.setMessage(NewWizardMessages.getString("NewTypeWizardPage.ChooseEnclosingTypeDialog.description"));
        dialog.setFilter(Signature.getSimpleName((String)this.getEnclosingTypeText()));
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IType chooseSuperType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        TypeSelectionDialog dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 5, scope);
        dialog.setTitle(NewWizardMessages.getString("NewTypeWizardPage.SuperClassDialog.title"));
        dialog.setMessage(NewWizardMessages.getString("NewTypeWizardPage.SuperClassDialog.message"));
        dialog.setFilter(this.getSuperClass());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private void chooseSuperInterfaces() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject project = root.getJavaProject();
        SuperInterfaceSelectionDialog dialog = new SuperInterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.fSuperInterfacesDialogField, project);
        dialog.setTitle(this.fIsClass ? NewWizardMessages.getString("NewTypeWizardPage.InterfacesDialog.class.title") : NewWizardMessages.getString("NewTypeWizardPage.InterfacesDialog.interface.title"));
        dialog.setMessage(NewWizardMessages.getString("NewTypeWizardPage.InterfacesDialog.message"));
        dialog.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        block17: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(NewWizardMessages.getString("NewTypeWizardPage.operationdesc"), 10);
            ICompilationUnit createdWorkingCopy = null;
            try {
                IType createdType;
                ImportsManager imports;
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                IPackageFragment pack = this.getPackageFragment();
                if (pack == null) {
                    pack = root.getPackageFragment("");
                }
                if (!pack.exists()) {
                    String packName = pack.getElementName();
                    pack = root.createPackageFragment(packName, true, null);
                }
                monitor.worked(1);
                String clName = this.getTypeName();
                boolean isInnerClass = this.isEnclosingTypeSelected();
                int indent = 0;
                String lineDelimiter = null;
                if (!isInnerClass) {
                    lineDelimiter = System.getProperty("line.separator", "\n");
                    ICompilationUnit parentCU = pack.createCompilationUnit(clName + ".java", "", false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    createdWorkingCopy = parentCU.getWorkingCopy(null);
                    String content = CodeGeneration.getCompilationUnitContent(createdWorkingCopy, null, "", lineDelimiter);
                    if (content != null) {
                        createdWorkingCopy.getBuffer().setContents(content);
                    }
                    imports = new ImportsManager(createdWorkingCopy);
                    imports.addImport(JavaModelUtil.concatenateName(pack.getElementName(), this.getTypeName()));
                    String typeContent = this.constructTypeStub(imports, lineDelimiter);
                    String cuContent = this.constructCUContent(parentCU, typeContent, lineDelimiter);
                    createdWorkingCopy.getBuffer().setContents(cuContent);
                    createdType = createdWorkingCopy.getType(clName);
                } else {
                    String comment;
                    IType enclosingType = this.getEnclosingType();
                    ICompilationUnit parentCU = enclosingType.getCompilationUnit();
                    imports = new ImportsManager(parentCU);
                    IType[] topLevelTypes = parentCU.getTypes();
                    for (int i = 0; i < topLevelTypes.length; ++i) {
                        imports.addImport(topLevelTypes[i].getFullyQualifiedName('.'));
                    }
                    lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)enclosingType);
                    StringBuffer content = new StringBuffer();
                    if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc") && (comment = this.getTypeComment(parentCU, lineDelimiter)) != null) {
                        content.append(comment);
                        content.append(lineDelimiter);
                    }
                    content.append(this.constructTypeStub(imports, lineDelimiter));
                    IJavaElement[] elems = enclosingType.getChildren();
                    IJavaElement sibling = elems.length > 0 ? elems[0] : null;
                    createdType = enclosingType.createType(content.toString(), sibling, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    indent = StubUtility.getIndentUsed((IJavaElement)enclosingType) + 1;
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ICompilationUnit cu = createdType.getCompilationUnit();
                boolean needsSave = !cu.isWorkingCopy();
                imports.create(needsSave, new SubProgressMonitor(monitor, 1));
                JavaModelUtil.reconcile(cu);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                imports = new ImportsManager(imports.getCompilationUnit(), imports.getAddedTypes());
                this.createTypeMembers(createdType, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                imports.create(needsSave, new SubProgressMonitor(monitor, 1));
                this.removeUnusedImports(cu, imports.getAddedTypes(), needsSave);
                JavaModelUtil.reconcile(cu);
                ISourceRange range = createdType.getSourceRange();
                IBuffer buf = cu.getBuffer();
                String originalContent = buf.getText(range.getOffset(), range.getLength());
                String formattedContent = CodeFormatterUtil.format(4, originalContent, indent, null, lineDelimiter, pack.getJavaProject());
                buf.replace(range.getOffset(), range.getLength(), formattedContent);
                if (!isInnerClass) {
                    String fileComment = this.getFileComment(cu);
                    if (fileComment != null && fileComment.length() > 0) {
                        buf.replace(0, 0, fileComment + lineDelimiter);
                    }
                    cu.commitWorkingCopy(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    if (needsSave) {
                        buf.save(null, false);
                    }
                    monitor.worked(1);
                }
                this.fCreatedType = createdWorkingCopy != null ? (IType)createdType.getPrimaryElement() : createdType;
                Object var19_20 = null;
                if (createdWorkingCopy == null) break block17;
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                if (createdWorkingCopy != null) {
                    createdWorkingCopy.discardWorkingCopy();
                }
                monitor.done();
                throw throwable;
            }
            createdWorkingCopy.discardWorkingCopy();
        }
        monitor.done();
    }

    private void removeUnusedImports(ICompilationUnit cu, Set addedTypes, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        IProblem[] problems = root.getProblems();
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < problems.length; ++i) {
            int id = problems[i].getID();
            if (id != 268435844 && id != 268435847) continue;
            String imp = problems[i].getArguments()[0];
            res.add(imp);
        }
        if (!res.isEmpty()) {
            ImportsManager imports = new ImportsManager(cu, addedTypes);
            for (int i = 0; i < res.size(); ++i) {
                String curr = (String)res.get(i);
                imports.removeImport(curr);
            }
            imports.create(needsSave, null);
        }
    }

    protected String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String typeComment = this.getTypeComment(cu, lineDelimiter);
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent(cu, typeComment, typeContent, lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuffer buf = new StringBuffer();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        if (typeComment != null) {
            buf.append(typeComment).append(lineDelimiter);
        }
        buf.append(typeContent);
        return buf.toString();
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    private void writeSuperClass(StringBuffer buf, ImportsManager imports) {
        String typename = this.getSuperClass();
        if (this.fIsClass && typename.length() > 0 && !"java.lang.Object".equals(typename)) {
            buf.append(" extends ");
            String qualifiedName = this.fSuperClass != null ? JavaModelUtil.getFullyQualifiedName(this.fSuperClass) : typename;
            buf.append(imports.addImport(qualifiedName));
        }
    }

    private void writeSuperInterfaces(StringBuffer buf, ImportsManager imports) {
        List interfaces = this.getSuperInterfaces();
        int last = interfaces.size() - 1;
        if (last >= 0) {
            if (this.fIsClass) {
                buf.append(" implements ");
            } else {
                buf.append(" extends ");
            }
            for (int i = 0; i <= last; ++i) {
                String typename = (String)interfaces.get(i);
                buf.append(imports.addImport(typename));
                if (i >= last) continue;
                buf.append(',');
            }
        }
    }

    private String constructTypeStub(ImportsManager imports, String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        int modifiers = this.getModifiers();
        buf.append(Flags.toString((int)modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        buf.append(this.fIsClass ? "class " : "interface ");
        buf.append(this.getTypeName());
        this.writeSuperClass(buf, imports);
        this.writeSuperInterfaces(buf, imports);
        buf.append('{');
        buf.append(lineDelimiter);
        buf.append(lineDelimiter);
        buf.append('}');
        buf.append(lineDelimiter);
        return buf.toString();
    }

    protected void createTypeMembers(IType newType, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createTypeMembers(newType, (IImportsStructure)imports, monitor);
    }

    protected void createTypeMembers(IType newType, IImportsStructure imports, IProgressMonitor monitor) throws CoreException {
    }

    protected String getFileComment(ICompilationUnit parentCU) {
        return null;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment(next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    protected String getTypeComment(ICompilationUnit parentCU, String lineDelimiter) {
        try {
            StringBuffer typeName = new StringBuffer();
            if (this.isEnclosingTypeSelected()) {
                typeName.append(JavaModelUtil.getTypeQualifiedName(this.getEnclosingType())).append('.');
            }
            typeName.append(this.getTypeName());
            String comment = CodeGeneration.getTypeComment(parentCU, typeName.toString(), lineDelimiter);
            if (comment != null && this.isValidComment(comment)) {
                return comment;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    protected String getTypeComment(ICompilationUnit parentCU) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc")) {
            return this.getTypeComment(parentCU, String.valueOf('\n'));
        }
        return null;
    }

    protected String getTemplate(String name, ICompilationUnit parentCU) {
        return this.getTemplate(name, parentCU, 0);
    }

    protected String getTemplate(String name, ICompilationUnit parentCU, int pos) {
        try {
            Template template = JavaPlugin.getDefault().getTemplateStore().findTemplate(name);
            if (template != null) {
                return JavaContext.evaluateTemplate(template, parentCU, pos);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (TemplateException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    protected IMethod[] createInheritedMethods(IType type, boolean doConstructors, boolean doUnimplementedMethods, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        String[] constructors;
        IType superclass;
        ArrayList<String> newMethods = new ArrayList<String>();
        ITypeHierarchy hierarchy = null;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (doConstructors && (superclass = (hierarchy = type.newSupertypeHierarchy(monitor)).getSuperclass(type)) != null && (constructors = StubUtility.evalConstructors(type, superclass, settings, imports)) != null) {
            for (int i = 0; i < constructors.length; ++i) {
                newMethods.add(constructors[i]);
            }
        }
        if (doUnimplementedMethods) {
            String[] unimplemented;
            if (hierarchy == null) {
                hierarchy = type.newSupertypeHierarchy(monitor);
            }
            if ((unimplemented = StubUtility.evalUnimplementedMethods(type, hierarchy, false, settings, imports)) != null) {
                for (int i = 0; i < unimplemented.length; ++i) {
                    newMethods.add(unimplemented[i]);
                }
            }
        }
        IMethod[] createdMethods = new IMethod[newMethods.size()];
        for (int i = 0; i < newMethods.size(); ++i) {
            String content = (String)newMethods.get(i) + '\n';
            createdMethods[i] = type.createMethod(content, null, false, null);
        }
        return createdMethods;
    }

    protected IMethod[] createInheritedMethods(IType type, boolean doConstructors, boolean doUnimplementedMethods, IImportsStructure imports, IProgressMonitor monitor) throws CoreException {
        return this.createInheritedMethods(type, doConstructors, doUnimplementedMethods, new ImportsManager(imports), monitor);
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    NewTypeWizardPage.this.createType(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewTypeWizardPage.this.typePageChangeControlPressed(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NewTypeWizardPage.this.typePageCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewTypeWizardPage.this.typePageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get("org.eclipse.jdt.ui.int_obj.gif");

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    public static class ImportsManager
    implements IImportsStructure {
        private ImportsStructure fImportsStructure;
        private Set fAddedTypes;

        ImportsManager(IImportsStructure importsStructure) {
            this.fImportsStructure = (ImportsStructure)importsStructure;
        }

        ImportsManager(ICompilationUnit createdWorkingCopy) throws CoreException {
            this(createdWorkingCopy, new HashSet());
        }

        ImportsManager(ICompilationUnit createdWorkingCopy, Set addedTypes) throws CoreException {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference(store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold(store);
            this.fAddedTypes = addedTypes;
            this.fImportsStructure = new ImportsStructure(createdWorkingCopy, prefOrder, threshold, true);
        }

        ICompilationUnit getCompilationUnit() {
            return this.fImportsStructure.getCompilationUnit();
        }

        public String addImport(String qualifiedTypeName) {
            this.fAddedTypes.add(qualifiedTypeName);
            return this.fImportsStructure.addImport(qualifiedTypeName);
        }

        void create(boolean needsSave, SubProgressMonitor monitor) throws CoreException {
            this.fImportsStructure.create(needsSave, (IProgressMonitor)monitor);
        }

        void removeImport(String qualifiedName) {
            if (this.fAddedTypes.contains(qualifiedName)) {
                this.fImportsStructure.removeImport(qualifiedName);
            }
        }

        Set getAddedTypes() {
            return this.fAddedTypes;
        }
    }
}

