/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.internal.ui.util.ISelectionConverter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ViewSiteDecorator
extends PlatformObject
implements IViewSite {
    private IViewSite fViewSite;
    private ISelectionConverter fSelectionConverter;
    private ISelectionProvider fSelectionProvider;

    public ViewSiteDecorator(IViewSite site, ISelectionConverter converter) {
        this.fViewSite = site;
        this.fSelectionConverter = converter;
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider != null) {
            this.fSelectionProvider = new SelectionProviderDecorator(provider);
        }
    }

    public IActionBars getActionBars() {
        return this.fViewSite.getActionBars();
    }

    public String getId() {
        return this.fViewSite.getId();
    }

    public IKeyBindingService getKeyBindingService() {
        return this.fViewSite.getKeyBindingService();
    }

    public String getPluginId() {
        return this.fViewSite.getPluginId();
    }

    public String getRegisteredName() {
        return this.fViewSite.getRegisteredName();
    }

    public String getSecondaryId() {
        return this.fViewSite.getSecondaryId();
    }

    public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
        this.fViewSite.registerContextMenu(menuId, menuManager, selectionProvider);
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        this.fViewSite.registerContextMenu(menuManager, selectionProvider);
    }

    public IWorkbenchPage getPage() {
        return this.fViewSite.getPage();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public Shell getShell() {
        return this.fViewSite.getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.fViewSite.getWorkbenchWindow();
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        throw new UnsupportedOperationException();
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        ListenerList fListeners = new ListenerList();

        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = ViewSiteDecorator.this.fSelectionConverter.convert(event.getSelection());
            SelectionChangedEvent newEvent = new SelectionChangedEvent(ViewSiteDecorator.this.fSelectionProvider, selection);
            Object[] listeners = this.fListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(newEvent);
            }
        }

        public void addListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public void removeListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public boolean isEmpty() {
            return this.fListeners.isEmpty();
        }
    }

    private class SelectionProviderDecorator
    implements ISelectionProvider {
        private ISelectionProvider fProvider;
        private SelectionChangedListener fListener;

        public SelectionProviderDecorator(ISelectionProvider provider) {
            this.fProvider = provider;
        }

        public ISelection getSelection() {
            return ViewSiteDecorator.this.fSelectionConverter.convert(this.fProvider.getSelection());
        }

        public void setSelection(ISelection selection) {
            throw new UnsupportedOperationException();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.fListener == null) {
                this.fListener = new SelectionChangedListener();
                this.fProvider.addSelectionChangedListener((ISelectionChangedListener)this.fListener);
            }
            this.fListener.addListener(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.fListener == null) {
                return;
            }
            this.fListener.removeListener(listener);
            if (this.fListener.isEmpty()) {
                this.fProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fListener);
                this.fListener = null;
            }
        }
    }
}

