/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.ColorDecoratingLabelProvider;
import org.eclipse.jdt.internal.ui.search.FilterAction;
import org.eclipse.jdt.internal.ui.search.FiltersDialogAction;
import org.eclipse.jdt.internal.ui.search.GroupAction;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.jdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.jdt.internal.ui.search.JavaSearchEditorOpener;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchTableContentProvider;
import org.eclipse.jdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.jdt.internal.ui.search.MatchFilter;
import org.eclipse.jdt.internal.ui.search.NameSorter;
import org.eclipse.jdt.internal.ui.search.NewSearchViewActionGroup;
import org.eclipse.jdt.internal.ui.search.ParentSorter;
import org.eclipse.jdt.internal.ui.search.PathSorter;
import org.eclipse.jdt.internal.ui.search.PostfixLabelProvider;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SortAction;
import org.eclipse.jdt.internal.ui.search.SortingLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private static final String KEY_GROUPING = "org.eclipse.jdt.search.resultpage.grouping";
    private static final String KEY_SORTING = "org.eclipse.jdt.search.resultpage.sorting";
    private static final String KEY_FILTERS = "org.eclipse.jdt.search.resultpage.filters";
    private static final String KEY_LIMIT_ENABLED = "org.eclipse.jdt.search.resultpage.limit_enabled";
    private static final String KEY_LIMIT = "org.eclipse.jdt.search.resultpage.limit";
    private static final String GROUP_GROUPING = "org.eclipse.jdt.search.resultpage.grouping";
    private static final String GROUP_FILTERING = "org.eclipse.jdt.search.resultpage.filtering";
    private NewSearchViewActionGroup fActionGroup;
    private JavaSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByParentName;
    private SortAction fSortByPathAction;
    private GroupAction fGroupTypeAction;
    private GroupAction fGroupFileAction;
    private GroupAction fGroupPackageAction;
    private GroupAction fGroupProjectAction;
    private int fCurrentGrouping;
    private Set fMatchFilters = new HashSet();
    private FilterAction[] fFilterActions;
    private FiltersDialogAction fFilterDialogAction;
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
    public static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private JavaSearchEditorOpener fEditorOpener = new JavaSearchEditorOpener();
    private boolean fLimitElements = false;
    private int fElementLimit;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInTargetList;

    public JavaSearchResultPage() {
        this.initSortActions();
        this.initGroupingActions();
        this.initFilterActions();
    }

    private void initFilterActions() {
        MatchFilter[] allFilters = MatchFilter.allFilters();
        this.fFilterActions = new FilterAction[allFilters.length];
        for (int i = 0; i < this.fFilterActions.length; ++i) {
            this.fFilterActions[i] = new FilterAction(this, allFilters[i]);
            this.fFilterActions[i].setId("org.eclipse.jdt.search.filters." + i);
        }
        this.fFilterDialogAction = new FiltersDialogAction(this);
        this.fFilterDialogAction.setId("org.eclipse.jdt.search.filters." + allFilters.length);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fFilterDialogAction, "filter_ps.gif");
    }

    private void initSortActions() {
        this.fSortByNameAction = new SortAction(SearchMessages.getString("JavaSearchResultPage.sortByName"), this, 1);
        this.fSortByPathAction = new SortAction(SearchMessages.getString("JavaSearchResultPage.sortByPath"), this, 3);
        this.fSortByParentName = new SortAction(SearchMessages.getString("JavaSearchResultPage.sortByParentName"), this, 2);
    }

    private void initGroupingActions() {
        this.fGroupProjectAction = new GroupAction(SearchMessages.getString("JavaSearchResultPage.groupby_project"), SearchMessages.getString("JavaSearchResultPage.groupby_project.tooltip"), this, 4);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupProjectAction, "prj_mode.gif");
        this.fGroupPackageAction = new GroupAction(SearchMessages.getString("JavaSearchResultPage.groupby_package"), SearchMessages.getString("JavaSearchResultPage.groupby_package.tooltip"), this, 3);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupPackageAction, "package_mode.gif");
        this.fGroupFileAction = new GroupAction(SearchMessages.getString("JavaSearchResultPage.groupby_file"), SearchMessages.getString("JavaSearchResultPage.groupby_file.tooltip"), this, 2);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupFileAction, "file_mode.gif");
        this.fGroupTypeAction = new GroupAction(SearchMessages.getString("JavaSearchResultPage.groupby_type"), SearchMessages.getString("JavaSearchResultPage.groupby_type.tooltip"), this, 1);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupTypeAction, "type_mode.gif");
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewSearchViewActionGroup((IViewPart)part);
    }

    public void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IEditorPart editor;
        try {
            editor = this.fEditorOpener.open(match);
        }
        catch (JavaModelException e) {
            throw new PartInitException(e.getStatus());
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        Object element = match.getElement();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                this.showWithMarker(editor, file, offset, length);
            }
        } else {
            JavaSearchResult result = (JavaSearchResult)this.getInput();
            IMatchPresentation participant = result.getSearchParticpant(element);
            if (participant != null) {
                participant.showMatch(match, offset, length, activate);
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException(SearchMessages.getString("JavaSearchResultPage.error.marker"), (Throwable)e);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.getString("JavaSearchResultPage.sortBylabel"));
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        sortMenu.add((IAction)this.fSortByParentName);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        this.fSortByParentName.setChecked(this.fCurrentSortOrder == this.fSortByParentName.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() != 1) {
            this.addGroupActions(tbm);
        }
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("org.eclipse.jdt.search.resultpage.grouping"));
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupProjectAction);
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupPackageAction);
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupFileAction);
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupTypeAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.fGroupProjectAction.setChecked(this.fCurrentGrouping == 4);
        this.fGroupPackageAction.setChecked(this.fCurrentGrouping == 3);
        this.fGroupFileAction.setChecked(this.fCurrentGrouping == 2);
        this.fGroupTypeAction.setChecked(this.fCurrentGrouping == 1);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new ColorDecoratingLabelProvider((ILabelProvider)new SortingLabelProvider(this), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fContentProvider = new JavaSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.setSortOrder(this.fCurrentSortOrder);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setSorter(new ViewerSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new ColorDecoratingLabelProvider((ILabelProvider)new PostfixLabelProvider(this), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fContentProvider = new LevelTreeContentProvider(this, this.fCurrentGrouping);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new ProblemTreeViewer(parent, 770){

            public void add(Object parentElement, Object[] childElements) {
                if (JavaSearchResultPage.this.limitElements() && parentElement.equals(this.getInput())) {
                    int elementLimit = JavaSearchResultPage.this.getElementLimit();
                    Widget parentWidget = this.findItem(parentElement);
                    if (parentWidget == null) {
                        return;
                    }
                    Item[] children = this.getChildren(parentWidget);
                    if (children.length >= elementLimit) {
                        return;
                    }
                    if (children.length + childElements.length <= elementLimit) {
                        super.add(parentElement, childElements);
                        return;
                    }
                    int toAdd = elementLimit - children.length;
                    Object[] limited = new Object[toAdd];
                    System.arraycopy(childElements, 0, limited, 0, limited.length);
                    super.add(parentElement, limited);
                    return;
                }
                super.add(parentElement, childElements);
            }

            protected Object[] getFilteredChildren(Object parentElement) {
                if (parentElement == null) {
                    return new Object[0];
                }
                Object[] filtered = super.getFilteredChildren(parentElement);
                int elementLimit = JavaSearchResultPage.this.getElementLimit();
                if (JavaSearchResultPage.this.limitElements() && parentElement.equals(this.getInput()) && filtered.length > elementLimit) {
                    Object[] limited = new Object[elementLimit];
                    System.arraycopy(filtered, 0, limited, 0, limited.length);
                    return limited;
                }
                return filtered;
            }
        };
    }

    int getElementLimit() {
        return this.fElementLimit;
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new ProblemTableViewer(parent, 770){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
                this.getTable().setRedraw(false);
                try {
                    super.handleLabelProviderChanged(event);
                }
                finally {
                    this.getTable().setRedraw(true);
                }
            }

            public void add(Object[] elements) {
                if (JavaSearchResultPage.this.limitElements()) {
                    int elementLimit = JavaSearchResultPage.this.getElementLimit();
                    int currentCount = this.getTable().getItemCount();
                    if (currentCount >= elementLimit) {
                        return;
                    }
                    if (currentCount + elements.length <= elementLimit) {
                        super.add(elements);
                        return;
                    }
                    int toAdd = elementLimit - currentCount;
                    Object[] limited = new Object[toAdd];
                    System.arraycopy(elements, 0, limited, 0, limited.length);
                    super.add(limited);
                    return;
                }
                super.add(elements);
            }

            protected Object[] getFilteredChildren(Object parentElement) {
                if (parentElement == null) {
                    return new Object[0];
                }
                Object[] filtered = super.getFilteredChildren(parentElement);
                int elementLimit = JavaSearchResultPage.this.getElementLimit();
                if (JavaSearchResultPage.this.limitElements() && parentElement.equals(this.getInput()) && filtered.length > elementLimit) {
                    Object[] limited = new Object[elementLimit];
                    System.arraycopy(filtered, 0, limited, 0, limited.length);
                    return limited;
                }
                return filtered;
            }
        };
    }

    void setSortOrder(int order) {
        this.fCurrentSortOrder = order;
        StructuredViewer viewer = this.getViewer();
        viewer.getControl().setRedraw(false);
        DecoratingLabelProvider dlp = (DecoratingLabelProvider)viewer.getLabelProvider();
        ((SortingLabelProvider)dlp.getLabelProvider()).setOrder(order);
        if (order == 1) {
            viewer.setSorter((ViewerSorter)new NameSorter());
        } else if (order == 3) {
            viewer.setSorter((ViewerSorter)new PathSorter());
        } else {
            viewer.setSorter((ViewerSorter)new ParentSorter());
        }
        viewer.getControl().setRedraw(true);
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.insertBefore("group.properties", (IContributionItem)new Separator(GROUP_FILTERING));
        this.fActionGroup.fillActionBars(site.getActionBars());
        menuManager.appendToGroup(GROUP_FILTERING, (IAction)this.fFilterDialogAction);
    }

    void setGrouping(int grouping) {
        this.fCurrentGrouping = grouping;
        StructuredViewer viewer = this.getViewer();
        LevelTreeContentProvider cp = (LevelTreeContentProvider)viewer.getContentProvider();
        cp.setLevel(grouping);
        this.updateGroupingActions();
        this.getSettings().put("org.eclipse.jdt.search.resultpage.grouping", this.fCurrentGrouping);
        this.getViewPart().updateLabel();
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException e) {
            this.fCurrentSortOrder = 1;
        }
        try {
            this.fCurrentGrouping = this.getSettings().getInt("org.eclipse.jdt.search.resultpage.grouping");
        }
        catch (NumberFormatException e) {
            this.fCurrentGrouping = 3;
        }
        String encodedFilters = this.getSettings().get(KEY_FILTERS);
        this.restoreFilters(encodedFilters);
        this.fLimitElements = !FALSE.equals(this.getSettings().get(KEY_LIMIT_ENABLED));
        try {
            this.fElementLimit = this.getSettings().getInt(KEY_LIMIT);
        }
        catch (NumberFormatException e) {
            this.fElementLimit = 1000;
        }
        if (memento != null) {
            Integer value = memento.getInteger("org.eclipse.jdt.search.resultpage.grouping");
            if (value != null) {
                this.fCurrentGrouping = value;
            }
            if ((value = memento.getInteger(KEY_SORTING)) != null) {
                this.fCurrentSortOrder = value;
            }
            encodedFilters = memento.getString(KEY_FILTERS);
            this.restoreFilters(encodedFilters);
            this.fLimitElements = !FALSE.equals(memento.getString(KEY_LIMIT_ENABLED));
            value = memento.getInteger(KEY_LIMIT);
            if (value != null) {
                this.fElementLimit = value;
            }
        }
    }

    private void restoreFilters(String encodedFilters) {
        if (encodedFilters != null) {
            this.fMatchFilters.clear();
            String[] decodedFilters = this.decodeFiltersString(encodedFilters);
            for (int i = 0; i < decodedFilters.length; ++i) {
                MatchFilter filter = this.findMatchFilter(decodedFilters[i]);
                if (filter == null) continue;
                this.fMatchFilters.add(filter);
            }
        }
        this.updateFilterActions();
    }

    private MatchFilter findMatchFilter(String id) {
        MatchFilter[] allFilters = MatchFilter.allFilters();
        for (int i = 0; i < allFilters.length; ++i) {
            if (!allFilters[i].getID().equals(id)) continue;
            return allFilters[i];
        }
        return null;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger("org.eclipse.jdt.search.resultpage.grouping", this.fCurrentGrouping);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        memento.putString(KEY_FILTERS, this.encodeFilters());
        if (this.fLimitElements) {
            memento.putString(KEY_LIMIT_ENABLED, TRUE);
        } else {
            memento.putString(KEY_LIMIT_ENABLED, FALSE);
        }
        memento.putInteger(KEY_LIMIT, this.getElementLimit());
    }

    void addMatchFilter(MatchFilter filter) {
        this.fMatchFilters.add(filter);
        this.filtersChanged();
    }

    void enableLimit(boolean enable) {
        this.fLimitElements = enable;
        if (this.fLimitElements) {
            this.getSettings().put("org.eclipse.jdt.search.resultpage.grouping", TRUE);
        } else {
            this.getSettings().put(KEY_LIMIT_ENABLED, FALSE);
        }
        this.limitChanged();
    }

    private void limitChanged() {
        this.getViewer().refresh();
        this.getViewPart().updateLabel();
    }

    boolean limitElements() {
        return this.fLimitElements;
    }

    void removeMatchFilter(MatchFilter filter) {
        this.fMatchFilters.remove(filter);
        this.filtersChanged();
    }

    private void filtersChanged() {
        StructuredViewer viewer = this.getViewer();
        JavaSearchContentProvider cp = (JavaSearchContentProvider)viewer.getContentProvider();
        cp.filtersChanged(this.getMatchFilters());
        this.updateFilterActions();
        this.getViewPart().updateLabel();
        this.getSettings().put(KEY_FILTERS, this.encodeFilters());
    }

    private void updateFilterActions() {
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        for (int i = 0; i < this.fFilterActions.length; ++i) {
            this.fFilterActions[i].updateCheckState();
        }
        this.getSite().getActionBars().updateActionBars();
        menu.updateAll(true);
    }

    private String encodeFilters() {
        StringBuffer buf = new StringBuffer();
        MatchFilter[] enabledFilters = this.getMatchFilters();
        buf.append(enabledFilters.length);
        for (int i = 0; i < enabledFilters.length; ++i) {
            buf.append(';');
            buf.append(enabledFilters[i].getID());
        }
        return buf.toString();
    }

    private String[] decodeFiltersString(String encodedString) {
        StringTokenizer tokenizer = new StringTokenizer(encodedString, ";");
        int count = Integer.valueOf(tokenizer.nextToken());
        String[] ids = new String[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = tokenizer.nextToken();
        }
        return ids;
    }

    boolean hasMatchFilter(MatchFilter filter) {
        return this.fMatchFilters.contains(filter);
    }

    MatchFilter[] getMatchFilters() {
        MatchFilter[] filters = new MatchFilter[this.fMatchFilters.size()];
        return this.fMatchFilters.toArray(filters);
    }

    public int getDisplayedMatchCount(Object element) {
        if (this.getMatchFilters().length == 0) {
            return super.getDisplayedMatchCount(element);
        }
        Match[] matches = super.getDisplayedMatches(element);
        int count = 0;
        for (int i = 0; i < matches.length; ++i) {
            if (this.isFiltered(matches[i])) continue;
            ++count;
        }
        return count;
    }

    public Match[] getDisplayedMatches(Object element) {
        if (this.getMatchFilters().length == 0) {
            return super.getDisplayedMatches(element);
        }
        Match[] matches = super.getDisplayedMatches(element);
        int count = 0;
        for (int i = 0; i < matches.length; ++i) {
            if (this.isFiltered(matches[i])) {
                matches[i] = null;
                continue;
            }
            ++count;
        }
        Match[] filteredMatches = new Match[count];
        int writeIndex = 0;
        for (int i = 0; i < matches.length; ++i) {
            if (matches[i] == null) continue;
            filteredMatches[writeIndex++] = matches[i];
        }
        return filteredMatches;
    }

    private boolean isFiltered(Match match) {
        MatchFilter[] filters = this.getMatchFilters();
        for (int j = 0; j < filters.length; ++j) {
            if (!(match instanceof JavaElementMatch) || !filters[j].filters((JavaElementMatch)match)) continue;
            return true;
        }
        return false;
    }

    public void setInput(ISearchResult search, Object viewState) {
        this.updateFilterEnablement((JavaSearchResult)search);
        super.setInput(search, viewState);
    }

    private void updateFilterEnablement(JavaSearchResult result) {
        int i;
        IActionBars bars = this.getSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        for (i = 0; i < this.fFilterActions.length; ++i) {
            menu.remove(this.fFilterActions[i].getId());
        }
        for (i = this.fFilterActions.length - 1; i >= 0; --i) {
            if (!this.shouldEnable(result, this.fFilterActions[i])) continue;
            menu.prependToGroup(GROUP_FILTERING, (IAction)this.fFilterActions[i]);
        }
        menu.updateAll(true);
        bars.updateActionBars();
    }

    private boolean shouldEnable(JavaSearchResult result, FilterAction filterAction) {
        if (result == null) {
            return false;
        }
        JavaSearchQuery query = (JavaSearchQuery)result.getQuery();
        if (query == null) {
            return false;
        }
        return filterAction.getFilter().isApplicable(query);
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery());
        }
        return false;
    }

    public String getLabel() {
        String label = super.getLabel();
        int matchFilterCount = this.getMatchFiltersCount();
        int filteredMatchCount = this.getFilteredMatchCount();
        if (this.getInput() != null && (matchFilterCount > 0 || filteredMatchCount < this.getInput().getMatchCount())) {
            if (this.isQueryRunning()) {
                String message = SearchMessages.getString("JavaSearchResultPage.filtered.message");
                return MessageFormat.format(message, label);
            }
            String message = SearchMessages.getString("JavaSearchResultPage.filteredWithCount.message");
            return MessageFormat.format(message, label, new Integer(filteredMatchCount));
        }
        return label;
    }

    private int getMatchFiltersCount() {
        MatchFilter[] filters = this.getMatchFilters();
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return 0;
        }
        int filterCount = 0;
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].isApplicable((JavaSearchQuery)result.getQuery())) continue;
            ++filterCount;
        }
        return filterCount;
    }

    private int getFilteredMatchCount() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider tp = (ITreeContentProvider)viewer.getContentProvider();
            return this.getMatchCount(tp, this.getRootElements((TreeViewer)this.getViewer()));
        }
        return this.getMatchCount((TableViewer)viewer);
    }

    private Object[] getRootElements(TreeViewer viewer) {
        Tree t = viewer.getTree();
        TreeItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = roots[i].getData();
        }
        return elements;
    }

    private Object[] getRootElements(TableViewer viewer) {
        Table t = viewer.getTable();
        TableItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = roots[i].getData();
        }
        return elements;
    }

    private int getMatchCount(ITreeContentProvider cp, Object[] elements) {
        int count = 0;
        for (int j = 0; j < elements.length; ++j) {
            count += this.getDisplayedMatchCount(elements[j]);
            Object[] children = cp.getChildren(elements[j]);
            count += this.getMatchCount(cp, children);
        }
        return count;
    }

    private int getMatchCount(TableViewer viewer) {
        Object[] elements = this.getRootElements(viewer);
        int count = 0;
        for (int i = 0; i < elements.length; ++i) {
            count += this.getDisplayedMatchCount(elements[i]);
        }
        return count;
    }

    public Object getAdapter(Class adapter) {
        if ((class$org$eclipse$ui$part$IShowInTargetList == null ? (class$org$eclipse$ui$part$IShowInTargetList = JavaSearchResultPage.class$("org.eclipse.ui.part.IShowInTargetList")) : class$org$eclipse$ui$part$IShowInTargetList).equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if ((firstElement instanceof ICompilationUnit || firstElement instanceof IClassFile || firstElement instanceof IMember) && this.getDisplayedMatchCount(firstElement) == 0) {
            this.fActionGroup.handleOpen(event);
            return;
        }
        super.handleOpen(event);
    }

    public void setFilters(MatchFilter[] enabledFilters) {
        this.fMatchFilters.clear();
        for (int i = 0; i < enabledFilters.length; ++i) {
            this.fMatchFilters.add(enabledFilters[i]);
        }
        this.filtersChanged();
    }

    void setElementLimit(int elementLimit) {
        this.fElementLimit = elementLimit;
        this.getSettings().put(KEY_LIMIT, elementLimit);
        this.limitChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

