/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResultCollector;
import org.eclipse.jdt.internal.ui.search.PrettySignature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class NLSSearchOperation
extends WorkspaceModifyOperation {
    private IWorkspace fWorkspace;
    private IJavaElement fElementPattern;
    private int fLimitTo;
    private String fStringPattern;
    private int fSearchFor;
    private IJavaSearchScope fScope;
    private String fScopeDescription;
    private NLSSearchResultCollector fCollector;

    protected NLSSearchOperation(IWorkspace workspace, int limitTo, IJavaSearchScope scope, String scopeDescription, NLSSearchResultCollector collector) {
        super(null);
        this.fWorkspace = workspace;
        this.fLimitTo = limitTo;
        this.fScope = scope;
        this.fScopeDescription = scopeDescription;
        this.fCollector = collector;
        this.fCollector.setOperation(this);
    }

    public NLSSearchOperation(IWorkspace workspace, IJavaElement pattern, int limitTo, IJavaSearchScope scope, String scopeDescription, NLSSearchResultCollector collector) {
        this(workspace, limitTo, scope, scopeDescription, collector);
        this.fElementPattern = pattern;
    }

    public NLSSearchOperation(IWorkspace workspace, String pattern, int searchFor, int limitTo, IJavaSearchScope scope, String scopeDescription, NLSSearchResultCollector collector) {
        this(workspace, limitTo, scope, scopeDescription, collector);
        this.fStringPattern = pattern;
        this.fSearchFor = searchFor;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        this.fCollector.setProgressMonitor(monitor);
        SearchEngine engine = new SearchEngine();
        if (this.fElementPattern != null) {
            engine.search(this.fWorkspace, this.fElementPattern, this.fLimitTo, this.fScope, (IJavaSearchResultCollector)this.fCollector);
        } else {
            engine.search(this.fWorkspace, this.fStringPattern, this.fSearchFor, this.fLimitTo, this.fScope, (IJavaSearchResultCollector)this.fCollector);
        }
    }

    String getSingularLabel() {
        Object[] args = new String[]{this.getDescriptionPattern(), this.fScopeDescription};
        return NLSSearchMessages.getFormattedString("SearchOperation.singularLabelPostfix", args);
    }

    String getPluralLabelPattern() {
        Object[] args = new String[]{this.getDescriptionPattern(), "{0}", this.fScopeDescription};
        return NLSSearchMessages.getFormattedString("SearchOperation.pluralLabelPatternPostfix", args);
    }

    private String getDescriptionPattern() {
        if (this.fElementPattern != null) {
            if (this.fLimitTo == 2 && this.fElementPattern.getElementType() == 9) {
                return PrettySignature.getUnqualifiedMethodSignature((IMethod)this.fElementPattern);
            }
            return this.fElementPattern.getElementName();
        }
        return this.fStringPattern;
    }

    ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }
}

