/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

class OpenLocationAction
extends SelectionDispatchAction {
    private CallHierarchyViewPart fPart;

    public OpenLocationAction(CallHierarchyViewPart part, IWorkbenchSite site) {
        super(site);
        this.fPart = part;
        this.setText(CallHierarchyMessages.getString("OpenLocationAction.label"));
        this.setToolTipText(CallHierarchyMessages.getString("OpenLocationAction.tooltip"));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof MethodWrapper || element instanceof CallLocation) continue;
            return false;
        }
        return true;
    }

    public ISelection getSelection() {
        return this.fPart.getSelection();
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.getFirstElement());
    }

    public void run(Object element) {
        CallHierarchyUI.openInEditor(element, this.getShell(), this.getDialogTitle());
    }

    private String getDialogTitle() {
        return CallHierarchyMessages.getString("OpenLocationAction.error.title");
    }
}

