/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocVMInstallListener;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIException;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaDocLocations {
    public static final String ARCHIVE_PREFIX = "jar:file:/";
    private static final String PREF_JAVADOCLOCATIONS = "org.eclipse.jdt.ui.javadoclocations";
    private static final String NODE_ROOT = "javadoclocation";
    private static final String NODE_ENTRY = "location_01";
    private static final String NODE_PATH = "path";
    private static final String NODE_URL = "url";
    private static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    private static Map fgJavadocLocations = null;
    private static JavaDocVMInstallListener fgVMInstallListener = null;

    private static Map getJavaDocLocations() {
        if (fgJavadocLocations == null) {
            fgJavadocLocations = new HashMap();
            try {
                JavaDocLocations.initJavadocLocations();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return fgJavadocLocations;
    }

    private static IPath canonicalizedPath(IPath externalPath) {
        if (externalPath == null || IS_CASE_SENSITIVE) {
            return externalPath;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        try {
            return new Path(externalPath.toFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            return externalPath;
        }
    }

    private static boolean setJavadocBaseLocation(IPath path, URL url, boolean save) {
        boolean isModified;
        Object old;
        if (url == null) {
            old = JavaDocLocations.getJavaDocLocations().remove(path);
            isModified = old != null;
        } else {
            old = JavaDocLocations.getJavaDocLocations().put(path, url);
            boolean bl = isModified = old == null || !url.toExternalForm().equals(((URL)old).toExternalForm());
        }
        if (save && isModified) {
            try {
                JavaDocLocations.storeLocations();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return isModified;
    }

    private static URL getJavadocBaseLocation(IPath path) {
        return (URL)JavaDocLocations.getJavaDocLocations().get(path);
    }

    public static void setLibraryJavadocLocation(IPath archivePath, URL url) {
        JavaDocLocations.setJavadocBaseLocation(JavaDocLocations.canonicalizedPath(archivePath), url, true);
    }

    public static void setLibraryJavadocLocations(IPath[] archivePaths, URL[] urls) {
        boolean needsSave = false;
        for (int i = urls.length - 1; i >= 0; --i) {
            if (!JavaDocLocations.setJavadocBaseLocation(JavaDocLocations.canonicalizedPath(archivePaths[i]), urls[i], false)) continue;
            needsSave = true;
        }
        if (needsSave) {
            try {
                JavaDocLocations.storeLocations();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        JavaDocLocations.setJavadocBaseLocation(project.getProject().getFullPath(), url, true);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        return JavaDocLocations.getJavadocBaseLocation(project.getProject().getFullPath());
    }

    public static URL getLibraryJavadocLocation(IPath archivePath) {
        return JavaDocLocations.getJavadocBaseLocation(JavaDocLocations.canonicalizedPath(archivePath));
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        if (element.getElementType() == 2) {
            return JavaDocLocations.getProjectJavadocLocation((IJavaProject)element);
        }
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            return JavaDocLocations.getLibraryJavadocLocation(root.getPath());
        }
        return JavaDocLocations.getProjectJavadocLocation(root.getJavaProject());
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void storeLocations() throws CoreException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        try {
            String val;
            JavaDocLocations.saveToStream(fgJavadocLocations, stream);
            byte[] bytes = stream.toByteArray();
            try {
                val = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                val = new String(bytes);
            }
            PreferenceConstants.getPreferenceStore().setValue(PREF_JAVADOCLOCATIONS, val);
            JavaPlugin.getDefault().savePluginPreferences();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static boolean loadOldForCompatibility() {
        block23: {
            block22: {
                try {
                    String STORE_FILE = "javadoclocations.xml";
                    File file = JavaPlugin.getDefault().getStateLocation().append("javadoclocations.xml").toFile();
                    if (!file.exists()) break block22;
                    FileReader reader = null;
                    reader = new FileReader(file);
                    JavaDocLocations.loadFromStream(new InputSource(reader));
                    JavaDocLocations.storeLocations();
                    file.delete();
                    boolean bl = true;
                    Object var5_8 = null;
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    {
                        return bl;
                        catch (IOException e) {
                            JavaPlugin.log(e);
                            Object var5_9 = null;
                            try {
                                if (reader != null) {
                                    ((Reader)reader).close();
                                }
                                break block22;
                            }
                            catch (IOException e2) {}
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        try {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
            try {
                QualifiedName QUALIFIED_NAME = new QualifiedName("org.eclipse.jdt.ui", "jdoclocation");
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                String xmlString = root.getPersistentProperty(QUALIFIED_NAME);
                if (xmlString == null) break block23;
                StringReader reader = new StringReader(xmlString);
                try {
                    JavaDocLocations.loadFromStream(new InputSource(reader));
                    JavaDocLocations.storeLocations();
                    root.setPersistentProperty(QUALIFIED_NAME, null);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadFromPreferences() throws CoreException {
        String string = PreferenceConstants.getPreferenceStore().getString(PREF_JAVADOCLOCATIONS);
        if (string != null && string.length() > 0) {
            byte[] bytes;
            try {
                bytes = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = string.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                JavaDocLocations.loadFromStream(new InputSource(is));
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private static void saveToStream(Map locations, OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(NODE_ROOT);
            document.appendChild(rootElement);
            Iterator iter = locations.keySet().iterator();
            while (iter.hasNext()) {
                IPath path = (IPath)iter.next();
                URL url = JavaDocLocations.getJavadocBaseLocation(path);
                Element varElement = document.createElement(NODE_ENTRY);
                varElement.setAttribute(NODE_PATH, path.toString());
                varElement.setAttribute(NODE_URL, url.toExternalForm());
                rootElement.appendChild(varElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.serializeXML"));
        }
        catch (ParserConfigurationException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.serializeXML"));
        }
    }

    private static void loadFromStream(InputSource inputSource) throws CoreException {
        Element cpElement;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            cpElement = parser.parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
        }
        catch (ParserConfigurationException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
        }
        catch (IOException e) {
            throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
        }
        if (cpElement == null) {
            return;
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
            return;
        }
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element element;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type != 1 || !(element = (Element)node).getNodeName().equalsIgnoreCase(NODE_ENTRY)) continue;
            String varPath = element.getAttribute(NODE_PATH);
            String varURL = element.getAttribute(NODE_URL);
            try {
                JavaDocLocations.setJavadocBaseLocation((IPath)new Path(varPath), new URL(varURL), false);
                continue;
            }
            catch (MalformedURLException e) {
                throw JavaDocLocations.createException(e, CorextMessages.getString("JavaDocLocations.error.readXML"));
            }
        }
    }

    public static void shutdownJavadocLocations() {
        if (fgVMInstallListener == null) {
            return;
        }
        fgVMInstallListener.remove();
        fgVMInstallListener = null;
        fgJavadocLocations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initJavadocLocations() throws CoreException {
        try {
            boolean res = JavaDocLocations.loadFromPreferences();
            if (!res) {
                JavaDocLocations.loadOldForCompatibility();
            }
        }
        finally {
            fgVMInstallListener = new JavaDocVMInstallListener();
            fgVMInstallListener.init();
        }
    }

    public static URL getJavadocLocation(IJavaElement element, boolean includeMemberReference) throws JavaModelException {
        URL baseLocation = JavaDocLocations.getJavadocBaseLocation(element);
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer pathBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            pathBuffer.append('/');
        }
        switch (element.getElementType()) {
            case 4: {
                JavaDocLocations.appendPackageSummaryPath((IPackageFragment)element, pathBuffer);
                break;
            }
            case 2: 
            case 3: {
                JavaDocLocations.appendIndexPath(pathBuffer);
                break;
            }
            case 12: {
                element = element.getParent();
            }
            case 5: {
                IType mainType = ((ICompilationUnit)element).findPrimaryType();
                if (mainType == null) {
                    return null;
                }
                JavaDocLocations.appendTypePath(mainType, pathBuffer);
                break;
            }
            case 6: {
                JavaDocLocations.appendTypePath(((IClassFile)element).getType(), pathBuffer);
                break;
            }
            case 7: {
                JavaDocLocations.appendTypePath((IType)element, pathBuffer);
                break;
            }
            case 8: {
                IField field = (IField)element;
                JavaDocLocations.appendTypePath(field.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendFieldReference(field, pathBuffer);
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                JavaDocLocations.appendTypePath(method.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendMethodReference(method, pathBuffer);
                break;
            }
            case 10: {
                JavaDocLocations.appendTypePath(((IMember)element).getDeclaringType(), pathBuffer);
                break;
            }
            case 13: {
                IImportDeclaration decl = (IImportDeclaration)element;
                if (decl.isOnDemand()) {
                    IJavaElement cont = JavaModelUtil.findTypeContainer(element.getJavaProject(), Signature.getQualifier((String)decl.getElementName()));
                    if (cont instanceof IType) {
                        JavaDocLocations.appendTypePath((IType)cont, pathBuffer);
                        break;
                    }
                    if (!(cont instanceof IPackageFragment)) break;
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)cont, pathBuffer);
                    break;
                }
                IType imp = element.getJavaProject().findType(decl.getElementName());
                JavaDocLocations.appendTypePath(imp, pathBuffer);
                break;
            }
            case 11: {
                IJavaElement pack = element.getAncestor(4);
                if (pack != null) {
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)pack, pathBuffer);
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        try {
            return new URL(pathBuffer.toString());
        }
        catch (MalformedURLException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment pack, StringBuffer buf) {
        String packPath = pack.getElementName().replace('.', '/');
        buf.append(packPath);
        buf.append("/package-summary.html");
    }

    private static void appendIndexPath(StringBuffer buf) {
        buf.append("index.html");
    }

    private static void appendTypePath(IType type, StringBuffer buf) {
        IPackageFragment pack = type.getPackageFragment();
        String packPath = pack.getElementName().replace('.', '/');
        String typePath = JavaModelUtil.getTypeQualifiedName(type);
        buf.append(packPath);
        buf.append('/');
        buf.append(typePath);
        buf.append(".html");
    }

    private static void appendFieldReference(IField field, StringBuffer buf) {
        buf.append('#');
        buf.append(field.getElementName());
    }

    private static void appendMethodReference(IMethod meth, StringBuffer buf) throws JavaModelException {
        buf.append('#');
        buf.append(meth.getElementName());
        buf.append('(');
        String[] params = meth.getParameterTypes();
        IType declaringType = meth.getDeclaringType();
        for (int i = 0; i < params.length; ++i) {
            String curr;
            String fullName;
            if (i != 0) {
                buf.append(", ");
            }
            if ((fullName = JavaModelUtil.getResolvedTypeName(curr = params[i], declaringType)) == null) continue;
            buf.append(fullName);
            for (int dim = Signature.getArrayCount((String)curr); dim > 0; --dim) {
                buf.append("[]");
            }
        }
        buf.append(')');
    }
}

