/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.IImplementorFinder;
import org.eclipse.jdt.internal.corext.callhierarchy.JavaImplementorFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class Implementors {
    private static IImplementorFinder[] IMPLEMENTOR_FINDERS = new IImplementorFinder[]{new JavaImplementorFinder()};
    private static Implementors fgInstance;

    public static Implementors getInstance() {
        if (fgInstance == null) {
            fgInstance = new Implementors();
        }
        return fgInstance;
    }

    public IJavaElement[] searchForImplementors(IJavaElement[] elements, IProgressMonitor progressMonitor) {
        if (elements != null && elements.length > 0) {
            IJavaElement element = elements[0];
            try {
                IMember member;
                IType type;
                if (element instanceof IMember && (type = (member = (IMember)element).getDeclaringType()).isInterface()) {
                    IType[] implementingTypes = this.findImplementingTypes(type, progressMonitor);
                    if (member.getElementType() == 9) {
                        return this.findMethods((IMethod)member, implementingTypes, progressMonitor);
                    }
                    return implementingTypes;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    public IJavaElement[] searchForInterfaces(IJavaElement[] elements, IProgressMonitor progressMonitor) {
        IJavaElement element;
        if (elements != null && elements.length > 0 && (element = elements[0]) instanceof IMember) {
            IMember member = (IMember)element;
            IType type = member.getDeclaringType();
            IType[] implementingTypes = this.findInterfaces(type, progressMonitor);
            if (!progressMonitor.isCanceled()) {
                if (member.getElementType() == 9) {
                    return this.findMethods((IMethod)member, implementingTypes, progressMonitor);
                }
                return implementingTypes;
            }
        }
        return null;
    }

    private IImplementorFinder[] getImplementorFinders() {
        return IMPLEMENTOR_FINDERS;
    }

    private IType[] findImplementingTypes(IType type, IProgressMonitor progressMonitor) throws JavaModelException {
        ArrayList implementingTypes = new ArrayList();
        IImplementorFinder[] finders = this.getImplementorFinders();
        for (int i = 0; i < finders.length && !progressMonitor.isCanceled(); ++i) {
            Collection types = finders[i].findImplementingTypes(type, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10, 2));
            if (types == null) continue;
            implementingTypes.addAll(types);
        }
        return implementingTypes.toArray(new IType[implementingTypes.size()]);
    }

    private IType[] findInterfaces(IType type, IProgressMonitor progressMonitor) {
        ArrayList interfaces = new ArrayList();
        IImplementorFinder[] finders = this.getImplementorFinders();
        for (int i = 0; i < finders.length && !progressMonitor.isCanceled(); ++i) {
            Collection types = finders[i].findInterfaces(type, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10, 2));
            if (types == null) continue;
            interfaces.addAll(types);
        }
        return interfaces.toArray(new IType[interfaces.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IJavaElement[] findMethods(IMethod method, IType[] types, IProgressMonitor progressMonitor) {
        ArrayList<IMethod> foundMethods = new ArrayList<IMethod>();
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 10, 2);
        subProgressMonitor.beginTask("", types.length);
        try {
            for (int i = 0; i < types.length; ++i) {
                IType type = types[i];
                IMethod[] methods = type.findMethods(method);
                if (methods != null) {
                    for (int j = 0; j < methods.length; ++j) {
                        foundMethods.add(methods[j]);
                    }
                }
                subProgressMonitor.worked(1);
            }
        }
        finally {
            subProgressMonitor.done();
        }
        return foundMethods.toArray(new IJavaElement[foundMethods.size()]);
    }
}

